<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This value is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This value is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This value is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This value is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This value should be a valid expression.' => 'This value should be a valid expression.',
    'This value is not a valid CSS color.' => 'This value is not a valid CSS color.',
    'This value is not a valid CIDR notation.' => 'This value is not a valid CIDR notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'The value of the netmask should be between {{ min }} and {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.',
    'The password strength is too low. Please use a stronger password.' => 'The password strength is too low. Please use a stronger password.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'This value contains characters that are not allowed by the current restriction-level.',
    'Using invisible characters is not allowed.' => 'Using invisible characters is not allowed.',
    'Mixing numbers from different scripts is not allowed.' => 'Mixing numbers from different scripts is not allowed.',
    'Using hidden overlay characters is not allowed.' => 'Using hidden overlay characters is not allowed.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.',
    'This value is not a valid MAC address.' => 'This value is not a valid MAC address.',
    'This URL is missing a top-level domain.' => 'This URL is missing a top-level domain.',
    'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.' => 'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.',
    'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.' => 'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.',
    'This value does not represent a valid week in the ISO 8601 format.' => 'This value does not represent a valid week in the ISO 8601 format.',
    'This value is not a valid week.' => 'This value is not a valid week.',
    'This value should not be before week "{{ min }}".' => 'This value should not be before week "{{ min }}".',
    'This value should not be after week "{{ max }}".' => 'This value should not be after week "{{ max }}".',
    'This value is not a valid Twig template.' => 'This value is not a valid Twig template.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Too many failed login attempts, please try again in %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Too many failed login attempts, please try again in %minutes% minutes.',
  ),
  'messages' => 
  array (
    'shopware.installer.header_title' => 'Setup',
    'shopware.installer.menuitem_welcome' => 'Start',
    'shopware.installer.menuitem_requirements' => 'System requirements',
    'shopware.installer.menuitem_database-configuration' => 'Database configuration',
    'shopware.installer.menuitem_database-import' => 'Installation',
    'shopware.installer.menuitem_edition' => 'Shopware licence',
    'shopware.installer.menuitem_configuration' => 'Configuration',
    'shopware.installer.menuitem_finish' => 'Finish',
    'shopware.installer.menuitem_license' => 'GTC',
    'shopware.installer.license_incorrect' => 'The licence key you have entered does not appear to be valid.',
    'shopware.installer.license_does_not_match' => 'The licence key you have entered does not match any commercial Shopware version.',
    'shopware.installer.license_domain_error' => 'The licence key you have entered is not valid for the domain: ',
    'shopware.installer.version_text' => 'Version:',
    'shopware.installer.back' => 'Back',
    'shopware.installer.forward' => 'Next',
    'shopware.installer.start' => 'Start',
    'shopware.installer.start_installation' => 'Start installation',
    'shopware.installer.select_language_cs' => 'Czech',
    'shopware.installer.select_language_da-DK' => 'Danish',
    'shopware.installer.select_language_de' => 'German',
    'shopware.installer.select_language_en-US' => 'English (United States of America)',
    'shopware.installer.select_language_en' => 'English (United Kingdom)',
    'shopware.installer.select_language_es-ES' => 'Spanish',
    'shopware.installer.select_language_fr' => 'French',
    'shopware.installer.select_language_it' => 'Italian',
    'shopware.installer.select_language_nl' => 'Dutch',
    'shopware.installer.select_language_no' => 'Norwegian',
    'shopware.installer.select_language_pl' => 'Polish',
    'shopware.installer.select_language_pt-PT' => 'Portuguese',
    'shopware.installer.select_language_sv-SE' => 'Swedish',
    'shopware.installer.select_country_jam' => 'Jamaica',
    'shopware.installer.select_country_mmr' => 'Myanmar',
    'shopware.installer.select_country_pan' => 'Panama',
    'shopware.installer.select_country_aus' => 'Australia',
    'shopware.installer.select_country_jpn' => 'Japan',
    'shopware.installer.select_country_dnk' => 'Denmark',
    'shopware.installer.select_country_rou' => 'Romania',
    'shopware.installer.select_country_bra' => 'Brazil',
    'shopware.installer.select_country_fin' => 'Finland',
    'shopware.installer.select_country_isr' => 'Israel',
    'shopware.installer.select_country_bel' => 'Belgium',
    'shopware.installer.select_country_usa' => 'United States of America',
    'shopware.installer.select_country_lie' => 'Liechtenstein',
    'shopware.installer.select_country_pol' => 'Poland',
    'shopware.installer.select_country_nam' => 'Namibia',
    'shopware.installer.select_country_aut' => 'Austria',
    'shopware.installer.select_country_gbr' => 'United Kingdom',
    'shopware.installer.select_country_cze' => 'Czech Republic',
    'shopware.installer.select_country_are' => 'United Arab Emirates',
    'shopware.installer.select_country_isl' => 'Iceland',
    'shopware.installer.select_country_can' => 'Canada',
    'shopware.installer.select_country_grc' => 'Greece',
    'shopware.installer.select_country_irl' => 'Ireland',
    'shopware.installer.select_country_che' => 'Switzerland',
    'shopware.installer.select_country_fra' => 'France',
    'shopware.installer.select_country_swe' => 'Sweden',
    'shopware.installer.select_country_svk' => 'Slovakia',
    'shopware.installer.select_country_deu' => 'Germany',
    'shopware.installer.select_country_lux' => 'Luxembourg',
    'shopware.installer.select_country_ita' => 'Italy',
    'shopware.installer.select_country_hun' => 'Hungary',
    'shopware.installer.select_country_nor' => 'Norway',
    'shopware.installer.select_country_nld' => 'Netherlands',
    'shopware.installer.select_country_prt' => 'Portugal',
    'shopware.installer.select_country_tur' => 'Turkey',
    'shopware.installer.select_country_esp' => 'Spain',
    'shopware.installer.select_country_bgr' => 'Bulgaria',
    'shopware.installer.select_country_est' => 'Estonia',
    'shopware.installer.select_country_hrv' => 'Croatia',
    'shopware.installer.select_country_lva' => 'Latvia',
    'shopware.installer.select_country_ltu' => 'Lithuania',
    'shopware.installer.select_country_mlt' => 'Malta',
    'shopware.installer.select_country_svn' => 'Slovenia',
    'shopware.installer.select_country_cyp' => 'Cyprus',
    'shopware.installer.select_country_afg' => 'Afghanistan',
    'shopware.installer.select_country_ala' => 'Åland',
    'shopware.installer.select_country_alb' => 'Albania',
    'shopware.installer.select_country_dza' => 'Algeria',
    'shopware.installer.select_country_asm' => 'American Samoa',
    'shopware.installer.select_country_and' => 'Andorra',
    'shopware.installer.select_country_ago' => 'Angola',
    'shopware.installer.select_country_aia' => 'Anguilla',
    'shopware.installer.select_country_ata' => 'Antarctica',
    'shopware.installer.select_country_atg' => 'Antigua and Barbuda',
    'shopware.installer.select_country_arg' => 'Argentina',
    'shopware.installer.select_country_arm' => 'Armenien',
    'shopware.installer.select_country_abw' => 'Aruba',
    'shopware.installer.select_country_aze' => 'Azerbaijan',
    'shopware.installer.select_country_bhs' => 'Bahamas',
    'shopware.installer.select_country_bhr' => 'Bahrain',
    'shopware.installer.select_country_bgd' => 'Bangladesh',
    'shopware.installer.select_country_brb' => 'Barbados',
    'shopware.installer.select_country_blr' => 'Belarus',
    'shopware.installer.select_country_blz' => 'Belize',
    'shopware.installer.select_country_ben' => 'Benin',
    'shopware.installer.select_country_bmu' => 'Bermuda',
    'shopware.installer.select_country_btn' => 'Bhutan',
    'shopware.installer.select_country_bol' => 'Bolivia',
    'shopware.installer.select_country_bes' => 'Bonaire, Sint Eustatius and Saba',
    'shopware.installer.select_country_bih' => 'Bosnia and Herzegovina',
    'shopware.installer.select_country_bwa' => 'Botswana',
    'shopware.installer.select_country_bvt' => 'Bouvet Island',
    'shopware.installer.select_country_iot' => 'British Indian Ocean Territory',
    'shopware.installer.select_country_umi' => 'United States Minor Outlying Islands',
    'shopware.installer.select_country_vgb' => 'Virgin Islands (British)',
    'shopware.installer.select_country_vir' => 'Virgin Islands (U.S.)',
    'shopware.installer.select_country_brn' => 'Brunei Darussalam',
    'shopware.installer.select_country_bfa' => 'Burkina Faso',
    'shopware.installer.select_country_bdi' => 'Burundi',
    'shopware.installer.select_country_khm' => 'Cambodia',
    'shopware.installer.select_country_cmr' => 'Cameroon',
    'shopware.installer.select_country_cpv' => 'Cabo Verde',
    'shopware.installer.select_country_cym' => 'Cayman Islands',
    'shopware.installer.select_country_caf' => 'Central African Republic',
    'shopware.installer.select_country_tcd' => 'Chad',
    'shopware.installer.select_country_chl' => 'Chile',
    'shopware.installer.select_country_chn' => 'China',
    'shopware.installer.select_country_cxr' => 'Christmas Island',
    'shopware.installer.select_country_cck' => 'Cocos (Keeling) Islands',
    'shopware.installer.select_country_col' => 'Columbia',
    'shopware.installer.select_country_com' => 'Comoros',
    'shopware.installer.select_country_cog' => 'Congo',
    'shopware.installer.select_country_cod' => 'Congo (the Democratic Republic of the)',
    'shopware.installer.select_country_cok' => 'Cook Islands',
    'shopware.installer.select_country_cri' => 'Costa Rica',
    'shopware.installer.select_country_cub' => 'Cuba',
    'shopware.installer.select_country_cuw' => 'Curaçao',
    'shopware.installer.select_country_dji' => 'Djibouti',
    'shopware.installer.select_country_dma' => 'Dominica',
    'shopware.installer.select_country_dom' => 'Dominican Republic',
    'shopware.installer.select_country_ecu' => 'Ecuador',
    'shopware.installer.select_country_egy' => 'Egypt',
    'shopware.installer.select_country_slv' => 'El Salvador',
    'shopware.installer.select_country_gnq' => 'Equatorial Guinea',
    'shopware.installer.select_country_eri' => 'Eritrea',
    'shopware.installer.select_country_eth' => 'Ethiopia',
    'shopware.installer.select_country_flk' => 'Falkland Islands',
    'shopware.installer.select_country_fro' => 'Faroe Islands',
    'shopware.installer.select_country_fji' => 'Fiji',
    'shopware.installer.select_country_guf' => 'French Guiana',
    'shopware.installer.select_country_pyf' => 'French Polynesia',
    'shopware.installer.select_country_atf' => 'French Southern Territories',
    'shopware.installer.select_country_gab' => 'Gabon',
    'shopware.installer.select_country_gmb' => 'Gambia',
    'shopware.installer.select_country_geo' => 'Georgia',
    'shopware.installer.select_country_gha' => 'Ghana',
    'shopware.installer.select_country_gib' => 'Gibraltar',
    'shopware.installer.select_country_grl' => 'Greenland',
    'shopware.installer.select_country_grd' => 'Grenada',
    'shopware.installer.select_country_glp' => 'Guadeloupe',
    'shopware.installer.select_country_gum' => 'Guam',
    'shopware.installer.select_country_gtm' => 'Guatemala',
    'shopware.installer.select_country_ggy' => 'Guernsey',
    'shopware.installer.select_country_gin' => 'Guinea',
    'shopware.installer.select_country_gnb' => 'Guinea-Bissau',
    'shopware.installer.select_country_guy' => 'Guyana',
    'shopware.installer.select_country_hti' => 'Haiti',
    'shopware.installer.select_country_hmd' => 'Territory of Heard Island and McDonald Islands',
    'shopware.installer.select_country_vat' => 'Vatican City',
    'shopware.installer.select_country_hnd' => 'Honduras',
    'shopware.installer.select_country_hkg' => 'Hong Kong',
    'shopware.installer.select_country_ind' => 'India',
    'shopware.installer.select_country_idn' => 'Indonesia',
    'shopware.installer.select_country_civ' => 'Ivory Coast',
    'shopware.installer.select_country_irn' => 'Iran',
    'shopware.installer.select_country_irq' => 'Iraq',
    'shopware.installer.select_country_imn' => 'Isle of Man',
    'shopware.installer.select_country_jey' => 'Jersey',
    'shopware.installer.select_country_jor' => 'Jordan',
    'shopware.installer.select_country_kaz' => 'Kazakhstan',
    'shopware.installer.select_country_ken' => 'Kenya',
    'shopware.installer.select_country_kir' => 'Kiribati',
    'shopware.installer.select_country_kwt' => 'Kuwait',
    'shopware.installer.select_country_kgz' => 'Kyrgyzstan',
    'shopware.installer.select_country_lao' => 'Lao People\'s Democratic Republic',
    'shopware.installer.select_country_lbn' => 'Lebanon',
    'shopware.installer.select_country_lso' => 'Lesotho',
    'shopware.installer.select_country_lbr' => 'Liberia',
    'shopware.installer.select_country_lby' => 'Libya',
    'shopware.installer.select_country_mac' => 'Macao',
    'shopware.installer.select_country_mkd' => 'Republic of North Macedonia',
    'shopware.installer.select_country_mdg' => 'Madagascar',
    'shopware.installer.select_country_mwi' => 'Malawi',
    'shopware.installer.select_country_mys' => 'Malaysia',
    'shopware.installer.select_country_mdv' => 'Maldives',
    'shopware.installer.select_country_mli' => 'Mali',
    'shopware.installer.select_country_mhl' => 'Marshall Islands',
    'shopware.installer.select_country_mtq' => 'Martinique',
    'shopware.installer.select_country_mrt' => 'Mauritania',
    'shopware.installer.select_country_mus' => 'Mauritius',
    'shopware.installer.select_country_myt' => 'Mayotte',
    'shopware.installer.select_country_mex' => 'Mexico',
    'shopware.installer.select_country_fsm' => 'Micronesia (Federated States of)',
    'shopware.installer.select_country_mda' => 'Moldova (the Republic of)',
    'shopware.installer.select_country_mco' => 'Monaco',
    'shopware.installer.select_country_mng' => 'Mongolia',
    'shopware.installer.select_country_mne' => 'Montenegro',
    'shopware.installer.select_country_msr' => 'Montserrat',
    'shopware.installer.select_country_mar' => 'Morocco',
    'shopware.installer.select_country_moz' => 'Mozambique',
    'shopware.installer.select_country_mnr' => 'Myanmar',
    'shopware.installer.select_country_nru' => 'Nauru',
    'shopware.installer.select_country_npl' => 'Nepal',
    'shopware.installer.select_country_ncl' => 'New Caledonia',
    'shopware.installer.select_country_nzl' => 'New Zealand',
    'shopware.installer.select_country_nic' => 'Nicaragua',
    'shopware.installer.select_country_ner' => 'Niger',
    'shopware.installer.select_country_nga' => 'Nigeria',
    'shopware.installer.select_country_niu' => 'Niue',
    'shopware.installer.select_country_nfk' => 'Norfolk Island',
    'shopware.installer.select_country_prk' => 'North Korea',
    'shopware.installer.select_country_mnp' => 'Northern Mariana Islands',
    'shopware.installer.select_country_omn' => 'Oman',
    'shopware.installer.select_country_pak' => 'Pakistan',
    'shopware.installer.select_country_plw' => 'Palau',
    'shopware.installer.select_country_pse' => 'Palestine, State of',
    'shopware.installer.select_country_png' => 'Papua New Guinea',
    'shopware.installer.select_country_pry' => 'Paraguay',
    'shopware.installer.select_country_per' => 'Peru',
    'shopware.installer.select_country_phl' => 'Philippines',
    'shopware.installer.select_country_pcn' => 'Pitcairn',
    'shopware.installer.select_country_pri' => 'Puerto Rico',
    'shopware.installer.select_country_qat' => 'Qatar',
    'shopware.installer.select_country_kos' => 'Kosovo',
    'shopware.installer.select_country_reu' => 'Réunion',
    'shopware.installer.select_country_rus' => 'Russia',
    'shopware.installer.select_country_rwa' => 'Rwanda',
    'shopware.installer.select_country_blm' => 'Saint Barthélemy',
    'shopware.installer.select_country_shn' => 'Saint Helena, Ascension and Tristan da Cunha',
    'shopware.installer.select_country_kna' => 'Saint Kitts and Nevis',
    'shopware.installer.select_country_lca' => 'Saint Lucia',
    'shopware.installer.select_country_maf' => 'Saint Martin',
    'shopware.installer.select_country_spm' => 'Saint Pierre and Miquelon',
    'shopware.installer.select_country_vct' => 'Saint Vincent and the Grenadines',
    'shopware.installer.select_country_wsm' => 'Samoa',
    'shopware.installer.select_country_smr' => 'San Marino',
    'shopware.installer.select_country_stp' => 'São Tomé and Príncipe',
    'shopware.installer.select_country_sau' => 'Saudi Arabia',
    'shopware.installer.select_country_sen' => 'Senegal',
    'shopware.installer.select_country_srb' => 'Serbia',
    'shopware.installer.select_country_syc' => 'Seychelles',
    'shopware.installer.select_country_sle' => 'Sierra Leone',
    'shopware.installer.select_country_sgp' => 'Singapore',
    'shopware.installer.select_country_sxm' => 'Sint Maarten (Dutch part)',
    'shopware.installer.select_country_slb' => 'Solomon Islands',
    'shopware.installer.select_country_som' => 'Somalia',
    'shopware.installer.select_country_zaf' => 'South Africa',
    'shopware.installer.select_country_sgs' => 'South Georgia and the South Sandwich Islands',
    'shopware.installer.select_country_kor' => 'South Korea',
    'shopware.installer.select_country_ssd' => 'South Sudan',
    'shopware.installer.select_country_lka' => 'Sri Lanka',
    'shopware.installer.select_country_sdn' => 'Sudan',
    'shopware.installer.select_country_sur' => 'Suriname',
    'shopware.installer.select_country_sjm' => 'Svalbard and Jan Mayen',
    'shopware.installer.select_country_swz' => 'Eswatini',
    'shopware.installer.select_country_syr' => 'Syrian Arab Republic',
    'shopware.installer.select_country_twn' => 'Taiwan (Province of China)',
    'shopware.installer.select_country_tjk' => 'Tajikistan',
    'shopware.installer.select_country_tza' => 'Tanzania, United Republic of',
    'shopware.installer.select_country_tha' => 'Thailand',
    'shopware.installer.select_country_tls' => 'Timor-Leste',
    'shopware.installer.select_country_tgo' => 'Togo',
    'shopware.installer.select_country_tkl' => 'Tokelau',
    'shopware.installer.select_country_ton' => 'Tonga',
    'shopware.installer.select_country_tto' => 'Trinidad and Tobago',
    'shopware.installer.select_country_tun' => 'Tunisia',
    'shopware.installer.select_country_tkm' => 'Turkmenistan',
    'shopware.installer.select_country_tca' => 'Turks and Caicos Islands',
    'shopware.installer.select_country_tuv' => 'Tuvalu',
    'shopware.installer.select_country_uga' => 'Uganda',
    'shopware.installer.select_country_ukr' => 'Ukraine',
    'shopware.installer.select_country_ury' => 'Uruguay',
    'shopware.installer.select_country_uzb' => 'Uzbekistan',
    'shopware.installer.select_country_vut' => 'Vanuatu',
    'shopware.installer.select_country_ven' => 'Venezuela (Bolivarian Republic of)',
    'shopware.installer.select_country_vnm' => 'Vietnam',
    'shopware.installer.select_country_wlf' => 'Wallis and Futuna',
    'shopware.installer.select_country_esh' => 'Western Sahara',
    'shopware.installer.select_country_yem' => 'Yemen',
    'shopware.installer.select_country_zmb' => 'Zambia',
    'shopware.installer.select_country_zwe' => 'Zimbabwe',
    'shopware.installer.welcome_title' => 'Welcome to Shopware 6',
    'shopware.installer.language-selection_select_language' => 'Installation wizard language',
    'shopware.installer.welcome_header' => 'Your Shopware installation',
    'shopware.installer.welcome_message' => 'We are delighted you want to join our fantastic, global Shopware community. We will now take you through the installation process step by step. If you have any queries, simply take a look in our <a class="is--nowrap" href="https://forum.shopware.com" target="_blank">forum</a>, give us a call on <a class="is--nowrap" href="tel:0080074676260">00 800 746 7626 0 (free of charge)</a> or send us an <a class="is--nowrap" href="mailto:info@shopware.com">email</a>.',
    'shopware.installer.requirements_header' => 'System requirements',
    'shopware.installer.requirements_header_files' => 'Files and directories',
    'shopware.installer.requirements_header_system' => 'System',
    'shopware.installer.requirements_files_info' => 'The following files and directories must be present and have write permissions.',
    'shopware.installer.requirements_table_files_col_check' => 'File/directory',
    'shopware.installer.requirements_table_files_col_status' => 'Status',
    'shopware.installer.requirements_error' => 'Not all of the requirements for successful installation have been met.',
    'shopware.installer.requirements_error_title' => 'Your system is not yet ready for Shopware 6',
    'shopware.installer.requirements_success' => 'All of the requirements for successful installation have been met.',
    'shopware.installer.requirements_success_title' => 'Your system is ready for Shopware 6',
    'shopware.installer.requirements_php_info' => 'Your server must meet the following system requirements in order to run Shopware.',
    'shopware.installer.requirements_php_max_compatible_version' => 'This Shopware version supports PHP up to version %s. There is no guarantee that everything will work with newer PHP versions.',
    'shopware.installer.requirements_system_col_check' => 'Requirement',
    'shopware.installer.requirements_system_col_required' => 'Required',
    'shopware.installer.requirements_system_col_found' => 'Your system',
    'shopware.installer.requirements_system_col_status' => 'Status',
    'shopware.installer.requirements_show_all' => '(show all)',
    'shopware.installer.requirements_hide_all' => '(hide all)',
    'shopware.installer.requirements_status_error' => 'Error',
    'shopware.installer.requirements_status_warning' => 'Warning',
    'shopware.installer.requirements_status_ready' => 'Ready',
    'shopware.installer.license_agreement_header' => 'General Terms and Conditions of Business ("GTC")',
    'shopware.installer.license_agreement_info' => 'These are our General Terms and Conditions of Business. You will have to read and accept the GTC in order to successfully install Shopware 6. The Community Edition is completely free of charge and has been released under the MIT License.',
    'shopware.installer.license_agreement_error' => 'Please accept our GTC.',
    'shopware.installer.license_agreement_checkbox' => 'I agree to the General Terms and Conditions of Business (GTC)',
    'shopware.installer.database-configuration_header' => 'Configure database',
    'shopware.installer.database-configuration_field_host' => 'Server:',
    'shopware.installer.database-configuration_advanced_settings' => 'Advanced settings',
    'shopware.installer.database-configuration_field_port' => 'Port:',
    'shopware.installer.database-configuration_field_user' => 'User:',
    'shopware.installer.database-configuration_field_password' => 'Password:',
    'shopware.installer.database-configuration_field_database' => 'Database name:',
    'shopware.installer.database-configuration_field_new_database' => 'New database:',
    'shopware.installer.database-configuration_info' => 'In order to install Shopware on your system, you will need the access credentials to your database. If you are not sure what to put here, contact your administrator/hosting service.',
    'shopware.installer.database-configuration-create_new_database' => 'Create new database',
    'shopware.installer.database-configuration_non_empty_database' => 'The selected database already contains data. Please select an empty database or create a new one from scratch.',
    'shopware.installer.database-configuration_error_required_fields' => 'Please fill in all the blanks.',
    'shopware.installer.database-configuration_field_ssl_ca_path' => 'SSL certificate authority path',
    'shopware.installer.database-configuration_field_ssl_cert_path' => 'SSL certificate path',
    'shopware.installer.database-configuration_field_ssl_cert_key_path' => 'SSL certificate key path',
    'shopware.installer.database-configuration_field_ssl_dont_verify_cert' => 'Don\'t verify server certificate',
    'shopware.installer.database-configuration_fetch_error' => 'An error occurred while fetching the database information',
    'shopware.installer.database-configuration_access_denied' => 'Access denied, credentials are incorrect',
    'shopware.installer.database-configuration_host_not_found' => 'Could not connect to database server',
    'shopware.installer.database-configuration_invalid_requirements' => 'Shopware 6 requires at least MySQL 8.0.22 or MariaDB 10.11',
    'shopware.installer.database-configuration_refresh_databases' => 'Refresh Databases',
    'shopware.installer.database-import_header' => 'Installation',
    'shopware.installer.database-import_skip_import' => 'Skip',
    'shopware.installer.database-import_progress' => 'Progress: ',
    'shopware.installer.database-import-hint' => '<strong>Note:</strong> If there are any Shopware tables found in the configured database, they will be removed by the installation/update!',
    'shopware.installer.database-import_info_text' => 'Installing Shopware 6 using the selected database. This process may take several minutes, depending on your overall system.',
    'shopware.installer.database_import_success' => 'Shopware 6 has been installed!',
    'shopware.installer.database_import_install_label' => 'Database installation:',
    'shopware.installer.database_import_install_step_text' => 'Step',
    'shopware.installer.database_import_install_from_text' => 'of',
    'shopware.installer.migration_counter_text_migrations' => 'Updating database',
    'shopware.installer.migration_counter_text_snippets' => 'Updating text snippets',
    'shopware.installer.migration_update_success' => 'Database has been imported!',
    'shopware.installer.edition_header' => 'Have you already purchased a Shopware licence?',
    'shopware.installer.edition_info' => 'Shopware is available in different versions. There is the free <a href="https://en.shopware.com/pricing/" target="_blank">Community Edition</a>, and there are the <a href="https://en.shopware.com/pricing/" target="_blank">Professional or Enterprise Edition</a>, that are available for a one time fee.',
    'shopware.installer.edition_ce' => 'No, I would like to use the free <a href="https://en.shopware.com/pricing/" target="_blank">Community Edition</a>.',
    'shopware.installer.edition_cm' => 'Yes, I have already purchased a Shopware licence (<a href="https://en.shopware.com/pricing/" target="_blank">Professional or Enterprise</a>).',
    'shopware.installer.edition_license' => 'Please enter your licence key here. You can find it in your Shopware Account under "Licences" → "Product licences" → "Details / Download":',
    'shopware.installer.edition_license_error' => 'A valid licence is required in order to install any of the Shopware versions that come with a fee.',
    'shopware.installer.configuration_header' => 'Configuration',
    'shopware.installer.configuration_sconfig_text' => 'Almost done. You just need to make some few basic settings in your shop, Shopware 6 will be installed completely afterwards.',
    'shopware.installer.configuration_sconfig_name' => 'Shop name',
    'shopware.installer.configuration_sconfig_name_info' => 'Please enter the name of your shop.',
    'shopware.installer.configuration_sconfig_mail' => 'Shop email address:',
    'shopware.installer.configuration_sconfig_mail_info' => 'Please enter an email address for outgoing emails',
    'shopware.installer.configuration_sconfig_domain' => 'Shop domain:',
    'shopware.installer.configuration_sconfig_language' => 'Default system language:',
    'shopware.installer.configuration_sconfig_currency' => 'Default currency:',
    'shopware.installer.configuration_sconfig_country' => 'Default country:',
    'shopware.installer.configuration_sconfig_currency_info' => 'This currency will be used as the standard currency, everytime item prices are set.',
    'shopware.installer.configuration_admin_currency_eur' => 'Euro',
    'shopware.installer.configuration_admin_currency_usd' => 'Dollar (US)',
    'shopware.installer.configuration_admin_currency_gbp' => 'Pound sterling (UK)',
    'shopware.installer.configuration_admin_currency_pln' => 'Polish zloty',
    'shopware.installer.configuration_admin_currency_chf' => 'Swiss francs',
    'shopware.installer.configuration_admin_currency_sek' => 'Swedish kronor',
    'shopware.installer.configuration_admin_currency_dkk' => 'Danish kroner',
    'shopware.installer.configuration_admin_currency_nok' => 'Norwegian kroner',
    'shopware.installer.configuration_admin_currency_czk' => 'Czech koruna',
    'shopware.installer.configuration_admin_username' => 'Admin login name:',
    'shopware.installer.configuration_admin_mail' => 'Admin email:',
    'shopware.installer.configuration_admin_firstName' => 'Admin first name:',
    'shopware.installer.configuration_admin_lastName' => 'Admin last name:',
    'shopware.installer.configuration_defaults_warning' => 'Beware! The settings for your default system language as well as the default currency are permanent and cannot be changed ever again.',
    'shopware.installer.configuration_admin_currency_headline' => 'Available currencies',
    'shopware.installer.configuration_admin_currency_text' => 'Add more currencies to your Shopware shop. If you want to add currencies afterwards, you can create them at any time in the Administration.',
    'shopware.installer.configuration_email_help_text' => 'This email address will be used for outgoing shop emails.',
    'shopware.installer.configuration_admin_language_de' => 'German',
    'shopware.installer.configuration_admin_language_en' => 'English',
    'shopware.installer.configuration_admin_password' => 'Admin password:',
    'shopware.installer.finish_header' => 'Installation completed',
    'shopware.installer.finish_info' => 'You have successfully installed Shopware!',
    'shopware.installer.finish_info_heading' => 'Hooray!',
    'shopware.installer.finish_first_steps' => '"First steps" guide',
    'shopware.installer.finish_frontend' => 'Open Storefront',
    'shopware.installer.finish_backend' => 'Open Administration',
    'shopware.installer.finish_message' => ' <p> <strong>Welcome to Shopware,</strong> </p> <p> You have installed Shopware successfully and we are delighted to welcome you to our community! <p>Your shop is now ready to use. If you are new to Shopware, we recommend taking a look at this guide <a href="https://docs.shopware.com/en/shopware-6-en/first-steps/welcome-to-shopware" target="_blank">"First steps in Shopware"</a>. When you log in to the administration for the first time, our "First Run Wizard" will take you through the basic setup. </p> <p> Enjoy your new online shop! </p>',
  ),
));


return $catalogue;
