const m=`{% block sw_settings_user_list %} <mt-card class="sw-users-permissions-user-listing sw-settings-user-list" position-identifier="sw-users-permissions-user-listing" :title="$tc('sw-users-permissions.users.general.cardLabel')" > <div class="sw-users-permissions-user-listing__toolbar"> <sw-container columns="1fr minmax(100px, 200px)" gap="0 10px" > {% block sw_settings_user_list_smart_bar_actions %} {% block sw_settings_user_list_search_bar %} <sw-simple-search-field v-model:value="term" size="small" variant="form" @search-term-change="onSearch" /> {% endblock %} {% block sw_settings_user_list_actions_create_user %} <mt-button v-if="isSso" size="small" :disabled="!acl.can('users_and_permissions.creator') || undefined" class="sw-users-permissions-user-listing__add-user-button" variant="primary" @click="openInvitationModal" > {{ $tc('sw-users-permissions.sso.inviteButtonLabel') }} </mt-button> <mt-button v-else ghost size="small" :disabled="!acl.can('users_and_permissions.creator') || undefined" class="sw-users-permissions-user-listing__add-user-button" variant="secondary" @click="$router.push({ name: 'sw.users.permissions.user.create' })" > {{ $tc('sw-users-permissions.users.general.labelCreateNewUser') }} </mt-button> <sw-user-sso-invitation-modal v-if="showInvitationModal" @modal-close="closeInvitationModal" @user-invited="onUserInvited" @invitation-failed="invitationFailed" /> {% endblock %} {% endblock %} </sw-container> </div> {% block sw_settings_user_list_content %} {% block sw_settings_user_list_content_grid %} <sw-data-grid :data-source="user" :columns="userColumns" identifier="user-grid" :show-settings="true" :show-selection="false" :is-loading="isLoading" @column-sort="onSortColumn" > {% block sw_settings_user_list_content_grid_actions %} <template #actions="{ item }"> {% block sw_settings_user_list_actions_edit %} <sw-context-menu-item class="sw-settings-user-list__user-view-action" :disabled="!acl.can('users_and_permissions.editor') || undefined" :router-link="{ name: 'sw.users.permissions.user.sso.detail', params: { id: item.id } }" > {{ $tc('sw-users-permissions.users.user-grid.contextMenuEdit') }} </sw-context-menu-item> {% endblock %} {% block sw_settings_user_list_actions_delete %} <sw-context-menu-item class="sw-settings-user-list__user-delete-action" variant="danger" :disabled="!acl.can('users_and_permissions.deleter') || undefined" @click="onDelete(item)" > {{ $tc('sw-users-permissions.users.user-grid.contextMenuDelete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_settings_user_list_column_username_preview %} <template #preview-username="{ item, compact }"> <sw-avatar v-if="!isSso" :size="compact ? '32px' : '48px'" :first-name="item.firstName" :last-name="item.lastName" variant="square" :source-context="item" /> </template> {% endblock %} {% block sw_settings_user_list_column_username %} <template #column-username="{ item }"> {% block sw_settings_user_list_column_username_content %} <router-link class="sw-settings-user-list__columns" :to="{ name: 'sw.users.permissions.user.detail', params: { id: item.id } }" > {{ item.username }} </router-link> {% endblock %} </template> {% endblock %} {% block sw_settings_user_list_column_status %} <template #column-status="{item}"> <sw-user-sso-status-label :user="item" /> </template> {% endblock %} {% block sw_settings_user_list_column_username_acl_roles %} <template #column-aclRoles="{ item, compact }"> <template v-if="item.aclRoles && item.aclRoles.length > 0"> <span v-for="(role, index) in item.aclRoles" :key="index" > {{ role.name }}<template v-if="index + 1 < item.aclRoles.length">,&nbsp;</template> </span> </template> <span v-else-if="item.admin"> {{ $tc('sw-users-permissions.users.user-detail.labelAdministrator') }} </span> <span v-else></span> </template> {% endblock %} <template #pagination> {% block sw_settings_user_list_grid_pagination %} <sw-pagination :page="page" :limit="limit" :total="total" :auto-hide="true" @page-change="onPageChange" /> {% endblock %} </template> <template #action-modals="{ item }"> {% block sw_settings_user_list_delete_modal %} <sw-modal v-if="getItemToDelete(item)" :title="$tc('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_settings_user_list_delete_modal_confirm_delete_text %} <p class="sw-settings-user-list__confirm-delete-text"> {{ $tc('sw-users-permissions.users.user-grid.textModalDelete', { name: salutation(item) }, 0) }} </p> {% endblock %} {% block sw_settings_user_list_delete_modal_input__confirm_password %} <mt-password-field v-if="!isSso" v-model="confirmPassword" class="sw-settings-user-detail__confirm-password" required name="sw-field--confirm-password" :password-toggle-able="true" :label="$tc('sw-users-permissions.users.user-detail.passwordConfirmation.labelConfirmPassword')" :placeholder="$tc('sw-users-permissions.users.user-detail.passwordConfirmation.placeholderConfirmPassword')" autocomplete="off" @keypress.enter="onConfirmDelete(item)" /> {% endblock %} {% block sw_settings_user_list_delete_modal_footer %} <template #modal-footer> {% block sw_settings_user_list_delete_modal_cancel %} <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_user_list_delete_modal_confirm %} <mt-button :disabled="!confirmPassword && !isSso || undefined" :is-loading="isConfirmingPassword" variant="critical" size="small" @click="onConfirmDelete(item)" > {{ $tc('sw-users-permissions.users.user-grid.labelButtonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </template> </sw-data-grid> {% endblock %} {% endblock %} </mt-card> {% endblock %}`,{Data:u,Mixin:t}=Shopware,{Criteria:o}=u,_={template:m,inject:["userService","loginService","repositoryFactory","acl","ssoSettingsService"],emits:["get-list"],mixins:[t.getByName("listing"),t.getByName("notification"),t.getByName("salutation")],created(){this.ssoSettingsService.isSso().then(s=>{this.isSso=s.isSso})},data(){return{user:[],isLoading:!1,itemToDelete:null,disableRouteParams:!0,confirmPassword:"",sortBy:"username",isConfirmingPassword:!1,showInvitationModal:!1,isSso:!1}},metaInfo(){return{title:this.$createTitle()}},computed:{userRepository(){return this.repositoryFactory.create("user")},currentUser:{get(){return Shopware.Store.get("session").currentUser}},userCriteria(){const s=new o(this.page,this.limit);return this.term&&s.setTerm(this.term),this.sortBy&&s.addSorting(o.sort(this.sortBy,this.sortDirection||"ASC")),s.addAssociation("aclRoles"),s.addAssociation("avatarMedia"),s},userColumns(){return this.isSso?[{property:"email",label:this.$tc("sw-users-permissions.users.user-grid.labelEmail")},{property:"aclRoles",sortable:!1,label:this.$tc("sw-users-permissions.users.user-grid.labelRoles")},{property:"status",label:this.$tc("sw-users-permissions.users.user-grid.status")}]:[{property:"username",label:this.$tc("sw-users-permissions.users.user-grid.labelUsername")},{property:"firstName",label:this.$tc("sw-users-permissions.users.user-grid.labelFirstName")},{property:"lastName",label:this.$tc("sw-users-permissions.users.user-grid.labelLastName")},{property:"aclRoles",sortable:!1,label:this.$tc("sw-users-permissions.users.user-grid.labelRoles")},{property:"email",label:this.$tc("sw-users-permissions.users.user-grid.labelEmail")}]}},methods:{getItemToDelete(s){return this.itemToDelete?this.itemToDelete.id===s.id:!1},onSearch(s){this.term=s,this.getList()},getList(){return this.isLoading=!0,this.user=[],this.$emit("get-list"),this.userRepository.search(this.userCriteria).then(s=>{this.total=s.total,this.user=s}).finally(()=>{this.isLoading=!1})},onDelete(s){this.itemToDelete=s},onUserInvited(){this.getList(),this.closeInvitationModal()},openInvitationModal(){this.showInvitationModal=!0},closeInvitationModal(){this.showInvitationModal=!1},invitationFailed(){this.createNotificationError({title:this.$tc("global.default.error"),message:this.$tc("sw-users-permissions.sso.error.cannotInviteUser")})},async onConfirmDelete(s){const i=`${s.firstName} ${s.lastName} `,a=this.$tc("global.default.success"),l=this.$tc("sw-users-permissions.users.user-grid.notification.deleteSuccess.message",{name:i},0),n=this.$tc("global.default.error"),c=this.$tc("sw-users-permissions.users.user-grid.notification.deleteError.message",{name:i},0);if(s.id===this.currentUser.id){this.createNotificationError({title:this.$tc("global.default.error"),message:this.$tc("sw-users-permissions.users.user-grid.notification.deleteUserLoggedInError.message")}),this.onCloseDeleteModal();return}const r={...Shopware.Context.api};if(!this.isSso){let e;try{this.isConfirmingPassword=!0,e=await this.loginService.verifyUserToken(this.confirmPassword)}catch{this.createNotificationError({title:this.$tc("sw-users-permissions.users.user-detail.passwordConfirmation.notificationPasswordErrorTitle"),message:this.$tc("sw-users-permissions.users.user-detail.passwordConfirmation.notificationPasswordErrorMessage")})}finally{this.confirmPassword="",this.isConfirmingPassword=!1}if(!e)return;this.confirmPasswordModal=!1,r.authToken.access=e}this.userRepository.delete(s.id,r).then(()=>{this.createNotificationSuccess({title:a,message:l}),this.getList()}).catch(()=>{this.createNotificationError({title:n,message:c})}),this.onCloseDeleteModal()},onCloseDeleteModal(){this.itemToDelete=null}}};export{_ as default};
