const o=`{% block sw_generic_custom_entity_detail %} <sw-page class="sw-generic-custom-entity-detail" :header-border-color="entityAccentColor" > <template #smart-bar-header> <h2 class="sw-generic-custom-entity-detail__title"> {{ placeholder(customEntityData, titlePropertyName, $tc(\`\${customEntityName}.moduleTitle\`)) }} </h2> </template> <template #smart-bar-actions> <sw-button-process class="sw-generic-custom-entity-detail__save-action" :is-loading="isLoading" :process-success="isSaveSuccessful" variant="primary" :disabled="isLoading" @update:process-success="saveFinish" @click="onSave" > {{ $tc('global.default.save') }} </sw-button-process> </template> <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> <template #content> <sw-card-view> <sw-tabs v-if="detailTabs" class="sw-generic-custom-entity-detail__tabs" position-identifier="sw-generic-custom-entity-detail-tabs" :default-item="mainTabName" :small="false" > <template #default="{ active }"> <sw-tabs-item v-for="tab in detailTabs" :key="\`tab-item-\${tab.name}\`" class="sw-generic-custom-entity-detail__tab-item" :name="tab.name" :active-tab="active" > {{ getLabel('tabs', tab.name) }} </sw-tabs-item> <sw-tabs-item v-if="customEntityDataDefinition?.flags?.['cms-aware']" class="sw-generic-custom-entity-detail__tab-item" name="cms-aware-tab-layout" :active-tab="active" > {{ $tc('sw-custom-entity.detail.tabs.layout') }} </sw-tabs-item> <sw-tabs-item v-if="customEntityDataDefinition?.flags?.['cms-aware']" class="sw-generic-custom-entity-detail__tab-item" name="cms-aware-tab-seo" :active-tab="active" > {{ $tc('sw-custom-entity.detail.tabs.seo') }} </sw-tabs-item> </template> <template #content="{ active }"> <template v-for="tab in detailTabs" :key="\`tab-\${tab.name}\`" > <div v-if="active === tab.name" class="sw-generic-custom-entity-detail__tab" > <mt-card v-for="card in tab.cards" :key="\`card-\${card.name}\`" class="sw-generic-custom-entity-detail__card" position-identifier="\`sw-generic-custom-entity-detail-tab-\${card.name}\`" :title="getLabel('cards', card.name)" > <template v-if="!isLoading"> <sw-custom-entity-input-field v-for="field in card.fields" :key="field.ref" v-model:value="customEntityData[field.ref]" class="sw-generic-custom-entity-detail__field" :type="getType(field.ref)" :label="getLabel('fields', field.ref)" :placeholder="getPlaceholder('fields', field.ref)" :help-text="getHelpText('fields', field.ref)" /> </template> </mt-card> </div> </template> <sw-generic-cms-page-assignment v-if="active === 'cms-aware-tab-layout'" :cms-page-id="customEntityData?.swCmsPageId" :slot-overrides="customEntityData?.swSlotConfig" class="sw-generic-custom-entity-detail__tab sw-generic-custom-entity-detail__tab-cms-aware" @update:cms-page-id="updateCmsPageId" @update:slot-overrides="updateCmsSlotOverwrites" @create-layout="onCreateLayout" /> <template v-else-if="active === 'cms-aware-tab-seo'" > <sw-generic-seo-general-card :seo-meta-title="customEntityData?.swSeoMetaTitle" :seo-meta-description="customEntityData?.swSeoMetaDescription" :seo-url="customEntityData?.swSeoUrl" @update:seo-meta-title="updateSeoMetaTitle" @update:seo-meta-description="updateSeoMetaDescription" @update:seo-url="updateSeoUrl" /> <sw-generic-social-media-card :og-title="customEntityData?.swOgTitle" :og-description="customEntityData?.swOgDescription" :og-image-id="customEntityData?.swOgImageId" @update:og-title="updateOgTitle" @update:og-description="updateOgDescription" @update:og-image-id="updateOgImageId" /> </template> </template> </sw-tabs> </sw-card-view> </template> </sw-page> {% endblock %}`,{Mixin:n}=Shopware,r=Shopware.Component.wrapComponentConfig({template:o,inject:["customEntityDefinitionService","repositoryFactory","acl"],mixins:[n.getByName("placeholder"),n.getByName("notification")],data(){return{isLoading:!0,isSaveSuccessful:!1,customEntityData:null,customEntityDataInstances:void 0}},computed:{customEntityDataId(){var t,e;return((e=(t=this.$route.params)==null?void 0:t.id)==null?void 0:e.toLowerCase())??null},customEntityName(){return this.$route.params.entityName||""},customEntityDataDefinition(){return this.customEntityName?this.customEntityDefinitionService.getDefinitionByName(this.customEntityName)??null:null},customEntityDataRepository(){return this.customEntityDataDefinition===null?null:this.repositoryFactory.create(this.customEntityDataDefinition.entity)},customEntityProperties(){var t;return(t=this.customEntityDataDefinition)==null?void 0:t.properties},adminConfig(){var t;return(t=this.customEntityDataDefinition)==null?void 0:t.flags["admin-ui"]},entityAccentColor(){var t;return(t=this.adminConfig)==null?void 0:t.color},detailTabs(){var t,e,a;return((a=(e=(t=this.customEntityDataDefinition)==null?void 0:t.flags["admin-ui"])==null?void 0:e.detail)==null?void 0:a.tabs)??[]},mainTabName(){var t,e;return(e=(t=this.detailTabs)==null?void 0:t[0])==null?void 0:e.name},titlePropertyName(){var t,e,a,s,i;return(i=(s=(a=(e=(t=this.detailTabs)==null?void 0:t[0])==null?void 0:e.cards)==null?void 0:a[0].fields)==null?void 0:s[0])==null?void 0:i.ref}},created(){this.createdComponent()},methods:{createdComponent(){this.initializeCustomEntity()},initializeCustomEntity(){var t;this.adminConfig!==null&&(this.$route.meta.$module.icon=(t=this.adminConfig)==null?void 0:t.icon),this.loadData()},async loadData(){this.isLoading=!0;try{if(!this.customEntityDataRepository)throw new Error(`Custom entity repository for "${this.customEntityName}" not found`);if(!this.customEntityDataId){this.customEntityData=this.customEntityDataRepository.create(),this.isLoading=!1;return}this.customEntityData=await this.customEntityDataRepository.get(this.customEntityDataId)}catch(t){console.error(t),this.createNotificationError({message:this.$tc("global.notification.notificationLoadingDataErrorMessage")})}finally{this.isLoading=!1}},async onSave(){var t;return this.isLoading=!0,this.customEntityData?(t=this.customEntityDataRepository)==null?void 0:t.save(this.customEntityData).then(async()=>{var e;this.isSaveSuccessful=!0,!this.customEntityDataId&&((e=this.customEntityData)!=null&&e.id)&&await this.$router.push({name:"sw.custom.entity.detail",params:{id:this.customEntityData.id}}),this.loadData()}).finally(()=>{this.isLoading=!1}):Promise.reject()},saveFinish(){this.isSaveSuccessful=!1},onChangeLanguage(t){Shopware.Store.get("context").setApiLanguageId(t),this.loadData()},getFieldTranslation(t,e,a="",s=!1){const i=[this.customEntityName,t,e].join(".").concat(a);return s&&!this.$te(i)?"":this.$tc(i)},getLabel(t,e){return this.getFieldTranslation(t,e)},getPlaceholder(t,e){return this.getFieldTranslation(t,e,"Placeholder",!0)},getHelpText(t,e){return this.getFieldTranslation(t,e,"HelpText",!0)},getType(t){var e,a;return((a=(e=this.customEntityProperties)==null?void 0:e[t])==null?void 0:a.type)||""},updateCmsPageId(t){this.customEntityData&&(this.customEntityData.swCmsPageId=t)},updateCmsSlotOverwrites(t){this.customEntityData&&(this.customEntityData.swSlotConfig=t)},updateSeoMetaTitle(t){this.customEntityData&&(this.customEntityData.swSeoMetaTitle=t)},updateSeoMetaDescription(t){this.customEntityData&&(this.customEntityData.swSeoMetaDescription=t)},updateSeoUrl(t){this.customEntityData&&(this.customEntityData.swSeoUrl=t)},updateOgTitle(t){this.customEntityData&&(this.customEntityData.swOgTitle=t)},updateOgDescription(t){this.customEntityData&&(this.customEntityData.swOgDescription=t)},updateOgImageId(t){this.customEntityData&&(this.customEntityData.swOgImageId=t)},onCreateLayout(){this.customEntityData&&this.$router.push({name:"sw.cms.create",params:{id:this.customEntityData.id,type:this.customEntityName}})}}});export{r as default};
