const i=`{% block sw_settings_currency_detail %} <sw-page class="sw-settings-currency-detail"> {% block sw_settings_currency_detail_header %} <template #smart-bar-header> <h2>{{ placeholder(currency, 'name', $tc('sw-settings-currency.detail.textHeadline')) }}</h2> </template> {% endblock %} {% block sw_settings_currency_detail_actions %} <template #smart-bar-actions> {% block sw_settings_currency_detail_actions_abort %} <mt-button v-tooltip.bottom="tooltipCancel" :disabled="isLoading" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_currency_detail_actions_save %} <sw-button-process v-model:process-success="isSaveSuccessful" v-tooltip.bottom="tooltipSave" class="sw-settings-currency-detail__save-action" :is-loading="isLoading" :disabled="isLoading || !acl.can('currencies.editor') || undefined" variant="primary" @update:process-success="saveFinish" @click.prevent="onSave" > {{ $tc('sw-settings-currency.detail.buttonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_settings_currency_detail_language_switch %} <template #language-switch> <sw-language-switch :disabled="currencyId == null" :save-changes-function="saveOnLanguageChange" :abort-change-function="abortOnLanguageChange" @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_settings_currency_detail_content %} <template #content> <sw-card-view> <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </template> <template v-else> {% block sw_settings_currency_detail_content_language_info %} <sw-language-info :entity-description="placeholder(currency, 'name', $tc('sw-settings-currency.detail.textHeadline'))" /> {% endblock %} {% block sw_settings_currency_detail_content_card %} <mt-card position-identifier="sw-settings-currency-detail-content" :is-loading="isLoading" :title="$tc('sw-settings-currency.detail.titleCard')" > <sw-container columns="repeat(auto-fit, minmax(250px, 1fr))" gap="0px 30px" > {% block sw_settings_currency_detail_content_field_name %} <mt-text-field v-model="currency.name" name="sw-field--currency-name" required :disabled="!acl.can('currencies.editor')" :label="$tc('sw-settings-currency.detail.labelName')" :placeholder="placeholder(currency, 'name', $tc('sw-settings-currency.detail.placeholderName'))" :error="currencyNameError" /> {% endblock %} {% block sw_settings_currency_detail_content_field_iso_code %} <mt-text-field v-model="currency.isoCode" name="sw-field--currency-isoCode" required :disabled="!acl.can('currencies.editor')" :label="$tc('sw-settings-currency.detail.labelIsoCode')" :placeholder="placeholder(currency, 'isoCode', $tc('sw-settings-currency.detail.placeholderIsoCode'))" :error="currencyIsoCodeError" /> {% endblock %} {% block sw_settings_currency_detail_content_field_short_name %} <mt-text-field v-model="currency.shortName" name="sw-field--currency-shortName" required :disabled="!acl.can('currencies.editor')" :label="$tc('sw-settings-currency.detail.labelShortName')" :placeholder="placeholder(currency, 'shortName', $tc('sw-settings-currency.detail.placeholderShortName'))" :error="currencyShortNameError" /> {% endblock %} {% block sw_settings_currency_detail_content_field_symbol %} <mt-text-field v-model="currency.symbol" name="sw-field--currency-symbol" required :disabled="!acl.can('currencies.editor')" :label="$tc('sw-settings-currency.detail.labelSymbol')" :placeholder="$tc('sw-settings-currency.detail.placeholderSymbol')" :error="currencySymbolError" /> {% endblock %} {% block sw_settings_currency_detail_content_field_factor %} <mt-number-field v-model="currency.factor" name="sw-field--currency-factor" required :digits="14" :label="$tc('sw-settings-currency.detail.labelFactor')" :placeholder="$tc('sw-settings-currency.detail.placeholderFactor')" :error="currencyFactorError" :disabled="currency.isSystemDefault || !acl.can('currencies.editor')" /> {% endblock %} {% block sw_settings_currency_detail_content_field_tax_free_from %} <mt-number-field v-model="currency.taxFreeFrom" name="sw-field--currency-taxFreeFrom" :min="0" :label="$tc('sw-settings-currency.detail.taxFreeFrom')" :help-text="$tc('sw-settings-currency.detail.taxFreeFromHelpText', { currencyName: \`\${currency.name}\` }, 0)" :disabled="!currency.factor" > <template #suffix> {{ currency.symbol }} </template> </mt-number-field> {% endblock %} </sw-container> </mt-card> {% endblock %} {% block sw_settings_currency_detail_content_card_price_rounding %} <mt-card position-identifier="sw-settings-currency-detail-price-rounding" :is-loading="isLoading" :title="$tc('sw-settings-currency.detail.titleRoundingCard')" > <sw-settings-price-rounding :item-rounding="currency.itemRounding" :total-rounding="currency.totalRounding" /> </mt-card> {% endblock %} {% block sw_settings_currency_detail_content_card_country_price_rounding %} <mt-card position-identifier="sw-settings-currency-detail-country-price-rounding" :title="$tc('sw-settings-currency.detail.titleCountryRoundingCard')" :is-loading="currencyCountryLoading" > <template v-if="currency.id && !currency.isNew()" #toolbar > {% block sw_settings_currency_detail_content_card_country_price_rounding_toolbar %} <div class="sw-settings-currency-detail__currency-country-toolbar"> {% block sw_settings_currency_detail_content_card_country_price_rounding_toolbar_filter %} <sw-card-filter :placeholder="$tc('sw-settings-currency.detail.searchbarPlaceholder')" @sw-card-filter-term-change="onChangeCountrySearch" /> {% endblock %} {% block sw_settings_currency_detail_content_card_country_price_rounding_toolbar_button %} <mt-button ghost class="sw-settings-currency-detail__currency-country-toolbar-button" size="small" variant="secondary" @click="onAddCountry" > {{ $tc('sw-settings-currency.detail.buttonAddCountry') }} </mt-button> {% endblock %} </div> {% endblock %} </template> {% block sw_settings_currency_detail_content_card_country_price_rounding_listing %} <sw-entity-listing v-if="currencyCountryRoundings && currencyCountryRoundings.length > 0" class="sw-settings-currency-detail__currency-country-list" :full-page="false" :show-selection="false" :items="currencyCountryRoundings" :columns="currencyCountryColumns" identifier="sw-settings-currency-detail-currency-country-list" :repository="currencyCountryRoundingRepository" @delete-item-finish="loadCurrencyCountryRoundings" @items-delete-finish="loadCurrencyCountryRoundings" > {% block sw_settings_currency_detail_content_card_country_price_rounding_listing_country_column %} <template #column-country="{ item }"> <a href="#" @click="onClickEdit(item)" > {{ item.country.name }} </a> </template> {% endblock %} {% block sw_settings_currency_detail_content_card_country_price_rounding_listing_item_interval_column %} <template #column-itemRounding.interval="{ item }"> <template v-if="item.itemRounding.interval === 0.01"> {{ $tc('sw-settings-currency.price-rounding.labelIntervalNone') }} </template> <template v-if="item.itemRounding.interval !== 0.01"> {{ item.itemRounding.interval }} </template> </template> {% endblock %} {% block sw_settings_currency_detail_content_card_country_price_rounding_listing_total_interval_column %} <template #column-totalRounding.interval="{ item }"> <template v-if="item.totalRounding.interval === 0.01"> {{ $tc('sw-settings-currency.price-rounding.labelIntervalNone') }} </template> <template v-if="item.totalRounding.interval !== 0.01"> {{ item.totalRounding.interval }} </template> </template> {% endblock %} {% block sw_settings_currency_detail_content_card_country_price_rounding_listing_item_net_column %} <template #column-itemRounding.roundForNet="{ item }"> <sw-data-grid-column-boolean v-model:value="item.itemRounding.roundForNet" /> </template> {% endblock %} {% block sw_settings_currency_detail_content_card_country_price_rounding_listing_total_net_column %} <template #column-totalRounding.roundForNet="{ item }"> <sw-data-grid-column-boolean v-model:value="item.totalRounding.roundForNet" /> </template> {% endblock %} {% block sw_settings_currency_detail_content_card_country_price_rounding_listing_more_actions %} <template #more-actions="{ item }"> <sw-context-menu-item @click="onClickEdit(item)"> {{ $tc('global.default.edit') }} </sw-context-menu-item> </template> {% endblock %} </sw-entity-listing> {% endblock %} {% block sw_settings_currency_detail_content_card_country_price_rounding_empty %} <sw-empty-state v-else class="sw-settings-currency-detail__currency-country-empty-state" title="" :absolute="false" :subline="emptyStateText" /> {% endblock %} </mt-card> {% block sw_settings_currency_detail_content_card_country_price_rounding_modal %} <sw-settings-currency-country-modal v-if="currentCurrencyCountry" :currency-country-rounding="currentCurrencyCountry" @save="onSaveCurrencyCountry" @edit-cancel="onCancelEditCountry" /> {% endblock %} {% endblock %} {% block sw_settings_currency_detail_custom_field_sets %} <mt-card v-if="showCustomFields" position-identifier="sw-settings-currency-detail-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="currency" :disabled="!acl.can('currencies.editor')" :sets="customFieldSets" /> </mt-card> {% endblock %} </template> </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{cloneDeep:t}=Shopware.Utils.object,{Mixin:r}=Shopware,{Criteria:n}=Shopware.Data,{mapPropertyErrors:s}=Shopware.Component.getComponentHelper(),o={template:i,inject:["repositoryFactory","acl","feature","customFieldDataProviderService"],mixins:[r.getByName("notification"),r.getByName("placeholder")],props:{currencyId:{type:String,required:!1,default:null}},shortcuts:{"SYSTEMKEY+S":{active(){return this.acl.can("currencies.editor")},method:"onSave"},ESCAPE:"onCancel"},data(){return{currency:{},isLoading:!1,currencyCountryLoading:!1,isSaveSuccessful:!1,currentCurrencyCountry:null,currencyCountryRoundings:null,searchTerm:"",customFieldSets:null}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{identifier(){return this.placeholder(this.currency,"name")},currencyRepository(){return this.repositoryFactory.create("currency")},currencyCountryRoundingRepository(){return this.currency.countryRoundings?this.repositoryFactory.create(this.currency.countryRoundings.entity,this.currency.countryRoundings.source):null},tooltipSave(){return this.acl.can("currencies.editor")?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.acl.can("currencies.editor"),showOnDisabledElements:!0}},tooltipCancel(){return{message:"ESC",appearance:"light"}},...s("currency",["name","isoCode","shortName","symbol","isDefault","decimalPrecision","factor"]),currencyCountryColumns(){return[{property:"country",label:"sw-settings-currency.detail.currencyCountry.countryColumn",sortable:!0},{property:"itemRounding.decimals",label:"sw-settings-currency.detail.currencyCountry.itemDecimalsColumn",sortable:!1},{property:"itemRounding.interval",label:"sw-settings-currency.detail.currencyCountry.itemIntervalColumn",sortable:!1},{property:"itemRounding.roundForNet",label:"sw-settings-currency.detail.currencyCountry.itemNetRoundingColumn",sortable:!1,visible:!1},{property:"totalRounding.decimals",label:"sw-settings-currency.detail.currencyCountry.totalDecimalsColumn",sortable:!1},{property:"totalRounding.interval",label:"sw-settings-currency.detail.currencyCountry.totalIntervalColumn",sortable:!1},{property:"totalRounding.roundForNet",label:"sw-settings-currency.detail.currencyCountry.totalNetRoundingColumn",sortable:!1,visible:!1}]},currencyCountryRoundingCriteria(){const e=new n(1,25);return e.addAssociation("country"),this.searchTerm?e.setTerm(this.searchTerm):e.setTerm(""),e.addSorting(n.sort("country.name")),e},emptyStateText(){return this.currency.id&&this.currency.isNew()?this.$tc("sw-settings-currency.detail.emptyCountryRoundingsNewCurrency"):this.$tc("sw-settings-currency.detail.emptyCountryRoundings")},showCustomFields(){return this.customFieldSets&&this.customFieldSets.length>0}},watch:{currencyId(){this.currencyId||this.createdComponent()}},created(){this.createdComponent()},methods:{createdComponent(){return this.currencyId?Promise.all([this.loadEntityData(),this.loadCustomFieldSets()]):(Shopware.Store.get("context").resetLanguageToDefault(),this.isLoading=!0,this.currency=this.currencyRepository.create(),this.currency.itemRounding={decimals:2,interval:.01,roundForNet:!0},this.currency.totalRounding={decimals:2,interval:.01,roundForNet:!0},this.isLoading=!1,Promise.resolve())},loadEntityData(){return this.isLoading=!0,this.currencyRepository.get(this.currencyId).then(e=>(this.currency=e,this.loadCurrencyCountryRoundings().then(c=>[e,c]))).finally(()=>{this.isLoading=!1})},loadCurrencyCountryRoundings(){return this.currencyCountryLoading=!0,this.currencyCountryRoundingRepository.search(this.currencyCountryRoundingCriteria).then(e=>(this.currencyCountryRoundings=e,e)).finally(()=>{this.currencyCountryLoading=!1})},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("currency").then(e=>{this.customFieldSets=e})},saveFinish(){this.isSaveSuccessful=!1},onSave(){return this.isSaveSuccessful=!1,this.isLoading=!0,this.currencyRepository.save(this.currency).then(()=>{this.isSaveSuccessful=!0,this.currencyId||this.$router.push({name:"sw.settings.currency.detail",params:{id:this.currency.id}}),this.currencyRepository.get(this.currency.id).then(e=>{this.currency=e,this.isLoading=!1})}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-currency.detail.notificationErrorMessage")}),this.isLoading=!1})},onCancel(){this.$router.push({name:"sw.settings.currency.index"})},abortOnLanguageChange(){return this.currencyRepository.hasChanges(this.currency)},saveOnLanguageChange(){return this.onSave()},onChangeLanguage(){this.loadEntityData()},onChangeCountrySearch(e){this.searchTerm=e,this.loadCurrencyCountryRoundings()},onAddCountry(){this.currentCurrencyCountry=this.currencyCountryRoundingRepository.create(),this.currentCurrencyCountry.itemRounding=t(this.currency.itemRounding),this.currentCurrencyCountry.totalRounding=t(this.currency.totalRounding),this.currentCurrencyCountry.currencyId=this.currency.id},onCancelEditCountry(){this.currentCurrencyCountry=null},onClickEdit(e){this.currentCurrencyCountry=e},onSaveCurrencyCountry(){this.currencyCountryLoading=!0,this.currencyCountryRoundingRepository.save(this.currentCurrencyCountry).then(()=>{this.createNotificationSuccess({title:this.$tc("global.default.success"),message:this.$tc("sw-settings-currency.detail.notificationCountrySuccessMessage")}),this.onCancelEditCountry(),this.loadCurrencyCountryRoundings()}).catch(()=>{this.createNotificationError({title:this.$tc("global.default.error"),message:this.$tc("sw-settings-currency.detail.notificationCountryErrorMessage")})}).finally(()=>{this.currencyCountryLoading=!1})}}};export{o as default};
