<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @Installer/installer/database-configuration.html.twig */
class __TwigTemplate_4aa4cceaed8b66204c9b7f2a79b516f7 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'base_content' => [$this, 'block_base_content'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "@Installer/installer/base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $this->parent = $this->load("@Installer/installer/base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_base_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 4
        yield "    <div class=\"card__title\">
        <h2>";
        // line 5
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_header"), "html", null, true);
        yield "</h2>
    </div>

    <form
        action=\"";
        // line 9
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getUrl("installer.database-configuration");
        yield "\"
        method=\"post\"
        id=\"database-configuration\">

        <div class=\"card__body\">
            ";
        // line 14
        if ((($tmp = ($context["error"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 15
            yield "                <div class=\"alert alert-error\">
                    ";
            // line 16
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans(($context["error"] ?? null)), "html", null, true);
            yield "
                </div>
            ";
        }
        // line 19
        yield "
            <p>";
        // line 20
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_info"), "html", null, true);
        yield "</p>

            <p>
                <label for=\"hostname\">";
        // line 23
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_host"), "html", null, true);
        yield "</label>
                <input type=\"text\" value=\"";
        // line 24
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "hostname", [], "any", true, true, false, 24)) ? (Twig\Extension\CoreExtension::default(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "hostname", [], "any", false, false, false, 24), "localhost")) : ("localhost")), "html", null, true);
        yield "\" name=\"hostname\" id=\"hostname\" required=\"required\" />
            </p>

            <div class=\"form-group form-group--50\">
                <p>
                    <label for=\"username\">";
        // line 29
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_user"), "html", null, true);
        yield "</label>
                    <input type=\"text\" value=\"";
        // line 30
        yield (((\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "username", [], "any", true, true, false, 30) &&  !(null === \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "username", [], "any", false, false, false, 30)))) ? ($this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "username", [], "any", false, false, false, 30), "html", null, true)) : (""));
        yield "\" name=\"username\" id=\"username\" required=\"required\" />
                </p>

                <p>
                    <label for=\"password\">";
        // line 34
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_password"), "html", null, true);
        yield "</label>
                    <input type=\"password\" value=\"";
        // line 35
        yield (((\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "password", [], "any", true, true, false, 35) &&  !(null === \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "password", [], "any", false, false, false, 35)))) ? ($this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "password", [], "any", false, false, false, 35), "html", null, true)) : (""));
        yield "\" name=\"password\" id=\"password\" />
                </p>
            </div>

            <details ";
        // line 39
        if ((($tmp = \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "hasAdvancedSetting", [], "any", false, false, false, 39)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "open";
        }
        yield ">
                <summary>
                    <div class=\"custom-checkbox\">
                        <input
                            type=\"checkbox\"
                            name=\"advanced-settings\"
                            id=\"advanced\"
                            onchange=\"this.parentElement.click();\"
                            ";
        // line 47
        if ((($tmp = \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "hasAdvancedSetting", [], "any", false, false, false, 47)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "checked";
        }
        yield "/>
                        <label for=\"advanced\" class=\"toggle\">
                            ";
        // line 49
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_advanced_settings"), "html", null, true);
        yield "
                        </label>
                    </div>
                </summary>

                <div id=\"advanced-settings\">
                    <p>
                        <label for=\"port\">";
        // line 56
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_port"), "html", null, true);
        yield "</label>
                        <input type=\"text\" value=\"";
        // line 57
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "port", [], "any", false, false, false, 57), "html", null, true);
        yield "\" name=\"port\" id=\"port\" required=\"required\" />
                    </p>

                    <p>
                        <label for=\"sslCaPath\">";
        // line 61
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_ssl_ca_path"), "html", null, true);
        yield "</label>
                        <input type=\"text\" value=\"";
        // line 62
        yield (((\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslCaPath", [], "any", true, true, false, 62) &&  !(null === \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslCaPath", [], "any", false, false, false, 62)))) ? ($this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslCaPath", [], "any", false, false, false, 62), "html", null, true)) : (""));
        yield "\" name=\"sslCaPath\" id=\"sslCaPath\" />
                    </p>

                    <p>
                        <label for=\"sslCertPath\">";
        // line 66
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_ssl_cert_path"), "html", null, true);
        yield "</label>
                        <input type=\"text\" value=\"";
        // line 67
        yield (((\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslCertPath", [], "any", true, true, false, 67) &&  !(null === \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslCertPath", [], "any", false, false, false, 67)))) ? ($this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslCertPath", [], "any", false, false, false, 67), "html", null, true)) : (""));
        yield "\" name=\"sslCertPath\" id=\"sslCertPath\" />
                    </p>

                    <p>
                        <label for=\"sslCertKeyPath\">";
        // line 71
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_ssl_cert_key_path"), "html", null, true);
        yield "</label>
                        <input type=\"text\" value=\"";
        // line 72
        yield (((\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslCertKeyPath", [], "any", true, true, false, 72) &&  !(null === \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslCertKeyPath", [], "any", false, false, false, 72)))) ? ($this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslCertKeyPath", [], "any", false, false, false, 72), "html", null, true)) : (""));
        yield "\" name=\"sslCertKeyPath\" id=\"sslCertKeyPath\" />
                    </p>


                    <div class=\"custom-checkbox\">
                        <input type=\"checkbox\"
                               id=\"sslDontVerifyServerCert\"
                               name=\"sslDontVerifyServerCert\"
                               ";
        // line 80
        yield (((($tmp = \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "sslDontVerifyServerCert", [], "any", false, false, false, 80)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) ? ("checked") : (""));
        yield "/>
                        <label for=\"sslDontVerifyServerCert\">";
        // line 81
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_ssl_dont_verify_cert"), "html", null, true);
        yield "</label>
                    </div>
                </div>
            </details>

            <p>
                <label for=\"databaseName\">";
        // line 87
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_database"), "html", null, true);
        yield "</label>
                <input
                    type=\"text\"
                    value=\"";
        // line 90
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "databaseName", [], "any", false, false, false, 90), "html", null, true);
        yield "\"
                    name=\"databaseName\"
                    id=\"databaseName\"
                    required=\"required\"
                    onfocus=\"fetchDatabaseInformation();\"
                />
                <button id=\"databaseRefresh\" type=\"button\" class=\"database-refresh is--hidden\" href=\"#\" onclick=\"refreshDatabases();\" >";
        // line 96
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_refresh_databases"), "html", null, true);
        yield "</button>
            </p>
            <div id=\"non-empty-db-warning\" class=\"alert alert-warning is--hidden\">
                <span class=\"icon-warning\"></span>
                ";
        // line 100
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_non_empty_database"), "html", null, true);
        yield "
            </div>
            <div id=\"db-error\" class=\"alert alert-error is--hidden\">
                <span class=\"icon-warning\"></span>
                <span class=\"error-text\"></span>
            </div>
            <p>
                <div class=\"custom-checkbox create_database\">
                    <input
                        id=\"database_create_schema_new\"
                        type=\"checkbox\"
                        onchange=\"
                            document.getElementById('databaseName').disabled = this.checked;
                            document.getElementById('databaseName_new').disabled =!this.checked;

                            if (!this.checked) {
                                document.getElementById('databaseName_new').value = '';
                            }
                        \"/>
                    <label for=\"database_create_schema_new\">";
        // line 119
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.database-configuration_field_new_database"), "html", null, true);
        yield "</label>
                </div>

                <input type=\"text\" name=\"databaseName\" id=\"databaseName_new\" value=\"";
        // line 122
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["connectionInfo"] ?? null), "databaseName", [], "any", false, false, false, 122), "html", null, true);
        yield "\" disabled/>
            </p>

        </div>

        <div class=\"card__footer flex-container\">
            <a href=\"";
        // line 128
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getUrl("installer.license");
        yield "\" class=\"btn btn-default flex-item\">";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.back"), "html", null, true);
        yield "</a>
            <button type=\"submit\"
                    class=\"btn btn-primary flex-item flex-right\"
                    onclick=\"document.getElementById('database-configuration').classList.add('is--submitted')\">
                ";
        // line 132
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.start_installation"), "html", null, true);
        yield "
            </button>
        </div>
    </form>

    <script>
        async function fetchDatabaseInformation() {
            let dbs;
            try {
                dbs = await fetchDatabases();
            } catch(e) {
                return;
            }

            await createSelectFieldWithOptions(
                dbs,
                document.getElementById('databaseName').value
            );
        }

        function createSelectFieldWithOptions(data, oldValue) {
            if (Object.entries(data).length === 0) {
                return;
            }

            const element = document.createElement('div');
            element.classList.add('select-wrapper');

            const select = document.createElement('select');
            select.id = 'databaseName';
            select.name = 'databaseName';
            select.required = true;
            select.onchange = function(event) {
                const selectedDatabase = event.target.value;

                if (data[selectedDatabase] !== undefined && data[selectedDatabase]) {
                    document.getElementById('non-empty-db-warning').classList.remove('is--hidden');
                } else {
                    document.getElementById('non-empty-db-warning').classList.add('is--hidden');
                }
            };
            element.appendChild(select);

            addDatabasesToSelect(select, data, oldValue);

            select.dispatchEvent(new Event('change'));

            document.getElementById('databaseName').replaceWith(element);
            document.getElementById('databaseRefresh').classList.remove('is--hidden');
        }

        async function fetchDatabases() {
            const dbError = document.getElementById('db-error');
            dbError.classList.add('is--hidden');
            document.getElementById('non-empty-db-warning').classList.add('is--hidden');

            const form = new FormData(document.getElementById('database-configuration'));
            const response = await fetch('";
        // line 189
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getUrl("installer.database-information");
        yield "', {
                method: 'POST',
                body: form,
            })

            const data = await response.json();

            if (!response.ok) {
                dbError.querySelector('.error-text').innerText = data.error ?? ";
        // line 197
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("shopware.installer.db_fetch_error"), "html", null, true);
        yield ";
                dbError.classList.remove('is--hidden');

                throw new Error('Failed to fetch databases');
            }

            return data
        }

        function addDatabasesToSelect(select, dbs, oldValue) {
            let hasOldValue = false;
            Object.entries(dbs).forEach(function([key, value]) {
                const option = document.createElement('option');
                option.value = key;
                option.text = key;
                if (key === oldValue) {
                    hasOldValue = true;
                    option.selected = true;
                }

                select.add(option);
            });

            // default to the first empty database
            if (!hasOldValue) {
                for(const option of select.options) {
                    if (dbs[option.value] !== undefined && !dbs[option.value]) {
                        select.value = option.value;
                        break;
                    }
                }
            }

            select.dispatchEvent(new Event('change'));
        }

        async function refreshDatabases() {
            const select = document.getElementById('databaseName');
            const oldValue = document.getElementById('databaseName').value

            while (select.firstChild) {
                select.removeChild(select.firstChild);
            }


            let dbs;
            try {
                dbs = await fetchDatabases();
            } catch(e) {
                return;
            }

            addDatabasesToSelect(select, dbs, oldValue);
        }
    </script>
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@Installer/installer/database-configuration.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  360 => 197,  349 => 189,  289 => 132,  280 => 128,  271 => 122,  265 => 119,  243 => 100,  236 => 96,  227 => 90,  221 => 87,  212 => 81,  208 => 80,  197 => 72,  193 => 71,  186 => 67,  182 => 66,  175 => 62,  171 => 61,  164 => 57,  160 => 56,  150 => 49,  143 => 47,  130 => 39,  123 => 35,  119 => 34,  112 => 30,  108 => 29,  100 => 24,  96 => 23,  90 => 20,  87 => 19,  81 => 16,  78 => 15,  76 => 14,  68 => 9,  61 => 5,  58 => 4,  51 => 3,  40 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@Installer/installer/database-configuration.html.twig", "/www/public/vendor/shopware/core/Installer/Resources/views/installer/database-configuration.html.twig");
    }
}
