const i=`{% block sw_settings_delivery_time_detail %} <sw-page class="sw-settings-delivery-time-detail"> {% block sw_settings_delivery_time_detail_smart_bar_header %} <template #smart-bar-header> <h2>{{ displayName }}</h2> </template> {% endblock %} {% block sw_settings_delivery_time_detail_language_switch %} <template #language-switch> <sw-language-switch :disabled="!$route.params.id || undefined" @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_settings_delivery_time_detail_smart_bar_actions %} <template #smart-bar-actions> {% block sw_settings_delivery_time_detail_smart_bar_actions_cancel %} <mt-button v-tooltip.bottom="tooltipCancel" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_delivery_time_detail_smart_bar_actions_save %} <sw-button-process v-tooltip.bottom="tooltipSave" class="sw-settings-delivery-time-detail__save" :is-loading="isLoading" :process-success="isSaveSuccessful" :disabled="!allowSave || undefined" variant="primary" @update:process-success="saveFinish" @click.prevent="onSave" > {{ $tc('sw-settings-delivery-time.general.buttonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_settings_delivery_time_detail_content %} <template #content> <sw-card-view> <sw-skeleton v-if="isLoading" /> <template v-else> {% block sw_settings_delivery_time_language_info %} <sw-language-info :entity-description="displayName" :is-new-entity="!$route.params.id" /> {% endblock %} {% block sw_settings_delivery_time_detail_form %} <mt-card :is-loading="isLoading" position-identifier="sw-settings-delivery-time-detail-form" > <template v-if="deliveryTime"> {% block sw_settings_delivery_time_detail_name_field %} <mt-text-field v-model="deliveryTime.name" name="sw-field--deliveryTime-name" :label="$tc('sw-settings-delivery-time.detail.labelName')" :error="deliveryTimeNameError" :disabled="!acl.can('delivery_times.editor') || undefined" required /> {% endblock %} {% block sw_settings_delivery_time_detail_unit_field %} <sw-single-select v-model:value="deliveryTime.unit" name="sw-field--deliveryTime-unit" class="sw-delivery-time-detail__field-unit" :options="deliveryTimeUnits" :error="deliveryTimeUnitError" :label="$tc('sw-settings-delivery-time.detail.labelUnit')" :disabled="!acl.can('delivery_times.editor') || undefined" required show-clearable-button /> {% endblock %} {% block sw_settings_delivery_time_min_max_container %} <sw-container columns="1fr 1fr" gap="30px" > {% block sw_settings_delivery_time_detail_min_field %} <mt-number-field v-model="deliveryTime.min" name="sw-field--deliveryTime-min" :label="$tc('sw-settings-delivery-time.detail.labelMin')" :error="deliveryTimeMinError || invalidMinError" :min="0" :max="deliveryTime.max" :step="1" number-type="int" :disabled="!acl.can('delivery_times.editor') || undefined" required /> {% endblock %} {% block sw_settings_delivery_time_detail_max_field %} <mt-number-field v-model="deliveryTime.max" name="sw-field--deliveryTime-max" :label="$tc('sw-settings-delivery-time.detail.labelMax')" :error="deliveryTimeMaxError" :min="deliveryTime.min" :step="1" number-type="int" :disabled="!acl.can('delivery_times.editor') || undefined" required /> {% endblock %} </sw-container> {% endblock %} </template> </mt-card> {% endblock %} {% block sw_settings_delivery_time_detail_custom_field_sets %} <mt-card v-if="showCustomFields" position-identifier="sw-settings-delivery-time-detail-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="deliveryTime" :disabled="!acl.can('delivery_times.editor') || undefined" :sets="customFieldSets" /> </mt-card> {% endblock %} </template> </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Component:t,Mixin:s}=Shopware,l=Shopware.Classes.ShopwareError,{mapPropertyErrors:a}=t.getComponentHelper(),r={template:i,inject:["repositoryFactory","acl","customFieldDataProviderService"],mixins:[s.getByName("notification")],shortcuts:{"SYSTEMKEY+S":{active(){return this.allowSave},method:"onSave"},ESCAPE:"onCancel"},data(){return{deliveryTime:null,isLoading:!1,isSaveSuccessful:!1,customFieldSets:null}},metaInfo(){return{title:this.$createTitle()}},computed:{...a("deliveryTime",["name","min","max","unit"]),deliveryTimeRepository(){return this.repositoryFactory.create("delivery_time")},deliveryTimeUnits(){return[{value:"hour",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitHour")},{value:"day",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitDay")},{value:"week",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitWeek")},{value:"month",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitMonth")},{value:"year",label:this.$tc("sw-settings-delivery-time.detail.selectionUnitYear")}]},displayName(){return this.deliveryTime&&this.deliveryTime.name?this.deliveryTime.name:this.$tc("sw-settings-delivery-time.detail.textHeadlineNew")},isInvalidMinField(){return this.deliveryTime.min>this.deliveryTime.max},invalidMinError(){return this.isInvalidMinField?new l({code:"DELIVERY_TIME_MIN_INVALID"}):null},allowSave(){return this.deliveryTime?this.deliveryTime.isNew()?this.acl.can("delivery_times.creator"):this.acl.can("delivery_times.editor"):!1},tooltipSave(){return this.allowSave?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.allowSave,showOnDisabledElements:!0}},tooltipCancel(){return{message:"ESC",appearance:"light"}},showCustomFields(){return this.deliveryTime&&this.customFieldSets&&this.customFieldSets.length>0}},created(){this.createdComponent()},methods:{createdComponent(){this.isLoading=!0,this.loadCustomFieldSets(),this.deliveryTimeRepository.get(this.$route.params.id.toLowerCase()).then(e=>{this.deliveryTime=e,this.isLoading=!1}).catch(e=>{throw this.createNotificationError({message:this.$tc("sw-settings-delivery-time.detail.errorLoad")}),this.isLoading=!1,e})},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("delivery_time").then(e=>{this.customFieldSets=e})},onSave(){return this.isLoading=!0,this.isSaveSuccessful=!1,this.deliveryTimeRepository.save(this.deliveryTime,Shopware.Context.api).then(()=>{this.isLoading=!1,this.isSaveSuccessful=!0}).catch(e=>{throw this.createNotificationError({message:this.$tc("sw-settings-delivery-time.detail.errorSave")}),this.isLoading=!1,e})},onChangeLanguage(){this.createdComponent()},saveFinish(){this.isSaveSuccessful=!1},onCancel(){this.$router.push({name:"sw.settings.delivery.time.index"})}}};export{r as default};
