const{Mixin:w}=Shopware;w.register("theme",{inject:["repositoryFactory","themeService","acl"],data(){return{showDeleteModal:!1,showMediaModal:!1,showRenameModal:!1,showDuplicateModal:!1,newThemeName:"",modalTheme:null}},computed:{themeRepository(){return this.repositoryFactory.create("theme")}},methods:{onDeleteTheme(e){this.acl.can("theme.deleter")&&(this.modalTheme=e,this.showDeleteModal=!0)},onCloseDeleteModal(){this.showDeleteModal=!1,this.modalTheme=null},onConfirmThemeDelete(){this.deleteTheme(this.modalTheme),this.showDeleteModal=!1,this.modalTheme=null},deleteTheme(e){const t=this.$t("sw-theme-manager.components.themeListItem.notificationDeleteErrorTitle"),a=this.$t("sw-theme-manager.components.themeListItem.notificationDeleteErrorMessage");this.isLoading=!0,this.themeRepository.delete(e.id,Shopware.Context.api).then(()=>{if(this.getList){this.getList();return}this.$router.push({name:"sw.theme.manager.index"})}).catch(()=>{this.isLoading=!1,this.createNotificationError({title:t,message:a})})},onDuplicateTheme(e){this.acl.can("theme.creator")&&(this.modalTheme=e,this.showDuplicateModal=!0)},onCloseDuplicateModal(){this.showDuplicateModal=!1,this.modalTheme=null,this.newThemeName=""},onConfirmThemeDuplicate(){this.duplicateTheme(this.modalTheme,this.newThemeName),this.showDuplicateModal=!1,this.modalTheme=null,this.newThemeName=""},duplicateTheme(e,t){const a=this.themeRepository.create(Shopware.Context.api);a.name=t,a.parentThemeId=e.id,a.author=e.author,a.description=e.description,a.labels=e.labels,a.helpTexts=e.helpTexts,a.customFields=e.customFields,a.baseConfig=null,a.configValues=null,a.previewMediaId=e.previewMediaId,a.active=!0,this.themeRepository.save(a,Shopware.Context.api).then(()=>{this.$router.push({name:"sw.theme.manager.detail",params:{id:a.id}})})},onRenameTheme(e){this.acl.can("theme.editor")&&(this.modalTheme=e,this.newThemeName=this.modalTheme.name,this.showRenameModal=!0)},onCloseRenameModal(){this.showRenameModal=!1,this.modalTheme=null,this.newThemeName=""},onConfirmThemeRename(){this.RenameTheme(this.modalTheme,this.newThemeName),this.showRenameModal=!1,this.modalTheme=null,this.newThemeName=""},RenameTheme(e,t){t&&(e.name=t),this.themeRepository.save(e,Shopware.Context.api)}}});const f=`{% block sw_theme_manager_detail %} <sw-page class="sw-theme-manager-detail"> {% block sw_theme_manager_detail_search_bar %} <template #search-bar> <sw-search-bar :placeholder="$t('sw-theme-manager.general.placeholderSearchBar')" :entityService="themeRepository" @search="onSearch" ></sw-search-bar> </template> {% endblock %} {% block sw_theme_manager_detail_smart_bar_header %} <template #smart-bar-header> {% block sw_theme_manager_detail_smart_bar_header_title %} <h2 v-if="theme"> {% block sw_theme_manager_detail_smart_bar_header_title_text %} {{ theme.name }} {% endblock %} </h2> <h2 v-else> {% block sw_theme_manager_detail_smart_bar_header_title_text_default %} {{ $t('sw-theme-manager.list.textThemeOverview') }} {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_theme_manager_detail_smart_bar_actions %} <template #smart-bar-actions> <sw-button-group v-tooltip.bottom="{ message: $t('sw-privileges.tooltip.warning'), disabled: acl.can('theme.editor'), showOnDisabledElements: true }" class="sw-theme-manager-detail__save-button-group" :split-button="true" > {% block sw_theme_manager_detail_smart_bar_actions_save %} <sw-button-process v-tooltip.bottom="{ message: $t('sw-privileges.tooltip.warning'), disabled: acl.can('theme.editor'), showOnDisabledElements: true }" class="sw_theme_manager_detail__save-action" :is-loading="isLoading" :process-success="isSaveSuccessful" variant="primary" :disabled="isLoading || !acl.can('theme.editor')" @process-finish="saveFinish" @click.prevent="onSave" > {{ $t('global.default.save') }} </sw-button-process> {% endblock %} {% block sw_theme_manager_detail_smart_bar_actions_save_context_menu %} <sw-context-button> <template #button> <mt-button class="sw_theme_manager_detail__button-context-menu" square variant="primary" :disabled="isLoading || !acl.can('theme.editor')" size="default" > <mt-icon name="regular-chevron-down-xs" size="16" /> </mt-button> </template> {% block sw_theme_manager_detail_smart_bar_actions_save_context_menu_actions %} {% block sw_theme_manager_detail_smart_bar_actions_save_clean %} <sw-context-menu-item class="sw_theme_manager_detail__save-clean-action" :disabled="!acl.can('theme.editor')" @click="onSaveClean" v-tooltip.top="{ message: $t('sw-theme-manager.actions.saveCleanToolTip'), disabled: !acl.can('theme.editor'), showOnDisabledElements: true }" > {{ $t('sw-theme-manager.actions.saveClean') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_manager_detail_smart_bar_actions_validate %} <sw-context-menu-item class="sw_theme_manager_detail__validate-action" :disabled="!acl.can('theme.editor')" @click="onValidate" v-tooltip.top="{ message: $t('sw-theme-manager.actions.validateToolTip'), disabled: !acl.can('theme.editor'), showOnDisabledElements: true }" > {{ $t('sw-theme-manager.actions.validate') }} </sw-context-menu-item> {% endblock %} {% endblock %} </sw-context-button> {% endblock %} </sw-button-group> </template> {% endblock %} {% block sw_theme_manager_detail_content %} <template #content> <div v-if="!shouldShowContent" class="sw-theme-manager-detail__content-skeleton" > <sw-skeleton /> <sw-skeleton /> </div> <div v-else class="sw-theme-manager-detail__content"> <sw-tabs defaultItem="default" positionIdentifier="theme-manager-detail-tabs" @new-item-active="onChangeTab" > <template #default="{ active }"> <sw-tabs-item v-if="hasMoreThanOneTab" v-for="(tab, tabName) in structuredThemeFields.tabs" :key="tabName" :title="tab.label" :name="tabName" :active="active === tabName"> {{ tab.label || $t('sw-theme-manager.general.defaultTab') }} </sw-tabs-item> </template> <template #content="{ active }"> <template v-if="active === 'default'"> <template v-if="isDerived"> {% block sw_theme_manager_detail_content_inheritance %} <div class="sw-theme-manager-detail__inheritance"> {% block sw_theme_manager_detail_content_inheritance_icon %} <sw-icon size="20" name="regular-link-horizontal"></sw-icon> {% endblock %} {% block sw_theme_manager_detail_content_inheritance_text %} <p class="sw-theme-manager-detail__inheritance-text" v-if="parentTheme"> {{ $t('sw-theme-manager.detail.inheritanceInfo', { parentThemeName: parentTheme.name }) }} </p> <p class="sw-theme-manager-detail__inheritance-text" v-else-if="defaultTheme"> {{ $t('sw-theme-manager.detail.inheritanceInfo', { parentThemeName: defaultTheme.name }) }} </p> {% endblock %} </div> {% endblock %} </template> {% block sw_theme_manager_detail_content_info %} <sw-card class="sw-theme-manager-detail__info-card" positionIdentifier="theme-manager-detail-info" > <div class="sw-theme-manager-detail__info"> {% block sw_theme_manager_detail_content_info_image %} <div class="sw-theme-manager-detail__info-image" :style="previewMedia"></div> {% endblock %} {% block sw_theme_manager_detail_content_info_content %} <div class="sw-theme-manager-detail__info-content"> <div class="sw-theme-manager-detail__info-name">{{ theme.name }}</div> <div class="sw-theme-manager-detail__info-author">{{ theme.author }}</div> <div v-if="theme.description" class="sw-theme-manager-detail__info-descr"> <p class="sw-theme-manager-detail__info-descr-title"> {{ $t('sw-theme-manager.detail.description') }}: </p> <p>{{ theme.description |truncate(140) }}</p> </div> <sw-entity-multi-select v-model:entityCollection="theme.salesChannels" class="sw-theme-manager-detail__saleschannels-select" :label="$t('sw-theme-manager.detail.salesChannel')" :disabled="!acl.can('theme.editor')" :helpText="isDefaultTheme ? $t('sw-theme-manager.detail.salesChannelHelpText') : null" :placeholder="$t('sw-theme-manager.detail.placeholder.selectSalesChannel')" :selectionDisablingMethod="selectionDisablingMethod"> <template #result-item="{ item, index }"> <span v-if="!isThemeCompatible(item)"></span> </template> </sw-entity-multi-select> </div> {% endblock %} </div> {% block sw_theme_manager_detail_content_info_context_button %} <sw-context-button class="sw-theme-manager-detail__context-button" :zIndex="1100" > {% block sw_theme_manager_detail_context_button_option_rename %} <sw-context-menu-item :disabled="!acl.can('theme.editor')" @click="onRenameTheme(theme)" > {{ $t('sw-theme-manager.actions.rename') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_manager_detail_context_button_option_create %} <sw-context-menu-item v-if="theme.technicalName" :disabled="!acl.can('theme.creator')" @click="onDuplicateTheme(theme)" > {{ $t('sw-theme-manager.actions.duplicate') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_manager_detail_context_button_option_reset %} <sw-context-menu-item v-if="theme.configValues !== null" variant="danger" :disabled="!acl.can('theme.editor')" @click="onReset" > {{ $t('sw-theme-manager.actions.buttonReset') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_manager_detail_context_button_option_delete %} <sw-context-menu-item v-if="!theme.technicalName" v-tooltip.right="deleteDisabledToolTip" class="sw-theme-manager-detail__option-delete" variant="danger" :disabled="!acl.can('theme.deleter') || theme.salesChannels.length > 0" @click="onDeleteTheme(theme)" > {{ $t('global.default.delete') }} </sw-context-menu-item> {% endblock %} </sw-context-button> {% endblock %} </sw-card> {% endblock %} </template> <template v-for="(tab, tabName) in structuredThemeFields.tabs"> <template v-if="tabName === active"> {% block sw_theme_manager_detail_content_areas %} <sw-card v-for="(block, blockName) in tab.blocks" :key="blockName" class="sw-theme-manager-detail__area" positionIdentifier="theme-manager-detail-content" :title="block.label"> {% block sw_theme_manager_detail_content_sections %} <sw-card-section v-for="(section, sectionName) in block.sections" :key="sectionName"> <div v-if="section.label" class="sw-theme-manager-detail__content--section_title"> {{ section.label }} </div> {% block sw_theme_manager_detail_content_fields %} <sw-container class="sw-theme-manager-detail__content--section_field"> <div v-for="(field, fieldName) in section.fields" :key="fieldName" class="sw-theme-manager-detail__content--section_field" :class="{'sw-theme-manager-detail__content--section_field-full-width': field.fullWidth}"> <template v-if="themeConfig[fieldName] && baseThemeConfig[fieldName]"> <template v-if="mapSwFieldTypes(field.type) === 'select'"> <sw-inherit-wrapper :class="'sw-field-id-' + fieldName" v-model:value="currentThemeConfig[fieldName].value" :ref="\`wrapper-\${fieldName}\`" :has-parent="theme.baseConfig?.fields?.[fieldName] == null" :inherited-value="baseThemeConfig[fieldName].value" :label="!field.label ? '' : field.label" :customInheritationCheckFunction="checkInheritanceFunction(fieldName)" @update:value="handleInheritanceInput($event, fieldName)" > <template #content="{ currentValue, updateCurrentValue, isInherited }"> <sw-select-field v-model:value="currentValue" :placeholder="field.placeholder" :options="field.options" :helpText="!field.helpText ? null : field.helpText" :disabled="isInherited || !acl.can('theme.editor')" @update:value="updateCurrentValue" > </sw-select-field> </template> </sw-inherit-wrapper> </template> <template v-else-if="field.type === 'url'"> <sw-inherit-wrapper :class="'sw-field-id-' + fieldName" v-model:value="currentThemeConfig[fieldName].value" :ref="\`wrapper-\${fieldName}\`" :has-parent="theme.baseConfig?.fields?.[fieldName] == null" :inherited-value="baseThemeConfig[fieldName].value" :label="!field.label ? '' : field.label" :customInheritationCheckFunction="checkInheritanceFunction(fieldName)" @update:value="handleInheritanceInput($event, fieldName)" > <template #content="{ currentValue, updateCurrentValue, isInherited }"> <sw-url-field v-model:value="currentValue" :helpText="!field.helpText ? null : field.helpText" :disabled="isInherited || !acl.can('theme.editor')" @update:value="updateCurrentValue" > </sw-url-field> </template> </sw-inherit-wrapper> </template> <div v-else-if="field.type === 'media'"> <sw-upload-listener :uploadTag="tabName + '-' + blockName + '-' + sectionName + '-' + fieldName" @media-upload-finish="successfulUpload($event, currentThemeConfig[fieldName])" autoUpload> </sw-upload-listener> <sw-inherit-wrapper :class="'sw-field-id-' + fieldName" v-model:value="currentThemeConfig[fieldName].value" :ref="\`wrapper-\${fieldName}\`" :has-parent="theme.baseConfig?.fields?.[fieldName] == null" :inherited-value="baseThemeConfig[fieldName].value" :label="!field.label ? '' : field.label" :customInheritationCheckFunction="checkInheritanceFunction(fieldName)" @update:value="handleInheritanceInput($event, fieldName)" > <template #content="{ currentValue, updateCurrentValue, isInherited, removeInheritance }"> <sw-media-upload-v2 :source="currentValue" :uploadTag="tabName + '-' + blockName + '-' + sectionName + '-' + fieldName" :helpText="!field.helpText ? null : field.helpText" :ref="tabName + '-' + blockName + '-' + sectionName + '-' + fieldName" :defaultFolder="themeRepository.schema.entity" :allowMultiSelect="false" :disabled="!acl.can('theme.editor') || themeConfig[fieldName].editable === false" @media-drop="onDropMedia($event, currentThemeConfig[fieldName])" @media-upload-sidebar-open="onOpenMediaModal(fieldName)" @media-upload-remove-image="removeMediaItem(fieldName, updateCurrentValue, isInherited, removeInheritance)"> </sw-media-upload-v2> </template> </sw-inherit-wrapper> </div> <template v-else-if="mapSwFieldTypes(field.type)"> <sw-inherit-wrapper :class="'sw-field-id-' + fieldName" v-model:value="currentThemeConfig[fieldName].value" :ref="\`wrapper-\${fieldName}\`" :has-parent="theme.baseConfig?.fields?.[fieldName] == null" :inherited-value="baseThemeConfig[fieldName].value" :label="!field.label ? '' : field.label" :customInheritationCheckFunction="checkInheritanceFunction(fieldName)" @update:value="handleInheritanceInput($event, fieldName)" > <template #content="{ currentValue, updateCurrentValue, isInherited }"> <sw-colorpicker v-if="mapSwFieldTypes(field.type) === 'colorpicker'" :helpText="!field.helpText ? null : field.helpText" :disabled="isInherited || !acl.can('theme.editor') || themeConfig[fieldName].editable === false" :value="currentValue" zIndex="100" @update:value="updateCurrentValue" /> <mt-text-field v-else-if="mapSwFieldTypes(field.type) === 'text' || mapSwFieldTypes(field.type) === null" :helpText="!field.helpText ? null : field.helpText" :disabled="isInherited || !acl.can('theme.editor') || themeConfig[fieldName].editable === false" :model-value="cssValue(currentValue)" @update:modelValue="updateCurrentValue" /> </template> </sw-inherit-wrapper> </template> <template v-else-if="themeConfig[fieldName].editable !== false"> <sw-inherit-wrapper :class="'sw-field-id-' + fieldName" v-model:value="currentThemeConfig[fieldName].value" :ref="\`wrapper-\${fieldName}\`" :has-parent="theme.baseConfig?.fields?.[fieldName] == null" :inherited-value="baseThemeConfig[fieldName].value" :label="!field.label ? '' : field.label" :customInheritationCheckFunction="checkInheritanceFunction(fieldName)" @update:value="handleInheritanceInput($event, fieldName)" > <template #content="{ currentValue, updateCurrentValue, isInherited }"> <sw-form-field-renderer v-bind="getBind(field)" :value="currentValue" :disabled="isInherited || !acl.can('theme.editor')" @update:value="updateCurrentValue" > </sw-form-field-renderer> </template> </sw-inherit-wrapper> </template> </template> </div> </sw-container> {% endblock %} </sw-card-section> {% endblock %} </sw-card> {% endblock %} </template> </template> </template> </sw-tabs> </div> {% endblock %} {% block sw_theme_manager_reset_modal %} <sw-modal v-if="showResetModal" variant="small" :title="$t('sw-theme-manager.modal.modalTitleReset')" @modal-close="onCloseResetModal" > {% block sw_theme_manager_reset_modal_reset_text %} <p class="sw_theme_manager__confirm-reset-text"> {{ $t('sw-theme-manager.modal.modalTextResetInfo') }} </p> <p v-if="theme.salesChannels.length > 0" class="sw_theme_manager__confirm-reset-text"> {{ $t('sw-theme-manager.modal.modalTextResetAssigned') }} </p> {% endblock %} {% block sw_theme_manager_reset_modal_footer %} <template #modal-footer> {% block sw_theme_manager_reset_modal_cancel %} <mt-button size="small" variant="primary" @click="onCloseResetModal" > {{ $t('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_theme_manager_reset_modal_confirm %} <mt-button size="small" variant="critical" @click="onConfirmThemeReset" > {{ $t('sw-theme-manager.actions.buttonReset') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_theme_manager_detail_delete_modal %} <sw-modal v-if="showDeleteModal" @modal-close="onCloseDeleteModal" :title="$t('global.default.warning')" variant="small"> {% block sw_theme_manager_detail_delete_modal_info %} <div class="sw_theme_manager__confirm-delete-text"> {{ $t('sw-theme-manager.modal.textDeleteInfo', { themeName: theme.name }) }} </div> {% endblock %} {% block sw_theme_manager_detail_delete_modal_footer %} <template #modal-footer> {% block sw_theme_manager_detail_delete_modal_cancel %} <mt-button variant="secondary" size="small" @click="onCloseDeleteModal" > {{ $t('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_theme_manager_detail_delete_modal_confirm %} <mt-button variant="critical" size="small" @click="onConfirmThemeDelete" > {{ $t('global.default.delete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_theme_manager_detail_save_modal %} <sw-modal v-if="showSaveModal" class="sw-theme-manager-detail-modal" variant="large" :title="$t('sw-theme-manager.modal.modalTitleSave')" @modal-close="onCloseSaveModal" > {% block sw_theme_manager_detail_save_modal_info %} <div class="sw_theme_manager__confirm-save-text"> {{ $t('sw-theme-manager.modal.textSaveInfo', { themeName: theme.name }) }} </div> {% endblock %} {% block sw_theme_manager_detail_save_modal_already_assigned_warning %} <sw-alert v-if="overwrittenSalesChannelAssignments.length > 0" variant="warning"> <div class="sw-theme-manager-detail__sales-channel-warning" v-if="overwrittenSalesChannelAssignments.length === 1"> <span v-html="$t('sw-theme-manager.modal.salesChannelAlreadyAssignedModal.descriptionSingle', { newThemeName: theme.name })"></span> </div> <div class="sw-theme-manager-detail__sales-channel-warning" v-else> <span v-html="$t('sw-theme-manager.modal.salesChannelAlreadyAssignedModal.descriptionMultiple', { newThemeName: theme.name })"></span> </div> <div v-for="salesChannel in overwrittenSalesChannelAssignments"> <b>{{ salesChannel.oldThemeName }}</b> ({{ salesChannel.salesChannelName }}) </div> </sw-alert> {% endblock %} {% block sw_theme_manager_detail_save_modal_removed_warning %} <sw-alert v-if="removedSalesChannels.length > 0" variant="warning"> <div class="sw-theme-manager-detail__sales-channel-warning" v-if="removedSalesChannels.length === 1"> <span v-html="$t('sw-theme-manager.modal.salesChannelRemovedModal.descriptionSingle', { defaultThemeName: defaultTheme.name })"></span> </div> <div class="sw-theme-manager-detail__sales-channel-warning" v-else> <span v-html="$t('sw-theme-manager.modal.salesChannelRemovedModal.descriptionMultiple', { defaultThemeName: defaultTheme.name })"></span> </div> <div v-for="salesChannel in removedSalesChannels"> <b>{{ theme.name }}</b> ({{ salesChannel.name }}) </div> </sw-alert> {% endblock %} {% block sw_theme_manager_detail_save_modal_footer %} <template #modal-footer> {% block sw_theme_manager_detail_save_modal_cancel %} <mt-button variant="secondary" size="small" @click="onCloseSaveModal" > {{ $t('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_theme_manager_detail_save_modal_confirm %} <mt-button variant="primary" size="small" @click="onConfirmThemeSave" > {{ $t('global.default.save') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_theme_manager_detail_duplicate_modal %} <sw-modal v-if="showDuplicateModal" class="sw_theme_manager__duplicate-modal" @modal-close="onCloseDuplicateModal" :title="$t('sw-theme-manager.modal.modalTitleDuplicate')" variant="small"> {% block sw_theme_manager_detail_duplicate_modal_name_input %} <div class="sw_theme_manager__duplicate-info"> {{ $t('sw-theme-manager.modal.textDuplicateInfo') }} </div> <sw-text-field v-model:value="newThemeName" name="sw-field--duplicate-theme-name" :label="$t('sw-theme-manager.modal.labelDuplicateThemeName')" :placeholder="$t('sw-theme-manager.modal.placeholderDuplicateThemeName')" /> {% endblock %} {% block sw_theme_manager_detail_duplicate_modal_footer %} <template #modal-footer> {% block sw_theme_manager_detail_duplicate_modal_cancel %} <mt-button variant="primary" size="small" @click="onCloseDuplicateModal" > {{ $t('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_theme_manager_detail_duplicate_modal_confirm %} <mt-button variant="primary" :disabled="newThemeName.length < 3" size="small" @click="onConfirmThemeDuplicate" > {{ $t('sw-theme-manager.modal.buttonDuplicateTheme') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_theme_manager_detail_rename_modal %} <sw-modal v-if="showRenameModal" class="sw_theme_manager__rename-modal" @modal-close="onCloseRenameModal" :title="$t('sw-theme-manager.modal.modalTitleRename')" variant="small"> {% block sw_theme_manager_detail_rename_modal_name_input %} <div class="sw_theme_manager__rename-info"> {{ $t('sw-theme-manager.modal.textRenameInfo') }} </div> <sw-text-field v-model:value="newThemeName" name="sw-field--rename-theme-name" :label="$t('sw-theme-manager.modal.labelRenameThemeName')" :placeholder="$t('sw-theme-manager.modal.placeholderRenameThemeName')" /> {% endblock %} {% block sw_theme_manager_detail_rename_modal_footer %} <template #modal-footer> {% block sw_theme_manager_detail_rename_modal_cancel %} <mt-button variant="secondary" size="small" @click="onCloseRenameModal" > {{ $t('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_theme_manager_detail_rename_modal_confirm %} <mt-button variant="primary" :disabled="newThemeName.length < 3" size="small" @click="onConfirmThemeRename" > {{ $t('global.default.save') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_theme_manager_detail_error_modal %} <sw-modal v-if="errorModalMessage" @modal-close="onCloseErrorModal" :title="$t('sw-theme-manager.modal.errorModalTitle')" variant="large"> {% block sw_theme_manager_detail_error_modal_message %} <pre style="white-space: pre-line;">{{ errorModalMessage }}</pre> {% endblock %} {% block sw_theme_manager_detail_error_modal_footer %} <template #modal-footer> {% block sw_theme_manager_detail_error_modal_close %} <mt-button variant="secondary" size="small" @click="onCloseErrorModal" > {{ $t('global.default.close') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_theme_manager_detail_media_modal %} <sw-media-modal-v2 v-if="showMediaModal" :initial-folder-id="defaultMediaFolderId" :allow-multi-select="false" @media-modal-selection-change="onMediaChange" @modal-close="onCloseMediaModal" /> {% endblock %} </template> {# @deprecated tag:v6.8.0 - Will be removed, use block sw_theme_manager_detail_media_modal instead. #} {% block sw_theme_manager_detail_sidebar %} <template #sidebar> <sw-sidebar :propagateWidth="true"> {# @deprecated tag:v6.8.0 - Will be removed. #} {% block sw_theme_manager_detail_sidebar_media %} <sw-sidebar-media-item ref="mediaSidebarItem" :initialFolderId="defaultMediaFolderId"> <template #context-menu-items="media"> {# @deprecated tag:v6.8.0 - Will be removed. #} {% block sw_theme_manager_detail_sidebar_media_items %} <template v-if="shouldShowContent"> <template v-for="(tab, tabName) in structuredThemeFields.tabs"> <template v-for="block in tab.blocks"> <template v-for="section in block.sections"> <template v-for="(field, fieldName) in section.fields"> <sw-context-menu-item v-if="themeConfig[fieldName] && field.type === 'media'" :key="fieldName" @click="onAddMediaToTheme(media.mediaItem, currentThemeConfig[fieldName])" > {{ $t('sw-theme-manager.modal.addToMediaLabel', { name: field.label }) }} </sw-context-menu-item> </template> </template> </template> </template> </template> {% endblock %} </template> </sw-sidebar-media-item> {% endblock %} </sw-sidebar> </template> {% endblock %} </sw-page> {% endblock %}`,{Component:b,Mixin:g}=Shopware,n=Shopware.Data.Criteria,{getObjectDiff:v,cloneDeep:u,deepMergeObject:k}=Shopware.Utils.object,{isArray:m}=Shopware.Utils.types;b.register("sw-theme-manager-detail",{template:f,inject:["acl","feature"],mixins:[g.getByName("theme"),g.getByName("notification")],data(){return{theme:null,parentTheme:!1,defaultMediaFolderId:null,structuredThemeFields:{},themeConfig:{},currentThemeConfig:{},showResetModal:!1,showSaveModal:!1,errorModalMessage:null,baseThemeConfig:{},currentThemeConfigInitial:{},inheritanceChanged:[],isLoading:!1,isSaveSuccessful:!1,mappedFields:{color:"colorpicker",fontFamily:"text"},defaultTheme:null,themeCompatibleSalesChannels:[],salesChannelsWithTheme:null,newAssignedSalesChannels:[],overwrittenSalesChannelAssignments:[],removedSalesChannels:[],showMediaModal:!1,activeMediaField:null}},metaInfo(){return{title:this.$createTitle(this.themeName)}},computed:{themeName(){return this.theme?this.theme.name:""},isDerived(){var e,t;return!this.theme||this.theme.technicalName==="Storefront"?!1:this.parentTheme?!0:!(m((t=(e=this.theme)==null?void 0:e.baseConfig)==null?void 0:t.configInheritance)&&!this.theme.baseConfig.configInheritance.includes("@Storefront"))},mediaRepository(){return this.repositoryFactory.create("media")},defaultFolderRepository(){return this.repositoryFactory.create("media_default_folder")},salesChannelRepository(){return this.repositoryFactory.create("sales_channel")},previewMedia(){return this.theme&&this.theme.previewMedia&&this.theme.previewMedia.id&&this.theme.previewMedia.url?{"background-image":`url('${this.theme.previewMedia.url}')`,"background-size":"cover"}:{"background-image":this.defaultThemeAsset}},defaultThemeAsset(){return`url(${Shopware.Filter.getByName("asset")("administration/static/img/theme/default_theme_preview.jpg")})`},deleteDisabledToolTip(){return{showDelay:300,message:this.$t("sw-theme-manager.actions.deleteDisabledToolTip"),disabled:this.theme.salesChannels.length===0}},themeId(){return this.$route.params.id},shouldShowContent(){return Object.values(this.structuredThemeFields).length>0&&!this.isLoading},hasMoreThanOneTab(){return Object.values(this.structuredThemeFields.tabs).length>1},isDefaultTheme(){return this.theme.id===this.defaultTheme.id}},created(){this.createdComponent()},watch:{themeId(){this.getTheme()}},methods:{createdComponent(){this.getTheme(),this.setPageContext()},cssValue(e){return e?(e=e.toString(),e.replace(/`|´/g,"")):""},getTheme(){if(!this.themeId)return;this.isLoading=!0;const e=new n;e.addAssociation("previewMedia"),e.addAssociation("salesChannels"),this.themeRepository.get(this.themeId,Shopware.Context.api,e).then(t=>{this.theme=t,this.getThemeConfig(),this.theme.parentThemeId&&this.getParentTheme(),this.isLoading=!1})},checkInheritanceFunction(e){return()=>this.currentThemeConfig[e].isInherited},handleInheritanceInput(e,t){this.currentThemeConfig[t].isInherited=e===null},getThemeConfig(){this.isLoading=!0,!(!this.theme||!this.themeId)&&(this.structuredThemeFields={},this.currentThemeConfig={},this.themeConfig={},this.baseThemeConfig={},this.currentThemeConfigInitial={},this.themeService.getStructuredFields(this.themeId).then(e=>{this.structuredThemeFields=e}),this.themeService.getConfiguration(this.themeId).then(e=>{this.currentThemeConfig=e.currentFields,this.currentThemeConfigInitial=u(this.currentThemeConfig),this.themeConfig=e.fields,this.baseThemeConfig=u(e.baseThemeFields),this.isLoading=!1}))},setPageContext(){this.getDefaultTheme().then(e=>{this.defaultTheme=e}),this.getDefaultFolderId().then(e=>{this.defaultMediaFolderId=e}),this.getThemeCompatibleSalesChannels().then(e=>{this.themeCompatibleSalesChannels=e}),this.getSalesChannelsWithTheme().then(e=>{this.salesChannelsWithTheme=e})},getParentTheme(){this.themeRepository.get(this.theme.parentThemeId).then(e=>{this.parentTheme=e})},openMediaSidebar(){this.$refs.mediaSidebarItem.openContent()},onAddMediaToTheme(e,t){this.setMediaItem(e,t)},onDropMedia(e,t){this.setMediaItem(e,t)},setMediaItem(e,t){t.value=e.id},successfulUpload(e,t){this.mediaRepository.get(e.targetId).then(a=>(this.setMediaItem(a,t),!0))},removeMediaItem(e,t,a,s){this.currentThemeConfig[e].value=null,this.themeConfig[e].value=null,a?t(null):s(null),this.currentThemeConfigInitial[e].value=!1},restoreMediaInheritance(e,t){return e},onReset(){this.acl.can("theme.editor")&&this.theme.configValues!==null&&(this.showResetModal=!0)},onCloseResetModal(){this.showResetModal=!1},onCloseErrorModal(){this.errorModalMessage=null},onConfirmThemeReset(){this.acl.can("theme.editor")&&(this.themeService.resetTheme(this.themeId).then(()=>{this.getTheme()}),this.showResetModal=!1)},onSave(){if(this.findChangedSalesChannels(),this.theme.salesChannels.length>0||this.removedSalesChannels.length>0){this.showSaveModal=!0;return}return this.onSaveTheme()},onSaveClean(){if(this.findChangedSalesChannels(),this.theme.salesChannels.length>0||this.removedSalesChannels.length>0){this.showSaveModal=!0;return}return this.onSaveTheme(!0)},onCloseSaveModal(){this.showSaveModal=!1},onConfirmThemeSave(){this.onSaveTheme(),this.showSaveModal=!1},onValidate(){if(!this.acl.can("theme.editor"))return;this.isLoading=!0;const e=this.getCurrentChangeset();return this.removeInheritedFromChangeset(e),this.themeService.validateFields(k(this.themeConfig,e)).then(()=>{this.isLoading=!1,this.createNotificationSuccess({title:this.$t("sw-theme-manager.detail.validate.success"),message:this.$t("sw-theme-manager.detail.validate.successMessage"),autoClose:!0})}).catch(t=>{this.isLoading=!1;const a=t.response.data.errors[0];if(a.code==="THEME__INVALID_SCSS_VAR"){this.createNotificationError({title:this.$t("sw-theme-manager.detail.validate.failed"),message:this.$t("sw-theme-manager.detail.validate.failedMessage"),autoClose:!1,actions:[{label:this.$t("sw-theme-manager.detail.showFullError"),method:(function(){this.errorModalMessage=a.detail}).bind(this)}]});return}this.createNotificationError({message:a.detail??t.toString(),autoClose:!0})})},onSaveTheme(e=!1){if(this.acl.can("theme.editor"))return this.isSaveSuccessful=!1,this.isLoading=!0,Promise.all([this.saveSalesChannels(),this.saveThemeConfig(e)]).finally(()=>{this.getTheme()}).catch(t=>{this.isLoading=!1;const a=t.response.data.errors[0];if(a.code==="THEME__COMPILING_ERROR"||a.code==="THEME__INVALID_SCSS_VAR"){this.createNotificationError({title:this.$t("sw-theme-manager.detail.error.themeCompile.title"),message:this.$t("sw-theme-manager.detail.error.themeCompile.message"),autoClose:!1,actions:[{label:this.$t("sw-theme-manager.detail.showFullError"),method:(function(){this.errorModalMessage=a.detail}).bind(this)}]});return}this.createNotificationError({message:a.detail??t.toString(),autoClose:!0})})},saveSalesChannels(){const e=[];return this.newAssignedSalesChannels.length>0&&this.newAssignedSalesChannels.forEach(t=>{e.push(this.themeService.assignTheme(this.themeId,t))}),this.removedSalesChannels.length>0&&this.removedSalesChannels.forEach(t=>{e.push(this.themeService.assignTheme(this.defaultTheme.id,t.id))}),Promise.all(e)},findChangedSalesChannels(){this.newAssignedSalesChannels=[],this.removedSalesChannels=[],this.overwrittenSalesChannelAssignments=[];const e=this.themeRepository.getSyncChangeset([this.theme]);e.changeset.length>0&&e.changeset[0].changes.hasOwnProperty("salesChannels")&&this.findAddedSalesChannels(e.changeset[0].changes.salesChannels),e.deletions.length>0&&this.findRemovedSalesChannels(e.deletions)},findAddedSalesChannels(e){e.forEach(t=>{this.newAssignedSalesChannels.push(t.id);const a=this.salesChannelsWithTheme.get(t.id);a!==null&&this.overwrittenSalesChannelAssignments.push({id:t.id,salesChannelName:this.theme.salesChannels.get(t.id).translated.name,oldThemeName:a.extensions.themes[0].name})})},findRemovedSalesChannels(e){e.forEach(t=>{this.removedSalesChannels.push({id:t.key,name:this.theme.getOrigin().salesChannels.get(t.key).translated.name})})},getCurrentChangeset(e=!1){const t=v(this.currentThemeConfigInitial,this.currentThemeConfig),a=this.theme.configValues??{};if(Object.assign(a,t),!e)return a;const s={};for(const[i,l]of Object.entries(a))this.themeConfig[i]===void 0||this.themeConfig[i].type===void 0||this.themeConfig[i].type===null||(s[i]=l);return s},removeInheritedFromChangeset(e){for(const t of Object.keys(e)){if(this.wrapperIsVisible(t)&&this.$refs[`wrapper-${t}`][0].isInherited){delete e[`${t}`];continue}!this.wrapperIsVisible(t)&&this.inheritanceChanged[`wrapper-${t}`]!==void 0&&this.inheritanceChanged[`wrapper-${t}`]===!0&&delete e[`${t}`]}},wrapperIsVisible(e){return this.$refs[`wrapper-${e}`]!==void 0&&m(this.$refs[`wrapper-${e}`])&&this.$refs[`wrapper-${e}`][0]!==void 0},saveThemeConfig(e=!1){const t=this.getCurrentChangeset(e);return this.removeInheritedFromChangeset(t),this.themeService.updateTheme(this.themeId,{config:t},{reset:!0})},saveFinish(){this.isSaveSuccessful=!1},onSearch(e=null){!e.length||e.length<=0?this.term=null:this.term=e},onChangeTab(){for(const[e,t]of Object.entries(this.$refs))e.startsWith("wrapper-")&&t!==void 0&&m(t)&&t[0]!==void 0&&(this.inheritanceChanged[e]=t[0].isInherited)},mapSwFieldTypes(e){return this.mappedFields[e]?this.mappedFields[e]:null},getThemeCompatibleSalesChannels(){const e=new n;return e.addAssociation("type"),e.addFilter(n.equalsAny("type.name",["Storefront","Headless"])),this.salesChannelRepository.search(e).then(t=>t.getIds())},getSalesChannelsWithTheme(){const e=new n;return e.addAssociation("themes"),e.addFilter(n.not("or",[n.equals("themes.id",null)])),this.salesChannelRepository.search(e).then(t=>t)},getDefaultFolderId(){const e=new n(1,1);return e.addAssociation("folder"),e.addFilter(n.equals("entity",this.themeRepository.schema.entity)),this.defaultFolderRepository.search(e).then(t=>{const a=t.first();return a.folder.id?a.folder.id:null})},getDefaultTheme(){const e=new n;return e.addFilter(n.equals("technicalName","Storefront")),this.themeRepository.search(e).then(t=>t.first())},getBind(e){var a,s,i,l;const t=Object.assign({},e);return(t==null?void 0:t.type)!=="switch"&&(t==null?void 0:t.type)!=="checkbox"&&((a=t.custom)==null?void 0:a.componentName)!=="sw-switch-field"&&((s=t.custom)==null?void 0:s.componentName)!=="sw-checkbox-field"&&(t.label=""),delete t.type,Object.assign(t,t.custom),((i=t.custom)==null?void 0:i.componentName)!=="sw-switch-field"&&((l=t.custom)==null?void 0:l.componentName)!=="sw-checkbox-field"&&delete t.custom,{type:e.type,config:t}},selectionDisablingMethod(e){return this.isDefaultTheme?this.theme.getOrigin().salesChannels.has(e.id):!1},isThemeCompatible(e){return this.themeCompatibleSalesChannels.includes(e.id)},onOpenMediaModal(e){this.showMediaModal=!0,this.activeMediaField=e},onCloseMediaModal(){this.showMediaModal=!1,this.activeMediaField=null},onMediaChange(e){!e||!e.length||this.onAddMediaToTheme(e[0],this.currentThemeConfig[this.activeMediaField])}}});const C=`{% block sw_theme_manager_list %} <sw-page class="sw-theme-list"> {% block sw_theme_manager_list_search_bar %} <template #search-bar> <sw-search-bar :placeholder="$t('sw-theme-manager.general.placeholderSearchBar')" :initialSearchType="$t('sw-theme-manager.general.mainMenuItemGeneral')" @search="onSearch"> </sw-search-bar> </template> {% endblock %} {% block sw_theme_manager_list_toolbar %} <template #smart-bar-header> <h2> {{ $t('sw-theme-manager.general.mainMenuItemGeneral') }}</h2> </template> {% endblock %} {% block sw_theme_list_card_view %} <template #content> <sw-card-view> {% block sw_themes_list_listing %} <div class="sw-theme-list__content"> {% block sw_theme_list_listing_actions %} <div class="sw-theme-list__actions"> {% block sw_theme_list_listing_title %} <h3>{{ $t('sw-theme-manager.general.mainMenuHeader') }}</h3> {% endblock %} {% block sw_theme_list_listing_actions_sorting %} <div class="sw-theme-list__actions-sorting"> <sw-sorting-select :sort-by="sortBy" :sort-direction="sortDirection" @sorting-changed="onSortingChanged" /> </div> {% endblock %} {% block sw_theme_list_listing_actions_mode %} <div class="sw-theme-list__actions-mode" @click="onListModeChange" > <mt-icon v-if="listMode === 'grid'" name="regular-view-normal" size="16" /> <mt-icon v-if="listMode === 'list'" name="regular-view-grid" size="16" /> </div> {% endblock %} </div> {% endblock %} {% block sw_theme_list_listing_list %} <div class="sw-theme-list__list"> {% block sw_theme_list_listing_list_card %} <sw-card class="sw-theme-list__list-card" v-if="listMode === 'list'"> <template #grid> {% block sw_theme_list_listing_list_data_grid %} <sw-data-grid class="sw-theme-list__list-data-grid" identifier="sw-theme-list" :isLoading="isLoading" :dataSource="themes" :columns="columnConfig" :skeletonItemAmount="limit" :sortBy="sortBy" :sortDirection="sortDirection" :allowInlineEdit="false" :allowColumnEdit="false" :showSettings="false" :showSelection="false" @column-sort="onSortColumn"> {% block sw_theme_list_listing_list_data_grid_column_name %} <template #column-name="{ item }"> <sw-icon name="regular-lock" class="sw-theme-list__icon-lock" v-if="item.technicalName" v-tooltip="lockToolTip" size="14"> </sw-icon> <router-link :to="{ name: 'sw.theme.manager.detail', params: { id: item.id } }"> {{ item.name }} </router-link> </template> {% endblock %} {% block sw_theme_list_listing_list_data_grid_column_assignment %} <template #column-assignment="{ item }"> {{ item.salesChannels.length }} </template> {% endblock %} {% block sw_theme_list_listing_list_data_grid_column_created %} <template #column-createdAt="{ item }"> {{ dateFilter(item.createdAt, { hour: '2-digit', minute: '2-digit' }) }} </template> {% endblock %} {% block sw_theme_list_listing_list_data_grid_actions %} <template #actions="{ item }"> {% block sw_theme_list_listing_list_data_grid_actions_edit %} <sw-context-menu-item class="sw-theme-list-item__option-edit" :routerLink="{ name: 'sw.theme.manager.detail', params: { id: item.id } }"> {{ $t('global.default.edit') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_list_listing_list_data_grid_actions_rename %} <sw-context-menu-item @click="onRenameTheme(item)" class="sw-theme-list-item__option-rename" :disabled="!acl.can('theme.editor')"> {{ $t('sw-theme-manager.themeListItem.rename') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_list_listing_list_data_grid_actions_delete %} <sw-context-menu-item variant="danger" class="sw-theme-list-item__option-delete" :disabled="item.salesChannels.length > 0 || !acl.can('theme.deleter')" v-tooltip="deleteDisabledToolTip(item)" @click="onDeleteTheme(item)" v-if="!item.technicalName"> {{ $t('global.default.delete') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_list_listing_list_data_grid_actions_create %} <sw-context-menu-item v-if="item.technicalName" class="sw-theme-list-item__option-duplicate" @click="onDuplicateTheme(item)" :disabled="!acl.can('theme.creator')"> {{ $t('sw-theme-manager.actions.duplicate') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_theme_list_listing_list_data_grid_pagination %} <template #pagination> <sw-pagination :page="page" :limit="limit" :total="total" :steps="[5, 10, 25, 50]" @page-change="onPageChange"> </sw-pagination> </template> {% endblock %} </sw-data-grid> {% endblock %} </template> </sw-card> {% endblock %} {% block sw_theme_list_listing_list_grid %} <div class="sw-theme-list__list-grid" v-if="listMode === 'grid'"> {% block sw_theme_list_listing_list_grid_content %} <div class="sw-theme-list__list-grid-content"> {% block sw_theme_list_listing_list_item %} <template v-if="!isLoading"> <sw-theme-list-item v-for="theme in themes" :theme="theme" :key="theme.id" @preview-image-change="onPreviewChange" @item-click="onListItemClick" > <template #contextMenu> <sw-context-button :zIndex="1100" class="sw-theme-list-item__options" > {% block sw_theme_list_listing_list_item_option_add_preview %} <sw-context-menu-item class="sw-theme-list-item__option-preview" :disabled="!acl.can('theme.editor')" @click="onPreviewChange(theme)" > {{ $t('sw-theme-manager.themeListItem.addPreviewImage') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_list_listing_list_item_option_remove_preview %} <sw-context-menu-item v-if="theme.previewMediaId" variant="danger" class="sw-theme-list-item__option-preview sw-theme-list-item__option-preview-remove" :disabled="!acl.can('theme.editor')" @click="onPreviewImageRemove(theme)" > {{ $t('sw-theme-manager.themeListItem.removePreviewImage') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_list_listing_list_item_option_rename %} <sw-context-menu-item class="sw-theme-list-item__option-rename" :disabled="!acl.can('theme.editor')" @click="onRenameTheme(theme)" > {{ $t('sw-theme-manager.themeListItem.rename') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_list_listing_list_item_option_create %} <sw-context-menu-item v-if="theme.technicalName" class="sw-theme-list-item__option-duplicate" :disabled="!acl.can('theme.creator')" @click="onDuplicateTheme(theme)" > {{ $t('sw-theme-manager.actions.duplicate') }} </sw-context-menu-item> {% endblock %} {% block sw_theme_list_listing_list_item_option_delete %} <sw-context-menu-item v-if="!theme.technicalName" v-tooltip="deleteDisabledToolTip(theme)" class="sw-theme-list-item__option-delete" variant="danger" :disabled="theme.salesChannels.length > 0 || !acl.can('theme.deleter')" @click="onDeleteTheme(theme)" > {{ $t('global.default.delete') }} </sw-context-menu-item> {% endblock %} </sw-context-button> </template> </sw-theme-list-item> </template> <template v-else> <sw-skeleton variant="gallery" /> <sw-skeleton variant="gallery" /> <sw-skeleton variant="gallery" /> <sw-skeleton variant="gallery" /> <sw-skeleton variant="gallery" /> <sw-skeleton variant="gallery" /> <sw-skeleton variant="gallery" /> <sw-skeleton variant="gallery" /> <sw-skeleton variant="gallery" /> </template> {% endblock %} </div> {% endblock %} {% block sw_theme_list_listing_pagination %} <sw-pagination class="sw-theme-list__list-pagination" v-if="!isLoading" :page="page" :limit="limit" :total="total" :steps="[9]" @page-change="onPageChange"> </sw-pagination> {% endblock %} </div> {% endblock %} </div> {% endblock %} </div> {% endblock %} {% block sw_theme_list_media_modal %} <sw-media-modal-v2 v-if="showMediaModal" :caption="$t('sw-theme-manager.general.captionMediaUpload')" entityContext="theme" :allowMultiSelect="false" @media-modal-selection-change="onPreviewImageChange" @modal-close="onModalClose" ></sw-media-modal-v2> {% endblock %} {% block sw_theme_list_delete_modal %} <sw-modal v-if="showDeleteModal" :title="$t('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_theme_list_delete_modal_info %} <div class="sw_theme_manager__confirm-delete-text"> {{ $t('sw-theme-manager.modal.textDeleteInfo', { themeName: modalTheme.name }) }} </div> {% endblock %} {% block sw_theme_list_delete_modal_footer %} <template #modal-footer> {% block sw_theme_list_delete_modal_cancel %} <mt-button variant="secondary" size="small" @click="onCloseDeleteModal" > {{ $t('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_theme_list_delete_modal_confirm %} <mt-button variant="critical" size="small" @click="onConfirmThemeDelete" > {{ $t('global.default.delete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_theme_list_duplicate_modal %} <sw-modal v-if="showDuplicateModal" class="sw_theme_manager__duplicate-modal" @modal-close="onCloseDuplicateModal" :title="$t('sw-theme-manager.modal.modalTitleDuplicate')" variant="small"> {% block sw_theme_list_duplicate__modal_name_input %} <div class="sw_theme_manager__duplicate-info"> {{ $t('sw-theme-manager.modal.textDuplicateInfo') }} </div> <sw-text-field v-model:value="newThemeName" name="sw-field--duplicate-theme-name" :label="$t('sw-theme-manager.modal.labelDuplicateThemeName')" :placeholder="$t('sw-theme-manager.modal.placeholderDuplicateThemeName')" /> {% endblock %} {% block sw_theme_list_duplicate_modal_footer %} <template #modal-footer> {% block sw_theme_list_duplicate_modal_cancel %} <mt-button variant="secondary" size="small" @click="onCloseDuplicateModal" > {{ $t('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_theme_list_duplicate_modal_confirm %} <mt-button variant="primary" :disabled="newThemeName.length < 3" size="small" @click="onConfirmThemeDuplicate" > {{ $t('sw-theme-manager.modal.buttonDuplicateTheme') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_theme_list_rename_modal %} <sw-modal v-if="showRenameModal" class="sw_theme_manager__rename-modal" @modal-close="onCloseRenameModal" :title="$t('sw-theme-manager.modal.modalTitleRename')" variant="small"> {% block sw_theme_list_rename__modal_name_input %} <div class="sw_theme_manager__rename-info"> {{ $t('sw-theme-manager.modal.textRenameInfo') }} </div> <sw-text-field v-model:value="newThemeName" name="sw-field--rename-theme-name" :label="$t('sw-theme-manager.modal.labelRenameThemeName')" :placeholder="$t('sw-theme-manager.modal.placeholderRenameThemeName')" /> {% endblock %} {% block sw_theme_list_rename_modal_footer %} <template #modal-footer> {% block sw_theme_list_rename_modal_cancel %} <mt-button variant="secondary" size="small" @click="onCloseRenameModal" > {{ $t('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_theme_list_rename_modal_confirm %} <mt-button variant="primary" :disabled="newThemeName.length < 3" size="small" @click="onConfirmThemeRename" > {{ $t('global.default.save') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Component:T,Mixin:d}=Shopware,h=Shopware.Data.Criteria;T.register("sw-theme-manager-list",{template:C,inject:["acl"],mixins:[d.getByName("notification"),d.getByName("listing"),d.getByName("theme")],data(){return{themes:[],isLoading:!1,total:0,disableRouteParams:!0,salesChannelId:this.$route.params.id,listMode:"grid",sortBy:"createdAt",sortDirection:"DESC",limit:9,term:null}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{languageRepository(){return this.repositoryFactory.create("language")},columnConfig(){return this.getColumnConfig()},sortOptions(){return[{value:"createdAt:DESC",label:this.$t("sw-theme-manager.sorting.labelSortByCreatedDsc")},{value:"createdAt:ASC",label:this.$t("sw-theme-manager.sorting.labelSortByCreatedAsc")},{value:"updatedAt:DESC",label:this.$t("sw-theme-manager.sorting.labelSortByUpdatedDsc")},{value:"updatedAt:ASC",label:this.$t("sw-theme-manager.sorting.labelSortByUpdatedAsc")}]},sortingConCat(){return`${this.sortBy}:${this.sortDirection}`},lockToolTip(){return{showDelay:100,message:this.$t("sw-theme-manager.general.lockedToolTip")}},dateFilter(){return Shopware.Filter.getByName("date")}},methods:{onRefresh(){this.getList()},getList(){this.isLoading=!0;const e=new h(this.page,this.limit);return e.addAssociation("previewMedia"),e.addAssociation("salesChannels"),e.addSorting(h.sort(this.sortBy,this.sortDirection)),e.addFilter(h.equals("active",!0)),this.term!==null&&e.setTerm(this.term),this.themeRepository.search(e,Shopware.Context.api).then(t=>(this.total=t.total,this.themes=t,this.isLoading=!1,this.pages)).catch(()=>{this.isLoading=!1})},resetList(){this.page=1,this.themes=[],this.updateRoute({page:this.page,limit:this.limit,term:this.term,sortBy:this.sortBy,sortDirection:this.sortDirection}),this.getList()},onChangeLanguage(e){Shopware.Context.api.languageId=e,this.resetList()},onListItemClick(e){this.$router.push({name:"sw.theme.manager.detail",params:{id:e.id}})},onSortingChanged(e){[this.sortBy,this.sortDirection]=e.split(":"),this.resetList()},onSearch(e=null){this.term=e.length>0?e:null,this.resetList()},onPageChange({page:e,limit:t}){this.page=e,this.limit=t,this.getList(),this.updateRoute({page:this.page,limit:this.limit})},onListModeChange(){this.listMode=this.listMode==="grid"?"list":"grid",this.limit=this.listMode==="grid"?9:10,this.resetList()},onPreviewChange(e){this.acl.can("theme.editor")&&(this.showMediaModal=!0,this.currentTheme=e)},onPreviewImageRemove(e){this.acl.can("theme.editor")&&(e.previewMediaId=null,e.previewMedia=null,this.saveTheme(e))},onModalClose(){this.showMediaModal=!1,this.currentTheme=null},onPreviewImageChange([e]){this.currentTheme.previewMediaId=e.id,this.saveTheme(this.currentTheme),this.currentTheme.previewMedia=e},saveTheme(e){return this.isLoading=!0,this.themeRepository.save(e,Shopware.Context.api).then(()=>{this.isLoading=!1}).catch(()=>{this.isLoading=!1})},getColumnConfig(){return[{property:"name",label:this.$t("sw-theme-manager.list.gridHeaderName"),primary:!0},{property:"salesChannels.length",label:this.$t("sw-theme-manager.list.gridHeaderAssignment"),sortable:!1},{property:"createdAt",label:this.$t("sw-theme-manager.list.gridHeaderCreated")}]},deleteDisabledToolTip(e){return{showDelay:300,message:this.$t("sw-theme-manager.actions.deleteDisabledToolTip"),disabled:e.salesChannels.length===0}}}});const S=`{% block sw_theme_list_item %} <div class="sw-theme-list-item" :class="componentClasses"> {% block sw_theme_list_item_options %} <slot name="contextMenu"></slot> {% endblock %} {% block sw_theme_list_item_image %} <div class="sw-theme-list-item__image" v-if="theme" :style="previewMedia" @click="emitItemClick(theme)"> </div> <div class="sw-theme-list-item__image is--empty" v-else> {{ $t('sw-theme-manager.themeListItem.emptyText') }} </div> {% endblock %} {% block sw_theme_list_item_info %} <div class="sw-theme-list-item__info"> <div v-if="theme" class="sw-theme-list-item__status" :class="componentClasses"></div> <div class="sw-theme-list-item__title" v-if="theme" @click="onThemeClick">{{ theme.name }}</div> <sw-icon v-if="theme && theme.technicalName" class="sw-theme-list-item__locked" name="regular-lock" v-tooltip="lockToolTip" size="16"> </sw-icon> </div> {% endblock %} </div> {% endblock %}`,{Component:M,Application:P}=Shopware;M.register("sw-theme-list-item",{template:S,props:{theme:{type:Object,required:!1,default:null},active:{type:Boolean,required:!1,default:!1},disabled:{type:Boolean,required:!1,default:!1}},computed:{previewMedia(){return this.theme.previewMedia&&this.theme.previewMedia.id&&this.theme.previewMedia.url?{"background-image":`url('${this.theme.previewMedia.url}')`,"background-size":"cover"}:{"background-image":this.defaultThemeAsset}},defaultThemeAsset(){return`url(${Shopware.Filter.getByName("asset")("administration/static/img/theme/default_theme_preview.jpg")})`},lockToolTip(){return{showDelay:100,message:this.$t("sw-theme-manager.general.lockedToolTip")}},componentClasses(){return{"is--active":this.isActive(),"is--disabled":this.disabled}}},methods:{isActive(){return this.theme&&this.theme.salesChannels&&this.theme.salesChannels.length>0||this.active},onChangePreviewImage(e){this.disabled||this.$emit("preview-image-change",e)},onThemeClick(){this.disabled||this.$emit("item-click",this.theme)},onRemovePreviewImage(e){e.previewMediaId=null,e.save(),e.previewMedia=null},onDelete(e){this.disabled||this.$emit("theme-delete",e)},emitItemClick(e){this.disabled||this.$emit("item-click",e)}}});const y=`{% block sw_theme_modal %} <sw-modal class="sw-theme-modal" @modal-close="closeModal" :title="$t('sw-theme-manager.themeModal.modalTitle')" :subtitle="$t('sw-theme-manager.themeModal.modalSubtitle')" > {% block sw_theme_modal_header %} <div class="sw-theme-modal__header"> <sw-card-section class="sw-theme-modal__header-search"> <sw-container> <sw-simple-search-field class="sw-theme-modal__header-search" variant="form" :placeholder="$t('sw-theme-manager.general.placeholderSearchBar')" @search-term-change="onSearch" ></sw-simple-search-field> </sw-container> </sw-card-section> </div> {% endblock %} {% block sw_theme_modal_content %} <div class="sw-theme-modal__content"> {% block sw_theme_modal_loader %} <sw-loader v-if="isLoading"></sw-loader> {% endblock %} {% block sw_theme_modal_content %} <sw-container v-else columns="repeat(auto-fill, minmax(250px, 1fr))" gap="24px"> {% block sw_theme_modal_content_listing %} <div v-for="theme in themes" class="sw-theme-modal__content-item" :class="{ 'is--selected': theme.id === selected }"> {% block sw_theme_modal_content_listing_item %} {% block sw_theme_modal_content_listing_item_checkbox %} <mt-checkbox @update:checked="onSelection(theme.id)" :checked="theme.id === selected" /> {% endblock %} {% block sw_theme_modal_content_listing_item_inner %} <sw-theme-list-item :theme="theme" :key="theme.id" @item-click="selectItem(theme.id)"> </sw-theme-list-item> {% endblock %} {% endblock %} </div> {% endblock %} </sw-container> {% endblock %} </div> {% endblock %} {% block sw_theme_modal_footer %} <template #modal-footer> <sw-button @click="closeModal"> {{ $t('global.default.cancel') }} </sw-button> <sw-button @click="selectLayout" variant="primary"> {{ $t('sw-theme-manager.themeModal.actionConfirm') }} </sw-button> </template> {% endblock %} </sw-modal> {% endblock %}`,{Component:$,Mixin:x}=Shopware,c=Shopware.Data.Criteria;$.register("sw-theme-modal",{template:y,inject:["repositoryFactory"],mixins:[x.getByName("listing")],props:{selectedThemeId:{type:String,default:null,required:!1}},data(){return{selected:null,isLoading:!1,sortBy:"createdAt",sortDirection:"DESC",term:"",total:null,themes:[]}},computed:{themeRepository(){return this.repositoryFactory.create("theme")}},created(){this.createdComponent()},methods:{createdComponent(){this.selected=this.selectedThemeId},getList(){this.isLoading=!0;const e=new c(this.page,this.limit);return e.addAssociation("previewMedia"),e.addAssociation("salesChannels"),e.addFilter(c.equals("active",!0)),e.addSorting(c.sort(this.sortBy,this.sortDirection)),e.setTerm(this.term),this.themeRepository.search(e,Shopware.Context.api).then(t=>(this.total=t.total,this.themes=t,this.isLoading=!1,this.themes)).catch(()=>{this.isLoading=!1})},selectLayout(){this.$emit("modal-theme-select",this.selected),this.closeModal()},selectItem(e){this.selected=e},onSearch(e){this.term=e,this.page=1,this.getList()},onSelection(e){this.selected=e},closeModal(){this.$emit("modal-close"),this.selected=null,this.term=null}}});Shopware.Service("privileges").addPrivilegeMappingEntry({category:"permissions",parent:"content",key:"theme",roles:{viewer:{privileges:["theme:read","theme_child:read","sales_channel:read",Shopware.Service("privileges").getPrivileges("media.viewer")],dependencies:[]},editor:{privileges:["theme:update","theme_child:update","tag:read","product_media:read","product:read","category:read","product_manufacturer:read","mail_template_media:read","mail_template:read","document_base_config:read","user:read","payment_method:read","shipping_method:read","custom_field_set:read","custom_field:read","custom_field_set_relation:read",Shopware.Service("privileges").getPrivileges("media.creator")],dependencies:["theme.viewer"]},creator:{privileges:["theme:create","theme_child:create"],dependencies:["theme.viewer","theme.editor"]},deleter:{privileges:["theme:delete","theme_child:delete"],dependencies:["theme.viewer"]}}});const{Module:I}=Shopware;I.register("sw-theme-manager",{type:"core",title:"sw-theme-manager.general.mainMenuItemGeneral",description:"sw-theme-manager.general.descriptionTextModule",version:"1.0.0",targetVersion:"1.0.0",color:"#ff68b4",icon:"regular-content",favicon:"icon-module-content.png",entity:"theme",routes:{index:{component:"sw-theme-manager-list",path:"index",meta:{privilege:"theme.viewer"}},detail:{component:"sw-theme-manager-detail",path:"detail/:id",meta:{parentPath:"sw.theme.manager.index",privilege:"theme.viewer"}}},navigation:[{id:"sw-theme-manager",label:"sw-theme-manager.general.mainMenuItemGeneral",color:"#ff68b4",icon:"default-object-image",path:"sw.theme.manager.index",privilege:"theme.viewer",position:80,parent:"sw-content"}],routeMiddleware(e,t){const a="sw.sales.channel.detail.theme";t.name==="sw.sales.channel.detail"&&t.children.every(s=>s.name!==a)&&t.children.push({component:"sw-sales-channel-detail-theme",name:a,isChildren:!0,path:"/sw/sales/channel/detail/:id/theme",meta:{parentPath:"sw.sales.channel.list",privilege:"sales_channel.viewer"}}),e(t)}});const N=`{% block sw_settings_storefront_index %} <sw-page class="sw-settings-storefront"> {% block sw_settings_storefront_smart_bar_header %} <template #smart-bar-header> {% block sw_settings_storefront_smart_bar_header_title %} <h2> {% block sw_settings_storefront_smart_bar_header_title_text %} {{ $tc('sw-settings.index.title') }} <sw-icon name="regular-chevron-right-xs" small /> {{ $tc('sw-settings-storefront.general.textHeadline') }} {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_settings_storefront_smart_bar_actions %} <template #smart-bar-actions> {% block sw_settings_storefront_actions_save %} <sw-button-process :is-loading="isLoading" :process-success="isSaveSuccessful" variant="primary" @process-finish="onSaveFinish" @click="savestorefrontSettings" > {{ $tc('global.default.save') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_settings_storefront_content %} <template #content> <sw-card-view> <sw-skeleton v-if="isLoading" /> {% block sw_settings_storefront %} <sw-card position-identifier="sw-settings-storefront--settings" :title="$tc('sw-settings-storefront.configuration.cardTitle')" class="sw-settings-storefront__input-fields" > {% block sw_settings_storefront_smtp_settings %} <sw-settings-storefront-configuration :storefront-settings="storefrontSettings" /> {% endblock %} </sw-card> {% endblock %} </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`;Shopware.Component.register("sw-settings-storefront-index",{template:N,inject:["systemConfigApiService"],data(){return{isLoading:!0,isSaveSuccessful:!1,storefrontSettings:{"core.storefrontSettings.iconCache":!0,"core.storefrontSettings.asyncThemeCompilation":!1,"core.storefrontSettings.speculationRules":!1}}},metaInfo(){return{title:this.$createTitle()}},created(){this.createdComponent()},methods:{async createdComponent(){await this.loadPageContent()},async loadPageContent(){await this.loadstorefrontSettings()},async loadstorefrontSettings(){this.isLoading=!0,this.storefrontSettings=await this.systemConfigApiService.getValues("core.storefrontSettings"),Object.keys(this.storefrontSettings).length===0&&(this.storefrontSettings={"core.storefrontSettings.iconCache":!0,"core.storefrontSettings.asyncThemeCompilation":!1,"core.storefrontSettings.speculationRules":!1}),this.isLoading=!1},async savestorefrontSettings(){this.isLoading=!0,this.storefrontSettings["core.storefrontSettings.iconCache"]===""&&(this.storefrontSettings["core.storefrontSettings.iconCache"]=!0),this.storefrontSettings["core.storefrontSettings.asyncThemeCompilation"]===""&&(this.storefrontSettings["core.storefrontSettings.asyncThemeCompilation"]=!1),this.storefrontSettings["core.storefrontSettings.speculationRules"]===""&&(this.storefrontSettings["core.storefrontSettings.speculationRules"]=!1),await this.systemConfigApiService.saveValues(this.storefrontSettings),this.isLoading=!1},async onSaveFinish(){await this.loadPageContent()}}});const D=`{% block sw_settings_storefront %} <div class="sw-settings-storefront-configuration"> {% block sw_settings_storefront_settings_icon_cache %} <sw-switch-field v-model:value="storefrontSettings['core.storefrontSettings.iconCache']" :label="$tc('sw-settings-storefront.configuration.iconCache')" v-tooltip.top="{ message: $tc('sw-settings-storefront.configuration.iconCacheToolTip'), showOnDisabledElements: true }" /> {% endblock %} {% block sw_settings_storefront_settings_theme_async %} <sw-switch-field v-model:value="storefrontSettings['core.storefrontSettings.asyncThemeCompilation']" :label="$tc('sw-settings-storefront.configuration.theme.async')" v-tooltip.top="{ message: $tc('sw-settings-storefront.configuration.theme.asyncTooltip'), showOnDisabledElements: true }" /> {% endblock %} {% block sw_settings_storefront_settings_speculation_rules %} <sw-switch-field v-model:value="storefrontSettings['core.storefrontSettings.speculationRules']" :label="$tc('sw-settings-storefront.configuration.speculationRules.title')" v-tooltip.top="{ message: $tc('sw-settings-storefront.configuration.speculationRules.description'), showOnDisabledElements: true }" /> {% endblock %} </div> {% endblock %}`;Shopware.Component.register("sw-settings-storefront-configuration",{template:D,inject:["feature"],props:{storefrontSettings:{type:Object,required:!0}}});Shopware.Module.register("sw-settings-storefront",{type:"core",name:"sw-settings-storefront",title:"sw-settings-storefront.general.mainMenuItemGeneral",description:"sw-settings-storefront.general.description",color:"#9AA8B5",icon:"regular-cog",favicon:"icon-module-settings.png",routes:{index:{component:"sw-settings-storefront-index",path:"index",meta:{parentPath:"sw.settings.index.system",privilege:"system.system_config"}}},settingsItem:{group:"system",to:"sw.settings.storefront.index",icon:"regular-storefront",privilege:"system.system_config"}});const R=`{% block sw_sales_channel_detail_content_tab_theme %} <sw-tabs-item :disabled="isProductComparison || isLoading" :route="{ name: 'sw.sales.channel.detail.theme', params: { id: $route.params.id } }" :title="$tc('sw-sales-channel.detail.tabTheme')"> {{ $tc('sw-sales-channel.detail.tabTheme') }} </sw-tabs-item> {% endblock %}`,{Component:F}=Shopware;F.override("sw-sales-channel-detail",{template:R,inject:["themeService"],methods:{getLoadSalesChannelCriteria(){const e=this.$super("getLoadSalesChannelCriteria");return e.addAssociation("themes"),e},async onSave(){this.isLoading=!0,await this.assignSalesChannelTheme(),await this.$super("onSave")},async assignSalesChannelTheme(){var a,s,i,l,r,_;const e=(i=(s=(a=this.salesChannel.getOrigin().extensions)==null?void 0:a.themes)==null?void 0:s[0])==null?void 0:i.id,t=(_=(r=(l=this.salesChannel.extensions)==null?void 0:l.themes)==null?void 0:r[0])==null?void 0:_.id;if(e!==t)try{await this.themeService.assignTheme(t,this.salesChannel.id)}catch{this.createNotificationError({message:this.$tc("sw-theme-manager.general.messageSaveError")})}}}});const L=`{% block sw_sales_channel_detail_theme %} <sw-card :title="$tc('sales-channel-theme.title')" :isLoading="isLoading"> <div class="sw-sales-channel-detail-theme"> {% block sw_sales_channel_detail_theme_preview %} <div class="sw-sales-channel-detail-theme__preview"> {% block sw_sales_channel_detail_theme_preview_item %} <div @click="openThemeModal"> <sw-theme-list-item :theme="theme" :disabled="!acl.can('sales_channel.editor')" :active="!!theme"> </sw-theme-list-item> </div> {% endblock %} {% block sw_sales_channel_detail_theme_modal %} <sw-theme-modal v-if="showThemeSelectionModal" :selected-theme-id="theme?.id" @modal-theme-select="onChangeTheme" @modal-close="closeThemeModal"> </sw-theme-modal> {% endblock %} </div> {% endblock %} {% block sw_sales_channel_detail_theme_info %} <div class="sw-sales-channel-detail-theme__info"> {% block sw_sales_channel_detail_theme_info_content %} <div class="sw-sales-channel-detail-theme__info-content"> {% block sw_sales_channel_detail_theme_info_name %} <div class="sw-sales-channel-detail-theme__info-name" :class="{ 'is--empty': !theme }"> {{ theme ? theme.name : $tc('sales-channel-theme.defaultTitle') }} </div> {% endblock %} {% block sw_sales_channel_detail_theme_info_author %} <div v-if="theme" class="sw-sales-channel-detail-theme__info-author"> {{ theme.author }} </div> {% endblock %} {% block sw_sales_channel_detail_theme_info_description %} <div v-if="theme && theme.description" class="sw-sales-channel-detail-theme__info-description"> <p class="sw-sales-channel-detail-theme__info-description-title"> {{ $tc('sw-theme-manager.detail.description') }}: </p> <p>{{ theme.description |truncate(140) }}</p> </div> {% endblock %} </div> {% endblock %} {% block sw_sales_channel_detail_theme_info_actions %} <div class="sw-sales-channel-detail-theme__info-actions"> {% block sw_sales_channel_detail_theme_info_actions_theme %} <sw-button size="small" @click="openThemeModal" :disabled="!acl.can('sales_channel.editor')"> {{ theme ? $tc('sales-channel-theme.changeTheme') : $tc('sales-channel-theme.changeThemeEmpty') }} </sw-button> {% endblock %} {% block sw_sales_channel_detail_theme_info_actions_manager %} <sw-button size="small" @click="openInThemeManager" :disabled="!acl.can('sales_channel.editor')"> {{ theme ? $tc('sales-channel-theme.editContent'): $tc('sales-channel-theme.createTheme') }} </sw-button> {% endblock %} </div> {% endblock %} </div> {% endblock %} </div> </sw-card> {% endblock %}`,{Component:A,Mixin:p}=Shopware,B=Shopware.Data.Criteria;A.register("sw-sales-channel-detail-theme",{template:L,mixins:[p.getByName("notification"),p.getByName("placeholder")],inject:["repositoryFactory","themeService","acl"],props:{salesChannel:{required:!0}},data(){return{theme:null,showThemeSelectionModal:!1,showChangeModal:!1,newThemeId:null,isLoading:!1}},computed:{themeRepository(){return this.repositoryFactory.create("theme")}},watch:{"salesChannel.extensions.themes":{deep:!0,handler(){var e,t,a;this.getTheme((a=(t=(e=this.salesChannel)==null?void 0:e.extensions)==null?void 0:t.themes[0])==null?void 0:a.id)}}},created(){this.createdComponent()},methods:{createdComponent(){var e,t;(t=(e=this.salesChannel)==null?void 0:e.extensions)!=null&&t.themes[0]&&(this.theme=this.salesChannel.extensions.themes[0],this.getTheme(this.theme.id))},async getTheme(e){if(e===null)return;const t=new B;t.addAssociation("previewMedia"),this.theme=await this.themeRepository.get(e,Shopware.Context.api,t)},openThemeModal(){this.acl.can("sales_channel.editor")&&(this.showThemeSelectionModal=!0)},closeThemeModal(){this.showThemeSelectionModal=!1},openInThemeManager(){this.theme?this.$router.push({name:"sw.theme.manager.detail",params:{id:this.theme.id}}):this.$router.push({name:"sw.theme.manager.index"})},async onChangeTheme(e){this.showThemeSelectionModal=!1,await this.getTheme(e),this.salesChannel.extensions.themes[0]=this.theme}}});const o=Shopware.Classes.ApiService;class E extends o{constructor(t,a,s="theme"){super(t,a,s),this.name="themeService"}assignTheme(t,a,s={},i={}){const l=`/_action/${this.getApiBasePath()}/${t}/assign/${a}`;return this.httpClient.post(l,{},{params:{...s},headers:this.getBasicHeaders(i)}).then(r=>o.handleResponse(r))}updateTheme(t,a,s={},i={}){const l=`/_action/${this.getApiBasePath()}/${t}`;return this.httpClient.patch(l,a,{params:{...s},headers:this.getBasicHeaders(i)}).then(r=>o.handleResponse(r))}resetTheme(t,a={},s={}){const i=`/_action/${this.getApiBasePath()}/${t}/reset`;return this.httpClient.patch(i,{},{params:{...a},headers:this.getBasicHeaders(s)}).then(l=>o.handleResponse(l))}getConfiguration(t){const a=`/_action/${this.getApiBasePath()}/${t}/configuration`,s={"sw-language-id":Shopware.Store.get("session").languageId};return this.httpClient.get(a,{headers:this.getBasicHeaders(s)}).then(i=>o.handleResponse(i))}getStructuredFields(t){const a=`/_action/${this.getApiBasePath()}/${t}/structured-fields`,s={"sw-language-id":Shopware.Store.get("session").languageId};return this.httpClient.get(a,{headers:this.getBasicHeaders(s)}).then(i=>o.handleResponse(i))}validateFields(t){const a=`/_action/${this.getApiBasePath()}/validate-fields`,s={"sw-language-id":Shopware.Store.get("session").languageId};return this.httpClient.post(a,{fields:t},{headers:this.getBasicHeaders(s)}).then(i=>o.handleResponse(i))}}const{Application:V}=Shopware;Shopware.Service().register("themeService",e=>{const t=V.getContainer("init");return new E(t.httpClient,e.loginService)});
