const n=`{% block sw_settings_list %} <sw-page class="sw-settings-logging-list"> {% block sw_settings_logging_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="Logs" :placeholder="$tc('sw-settings-logging.general.placeholderSearchBar')" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_settings_logging_list_smart_bar_header %} <template #smart-bar-header> {% block sw_settings_logging_list_smart_bar_header_title %} <h2> {% block sw_settings_logging_list_smart_bar_header_title_text %} {{ $tc('sw-settings.index.title') }} <mt-icon name="regular-chevron-right-xs" size="12px" /> {{ $tc('sw-settings-logging.list.title') }} {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_settings_logging_list_smart_bar_actions %} <template #smart-bar-actions></template> {% endblock %} {% block sw_settings_logging_list_content %} <template #content> {% block sw_settings_logging_list_content_listing %} <sw-entity-listing :data-source="logs" :columns="logColumns" :full-page="true" :show-settings="true" :show-selection="undefined" :show-actions="true" :sort-by="sortBy" :sort-direction="sortDirection" :is-loading="isLoading" :allow-column-edit="true" :repository="logEntryRepository" identifier="sw-log-entry-list" > <template #column-createdAt="{ item }" > {% block sw_settings_logging_list_column_created_at %} {{ dateFilter(item.createdAt, { hour: '2-digit', minute: '2-digit' }) }} {% endblock %} </template> <template #column-level="{ item }" > {% block sw_settings_logging_list_column_level %} {{ logLevelToString(item.level) }} ({{ item.level }}) {% endblock %} </template> <template #column-context="{ item }" > {% block sw_settings_logging_list_column_context %} <a role="button" tabindex="0" @click="showInfoModal(item)" @keydown.enter="showInfoModal(item)" > {{ item.context }} </a> {% endblock %} </template> <template #pagination> {% block sw_settings_logging_list_content_listing_pagination %} <sw-pagination :page="page" :limit="limit" :total="total" :total-visible="7" @page-change="onPageChange" /> {% endblock %} </template> <template #actions="{ item }" > {% block sw_settings_logging_list_content_listing_actions %} <sw-context-menu-item @click="showInfoModal(item)"> {% block sw_settings_logging_list_content_listing_action_show_label %} {{ $tc('sw-settings-logging.list.actionShowInfo') }} {% endblock %} </sw-context-menu-item> {% endblock %} </template> </sw-entity-listing> {% endblock %} {% block sw_settings_logging_list_content_info_modal %} <component :is="modalNameFromLogEntry" v-if="displayedLog !== null" class="sw-settings-logging-list__custom-content" :log-entry="displayedLog" @close="closeInfoModal" /> {% endblock %} </template> {% endblock %} {% block sw_settings_logging_list_sidebar %} <template #sidebar> <sw-sidebar class="sw-settings-logging-list__sidebar"> {% block sw_settings_logging_list_sidebar_refresh %} <sw-sidebar-item icon="regular-undo" :title="$tc('sw-settings-logging.list.titleSidebarItemRefresh')" @click="onRefresh" /> {% endblock %} </sw-sidebar> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:i,Component:g}=Shopware,{Criteria:l}=Shopware.Data,a={template:n,inject:["repositoryFactory"],mixins:[i.getByName("sw-settings-list"),i.getByName("placeholder")],data(){return{entityName:"log_entry",sortBy:"log_entry.createdAt",sortDirection:"DESC",isLoading:!0,logs:[],displayedLog:null,logLevels:{Debug:100,Info:200,Notice:250,Warning:300,Error:400,Critical:500,Alert:550,Emergency:600}}},metaInfo(){return{title:this.$createTitle()}},computed:{logEntryRepository(){return this.repositoryFactory.create("log_entry")},logColumns(){return this.getLogColumns()},modalNameFromLogEntry(){const t=this.displayedLog.message.replace(/[._]/g,"-");return g.getComponentRegistry().has(`sw-settings-logging-${t}-info`)?`sw-settings-logging-${t}-info`:"sw-settings-logging-entry-info"},dateFilter(){return Shopware.Filter.getByName("date")}},methods:{showInfoModal(e){this.displayedLog=e},closeInfoModal(){this.displayedLog=null},getList(){this.isLoading=!0;const e=new l(this.page,this.limit);return e.setTerm(this.term),e.addSorting(l.sort(this.sortBy,this.sortDirection)),this.logEntryRepository.search(e).then(t=>(this.total=t.total,this.logs=t,this.isLoading=!1,t)).catch(()=>{this.isLoading=!1})},logLevelToString(e){const t=Object.values(this.logLevels).map(s=>Math.abs(s-e)),o=Object.keys(this.logLevels)[t.findIndex(s=>s===Math.min(...t))];return this.$tc(`sw-settings-logging.list.level${o}`)},getLogColumns(){return[{property:"createdAt",dataIndex:"createdAt",label:"sw-settings-logging.list.columnDate",allowResize:!0,primary:!0},{property:"message",dataIndex:"message",label:"sw-settings-logging.list.columnMessage",allowResize:!0},{property:"level",dataIndex:"level",label:"sw-settings-logging.list.columnLevel",allowResize:!0},{property:"context",dataIndex:"context",label:"sw-settings-logging.list.columnContent",allowResize:!0}]}}};export{a as default};
