const o=`{% block sw_sales_channel_detail_domains %} <mt-card :title="$tc('sw-sales-channel.detail.titleDomains')" class="sw-sales-channel-detail-domains" position-identifier="sw-sales-channel-detail-domains" > {% block sw_sales_channel_detail_domains_meta %} <div class="sw-sales-channel-detail-domains__meta"> {% block sw_sales_channel_detail_domains_headline %} <h4 class="sw-sales-channel-detail-domains__headline sw-sales-channel-detail-base__headline"> <span class="sw-sales-channel-detail-domains__headline-text sw-sales-channel-detail-base__headline-text"> {{ $tc('sw-sales-channel.detail.titleDomainHeadline') }} </span> </h4> {% endblock %} {% block sw_sales_channel_detail_domains_add_button %} <mt-button size="small" :disabled="disableEdit || undefined" class="sw-sales-channel-detail__button-domain-add" variant="secondary" @click="onClickOpenCreateDomainModal" > {{ $tc('sw-sales-channel.detail.buttonAddDomain') }} </mt-button> {% endblock %} </div> {% endblock %} <template #grid> {% block sw_sales_channel_detail_domains_grid %} <sw-data-grid ref="gridDomains" :data-source="sortedDomains" :columns="getDomainColumns()" :show-selection="false" :is-loading="isLoadingDomains" :show-actions="true" :sort-by="sortBy" :sort-direction="sortDirection" @column-sort="sortColumns" > {% block sw_sales_channel_detail_domains_columns_template %} {% block sw_sales_channel_detail_domains_column_url %} <template #column-url="{ item }" > {{ unicodeUriFilter(item.url) }} </template> {% endblock %} {% block sw_sales_channel_detail_domains_column_language_id %} <template #column-languageId="{ item, isInlineEdit}" > {{ item.language.name }} </template> {% endblock %} {% block sw_sales_channel_detail_domains_column_currency_id %} <template #column-currencyId="{ item, isInlineEdit}" > {{ item.currency.translated.name }} </template> {% endblock %} {% block sw_sales_channel_detail_domains_column_snippet_set_id %} <template #column-snippetSetId="{ item, isInlineEdit}" > {{ item.snippetSet.name }} </template> {% endblock %} {% block sw_sales_channel_detail_domains_column_actions %} <template #actions="{ item }"> {% block sw_sales_channel_detail_domains_column_action_domain_edit %} <sw-context-menu-item :disabled="disableEdit" @click="onClickEditDomain(item)" > {{ $tc('sw-sales-channel.detail.buttonEditDomain') }} </sw-context-menu-item> {% endblock %} {% block sw_sales_channel_detail_domains_column_action_domain_delete %} <sw-context-menu-item :disabled="disableEdit" variant="danger" @click="onClickDeleteDomain(item)" > {{ $tc('sw-sales-channel.detail.buttonDeleteDomain') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% endblock %} </sw-data-grid> </template> {% endblock %} {% block sw_sales_channel_detail_domains_create_modal %} <sw-modal v-if="currentDomain" :title="currentDomainModalTitle" @modal-close="onCloseCreateDomainModal" > {% block sw_sales_channel_detail_domains_create_modal_content %} <sw-container columns="repeat(auto-fit, minmax(250px, 1fr))" gap="0px 30px" > {% block sw_sales_channel_detail_domains_input_url %} <mt-url-field v-model="currentDomain.url" type="text" omit-url-hash omit-url-search :label="$tc('sw-sales-channel.detail.labelInputUrl')" :error="error" @update:model-value="onInput" /> {% endblock %} {% block sw_sales_channel_detail_domains_input_language %} <sw-single-select v-model:value="currentDomain.languageId" class="sw-sales-channel-detail-domains__domain-language-select" :options="salesChannel.languages" label-property="name" value-property="id" required :label="$tc('sw-sales-channel.detail.labelInputLanguage')" show-clearable-button @update:value="onLanguageSelect" /> {% endblock %} </sw-container> <sw-container columns="repeat(auto-fit, minmax(250px, 1fr))" gap="0px 30px" > {% block sw_sales_channel_detail_domains_input_currency %} <sw-single-select v-model:value="currentDomain.currencyId" class="sw-sales-channel-detail-domains__domain-currency-select" :label="$tc('sw-sales-channel.detail.labelInputCurrency')" required show-clearable-button :options="salesChannel.currencies" label-property="translated.name" value-property="id" @update:value="onCurrencySelect" /> {% endblock %} {% block sw_sales_channel_detail_domains_input_snippet_set %} <sw-entity-single-select v-model:value="currentDomain.snippetSetId" entity="snippet_set" :criteria="snippetSetCriteria" :label="$tc('sw-sales-channel.detail.labelInputSnippet')" required show-clearable-button @option-select="onOptionSelect" /> {% endblock %} </sw-container> {% block sw_sales_channel_detail_domains_hreflang %} <sw-radio-field v-model:value="currentDomain.hreflangUseOnlyLocale" :label="$tc('sw-sales-channel.detail.hreflang.domainSettings.label')" identification="hreflang" :options="hreflangLocalisationOptions" /> {% endblock %} {% endblock %} <template #modal-footer> {% block sw_sales_channel_detail_domains_create_action_cancel %} <mt-button size="small" variant="secondary" @click="onCloseCreateDomainModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_sales_channel_detail_domains_create_action_create %} <mt-button size="small" variant="primary" :disabled="disabled" @click="onClickAddNewDomain" > {{ currentDomainModalButtonText }} </mt-button> {% endblock %} </template> </sw-modal> {% endblock %} {% block sw_sales_channel_detail_domains_delete_modal %} <sw-modal v-if="deleteDomain" :title="$tc('sw-sales-channel.detail.deleteDomainModalTitle')" variant="small" @modal-close="onCloseDeleteDomainModal" > {% block sw_sales_channel_detail_domains_delete_modal_confirm_text %} {{ $tc('sw-sales-channel.detail.textConfirmDeleteDomain', { url: unicodeUriFilter(deleteDomain.url) }, 0) }} {% endblock %} {% block sw_sales_channel_detail_domains_delete_modal_footer %} <template #modal-footer> {% block sw_sales_channel_detail_domains_delete_modal_abort %} <mt-button size="small" variant="secondary" @click="onCloseDeleteDomainModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_sales_channel_detail_domains_delete_modal_confirm %} <mt-button size="small" variant="critical" @click="onConfirmDeleteDomain(deleteDomain)" > {{ $tc('sw-sales-channel.detail.buttonConfirmDeleteDomain') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </mt-card> {% endblock %}`,{Mixin:r,Context:c}=Shopware,{Criteria:t}=Shopware.Data,{ShopwareError:d}=Shopware.Classes,u={template:o,inject:["repositoryFactory"],mixins:[r.getByName("notification")],props:{salesChannel:{required:!0},disableEdit:{type:Boolean,required:!1,default:!1}},data(){return{currentDomain:null,currentDomainBackup:{url:null,language:null,languageId:null,currency:null,currencyId:null,snippetSet:null,snippetSetId:null},isLoadingDomains:!1,deleteDomain:null,sortBy:"url",sortDirection:"ASC",error:null,isEditingDomain:!1}},computed:{domainRepository(){return this.repositoryFactory.create(this.salesChannel.domains.entity,this.salesChannel.domains.source)},currentDomainModalTitle(){return this.isEditingDomain?this.$t("sw-sales-channel.detail.titleEditDomain",{name:this.unicodeUriFilter(this.currentDomainBackup.url)}):this.$t("sw-sales-channel.detail.titleCreateDomain")},currentDomainModalButtonText(){return this.isEditingDomain?this.$t("sw-sales-channel.detail.buttonEditDomain"):this.$t("sw-sales-channel.detail.buttonAddDomain")},snippetSetCriteria(){return new t(1,25).addSorting(t.sort("name","ASC"))},salesChannelFilterCriteria(){const e=new t(1,25);return e.addAssociation("salesChannels").addSorting(t.sort("name","ASC")),e.addFilter(t.equals("salesChannels.id",this.salesChannel.id))},currencyCriteria(){return new t(1,25).addSorting(t.sort("name","ASC"))},hreflangLocalisationOptions(){return[{name:this.$tc("sw-sales-channel.detail.hreflang.domainSettings.byIso"),value:!1,helpText:this.$tc("sw-sales-channel.detail.hreflang.domainSettings.byIsoHelpText")},{name:this.$tc("sw-sales-channel.detail.hreflang.domainSettings.byAbbreviation"),value:!0,helpText:this.$tc("sw-sales-channel.detail.hreflang.domainSettings.byAbbreviationHelpText")}]},disabled(){return!this.currentDomain||!this.currentDomain.currencyId||!this.currentDomain.snippetSetId||!this.currentDomain.url||!this.currentDomain.languageId||this.disableEdit||this.error!==null},sortedDomains(){const e=[...this.salesChannel.domains];return this.localSortDomains(e)}},methods:{sortColumns(e){this.sortBy===e.dataIndex?this.sortDirection=this.sortDirection==="ASC"?"DESC":"ASC":(this.sortBy=e.dataIndex,this.sortDirection="ASC")},unicodeUriFilter(e){return Shopware.Filter.getByName("unicodeUri")(e)},localSortDomains(e){return e.sort((n,a)=>{const l=this.getSortValue(n,this.sortBy).toString(),s=this.getSortValue(a,this.sortBy).toString(),i=l.localeCompare(s,void 0,{numeric:!0,sensitivity:"base"});return this.sortDirection==="ASC"?i:i*-1}),e},getSortValue(e,n){return n=n.replace("Id",""),e.hasOwnProperty(n)&&typeof e[n]=="object"&&e[n].hasOwnProperty("name")?e[n].name:e[n]},onInput(){this.error=null},async verifyUrl(e){return!(this.domainExistsLocal(e)||await this.domainExistsInDatabase(e.url))},domainExistsLocal(e){return this.salesChannel.domains.filter(n=>n.id!==e.id&&n.url===e.url).length>0},isOriginalUrl(e){return e===this.currentDomainBackup.url},async domainExistsInDatabase(e){const n=this.repositoryFactory.create(this.salesChannel.domains.entity),a=new t(1,25);a.addFilter(t.equals("url",e));const l=await n.search(a);return l.total===0?!1:l.first().salesChannelId!==this.salesChannel.id},setCurrentDomainBackup(e){this.currentDomainBackup={url:e.url,language:e.language,languageId:e.languageId,currency:e.currency,currencyId:e.currencyId,snippetSet:e.snippetSet,snippetSetId:e.snippetSetId}},resetCurrentDomainToBackup(){this.currentDomain.url=this.currentDomainBackup.url,this.currentDomain.language=this.currentDomainBackup.language,this.currentDomain.languageId=this.currentDomainBackup.languageId,this.currentDomain.currency=this.currentDomainBackup.currency,this.currentDomain.currencyId=this.currentDomainBackup.currencyId,this.currentDomain.snippetSet=this.currentDomainBackup.snippetSet,this.currentDomain.snippetSetId=this.currentDomainBackup.snippetSetId},setInitialCurrency(e){const n=this.salesChannel.currencies.first();e.currency=n,e.currencyId=n.id,this.currentDomain=e},setInitialLanguage(e){const n=this.salesChannel.languages.first();e.language=n,e.languageId=n.id,this.currentDomain=e},onClickOpenCreateDomainModal(){const e=this.domainRepository.create(c.api);this.setCurrentDomainBackup(e),this.salesChannel.currencies.length===1&&this.setInitialCurrency(e),this.salesChannel.languages.length===1&&this.setInitialLanguage(e),e.hreflangUseOnlyLocale=!1,this.currentDomain=e,this.isEditingDomain=!1},async onClickAddNewDomain(){if(this.isOriginalUrl(this.currentDomain.url)){this.currentDomain=null;return}if(!await this.verifyUrl(this.currentDomain)){this.error=new d({code:"DUPLICATED_URL"});return}this.isEditingDomain||this.salesChannel.domains.add(this.currentDomain),this.currentDomain=null,this.isEditingDomain=!1},onClickEditDomain(e){this.currentDomain=e,this.setCurrentDomainBackup(this.currentDomain),this.isEditingDomain=!0},onCloseCreateDomainModal(){this.resetCurrentDomainToBackup(),this.currentDomain=null,this.isEditingDomain=!1},onClickDeleteDomain(e){e.isNew()?this.onConfirmDeleteDomain(e):this.deleteDomain=e},onConfirmDeleteDomain(e){if(e.productExports.length>0){this.createNotificationError({message:this.$tc("sw-sales-channel.detail.messageDeleteDomainError",{url:this.unicodeUriFilter(e.url)},0)}),this.deleteDomain=null;return}this.deleteDomain=null,this.$nextTick(()=>{this.salesChannel.domains.remove(e.id)})},onCloseDeleteDomainModal(){this.deleteDomain=null},onLanguageSelect(e){this.onOptionSelect("language",this.salesChannel.languages.get(e))},onCurrencySelect(e){this.onOptionSelect("currency",this.salesChannel.currencies.get(e))},onOptionSelect(e,n){this.currentDomain[e]=n},getDomainColumns(){return[{property:"url",dataIndex:"url",label:this.$t("sw-sales-channel.detail.columnDomainUrl"),allowResize:!1,primary:!0,inlineEdit:!0},{property:"languageId",dataIndex:"languageId",label:this.$t("sw-sales-channel.detail.columnDomainLanguage"),allowResize:!1,inlineEdit:!1},{property:"snippetSetId",dataIndex:"snippetSetId",label:this.$t("sw-sales-channel.detail.columnDomainSnippetSet"),allowResize:!1,inlineEdit:!1},{property:"currencyId",dataIndex:"currencyId",label:this.$t("sw-sales-channel.detail.columnDomainCurrency"),allowResize:!1,inlineEdit:!1}]}}};export{u as default};
