const l=`{% block sw_promotion_v2_list %} <sw-page class="sw-promotion-v2-list"> {% block sw_promotion_v2_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="promotion" :placeholder="$tc('sw-promotion-v2.list.placeholderSearchBar')" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_promotion_v2_list_smart_bar_header %} <template #smart-bar-header> {% block sw_promotion_v2_list_smart_bar_header_title %} <h2> {% block sw_promotion_v2_list_smart_bar_header_title_text %} {{ $tc('sw-promotion-v2.list.textTitle') }} {% endblock %} {% block sw_promotion_v2_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_promotion_v2_list_smart_bar_actions %} <template #smart-bar-actions> {% block sw_promotion_v2_list_smart_bar_actions_add %} <mt-button v-tooltip="addButtonTooltip" class="sw-promotion-v2-list__smart-bar-button-add" variant="primary" :disabled="!acl.can('promotion.creator') || undefined" size="default" @click="$router.push({ name: 'sw.promotion.v2.create' })" > {{ $tc('sw-promotion-v2.list.buttonAddPromotion') }} </mt-button> {% endblock %} </template> {% endblock %} {% block sw_promotion_v2_list_language_switch %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_promotion_v2_list_content %} <template #content> <div class="sw-promotion-v2-list__content"> {% block sw_promotion_v2_list_grid %} <sw-entity-listing v-if="entitySearchable" ref="listing" :repository="promotionRepository" :columns="promotionColumns" :items="promotions" detail-route="sw.promotion.v2.detail" :is-loading="isLoading" :allow-inline-edit="acl.can('promotion.editor') || undefined" :show-selection="acl.can('promotion.deleter') || undefined" :allow-edit="acl.can('promotion.editor') || undefined" :allow-view="acl.can('promotion.viewer') || undefined" allow-column-edit full-page @update-records="updateTotal" @selection-change="updateSelection" > {% block sw_promotion_v2_list_grid_columns %} {% block sw_promotion_v2_list_grid_columns_active %} <template #column-active="{ item }"> <mt-icon v-if="item.active" class="sw-promotion-v2-list__icon-activity is--active" name="regular-checkmark-xs" /> <mt-icon v-else class="sw-promotion-v2-list__icon-activity is--inactive" name="regular-times-s" /> </template> {% endblock %} {% block sw_promotion_v2_list_grid_columns_valid_from %} <template #column-validFrom="{ item }"> {{ dateFilter(item.validFrom, { hour: '2-digit', minute: '2-digit' }) }} </template> {% endblock %} {% block sw_promotion_v2_list_grid_columns_valid_until %} <template #column-validUntil="{ item }"> {{ dateFilter(item.validUntil, { hour: '2-digit', minute: '2-digit' }) }} </template> {% endblock %} {% endblock %} {% block sw_promotion_v2_list_grid_columns_actions %} <template #more-actions="{ item }"> {% block sw_promotion_v2_list_grid_columns_actions_duplicate %} <sw-context-menu-item :disabled="!acl.can('promotion.creator')" @click="onDuplicatePromotion(item)" > {{ $tc('global.default.duplicate') }} </sw-context-menu-item> {% endblock %} </template> {% block sw_promotion_v2_list_grid_columns_actions_delete %} <template #delete-action="{ item, showDelete }"> <sw-context-menu-item v-tooltip="deleteDisabledTooltip(item)" variant="danger" :disabled="(item && item.orderCount > 0) || !acl.can('promotion.deleter') || undefined" @click="showDelete(item.id)" > {{ $tc('global.default.delete') }} </sw-context-menu-item> </template> {% endblock %} {% endblock %} </sw-entity-listing> {% endblock %} {% block sw_promotion_v2_list_empty_state %} <template v-if="!isLoading && !total"> <sw-promotion-v2-empty-state-hero v-if="isValidTerm(term)" :title="$tc('sw-empty-state.messageNoResultTitle')" :description="$tc('sw-empty-state.messageNoResultSubline')" /> <sw-promotion-v2-empty-state-hero v-else :title="$tc('sw-promotion-v2.list.titleEmpty')" :description="$tc('sw-promotion-v2.list.descriptionEmpty')" > {% block sw_promotion_v2_list_empty_state_actions %} <template #actions> <mt-button v-tooltip="addButtonTooltip" class="sw-promotion-v2-list__empty-state-button-add" variant="primary" :disabled="!acl.can('promotion.creator') || undefined" @click="$router.push({ name: 'sw.promotion.v2.create' })" > {{ $tc('sw-promotion-v2.list.buttonAddPromotion') }} </mt-button> </template> {% endblock %} </sw-promotion-v2-empty-state-hero> </template> {% endblock %} </div> </template> {% endblock %} {% block sw_promotion_v2_list_sidebar %} <template #sidebar> <sw-sidebar> {% block sw_promotion_v2_list_sidebar_refresh %} <sw-sidebar-item icon="regular-undo" :title="$tc('sw-promotion-v2.list.titleSidebarItemRefresh')" @click="onRefresh" /> {% endblock %} </sw-sidebar> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:e}=Shopware,{Criteria:i}=Shopware.Data,n={template:l,inject:["repositoryFactory","acl"],mixins:[e.getByName("listing"),e.getByName("notification")],data(){return{isLoading:!0,promotions:null,total:0,showDeleteModal:!1,sortBy:"createdAt",sortDirection:"DESC",searchConfigEntity:"promotion"}},metaInfo(){return{title:this.$createTitle()}},computed:{promotionRepository(){return this.repositoryFactory.create("promotion")},promotionCriteria(){return new i(this.page,this.limit).setTerm(this.term).addSorting(i.sort(this.sortBy,this.sortDirection))},promotionColumns(){return this.getPromotionColumns()},addButtonTooltip(){return{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.acl.can("promotion.creator"),showOnDisabledElements:!0,position:"bottom"}},dateFilter(){return Shopware.Filter.getByName("date")}},methods:{async getList(){this.isLoading=!0;const t=await this.addQueryScores(this.term,this.promotionCriteria);return this.entitySearchable?this.promotionRepository.search(t).then(o=>(this.isLoading=!1,this.total=o.total,this.promotions=o,this.promotions)):(this.isLoading=!1,this.total=0,!1)},onChangeLanguage(){this.getList()},getPromotionColumns(){return[{property:"name",label:"sw-promotion-v2.list.columnName",routerLink:"sw.promotion.v2.detail",inlineEdit:"string",allowResize:!0,primary:!0},{property:"active",label:"sw-promotion-v2.list.columnActive",inlineEdit:"boolean",allowResize:!0,align:"center"},{property:"validFrom",label:"sw-promotion-v2.list.columnValidFrom",inlineEdit:"date",allowResize:!0,align:"center"},{property:"validUntil",label:"sw-promotion-v2.list.columnValidUntil",inlineEdit:"date",allowResize:!0,align:"center"}]},updateTotal({total:t}){this.total=t},async onDuplicatePromotion(t){this.isLoading=!0;try{const o={overwrites:{name:`${t.name} ${this.$tc("global.default.copy")}`,code:null,useCodes:!1,useIndividualCodes:!1,individualCodePattern:"",individualCodes:null,active:!1,orderCount:0,ordersPerCustomerCount:null}},a=await this.promotionRepository.clone(t.id,o,Shopware.Context.api);this.$nextTick(()=>{this.$router.push({name:"sw.promotion.v2.detail",params:{id:a.id}})}),this.createNotificationInfo({message:this.$tc("sw-promotion-v2.list.duplicatePromotionInfo")})}catch(o){throw new Error(o)}finally{this.isLoading=!1}},deleteDisabledTooltip(t){return{showDelay:300,message:this.$tc("sw-promotion-v2.list.deleteDisabledToolTip"),disabled:t.orderCount===0}}}};export{n as default};
