<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelistsenum;

/**
 * Class representing the Country Codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
enum ZugferdCountryCodes: string
{

    /**
     * Andorra
     */
    case ANDORRA = "AD";

    /**
     * United Arab Emirates (the)
     */
    case UNITED_ARAB_EMIRATES_THE = "AE";

    /**
     * Afghanistan
     */
    case AFGHANISTAN = "AF";

    /**
     * Antigua and Barbuda
     */
    case ANTIGUA_AND_BARBUDA = "AG";

    /**
     * Anguilla
     */
    case ANGUILLA = "AI";

    /**
     * Albania
     */
    case ALBANIA = "AL";

    /**
     * Armenia
     */
    case ARMENIA = "AM";

    /**
     * Angola
     */
    case ANGOLA = "AO";

    /**
     * Antarctica
     */
    case ANTARCTICA = "AQ";

    /**
     * Argentina
     */
    case ARGENTINA = "AR";

    /**
     * American Samoa
     */
    case AMERICAN_SAMOA = "AS";

    /**
     * Austria
     */
    case AUSTRIA = "AT";

    /**
     * Australia
     */
    case AUSTRALIA = "AU";

    /**
     * Aruba
     */
    case ARUBA = "AW";

    /**
     * Åland Islands
     */
    case LAND_ISLANDS = "AX";

    /**
     * Azerbaijan
     */
    case AZERBAIJAN = "AZ";

    /**
     * Bosnia and Herzegovina
     */
    case BOSNIA_AND_HERZEGOVINA = "BA";

    /**
     * Barbados
     */
    case BARBADOS = "BB";

    /**
     * Bangladesh
     */
    case BANGLADESH = "BD";

    /**
     * Belgium
     */
    case BELGIUM = "BE";

    /**
     * Burkina Faso
     */
    case BURKINA_FASO = "BF";

    /**
     * Bulgaria
     */
    case BULGARIA = "BG";

    /**
     * Bahrain
     */
    case BAHRAIN = "BH";

    /**
     * Burundi
     */
    case BURUNDI = "BI";

    /**
     * Benin
     */
    case BENIN = "BJ";

    /**
     * Saint Barthélemy
     */
    case SAINT_BARTHLEMY = "BL";

    /**
     * Bermuda
     */
    case BERMUDA = "BM";

    /**
     * Brunei Darussalam
     */
    case BRUNEI_DARUSSALAM = "BN";

    /**
     * Bolivia (Plurinational State of)
     */
    case BOLIVIA_PLURINATIONAL_STATE_OF = "BO";

    /**
     * Bonaire, Sint Eustatius and Saba
     */
    case BONAIRE_SINT_EUSTATIUS_AND_SABA = "BQ";

    /**
     * Brazil
     */
    case BRAZIL = "BR";

    /**
     * Bahamas (the)
     */
    case BAHAMAS_THE = "BS";

    /**
     * Bhutan
     */
    case BHUTAN = "BT";

    /**
     * Bouvet Island
     */
    case BOUVET_ISLAND = "BV";

    /**
     * Botswana
     */
    case BOTSWANA = "BW";

    /**
     * Belarus
     */
    case BELARUS = "BY";

    /**
     * Belize
     */
    case BELIZE = "BZ";

    /**
     * Canada
     */
    case CANADA = "CA";

    /**
     * Cocos (Keeling) Islands (the)
     */
    case COCOS_KEELING_ISLANDS_THE = "CC";

    /**
     * Congo (the Democratic Republic of the)
     */
    case CONGO_THE_DEMOCRATIC_REPUBLIC_OF_THE = "CD";

    /**
     * Central African Republic (the)
     */
    case CENTRAL_AFRICAN_REPUBLIC_THE = "CF";

    /**
     * Congo (the)
     */
    case CONGO_THE = "CG";

    /**
     * Switzerland
     */
    case SWITZERLAND = "CH";

    /**
     * Côte d'Ivoire
     */
    case CTE_DIVOIRE = "CI";

    /**
     * Cook Islands (the)
     */
    case COOK_ISLANDS_THE = "CK";

    /**
     * Chile
     */
    case CHILE = "CL";

    /**
     * Cameroon
     */
    case CAMEROON = "CM";

    /**
     * China
     */
    case CHINA = "CN";

    /**
     * Colombia
     */
    case COLOMBIA = "CO";

    /**
     * Costa Rica
     */
    case COSTA_RICA = "CR";

    /**
     * Cuba
     */
    case CUBA = "CU";

    /**
     * Cabo Verde
     */
    case CABO_VERDE = "CV";

    /**
     * Curaçao
     */
    case CURAAO = "CW";

    /**
     * Christmas Island
     */
    case CHRISTMAS_ISLAND = "CX";

    /**
     * Cyprus
     */
    case CYPRUS = "CY";

    /**
     * Czechia
     */
    case CZECHIA = "CZ";

    /**
     * Germany
     */
    case GERMANY = "DE";

    /**
     * Djibouti
     */
    case DJIBOUTI = "DJ";

    /**
     * Denmark
     */
    case DENMARK = "DK";

    /**
     * Dominica
     */
    case DOMINICA = "DM";

    /**
     * Dominican Republic (the)
     */
    case DOMINICAN_REPUBLIC_THE = "DO";

    /**
     * Algeria
     */
    case ALGERIA = "DZ";

    /**
     * Ecuador
     */
    case ECUADOR = "EC";

    /**
     * Estonia
     */
    case ESTONIA = "EE";

    /**
     * Egypt
     */
    case EGYPT = "EG";

    /**
     * Western Sahara*
     */
    case WESTERN_SAHARA = "EH";

    /**
     * Eritrea
     */
    case ERITREA = "ER";

    /**
     * Spain
     */
    case SPAIN = "ES";

    /**
     * Ethiopia
     */
    case ETHIOPIA = "ET";

    /**
     * Finland
     */
    case FINLAND = "FI";

    /**
     * Fiji
     */
    case FIJI = "FJ";

    /**
     * Falkland Islands (the) [Malvinas]
     */
    case FALKLAND_ISLANDS_THE_MALVINAS = "FK";

    /**
     * Micronesia (Federated States of)
     */
    case MICRONESIA_FEDERATED_STATES_OF = "FM";

    /**
     * Faroe Islands (the)
     */
    case FAROE_ISLANDS_THE = "FO";

    /**
     * France
     */
    case FRANCE = "FR";

    /**
     * Gabon
     */
    case GABON = "GA";

    /**
     * United Kingdom of Great Britain and Northern Ireland (the)
     */
    case UNITED_KINGDOM_OF_GREAT_BRITAIN_AND_NORTHERN_IRELAND_THE = "GB";

    /**
     * Grenada
     */
    case GRENADA = "GD";

    /**
     * Georgia
     */
    case GEORGIA = "GE";

    /**
     * French Guiana
     */
    case FRENCH_GUIANA = "GF";

    /**
     * Guernsey
     */
    case GUERNSEY = "GG";

    /**
     * Ghana
     */
    case GHANA = "GH";

    /**
     * Gibraltar
     */
    case GIBRALTAR = "GI";

    /**
     * Greenland
     */
    case GREENLAND = "GL";

    /**
     * Gambia (the)
     */
    case GAMBIA_THE = "GM";

    /**
     * Guinea
     */
    case GUINEA = "GN";

    /**
     * Guadeloupe
     */
    case GUADELOUPE = "GP";

    /**
     * Equatorial Guinea
     */
    case EQUATORIAL_GUINEA = "GQ";

    /**
     * Greece
     */
    case GREECE = "GR";

    /**
     * South Georgia and the South Sandwich Islands
     */
    case SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS = "GS";

    /**
     * Guatemala
     */
    case GUATEMALA = "GT";

    /**
     * Guam
     */
    case GUAM = "GU";

    /**
     * Guinea-Bissau
     */
    case GUINEABISSAU = "GW";

    /**
     * Guyana
     */
    case GUYANA = "GY";

    /**
     * Hong Kong
     */
    case HONG_KONG = "HK";

    /**
     * Heard Island and McDonald Islands
     */
    case HEARD_ISLAND_AND_MCDONALD_ISLANDS = "HM";

    /**
     * Honduras
     */
    case HONDURAS = "HN";

    /**
     * Croatia
     */
    case CROATIA = "HR";

    /**
     * Haiti
     */
    case HAITI = "HT";

    /**
     * Hungary
     */
    case HUNGARY = "HU";

    /**
     * Indonesia
     */
    case INDONESIA = "ID";

    /**
     * Ireland
     */
    case IRELAND = "IE";

    /**
     * Israel
     */
    case ISRAEL = "IL";

    /**
     * Isle of Man
     */
    case ISLE_OF_MAN = "IM";

    /**
     * India
     */
    case INDIA = "IN";

    /**
     * British Indian Ocean Territory (the)
     */
    case BRITISH_INDIAN_OCEAN_TERRITORY_THE = "IO";

    /**
     * Iraq
     */
    case IRAQ = "IQ";

    /**
     * Iran (Islamic Republic of)
     */
    case IRAN_ISLAMIC_REPUBLIC_OF = "IR";

    /**
     * Iceland
     */
    case ICELAND = "IS";

    /**
     * Italy
     */
    case ITALY = "IT";

    /**
     * Jersey
     */
    case JERSEY = "JE";

    /**
     * Jamaica
     */
    case JAMAICA = "JM";

    /**
     * Jordan
     */
    case JORDAN = "JO";

    /**
     * Japan
     */
    case JAPAN = "JP";

    /**
     * Kenya
     */
    case KENYA = "KE";

    /**
     * Kyrgyzstan
     */
    case KYRGYZSTAN = "KG";

    /**
     * Cambodia
     */
    case CAMBODIA = "KH";

    /**
     * Kiribati
     */
    case KIRIBATI = "KI";

    /**
     * Comoros (the)
     */
    case COMOROS_THE = "KM";

    /**
     * Saint Kitts and Nevis
     */
    case SAINT_KITTS_AND_NEVIS = "KN";

    /**
     * Korea (the Democratic People's Republic of)
     */
    case KOREA_THE_DEMOCRATIC_PEOPLES_REPUBLIC_OF = "KP";

    /**
     * Korea (the Republic of)
     */
    case KOREA_THE_REPUBLIC_OF = "KR";

    /**
     * Kuwait
     */
    case KUWAIT = "KW";

    /**
     * Cayman Islands (the)
     */
    case CAYMAN_ISLANDS_THE = "KY";

    /**
     * Kazakhstan
     */
    case KAZAKHSTAN = "KZ";

    /**
     * Lao People's Democratic Republic (the)
     */
    case LAO_PEOPLES_DEMOCRATIC_REPUBLIC_THE = "LA";

    /**
     * Lebanon
     */
    case LEBANON = "LB";

    /**
     * Saint Lucia
     */
    case SAINT_LUCIA = "LC";

    /**
     * Liechtenstein
     */
    case LIECHTENSTEIN = "LI";

    /**
     * Sri Lanka
     */
    case SRI_LANKA = "LK";

    /**
     * Liberia
     */
    case LIBERIA = "LR";

    /**
     * Lesotho
     */
    case LESOTHO = "LS";

    /**
     * Lithuania
     */
    case LITHUANIA = "LT";

    /**
     * Luxembourg
     */
    case LUXEMBOURG = "LU";

    /**
     * Latvia
     */
    case LATVIA = "LV";

    /**
     * Libya
     */
    case LIBYA = "LY";

    /**
     * Morocco
     */
    case MOROCCO = "MA";

    /**
     * Monaco
     */
    case MONACO = "MC";

    /**
     * Moldova (the Republic of)
     */
    case MOLDOVA_THE_REPUBLIC_OF = "MD";

    /**
     * Montenegro
     */
    case MONTENEGRO = "ME";

    /**
     * Saint Martin (French part)
     */
    case SAINT_MARTIN_FRENCH_PART = "MF";

    /**
     * Madagascar
     */
    case MADAGASCAR = "MG";

    /**
     * Marshall Islands (the)
     */
    case MARSHALL_ISLANDS_THE = "MH";

    /**
     * North Macedonia
     */
    case NORTH_MACEDONIA = "MK";

    /**
     * Mali
     */
    case MALI = "ML";

    /**
     * Myanmar
     */
    case MYANMAR = "MM";

    /**
     * Mongolia
     */
    case MONGOLIA = "MN";

    /**
     * Macao
     */
    case MACAO = "MO";

    /**
     * Northern Mariana Islands (the)
     */
    case NORTHERN_MARIANA_ISLANDS_THE = "MP";

    /**
     * Martinique
     */
    case MARTINIQUE = "MQ";

    /**
     * Mauritania
     */
    case MAURITANIA = "MR";

    /**
     * Montserrat
     */
    case MONTSERRAT = "MS";

    /**
     * Malta
     */
    case MALTA = "MT";

    /**
     * Mauritius
     */
    case MAURITIUS = "MU";

    /**
     * Maldives
     */
    case MALDIVES = "MV";

    /**
     * Malawi
     */
    case MALAWI = "MW";

    /**
     * Mexico
     */
    case MEXICO = "MX";

    /**
     * Malaysia
     */
    case MALAYSIA = "MY";

    /**
     * Mozambique
     */
    case MOZAMBIQUE = "MZ";

    /**
     * Namibia
     */
    case NAMIBIA = "NA";

    /**
     * New Caledonia
     */
    case NEW_CALEDONIA = "NC";

    /**
     * Niger (the)
     */
    case NIGER_THE = "NE";

    /**
     * Norfolk Island
     */
    case NORFOLK_ISLAND = "NF";

    /**
     * Nigeria
     */
    case NIGERIA = "NG";

    /**
     * Nicaragua
     */
    case NICARAGUA = "NI";

    /**
     * Netherlands (the)
     */
    case NETHERLANDS_THE = "NL";

    /**
     * Norway
     */
    case NORWAY = "NO";

    /**
     * Nepal
     */
    case NEPAL = "NP";

    /**
     * Nauru
     */
    case NAURU = "NR";

    /**
     * Niue
     */
    case NIUE = "NU";

    /**
     * New Zealand
     */
    case NEW_ZEALAND = "NZ";

    /**
     * Oman
     */
    case OMAN = "OM";

    /**
     * Panama
     */
    case PANAMA = "PA";

    /**
     * Peru
     */
    case PERU = "PE";

    /**
     * French Polynesia
     */
    case FRENCH_POLYNESIA = "PF";

    /**
     * Papua New Guinea
     */
    case PAPUA_NEW_GUINEA = "PG";

    /**
     * Philippines (the)
     */
    case PHILIPPINES_THE = "PH";

    /**
     * Pakistan
     */
    case PAKISTAN = "PK";

    /**
     * Poland
     */
    case POLAND = "PL";

    /**
     * Saint Pierre and Miquelon
     */
    case SAINT_PIERRE_AND_MIQUELON = "PM";

    /**
     * Pitcairn
     */
    case PITCAIRN = "PN";

    /**
     * Puerto Rico
     */
    case PUERTO_RICO = "PR";

    /**
     * Palestine, State of
     */
    case PALESTINE_STATE_OF = "PS";

    /**
     * Portugal
     */
    case PORTUGAL = "PT";

    /**
     * Palau
     */
    case PALAU = "PW";

    /**
     * Paraguay
     */
    case PARAGUAY = "PY";

    /**
     * Qatar
     */
    case QATAR = "QA";

    /**
     * Réunion
     */
    case RUNION = "RE";

    /**
     * Romania
     */
    case ROMANIA = "RO";

    /**
     * Serbia
     */
    case SERBIA = "RS";

    /**
     * Russian Federation (the)
     */
    case RUSSIAN_FEDERATION_THE = "RU";

    /**
     * Rwanda
     */
    case RWANDA = "RW";

    /**
     * Saudi Arabia
     */
    case SAUDI_ARABIA = "SA";

    /**
     * Solomon Islands
     */
    case SOLOMON_ISLANDS = "SB";

    /**
     * Seychelles
     */
    case SEYCHELLES = "SC";

    /**
     * Sudan (the)
     */
    case SUDAN_THE = "SD";

    /**
     * Sweden
     */
    case SWEDEN = "SE";

    /**
     * Singapore
     */
    case SINGAPORE = "SG";

    /**
     * Saint Helena, Ascension and Tristan da Cunha
     */
    case SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA = "SH";

    /**
     * Slovenia
     */
    case SLOVENIA = "SI";

    /**
     * Svalbard and Jan Mayen
     */
    case SVALBARD_AND_JAN_MAYEN = "SJ";

    /**
     * Slovakia
     */
    case SLOVAKIA = "SK";

    /**
     * Sierra Leone
     */
    case SIERRA_LEONE = "SL";

    /**
     * San Marino
     */
    case SAN_MARINO = "SM";

    /**
     * Senegal
     */
    case SENEGAL = "SN";

    /**
     * Somalia
     */
    case SOMALIA = "SO";

    /**
     * Suriname
     */
    case SURINAME = "SR";

    /**
     * South Sudan
     */
    case SOUTH_SUDAN = "SS";

    /**
     * Sao Tome and Principe
     */
    case SAO_TOME_AND_PRINCIPE = "ST";

    /**
     * El Salvador
     */
    case EL_SALVADOR = "SV";

    /**
     * Sint Maarten (Dutch part)
     */
    case SINT_MAARTEN_DUTCH_PART = "SX";

    /**
     * Syrian Arab Republic (the)
     */
    case SYRIAN_ARAB_REPUBLIC_THE = "SY";

    /**
     * Eswatini
     */
    case ESWATINI = "SZ";

    /**
     * Turks and Caicos Islands (the)
     */
    case TURKS_AND_CAICOS_ISLANDS_THE = "TC";

    /**
     * Chad
     */
    case CHAD = "TD";

    /**
     * French Southern Territories (the)
     */
    case FRENCH_SOUTHERN_TERRITORIES_THE = "TF";

    /**
     * Togo
     */
    case TOGO = "TG";

    /**
     * Thailand
     */
    case THAILAND = "TH";

    /**
     * Tajikistan
     */
    case TAJIKISTAN = "TJ";

    /**
     * Tokelau
     */
    case TOKELAU = "TK";

    /**
     * Timor-Leste
     */
    case TIMORLESTE = "TL";

    /**
     * Turkmenistan
     */
    case TURKMENISTAN = "TM";

    /**
     * Tunisia
     */
    case TUNISIA = "TN";

    /**
     * Tonga
     */
    case TONGA = "TO";

    /**
     * Turkey
     */
    case TURKEY = "TR";

    /**
     * Trinidad and Tobago
     */
    case TRINIDAD_AND_TOBAGO = "TT";

    /**
     * Tuvalu
     */
    case TUVALU = "TV";

    /**
     * Taiwan (Province of China)
     */
    case TAIWAN_PROVINCE_OF_CHINA = "TW";

    /**
     * Tanzania, the United Republic of
     */
    case TANZANIA_THE_UNITED_REPUBLIC_OF = "TZ";

    /**
     * Ukraine
     */
    case UKRAINE = "UA";

    /**
     * Uganda
     */
    case UGANDA = "UG";

    /**
     * United States Minor Outlying Islands (the)
     */
    case UNITED_STATES_MINOR_OUTLYING_ISLANDS_THE = "UM";

    /**
     * United States of America (the)
     */
    case UNITED_STATES_OF_AMERICA_THE = "US";

    /**
     * Uruguay
     */
    case URUGUAY = "UY";

    /**
     * Uzbekistan
     */
    case UZBEKISTAN = "UZ";

    /**
     * Holy See (the)
     */
    case HOLY_SEE_THE = "VA";

    /**
     * Saint Vincent and the Grenadines
     */
    case SAINT_VINCENT_AND_THE_GRENADINES = "VC";

    /**
     * Venezuela (Bolivarian Republic of)
     */
    case VENEZUELA_BOLIVARIAN_REPUBLIC_OF = "VE";

    /**
     * Virgin Islands (British)
     */
    case VIRGIN_ISLANDS_BRITISH = "VG";

    /**
     * Virgin Islands (U.S.)
     */
    case VIRGIN_ISLANDS_US = "VI";

    /**
     * Viet Nam
     */
    case VIET_NAM = "VN";

    /**
     * Vanuatu
     */
    case VANUATU = "VU";

    /**
     * Wallis and Futuna
     */
    case WALLIS_AND_FUTUNA = "WF";

    /**
     * Samoa
     */
    case SAMOA = "WS";

    /**
     * Yemen
     */
    case YEMEN = "YE";

    /**
     * Mayotte
     */
    case MAYOTTE = "YT";

    /**
     * South Africa
     */
    case SOUTH_AFRICA = "ZA";

    /**
     * Zambia
     */
    case ZAMBIA = "ZM";

    /**
     * Zimbabwe
     */
    case ZIMBABWE = "ZW";

    /**
     * Kosovo
     */
    case KOSOVO = "1A";
}
