<?php

namespace ContainerSOR749e;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/*
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class Shopware_Core_KernelProdContainer extends Container
{
    private const NONEMPTY_PARAMETERS = [
        'kernel.secret' => 'A non-empty value for the parameter "kernel.secret" is required. Did you forget to configure the "APP_SECRET" env var?',
    ];

    protected $targetDir;
    protected $parameters = [];
    protected \Closure $getService;

    public function __construct(private array $buildParameters = [], protected string $containerDir = __DIR__)
    {
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
        ];
        $this->methodMap = [
            'Doctrine\\DBAL\\Connection' => 'getConnectionService',
            'OpenSearch\\Client' => 'getClientService',
            'Pentatrion\\ViteBundle\\Controller\\ProfilerController' => 'getProfilerControllerService',
            'Pentatrion\\ViteBundle\\Controller\\ViteController' => 'getViteControllerService',
            'Shopware\\Administration\\Controller\\AdminExtensionApiController' => 'getAdminExtensionApiControllerService',
            'Shopware\\Administration\\Controller\\AdminProductStreamController' => 'getAdminProductStreamControllerService',
            'Shopware\\Administration\\Controller\\AdminSearchController' => 'getAdminSearchControllerService',
            'Shopware\\Administration\\Controller\\AdminTagController' => 'getAdminTagControllerService',
            'Shopware\\Administration\\Controller\\AdministrationController' => 'getAdministrationControllerService',
            'Shopware\\Administration\\Controller\\DashboardController' => 'getDashboardControllerService',
            'Shopware\\Administration\\Controller\\NotificationController' => 'getNotificationControllerService',
            'Shopware\\Administration\\Controller\\UserConfigController' => 'getUserConfigControllerService',
            'Shopware\\Administration\\Notification\\NotificationDefinition' => 'getNotificationDefinitionService',
            'Shopware\\Administration\\Notification\\NotificationService' => 'getNotificationServiceService',
            'Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition' => 'getAppAdministrationSnippetDefinitionService',
            'Shopware\\Core\\Checkout\\Cart\\Calculator' => 'getCalculatorService',
            'Shopware\\Core\\Checkout\\Cart\\Facade\\CartFacadeHookFactory' => 'getCartFacadeHookFactoryService',
            'Shopware\\Core\\Checkout\\Cart\\Facade\\PriceFactoryFactory' => 'getPriceFactoryFactoryService',
            'Shopware\\Core\\Checkout\\Cart\\Order\\Api\\OrderConverterController' => 'getOrderConverterControllerService',
            'Shopware\\Core\\Checkout\\Cart\\Order\\Api\\OrderRecalculationController' => 'getOrderRecalculationControllerService',
            'Shopware\\Core\\Checkout\\Cart\\PriceActionController' => 'getPriceActionControllerService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute' => 'getCartDeleteRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute' => 'getCartItemAddRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute' => 'getCartItemRemoveRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute' => 'getCartItemUpdateRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute' => 'getCartLoadRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute' => 'getCartOrderRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService' => 'getCartServiceService',
            'Shopware\\Core\\Checkout\\Cart\\TaxProvider\\TaxProviderRegistry' => 'getTaxProviderRegistryService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition' => 'getCustomerAddressDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition' => 'getCustomerGroupRegistrationSalesChannelDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition' => 'getCustomerGroupTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition' => 'getCustomerGroupDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition' => 'getCustomerRecoveryDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition' => 'getCustomerTagDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition' => 'getCustomerWishlistProductDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition' => 'getCustomerWishlistDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Api\\CustomerGroupRegistrationActionController' => 'getCustomerGroupRegistrationActionControllerService',
            'Shopware\\Core\\Checkout\\Customer\\CustomerDefinition' => 'getCustomerDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountNewsletterRecipientRoute' => 'getAccountNewsletterRecipientRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AddWishlistProductRoute' => 'getAddWishlistProductRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeCustomerProfileRoute' => 'getChangeCustomerProfileRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeEmailRoute' => 'getChangeEmailRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeLanguageRoute' => 'getChangeLanguageRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangePasswordRoute' => 'getChangePasswordRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerGroupRegistrationSettingsRoute' => 'getCustomerGroupRegistrationSettingsRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRecoveryIsExpiredRoute' => 'getCustomerRecoveryIsExpiredRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRoute' => 'getCustomerRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteAddressRoute' => 'getDeleteAddressRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteCustomerRoute' => 'getDeleteCustomerRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DownloadRoute' => 'getDownloadRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ImitateCustomerRoute' => 'getImitateCustomerRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ListAddressRoute' => 'getListAddressRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoadWishlistRoute' => 'getLoadWishlistRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoginRoute' => 'getLoginRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute' => 'getLogoutRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\MergeWishlistProductRoute' => 'getMergeWishlistProductRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterConfirmRoute' => 'getRegisterConfirmRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterRoute' => 'getRegisterRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RemoveWishlistProductRoute' => 'getRemoveWishlistProductRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ResetPasswordRoute' => 'getResetPasswordRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SendPasswordRecoveryMailRoute' => 'getSendPasswordRecoveryMailRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute' => 'getSwitchDefaultAddressRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\UpsertAddressRoute' => 'getUpsertAddressRouteService',
            'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition' => 'getDocumentBaseConfigSalesChannelDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition' => 'getDocumentBaseConfigDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition' => 'getDocumentTypeTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition' => 'getDocumentTypeDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\Controller\\DocumentController' => 'getDocumentControllerService',
            'Shopware\\Core\\Checkout\\Document\\DocumentDefinition' => 'getDocumentDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\DocumentGeneratorController' => 'getDocumentGeneratorControllerService',
            'Shopware\\Core\\Checkout\\Document\\SalesChannel\\DocumentRoute' => 'getDocumentRouteService',
            'Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute' => 'getCheckoutGatewayRouteService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition' => 'getOrderAddressDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition' => 'getOrderCustomerDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition' => 'getOrderDeliveryPositionDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition' => 'getOrderDeliveryDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItemDownload\\OrderLineItemDownloadDefinition' => 'getOrderLineItemDownloadDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition' => 'getOrderLineItemDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition' => 'getOrderTagDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition' => 'getOrderTransactionCaptureRefundPositionDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition' => 'getOrderTransactionCaptureRefundDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition' => 'getOrderTransactionCaptureDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition' => 'getOrderTransactionDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Api\\OrderActionController' => 'getOrderActionControllerService',
            'Shopware\\Core\\Checkout\\Order\\OrderDefinition' => 'getOrderDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\SalesChannel\\CancelOrderRoute' => 'getCancelOrderRouteService',
            'Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute' => 'getOrderRouteService',
            'Shopware\\Core\\Checkout\\Order\\SalesChannel\\SetPaymentOrderRoute' => 'getSetPaymentOrderRouteService',
            'Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition' => 'getPaymentMethodTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentRecurringProcessor' => 'getPaymentRecurringProcessorService',
            'Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentRefundProcessor' => 'getPaymentRefundProcessorService',
            'Shopware\\Core\\Checkout\\Payment\\Controller\\PaymentController' => 'getPaymentControllerService',
            'Shopware\\Core\\Checkout\\Payment\\PaymentMethodDefinition' => 'getPaymentMethodDefinitionService',
            'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\HandlePaymentMethodRoute' => 'getHandlePaymentMethodRouteService',
            'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\PaymentMethodRoute' => 'getPaymentMethodRouteService',
            'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition' => 'getSalesChannelPaymentMethodDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition' => 'getPromotionCartRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition' => 'getPromotionDiscountPriceDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition' => 'getPromotionDiscountRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition' => 'getPromotionDiscountDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition' => 'getPromotionIndividualCodeDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition' => 'getPromotionOrderRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition' => 'getPromotionPersonaCustomerDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition' => 'getPromotionPersonaRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition' => 'getPromotionSalesChannelDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition' => 'getPromotionSetGroupRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition' => 'getPromotionSetGroupDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition' => 'getPromotionTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Api\\PromotionActionController' => 'getPromotionActionControllerService',
            'Shopware\\Core\\Checkout\\Promotion\\Api\\PromotionController' => 'getPromotionControllerService',
            'Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition' => 'getPromotionDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition' => 'getShippingMethodPriceDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition' => 'getShippingMethodTagDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition' => 'getShippingMethodTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition' => 'getSalesChannelShippingMethodDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\ShippingMethodRoute' => 'getShippingMethodRouteService',
            'Shopware\\Core\\Checkout\\Shipping\\ShippingMethodDefinition' => 'getShippingMethodDefinitionService',
            'Shopware\\Core\\Content\\Breadcrumb\\SalesChannel\\BreadcrumbRoute' => 'getBreadcrumbRouteService',
            'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition' => 'getCategoryTagDefinitionService',
            'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition' => 'getCategoryTranslationDefinitionService',
            'Shopware\\Core\\Content\\Category\\CategoryDefinition' => 'getCategoryDefinitionService',
            'Shopware\\Core\\Content\\Category\\CategoryHydrator' => 'getCategoryHydratorService',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\CategoryListRoute' => 'getCategoryListRouteService',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\CategoryRoute' => 'getCategoryRouteService',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition' => 'getSalesChannelCategoryDefinitionService',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\TreeBuildingNavigationRoute' => 'getTreeBuildingNavigationRouteService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition' => 'getCmsBlockDefinitionService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition' => 'getCmsPageTranslationDefinitionService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition' => 'getCmsSectionDefinitionService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition' => 'getCmsSlotTranslationDefinitionService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition' => 'getCmsSlotDefinitionService',
            'Shopware\\Core\\Content\\Cms\\CmsPageDefinition' => 'getCmsPageDefinitionService',
            'Shopware\\Core\\Content\\Cms\\DataAbstractionLayer\\FieldSerializer\\SlotConfigFieldSerializer' => 'getSlotConfigFieldSerializerService',
            'Shopware\\Core\\Content\\Cms\\DataResolver\\CmsSlotsDataResolver' => 'getCmsSlotsDataResolverService',
            'Shopware\\Core\\Content\\Cms\\SalesChannel\\CmsRoute' => 'getCmsRouteService',
            'Shopware\\Core\\Content\\ContactForm\\SalesChannel\\ContactFormRoute' => 'getContactFormRouteService',
            'Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition' => 'getFlowSequenceDefinitionService',
            'Shopware\\Core\\Content\\Flow\\Aggregate\\FlowTemplate\\FlowTemplateDefinition' => 'getFlowTemplateDefinitionService',
            'Shopware\\Core\\Content\\Flow\\Controller\\TriggerFlowController' => 'getTriggerFlowControllerService',
            'Shopware\\Core\\Content\\Flow\\DataAbstractionLayer\\FieldSerializer\\FlowTemplateConfigFieldSerializer' => 'getFlowTemplateConfigFieldSerializerService',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\CachedFlowLoader' => 'getCachedFlowLoaderService',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor' => 'getFlowExecutorService',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowFactory' => 'getFlowFactoryService',
            'Shopware\\Core\\Content\\Flow\\FlowDefinition' => 'getFlowDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition' => 'getImportExportFileDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition' => 'getImportExportLogDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\Controller\\ImportExportActionController' => 'getImportExportActionControllerService',
            'Shopware\\Core\\Content\\ImportExport\\ImportExportFactory' => 'getImportExportFactoryService',
            'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition' => 'getImportExportProfileDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition' => 'getImportExportProfileTranslationDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler' => 'getImportExportHandlerService',
            'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition' => 'getLandingPageSalesChannelDefinitionService',
            'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition' => 'getLandingPageTagDefinitionService',
            'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition' => 'getLandingPageTranslationDefinitionService',
            'Shopware\\Core\\Content\\LandingPage\\LandingPageDefinition' => 'getLandingPageDefinitionService',
            'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\LandingPageRoute' => 'getLandingPageRouteService',
            'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition' => 'getSalesChannelLandingPageDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition' => 'getMailHeaderFooterTranslationDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition' => 'getMailHeaderFooterDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition' => 'getMailTemplateMediaDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition' => 'getMailTemplateTranslationDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition' => 'getMailTemplateTypeTranslationDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition' => 'getMailTemplateTypeDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Api\\MailActionController' => 'getMailActionControllerService',
            'Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition' => 'getMailTemplateDefinitionService',
            'Shopware\\Core\\Content\\Mail\\Service\\MailAttachmentsBuilder' => 'getMailAttachmentsBuilderService',
            'Shopware\\Core\\Content\\Mail\\Service\\MailFactory' => 'getMailFactoryService',
            'Shopware\\Core\\Content\\Mail\\Service\\MailSender' => 'getMailSenderService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition' => 'getMediaDefaultFolderDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition' => 'getMediaFolderConfigurationMediaThumbnailSizeDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition' => 'getMediaFolderConfigurationDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition' => 'getMediaFolderDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition' => 'getMediaTagDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition' => 'getMediaThumbnailSizeDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition' => 'getMediaThumbnailDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition' => 'getMediaTranslationDefinitionService',
            'Shopware\\Core\\Content\\Media\\Api\\MediaFolderController' => 'getMediaFolderControllerService',
            'Shopware\\Core\\Content\\Media\\Api\\MediaUploadController' => 'getMediaUploadControllerService',
            'Shopware\\Core\\Content\\Media\\File\\FileSaver' => 'getFileSaverService',
            'Shopware\\Core\\Content\\Media\\MediaDefinition' => 'getMediaDefinitionService',
            'Shopware\\Core\\Content\\Media\\MediaHydrator' => 'getMediaHydratorService',
            'Shopware\\Core\\Content\\Media\\MediaUrlPlaceholderHandlerInterface' => 'getMediaUrlPlaceholderHandlerInterfaceService',
            'Shopware\\Core\\Content\\Media\\SalesChannel\\MediaRoute' => 'getMediaRouteService',
            'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition' => 'getNewsletterRecipientTagDefinitionService',
            'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipient\\NewsletterRecipientDefinition' => 'getNewsletterRecipientDefinitionService',
            'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterConfirmRoute' => 'getNewsletterConfirmRouteService',
            'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterSubscribeRoute' => 'getNewsletterSubscribeRouteService',
            'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterUnsubscribeRoute' => 'getNewsletterUnsubscribeRouteService',
            'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition' => 'getSalesChannelNewsletterRecipientDefinitionService',
            'Shopware\\Core\\Content\\ProductExport\\Api\\ProductExportController' => 'getProductExportControllerService',
            'Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition' => 'getProductExportDefinitionService',
            'Shopware\\Core\\Content\\ProductExport\\ProductExportHydrator' => 'getProductExportHydratorService',
            'Shopware\\Core\\Content\\ProductExport\\SalesChannel\\ExportController' => 'getExportControllerService',
            'Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator' => 'getProductExportGeneratorService',
            'Shopware\\Core\\Content\\ProductExport\\Service\\ProductExporter' => 'getProductExporterService',
            'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition' => 'getProductStreamFilterDefinitionService',
            'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterHydrator' => 'getProductStreamFilterHydratorService',
            'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition' => 'getProductStreamTranslationDefinitionService',
            'Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition' => 'getProductStreamDefinitionService',
            'Shopware\\Core\\Content\\ProductStream\\ProductStreamHydrator' => 'getProductStreamHydratorService',
            'Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder' => 'getProductStreamBuilderService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition' => 'getProductCategoryTreeDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition' => 'getProductCategoryDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition' => 'getProductConfiguratorSettingDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingHydrator' => 'getProductConfiguratorSettingHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition' => 'getProductCrossSellingAssignedProductsDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsHydrator' => 'getProductCrossSellingAssignedProductsHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition' => 'getProductCrossSellingTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition' => 'getProductCrossSellingDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingHydrator' => 'getProductCrossSellingHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition' => 'getProductCustomFieldSetDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductDownload\\ProductDownloadDefinition' => 'getProductDownloadDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition' => 'getProductFeatureSetTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition' => 'getProductFeatureSetDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetHydrator' => 'getProductFeatureSetHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition' => 'getProductKeywordDictionaryDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryHydrator' => 'getProductKeywordDictionaryHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition' => 'getProductManufacturerTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition' => 'getProductManufacturerDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerHydrator' => 'getProductManufacturerHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition' => 'getProductMediaDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaHydrator' => 'getProductMediaHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition' => 'getProductOptionDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition' => 'getProductPriceDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceHydrator' => 'getProductPriceHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition' => 'getProductPropertyDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition' => 'getProductReviewDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewHydrator' => 'getProductReviewHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition' => 'getProductSearchConfigFieldDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldHydrator' => 'getProductSearchConfigFieldHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition' => 'getProductSearchConfigDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigHydrator' => 'getProductSearchConfigHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition' => 'getProductSearchKeywordDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordHydrator' => 'getProductSearchKeywordHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition' => 'getProductStreamMappingDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition' => 'getProductTagDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition' => 'getProductTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition' => 'getProductVisibilityDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityHydrator' => 'getProductVisibilityHydratorService',
            'Shopware\\Core\\Content\\Product\\Api\\ProductActionController' => 'getProductActionControllerService',
            'Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\CheapestPrice\\CheapestPriceAccessorBuilder' => 'getCheapestPriceAccessorBuilderService',
            'Shopware\\Core\\Content\\Product\\ProductDefinition' => 'getProductDefinitionService',
            'Shopware\\Core\\Content\\Product\\ProductHydrator' => 'getProductHydratorService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\ProductCrossSellingRoute' => 'getProductCrossSellingRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\ProductDetailRoute' => 'getProductDetailRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\FindVariant\\FindProductVariantRoute' => 'getFindProductVariantRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute' => 'getResolveCriteriaProductListingRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\ProductListRoute' => 'getProductListRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewRoute' => 'getProductReviewRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewSaveRoute' => 'getProductReviewSaveRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition' => 'getSalesChannelProductDefinitionService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute' => 'getResolvedCriteriaProductSearchRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition' => 'getProductSortingDefinitionService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingHydrator' => 'getProductSortingHydratorService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition' => 'getProductSortingTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\ResolvedCriteriaProductSuggestRoute' => 'getResolvedCriteriaProductSuggestRouteService',
            'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition' => 'getPropertyGroupOptionTranslationDefinitionService',
            'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition' => 'getPropertyGroupOptionDefinitionService',
            'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionHydrator' => 'getPropertyGroupOptionHydratorService',
            'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition' => 'getPropertyGroupTranslationDefinitionService',
            'Shopware\\Core\\Content\\Property\\PropertyGroupDefinition' => 'getPropertyGroupDefinitionService',
            'Shopware\\Core\\Content\\Property\\PropertyGroupHydrator' => 'getPropertyGroupHydratorService',
            'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition' => 'getRuleConditionDefinitionService',
            'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition' => 'getRuleTagDefinitionService',
            'Shopware\\Core\\Content\\Rule\\RuleDefinition' => 'getRuleDefinitionService',
            'Shopware\\Core\\Content\\Seo\\Api\\SeoActionController' => 'getSeoActionControllerService',
            'Shopware\\Core\\Content\\Seo\\EmptyPathInfoResolver' => 'getEmptyPathInfoResolverService',
            'Shopware\\Core\\Content\\Seo\\MainCategory\\MainCategoryDefinition' => 'getMainCategoryDefinitionService',
            'Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition' => 'getSalesChannelMainCategoryDefinitionService',
            'Shopware\\Core\\Content\\Seo\\SalesChannel\\SeoUrlRoute' => 'getSeoUrlRouteService',
            'Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface' => 'getSeoUrlPlaceholderHandlerInterfaceService',
            'Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition' => 'getSeoUrlTemplateDefinitionService',
            'Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition' => 'getSalesChannelSeoUrlDefinitionService',
            'Shopware\\Core\\Content\\Seo\\SeoUrl\\SeoUrlDefinition' => 'getSeoUrlDefinitionService',
            'Shopware\\Core\\Content\\Sitemap\\SalesChannel\\SitemapFileRoute' => 'getSitemapFileRouteService',
            'Shopware\\Core\\Content\\Sitemap\\SalesChannel\\SitemapRoute' => 'getSitemapRouteService',
            'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidator' => 'getCacheInvalidatorService',
            'Shopware\\Core\\Framework\\Adapter\\Cache\\Http\\CacheStore' => 'getCacheStoreService',
            'Shopware\\Core\\Framework\\Adapter\\Cache\\Script\\Facade\\CacheInvalidatorFacadeHookFactory' => 'getCacheInvalidatorFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\Adapter\\Storage\\AbstractKeyValueStorage' => 'getAbstractKeyValueStorageService',
            'Shopware\\Core\\Framework\\Adapter\\Twig\\AppTemplateIterator' => 'getAppTemplateIteratorService',
            'Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder' => 'getTemplateFinderService',
            'Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateIterator' => 'getTemplateIteratorService',
            'Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator' => 'getAclCriteriaValidatorService',
            'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition' => 'getAclRoleDefinitionService',
            'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition' => 'getAclUserRoleDefinitionService',
            'Shopware\\Core\\Framework\\Api\\Controller\\AccessKeyController' => 'getAccessKeyControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\AclController' => 'getAclControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\ApiController' => 'getApiControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\AuthController' => 'getAuthControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\CacheController' => 'getCacheControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\CustomSnippetFormatController' => 'getCustomSnippetFormatControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\FallbackController' => 'getFallbackControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\FeatureFlagController' => 'getFeatureFlagControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\HealthCheckController' => 'getHealthCheckControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\IndexingController' => 'getIndexingControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\InfoController' => 'getInfoControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\IntegrationController' => 'getIntegrationControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\SalesChannelProxyController' => 'getSalesChannelProxyControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\SyncController' => 'getSyncControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\UserController' => 'getUserControllerService',
            'Shopware\\Core\\Framework\\Api\\Sync\\SyncService' => 'getSyncServiceService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition' => 'getActionButtonTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition' => 'getActionButtonDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition' => 'getAppPaymentMethodDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition' => 'getAppScriptConditionTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition' => 'getAppScriptConditionDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\AppShippingMethod\\AppShippingMethodDefinition' => 'getAppShippingMethodDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition' => 'getAppTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition' => 'getAppCmsBlockTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition' => 'getAppCmsBlockDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition' => 'getAppFlowActionTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition' => 'getAppFlowActionDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\FlowEvent\\AppFlowEventDefinition' => 'getAppFlowEventDefinitionService',
            'Shopware\\Core\\Framework\\App\\Api\\AppActionController' => 'getAppActionControllerService',
            'Shopware\\Core\\Framework\\App\\Api\\AppCmsController' => 'getAppCmsControllerService',
            'Shopware\\Core\\Framework\\App\\Api\\AppJWTGenerateRoute' => 'getAppJWTGenerateRouteService',
            'Shopware\\Core\\Framework\\App\\Api\\AppUrlChangeController' => 'getAppUrlChangeControllerService',
            'Shopware\\Core\\Framework\\App\\AppDefinition' => 'getAppDefinitionService',
            'Shopware\\Core\\Framework\\App\\AppLocaleProvider' => 'getAppLocaleProviderService',
            'Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\Resolver' => 'getResolverService',
            'Shopware\\Core\\Framework\\App\\Flow\\Action\\AppFlowActionProvider' => 'getAppFlowActionProviderService',
            'Shopware\\Core\\Framework\\App\\Payload\\AppPayloadServiceHelper' => 'getAppPayloadServiceHelperService',
            'Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider' => 'getShopIdProviderService',
            'Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition' => 'getTemplateDefinitionService',
            'Shopware\\Core\\Framework\\App\\Template\\TemplateStateService' => 'getTemplateStateServiceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator' => 'getEntityCacheKeyGeneratorService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityHydrator' => 'getEntityHydratorService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\ConfigJsonFieldAccessorBuilder' => 'getConfigJsonFieldAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\CustomFieldsAccessorBuilder' => 'getCustomFieldsAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\DefaultFieldAccessorBuilder' => 'getDefaultFieldAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\JsonFieldAccessorBuilder' => 'getJsonFieldAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\PriceFieldAccessorBuilder' => 'getPriceFieldAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\ManyToManyAssociationFieldResolver' => 'getManyToManyAssociationFieldResolverService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\ManyToOneAssociationFieldResolver' => 'getManyToOneAssociationFieldResolverService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\OneToManyAssociationFieldResolver' => 'getOneToManyAssociationFieldResolverService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\TranslationFieldResolver' => 'getTranslationFieldResolverService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\JoinGroupBuilder' => 'getJoinGroupBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry' => 'getDefinitionInstanceRegistryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory' => 'getEntityLoadedEventFactoryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\RepositoryFacadeHookFactory' => 'getRepositoryFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\RepositoryWriterFacadeHookFactory' => 'getRepositoryWriterFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\SalesChannelRepositoryFacadeHookFactory' => 'getSalesChannelRepositoryFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\BlobFieldSerializer' => 'getBlobFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\BoolFieldSerializer' => 'getBoolFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CalculatedPriceFieldSerializer' => 'getCalculatedPriceFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CartPriceFieldSerializer' => 'getCartPriceFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CashRoundingConfigFieldSerializer' => 'getCashRoundingConfigFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ConfigJsonFieldSerializer' => 'getConfigJsonFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CreatedAtFieldSerializer' => 'getCreatedAtFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CreatedByFieldSerializer' => 'getCreatedByFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CronIntervalFieldSerializer' => 'getCronIntervalFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer' => 'getCustomFieldsSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateFieldSerializer' => 'getDateFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateIntervalFieldSerializer' => 'getDateIntervalFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateTimeFieldSerializer' => 'getDateTimeFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\EmailFieldSerializer' => 'getEmailFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\EnumFieldSerializer' => 'getEnumFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\FkFieldSerializer' => 'getFkFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\FloatFieldSerializer' => 'getFloatFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\IdFieldSerializer' => 'getIdFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\IntFieldSerializer' => 'getIntFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\JsonFieldSerializer' => 'getJsonFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ListFieldSerializer' => 'getListFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\LongTextFieldSerializer' => 'getLongTextFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ManyToManyAssociationFieldSerializer' => 'getManyToManyAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ManyToOneAssociationFieldSerializer' => 'getManyToOneAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\OneToManyAssociationFieldSerializer' => 'getOneToManyAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\OneToOneAssociationFieldSerializer' => 'getOneToOneAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PHPUnserializeFieldSerializer' => 'getPHPUnserializeFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PasswordFieldSerializer' => 'getPasswordFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PriceDefinitionFieldSerializer' => 'getPriceDefinitionFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PriceFieldSerializer' => 'getPriceFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ReferenceVersionFieldSerializer' => 'getReferenceVersionFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\RemoteAddressFieldSerializer' => 'getRemoteAddressFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\StateMachineStateFieldSerializer' => 'getStateMachineStateFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\StringFieldSerializer' => 'getStringFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TaxFreeConfigFieldSerializer' => 'getTaxFreeConfigFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TimeZoneFieldSerializer' => 'getTimeZoneFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TranslatedFieldSerializer' => 'getTranslatedFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TranslationsAssociationFieldSerializer' => 'getTranslationsAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\UpdatedAtFieldSerializer' => 'getUpdatedAtFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\UpdatedByFieldSerializer' => 'getUpdatedByFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VariantListingConfigFieldSerializer' => 'getVariantListingConfigFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VersionDataPayloadFieldSerializer' => 'getVersionDataPayloadFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VersionFieldSerializer' => 'getVersionFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry' => 'getEntityIndexerRegistryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface' => 'getEntityReaderInterfaceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface' => 'getEntityAggregatorInterfaceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface' => 'getEntitySearcherInterfaceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager' => 'getVersionManagerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition' => 'getVersionCommitDataDefinitionService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition' => 'getVersionCommitDefinitionService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition' => 'getVersionDefinitionService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface' => 'getEntityWriteGatewayInterfaceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter' => 'getEntityWriterService',
            'Shopware\\Core\\Framework\\Event\\BusinessEventCollector' => 'getBusinessEventCollectorService',
            'Shopware\\Core\\Framework\\Event\\BusinessEventRegistry' => 'getBusinessEventRegistryService',
            'Shopware\\Core\\Framework\\Feature\\FeatureFlagRegistry' => 'getFeatureFlagRegistryService',
            'Shopware\\Core\\Framework\\Increment\\Controller\\IncrementApiController' => 'getIncrementApiControllerService',
            'Shopware\\Core\\Framework\\Log\\LogEntryDefinition' => 'getLogEntryDefinitionService',
            'Shopware\\Core\\Framework\\MessageQueue\\Api\\ConsumeMessagesController' => 'getConsumeMessagesControllerService',
            'Shopware\\Core\\Framework\\MessageQueue\\Api\\ScheduledTaskController' => 'getScheduledTaskControllerService',
            'Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition' => 'getScheduledTaskDefinitionService',
            'Shopware\\Core\\Framework\\Migration\\IndexerQueuer' => 'getIndexerQueuerService',
            'Shopware\\Core\\Framework\\Migration\\MigrationCollectionLoader' => 'getMigrationCollectionLoaderService',
            'Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition' => 'getPluginTranslationDefinitionService',
            'Shopware\\Core\\Framework\\Plugin\\KernelPluginCollection' => 'getKernelPluginCollectionService',
            'Shopware\\Core\\Framework\\Plugin\\KernelPluginLoader\\KernelPluginLoader' => 'getKernelPluginLoaderService',
            'Shopware\\Core\\Framework\\Plugin\\PluginDefinition' => 'getPluginDefinitionService',
            'Shopware\\Core\\Framework\\Plugin\\Util\\PluginIdProvider' => 'getPluginIdProviderService',
            'Shopware\\Core\\Framework\\Routing\\CanonicalRedirectService' => 'getCanonicalRedirectServiceService',
            'Shopware\\Core\\Framework\\Routing\\Facade\\RequestFacadeFactory' => 'getRequestFacadeFactoryService',
            'Shopware\\Core\\Framework\\Routing\\RequestTransformerInterface' => 'getRequestTransformerInterfaceService',
            'Shopware\\Core\\Framework\\Rule\\Api\\RuleConfigController' => 'getRuleConfigControllerService',
            'Shopware\\Core\\Framework\\Script\\Api\\ScriptApiRoute' => 'getScriptApiRouteService',
            'Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseFactoryFacadeHookFactory' => 'getScriptResponseFactoryFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\Script\\Api\\ScriptStoreApiRoute' => 'getScriptStoreApiRouteService',
            'Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor' => 'getScriptExecutorService',
            'Shopware\\Core\\Framework\\Script\\ScriptDefinition' => 'getScriptDefinitionService',
            'Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreActionsController' => 'getExtensionStoreActionsControllerService',
            'Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreDataController' => 'getExtensionStoreDataControllerService',
            'Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreLicensesController' => 'getExtensionStoreLicensesControllerService',
            'Shopware\\Core\\Framework\\Store\\Api\\FirstRunWizardController' => 'getFirstRunWizardControllerService',
            'Shopware\\Core\\Framework\\Store\\Api\\StoreController' => 'getStoreControllerService',
            'Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider' => 'getStoreRequestOptionsProviderService',
            'Shopware\\Core\\Framework\\Store\\InAppPurchase' => 'getInAppPurchaseService',
            'Shopware\\Core\\Framework\\Store\\InAppPurchase\\Api\\InAppPurchasesController' => 'getInAppPurchasesControllerService',
            'Shopware\\Core\\Framework\\Store\\InAppPurchase\\Services\\InAppPurchaseUpdater' => 'getInAppPurchaseUpdaterService',
            'Shopware\\Core\\Framework\\Store\\Services\\ShopSecretInvalidMiddleware' => 'getShopSecretInvalidMiddlewareService',
            'Shopware\\Core\\Framework\\Store\\Services\\StoreSessionExpiredMiddleware' => 'getStoreSessionExpiredMiddlewareService',
            'Shopware\\Core\\Framework\\Telemetry\\Metrics\\Meter' => 'getMeterService',
            'Shopware\\Core\\Framework\\Update\\Api\\UpdateController' => 'getUpdateControllerService',
            'Shopware\\Core\\Framework\\Util\\HtmlSanitizer' => 'getHtmlSanitizerService',
            'Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition' => 'getWebhookEventLogDefinitionService',
            'Shopware\\Core\\Framework\\Webhook\\WebhookDefinition' => 'getWebhookDefinitionService',
            'Shopware\\Core\\Maintenance\\SalesChannel\\Service\\SalesChannelCreator' => 'getSalesChannelCreatorService',
            'Shopware\\Core\\Maintenance\\User\\Service\\UserProvisioner' => 'getUserProvisionerService',
            'Shopware\\Core\\Profiling\\Profiler' => 'getProfilerService',
            'Shopware\\Core\\Service\\Api\\ServiceController' => 'getServiceControllerService',
            'Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition' => 'getCountryStateTranslationDefinitionService',
            'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\CountryStateDefinition' => 'getCountryStateDefinitionService',
            'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition' => 'getSalesChannelCountryStateDefinitionService',
            'Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition' => 'getCountryTranslationDefinitionService',
            'Shopware\\Core\\System\\Country\\CountryDefinition' => 'getCountryDefinitionService',
            'Shopware\\Core\\System\\Country\\SalesChannel\\CountryRoute' => 'getCountryRouteService',
            'Shopware\\Core\\System\\Country\\SalesChannel\\CountryStateRoute' => 'getCountryStateRouteService',
            'Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition' => 'getSalesChannelCountryDefinitionService',
            'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition' => 'getCurrencyCountryRoundingDefinitionService',
            'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition' => 'getCurrencyTranslationDefinitionService',
            'Shopware\\Core\\System\\Currency\\CurrencyDefinition' => 'getCurrencyDefinitionService',
            'Shopware\\Core\\System\\Currency\\CurrencyFormatter' => 'getCurrencyFormatterService',
            'Shopware\\Core\\System\\Currency\\SalesChannel\\CurrencyRoute' => 'getCurrencyRouteService',
            'Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition' => 'getSalesChannelCurrencyDefinitionService',
            'Shopware\\Core\\System\\CustomEntity\\Api\\CustomEntityApiController' => 'getCustomEntityApiControllerService',
            'Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition' => 'getCustomEntityDefinitionService',
            'Shopware\\Core\\System\\CustomEntity\\CustomEntityRegistrar' => 'getCustomEntityRegistrarService',
            'Shopware\\Core\\System\\CustomEntity\\Schema\\CustomEntitySchemaUpdater' => 'getCustomEntitySchemaUpdaterService',
            'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition' => 'getCustomFieldSetRelationDefinitionService',
            'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition' => 'getCustomFieldSetDefinitionService',
            'Shopware\\Core\\System\\CustomField\\Api\\CustomFieldSetActionController' => 'getCustomFieldSetActionControllerService',
            'Shopware\\Core\\System\\CustomField\\CustomFieldDefinition' => 'getCustomFieldDefinitionService',
            'Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition' => 'getDeliveryTimeTranslationDefinitionService',
            'Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition' => 'getDeliveryTimeDefinitionService',
            'Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition' => 'getIntegrationRoleDefinitionService',
            'Shopware\\Core\\System\\Integration\\IntegrationDefinition' => 'getIntegrationDefinitionService',
            'Shopware\\Core\\System\\Language\\LanguageDefinition' => 'getLanguageDefinitionService',
            'Shopware\\Core\\System\\Language\\SalesChannel\\LanguageRoute' => 'getLanguageRouteService',
            'Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition' => 'getSalesChannelLanguageDefinitionService',
            'Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition' => 'getLocaleTranslationDefinitionService',
            'Shopware\\Core\\System\\Locale\\LocaleDefinition' => 'getLocaleDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition' => 'getNumberRangeSalesChannelDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition' => 'getNumberRangeStateDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition' => 'getNumberRangeTranslationDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition' => 'getNumberRangeTypeTranslationDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition' => 'getNumberRangeTypeDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Api\\NumberRangeController' => 'getNumberRangeControllerService',
            'Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition' => 'getNumberRangeDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface' => 'getNumberRangeValueGeneratorInterfaceService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition' => 'getSalesChannelAnalyticsDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition' => 'getSalesChannelCountryDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition' => 'getSalesChannelCurrencyDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition' => 'getSalesChannelDomainDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition' => 'getSalesChannelLanguageDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition' => 'getSalesChannelPaymentMethodDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition' => 'getSalesChannelShippingMethodDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition' => 'getSalesChannelTranslationDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition' => 'getSalesChannelTypeTranslationDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition' => 'getSalesChannelTypeDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory' => 'getSalesChannelContextFactoryService',
            'Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry' => 'getSalesChannelDefinitionInstanceRegistryService',
            'Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition' => 'getSalesChannelDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextRoute' => 'getContextRouteService',
            'Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextSwitchRoute' => 'getContextSwitchRouteService',
            'Shopware\\Core\\System\\SalesChannel\\SalesChannel\\StoreApiInfoController' => 'getStoreApiInfoControllerService',
            'Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition' => 'getSalutationTranslationDefinitionService',
            'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition' => 'getSalesChannelSalutationDefinitionService',
            'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalutationRoute' => 'getSalutationRouteService',
            'Shopware\\Core\\System\\Salutation\\SalutationDefinition' => 'getSalutationDefinitionService',
            'Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition' => 'getSnippetSetDefinitionService',
            'Shopware\\Core\\System\\Snippet\\Api\\SnippetController' => 'getSnippetControllerService',
            'Shopware\\Core\\System\\Snippet\\Files\\SnippetFileCollection' => 'getSnippetFileCollectionService',
            'Shopware\\Core\\System\\Snippet\\Filter\\SnippetFilterFactory' => 'getSnippetFilterFactoryService',
            'Shopware\\Core\\System\\Snippet\\SnippetDefinition' => 'getSnippetDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition' => 'getStateMachineHistoryDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition' => 'getStateMachineStateDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition' => 'getStateMachineStateTranslationDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition' => 'getStateMachineTransitionDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Api\\StateMachineActionController' => 'getStateMachineActionControllerService',
            'Shopware\\Core\\System\\StateMachine\\StateMachineDefinition' => 'getStateMachineDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition' => 'getStateMachineTranslationDefinitionService',
            'Shopware\\Core\\System\\SystemConfig\\Api\\SystemConfigController' => 'getSystemConfigControllerService',
            'Shopware\\Core\\System\\SystemConfig\\Facade\\SystemConfigFacadeHookFactory' => 'getSystemConfigFacadeHookFactoryService',
            'Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition' => 'getSystemConfigDefinitionService',
            'Shopware\\Core\\System\\SystemConfig\\SystemConfigService' => 'getSystemConfigServiceService',
            'Shopware\\Core\\System\\Tag\\Service\\FilterTagIdsService' => 'getFilterTagIdsServiceService',
            'Shopware\\Core\\System\\Tag\\TagDefinition' => 'getTagDefinitionService',
            'Shopware\\Core\\System\\TaxProvider\\Aggregate\\TaxProviderTranslation\\TaxProviderTranslationDefinition' => 'getTaxProviderTranslationDefinitionService',
            'Shopware\\Core\\System\\TaxProvider\\TaxProviderDefinition' => 'getTaxProviderDefinitionService',
            'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition' => 'getTaxRuleTypeTranslationDefinitionService',
            'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition' => 'getTaxRuleTypeDefinitionService',
            'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition' => 'getTaxRuleDefinitionService',
            'Shopware\\Core\\System\\Tax\\TaxDefinition' => 'getTaxDefinitionService',
            'Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition' => 'getUnitTranslationDefinitionService',
            'Shopware\\Core\\System\\Unit\\UnitDefinition' => 'getUnitDefinitionService',
            'Shopware\\Core\\System\\UsageData\\Api\\ConsentController' => 'getConsentControllerService',
            'Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition' => 'getUserAccessKeyDefinitionService',
            'Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition' => 'getUserConfigDefinitionService',
            'Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition' => 'getUserRecoveryDefinitionService',
            'Shopware\\Core\\System\\User\\Api\\UserRecoveryController' => 'getUserRecoveryControllerService',
            'Shopware\\Core\\System\\User\\Api\\UserValidationController' => 'getUserValidationControllerService',
            'Shopware\\Core\\System\\User\\UserDefinition' => 'getUserDefinitionService',
            'Shopware\\Elasticsearch\\Admin\\AdminElasticsearchHelper' => 'getAdminElasticsearchHelperService',
            'Shopware\\Elasticsearch\\Admin\\AdminSearchController' => 'getAdminSearchController2Service',
            'Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper' => 'getElasticsearchHelperService',
            'Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler' => 'getCreateAliasTaskHandlerService',
            'Shopware\\Storefront\\Controller\\AccountOrderController' => 'getAccountOrderControllerService',
            'Shopware\\Storefront\\Controller\\AccountProfileController' => 'getAccountProfileControllerService',
            'Shopware\\Storefront\\Controller\\AddressController' => 'getAddressControllerService',
            'Shopware\\Storefront\\Controller\\Api\\CaptchaController' => 'getCaptchaControllerService',
            'Shopware\\Storefront\\Controller\\AppController' => 'getAppControllerService',
            'Shopware\\Storefront\\Controller\\AuthController' => 'getAuthController2Service',
            'Shopware\\Storefront\\Controller\\CaptchaController' => 'getCaptchaController2Service',
            'Shopware\\Storefront\\Controller\\CartLineItemController' => 'getCartLineItemControllerService',
            'Shopware\\Storefront\\Controller\\CheckoutController' => 'getCheckoutControllerService',
            'Shopware\\Storefront\\Controller\\CmsController' => 'getCmsControllerService',
            'Shopware\\Storefront\\Controller\\ContextController' => 'getContextControllerService',
            'Shopware\\Storefront\\Controller\\CookieController' => 'getCookieControllerService',
            'Shopware\\Storefront\\Controller\\CountryStateController' => 'getCountryStateControllerService',
            'Shopware\\Storefront\\Controller\\DocumentController' => 'getDocumentController2Service',
            'Shopware\\Storefront\\Controller\\DownloadController' => 'getDownloadControllerService',
            'Shopware\\Storefront\\Controller\\ErrorController' => 'getErrorControllerService',
            'Shopware\\Storefront\\Controller\\FormController' => 'getFormControllerService',
            'Shopware\\Storefront\\Controller\\LandingPageController' => 'getLandingPageControllerService',
            'Shopware\\Storefront\\Controller\\MaintenanceController' => 'getMaintenanceControllerService',
            'Shopware\\Storefront\\Controller\\NavigationController' => 'getNavigationControllerService',
            'Shopware\\Storefront\\Controller\\NewsletterController' => 'getNewsletterControllerService',
            'Shopware\\Storefront\\Controller\\ProductController' => 'getProductControllerService',
            'Shopware\\Storefront\\Controller\\RegisterController' => 'getRegisterControllerService',
            'Shopware\\Storefront\\Controller\\ScriptController' => 'getScriptControllerService',
            'Shopware\\Storefront\\Controller\\SearchController' => 'getSearchControllerService',
            'Shopware\\Storefront\\Controller\\SitemapController' => 'getSitemapControllerService',
            'Shopware\\Storefront\\Controller\\VerificationHashController' => 'getVerificationHashControllerService',
            'Shopware\\Storefront\\Controller\\WellKnownController' => 'getWellKnownControllerService',
            'Shopware\\Storefront\\Controller\\WishlistController' => 'getWishlistControllerService',
            'Shopware\\Storefront\\Framework\\Media\\StorefrontMediaValidatorRegistry' => 'getStorefrontMediaValidatorRegistryService',
            'Shopware\\Storefront\\Page\\Checkout\\Register\\CheckoutRegisterPageLoader' => 'getCheckoutRegisterPageLoaderService',
            'Shopware\\Storefront\\Page\\Search\\SearchPageLoader' => 'getSearchPageLoaderService',
            'Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition' => 'getThemeChildDefinitionService',
            'Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition' => 'getThemeMediaDefinitionService',
            'Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition' => 'getThemeSalesChannelDefinitionService',
            'Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition' => 'getThemeTranslationDefinitionService',
            'Shopware\\Storefront\\Theme\\Controller\\ThemeController' => 'getThemeControllerService',
            'Shopware\\Storefront\\Theme\\DatabaseSalesChannelThemeLoader' => 'getDatabaseSalesChannelThemeLoaderService',
            'Shopware\\Storefront\\Theme\\StorefrontPluginRegistry' => 'getStorefrontPluginRegistryService',
            'Shopware\\Storefront\\Theme\\ThemeDefinition' => 'getThemeDefinitionService',
            'Shopware\\Storefront\\Theme\\ThemeFilesystemResolver' => 'getThemeFilesystemResolverService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            '_dummy_es_env_usage' => 'getDummyEsEnvUsageService',
            'acl_role.repository' => 'getAclRole_RepositoryService',
            'acl_user_role.repository' => 'getAclUserRole_RepositoryService',
            'admin.openSearch.client' => 'getAdmin_OpenSearch_ClientService',
            'administration.filesystem.private' => 'getAdministration_Filesystem_PrivateService',
            'administration.filesystem.public' => 'getAdministration_Filesystem_PublicService',
            'app.repository' => 'getApp_RepositoryService',
            'app_action_button.repository' => 'getAppActionButton_RepositoryService',
            'app_action_button_translation.repository' => 'getAppActionButtonTranslation_RepositoryService',
            'app_administration_snippet.repository' => 'getAppAdministrationSnippet_RepositoryService',
            'app_cms_block.repository' => 'getAppCmsBlock_RepositoryService',
            'app_cms_block_translation.repository' => 'getAppCmsBlockTranslation_RepositoryService',
            'app_flow_action.repository' => 'getAppFlowAction_RepositoryService',
            'app_flow_action_translation.repository' => 'getAppFlowActionTranslation_RepositoryService',
            'app_flow_event.repository' => 'getAppFlowEvent_RepositoryService',
            'app_payment_method.repository' => 'getAppPaymentMethod_RepositoryService',
            'app_script_condition.repository' => 'getAppScriptCondition_RepositoryService',
            'app_script_condition_translation.repository' => 'getAppScriptConditionTranslation_RepositoryService',
            'app_shipping_method.repository' => 'getAppShippingMethod_RepositoryService',
            'app_template.repository' => 'getAppTemplate_RepositoryService',
            'app_translation.repository' => 'getAppTranslation_RepositoryService',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.pentatrion_vite_fallback' => 'getCache_PentatrionViteFallbackService',
            'cache.system' => 'getCache_SystemService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache.validator_expression_language' => 'getCache_ValidatorExpressionLanguageService',
            'cache_warmer' => 'getCacheWarmerService',
            'category.repository' => 'getCategory_RepositoryService',
            'category_tag.repository' => 'getCategoryTag_RepositoryService',
            'category_translation.repository' => 'getCategoryTranslation_RepositoryService',
            'checkout.filesystem.private' => 'getCheckout_Filesystem_PrivateService',
            'checkout.filesystem.public' => 'getCheckout_Filesystem_PublicService',
            'cms_block.repository' => 'getCmsBlock_RepositoryService',
            'cms_page.repository' => 'getCmsPage_RepositoryService',
            'cms_page_translation.repository' => 'getCmsPageTranslation_RepositoryService',
            'cms_section.repository' => 'getCmsSection_RepositoryService',
            'cms_slot.repository' => 'getCmsSlot_RepositoryService',
            'cms_slot_translation.repository' => 'getCmsSlotTranslation_RepositoryService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'container.get_routing_condition_service' => 'getContainer_GetRoutingConditionServiceService',
            'content.filesystem.private' => 'getContent_Filesystem_PrivateService',
            'content.filesystem.public' => 'getContent_Filesystem_PublicService',
            'country.repository' => 'getCountry_RepositoryService',
            'country_state.repository' => 'getCountryState_RepositoryService',
            'country_state_translation.repository' => 'getCountryStateTranslation_RepositoryService',
            'country_translation.repository' => 'getCountryTranslation_RepositoryService',
            'currency.repository' => 'getCurrency_RepositoryService',
            'currency_country_rounding.repository' => 'getCurrencyCountryRounding_RepositoryService',
            'currency_translation.repository' => 'getCurrencyTranslation_RepositoryService',
            'custom_entity.repository' => 'getCustomEntity_RepositoryService',
            'custom_field.repository' => 'getCustomField_RepositoryService',
            'custom_field_set.repository' => 'getCustomFieldSet_RepositoryService',
            'custom_field_set_relation.repository' => 'getCustomFieldSetRelation_RepositoryService',
            'customer.repository' => 'getCustomer_RepositoryService',
            'customer_address.repository' => 'getCustomerAddress_RepositoryService',
            'customer_group.repository' => 'getCustomerGroup_RepositoryService',
            'customer_group_registration_sales_channels.repository' => 'getCustomerGroupRegistrationSalesChannels_RepositoryService',
            'customer_group_translation.repository' => 'getCustomerGroupTranslation_RepositoryService',
            'customer_recovery.repository' => 'getCustomerRecovery_RepositoryService',
            'customer_tag.repository' => 'getCustomerTag_RepositoryService',
            'customer_wishlist.repository' => 'getCustomerWishlist_RepositoryService',
            'customer_wishlist_product.repository' => 'getCustomerWishlistProduct_RepositoryService',
            'debug.error_handler_configurator' => 'getDebug_ErrorHandlerConfiguratorService',
            'delivery_time.repository' => 'getDeliveryTime_RepositoryService',
            'delivery_time_translation.repository' => 'getDeliveryTimeTranslation_RepositoryService',
            'document.repository' => 'getDocument_RepositoryService',
            'document_base_config.repository' => 'getDocumentBaseConfig_RepositoryService',
            'document_base_config_sales_channel.repository' => 'getDocumentBaseConfigSalesChannel_RepositoryService',
            'document_type.repository' => 'getDocumentType_RepositoryService',
            'document_type_translation.repository' => 'getDocumentTypeTranslation_RepositoryService',
            'elasticsearch.filesystem.private' => 'getElasticsearch_Filesystem_PrivateService',
            'elasticsearch.filesystem.public' => 'getElasticsearch_Filesystem_PublicService',
            'error_controller' => 'getErrorController2Service',
            'event_dispatcher' => 'getEventDispatcherService',
            'flow.repository' => 'getFlow_RepositoryService',
            'flow_sequence.repository' => 'getFlowSequence_RepositoryService',
            'flow_template.repository' => 'getFlowTemplate_RepositoryService',
            'framework.filesystem.private' => 'getFramework_Filesystem_PrivateService',
            'framework.filesystem.public' => 'getFramework_Filesystem_PublicService',
            'http_cache' => 'getHttpCacheService',
            'http_kernel' => 'getHttpKernelService',
            'import_export_file.repository' => 'getImportExportFile_RepositoryService',
            'import_export_log.repository' => 'getImportExportLog_RepositoryService',
            'import_export_profile.repository' => 'getImportExportProfile_RepositoryService',
            'import_export_profile_translation.repository' => 'getImportExportProfileTranslation_RepositoryService',
            'integration.repository' => 'getIntegration_RepositoryService',
            'integration_role.repository' => 'getIntegrationRole_RepositoryService',
            'landing_page.repository' => 'getLandingPage_RepositoryService',
            'landing_page_sales_channel.repository' => 'getLandingPageSalesChannel_RepositoryService',
            'landing_page_tag.repository' => 'getLandingPageTag_RepositoryService',
            'landing_page_translation.repository' => 'getLandingPageTranslation_RepositoryService',
            'language.repository' => 'getLanguage_RepositoryService',
            'locale.repository' => 'getLocale_RepositoryService',
            'locale_translation.repository' => 'getLocaleTranslation_RepositoryService',
            'log_entry.repository' => 'getLogEntry_RepositoryService',
            'mail_header_footer.repository' => 'getMailHeaderFooter_RepositoryService',
            'mail_header_footer_translation.repository' => 'getMailHeaderFooterTranslation_RepositoryService',
            'mail_template.repository' => 'getMailTemplate_RepositoryService',
            'mail_template_media.repository' => 'getMailTemplateMedia_RepositoryService',
            'mail_template_translation.repository' => 'getMailTemplateTranslation_RepositoryService',
            'mail_template_type.repository' => 'getMailTemplateType_RepositoryService',
            'mail_template_type_translation.repository' => 'getMailTemplateTypeTranslation_RepositoryService',
            'main_category.repository' => 'getMainCategory_RepositoryService',
            'maintenance.filesystem.private' => 'getMaintenance_Filesystem_PrivateService',
            'maintenance.filesystem.public' => 'getMaintenance_Filesystem_PublicService',
            'media.repository' => 'getMedia_RepositoryService',
            'media_default_folder.repository' => 'getMediaDefaultFolder_RepositoryService',
            'media_folder.repository' => 'getMediaFolder_RepositoryService',
            'media_folder_configuration.repository' => 'getMediaFolderConfiguration_RepositoryService',
            'media_folder_configuration_media_thumbnail_size.repository' => 'getMediaFolderConfigurationMediaThumbnailSize_RepositoryService',
            'media_tag.repository' => 'getMediaTag_RepositoryService',
            'media_thumbnail.repository' => 'getMediaThumbnail_RepositoryService',
            'media_thumbnail_size.repository' => 'getMediaThumbnailSize_RepositoryService',
            'media_translation.repository' => 'getMediaTranslation_RepositoryService',
            'messenger.default_bus' => 'getMessenger_DefaultBusService',
            'monolog.logger.business_events' => 'getMonolog_Logger_BusinessEventsService',
            'monolog.logger.elasticsearch' => 'getMonolog_Logger_ElasticsearchService',
            'newsletter_recipient.repository' => 'getNewsletterRecipient_RepositoryService',
            'newsletter_recipient_tag.repository' => 'getNewsletterRecipientTag_RepositoryService',
            'notification.repository' => 'getNotification_RepositoryService',
            'number_range.repository' => 'getNumberRange_RepositoryService',
            'number_range_sales_channel.repository' => 'getNumberRangeSalesChannel_RepositoryService',
            'number_range_state.repository' => 'getNumberRangeState_RepositoryService',
            'number_range_translation.repository' => 'getNumberRangeTranslation_RepositoryService',
            'number_range_type.repository' => 'getNumberRangeType_RepositoryService',
            'number_range_type_translation.repository' => 'getNumberRangeTypeTranslation_RepositoryService',
            'order.repository' => 'getOrder_RepositoryService',
            'order_address.repository' => 'getOrderAddress_RepositoryService',
            'order_customer.repository' => 'getOrderCustomer_RepositoryService',
            'order_delivery.repository' => 'getOrderDelivery_RepositoryService',
            'order_delivery_position.repository' => 'getOrderDeliveryPosition_RepositoryService',
            'order_line_item.repository' => 'getOrderLineItem_RepositoryService',
            'order_line_item_download.repository' => 'getOrderLineItemDownload_RepositoryService',
            'order_tag.repository' => 'getOrderTag_RepositoryService',
            'order_transaction.repository' => 'getOrderTransaction_RepositoryService',
            'order_transaction_capture.repository' => 'getOrderTransactionCapture_RepositoryService',
            'order_transaction_capture_refund.repository' => 'getOrderTransactionCaptureRefund_RepositoryService',
            'order_transaction_capture_refund_position.repository' => 'getOrderTransactionCaptureRefundPosition_RepositoryService',
            'payment_method.repository' => 'getPaymentMethod_RepositoryService',
            'payment_method_translation.repository' => 'getPaymentMethodTranslation_RepositoryService',
            'plugin.repository' => 'getPlugin_RepositoryService',
            'plugin_translation.repository' => 'getPluginTranslation_RepositoryService',
            'product.repository' => 'getProduct_RepositoryService',
            'product_category.repository' => 'getProductCategory_RepositoryService',
            'product_category_tree.repository' => 'getProductCategoryTree_RepositoryService',
            'product_configurator_setting.repository' => 'getProductConfiguratorSetting_RepositoryService',
            'product_cross_selling.repository' => 'getProductCrossSelling_RepositoryService',
            'product_cross_selling_assigned_products.repository' => 'getProductCrossSellingAssignedProducts_RepositoryService',
            'product_cross_selling_translation.repository' => 'getProductCrossSellingTranslation_RepositoryService',
            'product_custom_field_set.repository' => 'getProductCustomFieldSet_RepositoryService',
            'product_download.repository' => 'getProductDownload_RepositoryService',
            'product_export.repository' => 'getProductExport_RepositoryService',
            'product_feature_set.repository' => 'getProductFeatureSet_RepositoryService',
            'product_feature_set_translation.repository' => 'getProductFeatureSetTranslation_RepositoryService',
            'product_keyword_dictionary.repository' => 'getProductKeywordDictionary_RepositoryService',
            'product_manufacturer.repository' => 'getProductManufacturer_RepositoryService',
            'product_manufacturer_translation.repository' => 'getProductManufacturerTranslation_RepositoryService',
            'product_media.repository' => 'getProductMedia_RepositoryService',
            'product_option.repository' => 'getProductOption_RepositoryService',
            'product_price.repository' => 'getProductPrice_RepositoryService',
            'product_property.repository' => 'getProductProperty_RepositoryService',
            'product_review.repository' => 'getProductReview_RepositoryService',
            'product_search_config.repository' => 'getProductSearchConfig_RepositoryService',
            'product_search_config_field.repository' => 'getProductSearchConfigField_RepositoryService',
            'product_search_keyword.repository' => 'getProductSearchKeyword_RepositoryService',
            'product_sorting.repository' => 'getProductSorting_RepositoryService',
            'product_sorting_translation.repository' => 'getProductSortingTranslation_RepositoryService',
            'product_stream.repository' => 'getProductStream_RepositoryService',
            'product_stream_filter.repository' => 'getProductStreamFilter_RepositoryService',
            'product_stream_mapping.repository' => 'getProductStreamMapping_RepositoryService',
            'product_stream_translation.repository' => 'getProductStreamTranslation_RepositoryService',
            'product_tag.repository' => 'getProductTag_RepositoryService',
            'product_translation.repository' => 'getProductTranslation_RepositoryService',
            'product_visibility.repository' => 'getProductVisibility_RepositoryService',
            'profiling.filesystem.private' => 'getProfiling_Filesystem_PrivateService',
            'profiling.filesystem.public' => 'getProfiling_Filesystem_PublicService',
            'promotion.repository' => 'getPromotion_RepositoryService',
            'promotion_cart_rule.repository' => 'getPromotionCartRule_RepositoryService',
            'promotion_discount.repository' => 'getPromotionDiscount_RepositoryService',
            'promotion_discount_prices.repository' => 'getPromotionDiscountPrices_RepositoryService',
            'promotion_discount_rule.repository' => 'getPromotionDiscountRule_RepositoryService',
            'promotion_individual_code.repository' => 'getPromotionIndividualCode_RepositoryService',
            'promotion_order_rule.repository' => 'getPromotionOrderRule_RepositoryService',
            'promotion_persona_customer.repository' => 'getPromotionPersonaCustomer_RepositoryService',
            'promotion_persona_rule.repository' => 'getPromotionPersonaRule_RepositoryService',
            'promotion_sales_channel.repository' => 'getPromotionSalesChannel_RepositoryService',
            'promotion_setgroup.repository' => 'getPromotionSetgroup_RepositoryService',
            'promotion_setgroup_rule.repository' => 'getPromotionSetgroupRule_RepositoryService',
            'promotion_translation.repository' => 'getPromotionTranslation_RepositoryService',
            'property_group.repository' => 'getPropertyGroup_RepositoryService',
            'property_group_option.repository' => 'getPropertyGroupOption_RepositoryService',
            'property_group_option_translation.repository' => 'getPropertyGroupOptionTranslation_RepositoryService',
            'property_group_translation.repository' => 'getPropertyGroupTranslation_RepositoryService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
            'routing.loader' => 'getRouting_LoaderService',
            'rule.repository' => 'getRule_RepositoryService',
            'rule_condition.repository' => 'getRuleCondition_RepositoryService',
            'rule_tag.repository' => 'getRuleTag_RepositoryService',
            'sales_channel.category.repository' => 'getSalesChannel_Category_RepositoryService',
            'sales_channel.country.repository' => 'getSalesChannel_Country_RepositoryService',
            'sales_channel.country_state.repository' => 'getSalesChannel_CountryState_RepositoryService',
            'sales_channel.currency.repository' => 'getSalesChannel_Currency_RepositoryService',
            'sales_channel.landing_page.repository' => 'getSalesChannel_LandingPage_RepositoryService',
            'sales_channel.language.repository' => 'getSalesChannel_Language_RepositoryService',
            'sales_channel.main_category.repository' => 'getSalesChannel_MainCategory_RepositoryService',
            'sales_channel.newsletter_recipient.repository' => 'getSalesChannel_NewsletterRecipient_RepositoryService',
            'sales_channel.payment_method.repository' => 'getSalesChannel_PaymentMethod_RepositoryService',
            'sales_channel.product.repository' => 'getSalesChannel_Product_RepositoryService',
            'sales_channel.repository' => 'getSalesChannel_RepositoryService',
            'sales_channel.salutation.repository' => 'getSalesChannel_Salutation_RepositoryService',
            'sales_channel.seo_url.repository' => 'getSalesChannel_SeoUrl_RepositoryService',
            'sales_channel.shipping_method.repository' => 'getSalesChannel_ShippingMethod_RepositoryService',
            'sales_channel_analytics.repository' => 'getSalesChannelAnalytics_RepositoryService',
            'sales_channel_country.repository' => 'getSalesChannelCountry_RepositoryService',
            'sales_channel_currency.repository' => 'getSalesChannelCurrency_RepositoryService',
            'sales_channel_definition.Shopware\\Administration\\Notification\\NotificationDefinition' => 'getNotificationDefinition2Service',
            'sales_channel_definition.Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition' => 'getAppAdministrationSnippetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition' => 'getCustomerAddressDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition' => 'getCustomerGroupRegistrationSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition' => 'getCustomerGroupTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition' => 'getCustomerGroupDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition' => 'getCustomerRecoveryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition' => 'getCustomerTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition' => 'getCustomerWishlistProductDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition' => 'getCustomerWishlistDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\CustomerDefinition' => 'getCustomerDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition' => 'getDocumentBaseConfigSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition' => 'getDocumentBaseConfigDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition' => 'getDocumentTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition' => 'getDocumentTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\DocumentDefinition' => 'getDocumentDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition' => 'getOrderAddressDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition' => 'getOrderCustomerDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition' => 'getOrderDeliveryPositionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition' => 'getOrderDeliveryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItemDownload\\OrderLineItemDownloadDefinition' => 'getOrderLineItemDownloadDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition' => 'getOrderLineItemDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition' => 'getOrderTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition' => 'getOrderTransactionCaptureRefundPositionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition' => 'getOrderTransactionCaptureRefundDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition' => 'getOrderTransactionCaptureDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition' => 'getOrderTransactionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\OrderDefinition' => 'getOrderDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition' => 'getPaymentMethodTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition' => 'getPromotionCartRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition' => 'getPromotionDiscountPriceDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition' => 'getPromotionDiscountRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition' => 'getPromotionDiscountDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition' => 'getPromotionIndividualCodeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition' => 'getPromotionOrderRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition' => 'getPromotionPersonaCustomerDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition' => 'getPromotionPersonaRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition' => 'getPromotionSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition' => 'getPromotionSetGroupRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition' => 'getPromotionSetGroupDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition' => 'getPromotionTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition' => 'getPromotionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition' => 'getShippingMethodPriceDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition' => 'getShippingMethodTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition' => 'getShippingMethodTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition' => 'getCategoryTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition' => 'getCategoryTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition' => 'getCmsBlockDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition' => 'getCmsPageTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition' => 'getCmsSectionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition' => 'getCmsSlotTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition' => 'getCmsSlotDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\CmsPageDefinition' => 'getCmsPageDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition' => 'getFlowSequenceDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Flow\\Aggregate\\FlowTemplate\\FlowTemplateDefinition' => 'getFlowTemplateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Flow\\FlowDefinition' => 'getFlowDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition' => 'getImportExportFileDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition' => 'getImportExportLogDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition' => 'getImportExportProfileDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition' => 'getImportExportProfileTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition' => 'getLandingPageSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition' => 'getLandingPageTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition' => 'getLandingPageTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition' => 'getMailHeaderFooterTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition' => 'getMailHeaderFooterDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition' => 'getMailTemplateMediaDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition' => 'getMailTemplateTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition' => 'getMailTemplateTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition' => 'getMailTemplateTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition' => 'getMailTemplateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition' => 'getMediaDefaultFolderDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition' => 'getMediaFolderConfigurationMediaThumbnailSizeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition' => 'getMediaFolderConfigurationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition' => 'getMediaFolderDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition' => 'getMediaTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition' => 'getMediaThumbnailSizeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition' => 'getMediaThumbnailDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition' => 'getMediaTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\MediaDefinition' => 'getMediaDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition' => 'getNewsletterRecipientTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition' => 'getProductExportDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition' => 'getProductStreamFilterDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition' => 'getProductStreamTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition' => 'getProductStreamDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition' => 'getProductCategoryTreeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition' => 'getProductCategoryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition' => 'getProductConfiguratorSettingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition' => 'getProductCrossSellingAssignedProductsDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition' => 'getProductCrossSellingTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition' => 'getProductCrossSellingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition' => 'getProductCustomFieldSetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductDownload\\ProductDownloadDefinition' => 'getProductDownloadDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition' => 'getProductFeatureSetTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition' => 'getProductFeatureSetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition' => 'getProductKeywordDictionaryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition' => 'getProductManufacturerTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition' => 'getProductManufacturerDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition' => 'getProductMediaDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition' => 'getProductOptionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition' => 'getProductPriceDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition' => 'getProductPropertyDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition' => 'getProductReviewDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition' => 'getProductSearchConfigFieldDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition' => 'getProductSearchConfigDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition' => 'getProductSearchKeywordDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition' => 'getProductStreamMappingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition' => 'getProductTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition' => 'getProductTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition' => 'getProductVisibilityDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition' => 'getProductSortingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition' => 'getProductSortingTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition' => 'getPropertyGroupOptionTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition' => 'getPropertyGroupOptionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition' => 'getPropertyGroupTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Property\\PropertyGroupDefinition' => 'getPropertyGroupDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition' => 'getRuleConditionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition' => 'getRuleTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Rule\\RuleDefinition' => 'getRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition' => 'getSeoUrlTemplateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition' => 'getAclRoleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition' => 'getAclUserRoleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition' => 'getActionButtonTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition' => 'getActionButtonDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition' => 'getAppPaymentMethodDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition' => 'getAppScriptConditionTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition' => 'getAppScriptConditionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\AppShippingMethod\\AppShippingMethodDefinition' => 'getAppShippingMethodDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition' => 'getAppTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition' => 'getAppCmsBlockTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition' => 'getAppCmsBlockDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition' => 'getAppFlowActionTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition' => 'getAppFlowActionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\FlowEvent\\AppFlowEventDefinition' => 'getAppFlowEventDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\AppDefinition' => 'getAppDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition' => 'getTemplateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition' => 'getVersionCommitDataDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition' => 'getVersionCommitDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition' => 'getVersionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Log\\LogEntryDefinition' => 'getLogEntryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition' => 'getScheduledTaskDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition' => 'getPluginTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Plugin\\PluginDefinition' => 'getPluginDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Script\\ScriptDefinition' => 'getScriptDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition' => 'getWebhookEventLogDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Webhook\\WebhookDefinition' => 'getWebhookDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition' => 'getCountryStateTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition' => 'getCountryTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition' => 'getCurrencyCountryRoundingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition' => 'getCurrencyTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition' => 'getCustomEntityDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition' => 'getCustomFieldSetRelationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition' => 'getCustomFieldSetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\CustomField\\CustomFieldDefinition' => 'getCustomFieldDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition' => 'getDeliveryTimeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition' => 'getDeliveryTimeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition' => 'getIntegrationRoleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Integration\\IntegrationDefinition' => 'getIntegrationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition' => 'getLocaleTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Locale\\LocaleDefinition' => 'getLocaleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition' => 'getNumberRangeSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition' => 'getNumberRangeStateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition' => 'getNumberRangeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition' => 'getNumberRangeTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition' => 'getNumberRangeTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition' => 'getNumberRangeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition' => 'getSalesChannelAnalyticsDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition' => 'getSalesChannelCountryDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition' => 'getSalesChannelCurrencyDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition' => 'getSalesChannelDomainDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition' => 'getSalesChannelLanguageDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition' => 'getSalesChannelPaymentMethodDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition' => 'getSalesChannelShippingMethodDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition' => 'getSalesChannelTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition' => 'getSalesChannelTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition' => 'getSalesChannelTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition' => 'getSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition' => 'getSalutationTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition' => 'getSnippetSetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Snippet\\SnippetDefinition' => 'getSnippetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition' => 'getStateMachineHistoryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition' => 'getStateMachineStateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition' => 'getStateMachineStateTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition' => 'getStateMachineTransitionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\StateMachineDefinition' => 'getStateMachineDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition' => 'getStateMachineTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition' => 'getSystemConfigDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tag\\TagDefinition' => 'getTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\TaxProvider\\Aggregate\\TaxProviderTranslation\\TaxProviderTranslationDefinition' => 'getTaxProviderTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\TaxProvider\\TaxProviderDefinition' => 'getTaxProviderDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition' => 'getTaxRuleTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition' => 'getTaxRuleTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition' => 'getTaxRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tax\\TaxDefinition' => 'getTaxDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition' => 'getUnitTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Unit\\UnitDefinition' => 'getUnitDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition' => 'getUserAccessKeyDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition' => 'getUserConfigDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition' => 'getUserRecoveryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\User\\UserDefinition' => 'getUserDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition' => 'getThemeChildDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition' => 'getThemeMediaDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition' => 'getThemeSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition' => 'getThemeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\ThemeDefinition' => 'getThemeDefinition2Service',
            'sales_channel_domain.repository' => 'getSalesChannelDomain_RepositoryService',
            'sales_channel_language.repository' => 'getSalesChannelLanguage_RepositoryService',
            'sales_channel_payment_method.repository' => 'getSalesChannelPaymentMethod_RepositoryService',
            'sales_channel_shipping_method.repository' => 'getSalesChannelShippingMethod_RepositoryService',
            'sales_channel_translation.repository' => 'getSalesChannelTranslation_RepositoryService',
            'sales_channel_type.repository' => 'getSalesChannelType_RepositoryService',
            'sales_channel_type_translation.repository' => 'getSalesChannelTypeTranslation_RepositoryService',
            'salutation.repository' => 'getSalutation_RepositoryService',
            'salutation_translation.repository' => 'getSalutationTranslation_RepositoryService',
            'scheduled_task.repository' => 'getScheduledTask_RepositoryService',
            'script.repository' => 'getScript_RepositoryService',
            'seo_url.repository' => 'getSeoUrl_RepositoryService',
            'seo_url_template.repository' => 'getSeoUrlTemplate_RepositoryService',
            'service.filesystem.private' => 'getService_Filesystem_PrivateService',
            'service.filesystem.public' => 'getService_Filesystem_PublicService',
            'services_resetter' => 'getServicesResetterService',
            'shipping_method.repository' => 'getShippingMethod_RepositoryService',
            'shipping_method_price.repository' => 'getShippingMethodPrice_RepositoryService',
            'shipping_method_tag.repository' => 'getShippingMethodTag_RepositoryService',
            'shipping_method_translation.repository' => 'getShippingMethodTranslation_RepositoryService',
            'shopware.filesystem.asset' => 'getShopware_Filesystem_AssetService',
            'shopware.filesystem.private' => 'getShopware_Filesystem_PrivateService',
            'shopware.filesystem.public' => 'getShopware_Filesystem_PublicService',
            'shopware.filesystem.sitemap' => 'getShopware_Filesystem_SitemapService',
            'shopware.filesystem.temp' => 'getShopware_Filesystem_TempService',
            'shopware.filesystem.theme' => 'getShopware_Filesystem_ThemeService',
            'shopware.frw_client' => 'getShopware_FrwClientService',
            'shopware.increment.gateway.registry' => 'getShopware_Increment_Gateway_RegistryService',
            'shopware.store_client' => 'getShopware_StoreClientService',
            'snippet.repository' => 'getSnippet_RepositoryService',
            'snippet_set.repository' => 'getSnippetSet_RepositoryService',
            'state_machine.repository' => 'getStateMachine_RepositoryService',
            'state_machine_history.repository' => 'getStateMachineHistory_RepositoryService',
            'state_machine_state.repository' => 'getStateMachineState_RepositoryService',
            'state_machine_state_translation.repository' => 'getStateMachineStateTranslation_RepositoryService',
            'state_machine_transition.repository' => 'getStateMachineTransition_RepositoryService',
            'state_machine_translation.repository' => 'getStateMachineTranslation_RepositoryService',
            'storefront.filesystem.private' => 'getStorefront_Filesystem_PrivateService',
            'storefront.filesystem.public' => 'getStorefront_Filesystem_PublicService',
            'system.filesystem.private' => 'getSystem_Filesystem_PrivateService',
            'system.filesystem.public' => 'getSystem_Filesystem_PublicService',
            'system_config.repository' => 'getSystemConfig_RepositoryService',
            'tag.repository' => 'getTag_RepositoryService',
            'tax.repository' => 'getTax_RepositoryService',
            'tax_provider.repository' => 'getTaxProvider_RepositoryService',
            'tax_provider_translation.repository' => 'getTaxProviderTranslation_RepositoryService',
            'tax_rule.repository' => 'getTaxRule_RepositoryService',
            'tax_rule_type.repository' => 'getTaxRuleType_RepositoryService',
            'tax_rule_type_translation.repository' => 'getTaxRuleTypeTranslation_RepositoryService',
            'theme.repository' => 'getTheme_RepositoryService',
            'theme_child.repository' => 'getThemeChild_RepositoryService',
            'theme_media.repository' => 'getThemeMedia_RepositoryService',
            'theme_sales_channel.repository' => 'getThemeSalesChannel_RepositoryService',
            'theme_translation.repository' => 'getThemeTranslation_RepositoryService',
            'translator' => 'getTranslatorService',
            'twig' => 'getTwigService',
            'unit.repository' => 'getUnit_RepositoryService',
            'unit_translation.repository' => 'getUnitTranslation_RepositoryService',
            'user.repository' => 'getUser_RepositoryService',
            'user_access_key.repository' => 'getUserAccessKey_RepositoryService',
            'user_config.repository' => 'getUserConfig_RepositoryService',
            'user_recovery.repository' => 'getUserRecovery_RepositoryService',
            'version.repository' => 'getVersion_RepositoryService',
            'version_commit.repository' => 'getVersionCommit_RepositoryService',
            'version_commit_data.repository' => 'getVersionCommitData_RepositoryService',
            'webhook.repository' => 'getWebhook_RepositoryService',
            'webhook_event_log.repository' => 'getWebhookEventLog_RepositoryService',
        ];
        $this->aliases = [
            'Shopware\\Core\\Content\\Category\\SalesChannel\\NavigationRoute' => 'Shopware\\Core\\Content\\Category\\SalesChannel\\TreeBuildingNavigationRoute',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowLoader' => 'Shopware\\Core\\Content\\Flow\\Dispatching\\CachedFlowLoader',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingRoute' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ProductSearchRoute' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\ProductSuggestRoute' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\ResolvedCriteriaProductSuggestRoute',
            'Shopware\\Core\\Content\\Seo\\SeoResolver' => 'Shopware\\Core\\Content\\Seo\\EmptyPathInfoResolver',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Payment\\PaymentMethodDefinition' => 'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition' => 'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition' => 'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\ShippingMethodDefinition' => 'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Category\\CategoryDefinition' => 'Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition' => 'Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\LandingPageDefinition' => 'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition' => 'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipient\\NewsletterRecipientDefinition' => 'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition' => 'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\ProductDefinition' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\MainCategory\\MainCategoryDefinition' => 'Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition' => 'Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition' => 'Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\SeoUrl\\SeoUrlDefinition' => 'Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\CountryStateDefinition' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\CountryDefinition' => 'Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition' => 'Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Currency\\CurrencyDefinition' => 'Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition' => 'Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Language\\LanguageDefinition' => 'Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition' => 'Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition' => 'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Salutation\\SalutationDefinition' => 'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition',
        ];

        $this->privates['service_container'] = static function ($container) {
            include_once __DIR__.'/proxy-classes.php';
        };
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function createProxy($class, \Closure $factory)
    {
        return $factory();
    }

    /*
     * Gets the public 'Doctrine\DBAL\Connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected static function getConnectionService($container)
    {
        return $container->services['Doctrine\\DBAL\\Connection'] = \Shopware\Core\Kernel::getConnection();
    }

    /*
     * Gets the public 'OpenSearch\Client' shared service.
     *
     * @return \OpenSearch\Client
     */
    protected static function getClientService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['OpenSearch\\Client'] = $container->createProxy('ClientProxyDf0d0fc', static fn () => \ClientProxyDf0d0fc::createLazyProxy(static fn () => self::getClientService($container, false)));
        }

        return \Shopware\Elasticsearch\Framework\ClientFactory::createClient($container->getEnv('string:OPENSEARCH_URL'), ($container->services['monolog.logger.elasticsearch'] ?? self::getMonolog_Logger_ElasticsearchService($container)), false, $container->parameters['elasticsearch.ssl']);
    }

    /*
     * Gets the public 'Pentatrion\ViteBundle\Controller\ProfilerController' shared service.
     *
     * @return \Pentatrion\ViteBundle\Controller\ProfilerController
     */
    protected static function getProfilerControllerService($container)
    {
        return $container->services['Pentatrion\\ViteBundle\\Controller\\ProfilerController'] = new \Pentatrion\ViteBundle\Controller\ProfilerController(new \Pentatrion\ViteBundle\Service\Debug($container->parameters['pentatrion_vite.configs'], ($container->privates['http_client.uri_template'] ?? self::getHttpClient_UriTemplateService($container)), ($container->privates['pentatrion_vite.entrypoints_lookup_collection'] ?? self::getPentatrionVite_EntrypointsLookupCollectionService($container)), NULL), ($container->services['twig'] ?? self::getTwigService($container)));
    }

    /*
     * Gets the public 'Pentatrion\ViteBundle\Controller\ViteController' shared service.
     *
     * @return \Pentatrion\ViteBundle\Controller\ViteController
     */
    protected static function getViteControllerService($container)
    {
        return $container->services['Pentatrion\\ViteBundle\\Controller\\ViteController'] = new \Pentatrion\ViteBundle\Controller\ViteController('_default', ($container->privates['http_client.uri_template'] ?? self::getHttpClient_UriTemplateService($container)), ($container->privates['pentatrion_vite.entrypoints_lookup_collection'] ?? self::getPentatrionVite_EntrypointsLookupCollectionService($container)), NULL);
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdminExtensionApiController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdminExtensionApiController
     */
    protected static function getAdminExtensionApiControllerService($container)
    {
        $container->services['Shopware\\Administration\\Controller\\AdminExtensionApiController'] = $instance = new \Shopware\Administration\Controller\AdminExtensionApiController(($container->privates['Shopware\\Core\\Framework\\App\\ActionButton\\Executor'] ?? self::getExecutorService($container)), ($container->services['Shopware\\Core\\Framework\\App\\Payload\\AppPayloadServiceHelper'] ?? self::getAppPayloadServiceHelperService($container)), ($container->services['app.repository'] ?? self::getApp_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\App\\Hmac\\QuerySigner'] ?? self::getQuerySignerService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdminProductStreamController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdminProductStreamController
     */
    protected static function getAdminProductStreamControllerService($container)
    {
        $container->services['Shopware\\Administration\\Controller\\AdminProductStreamController'] = $instance = new \Shopware\Administration\Controller\AdminProductStreamController(($container->services['Shopware\\Core\\Content\\Product\\ProductDefinition'] ?? self::getProductDefinitionService($container)), ($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? self::getSalesChannelContextServiceService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? self::getRequestCriteriaBuilderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdminSearchController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdminSearchController
     */
    protected static function getAdminSearchControllerService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container));

        $container->services['Shopware\\Administration\\Controller\\AdminSearchController'] = $instance = new \Shopware\Administration\Controller\AdminSearchController(($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? self::getRequestCriteriaBuilderService($container)), $a, new \Shopware\Administration\Service\AdminSearcher($a), ($container->privates['serializer'] ?? self::getSerializerService($container)), ($container->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] ?? self::getAclCriteriaValidatorService($container)), $a, ($container->privates['Shopware\\Core\\Framework\\Api\\Serializer\\JsonEntityEncoder'] ?? self::getJsonEntityEncoderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdminTagController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdminTagController
     */
    protected static function getAdminTagControllerService($container)
    {
        $container->services['Shopware\\Administration\\Controller\\AdminTagController'] = $instance = new \Shopware\Administration\Controller\AdminTagController(($container->services['Shopware\\Core\\System\\Tag\\Service\\FilterTagIdsService'] ?? self::getFilterTagIdsServiceService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdministrationController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdministrationController
     */
    protected static function getAdministrationControllerService($container)
    {
        $a = ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container));

        $container->services['Shopware\\Administration\\Controller\\AdministrationController'] = $instance = new \Shopware\Administration\Controller\AdministrationController(($container->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder'] ?? self::getTemplateFinderService($container)), ($container->privates['Shopware\\Core\\Framework\\Store\\Services\\FirstRunWizardService'] ?? self::getFirstRunWizardServiceService($container)), new \Shopware\Administration\Snippet\CachedSnippetFinder(new \Shopware\Administration\Snippet\SnippetFinder(($container->services['kernel'] ?? $container->get('kernel', 1)), $a), ($container->privates['cache.object'] ?? self::getCache_ObjectService($container))), $container->parameters['kernel.supported_api_versions'], new \Shopware\Administration\Framework\Routing\KnownIps\KnownIpsCollector(), $a, ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), (\dirname(__DIR__, 4).'/vendor/shopware/core'), ($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->services['currency.repository'] ?? self::getCurrency_RepositoryService($container)), ($container->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] ?? self::getHtmlSanitizerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['parameter_bag'] ??= new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['shopware.filesystem.asset'] ?? self::getShopware_Filesystem_AssetService($container)), 'P1W');

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\DashboardController' shared service.
     *
     * @return \Shopware\Administration\Controller\DashboardController
     */
    protected static function getDashboardControllerService($container)
    {
        $container->services['Shopware\\Administration\\Controller\\DashboardController'] = $instance = new \Shopware\Administration\Controller\DashboardController(new \Shopware\Administration\Dashboard\OrderAmountService(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\Price\\CashRounding'] ??= new \Shopware\Core\Checkout\Cart\Price\CashRounding()), $container->getEnv('bool:SHOPWARE_DBAL_TIMEZONE_SUPPORT_ENABLED')));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\NotificationController' shared service.
     *
     * @return \Shopware\Administration\Controller\NotificationController
     */
    protected static function getNotificationControllerService($container)
    {
        $container->services['Shopware\\Administration\\Controller\\NotificationController'] = $instance = new \Shopware\Administration\Controller\NotificationController(($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container)), ($container->services['Shopware\\Administration\\Notification\\NotificationService'] ?? self::getNotificationServiceService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\UserConfigController' shared service.
     *
     * @return \Shopware\Administration\Controller\UserConfigController
     */
    protected static function getUserConfigControllerService($container)
    {
        $container->services['Shopware\\Administration\\Controller\\UserConfigController'] = $instance = new \Shopware\Administration\Controller\UserConfigController(($container->services['user_config.repository'] ?? self::getUserConfig_RepositoryService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Notification\NotificationDefinition' shared service.
     *
     * @return \Shopware\Administration\Notification\NotificationDefinition
     */
    protected static function getNotificationDefinitionService($container)
    {
        $container->services['Shopware\\Administration\\Notification\\NotificationDefinition'] = $instance = new \Shopware\Administration\Notification\NotificationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Notification\NotificationService' shared service.
     *
     * @return \Shopware\Administration\Notification\NotificationService
     */
    protected static function getNotificationServiceService($container)
    {
        $a = ($container->services['notification.repository'] ?? self::getNotification_RepositoryService($container));

        if (isset($container->services['Shopware\\Administration\\Notification\\NotificationService'])) {
            return $container->services['Shopware\\Administration\\Notification\\NotificationService'];
        }

        return $container->services['Shopware\\Administration\\Notification\\NotificationService'] = new \Shopware\Administration\Notification\NotificationService($a);
    }

    /*
     * Gets the public 'Shopware\Administration\Snippet\AppAdministrationSnippetDefinition' shared service.
     *
     * @return \Shopware\Administration\Snippet\AppAdministrationSnippetDefinition
     */
    protected static function getAppAdministrationSnippetDefinitionService($container)
    {
        $container->services['Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition'] = $instance = new \Shopware\Administration\Snippet\AppAdministrationSnippetDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\Calculator' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\Calculator
     */
    protected static function getCalculatorService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Cart\\Calculator'] = new \Shopware\Core\Checkout\Cart\Calculator(($container->privates['Shopware\\Core\\Checkout\\Cart\\Price\\QuantityPriceCalculator'] ?? self::getQuantityPriceCalculatorService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\Price\\PercentagePriceCalculator'] ?? self::getPercentagePriceCalculatorService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\Price\\AbsolutePriceCalculator'] ?? self::getAbsolutePriceCalculatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\Facade\CartFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\Facade\CartFacadeHookFactory
     */
    protected static function getCartFacadeHookFactoryService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Checkout\\Cart\\Facade\\ScriptPriceStubs'] ?? self::getScriptPriceStubsService($container));

        return $container->services['Shopware\\Core\\Checkout\\Cart\\Facade\\CartFacadeHookFactory'] = new \Shopware\Core\Checkout\Cart\Facade\CartFacadeHookFactory(new \Shopware\Core\Checkout\Cart\Facade\CartFacadeHelper(($container->privates['Shopware\\Core\\Checkout\\Cart\\LineItemFactoryRegistry'] ?? self::getLineItemFactoryRegistryService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\Processor'] ?? self::getProcessorService($container)), $a), $a);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\Facade\PriceFactoryFactory' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\Facade\PriceFactoryFactory
     */
    protected static function getPriceFactoryFactoryService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Cart\\Facade\\PriceFactoryFactory'] = new \Shopware\Core\Checkout\Cart\Facade\PriceFactoryFactory(($container->privates['Shopware\\Core\\Checkout\\Cart\\Facade\\ScriptPriceStubs'] ?? self::getScriptPriceStubsService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\Order\Api\OrderConverterController' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\Order\Api\OrderConverterController
     */
    protected static function getOrderConverterControllerService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Cart\\Order\\Api\\OrderConverterController'] = $instance = new \Shopware\Core\Checkout\Cart\Order\Api\OrderConverterController(($container->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? self::getOrderConverterService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? self::getCartPersisterService($container)), ($container->services['order.repository'] ?? self::getOrder_RepositoryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\Order\Api\OrderRecalculationController' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\Order\Api\OrderRecalculationController
     */
    protected static function getOrderRecalculationControllerService($container)
    {
        $a = ($container->services['order.repository'] ?? self::getOrder_RepositoryService($container));
        $b = ($container->services['order_address.repository'] ?? self::getOrderAddress_RepositoryService($container));
        $c = ($container->services['customer_address.repository'] ?? self::getCustomerAddress_RepositoryService($container));
        $d = ($container->services['order_delivery.repository'] ?? self::getOrderDelivery_RepositoryService($container));

        $container->services['Shopware\\Core\\Checkout\\Cart\\Order\\Api\\OrderRecalculationController'] = $instance = new \Shopware\Core\Checkout\Cart\Order\Api\OrderRecalculationController(new \Shopware\Core\Checkout\Cart\Order\RecalculationService($a, ($container->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? self::getOrderConverterService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? self::getCartServiceService($container)), ($container->services['product.repository'] ?? self::getProduct_RepositoryService($container)), $b, $c, ($container->services['order_line_item.repository'] ?? self::getOrderLineItem_RepositoryService($container)), $d, ($container->privates['Shopware\\Core\\Checkout\\Cart\\Processor'] ?? self::getProcessorService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartRuleLoader'] ?? self::getCartRuleLoaderService($container)), ($container->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\PromotionItemBuilder'] ??= new \Shopware\Core\Checkout\Promotion\Cart\PromotionItemBuilder())), new \Shopware\Core\Checkout\Order\OrderAddressService($a, $b, $c, $d));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\PriceActionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\PriceActionController
     */
    protected static function getPriceActionControllerService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Cart\\PriceActionController'] = $instance = new \Shopware\Core\Checkout\Cart\PriceActionController(($container->services['tax.repository'] ?? self::getTax_RepositoryService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\Price\\NetPriceCalculator'] ?? self::getNetPriceCalculatorService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\Price\\GrossPriceCalculator'] ?? self::getGrossPriceCalculatorService($container)), ($container->services['currency.repository'] ?? self::getCurrency_RepositoryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartDeleteRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartDeleteRoute
     */
    protected static function getCartDeleteRouteService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? self::getCartPersisterService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'];
        }

        return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartDeleteRoute($a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartItemAddRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartItemAddRoute
     */
    protected static function getCartItemAddRouteService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? self::getCartCalculatorService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'];
        }
        $b = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? self::getCartPersisterService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'];
        }
        $c = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'];
        }
        $d = ($container->privates['Shopware\\Core\\Checkout\\Cart\\LineItemFactoryRegistry'] ?? self::getLineItemFactoryRegistryService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'];
        }
        $e = ($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'];
        }

        return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartItemAddRoute($a, $b, $c, $d, $e);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartItemRemoveRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartItemRemoveRoute
     */
    protected static function getCartItemRemoveRouteService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'];
        }
        $b = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? self::getCartCalculatorService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'];
        }
        $c = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? self::getCartPersisterService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'];
        }

        return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartItemRemoveRoute($a, $b, $c);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartItemUpdateRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartItemUpdateRoute
     */
    protected static function getCartItemUpdateRouteService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? self::getCartPersisterService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'];
        }
        $b = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? self::getCartCalculatorService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'];
        }
        $c = ($container->privates['Shopware\\Core\\Checkout\\Cart\\LineItemFactoryRegistry'] ?? self::getLineItemFactoryRegistryService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'];
        }

        return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartItemUpdateRoute($a, $b, $c, $d);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartLoadRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartLoadRoute
     */
    protected static function getCartLoadRouteService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? self::getCartPersisterService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'];
        }
        $b = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartFactory'] ?? self::getCartFactoryService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'];
        }
        $c = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? self::getCartCalculatorService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'];
        }
        $d = ($container->privates['Shopware\\Core\\Checkout\\Cart\\TaxProvider\\TaxProviderProcessor'] ?? self::getTaxProviderProcessorService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'];
        }

        return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartLoadRoute($a, $b, $c, $d);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartOrderRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartOrderRoute
     */
    protected static function getCartOrderRouteService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? self::getCartCalculatorService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $b = ($container->services['order.repository'] ?? self::getOrder_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $c = ($container->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? self::getOrderConverterService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $d = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartSerializationCleaner'] ?? self::getCartSerializationCleanerService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $e = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? self::getCartPersisterService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $f = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $g = ($container->privates['Shopware\\Core\\Checkout\\Payment\\PaymentProcessor'] ?? self::getPaymentProcessorService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $h = ($container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'] ?? self::getCheckoutGatewayRouteService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $i = ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartContextHasher'] ?? self::getCartContextHasherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }

        return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartOrderRoute($a, $b, new \Shopware\Core\Checkout\Cart\Order\OrderPersister($b, $c, $d), $e, $f, $g, ($container->privates['Shopware\\Core\\Checkout\\Cart\\TaxProvider\\TaxProviderProcessor'] ?? self::getTaxProviderProcessorService($container)), $h, $i, ($container->privates['lock.default.factory'] ?? self::getLock_Default_FactoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartService' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartService
     */
    protected static function getCartServiceService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] = $container->createProxy('CartServiceGhost1f3552a', static fn () => \CartServiceGhost1f3552a::createLazyGhost(static fn ($proxy) => self::getCartServiceService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? self::getCartPersisterService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? self::getCartCalculatorService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'] ?? self::getCartLoadRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'] ?? self::getCartDeleteRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'] ?? self::getCartItemAddRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'] ?? self::getCartItemUpdateRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'] ?? self::getCartItemRemoveRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'] ?? self::getCartOrderRouteService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartFactory'] ?? self::getCartFactoryService($container))) && false ?: $lazyLoad);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\TaxProvider\TaxProviderRegistry' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\TaxProvider\TaxProviderRegistry
     */
    protected static function getTaxProviderRegistryService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Cart\\TaxProvider\\TaxProviderRegistry'] = new \Shopware\Core\Checkout\Cart\TaxProvider\TaxProviderRegistry(new RewindableGenerator(fn () => new \EmptyIterator(), 0));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerAddress\CustomerAddressDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerAddress\CustomerAddressDefinition
     */
    protected static function getCustomerAddressDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerAddress\CustomerAddressDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupRegistrationSalesChannel\CustomerGroupRegistrationSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupRegistrationSalesChannel\CustomerGroupRegistrationSalesChannelDefinition
     */
    protected static function getCustomerGroupRegistrationSalesChannelDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupRegistrationSalesChannel\CustomerGroupRegistrationSalesChannelDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupTranslation\CustomerGroupTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupTranslation\CustomerGroupTranslationDefinition
     */
    protected static function getCustomerGroupTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupTranslation\CustomerGroupTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerGroup\CustomerGroupDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroup\CustomerGroupDefinition
     */
    protected static function getCustomerGroupDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroup\CustomerGroupDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerRecovery\CustomerRecoveryDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerRecovery\CustomerRecoveryDefinition
     */
    protected static function getCustomerRecoveryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerRecovery\CustomerRecoveryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerTag\CustomerTagDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerTag\CustomerTagDefinition
     */
    protected static function getCustomerTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerTag\CustomerTagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlistProduct\CustomerWishlistProductDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlistProduct\CustomerWishlistProductDefinition
     */
    protected static function getCustomerWishlistProductDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlistProduct\CustomerWishlistProductDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlist\CustomerWishlistDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlist\CustomerWishlistDefinition
     */
    protected static function getCustomerWishlistDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlist\CustomerWishlistDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Api\CustomerGroupRegistrationActionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Api\CustomerGroupRegistrationActionController
     */
    protected static function getCustomerGroupRegistrationActionControllerService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\Api\\CustomerGroupRegistrationActionController'] = new \Shopware\Core\Checkout\Customer\Api\CustomerGroupRegistrationActionController(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->services['customer_group.repository'] ?? self::getCustomerGroup_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextRestorer'] ?? self::getSalesChannelContextRestorerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\CustomerDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\CustomerDefinition
     */
    protected static function getCustomerDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Customer\\CustomerDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\CustomerDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\AccountNewsletterRecipientRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\AccountNewsletterRecipientRoute
     */
    protected static function getAccountNewsletterRecipientRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountNewsletterRecipientRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\AccountNewsletterRecipientRoute(($container->services['sales_channel.newsletter_recipient.repository'] ?? self::getSalesChannel_NewsletterRecipient_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\AddWishlistProductRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\AddWishlistProductRoute
     */
    protected static function getAddWishlistProductRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AddWishlistProductRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\AddWishlistProductRoute(($container->services['customer_wishlist.repository'] ?? self::getCustomerWishlist_RepositoryService($container)), ($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ChangeCustomerProfileRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ChangeCustomerProfileRoute
     */
    protected static function getChangeCustomerProfileRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeCustomerProfileRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ChangeCustomerProfileRoute(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\CustomerProfileValidationFactory'] ?? self::getCustomerProfileValidationFactoryService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\StoreApiCustomFieldMapper'] ?? self::getStoreApiCustomFieldMapperService($container)), ($container->services['salutation.repository'] ?? self::getSalutation_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ChangeEmailRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ChangeEmailRoute
     */
    protected static function getChangeEmailRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeEmailRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ChangeEmailRoute(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ChangeLanguageRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ChangeLanguageRoute
     */
    protected static function getChangeLanguageRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeLanguageRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ChangeLanguageRoute(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ChangePasswordRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ChangePasswordRoute
     */
    protected static function getChangePasswordRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangePasswordRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ChangePasswordRoute(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\CustomerGroupRegistrationSettingsRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\CustomerGroupRegistrationSettingsRoute
     */
    protected static function getCustomerGroupRegistrationSettingsRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerGroupRegistrationSettingsRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\CustomerGroupRegistrationSettingsRoute(($container->services['customer_group.repository'] ?? self::getCustomerGroup_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\CustomerRecoveryIsExpiredRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\CustomerRecoveryIsExpiredRoute
     */
    protected static function getCustomerRecoveryIsExpiredRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRecoveryIsExpiredRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\CustomerRecoveryIsExpiredRoute(($container->services['customer_recovery.repository'] ?? self::getCustomerRecovery_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\CustomerRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\CustomerRoute
     */
    protected static function getCustomerRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\CustomerRoute(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\DeleteAddressRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\DeleteAddressRoute
     */
    protected static function getDeleteAddressRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteAddressRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\DeleteAddressRoute(($container->services['customer_address.repository'] ?? self::getCustomerAddress_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\DeleteCustomerRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\DeleteCustomerRoute
     */
    protected static function getDeleteCustomerRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteCustomerRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\DeleteCustomerRoute(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\DownloadRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\DownloadRoute
     */
    protected static function getDownloadRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DownloadRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\DownloadRoute(($container->services['order_line_item_download.repository'] ?? self::getOrderLineItemDownload_RepositoryService($container)), new \Shopware\Core\Content\Media\File\DownloadResponseGenerator(($container->services['shopware.filesystem.public'] ?? self::getShopware_Filesystem_PublicService($container)), ($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), ($container->privates['Shopware\\Core\\Content\\Media\\MediaService'] ?? self::getMediaServiceService($container)), 'php', ($container->privates['Shopware\\Core\\Content\\Media\\Core\\Application\\AbstractMediaUrlGenerator'] ?? self::getAbstractMediaUrlGeneratorService($container)), ''));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ImitateCustomerRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ImitateCustomerRoute
     */
    protected static function getImitateCustomerRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ImitateCustomerRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ImitateCustomerRoute(($container->privates['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountService'] ?? self::getAccountServiceService($container)), ($container->privates['Shopware\\Core\\Checkout\\Customer\\ImitateCustomerTokenGenerator'] ??= new \Shopware\Core\Checkout\Customer\ImitateCustomerTokenGenerator($container->getEnv('APP_SECRET'))), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute'] ?? self::getLogoutRouteService($container)), ($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'] ?? self::getSalesChannelContextFactoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ListAddressRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ListAddressRoute
     */
    protected static function getListAddressRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ListAddressRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ListAddressRoute(($container->services['customer_address.repository'] ?? self::getCustomerAddress_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\LoadWishlistRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\LoadWishlistRoute
     */
    protected static function getLoadWishlistRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoadWishlistRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\LoadWishlistRoute(($container->services['customer_wishlist.repository'] ?? self::getCustomerWishlist_RepositoryService($container)), ($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] ??= new \Shopware\Core\Content\Product\SalesChannel\ProductCloseoutFilterFactory()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\LoginRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\LoginRoute
     */
    protected static function getLoginRouteService($container)
    {
        $a = new \Shopware\Core\Framework\RateLimiter\RateLimiter();

        $b = ($container->privates['cache.rate_limiter'] ?? self::getCache_RateLimiterService($container));
        $c = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));
        $d = ($container->privates['lock.default.factory'] ?? self::getLock_Default_FactoryService($container));

        $a->registerLimiterFactory('login', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $container->parameters['shopware.api.rate_limiter.login.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'login'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('guest_login', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $container->parameters['shopware.api.rate_limiter.login.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'guest_login'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('oauth', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $container->parameters['shopware.api.rate_limiter.login.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'oauth'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('reset_password', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $container->parameters['shopware.api.rate_limiter.reset_password.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'reset_password'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('user_recovery', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $container->parameters['shopware.api.rate_limiter.reset_password.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'user_recovery'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('contact_form', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $container->parameters['shopware.api.rate_limiter.reset_password.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'contact_form'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('notification', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $container->parameters['shopware.api.rate_limiter.login.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'notification'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('newsletter_form', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $container->parameters['shopware.api.rate_limiter.reset_password.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'newsletter_form'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('cart_add_line_item', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'system_config', 'reset' => '1 hours', 'limits' => $container->parameters['shopware.api.rate_limiter.cart_add_line_item.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'cart_add_line_item'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));

        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoginRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\LoginRoute(($container->privates['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountService'] ?? self::getAccountServiceService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), $a);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\LogoutRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\LogoutRoute
     */
    protected static function getLogoutRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\LogoutRoute(($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? self::getSalesChannelContextPersisterService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? self::getCartServiceService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\MergeWishlistProductRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\MergeWishlistProductRoute
     */
    protected static function getMergeWishlistProductRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\MergeWishlistProductRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\MergeWishlistProductRoute(($container->services['customer_wishlist.repository'] ?? self::getCustomerWishlist_RepositoryService($container)), ($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\RegisterConfirmRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\RegisterConfirmRoute
     */
    protected static function getRegisterConfirmRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterConfirmRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\RegisterConfirmRoute(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? self::getSalesChannelContextPersisterService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? self::getSalesChannelContextServiceService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\RegisterRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\RegisterRoute
     */
    protected static function getRegisterRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\RegisterRoute(($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'] ?? self::getNumberRangeValueGeneratorInterfaceService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), new \Shopware\Core\Checkout\Customer\Validation\CustomerValidationFactory(($container->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\CustomerProfileValidationFactory'] ?? self::getCustomerProfileValidationFactoryService($container))), ($container->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\AddressValidationFactory'] ?? self::getAddressValidationFactoryService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? self::getSalesChannelContextPersisterService($container)), ($container->services['sales_channel.country.repository'] ?? self::getSalesChannel_Country_RepositoryService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? self::getSalesChannelContextServiceService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\StoreApiCustomFieldMapper'] ?? self::getStoreApiCustomFieldMapperService($container)), ($container->services['salutation.repository'] ?? self::getSalutation_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\RemoveWishlistProductRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\RemoveWishlistProductRoute
     */
    protected static function getRemoveWishlistProductRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RemoveWishlistProductRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\RemoveWishlistProductRoute(($container->services['customer_wishlist.repository'] ?? self::getCustomerWishlist_RepositoryService($container)), ($container->services['customer_wishlist_product.repository'] ?? self::getCustomerWishlistProduct_RepositoryService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ResetPasswordRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ResetPasswordRoute
     */
    protected static function getResetPasswordRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ResetPasswordRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ResetPasswordRoute(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->services['customer_recovery.repository'] ?? self::getCustomerRecovery_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\SendPasswordRecoveryMailRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\SendPasswordRecoveryMailRoute
     */
    protected static function getSendPasswordRecoveryMailRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SendPasswordRecoveryMailRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\SendPasswordRecoveryMailRoute(($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), ($container->services['customer_recovery.repository'] ?? self::getCustomerRecovery_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\SwitchDefaultAddressRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\SwitchDefaultAddressRoute
     */
    protected static function getSwitchDefaultAddressRouteService($container)
    {
        $a = ($container->services['customer_address.repository'] ?? self::getCustomerAddress_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'];
        }
        $b = ($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'];
        }
        $c = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'];
        }

        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\SwitchDefaultAddressRoute($a, $b, $c);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\UpsertAddressRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\UpsertAddressRoute
     */
    protected static function getUpsertAddressRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\UpsertAddressRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\UpsertAddressRoute(($container->services['customer_address.repository'] ?? self::getCustomerAddress_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\AddressValidationFactory'] ?? self::getAddressValidationFactoryService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\StoreApiCustomFieldMapper'] ?? self::getStoreApiCustomFieldMapperService($container)), ($container->services['salutation.repository'] ?? self::getSalutation_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfigSalesChannel\DocumentBaseConfigSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfigSalesChannel\DocumentBaseConfigSalesChannelDefinition
     */
    protected static function getDocumentBaseConfigSalesChannelDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition'] = $instance = new \Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfigSalesChannel\DocumentBaseConfigSalesChannelDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfig\DocumentBaseConfigDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfig\DocumentBaseConfigDefinition
     */
    protected static function getDocumentBaseConfigDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition'] = $instance = new \Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfig\DocumentBaseConfigDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Aggregate\DocumentTypeTranslation\DocumentTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Aggregate\DocumentTypeTranslation\DocumentTypeTranslationDefinition
     */
    protected static function getDocumentTypeTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Document\Aggregate\DocumentTypeTranslation\DocumentTypeTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Aggregate\DocumentType\DocumentTypeDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Aggregate\DocumentType\DocumentTypeDefinition
     */
    protected static function getDocumentTypeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition'] = $instance = new \Shopware\Core\Checkout\Document\Aggregate\DocumentType\DocumentTypeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Controller\DocumentController' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Controller\DocumentController
     */
    protected static function getDocumentControllerService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Checkout\\Document\\Service\\DocumentGenerator'] ?? self::getDocumentGeneratorService($container));

        $container->services['Shopware\\Core\\Checkout\\Document\\Controller\\DocumentController'] = $instance = new \Shopware\Core\Checkout\Document\Controller\DocumentController($a, new \Shopware\Core\Checkout\Document\Service\DocumentMerger(($container->services['document.repository'] ?? self::getDocument_RepositoryService($container)), ($container->privates['Shopware\\Core\\Content\\Media\\MediaService'] ?? self::getMediaServiceService($container)), $a, new \setasign\Fpdi\Tfpdf\Fpdi(), ($container->privates['filesystem'] ??= new \Symfony\Component\Filesystem\Filesystem())));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\DocumentDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\DocumentDefinition
     */
    protected static function getDocumentDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Document\\DocumentDefinition'] = $instance = new \Shopware\Core\Checkout\Document\DocumentDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\DocumentGeneratorController' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\DocumentGeneratorController
     */
    protected static function getDocumentGeneratorControllerService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Document\\DocumentGeneratorController'] = $instance = new \Shopware\Core\Checkout\Document\DocumentGeneratorController(($container->privates['Shopware\\Core\\Checkout\\Document\\Service\\DocumentGenerator'] ?? self::getDocumentGeneratorService($container)), ($container->privates['serializer'] ?? self::getSerializerService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\SalesChannel\DocumentRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\SalesChannel\DocumentRoute
     */
    protected static function getDocumentRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Document\\SalesChannel\\DocumentRoute'] = new \Shopware\Core\Checkout\Document\SalesChannel\DocumentRoute(($container->privates['Shopware\\Core\\Checkout\\Document\\Service\\DocumentGenerator'] ?? self::getDocumentGeneratorService($container)), ($container->services['document.repository'] ?? self::getDocument_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Gateway\SalesChannel\CheckoutGatewayRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Gateway\SalesChannel\CheckoutGatewayRoute
     */
    protected static function getCheckoutGatewayRouteService($container)
    {
        $a = ($container->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\PaymentMethodRoute'] ?? self::getPaymentMethodRouteService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'];
        }
        $b = ($container->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\ShippingMethodRoute'] ?? self::getShippingMethodRouteService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\App\\Payload\\AppPayloadServiceHelper'] ?? self::getAppPayloadServiceHelperService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'];
        }
        $d = ($container->services['app.repository'] ?? self::getApp_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'];
        }
        $e = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'];
        }
        $f = ($container->privates['Shopware\\Core\\Framework\\Log\\ExceptionLogger'] ?? self::getExceptionLoggerService($container));
        $g = new \Shopware\Core\Checkout\Gateway\Command\Registry\CheckoutGatewayCommandRegistry(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Checkout\\Gateway\\Command\\Handler\\AddCartErrorCommandHandler'] ??= new \Shopware\Core\Checkout\Gateway\Command\Handler\AddCartErrorCommandHandler());
            yield 1 => ($container->privates['Shopware\\Core\\Checkout\\Gateway\\Command\\Handler\\AddPaymentMethodCommandHandler'] ?? self::getAddPaymentMethodCommandHandlerService($container));
            yield 2 => ($container->privates['Shopware\\Core\\Checkout\\Gateway\\Command\\Handler\\AddPaymentMethodExtensionsCommandHandler'] ?? self::getAddPaymentMethodExtensionsCommandHandlerService($container));
            yield 3 => ($container->privates['Shopware\\Core\\Checkout\\Gateway\\Command\\Handler\\RemovePaymentMethodCommandHandler'] ??= new \Shopware\Core\Checkout\Gateway\Command\Handler\RemovePaymentMethodCommandHandler());
            yield 4 => ($container->privates['Shopware\\Core\\Checkout\\Gateway\\Command\\Handler\\AddShippingMethodCommandHandler'] ?? self::getAddShippingMethodCommandHandlerService($container));
            yield 5 => ($container->privates['Shopware\\Core\\Checkout\\Gateway\\Command\\Handler\\AddShippingMethodExtensionsCommandHandler'] ?? self::getAddShippingMethodExtensionsCommandHandlerService($container));
            yield 6 => ($container->privates['Shopware\\Core\\Checkout\\Gateway\\Command\\Handler\\RemoveShippingMethodCommandHandler'] ??= new \Shopware\Core\Checkout\Gateway\Command\Handler\RemoveShippingMethodCommandHandler());
        }, 7));

        return $container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'] = new \Shopware\Core\Checkout\Gateway\SalesChannel\CheckoutGatewayRoute($a, $b, new \Shopware\Core\Framework\App\Checkout\Gateway\AppCheckoutGateway(new \Shopware\Core\Framework\App\Checkout\Payload\AppCheckoutGatewayPayloadService($c, ($container->privates['shopware.app_system.guzzle'] ?? self::getShopware_AppSystem_GuzzleService($container)), $f), new \Shopware\Core\Checkout\Gateway\Command\Executor\CheckoutGatewayCommandExecutor($g, $f), $g, $d, $e, $f, ($container->privates['Shopware\\Core\\Framework\\App\\ActiveAppsLoader'] ?? self::getActiveAppsLoaderService($container))), ($container->privates['Shopware\\Core\\Framework\\Rule\\RuleIdMatcher'] ??= new \Shopware\Core\Framework\Rule\RuleIdMatcher()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderAddress\OrderAddressDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderAddress\OrderAddressDefinition
     */
    protected static function getOrderAddressDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderAddress\OrderAddressDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderCustomer\OrderCustomerDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderCustomer\OrderCustomerDefinition
     */
    protected static function getOrderCustomerDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderCustomer\OrderCustomerDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderDeliveryPosition\OrderDeliveryPositionDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderDeliveryPosition\OrderDeliveryPositionDefinition
     */
    protected static function getOrderDeliveryPositionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderDeliveryPosition\OrderDeliveryPositionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderDelivery\OrderDeliveryDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderDelivery\OrderDeliveryDefinition
     */
    protected static function getOrderDeliveryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderDelivery\OrderDeliveryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderLineItemDownload\OrderLineItemDownloadDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderLineItemDownload\OrderLineItemDownloadDefinition
     */
    protected static function getOrderLineItemDownloadDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItemDownload\\OrderLineItemDownloadDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderLineItemDownload\OrderLineItemDownloadDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderLineItem\OrderLineItemDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderLineItem\OrderLineItemDefinition
     */
    protected static function getOrderLineItemDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderLineItem\OrderLineItemDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTag\OrderTagDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTag\OrderTagDefinition
     */
    protected static function getOrderTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTag\OrderTagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefundPosition\OrderTransactionCaptureRefundPositionDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefundPosition\OrderTransactionCaptureRefundPositionDefinition
     */
    protected static function getOrderTransactionCaptureRefundPositionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefundPosition\OrderTransactionCaptureRefundPositionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefund\OrderTransactionCaptureRefundDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefund\OrderTransactionCaptureRefundDefinition
     */
    protected static function getOrderTransactionCaptureRefundDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefund\OrderTransactionCaptureRefundDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCapture\OrderTransactionCaptureDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCapture\OrderTransactionCaptureDefinition
     */
    protected static function getOrderTransactionCaptureDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCapture\OrderTransactionCaptureDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionDefinition
     */
    protected static function getOrderTransactionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Api\OrderActionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Api\OrderActionController
     */
    protected static function getOrderActionControllerService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\Api\\OrderActionController'] = $instance = new \Shopware\Core\Checkout\Order\Api\OrderActionController(($container->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? self::getOrderServiceService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->services['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentRefundProcessor'] ?? self::getPaymentRefundProcessorService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\OrderDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\OrderDefinition
     */
    protected static function getOrderDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Order\\OrderDefinition'] = $instance = new \Shopware\Core\Checkout\Order\OrderDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\SalesChannel\CancelOrderRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\SalesChannel\CancelOrderRoute
     */
    protected static function getCancelOrderRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\CancelOrderRoute'] = new \Shopware\Core\Checkout\Order\SalesChannel\CancelOrderRoute(($container->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? self::getOrderServiceService($container)), ($container->services['order.repository'] ?? self::getOrder_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\SalesChannel\OrderRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\SalesChannel\OrderRoute
     */
    protected static function getOrderRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute'] = new \Shopware\Core\Checkout\Order\SalesChannel\OrderRoute(($container->services['order.repository'] ?? self::getOrder_RepositoryService($container)), ($container->services['promotion.repository'] ?? self::getPromotion_RepositoryService($container)), ($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\SalesChannel\SetPaymentOrderRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\SalesChannel\SetPaymentOrderRoute
     */
    protected static function getSetPaymentOrderRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\SetPaymentOrderRoute'] = new \Shopware\Core\Checkout\Order\SalesChannel\SetPaymentOrderRoute(($container->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? self::getOrderServiceService($container)), ($container->services['order.repository'] ?? self::getOrder_RepositoryService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? self::getOrderConverterService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\CartRuleLoader'] ?? self::getCartRuleLoaderService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\System\\StateMachine\\Loader\\InitialStateIdLoader'] ?? self::getInitialStateIdLoaderService($container)), ($container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'] ?? self::getCheckoutGatewayRouteService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\Aggregate\PaymentMethodTranslation\PaymentMethodTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\Aggregate\PaymentMethodTranslation\PaymentMethodTranslationDefinition
     */
    protected static function getPaymentMethodTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Payment\Aggregate\PaymentMethodTranslation\PaymentMethodTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\Cart\PaymentRecurringProcessor' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\Cart\PaymentRecurringProcessor
     */
    protected static function getPaymentRecurringProcessorService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentRecurringProcessor'] = new \Shopware\Core\Checkout\Payment\Cart\PaymentRecurringProcessor(($container->services['order_transaction.repository'] ?? self::getOrderTransaction_RepositoryService($container)), ($container->privates['Shopware\\Core\\System\\StateMachine\\Loader\\InitialStateIdLoader'] ?? self::getInitialStateIdLoaderService($container)), ($container->privates['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionStateHandler'] ?? self::getOrderTransactionStateHandlerService($container)), ($container->privates['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentHandler\\PaymentHandlerRegistry'] ?? self::getPaymentHandlerRegistryService($container)), ($container->privates['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentTransactionStructFactory'] ??= new \Shopware\Core\Checkout\Payment\Cart\PaymentTransactionStructFactory()), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\Cart\PaymentRefundProcessor' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\Cart\PaymentRefundProcessor
     */
    protected static function getPaymentRefundProcessorService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentRefundProcessor'] = new \Shopware\Core\Checkout\Payment\Cart\PaymentRefundProcessor(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), new \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefund\OrderTransactionCaptureRefundStateHandler(($container->privates['Shopware\\Core\\System\\StateMachine\\StateMachineRegistry'] ?? self::getStateMachineRegistryService($container))), ($container->privates['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentHandler\\PaymentHandlerRegistry'] ?? self::getPaymentHandlerRegistryService($container)), ($container->privates['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentTransactionStructFactory'] ??= new \Shopware\Core\Checkout\Payment\Cart\PaymentTransactionStructFactory()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\Controller\PaymentController' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\Controller\PaymentController
     */
    protected static function getPaymentControllerService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Payment\\Controller\\PaymentController'] = $instance = new \Shopware\Core\Checkout\Payment\Controller\PaymentController(($container->privates['Shopware\\Core\\Checkout\\Payment\\PaymentProcessor'] ?? self::getPaymentProcessorService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? self::getOrderConverterService($container)), ($container->privates['Shopware\\Core\\Checkout\\Payment\\Cart\\Token\\JWTFactoryV2'] ?? self::getJWTFactoryV2Service($container)), ($container->services['order.repository'] ?? self::getOrder_RepositoryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\PaymentMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\PaymentMethodDefinition
     */
    protected static function getPaymentMethodDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Payment\\PaymentMethodDefinition'] = $instance = new \Shopware\Core\Checkout\Payment\PaymentMethodDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\SalesChannel\HandlePaymentMethodRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\SalesChannel\HandlePaymentMethodRoute
     */
    protected static function getHandlePaymentMethodRouteService($container)
    {
        return $container->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\HandlePaymentMethodRoute'] = new \Shopware\Core\Checkout\Payment\SalesChannel\HandlePaymentMethodRoute(($container->privates['Shopware\\Core\\Checkout\\Payment\\PaymentProcessor'] ?? self::getPaymentProcessorService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? self::getSalesChannelContextServiceService($container)), ($container->services['currency.repository'] ?? self::getCurrency_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\SalesChannel\PaymentMethodRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\SalesChannel\PaymentMethodRoute
     */
    protected static function getPaymentMethodRouteService($container)
    {
        $a = ($container->services['sales_channel.payment_method.repository'] ?? self::getSalesChannel_PaymentMethod_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\PaymentMethodRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\PaymentMethodRoute'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\PaymentMethodRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\PaymentMethodRoute'];
        }

        return $container->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\PaymentMethodRoute'] = new \Shopware\Core\Checkout\Payment\SalesChannel\PaymentMethodRoute($a, $b, ($container->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'] ?? self::getScriptExecutorService($container)), ($container->privates['Shopware\\Core\\Framework\\Rule\\RuleIdMatcher'] ??= new \Shopware\Core\Framework\Rule\RuleIdMatcher()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\SalesChannel\SalesChannelPaymentMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\SalesChannel\SalesChannelPaymentMethodDefinition
     */
    protected static function getSalesChannelPaymentMethodDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition'] = $instance = new \Shopware\Core\Checkout\Payment\SalesChannel\SalesChannelPaymentMethodDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionCartRule\PromotionCartRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionCartRule\PromotionCartRuleDefinition
     */
    protected static function getPromotionCartRuleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionCartRule\PromotionCartRuleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountPrice\PromotionDiscountPriceDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountPrice\PromotionDiscountPriceDefinition
     */
    protected static function getPromotionDiscountPriceDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountPrice\PromotionDiscountPriceDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountRule\PromotionDiscountRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountRule\PromotionDiscountRuleDefinition
     */
    protected static function getPromotionDiscountRuleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountRule\PromotionDiscountRuleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscount\PromotionDiscountDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscount\PromotionDiscountDefinition
     */
    protected static function getPromotionDiscountDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscount\PromotionDiscountDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionIndividualCode\PromotionIndividualCodeDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionIndividualCode\PromotionIndividualCodeDefinition
     */
    protected static function getPromotionIndividualCodeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionIndividualCode\PromotionIndividualCodeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionOrderRule\PromotionOrderRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionOrderRule\PromotionOrderRuleDefinition
     */
    protected static function getPromotionOrderRuleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionOrderRule\PromotionOrderRuleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaCustomer\PromotionPersonaCustomerDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaCustomer\PromotionPersonaCustomerDefinition
     */
    protected static function getPromotionPersonaCustomerDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaCustomer\PromotionPersonaCustomerDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaRule\PromotionPersonaRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaRule\PromotionPersonaRuleDefinition
     */
    protected static function getPromotionPersonaRuleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaRule\PromotionPersonaRuleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionSalesChannel\PromotionSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSalesChannel\PromotionSalesChannelDefinition
     */
    protected static function getPromotionSalesChannelDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSalesChannel\PromotionSalesChannelDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroupRule\PromotionSetGroupRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroupRule\PromotionSetGroupRuleDefinition
     */
    protected static function getPromotionSetGroupRuleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroupRule\PromotionSetGroupRuleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroup\PromotionSetGroupDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroup\PromotionSetGroupDefinition
     */
    protected static function getPromotionSetGroupDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroup\PromotionSetGroupDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionTranslation\PromotionTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionTranslation\PromotionTranslationDefinition
     */
    protected static function getPromotionTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionTranslation\PromotionTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Api\PromotionActionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Api\PromotionActionController
     */
    protected static function getPromotionActionControllerService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Api\\PromotionActionController'] = $instance = new \Shopware\Core\Checkout\Promotion\Api\PromotionActionController(($container->privates['Shopware\\Core\\Checkout\\Cart\\LineItem\\Group\\LineItemGroupServiceRegistry'] ?? self::getLineItemGroupServiceRegistryService($container)), ($container->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\Discount\\Filter\\FilterServiceRegistry'] ?? self::getFilterServiceRegistryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Api\PromotionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Api\PromotionController
     */
    protected static function getPromotionControllerService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\Api\\PromotionController'] = $instance = new \Shopware\Core\Checkout\Promotion\Api\PromotionController(new \Shopware\Core\Checkout\Promotion\Util\PromotionCodeService(($container->services['promotion.repository'] ?? self::getPromotion_RepositoryService($container)), ($container->services['promotion_individual_code.repository'] ?? self::getPromotionIndividualCode_RepositoryService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\PromotionDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\PromotionDefinition
     */
    protected static function getPromotionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\PromotionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodPrice\ShippingMethodPriceDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodPrice\ShippingMethodPriceDefinition
     */
    protected static function getShippingMethodPriceDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodPrice\ShippingMethodPriceDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTag\ShippingMethodTagDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTag\ShippingMethodTagDefinition
     */
    protected static function getShippingMethodTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTag\ShippingMethodTagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTranslation\ShippingMethodTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTranslation\ShippingMethodTranslationDefinition
     */
    protected static function getShippingMethodTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTranslation\ShippingMethodTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\SalesChannel\SalesChannelShippingMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\SalesChannel\SalesChannelShippingMethodDefinition
     */
    protected static function getSalesChannelShippingMethodDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\SalesChannel\SalesChannelShippingMethodDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\SalesChannel\ShippingMethodRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\SalesChannel\ShippingMethodRoute
     */
    protected static function getShippingMethodRouteService($container)
    {
        $a = ($container->services['sales_channel.shipping_method.repository'] ?? self::getSalesChannel_ShippingMethod_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\ShippingMethodRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\ShippingMethodRoute'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\ShippingMethodRoute'])) {
            return $container->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\ShippingMethodRoute'];
        }

        return $container->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\ShippingMethodRoute'] = new \Shopware\Core\Checkout\Shipping\SalesChannel\ShippingMethodRoute($a, $b, ($container->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'] ?? self::getScriptExecutorService($container)), ($container->privates['Shopware\\Core\\Framework\\Rule\\RuleIdMatcher'] ??= new \Shopware\Core\Framework\Rule\RuleIdMatcher()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\ShippingMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\ShippingMethodDefinition
     */
    protected static function getShippingMethodDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Checkout\\Shipping\\ShippingMethodDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\ShippingMethodDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Breadcrumb\SalesChannel\BreadcrumbRoute' shared service.
     *
     * @return \Shopware\Core\Content\Breadcrumb\SalesChannel\BreadcrumbRoute
     */
    protected static function getBreadcrumbRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Breadcrumb\\SalesChannel\\BreadcrumbRoute'] = new \Shopware\Core\Content\Breadcrumb\SalesChannel\BreadcrumbRoute(($container->privates['Shopware\\Core\\Content\\Category\\Service\\CategoryBreadcrumbBuilder'] ?? self::getCategoryBreadcrumbBuilderService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\Aggregate\CategoryTag\CategoryTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Category\Aggregate\CategoryTag\CategoryTagDefinition
     */
    protected static function getCategoryTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition'] = $instance = new \Shopware\Core\Content\Category\Aggregate\CategoryTag\CategoryTagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\Aggregate\CategoryTranslation\CategoryTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Category\Aggregate\CategoryTranslation\CategoryTranslationDefinition
     */
    protected static function getCategoryTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition'] = $instance = new \Shopware\Core\Content\Category\Aggregate\CategoryTranslation\CategoryTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\CategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Category\CategoryDefinition
     */
    protected static function getCategoryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Category\\CategoryDefinition'] = $instance = new \Shopware\Core\Content\Category\CategoryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\CategoryHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Category\CategoryHydrator
     */
    protected static function getCategoryHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Category\\CategoryHydrator'] = new \Shopware\Core\Content\Category\CategoryHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\SalesChannel\CategoryListRoute' shared service.
     *
     * @return \Shopware\Core\Content\Category\SalesChannel\CategoryListRoute
     */
    protected static function getCategoryListRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CategoryListRoute'] = new \Shopware\Core\Content\Category\SalesChannel\CategoryListRoute(($container->services['sales_channel.category.repository'] ?? self::getSalesChannel_Category_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\SalesChannel\CategoryRoute' shared service.
     *
     * @return \Shopware\Core\Content\Category\SalesChannel\CategoryRoute
     */
    protected static function getCategoryRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CategoryRoute'] = new \Shopware\Core\Content\Category\SalesChannel\CategoryRoute(($container->services['sales_channel.category.repository'] ?? self::getSalesChannel_Category_RepositoryService($container)), ($container->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? self::getSalesChannelCmsPageLoaderService($container)), ($container->services['Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition'] ?? self::getSalesChannelCategoryDefinitionService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\SalesChannel\SalesChannelCategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Category\SalesChannel\SalesChannelCategoryDefinition
     */
    protected static function getSalesChannelCategoryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition'] = $instance = new \Shopware\Core\Content\Category\SalesChannel\SalesChannelCategoryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\SalesChannel\TreeBuildingNavigationRoute' shared service.
     *
     * @return \Shopware\Core\Content\Category\SalesChannel\TreeBuildingNavigationRoute
     */
    protected static function getTreeBuildingNavigationRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Category\\SalesChannel\\TreeBuildingNavigationRoute'] = new \Shopware\Core\Content\Category\SalesChannel\TreeBuildingNavigationRoute(new \Shopware\Core\Content\Category\SalesChannel\NavigationRoute(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->services['sales_channel.category.repository'] ?? self::getSalesChannel_Category_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container))));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsBlock\CmsBlockDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsBlock\CmsBlockDefinition
     */
    protected static function getCmsBlockDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsBlock\CmsBlockDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsPageTranslation\CmsPageTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsPageTranslation\CmsPageTranslationDefinition
     */
    protected static function getCmsPageTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsPageTranslation\CmsPageTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsSection\CmsSectionDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsSection\CmsSectionDefinition
     */
    protected static function getCmsSectionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsSection\CmsSectionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsSlotTranslation\CmsSlotTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsSlotTranslation\CmsSlotTranslationDefinition
     */
    protected static function getCmsSlotTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsSlotTranslation\CmsSlotTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsSlot\CmsSlotDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsSlot\CmsSlotDefinition
     */
    protected static function getCmsSlotDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsSlot\CmsSlotDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\CmsPageDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\CmsPageDefinition
     */
    protected static function getCmsPageDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Cms\\CmsPageDefinition'] = $instance = new \Shopware\Core\Content\Cms\CmsPageDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\DataAbstractionLayer\FieldSerializer\SlotConfigFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Content\Cms\DataAbstractionLayer\FieldSerializer\SlotConfigFieldSerializer
     */
    protected static function getSlotConfigFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Cms\\DataAbstractionLayer\\FieldSerializer\\SlotConfigFieldSerializer'] = new \Shopware\Core\Content\Cms\DataAbstractionLayer\FieldSerializer\SlotConfigFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\DataResolver\CmsSlotsDataResolver' shared service.
     *
     * @return \Shopware\Core\Content\Cms\DataResolver\CmsSlotsDataResolver
     */
    protected static function getCmsSlotsDataResolverService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Cms\\DataResolver\\CmsSlotsDataResolver'] = new \Shopware\Core\Content\Cms\DataResolver\CmsSlotsDataResolver(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\Category\\Cms\\CategoryNavigationCmsElementResolver'] ?? self::getCategoryNavigationCmsElementResolverService($container));
            yield 1 => ($container->privates['Shopware\\Core\\Content\\Media\\Cms\\ImageCmsElementResolver'] ?? self::getImageCmsElementResolverService($container));
            yield 2 => ($container->privates['Shopware\\Core\\Content\\Media\\Cms\\Type\\ImageSliderTypeDataResolver'] ?? self::getImageSliderTypeDataResolverService($container));
            yield 3 => ($container->privates['Shopware\\Core\\Content\\Media\\Cms\\Type\\ImageGalleryTypeDataResolver'] ?? self::getImageGalleryTypeDataResolverService($container));
            yield 4 => ($container->privates['Shopware\\Core\\Content\\Media\\Cms\\YoutubeVideoCmsElementResolver'] ??= new \Shopware\Core\Content\Media\Cms\YoutubeVideoCmsElementResolver());
            yield 5 => ($container->privates['Shopware\\Core\\Content\\Media\\Cms\\VimeoVideoCmsElementResolver'] ??= new \Shopware\Core\Content\Media\Cms\VimeoVideoCmsElementResolver());
            yield 6 => ($container->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductBoxCmsElementResolver'] ?? self::getProductBoxCmsElementResolverService($container));
            yield 7 => ($container->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductListingCmsElementResolver'] ?? self::getProductListingCmsElementResolverService($container));
            yield 8 => ($container->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductSliderCmsElementResolver'] ?? self::getProductSliderCmsElementResolverService($container));
            yield 9 => ($container->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductNameCmsElementResolver'] ??= new \Shopware\Core\Content\Product\Cms\ProductNameCmsElementResolver());
            yield 10 => ($container->privates['Shopware\\Core\\Content\\Product\\Cms\\ManufacturerLogoCmsElementResolver'] ??= new \Shopware\Core\Content\Product\Cms\ManufacturerLogoCmsElementResolver());
            yield 11 => ($container->privates['Shopware\\Core\\Content\\Product\\Cms\\CrossSellingCmsElementResolver'] ?? self::getCrossSellingCmsElementResolverService($container));
            yield 12 => ($container->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductDescriptionReviewsCmsElementResolver'] ?? self::getProductDescriptionReviewsCmsElementResolverService($container));
            yield 13 => ($container->privates['Shopware\\Core\\Content\\Product\\Cms\\BuyBoxCmsElementResolver'] ?? self::getBuyBoxCmsElementResolverService($container));
            yield 14 => ($container->privates['Shopware\\Core\\Content\\Cms\\DataResolver\\Element\\TextCmsElementResolver'] ?? self::getTextCmsElementResolverService($container));
            yield 15 => ($container->privates['Shopware\\Core\\Content\\Cms\\DataResolver\\Element\\HtmlCmsElementResolver'] ??= new \Shopware\Core\Content\Cms\DataResolver\Element\HtmlCmsElementResolver());
            yield 16 => ($container->privates['Shopware\\Core\\Content\\Cms\\DataResolver\\Element\\FormCmsElementResolver'] ?? self::getFormCmsElementResolverService($container));
        }, 17), ['product' => ($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container))], ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\Extensions\\ExtensionDispatcher'] ?? self::getExtensionDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\SalesChannel\CmsRoute' shared service.
     *
     * @return \Shopware\Core\Content\Cms\SalesChannel\CmsRoute
     */
    protected static function getCmsRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Cms\\SalesChannel\\CmsRoute'] = new \Shopware\Core\Content\Cms\SalesChannel\CmsRoute(($container->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? self::getSalesChannelCmsPageLoaderService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ContactForm\SalesChannel\ContactFormRoute' shared service.
     *
     * @return \Shopware\Core\Content\ContactForm\SalesChannel\ContactFormRoute
     */
    protected static function getContactFormRouteService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));
        $b = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));

        return $container->services['Shopware\\Core\\Content\\ContactForm\\SalesChannel\\ContactFormRoute'] = new \Shopware\Core\Content\ContactForm\SalesChannel\ContactFormRoute(new \Shopware\Core\Content\ContactForm\Validation\ContactFormValidationFactory($a, $b), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), $a, $b, ($container->services['cms_slot.repository'] ?? self::getCmsSlot_RepositoryService($container)), ($container->services['salutation.repository'] ?? self::getSalutation_RepositoryService($container)), ($container->services['category.repository'] ?? self::getCategory_RepositoryService($container)), ($container->services['landing_page.repository'] ?? self::getLandingPage_RepositoryService($container)), ($container->services['product.repository'] ?? self::getProduct_RepositoryService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Aggregate\FlowSequence\FlowSequenceDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Aggregate\FlowSequence\FlowSequenceDefinition
     */
    protected static function getFlowSequenceDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition'] = $instance = new \Shopware\Core\Content\Flow\Aggregate\FlowSequence\FlowSequenceDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Aggregate\FlowTemplate\FlowTemplateDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Aggregate\FlowTemplate\FlowTemplateDefinition
     */
    protected static function getFlowTemplateDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Flow\\Aggregate\\FlowTemplate\\FlowTemplateDefinition'] = $instance = new \Shopware\Core\Content\Flow\Aggregate\FlowTemplate\FlowTemplateDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Controller\TriggerFlowController' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Controller\TriggerFlowController
     */
    protected static function getTriggerFlowControllerService($container)
    {
        $container->services['Shopware\\Core\\Content\\Flow\\Controller\\TriggerFlowController'] = $instance = new \Shopware\Core\Content\Flow\Controller\TriggerFlowController(($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['app_flow_event.repository'] ?? self::getAppFlowEvent_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\DataAbstractionLayer\FieldSerializer\FlowTemplateConfigFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Content\Flow\DataAbstractionLayer\FieldSerializer\FlowTemplateConfigFieldSerializer
     */
    protected static function getFlowTemplateConfigFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Flow\\DataAbstractionLayer\\FieldSerializer\\FlowTemplateConfigFieldSerializer'] = new \Shopware\Core\Content\Flow\DataAbstractionLayer\FieldSerializer\FlowTemplateConfigFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Dispatching\CachedFlowLoader' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Dispatching\CachedFlowLoader
     */
    protected static function getCachedFlowLoaderService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\CachedFlowLoader'] = new \Shopware\Core\Content\Flow\Dispatching\CachedFlowLoader(new \Shopware\Core\Content\Flow\Dispatching\FlowLoader(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container))), ($container->privates['cache.object'] ?? self::getCache_ObjectService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Dispatching\FlowExecutor' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Dispatching\FlowExecutor
     */
    protected static function getFlowExecutorService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'])) {
            return $container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\App\\Flow\\Action\\AppFlowActionProvider'] ?? self::getAppFlowActionProviderService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'])) {
            return $container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'];
        }
        $c = ($container->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? self::getOrderConverterService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'])) {
            return $container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'];
        }
        $d = ($container->privates['Shopware\\Core\\Framework\\Extensions\\ExtensionDispatcher'] ?? self::getExtensionDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'])) {
            return $container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'];
        }

        return $container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'] = new \Shopware\Core\Content\Flow\Dispatching\FlowExecutor($a, $b, ($container->privates['Shopware\\Core\\Checkout\\Cart\\CachedRuleLoader'] ?? self::getCachedRuleLoaderService($container)), new \Shopware\Core\Content\Flow\Rule\FlowRuleScopeBuilder($c, ($container->privates['Shopware\\Core\\Checkout\\Cart\\Delivery\\DeliveryBuilder'] ??= new \Shopware\Core\Checkout\Cart\Delivery\DeliveryBuilder()), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\Product\\Cart\\ProductCartProcessor'] ?? self::getProductCartProcessorService($container));
            yield 1 => ($container->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\PromotionCollector'] ?? self::getPromotionCollectorService($container));
            yield 2 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\CustomCartProcessor'] ?? self::getCustomCartProcessorService($container));
            yield 3 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Delivery\\DeliveryProcessor'] ?? self::getDeliveryProcessorService($container));
        }, 4)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), $d, ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)), new RewindableGenerator(function () use ($container) {
            yield 'action.add.order.tag' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\AddOrderTagAction'] ?? self::getAddOrderTagActionService($container));
            yield 'action.add.customer.tag' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\AddCustomerTagAction'] ?? self::getAddCustomerTagActionService($container));
            yield 'action.remove.order.tag' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\RemoveOrderTagAction'] ?? self::getRemoveOrderTagActionService($container));
            yield 'action.remove.customer.tag' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\RemoveCustomerTagAction'] ?? self::getRemoveCustomerTagActionService($container));
            yield 'action.change.customer.group' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\ChangeCustomerGroupAction'] ?? self::getChangeCustomerGroupActionService($container));
            yield 'action.change.customer.status' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\ChangeCustomerStatusAction'] ?? self::getChangeCustomerStatusActionService($container));
            yield 'action.generate.document' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\GenerateDocumentAction'] ?? self::getGenerateDocumentActionService($container));
            yield 'action.grant.download.access' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\GrantDownloadAccessAction'] ?? self::getGrantDownloadAccessActionService($container));
            yield 'action.mail.send' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SendMailAction'] ?? self::getSendMailActionService($container));
            yield 'action.set.order.state' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SetOrderStateAction'] ?? self::getSetOrderStateActionService($container));
            yield 'action.set.customer.custom.field' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SetCustomerCustomFieldAction'] ?? self::getSetCustomerCustomFieldActionService($container));
            yield 'action.set.customer.group.custom.field' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SetCustomerGroupCustomFieldAction'] ?? self::getSetCustomerGroupCustomFieldActionService($container));
            yield 'action.add.customer.affiliate.and.campaign.code' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\AddCustomerAffiliateAndCampaignCodeAction'] ?? self::getAddCustomerAffiliateAndCampaignCodeActionService($container));
            yield 'action.add.order.affiliate.and.campaign.code' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\AddOrderAffiliateAndCampaignCodeAction'] ?? self::getAddOrderAffiliateAndCampaignCodeActionService($container));
            yield 'action.set.order.custom.field' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SetOrderCustomFieldAction'] ?? self::getSetOrderCustomFieldActionService($container));
            yield 'action.stop.flow' => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\StopFlowAction'] ??= new \Shopware\Core\Content\Flow\Dispatching\Action\StopFlowAction());
        }, 16));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Dispatching\FlowFactory' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Dispatching\FlowFactory
     */
    protected static function getFlowFactoryService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowFactory'] = new \Shopware\Core\Content\Flow\Dispatching\FlowFactory(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\CustomAppStorer'] ??= new \Shopware\Core\Content\Flow\Dispatching\Storer\CustomAppStorer());
            yield 1 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\OrderStorer'] ?? self::getOrderStorerService($container));
            yield 2 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ProductStorer'] ?? self::getProductStorerService($container));
            yield 3 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\A11yRenderedDocumentStorer'] ?? self::getA11yRenderedDocumentStorerService($container));
            yield 4 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\CustomerStorer'] ?? self::getCustomerStorerService($container));
            yield 5 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\MailStorer'] ??= new \Shopware\Core\Content\Flow\Dispatching\Storer\MailStorer());
            yield 6 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\UserStorer'] ?? self::getUserStorerService($container));
            yield 7 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\CustomerGroupStorer'] ?? self::getCustomerGroupStorerService($container));
            yield 8 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\CustomerRecoveryStorer'] ?? self::getCustomerRecoveryStorerService($container));
            yield 9 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\OrderTransactionStorer'] ?? self::getOrderTransactionStorerService($container));
            yield 10 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\NewsletterRecipientStorer'] ?? self::getNewsletterRecipientStorerService($container));
            yield 11 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ScalarValuesStorer'] ??= new \Shopware\Core\Content\Flow\Dispatching\Storer\ScalarValuesStorer());
            yield 12 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\MessageStorer'] ??= new \Shopware\Core\Content\Flow\Dispatching\Storer\MessageStorer());
            yield 13 => ($container->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\LanguageStorer'] ??= new \Shopware\Core\Content\Flow\Dispatching\Storer\LanguageStorer());
        }, 14));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\FlowDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Flow\FlowDefinition
     */
    protected static function getFlowDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Flow\\FlowDefinition'] = $instance = new \Shopware\Core\Content\Flow\FlowDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\Aggregate\ImportExportFile\ImportExportFileDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\Aggregate\ImportExportFile\ImportExportFileDefinition
     */
    protected static function getImportExportFileDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition'] = $instance = new \Shopware\Core\Content\ImportExport\Aggregate\ImportExportFile\ImportExportFileDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\Aggregate\ImportExportLog\ImportExportLogDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\Aggregate\ImportExportLog\ImportExportLogDefinition
     */
    protected static function getImportExportLogDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition'] = $instance = new \Shopware\Core\Content\ImportExport\Aggregate\ImportExportLog\ImportExportLogDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\Controller\ImportExportActionController' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\Controller\ImportExportActionController
     */
    protected static function getImportExportActionControllerService($container)
    {
        $a = ($container->services['import_export_profile.repository'] ?? self::getImportExportProfile_RepositoryService($container));
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container));

        $container->services['Shopware\\Core\\Content\\ImportExport\\Controller\\ImportExportActionController'] = $instance = new \Shopware\Core\Content\ImportExport\Controller\ImportExportActionController(new \Shopware\Core\Content\ImportExport\Service\SupportedFeaturesService($container->parameters['import_export.supported_entities'], $container->parameters['import_export.supported_file_types']), ($container->privates['Shopware\\Core\\Content\\ImportExport\\Service\\ImportExportService'] ?? self::getImportExportServiceService($container)), new \Shopware\Core\Content\ImportExport\Service\DownloadService(($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), ($container->services['import_export_file.repository'] ?? self::getImportExportFile_RepositoryService($container))), $a, ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'] ?? self::getImportExportFactoryService($container)), $b, ($container->services['messenger.default_bus'] ?? self::getMessenger_DefaultBusService($container)), new \Shopware\Core\Content\ImportExport\Service\MappingService(($container->privates['Shopware\\Core\\Content\\ImportExport\\Service\\FileService'] ?? self::getFileServiceService($container)), $a, $b));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\ImportExportFactory' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\ImportExportFactory
     */
    protected static function getImportExportFactoryService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Content\\ImportExport\\Service\\ImportExportService'] ?? self::getImportExportServiceService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'])) {
            return $container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'])) {
            return $container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'];
        }
        $c = ($container->privates['Shopware\\Core\\Content\\ImportExport\\Service\\FileService'] ?? self::getFileServiceService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'])) {
            return $container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'];
        }

        return $container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'] = new \Shopware\Core\Content\ImportExport\ImportExportFactory($a, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), $b, ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), $c, new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\ImportExport\\Processing\\Reader\\CsvReaderFactory'] ??= new \Shopware\Core\Content\ImportExport\Processing\Reader\CsvReaderFactory());
        }, 1), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\ImportExport\\Processing\\Writer\\CsvFileWriterFactory'] ?? self::getCsvFileWriterFactoryService($container));
        }, 1), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\ImportExport\\Processing\\Pipe\\PipeFactory'] ?? self::getPipeFactoryService($container));
        }, 1));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\ImportExportProfileDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\ImportExportProfileDefinition
     */
    protected static function getImportExportProfileDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition'] = $instance = new \Shopware\Core\Content\ImportExport\ImportExportProfileDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\ImportExportProfileTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\ImportExportProfileTranslationDefinition
     */
    protected static function getImportExportProfileTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition'] = $instance = new \Shopware\Core\Content\ImportExport\ImportExportProfileTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\Message\ImportExportHandler' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\Message\ImportExportHandler
     */
    protected static function getImportExportHandlerService($container)
    {
        $a = ($container->services['messenger.default_bus'] ?? self::getMessenger_DefaultBusService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'])) {
            return $container->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'];
        }
        $b = ($container->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'] ?? self::getImportExportFactoryService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'])) {
            return $container->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'];
        }
        $c = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'])) {
            return $container->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'];
        }

        return $container->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'] = new \Shopware\Core\Content\ImportExport\Message\ImportExportHandler($a, $b, $c);
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\Aggregate\LandingPageSalesChannel\LandingPageSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\Aggregate\LandingPageSalesChannel\LandingPageSalesChannelDefinition
     */
    protected static function getLandingPageSalesChannelDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\Aggregate\LandingPageSalesChannel\LandingPageSalesChannelDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\Aggregate\LandingPageTag\LandingPageTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\Aggregate\LandingPageTag\LandingPageTagDefinition
     */
    protected static function getLandingPageTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\Aggregate\LandingPageTag\LandingPageTagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\Aggregate\LandingPageTranslation\LandingPageTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\Aggregate\LandingPageTranslation\LandingPageTranslationDefinition
     */
    protected static function getLandingPageTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\Aggregate\LandingPageTranslation\LandingPageTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\LandingPageDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\LandingPageDefinition
     */
    protected static function getLandingPageDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\LandingPage\\LandingPageDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\LandingPageDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\SalesChannel\LandingPageRoute' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\SalesChannel\LandingPageRoute
     */
    protected static function getLandingPageRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\LandingPage\\SalesChannel\\LandingPageRoute'] = new \Shopware\Core\Content\LandingPage\SalesChannel\LandingPageRoute(($container->services['sales_channel.landing_page.repository'] ?? self::getSalesChannel_LandingPage_RepositoryService($container)), ($container->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? self::getSalesChannelCmsPageLoaderService($container)), ($container->services['Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition'] ?? self::getSalesChannelLandingPageDefinitionService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\SalesChannel\SalesChannelLandingPageDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\SalesChannel\SalesChannelLandingPageDefinition
     */
    protected static function getSalesChannelLandingPageDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\SalesChannel\SalesChannelLandingPageDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooterTranslation\MailHeaderFooterTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooterTranslation\MailHeaderFooterTranslationDefinition
     */
    protected static function getMailHeaderFooterTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooterTranslation\MailHeaderFooterTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooter\MailHeaderFooterDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooter\MailHeaderFooterDefinition
     */
    protected static function getMailHeaderFooterDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooter\MailHeaderFooterDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateMedia\MailTemplateMediaDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateMedia\MailTemplateMediaDefinition
     */
    protected static function getMailTemplateMediaDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateMedia\MailTemplateMediaDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTranslation\MailTemplateTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTranslation\MailTemplateTranslationDefinition
     */
    protected static function getMailTemplateTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTranslation\MailTemplateTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTypeTranslation\MailTemplateTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTypeTranslation\MailTemplateTypeTranslationDefinition
     */
    protected static function getMailTemplateTypeTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTypeTranslation\MailTemplateTypeTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateType\MailTemplateTypeDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateType\MailTemplateTypeDefinition
     */
    protected static function getMailTemplateTypeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateType\MailTemplateTypeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Api\MailActionController' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Api\MailActionController
     */
    protected static function getMailActionControllerService($container)
    {
        $container->services['Shopware\\Core\\Content\\MailTemplate\\Api\\MailActionController'] = $instance = new \Shopware\Core\Content\MailTemplate\Api\MailActionController(($container->privates['Shopware\\Core\\Content\\Mail\\Service\\MailService'] ?? self::getMailServiceService($container)), ($container->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\StringTemplateRenderer'] ?? self::getStringTemplateRendererService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\MailTemplateDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\MailTemplateDefinition
     */
    protected static function getMailTemplateDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\MailTemplateDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Mail\Service\MailAttachmentsBuilder' shared service.
     *
     * @return \Shopware\Core\Content\Mail\Service\MailAttachmentsBuilder
     */
    protected static function getMailAttachmentsBuilderService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Content\\Media\\MediaService'] ?? self::getMediaServiceService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Mail\\Service\\MailAttachmentsBuilder'])) {
            return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailAttachmentsBuilder'];
        }
        $b = ($container->services['media.repository'] ?? self::getMedia_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Mail\\Service\\MailAttachmentsBuilder'])) {
            return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailAttachmentsBuilder'];
        }
        $c = ($container->privates['Shopware\\Core\\Checkout\\Document\\Service\\DocumentGenerator'] ?? self::getDocumentGeneratorService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Mail\\Service\\MailAttachmentsBuilder'])) {
            return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailAttachmentsBuilder'];
        }

        return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailAttachmentsBuilder'] = new \Shopware\Core\Content\Mail\Service\MailAttachmentsBuilder($a, $b, $c, ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Mail\Service\MailFactory' shared service.
     *
     * @return \Shopware\Core\Content\Mail\Service\MailFactory
     */
    protected static function getMailFactoryService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Mail\\Service\\MailFactory'])) {
            return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailFactory'];
        }

        return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailFactory'] = new \Shopware\Core\Content\Mail\Service\MailFactory($a);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Mail\Service\MailSender' shared service.
     *
     * @return \Shopware\Core\Content\Mail\Service\MailSender
     */
    protected static function getMailSenderService($container)
    {
        $a = ($container->privates['mailer.transports'] ?? self::getMailer_TransportsService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'])) {
            return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'])) {
            return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'];
        }
        $c = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'])) {
            return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'];
        }

        return $container->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'] = new \Shopware\Core\Content\Mail\Service\MailSender(new \Symfony\Component\Mailer\Mailer($a, NULL, $b), ($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), $c, 0, NULL);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaDefaultFolder\MediaDefaultFolderDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaDefaultFolder\MediaDefaultFolderDefinition
     */
    protected static function getMediaDefaultFolderDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaDefaultFolder\MediaDefaultFolderDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaFolderConfigurationMediaThumbnailSize\MediaFolderConfigurationMediaThumbnailSizeDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaFolderConfigurationMediaThumbnailSize\MediaFolderConfigurationMediaThumbnailSizeDefinition
     */
    protected static function getMediaFolderConfigurationMediaThumbnailSizeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaFolderConfigurationMediaThumbnailSize\MediaFolderConfigurationMediaThumbnailSizeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaFolderConfiguration\MediaFolderConfigurationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaFolderConfiguration\MediaFolderConfigurationDefinition
     */
    protected static function getMediaFolderConfigurationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaFolderConfiguration\MediaFolderConfigurationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaFolder\MediaFolderDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaFolder\MediaFolderDefinition
     */
    protected static function getMediaFolderDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaFolder\MediaFolderDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaTag\MediaTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaTag\MediaTagDefinition
     */
    protected static function getMediaTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaTag\MediaTagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaThumbnailSize\MediaThumbnailSizeDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaThumbnailSize\MediaThumbnailSizeDefinition
     */
    protected static function getMediaThumbnailSizeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaThumbnailSize\MediaThumbnailSizeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaThumbnail\MediaThumbnailDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaThumbnail\MediaThumbnailDefinition
     */
    protected static function getMediaThumbnailDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaThumbnail\MediaThumbnailDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaTranslation\MediaTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaTranslation\MediaTranslationDefinition
     */
    protected static function getMediaTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaTranslation\MediaTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Api\MediaFolderController' shared service.
     *
     * @return \Shopware\Core\Content\Media\Api\MediaFolderController
     */
    protected static function getMediaFolderControllerService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Api\\MediaFolderController'] = $instance = new \Shopware\Core\Content\Media\Api\MediaFolderController(new \Shopware\Core\Content\Media\MediaFolderService(($container->services['media.repository'] ?? self::getMedia_RepositoryService($container)), ($container->services['media_folder.repository'] ?? self::getMediaFolder_RepositoryService($container)), ($container->services['media_folder_configuration.repository'] ?? self::getMediaFolderConfiguration_RepositoryService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Api\MediaUploadController' shared service.
     *
     * @return \Shopware\Core\Content\Media\Api\MediaUploadController
     */
    protected static function getMediaUploadControllerService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\Api\\MediaUploadController'] = $instance = new \Shopware\Core\Content\Media\Api\MediaUploadController(($container->privates['Shopware\\Core\\Content\\Media\\MediaService'] ?? self::getMediaServiceService($container)), ($container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'] ?? self::getFileSaverService($container)), ($container->privates['Shopware\\Core\\Content\\Media\\File\\FileNameProvider'] ?? self::getFileNameProviderService($container)), ($container->services['Shopware\\Core\\Content\\Media\\MediaDefinition'] ?? self::getMediaDefinitionService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\File\FileSaver' shared service.
     *
     * @return \Shopware\Core\Content\Media\File\FileSaver
     */
    protected static function getFileSaverService($container)
    {
        $a = ($container->services['media.repository'] ?? self::getMedia_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'])) {
            return $container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'];
        }
        $b = ($container->privates['Shopware\\Core\\Content\\Media\\Thumbnail\\ThumbnailService'] ?? self::getThumbnailServiceService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'])) {
            return $container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'];
        }
        $c = ($container->services['messenger.default_bus'] ?? self::getMessenger_DefaultBusService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'])) {
            return $container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'])) {
            return $container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'];
        }
        $e = ($container->privates['Shopware\\Core\\Content\\Media\\Core\\Application\\MediaLocationBuilder'] ?? self::getMediaLocationBuilderService($container));

        if (isset($container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'])) {
            return $container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'];
        }

        return $container->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'] = new \Shopware\Core\Content\Media\File\FileSaver($a, ($container->services['shopware.filesystem.public'] ?? self::getShopware_Filesystem_PublicService($container)), ($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), $b, new \Shopware\Core\Content\Media\Metadata\MetadataLoader(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\Media\\Metadata\\MetadataLoader\\ImageMetadataLoader'] ??= new \Shopware\Core\Content\Media\Metadata\MetadataLoader\ImageMetadataLoader());
        }, 1)), ($container->privates['Shopware\\Core\\Content\\Media\\TypeDetector\\TypeDetector'] ?? self::getTypeDetectorService($container)), $c, $d, $e, ($container->privates['Shopware\\Core\\Content\\Media\\Core\\Application\\AbstractMediaPathStrategy'] ?? self::getAbstractMediaPathStrategyService($container)), $container->parameters['shopware.filesystem.allowed_extensions'], $container->parameters['shopware.filesystem.private_allowed_extensions'], false);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\MediaDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\MediaDefinition
     */
    protected static function getMediaDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Media\\MediaDefinition'] = $instance = new \Shopware\Core\Content\Media\MediaDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
        $instance->addExtension(($container->privates['Shopware\\Storefront\\Theme\\Extension\\MediaExtension'] ??= new \Shopware\Storefront\Theme\Extension\MediaExtension()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\MediaHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Media\MediaHydrator
     */
    protected static function getMediaHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Media\\MediaHydrator'] = new \Shopware\Core\Content\Media\MediaHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\MediaUrlPlaceholderHandlerInterface' shared service.
     *
     * @return \Shopware\Core\Content\Media\MediaUrlPlaceholderHandler
     */
    protected static function getMediaUrlPlaceholderHandlerInterfaceService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Media\\MediaUrlPlaceholderHandlerInterface'] = new \Shopware\Core\Content\Media\MediaUrlPlaceholderHandler(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['Shopware\\Core\\Content\\Media\\Core\\Application\\AbstractMediaUrlGenerator'] ?? self::getAbstractMediaUrlGeneratorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\SalesChannel\MediaRoute' shared service.
     *
     * @return \Shopware\Core\Content\Media\SalesChannel\MediaRoute
     */
    protected static function getMediaRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Media\\SalesChannel\\MediaRoute'] = new \Shopware\Core\Content\Media\SalesChannel\MediaRoute(($container->services['media.repository'] ?? self::getMedia_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipientTag\NewsletterRecipientTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipientTag\NewsletterRecipientTagDefinition
     */
    protected static function getNewsletterRecipientTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition'] = $instance = new \Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipientTag\NewsletterRecipientTagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipient\NewsletterRecipientDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipient\NewsletterRecipientDefinition
     */
    protected static function getNewsletterRecipientDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipient\\NewsletterRecipientDefinition'] = $instance = new \Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipient\NewsletterRecipientDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\SalesChannel\NewsletterConfirmRoute' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterConfirmRoute
     */
    protected static function getNewsletterConfirmRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterConfirmRoute'] = new \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterConfirmRoute(($container->services['newsletter_recipient.repository'] ?? self::getNewsletterRecipient_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\SalesChannel\NewsletterSubscribeRoute' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterSubscribeRoute
     */
    protected static function getNewsletterSubscribeRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterSubscribeRoute'] = new \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterSubscribeRoute(($container->services['newsletter_recipient.repository'] ?? self::getNewsletterRecipient_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['Shopware\\Core\\System\\SalesChannel\\StoreApiCustomFieldMapper'] ?? self::getStoreApiCustomFieldMapperService($container)), ($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\SalesChannel\NewsletterUnsubscribeRoute' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterUnsubscribeRoute
     */
    protected static function getNewsletterUnsubscribeRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterUnsubscribeRoute'] = new \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterUnsubscribeRoute(($container->services['newsletter_recipient.repository'] ?? self::getNewsletterRecipient_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\SalesChannel\SalesChannelNewsletterRecipientDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\SalesChannel\SalesChannelNewsletterRecipientDefinition
     */
    protected static function getSalesChannelNewsletterRecipientDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition'] = $instance = new \Shopware\Core\Content\Newsletter\SalesChannel\SalesChannelNewsletterRecipientDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\Api\ProductExportController' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\Api\ProductExportController
     */
    protected static function getProductExportControllerService($container)
    {
        $container->services['Shopware\\Core\\Content\\ProductExport\\Api\\ProductExportController'] = $instance = new \Shopware\Core\Content\ProductExport\Api\ProductExportController(($container->services['sales_channel_domain.repository'] ?? self::getSalesChannelDomain_RepositoryService($container)), ($container->services['sales_channel.repository'] ?? self::getSalesChannel_RepositoryService($container)), ($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'] ?? self::getProductExportGeneratorService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\ProductExportDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\ProductExportDefinition
     */
    protected static function getProductExportDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition'] = $instance = new \Shopware\Core\Content\ProductExport\ProductExportDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\ProductExportHydrator' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\ProductExportHydrator
     */
    protected static function getProductExportHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\ProductExport\\ProductExportHydrator'] = new \Shopware\Core\Content\ProductExport\ProductExportHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\SalesChannel\ExportController' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\SalesChannel\ExportController
     */
    protected static function getExportControllerService($container)
    {
        return $container->services['Shopware\\Core\\Content\\ProductExport\\SalesChannel\\ExportController'] = new \Shopware\Core\Content\ProductExport\SalesChannel\ExportController(($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExporter'] ?? self::getProductExporterService($container)), ($container->privates['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportFileHandler'] ?? self::getProductExportFileHandlerService($container)), ($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['product_export.repository'] ?? self::getProductExport_RepositoryService($container)), ($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'] ?? self::getSalesChannelContextFactoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\Service\ProductExportGenerator' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\Service\ProductExportGenerator
     */
    protected static function getProductExportGeneratorService($container)
    {
        $a = ($container->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'] ?? self::getProductStreamBuilderService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $b = ($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $c = ($container->privates['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportRenderer'] ?? self::getProductExportRendererService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $e = ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? self::getSalesChannelContextServiceService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $f = ($container->services['translator'] ?? self::getTranslatorService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $g = ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? self::getSalesChannelContextPersisterService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $h = ($container->services['twig'] ?? self::getTwigService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }

        return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'] = new \Shopware\Core\Content\ProductExport\Service\ProductExportGenerator($a, $b, $c, $d, new \Shopware\Core\Content\ProductExport\Service\ProductExportValidator(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\ProductExport\\Validator\\XmlValidator'] ??= new \Shopware\Core\Content\ProductExport\Validator\XmlValidator());
        }, 1)), $e, $f, $g, ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), 100, ($container->services['Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface'] ?? self::getSeoUrlPlaceholderHandlerInterfaceService($container)), $h, ($container->services['Shopware\\Core\\Content\\Product\\ProductDefinition'] ?? self::getProductDefinitionService($container)), ($container->privates['Shopware\\Core\\System\\Locale\\LanguageLocaleCodeProvider'] ?? self::getLanguageLocaleCodeProviderService($container)), ($container->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\TwigVariableParserFactory'] ??= new \Shopware\Core\Framework\Adapter\Twig\TwigVariableParserFactory()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\Service\ProductExporter' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\Service\ProductExporter
     */
    protected static function getProductExporterService($container)
    {
        return $container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExporter'] = new \Shopware\Core\Content\ProductExport\Service\ProductExporter(($container->services['product_export.repository'] ?? self::getProductExport_RepositoryService($container)), ($container->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'] ?? self::getProductExportGeneratorService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportFileHandler'] ?? self::getProductExportFileHandlerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterDefinition
     */
    protected static function getProductStreamFilterDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition'] = $instance = new \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterHydrator' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterHydrator
     */
    protected static function getProductStreamFilterHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterHydrator'] = new \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\Aggregate\ProductStreamTranslation\ProductStreamTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamTranslation\ProductStreamTranslationDefinition
     */
    protected static function getProductStreamTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition'] = $instance = new \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamTranslation\ProductStreamTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\ProductStreamDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\ProductStreamDefinition
     */
    protected static function getProductStreamDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition'] = $instance = new \Shopware\Core\Content\ProductStream\ProductStreamDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\ProductStreamHydrator' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\ProductStreamHydrator
     */
    protected static function getProductStreamHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\ProductStream\\ProductStreamHydrator'] = new \Shopware\Core\Content\ProductStream\ProductStreamHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\Service\ProductStreamBuilder' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\Service\ProductStreamBuilder
     */
    protected static function getProductStreamBuilderService($container)
    {
        $a = ($container->services['product_stream.repository'] ?? self::getProductStream_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'])) {
            return $container->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'];
        }

        return $container->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'] = new \Shopware\Core\Content\ProductStream\Service\ProductStreamBuilder($a, ($container->services['Shopware\\Core\\Content\\Product\\ProductDefinition'] ?? self::getProductDefinitionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCategoryTree\ProductCategoryTreeDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCategoryTree\ProductCategoryTreeDefinition
     */
    protected static function getProductCategoryTreeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCategoryTree\ProductCategoryTreeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCategory\ProductCategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCategory\ProductCategoryDefinition
     */
    protected static function getProductCategoryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCategory\ProductCategoryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingDefinition
     */
    protected static function getProductConfiguratorSettingDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingHydrator
     */
    protected static function getProductConfiguratorSettingHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsDefinition
     */
    protected static function getProductCrossSellingAssignedProductsDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsHydrator
     */
    protected static function getProductCrossSellingAssignedProductsHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSellingTranslation\ProductCrossSellingTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingTranslation\ProductCrossSellingTranslationDefinition
     */
    protected static function getProductCrossSellingTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingTranslation\ProductCrossSellingTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingDefinition
     */
    protected static function getProductCrossSellingDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingHydrator
     */
    protected static function getProductCrossSellingHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCustomFieldSet\ProductCustomFieldSetDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCustomFieldSet\ProductCustomFieldSetDefinition
     */
    protected static function getProductCustomFieldSetDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCustomFieldSet\ProductCustomFieldSetDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductDownload\ProductDownloadDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductDownload\ProductDownloadDefinition
     */
    protected static function getProductDownloadDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductDownload\\ProductDownloadDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductDownload\ProductDownloadDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductFeatureSetTranslation\ProductFeatureSetTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductFeatureSetTranslation\ProductFeatureSetTranslationDefinition
     */
    protected static function getProductFeatureSetTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductFeatureSetTranslation\ProductFeatureSetTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetDefinition
     */
    protected static function getProductFeatureSetDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetHydrator
     */
    protected static function getProductFeatureSetHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryDefinition
     */
    protected static function getProductKeywordDictionaryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryHydrator
     */
    protected static function getProductKeywordDictionaryHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductManufacturerTranslation\ProductManufacturerTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductManufacturerTranslation\ProductManufacturerTranslationDefinition
     */
    protected static function getProductManufacturerTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductManufacturerTranslation\ProductManufacturerTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerDefinition
     */
    protected static function getProductManufacturerDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerHydrator
     */
    protected static function getProductManufacturerHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaDefinition
     */
    protected static function getProductMediaDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaHydrator
     */
    protected static function getProductMediaHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductOption\ProductOptionDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductOption\ProductOptionDefinition
     */
    protected static function getProductOptionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductOption\ProductOptionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceDefinition
     */
    protected static function getProductPriceDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceHydrator
     */
    protected static function getProductPriceHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductProperty\ProductPropertyDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductProperty\ProductPropertyDefinition
     */
    protected static function getProductPropertyDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductProperty\ProductPropertyDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewDefinition
     */
    protected static function getProductReviewDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewHydrator
     */
    protected static function getProductReviewHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldDefinition
     */
    protected static function getProductSearchConfigFieldDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldHydrator
     */
    protected static function getProductSearchConfigFieldHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigDefinition
     */
    protected static function getProductSearchConfigDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigHydrator
     */
    protected static function getProductSearchConfigHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordDefinition
     */
    protected static function getProductSearchKeywordDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordHydrator
     */
    protected static function getProductSearchKeywordHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductStreamMapping\ProductStreamMappingDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductStreamMapping\ProductStreamMappingDefinition
     */
    protected static function getProductStreamMappingDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductStreamMapping\ProductStreamMappingDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductTag\ProductTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductTag\ProductTagDefinition
     */
    protected static function getProductTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductTag\ProductTagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductTranslation\ProductTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductTranslation\ProductTranslationDefinition
     */
    protected static function getProductTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductTranslation\ProductTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityDefinition
     */
    protected static function getProductVisibilityDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityHydrator
     */
    protected static function getProductVisibilityHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Api\ProductActionController' shared service.
     *
     * @return \Shopware\Core\Content\Product\Api\ProductActionController
     */
    protected static function getProductActionControllerService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\Api\\ProductActionController'] = $instance = new \Shopware\Core\Content\Product\Api\ProductActionController(new \Shopware\Core\Content\Product\Util\VariantCombinationLoader(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\DataAbstractionLayer\CheapestPrice\CheapestPriceAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Content\Product\DataAbstractionLayer\CheapestPrice\CheapestPriceAccessorBuilder
     */
    protected static function getCheapestPriceAccessorBuilderService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\CheapestPrice\\CheapestPriceAccessorBuilder'] = new \Shopware\Core\Content\Product\DataAbstractionLayer\CheapestPrice\CheapestPriceAccessorBuilder(100, ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\ProductDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\ProductDefinition
     */
    protected static function getProductDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\ProductDefinition'] = $instance = new \Shopware\Core\Content\Product\ProductDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\ProductHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\ProductHydrator
     */
    protected static function getProductHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\ProductHydrator'] = new \Shopware\Core\Content\Product\ProductHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\CrossSelling\ProductCrossSellingRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\CrossSelling\ProductCrossSellingRoute
     */
    protected static function getProductCrossSellingRouteService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\ProductCrossSellingRoute'] = new \Shopware\Core\Content\Product\SalesChannel\CrossSelling\ProductCrossSellingRoute(($container->services['product_cross_selling.repository'] ?? self::getProductCrossSelling_RepositoryService($container)), $a, ($container->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'] ?? self::getProductStreamBuilderService($container)), ($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingLoader'] ?? self::getProductListingLoaderService($container)), ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] ??= new \Shopware\Core\Content\Product\SalesChannel\ProductCloseoutFilterFactory()), $a);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Detail\ProductDetailRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Detail\ProductDetailRoute
     */
    protected static function getProductDetailRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\ProductDetailRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Detail\ProductDetailRoute(($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['Shopware\\Storefront\\Page\\Product\\Configurator\\ProductPageConfiguratorLoader'] ?? self::getProductPageConfiguratorLoaderService($container)), ($container->privates['Shopware\\Core\\Content\\Category\\Service\\CategoryBreadcrumbBuilder'] ?? self::getCategoryBreadcrumbBuilderService($container)), ($container->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? self::getSalesChannelCmsPageLoaderService($container)), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition'] ?? self::getSalesChannelProductDefinitionService($container)), ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] ??= new \Shopware\Core\Content\Product\SalesChannel\ProductCloseoutFilterFactory()), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\FindVariant\FindProductVariantRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\FindVariant\FindProductVariantRoute
     */
    protected static function getFindProductVariantRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\FindVariant\\FindProductVariantRoute'] = new \Shopware\Core\Content\Product\SalesChannel\FindVariant\FindProductVariantRoute(($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Listing\ResolveCriteriaProductListingRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Listing\ResolveCriteriaProductListingRoute
     */
    protected static function getResolveCriteriaProductListingRouteService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Listing\ResolveCriteriaProductListingRoute(new \Shopware\Core\Content\Product\SalesChannel\Listing\ProductListingRoute(($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingLoader'] ?? self::getProductListingLoaderService($container)), ($container->services['category.repository'] ?? self::getCategory_RepositoryService($container)), ($container->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'] ?? self::getProductStreamBuilderService($container)), $a, ($container->privates['Shopware\\Core\\Framework\\Extensions\\ExtensionDispatcher'] ?? self::getExtensionDispatcherService($container))), $a, ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\Processor\\CompositeListingProcessor'] ?? self::getCompositeListingProcessorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\ProductListRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\ProductListRoute
     */
    protected static function getProductListRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductListRoute'] = new \Shopware\Core\Content\Product\SalesChannel\ProductListRoute(($container->services['sales_channel.product.repository'] ?? self::getSalesChannel_Product_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewRoute
     */
    protected static function getProductReviewRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewRoute(($container->services['product_review.repository'] ?? self::getProductReview_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewSaveRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewSaveRoute
     */
    protected static function getProductReviewSaveRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewSaveRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewSaveRoute(($container->services['product_review.repository'] ?? self::getProductReview_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\SalesChannelProductDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\SalesChannelProductDefinition
     */
    protected static function getSalesChannelProductDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition'] = $instance = new \Shopware\Core\Content\Product\SalesChannel\SalesChannelProductDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Search\ResolvedCriteriaProductSearchRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Search\ResolvedCriteriaProductSearchRoute
     */
    protected static function getResolvedCriteriaProductSearchRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Search\ResolvedCriteriaProductSearchRoute(new \Shopware\Core\Content\Product\SalesChannel\Search\ProductSearchRoute(($container->privates['Shopware\\Elasticsearch\\Product\\ProductSearchBuilder'] ?? self::getProductSearchBuilderService($container)), ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingLoader'] ?? self::getProductListingLoaderService($container))), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? self::getRequestCriteriaBuilderService($container)), ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\Processor\\CompositeListingProcessor'] ?? self::getCompositeListingProcessorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingDefinition
     */
    protected static function getProductSortingDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition'] = $instance = new \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingHydrator
     */
    protected static function getProductSortingHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingHydrator'] = new \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingTranslationDefinition
     */
    protected static function getProductSortingTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Suggest\ResolvedCriteriaProductSuggestRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Suggest\ResolvedCriteriaProductSuggestRoute
     */
    protected static function getResolvedCriteriaProductSuggestRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\ResolvedCriteriaProductSuggestRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Suggest\ResolvedCriteriaProductSuggestRoute(($container->privates['Shopware\\Elasticsearch\\Product\\ProductSearchBuilder'] ?? self::getProductSearchBuilderService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), new \Shopware\Core\Content\Product\SalesChannel\Suggest\ProductSuggestRoute(($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingLoader'] ?? self::getProductListingLoaderService($container))), ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\Processor\\CompositeListingProcessor'] ?? self::getCompositeListingProcessorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\Aggregate\PropertyGroupOptionTranslation\PropertyGroupOptionTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Property\Aggregate\PropertyGroupOptionTranslation\PropertyGroupOptionTranslationDefinition
     */
    protected static function getPropertyGroupOptionTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition'] = $instance = new \Shopware\Core\Content\Property\Aggregate\PropertyGroupOptionTranslation\PropertyGroupOptionTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionDefinition
     */
    protected static function getPropertyGroupOptionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition'] = $instance = new \Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionHydrator
     */
    protected static function getPropertyGroupOptionHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionHydrator'] = new \Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\Aggregate\PropertyGroupTranslation\PropertyGroupTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Property\Aggregate\PropertyGroupTranslation\PropertyGroupTranslationDefinition
     */
    protected static function getPropertyGroupTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition'] = $instance = new \Shopware\Core\Content\Property\Aggregate\PropertyGroupTranslation\PropertyGroupTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\PropertyGroupDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Property\PropertyGroupDefinition
     */
    protected static function getPropertyGroupDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Property\\PropertyGroupDefinition'] = $instance = new \Shopware\Core\Content\Property\PropertyGroupDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\PropertyGroupHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Property\PropertyGroupHydrator
     */
    protected static function getPropertyGroupHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Property\\PropertyGroupHydrator'] = new \Shopware\Core\Content\Property\PropertyGroupHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Rule\Aggregate\RuleCondition\RuleConditionDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Rule\Aggregate\RuleCondition\RuleConditionDefinition
     */
    protected static function getRuleConditionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition'] = $instance = new \Shopware\Core\Content\Rule\Aggregate\RuleCondition\RuleConditionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Rule\Aggregate\RuleTag\RuleTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Rule\Aggregate\RuleTag\RuleTagDefinition
     */
    protected static function getRuleTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition'] = $instance = new \Shopware\Core\Content\Rule\Aggregate\RuleTag\RuleTagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Rule\RuleDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Rule\RuleDefinition
     */
    protected static function getRuleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Rule\\RuleDefinition'] = $instance = new \Shopware\Core\Content\Rule\RuleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\Api\SeoActionController' shared service.
     *
     * @return \Shopware\Core\Content\Seo\Api\SeoActionController
     */
    protected static function getSeoActionControllerService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container));

        $container->services['Shopware\\Core\\Content\\Seo\\Api\\SeoActionController'] = $instance = new \Shopware\Core\Content\Seo\Api\SeoActionController(($container->privates['Shopware\\Core\\Content\\Seo\\SeoUrlGenerator'] ?? self::getSeoUrlGeneratorService($container)), ($container->privates['Shopware\\Core\\Content\\Seo\\SeoUrlPersister'] ?? self::getSeoUrlPersisterService($container)), $a, ($container->privates['Shopware\\Core\\Content\\Seo\\SeoUrlRoute\\SeoUrlRouteRegistry'] ?? self::getSeoUrlRouteRegistryService($container)), new \Shopware\Core\Content\Seo\Validation\SeoUrlValidationFactory(), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->services['sales_channel.repository'] ?? self::getSalesChannel_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? self::getRequestCriteriaBuilderService($container)), $a);

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\EmptyPathInfoResolver' shared service.
     *
     * @return \Shopware\Core\Content\Seo\EmptyPathInfoResolver
     */
    protected static function getEmptyPathInfoResolverService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Seo\\EmptyPathInfoResolver'] = new \Shopware\Core\Content\Seo\EmptyPathInfoResolver(new \Shopware\Core\Content\Seo\SeoResolver(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container))));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\MainCategory\MainCategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\MainCategory\MainCategoryDefinition
     */
    protected static function getMainCategoryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Seo\\MainCategory\\MainCategoryDefinition'] = $instance = new \Shopware\Core\Content\Seo\MainCategory\MainCategoryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\MainCategory\SalesChannel\SalesChannelMainCategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\MainCategory\SalesChannel\SalesChannelMainCategoryDefinition
     */
    protected static function getSalesChannelMainCategoryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition'] = $instance = new \Shopware\Core\Content\Seo\MainCategory\SalesChannel\SalesChannelMainCategoryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SalesChannel\SeoUrlRoute' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SalesChannel\SeoUrlRoute
     */
    protected static function getSeoUrlRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Seo\\SalesChannel\\SeoUrlRoute'] = new \Shopware\Core\Content\Seo\SalesChannel\SeoUrlRoute(($container->services['sales_channel.seo_url.repository'] ?? self::getSalesChannel_SeoUrl_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SeoUrlPlaceholderHandlerInterface' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SeoUrlPlaceholderHandler
     */
    protected static function getSeoUrlPlaceholderHandlerInterfaceService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface'] = new \Shopware\Core\Content\Seo\SeoUrlPlaceholderHandler(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['router.default'] ?? self::getRouter_DefaultService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SeoUrlTemplate\SeoUrlTemplateDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SeoUrlTemplate\SeoUrlTemplateDefinition
     */
    protected static function getSeoUrlTemplateDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition'] = $instance = new \Shopware\Core\Content\Seo\SeoUrlTemplate\SeoUrlTemplateDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SeoUrl\SalesChannel\SalesChannelSeoUrlDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SeoUrl\SalesChannel\SalesChannelSeoUrlDefinition
     */
    protected static function getSalesChannelSeoUrlDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition'] = $instance = new \Shopware\Core\Content\Seo\SeoUrl\SalesChannel\SalesChannelSeoUrlDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SeoUrl\SeoUrlDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SeoUrl\SeoUrlDefinition
     */
    protected static function getSeoUrlDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Content\\Seo\\SeoUrl\\SeoUrlDefinition'] = $instance = new \Shopware\Core\Content\Seo\SeoUrl\SeoUrlDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Sitemap\SalesChannel\SitemapFileRoute' shared service.
     *
     * @return \Shopware\Core\Content\Sitemap\SalesChannel\SitemapFileRoute
     */
    protected static function getSitemapFileRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Sitemap\\SalesChannel\\SitemapFileRoute'] = new \Shopware\Core\Content\Sitemap\SalesChannel\SitemapFileRoute(($container->services['shopware.filesystem.sitemap'] ?? self::getShopware_Filesystem_SitemapService($container)), ($container->privates['Shopware\\Core\\Framework\\Extensions\\ExtensionDispatcher'] ?? self::getExtensionDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Sitemap\SalesChannel\SitemapRoute' shared service.
     *
     * @return \Shopware\Core\Content\Sitemap\SalesChannel\SitemapRoute
     */
    protected static function getSitemapRouteService($container)
    {
        return $container->services['Shopware\\Core\\Content\\Sitemap\\SalesChannel\\SitemapRoute'] = new \Shopware\Core\Content\Sitemap\SalesChannel\SitemapRoute(new \Shopware\Core\Content\Sitemap\Service\SitemapLister(($container->services['shopware.filesystem.sitemap'] ?? self::getShopware_Filesystem_SitemapService($container)), ($container->privates['shopware.asset.sitemap'] ?? self::getShopware_Asset_SitemapService($container))), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->privates['Shopware\\Core\\Content\\Sitemap\\Service\\SitemapExporter'] ?? self::getSitemapExporterService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Cache\CacheInvalidator' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Cache\CacheInvalidator
     */
    protected static function getCacheInvalidatorService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidator'] = $container->createProxy('CacheInvalidatorGhost0edcb5d', static fn () => \CacheInvalidatorGhost0edcb5d::createLazyGhost(static fn ($proxy) => self::getCacheInvalidatorService($container, $proxy)));
        }

        return ($lazyLoad->__construct([($container->privates['cache.object'] ?? self::getCache_ObjectService($container)), ($container->privates['cache.http'] ?? self::getCache_HttpService($container))], ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\InvalidatorStorage\\AbstractInvalidatorStorage'] ?? self::getAbstractInvalidatorStorageService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), 'prod') && false ?: $lazyLoad);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Cache\Http\CacheStore' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Cache\Http\CacheStore
     */
    protected static function getCacheStoreService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Adapter\\Cache\\Http\\CacheStore'])) {
            return $container->services['Shopware\\Core\\Framework\\Adapter\\Cache\\Http\\CacheStore'];
        }
        $b = ($container->privates['Shopware\\Core\\Framework\\Routing\\MaintenanceModeResolver'] ?? self::getMaintenanceModeResolverService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Adapter\\Cache\\Http\\CacheStore'])) {
            return $container->services['Shopware\\Core\\Framework\\Adapter\\Cache\\Http\\CacheStore'];
        }

        return $container->services['Shopware\\Core\\Framework\\Adapter\\Cache\\Http\\CacheStore'] = new \Shopware\Core\Framework\Adapter\Cache\Http\CacheStore(($container->privates['cache.http'] ?? self::getCache_HttpService($container)), new \Shopware\Core\Framework\Adapter\Cache\Http\CacheStateValidator($container->parameters['shopware.cache.invalidation.http_cache']), $a, new \Shopware\Core\Framework\Adapter\Cache\Http\HttpCacheKeyGenerator('256274b53d9c6fa9d0666b039c0652da', $a, $container->parameters['shopware.http_cache.ignored_url_parameters']), $b, $container->parameters['session.storage.options'], ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheTagCollector'] ?? self::getCacheTagCollectorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Cache\Script\Facade\CacheInvalidatorFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Cache\Script\Facade\CacheInvalidatorFacadeHookFactory
     */
    protected static function getCacheInvalidatorFacadeHookFactoryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Adapter\\Cache\\Script\\Facade\\CacheInvalidatorFacadeHookFactory'] = new \Shopware\Core\Framework\Adapter\Cache\Script\Facade\CacheInvalidatorFacadeHookFactory(($container->services['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidator'] ?? self::getCacheInvalidatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Storage\AbstractKeyValueStorage' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Storage\MySQLKeyValueStorage
     */
    protected static function getAbstractKeyValueStorageService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Adapter\\Storage\\AbstractKeyValueStorage'] = new \Shopware\Core\Framework\Adapter\Storage\MySQLKeyValueStorage(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Twig\AppTemplateIterator' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Twig\AppTemplateIterator
     */
    protected static function getAppTemplateIteratorService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Adapter\\Twig\\AppTemplateIterator'] = new \Shopware\Core\Framework\Adapter\Twig\AppTemplateIterator(($container->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateIterator'] ?? self::getTemplateIteratorService($container)), ($container->services['app_template.repository'] ?? self::getAppTemplate_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Twig\TemplateFinder' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Twig\TemplateFinder
     */
    protected static function getTemplateFinderService($container)
    {
        $a = ($container->services['twig'] ?? self::getTwigService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder'])) {
            return $container->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder'];
        }

        return $container->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder'] = new \Shopware\Core\Framework\Adapter\Twig\TemplateFinder($a, ($container->privates['twig.loader.chain'] ?? self::getTwig_Loader_ChainService($container)), ($container->targetDir.''.'/twig'), new \Shopware\Core\Framework\Adapter\Twig\NamespaceHierarchy\NamespaceHierarchyBuilder(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\NamespaceHierarchy\\BundleHierarchyBuilder'] ?? self::getBundleHierarchyBuilderService($container));
            yield 1 => ($container->privates['Shopware\\Storefront\\Theme\\Twig\\ThemeNamespaceHierarchyBuilder'] ?? self::getThemeNamespaceHierarchyBuilderService($container));
        }, 2)), ($container->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateScopeDetector'] ?? self::getTemplateScopeDetectorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Twig\TemplateIterator' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Twig\TemplateIterator
     */
    protected static function getTemplateIteratorService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateIterator'] = new \Shopware\Core\Framework\Adapter\Twig\TemplateIterator(new \Symfony\Bundle\TwigBundle\TemplateIterator(($container->services['kernel'] ?? $container->get('kernel', 1)), [(\dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Resources/views/Email') => 'email'], (\dirname(__DIR__, 4).'/templates'), []), $container->parameters['kernel.bundles']);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Acl\AclCriteriaValidator' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Acl\AclCriteriaValidator
     */
    protected static function getAclCriteriaValidatorService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] = new \Shopware\Core\Framework\Api\Acl\AclCriteriaValidator(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Acl\Role\AclRoleDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Acl\Role\AclRoleDefinition
     */
    protected static function getAclRoleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition'] = $instance = new \Shopware\Core\Framework\Api\Acl\Role\AclRoleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Acl\Role\AclUserRoleDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Acl\Role\AclUserRoleDefinition
     */
    protected static function getAclUserRoleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition'] = $instance = new \Shopware\Core\Framework\Api\Acl\Role\AclUserRoleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\AccessKeyController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\AccessKeyController
     */
    protected static function getAccessKeyControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\AccessKeyController'] = $instance = new \Shopware\Core\Framework\Api\Controller\AccessKeyController();

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\AclController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\AclController
     */
    protected static function getAclControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\AclController'] = $instance = new \Shopware\Core\Framework\Api\Controller\AclController(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['router'] ?? self::getRouterService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\ApiController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\ApiController
     */
    protected static function getApiControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\ApiController'] = $instance = new \Shopware\Core\Framework\Api\Controller\ApiController(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['serializer'] ?? self::getSerializerService($container)), new \Shopware\Core\Framework\DataAbstractionLayer\Search\RequestCriteriaBuilder(($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Parser\\AggregationParser'] ??= new \Shopware\Core\Framework\DataAbstractionLayer\Search\Parser\AggregationParser()), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\ApiCriteriaValidator'] ?? self::getApiCriteriaValidatorService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\CriteriaArrayConverter'] ?? self::getCriteriaArrayConverterService($container)), 500), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\EntityProtection\\EntityProtectionValidator'] ?? self::getEntityProtectionValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] ?? self::getAclCriteriaValidatorService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\AuthController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\AuthController
     */
    protected static function getAuthControllerService($container)
    {
        $a = ($container->privates['Nyholm\\Psr7\\Factory\\Psr17Factory'] ??= new \Nyholm\Psr7\Factory\Psr17Factory());

        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\AuthController'] = $instance = new \Shopware\Core\Framework\Api\Controller\AuthController(($container->privates['shopware.api.authorization_server'] ?? self::getShopware_Api_AuthorizationServerService($container)), new \Symfony\Bridge\PsrHttpMessage\Factory\PsrHttpFactory($a, $a, $a, $a), ($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\CacheController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\CacheController
     */
    protected static function getCacheControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\CacheController'] = $instance = new \Shopware\Core\Framework\Api\Controller\CacheController(($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheClearer'] ?? self::getCacheClearerService($container)), ($container->services['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidator'] ?? self::getCacheInvalidatorService($container)), ($container->privates['cache.object'] ?? self::getCache_ObjectService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'] ?? self::getEntityIndexerRegistryService($container)));

        $instance->setContainer((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'router' => ['services', 'router', 'getRouterService', false],
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
            'http_kernel' => ['services', 'http_kernel', 'getHttpKernelService', false],
            'serializer' => ['privates', 'serializer', 'getSerializerService', false],
            'twig' => ['services', 'twig', 'getTwigService', false],
            'parameter_bag' => ['privates', 'parameter_bag', 'getParameterBagService', false],
        ], [
            'router' => '?',
            'request_stack' => '?',
            'http_kernel' => '?',
            'serializer' => '?',
            'twig' => '?',
            'parameter_bag' => '?',
        ]))->withContext('Shopware\\Core\\Framework\\Api\\Controller\\CacheController', $container));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\CustomSnippetFormatController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\CustomSnippetFormatController
     */
    protected static function getCustomSnippetFormatControllerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Api\\Controller\\CustomSnippetFormatController'] = new \Shopware\Core\Framework\Api\Controller\CustomSnippetFormatController(($container->services['Shopware\\Core\\Framework\\Plugin\\KernelPluginCollection'] ?? self::getKernelPluginCollectionService($container)), ($container->services['twig'] ?? self::getTwigService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\FallbackController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\FallbackController
     */
    protected static function getFallbackControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\FallbackController'] = $instance = new \Shopware\Core\Framework\Api\Controller\FallbackController();

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\FeatureFlagController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\FeatureFlagController
     */
    protected static function getFeatureFlagControllerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Api\\Controller\\FeatureFlagController'] = new \Shopware\Core\Framework\Api\Controller\FeatureFlagController(($container->services['Shopware\\Core\\Framework\\Feature\\FeatureFlagRegistry'] ?? self::getFeatureFlagRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheClearer'] ?? self::getCacheClearerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\HealthCheckController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\HealthCheckController
     */
    protected static function getHealthCheckControllerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Api\\Controller\\HealthCheckController'] = new \Shopware\Core\Framework\Api\Controller\HealthCheckController(($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\Framework\\SystemCheck\\SystemChecker'] ?? self::getSystemCheckerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\IndexingController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\IndexingController
     */
    protected static function getIndexingControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\IndexingController'] = $instance = new \Shopware\Core\Framework\Api\Controller\IndexingController(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'] ?? self::getEntityIndexerRegistryService($container)), ($container->services['messenger.default_bus'] ?? self::getMessenger_DefaultBusService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\InfoController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\InfoController
     */
    protected static function getInfoControllerService($container)
    {
        $a = ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container));

        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\InfoController'] = $instance = new \Shopware\Core\Framework\Api\Controller\InfoController(($container->privates['Shopware\\Core\\Framework\\Api\\ApiDefinition\\DefinitionService'] ?? self::getDefinitionServiceService($container)), ($container->privates['parameter_bag'] ??= new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($container)), ($container->services['kernel'] ?? $container->get('kernel', 1)), ($container->services['Shopware\\Core\\Framework\\Event\\BusinessEventCollector'] ?? self::getBusinessEventCollectorService($container)), ($container->services['shopware.increment.gateway.registry'] ?? self::getShopware_Increment_Gateway_RegistryService($container)), $a, new \Shopware\Core\Maintenance\System\Service\AppUrlVerifier(new \GuzzleHttp\Client(), $a, 'prod', $container->getEnv('bool:APP_URL_CHECK_DISABLED')), ($container->services['router'] ?? self::getRouterService($container)), ($container->privates['Shopware\\Core\\Content\\Flow\\Api\\FlowActionCollector'] ?? self::getFlowActionCollectorService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->privates['Shopware\\Core\\Framework\\Api\\Route\\ApiRouteInfoResolver'] ?? self::getApiRouteInfoResolverService($container)), ($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'] ?? self::getInAppPurchaseService($container)), ($container->privates['Shopware\\Administration\\Framework\\Twig\\ViteFileAccessorDecorator'] ?? self::getViteFileAccessorDecoratorService($container)), ($container->privates['filesystem'] ??= new \Symfony\Component\Filesystem\Filesystem()));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\IntegrationController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\IntegrationController
     */
    protected static function getIntegrationControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\IntegrationController'] = $instance = new \Shopware\Core\Framework\Api\Controller\IntegrationController(($container->services['integration.repository'] ?? self::getIntegration_RepositoryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\SalesChannelProxyController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\SalesChannelProxyController
     */
    protected static function getSalesChannelProxyControllerService($container)
    {
        $a = ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? self::getSalesChannelContextPersisterService($container));
        $b = ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? self::getCartServiceService($container));

        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\SalesChannelProxyController'] = $instance = new \Shopware\Core\Framework\Api\Controller\SalesChannelProxyController(($container->services['kernel'] ?? $container->get('kernel', 1)), ($container->services['sales_channel.repository'] ?? self::getSalesChannel_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), $a, ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? self::getSalesChannelContextServiceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), new \Shopware\Core\Checkout\Cart\ApiOrderCartService($b, $a), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'] ?? self::getCartOrderRouteService($container)), $b, ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['Shopware\\Core\\Checkout\\Customer\\ImitateCustomerTokenGenerator'] ??= new \Shopware\Core\Checkout\Customer\ImitateCustomerTokenGenerator($container->getEnv('APP_SECRET'))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\SyncController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\SyncController
     */
    protected static function getSyncControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\SyncController'] = $instance = new \Shopware\Core\Framework\Api\Controller\SyncController(($container->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'] ?? self::getSyncServiceService($container)), ($container->privates['serializer'] ?? self::getSerializerService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\UserController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\UserController
     */
    protected static function getUserControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Api\\Controller\\UserController'] = $instance = new \Shopware\Core\Framework\Api\Controller\UserController(($container->services['user.repository'] ?? self::getUser_RepositoryService($container)), ($container->services['acl_user_role.repository'] ?? self::getAclUserRole_RepositoryService($container)), ($container->services['acl_role.repository'] ?? self::getAclRole_RepositoryService($container)), ($container->services['user_access_key.repository'] ?? self::getUserAccessKey_RepositoryService($container)), ($container->services['Shopware\\Core\\System\\User\\UserDefinition'] ?? self::getUserDefinitionService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Sync\SyncService' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Sync\SyncService
     */
    protected static function getSyncServiceService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'] ?? self::getEntityWriterService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'])) {
            return $container->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'])) {
            return $container->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'])) {
            return $container->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'];
        }
        $d = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container));

        return $container->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'] = new \Shopware\Core\Framework\Api\Sync\SyncService($a, $b, $d, $c, ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? self::getRequestCriteriaBuilderService($container)), new \Shopware\Core\Framework\Api\Sync\SyncFkResolver($d, new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\Product\\Api\\ProductNumberFkResolver'] ?? self::getProductNumberFkResolverService($container));
        }, 1)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\ActionButtonTranslation\ActionButtonTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\ActionButtonTranslation\ActionButtonTranslationDefinition
     */
    protected static function getActionButtonTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\ActionButtonTranslation\ActionButtonTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\ActionButton\ActionButtonDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\ActionButton\ActionButtonDefinition
     */
    protected static function getActionButtonDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\ActionButton\ActionButtonDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\AppPaymentMethod\AppPaymentMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\AppPaymentMethod\AppPaymentMethodDefinition
     */
    protected static function getAppPaymentMethodDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\AppPaymentMethod\AppPaymentMethodDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\AppScriptConditionTranslation\AppScriptConditionTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\AppScriptConditionTranslation\AppScriptConditionTranslationDefinition
     */
    protected static function getAppScriptConditionTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\AppScriptConditionTranslation\AppScriptConditionTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\AppScriptCondition\AppScriptConditionDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\AppScriptCondition\AppScriptConditionDefinition
     */
    protected static function getAppScriptConditionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\AppScriptCondition\AppScriptConditionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\AppShippingMethod\AppShippingMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\AppShippingMethod\AppShippingMethodDefinition
     */
    protected static function getAppShippingMethodDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppShippingMethod\\AppShippingMethodDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\AppShippingMethod\AppShippingMethodDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\AppTranslation\AppTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\AppTranslation\AppTranslationDefinition
     */
    protected static function getAppTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\AppTranslation\AppTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\CmsBlockTranslation\AppCmsBlockTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\CmsBlockTranslation\AppCmsBlockTranslationDefinition
     */
    protected static function getAppCmsBlockTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\CmsBlockTranslation\AppCmsBlockTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\CmsBlock\AppCmsBlockDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\CmsBlock\AppCmsBlockDefinition
     */
    protected static function getAppCmsBlockDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\CmsBlock\AppCmsBlockDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\FlowActionTranslation\AppFlowActionTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\FlowActionTranslation\AppFlowActionTranslationDefinition
     */
    protected static function getAppFlowActionTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\FlowActionTranslation\AppFlowActionTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\FlowAction\AppFlowActionDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\FlowAction\AppFlowActionDefinition
     */
    protected static function getAppFlowActionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\FlowAction\AppFlowActionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\FlowEvent\AppFlowEventDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\FlowEvent\AppFlowEventDefinition
     */
    protected static function getAppFlowEventDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowEvent\\AppFlowEventDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\FlowEvent\AppFlowEventDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Api\AppActionController' shared service.
     *
     * @return \Shopware\Core\Framework\App\Api\AppActionController
     */
    protected static function getAppActionControllerService($container)
    {
        $a = ($container->services['app_action_button.repository'] ?? self::getAppActionButton_RepositoryService($container));

        $container->services['Shopware\\Core\\Framework\\App\\Api\\AppActionController'] = $instance = new \Shopware\Core\Framework\App\Api\AppActionController(new \Shopware\Core\Framework\App\ActionButton\ActionButtonLoader($a), new \Shopware\Core\Framework\App\ActionButton\AppActionLoader($a, ($container->services['Shopware\\Core\\Framework\\App\\Payload\\AppPayloadServiceHelper'] ?? self::getAppPayloadServiceHelperService($container))), ($container->privates['Shopware\\Core\\Framework\\App\\ActionButton\\Executor'] ?? self::getExecutorService($container)), new \Shopware\Core\Framework\App\Manifest\ModuleLoader(($container->services['app.repository'] ?? self::getApp_RepositoryService($container)), ($container->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'] ?? self::getShopIdProviderService($container)), ($container->privates['Shopware\\Core\\Framework\\App\\Hmac\\QuerySigner'] ?? self::getQuerySignerService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Api\AppCmsController' shared service.
     *
     * @return \Shopware\Core\Framework\App\Api\AppCmsController
     */
    protected static function getAppCmsControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Api\\AppCmsController'] = $instance = new \Shopware\Core\Framework\App\Api\AppCmsController(($container->services['app_cms_block.repository'] ?? self::getAppCmsBlock_RepositoryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Api\AppJWTGenerateRoute' shared service.
     *
     * @return \Shopware\Core\Framework\App\Api\AppJWTGenerateRoute
     */
    protected static function getAppJWTGenerateRouteService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\App\\Api\\AppJWTGenerateRoute'] = new \Shopware\Core\Framework\App\Api\AppJWTGenerateRoute(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'] ?? self::getShopIdProviderService($container)), ($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'] ?? self::getInAppPurchaseService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Api\AppUrlChangeController' shared service.
     *
     * @return \Shopware\Core\Framework\App\Api\AppUrlChangeController
     */
    protected static function getAppUrlChangeControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Api\\AppUrlChangeController'] = $instance = new \Shopware\Core\Framework\App\Api\AppUrlChangeController(($container->services['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\Resolver'] ?? self::getResolverService($container)), ($container->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'] ?? self::getShopIdProviderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\AppDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\AppDefinition
     */
    protected static function getAppDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\AppDefinition'] = $instance = new \Shopware\Core\Framework\App\AppDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\AppLocaleProvider' shared service.
     *
     * @return \Shopware\Core\Framework\App\AppLocaleProvider
     */
    protected static function getAppLocaleProviderService($container)
    {
        $a = ($container->services['user.repository'] ?? self::getUser_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\App\\AppLocaleProvider'])) {
            return $container->services['Shopware\\Core\\Framework\\App\\AppLocaleProvider'];
        }

        return $container->services['Shopware\\Core\\Framework\\App\\AppLocaleProvider'] = new \Shopware\Core\Framework\App\AppLocaleProvider($a, ($container->privates['Shopware\\Core\\System\\Locale\\LanguageLocaleCodeProvider'] ?? self::getLanguageLocaleCodeProviderService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\AppUrlChangeResolver\Resolver' shared service.
     *
     * @return \Shopware\Core\Framework\App\AppUrlChangeResolver\Resolver
     */
    protected static function getResolverService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\Resolver'] = new \Shopware\Core\Framework\App\AppUrlChangeResolver\Resolver(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\MoveShopPermanentlyStrategy'] ?? self::getMoveShopPermanentlyStrategyService($container));
            yield 1 => ($container->privates['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\ReinstallAppsStrategy'] ?? self::getReinstallAppsStrategyService($container));
            yield 2 => ($container->privates['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\UninstallAppsStrategy'] ?? self::getUninstallAppsStrategyService($container));
        }, 3));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Flow\Action\AppFlowActionProvider' shared service.
     *
     * @return \Shopware\Core\Framework\App\Flow\Action\AppFlowActionProvider
     */
    protected static function getAppFlowActionProviderService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Framework\\Webhook\\BusinessEventEncoder'] ?? self::getBusinessEventEncoderService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\App\\Flow\\Action\\AppFlowActionProvider'])) {
            return $container->services['Shopware\\Core\\Framework\\App\\Flow\\Action\\AppFlowActionProvider'];
        }
        $b = ($container->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\StringTemplateRenderer'] ?? self::getStringTemplateRendererService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\App\\Flow\\Action\\AppFlowActionProvider'])) {
            return $container->services['Shopware\\Core\\Framework\\App\\Flow\\Action\\AppFlowActionProvider'];
        }

        return $container->services['Shopware\\Core\\Framework\\App\\Flow\\Action\\AppFlowActionProvider'] = new \Shopware\Core\Framework\App\Flow\Action\AppFlowActionProvider(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), $a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Payload\AppPayloadServiceHelper' shared service.
     *
     * @return \Shopware\Core\Framework\App\Payload\AppPayloadServiceHelper
     */
    protected static function getAppPayloadServiceHelperService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'] ?? self::getShopIdProviderService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\App\\Payload\\AppPayloadServiceHelper'])) {
            return $container->services['Shopware\\Core\\Framework\\App\\Payload\\AppPayloadServiceHelper'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'] ?? self::getInAppPurchaseService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\App\\Payload\\AppPayloadServiceHelper'])) {
            return $container->services['Shopware\\Core\\Framework\\App\\Payload\\AppPayloadServiceHelper'];
        }

        return $container->services['Shopware\\Core\\Framework\\App\\Payload\\AppPayloadServiceHelper'] = new \Shopware\Core\Framework\App\Payload\AppPayloadServiceHelper(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\Api\\Serializer\\JsonEntityEncoder'] ?? self::getJsonEntityEncoderService($container)), $a, $b, $container->getEnv('APP_URL'));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\ShopId\ShopIdProvider' shared service.
     *
     * @return \Shopware\Core\Framework\App\ShopId\ShopIdProvider
     */
    protected static function getShopIdProviderService($container)
    {
        $a = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'])) {
            return $container->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'])) {
            return $container->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'];
        }

        return $container->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'] = new \Shopware\Core\Framework\App\ShopId\ShopIdProvider($a, $b, ($container->privates['Shopware\\Core\\Framework\\App\\ActiveAppsLoader'] ?? self::getActiveAppsLoaderService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Template\TemplateDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Template\TemplateDefinition
     */
    protected static function getTemplateDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition'] = $instance = new \Shopware\Core\Framework\App\Template\TemplateDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Template\TemplateStateService' shared service.
     *
     * @return \Shopware\Core\Framework\App\Template\TemplateStateService
     */
    protected static function getTemplateStateServiceService($container)
    {
        $a = ($container->services['app_template.repository'] ?? self::getAppTemplate_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\App\\Template\\TemplateStateService'])) {
            return $container->services['Shopware\\Core\\Framework\\App\\Template\\TemplateStateService'];
        }
        $b = ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheClearer'] ?? self::getCacheClearerService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\App\\Template\\TemplateStateService'])) {
            return $container->services['Shopware\\Core\\Framework\\App\\Template\\TemplateStateService'];
        }

        return $container->services['Shopware\\Core\\Framework\\App\\Template\\TemplateStateService'] = new \Shopware\Core\Framework\App\Template\TemplateStateService($a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator
     */
    protected static function getEntityCacheKeyGeneratorService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityHydrator' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityHydrator
     */
    protected static function getEntityHydratorService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityHydrator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityHydrator($container);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\ConfigJsonFieldAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\ConfigJsonFieldAccessorBuilder
     */
    protected static function getConfigJsonFieldAccessorBuilderService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\ConfigJsonFieldAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\ConfigJsonFieldAccessorBuilder(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\CustomFieldsAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\CustomFieldsAccessorBuilder
     */
    protected static function getCustomFieldsAccessorBuilderService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\CustomFieldsAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\CustomFieldsAccessorBuilder(($container->privates['Shopware\\Core\\System\\CustomField\\CustomFieldService'] ?? self::getCustomFieldServiceService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\DefaultFieldAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\DefaultFieldAccessorBuilder
     */
    protected static function getDefaultFieldAccessorBuilderService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\DefaultFieldAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\DefaultFieldAccessorBuilder();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\JsonFieldAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\JsonFieldAccessorBuilder
     */
    protected static function getJsonFieldAccessorBuilderService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\JsonFieldAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\JsonFieldAccessorBuilder(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\PriceFieldAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\PriceFieldAccessorBuilder
     */
    protected static function getPriceFieldAccessorBuilderService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\PriceFieldAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\PriceFieldAccessorBuilder(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToManyAssociationFieldResolver' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToManyAssociationFieldResolver
     */
    protected static function getManyToManyAssociationFieldResolverService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\ManyToManyAssociationFieldResolver'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToManyAssociationFieldResolver();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToOneAssociationFieldResolver' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToOneAssociationFieldResolver
     */
    protected static function getManyToOneAssociationFieldResolverService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\ManyToOneAssociationFieldResolver'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToOneAssociationFieldResolver(($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ??= new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper()), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\OneToManyAssociationFieldResolver' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\OneToManyAssociationFieldResolver
     */
    protected static function getOneToManyAssociationFieldResolverService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\OneToManyAssociationFieldResolver'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\OneToManyAssociationFieldResolver();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\TranslationFieldResolver' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\TranslationFieldResolver
     */
    protected static function getTranslationFieldResolverService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\TranslationFieldResolver'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\TranslationFieldResolver(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\JoinGroupBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\JoinGroupBuilder
     */
    protected static function getJoinGroupBuilderService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\JoinGroupBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\JoinGroupBuilder();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\DefinitionInstanceRegistry' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\DefinitionInstanceRegistry
     */
    protected static function getDefinitionInstanceRegistryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] = new \Shopware\Core\Framework\DataAbstractionLayer\DefinitionInstanceRegistry($container, ['log_entry' => 'Shopware\\Core\\Framework\\Log\\LogEntryDefinition', 'acl_role' => 'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition', 'acl_user_role' => 'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition', 'app' => 'Shopware\\Core\\Framework\\App\\AppDefinition', 'app_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition', 'app_action_button' => 'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition', 'app_action_button_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition', 'app_template' => 'Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition', 'app_payment_method' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition', 'app_script_condition' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition', 'app_script_condition_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition', 'app_cms_block' => 'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition', 'app_cms_block_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition', 'app_flow_action' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition', 'app_flow_action_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition', 'app_flow_event' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowEvent\\AppFlowEventDefinition', 'app_shipping_method' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppShippingMethod\\AppShippingMethodDefinition', 'custom_field' => 'Shopware\\Core\\System\\CustomField\\CustomFieldDefinition', 'custom_field_set' => 'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition', 'custom_field_set_relation' => 'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition', 'version' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition', 'version_commit' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition', 'version_commit_data' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition', 'plugin' => 'Shopware\\Core\\Framework\\Plugin\\PluginDefinition', 'plugin_translation' => 'Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition', 'scheduled_task' => 'Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition', 'script' => 'Shopware\\Core\\Framework\\Script\\ScriptDefinition', 'language' => 'Shopware\\Core\\System\\Language\\LanguageDefinition', 'seo_url' => 'Shopware\\Core\\Content\\Seo\\SeoUrl\\SeoUrlDefinition', 'seo_url_template' => 'Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition', 'main_category' => 'Shopware\\Core\\Content\\Seo\\MainCategory\\MainCategoryDefinition', 'webhook' => 'Shopware\\Core\\Framework\\Webhook\\WebhookDefinition', 'webhook_event_log' => 'Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition', 'sales_channel' => 'Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition', 'sales_channel_translation' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition', 'sales_channel_country' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition', 'sales_channel_currency' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition', 'sales_channel_domain' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition', 'sales_channel_language' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition', 'sales_channel_payment_method' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition', 'sales_channel_shipping_method' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition', 'sales_channel_type' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition', 'sales_channel_type_translation' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition', 'sales_channel_analytics' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition', 'country' => 'Shopware\\Core\\System\\Country\\CountryDefinition', 'country_state' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\CountryStateDefinition', 'country_state_translation' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition', 'country_translation' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition', 'currency' => 'Shopware\\Core\\System\\Currency\\CurrencyDefinition', 'currency_country_rounding' => 'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition', 'currency_translation' => 'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition', 'custom_entity' => 'Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition', 'locale' => 'Shopware\\Core\\System\\Locale\\LocaleDefinition', 'locale_translation' => 'Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition', 'snippet_set' => 'Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition', 'snippet' => 'Shopware\\Core\\System\\Snippet\\SnippetDefinition', 'salutation' => 'Shopware\\Core\\System\\Salutation\\SalutationDefinition', 'salutation_translation' => 'Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition', 'tax' => 'Shopware\\Core\\System\\Tax\\TaxDefinition', 'tax_rule' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition', 'tax_rule_type' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition', 'tax_rule_type_translation' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition', 'tax_provider' => 'Shopware\\Core\\System\\TaxProvider\\TaxProviderDefinition', 'tax_provider_translation' => 'Shopware\\Core\\System\\TaxProvider\\Aggregate\\TaxProviderTranslation\\TaxProviderTranslationDefinition', 'unit' => 'Shopware\\Core\\System\\Unit\\UnitDefinition', 'unit_translation' => 'Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition', 'user' => 'Shopware\\Core\\System\\User\\UserDefinition', 'user_config' => 'Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition', 'user_access_key' => 'Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition', 'user_recovery' => 'Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition', 'integration' => 'Shopware\\Core\\System\\Integration\\IntegrationDefinition', 'integration_role' => 'Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition', 'state_machine' => 'Shopware\\Core\\System\\StateMachine\\StateMachineDefinition', 'state_machine_translation' => 'Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition', 'state_machine_state' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition', 'state_machine_state_translation' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition', 'state_machine_transition' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition', 'state_machine_history' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition', 'system_config' => 'Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition', 'number_range' => 'Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition', 'number_range_sales_channel' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition', 'number_range_state' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition', 'number_range_type' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition', 'number_range_type_translation' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition', 'number_range_translation' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition', 'tag' => 'Shopware\\Core\\System\\Tag\\TagDefinition', 'category' => 'Shopware\\Core\\Content\\Category\\CategoryDefinition', 'category_translation' => 'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition', 'category_tag' => 'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition', 'media' => 'Shopware\\Core\\Content\\Media\\MediaDefinition', 'media_default_folder' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition', 'media_thumbnail' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition', 'media_translation' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition', 'media_folder' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition', 'media_thumbnail_size' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition', 'media_folder_configuration' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition', 'media_folder_configuration_media_thumbnail_size' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition', 'media_tag' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition', 'product' => 'Shopware\\Core\\Content\\Product\\ProductDefinition', 'product_stream_mapping' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition', 'product_category' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition', 'product_custom_field_set' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition', 'product_tag' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition', 'product_configurator_setting' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition', 'product_price' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition', 'product_property' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition', 'product_search_keyword' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition', 'product_keyword_dictionary' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition', 'product_review' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition', 'product_manufacturer' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition', 'product_manufacturer_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition', 'product_media' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition', 'product_download' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductDownload\\ProductDownloadDefinition', 'product_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition', 'product_option' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition', 'product_category_tree' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition', 'product_cross_selling' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition', 'product_cross_selling_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition', 'product_cross_selling_assigned_products' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition', 'product_feature_set' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition', 'product_feature_set_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition', 'product_sorting' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition', 'product_sorting_translation' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition', 'product_search_config' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition', 'product_search_config_field' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition', 'product_visibility' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition', 'delivery_time' => 'Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition', 'newsletter_recipient' => 'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipient\\NewsletterRecipientDefinition', 'newsletter_recipient_tag' => 'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition', 'rule' => 'Shopware\\Core\\Content\\Rule\\RuleDefinition', 'rule_condition' => 'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition', 'rule_tag' => 'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition', 'product_stream' => 'Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition', 'product_stream_translation' => 'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition', 'product_stream_filter' => 'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition', 'product_export' => 'Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition', 'property_group' => 'Shopware\\Core\\Content\\Property\\PropertyGroupDefinition', 'property_group_option' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition', 'property_group_option_translation' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition', 'property_group_translation' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition', 'cms_page' => 'Shopware\\Core\\Content\\Cms\\CmsPageDefinition', 'cms_page_translation' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition', 'cms_section' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition', 'cms_block' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition', 'cms_slot' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition', 'cms_slot_translation' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition', 'mail_template' => 'Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition', 'mail_template_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition', 'mail_template_type' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition', 'mail_template_type_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition', 'mail_template_media' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition', 'mail_header_footer' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition', 'mail_header_footer_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition', 'delivery_time_translation' => 'Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition', 'import_export_profile' => 'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition', 'import_export_log' => 'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition', 'import_export_file' => 'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition', 'import_export_profile_translation' => 'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition', 'landing_page' => 'Shopware\\Core\\Content\\LandingPage\\LandingPageDefinition', 'landing_page_translation' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition', 'landing_page_tag' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition', 'landing_page_sales_channel' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition', 'flow' => 'Shopware\\Core\\Content\\Flow\\FlowDefinition', 'flow_sequence' => 'Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition', 'flow_template' => 'Shopware\\Core\\Content\\Flow\\Aggregate\\FlowTemplate\\FlowTemplateDefinition', 'customer' => 'Shopware\\Core\\Checkout\\Customer\\CustomerDefinition', 'customer_group_translation' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition', 'customer_address' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition', 'customer_recovery' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition', 'customer_group' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition', 'customer_group_registration_sales_channels' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition', 'customer_tag' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition', 'customer_wishlist' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition', 'customer_wishlist_product' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition', 'document' => 'Shopware\\Core\\Checkout\\Document\\DocumentDefinition', 'document_type' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition', 'document_type_translation' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition', 'document_base_config' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition', 'document_base_config_sales_channel' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition', 'order' => 'Shopware\\Core\\Checkout\\Order\\OrderDefinition', 'order_address' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition', 'order_customer' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition', 'order_delivery' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition', 'order_delivery_position' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition', 'order_line_item' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition', 'order_line_item_download' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItemDownload\\OrderLineItemDownloadDefinition', 'order_tag' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition', 'order_transaction' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition', 'order_transaction_capture' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition', 'order_transaction_capture_refund' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition', 'order_transaction_capture_refund_position' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition', 'payment_method' => 'Shopware\\Core\\Checkout\\Payment\\PaymentMethodDefinition', 'payment_method_translation' => 'Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition', 'promotion' => 'Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition', 'promotion_sales_channel' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition', 'promotion_individual_code' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition', 'promotion_discount' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition', 'promotion_discount_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition', 'promotion_setgroup' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition', 'promotion_setgroup_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition', 'promotion_order_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition', 'promotion_persona_customer' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition', 'promotion_persona_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition', 'promotion_cart_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition', 'promotion_translation' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition', 'promotion_discount_prices' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition', 'shipping_method' => 'Shopware\\Core\\Checkout\\Shipping\\ShippingMethodDefinition', 'shipping_method_tag' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition', 'shipping_method_price' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition', 'shipping_method_translation' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition', 'app_administration_snippet' => 'Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition', 'notification' => 'Shopware\\Administration\\Notification\\NotificationDefinition', 'theme' => 'Shopware\\Storefront\\Theme\\ThemeDefinition', 'theme_translation' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition', 'theme_sales_channel' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition', 'theme_media' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition', 'theme_child' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition'], ['log_entry' => 'log_entry.repository', 'acl_role' => 'acl_role.repository', 'acl_user_role' => 'acl_user_role.repository', 'app' => 'app.repository', 'app_translation' => 'app_translation.repository', 'app_action_button' => 'app_action_button.repository', 'app_action_button_translation' => 'app_action_button_translation.repository', 'app_template' => 'app_template.repository', 'app_payment_method' => 'app_payment_method.repository', 'app_script_condition' => 'app_script_condition.repository', 'app_script_condition_translation' => 'app_script_condition_translation.repository', 'app_cms_block' => 'app_cms_block.repository', 'app_cms_block_translation' => 'app_cms_block_translation.repository', 'app_flow_action' => 'app_flow_action.repository', 'app_flow_action_translation' => 'app_flow_action_translation.repository', 'app_flow_event' => 'app_flow_event.repository', 'app_shipping_method' => 'app_shipping_method.repository', 'custom_field' => 'custom_field.repository', 'custom_field_set' => 'custom_field_set.repository', 'custom_field_set_relation' => 'custom_field_set_relation.repository', 'version' => 'version.repository', 'version_commit' => 'version_commit.repository', 'version_commit_data' => 'version_commit_data.repository', 'plugin' => 'plugin.repository', 'plugin_translation' => 'plugin_translation.repository', 'scheduled_task' => 'scheduled_task.repository', 'script' => 'script.repository', 'language' => 'language.repository', 'seo_url' => 'seo_url.repository', 'seo_url_template' => 'seo_url_template.repository', 'main_category' => 'main_category.repository', 'webhook' => 'webhook.repository', 'webhook_event_log' => 'webhook_event_log.repository', 'sales_channel' => 'sales_channel.repository', 'sales_channel_translation' => 'sales_channel_translation.repository', 'sales_channel_country' => 'sales_channel_country.repository', 'sales_channel_currency' => 'sales_channel_currency.repository', 'sales_channel_domain' => 'sales_channel_domain.repository', 'sales_channel_language' => 'sales_channel_language.repository', 'sales_channel_payment_method' => 'sales_channel_payment_method.repository', 'sales_channel_shipping_method' => 'sales_channel_shipping_method.repository', 'sales_channel_type' => 'sales_channel_type.repository', 'sales_channel_type_translation' => 'sales_channel_type_translation.repository', 'sales_channel_analytics' => 'sales_channel_analytics.repository', 'country' => 'country.repository', 'country_state' => 'country_state.repository', 'country_state_translation' => 'country_state_translation.repository', 'country_translation' => 'country_translation.repository', 'currency' => 'currency.repository', 'currency_country_rounding' => 'currency_country_rounding.repository', 'currency_translation' => 'currency_translation.repository', 'custom_entity' => 'custom_entity.repository', 'locale' => 'locale.repository', 'locale_translation' => 'locale_translation.repository', 'snippet_set' => 'snippet_set.repository', 'snippet' => 'snippet.repository', 'salutation' => 'salutation.repository', 'salutation_translation' => 'salutation_translation.repository', 'tax' => 'tax.repository', 'tax_rule' => 'tax_rule.repository', 'tax_rule_type' => 'tax_rule_type.repository', 'tax_rule_type_translation' => 'tax_rule_type_translation.repository', 'tax_provider' => 'tax_provider.repository', 'tax_provider_translation' => 'tax_provider_translation.repository', 'unit' => 'unit.repository', 'unit_translation' => 'unit_translation.repository', 'user' => 'user.repository', 'user_config' => 'user_config.repository', 'user_access_key' => 'user_access_key.repository', 'user_recovery' => 'user_recovery.repository', 'integration' => 'integration.repository', 'integration_role' => 'integration_role.repository', 'state_machine' => 'state_machine.repository', 'state_machine_translation' => 'state_machine_translation.repository', 'state_machine_state' => 'state_machine_state.repository', 'state_machine_state_translation' => 'state_machine_state_translation.repository', 'state_machine_transition' => 'state_machine_transition.repository', 'state_machine_history' => 'state_machine_history.repository', 'system_config' => 'system_config.repository', 'number_range' => 'number_range.repository', 'number_range_sales_channel' => 'number_range_sales_channel.repository', 'number_range_state' => 'number_range_state.repository', 'number_range_type' => 'number_range_type.repository', 'number_range_type_translation' => 'number_range_type_translation.repository', 'number_range_translation' => 'number_range_translation.repository', 'tag' => 'tag.repository', 'category' => 'category.repository', 'category_translation' => 'category_translation.repository', 'category_tag' => 'category_tag.repository', 'media' => 'media.repository', 'media_default_folder' => 'media_default_folder.repository', 'media_thumbnail' => 'media_thumbnail.repository', 'media_translation' => 'media_translation.repository', 'media_folder' => 'media_folder.repository', 'media_thumbnail_size' => 'media_thumbnail_size.repository', 'media_folder_configuration' => 'media_folder_configuration.repository', 'media_folder_configuration_media_thumbnail_size' => 'media_folder_configuration_media_thumbnail_size.repository', 'media_tag' => 'media_tag.repository', 'product' => 'product.repository', 'product_stream_mapping' => 'product_stream_mapping.repository', 'product_category' => 'product_category.repository', 'product_custom_field_set' => 'product_custom_field_set.repository', 'product_tag' => 'product_tag.repository', 'product_configurator_setting' => 'product_configurator_setting.repository', 'product_price' => 'product_price.repository', 'product_property' => 'product_property.repository', 'product_search_keyword' => 'product_search_keyword.repository', 'product_keyword_dictionary' => 'product_keyword_dictionary.repository', 'product_review' => 'product_review.repository', 'product_manufacturer' => 'product_manufacturer.repository', 'product_manufacturer_translation' => 'product_manufacturer_translation.repository', 'product_media' => 'product_media.repository', 'product_download' => 'product_download.repository', 'product_translation' => 'product_translation.repository', 'product_option' => 'product_option.repository', 'product_category_tree' => 'product_category_tree.repository', 'product_cross_selling' => 'product_cross_selling.repository', 'product_cross_selling_translation' => 'product_cross_selling_translation.repository', 'product_cross_selling_assigned_products' => 'product_cross_selling_assigned_products.repository', 'product_feature_set' => 'product_feature_set.repository', 'product_feature_set_translation' => 'product_feature_set_translation.repository', 'product_sorting' => 'product_sorting.repository', 'product_sorting_translation' => 'product_sorting_translation.repository', 'product_search_config' => 'product_search_config.repository', 'product_search_config_field' => 'product_search_config_field.repository', 'product_visibility' => 'product_visibility.repository', 'delivery_time' => 'delivery_time.repository', 'newsletter_recipient' => 'newsletter_recipient.repository', 'newsletter_recipient_tag' => 'newsletter_recipient_tag.repository', 'rule' => 'rule.repository', 'rule_condition' => 'rule_condition.repository', 'rule_tag' => 'rule_tag.repository', 'product_stream' => 'product_stream.repository', 'product_stream_translation' => 'product_stream_translation.repository', 'product_stream_filter' => 'product_stream_filter.repository', 'product_export' => 'product_export.repository', 'property_group' => 'property_group.repository', 'property_group_option' => 'property_group_option.repository', 'property_group_option_translation' => 'property_group_option_translation.repository', 'property_group_translation' => 'property_group_translation.repository', 'cms_page' => 'cms_page.repository', 'cms_page_translation' => 'cms_page_translation.repository', 'cms_section' => 'cms_section.repository', 'cms_block' => 'cms_block.repository', 'cms_slot' => 'cms_slot.repository', 'cms_slot_translation' => 'cms_slot_translation.repository', 'mail_template' => 'mail_template.repository', 'mail_template_translation' => 'mail_template_translation.repository', 'mail_template_type' => 'mail_template_type.repository', 'mail_template_type_translation' => 'mail_template_type_translation.repository', 'mail_template_media' => 'mail_template_media.repository', 'mail_header_footer' => 'mail_header_footer.repository', 'mail_header_footer_translation' => 'mail_header_footer_translation.repository', 'delivery_time_translation' => 'delivery_time_translation.repository', 'import_export_profile' => 'import_export_profile.repository', 'import_export_log' => 'import_export_log.repository', 'import_export_file' => 'import_export_file.repository', 'import_export_profile_translation' => 'import_export_profile_translation.repository', 'landing_page' => 'landing_page.repository', 'landing_page_translation' => 'landing_page_translation.repository', 'landing_page_tag' => 'landing_page_tag.repository', 'landing_page_sales_channel' => 'landing_page_sales_channel.repository', 'flow' => 'flow.repository', 'flow_sequence' => 'flow_sequence.repository', 'flow_template' => 'flow_template.repository', 'customer' => 'customer.repository', 'customer_group_translation' => 'customer_group_translation.repository', 'customer_address' => 'customer_address.repository', 'customer_recovery' => 'customer_recovery.repository', 'customer_group' => 'customer_group.repository', 'customer_group_registration_sales_channels' => 'customer_group_registration_sales_channels.repository', 'customer_tag' => 'customer_tag.repository', 'customer_wishlist' => 'customer_wishlist.repository', 'customer_wishlist_product' => 'customer_wishlist_product.repository', 'document' => 'document.repository', 'document_type' => 'document_type.repository', 'document_type_translation' => 'document_type_translation.repository', 'document_base_config' => 'document_base_config.repository', 'document_base_config_sales_channel' => 'document_base_config_sales_channel.repository', 'order' => 'order.repository', 'order_address' => 'order_address.repository', 'order_customer' => 'order_customer.repository', 'order_delivery' => 'order_delivery.repository', 'order_delivery_position' => 'order_delivery_position.repository', 'order_line_item' => 'order_line_item.repository', 'order_line_item_download' => 'order_line_item_download.repository', 'order_tag' => 'order_tag.repository', 'order_transaction' => 'order_transaction.repository', 'order_transaction_capture' => 'order_transaction_capture.repository', 'order_transaction_capture_refund' => 'order_transaction_capture_refund.repository', 'order_transaction_capture_refund_position' => 'order_transaction_capture_refund_position.repository', 'payment_method' => 'payment_method.repository', 'payment_method_translation' => 'payment_method_translation.repository', 'promotion' => 'promotion.repository', 'promotion_sales_channel' => 'promotion_sales_channel.repository', 'promotion_individual_code' => 'promotion_individual_code.repository', 'promotion_discount' => 'promotion_discount.repository', 'promotion_discount_rule' => 'promotion_discount_rule.repository', 'promotion_setgroup' => 'promotion_setgroup.repository', 'promotion_setgroup_rule' => 'promotion_setgroup_rule.repository', 'promotion_order_rule' => 'promotion_order_rule.repository', 'promotion_persona_customer' => 'promotion_persona_customer.repository', 'promotion_persona_rule' => 'promotion_persona_rule.repository', 'promotion_cart_rule' => 'promotion_cart_rule.repository', 'promotion_translation' => 'promotion_translation.repository', 'promotion_discount_prices' => 'promotion_discount_prices.repository', 'shipping_method' => 'shipping_method.repository', 'shipping_method_tag' => 'shipping_method_tag.repository', 'shipping_method_price' => 'shipping_method_price.repository', 'shipping_method_translation' => 'shipping_method_translation.repository', 'app_administration_snippet' => 'app_administration_snippet.repository', 'notification' => 'notification.repository', 'theme' => 'theme.repository', 'theme_translation' => 'theme_translation.repository', 'theme_sales_channel' => 'theme_sales_channel.repository', 'theme_media' => 'theme_media.repository', 'theme_child' => 'theme_child.repository']);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Event\EntityLoadedEventFactory' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Event\EntityLoadedEventFactory
     */
    protected static function getEntityLoadedEventFactoryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] = new \Shopware\Core\Framework\DataAbstractionLayer\Event\EntityLoadedEventFactory(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryFacadeHookFactory
     */
    protected static function getRepositoryFacadeHookFactoryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\RepositoryFacadeHookFactory'] = new \Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryFacadeHookFactory(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\AppContextCreator'] ?? self::getAppContextCreatorService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? self::getRequestCriteriaBuilderService($container)), ($container->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] ?? self::getAclCriteriaValidatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryWriterFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryWriterFacadeHookFactory
     */
    protected static function getRepositoryWriterFacadeHookFactoryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\RepositoryWriterFacadeHookFactory'] = new \Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryWriterFacadeHookFactory(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\AppContextCreator'] ?? self::getAppContextCreatorService($container)), ($container->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'] ?? self::getSyncServiceService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Facade\SalesChannelRepositoryFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Facade\SalesChannelRepositoryFacadeHookFactory
     */
    protected static function getSalesChannelRepositoryFacadeHookFactoryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\SalesChannelRepositoryFacadeHookFactory'] = new \Shopware\Core\Framework\DataAbstractionLayer\Facade\SalesChannelRepositoryFacadeHookFactory(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? self::getRequestCriteriaBuilderService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BlobFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BlobFieldSerializer
     */
    protected static function getBlobFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\BlobFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BlobFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BoolFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BoolFieldSerializer
     */
    protected static function getBoolFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\BoolFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BoolFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CalculatedPriceFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CalculatedPriceFieldSerializer
     */
    protected static function getCalculatedPriceFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CalculatedPriceFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CalculatedPriceFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CartPriceFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CartPriceFieldSerializer
     */
    protected static function getCartPriceFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CartPriceFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CartPriceFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CashRoundingConfigFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CashRoundingConfigFieldSerializer
     */
    protected static function getCashRoundingConfigFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CashRoundingConfigFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CashRoundingConfigFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ConfigJsonFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ConfigJsonFieldSerializer
     */
    protected static function getConfigJsonFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ConfigJsonFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ConfigJsonFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedAtFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedAtFieldSerializer
     */
    protected static function getCreatedAtFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CreatedAtFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedAtFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedByFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedByFieldSerializer
     */
    protected static function getCreatedByFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CreatedByFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedByFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CronIntervalFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CronIntervalFieldSerializer
     */
    protected static function getCronIntervalFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CronIntervalFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CronIntervalFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CustomFieldsSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CustomFieldsSerializer
     */
    protected static function getCustomFieldsSerializerService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer'];
        }

        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CustomFieldsSerializer(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), $a, ($container->privates['Shopware\\Core\\System\\CustomField\\CustomFieldService'] ?? self::getCustomFieldServiceService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateFieldSerializer
     */
    protected static function getDateFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateIntervalFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateIntervalFieldSerializer
     */
    protected static function getDateIntervalFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateIntervalFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateIntervalFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateTimeFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateTimeFieldSerializer
     */
    protected static function getDateTimeFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateTimeFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateTimeFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\EmailFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\EmailFieldSerializer
     */
    protected static function getEmailFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\EmailFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\EmailFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\EnumFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\EnumFieldSerializer
     */
    protected static function getEnumFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\EnumFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\EnumFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FkFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FkFieldSerializer
     */
    protected static function getFkFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\FkFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FkFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FloatFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FloatFieldSerializer
     */
    protected static function getFloatFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\FloatFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FloatFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IdFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IdFieldSerializer
     */
    protected static function getIdFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\IdFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IdFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IntFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IntFieldSerializer
     */
    protected static function getIntFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\IntFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IntFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\JsonFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\JsonFieldSerializer
     */
    protected static function getJsonFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\JsonFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\JsonFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ListFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ListFieldSerializer
     */
    protected static function getListFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ListFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ListFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\LongTextFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\LongTextFieldSerializer
     */
    protected static function getLongTextFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\LongTextFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\LongTextFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] ?? self::getHtmlSanitizerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToManyAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToManyAssociationFieldSerializer
     */
    protected static function getManyToManyAssociationFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ManyToManyAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToManyAssociationFieldSerializer(($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? self::getWriteCommandExtractorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToOneAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToOneAssociationFieldSerializer
     */
    protected static function getManyToOneAssociationFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ManyToOneAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToOneAssociationFieldSerializer(($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? self::getWriteCommandExtractorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToManyAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToManyAssociationFieldSerializer
     */
    protected static function getOneToManyAssociationFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\OneToManyAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToManyAssociationFieldSerializer(($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? self::getWriteCommandExtractorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] ?? self::getEntityWriteGatewayInterfaceService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToOneAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToOneAssociationFieldSerializer
     */
    protected static function getOneToOneAssociationFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\OneToOneAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToOneAssociationFieldSerializer(($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? self::getWriteCommandExtractorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PHPUnserializeFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PHPUnserializeFieldSerializer
     */
    protected static function getPHPUnserializeFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PHPUnserializeFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PHPUnserializeFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PasswordFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PasswordFieldSerializer
     */
    protected static function getPasswordFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PasswordFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PasswordFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceDefinitionFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceDefinitionFieldSerializer
     */
    protected static function getPriceDefinitionFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PriceDefinitionFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceDefinitionFieldSerializer(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->privates['Shopware\\Core\\Framework\\Rule\\Collector\\RuleConditionRegistry'] ?? self::getRuleConditionRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceFieldSerializer
     */
    protected static function getPriceFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PriceFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ReferenceVersionFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ReferenceVersionFieldSerializer
     */
    protected static function getReferenceVersionFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ReferenceVersionFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ReferenceVersionFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\RemoteAddressFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\RemoteAddressFieldSerializer
     */
    protected static function getRemoteAddressFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\RemoteAddressFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\RemoteAddressFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StateMachineStateFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StateMachineStateFieldSerializer
     */
    protected static function getStateMachineStateFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\StateMachineStateFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StateMachineStateFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StringFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StringFieldSerializer
     */
    protected static function getStringFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\StringFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StringFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] ?? self::getHtmlSanitizerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TaxFreeConfigFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TaxFreeConfigFieldSerializer
     */
    protected static function getTaxFreeConfigFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TaxFreeConfigFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TaxFreeConfigFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TimeZoneFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TimeZoneFieldSerializer
     */
    protected static function getTimeZoneFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TimeZoneFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TimeZoneFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslatedFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslatedFieldSerializer
     */
    protected static function getTranslatedFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TranslatedFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslatedFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslationsAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslationsAssociationFieldSerializer
     */
    protected static function getTranslationsAssociationFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TranslationsAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslationsAssociationFieldSerializer(($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? self::getWriteCommandExtractorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] ?? self::getEntityWriteGatewayInterfaceService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedAtFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedAtFieldSerializer
     */
    protected static function getUpdatedAtFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\UpdatedAtFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedAtFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedByFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedByFieldSerializer
     */
    protected static function getUpdatedByFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\UpdatedByFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedByFieldSerializer(($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VariantListingConfigFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VariantListingConfigFieldSerializer
     */
    protected static function getVariantListingConfigFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VariantListingConfigFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VariantListingConfigFieldSerializer(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\HappyPathValidator'] ?? self::getHappyPathValidatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionDataPayloadFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionDataPayloadFieldSerializer
     */
    protected static function getVersionDataPayloadFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VersionDataPayloadFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionDataPayloadFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionFieldSerializer
     */
    protected static function getVersionFieldSerializerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VersionFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Indexing\EntityIndexerRegistry' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Indexing\EntityIndexerRegistry
     */
    protected static function getEntityIndexerRegistryService($container)
    {
        $a = ($container->services['messenger.default_bus'] ?? self::getMessenger_DefaultBusService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'];
        }

        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'] = new \Shopware\Core\Framework\DataAbstractionLayer\Indexing\EntityIndexerRegistry(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Content\\LandingPage\\DataAbstractionLayer\\LandingPageIndexer'] ?? self::getLandingPageIndexerService($container));
            yield 1 => ($container->privates['Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\ProductIndexer'] ?? self::getProductIndexerService($container));
            yield 2 => ($container->privates['Shopware\\Core\\Content\\ProductStream\\DataAbstractionLayer\\ProductStreamIndexer'] ?? self::getProductStreamIndexerService($container));
            yield 3 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\DataAbstractionLayer\\CustomerIndexer'] ?? self::getCustomerIndexerService($container));
            yield 4 => ($container->privates['Shopware\\Core\\System\\SalesChannel\\DataAbstractionLayer\\SalesChannelIndexer'] ?? self::getSalesChannelIndexerService($container));
            yield 5 => ($container->privates['Shopware\\Core\\Content\\Category\\DataAbstractionLayer\\CategoryIndexer'] ?? self::getCategoryIndexerService($container));
            yield 6 => ($container->privates['Shopware\\Core\\Content\\Media\\DataAbstractionLayer\\MediaIndexer'] ?? self::getMediaIndexerService($container));
            yield 7 => ($container->privates['Shopware\\Core\\Content\\Media\\DataAbstractionLayer\\MediaFolderConfigurationIndexer'] ?? self::getMediaFolderConfigurationIndexerService($container));
            yield 8 => ($container->privates['Shopware\\Core\\Content\\Media\\DataAbstractionLayer\\MediaFolderIndexer'] ?? self::getMediaFolderIndexerService($container));
            yield 9 => ($container->privates['Shopware\\Core\\Content\\Media\\Infrastructure\\Path\\MediaPathPostUpdater'] ?? self::getMediaPathPostUpdaterService($container));
            yield 10 => ($container->privates['Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\ProductStreamUpdater'] ?? self::getProductStreamUpdaterService($container));
            yield 11 => ($container->privates['Shopware\\Core\\Content\\Newsletter\\DataAbstractionLayer\\NewsletterRecipientIndexer'] ?? self::getNewsletterRecipientIndexerService($container));
            yield 12 => ($container->privates['Shopware\\Core\\Content\\Rule\\DataAbstractionLayer\\RuleIndexer'] ?? self::getRuleIndexerService($container));
            yield 13 => ($container->privates['Shopware\\Core\\Content\\Flow\\Indexing\\FlowIndexer'] ?? self::getFlowIndexerService($container));
            yield 14 => ($container->privates['Shopware\\Core\\Checkout\\Payment\\DataAbstractionLayer\\PaymentMethodIndexer'] ?? self::getPaymentMethodIndexerService($container));
            yield 15 => ($container->privates['Shopware\\Core\\Checkout\\Promotion\\DataAbstractionLayer\\PromotionIndexer'] ?? self::getPromotionIndexerService($container));
            yield 16 => ($container->privates['Shopware\\Storefront\\Theme\\DataAbstractionLayer\\ThemeIndexer'] ?? self::getThemeIndexerService($container));
        }, 17), $a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Read\EntityReaderInterface' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityReader
     */
    protected static function getEntityReaderInterfaceService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityReader(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityHydrator'] ??= new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityHydrator($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ??= new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper()), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Parser\\SqlQueryParser'] ?? self::getSqlQueryParserService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\CriteriaQueryBuilder'] ?? self::getCriteriaQueryBuilderService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)), new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\CriteriaFieldsResolver());
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Search\EntityAggregatorInterface' shared service.
     *
     * @return \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntityAggregator
     */
    protected static function getEntityAggregatorInterfaceService($container)
    {
        $a = ($container->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'] ?? self::getElasticsearchHelperService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container));

        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] = new \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntityAggregator($a, ($container->services['OpenSearch\\Client'] ?? self::getClientService($container)), new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityAggregator(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ??= new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper()), $c, ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\CriteriaQueryBuilder'] ?? self::getCriteriaQueryBuilderService($container)), $container->getEnv('bool:SHOPWARE_DBAL_TIMEZONE_SUPPORT_ENABLED'), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Term\\SearchTermInterpreter'] ?? self::getSearchTermInterpreterService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Term\\EntityScoreQueryBuilder'] ??= new \Shopware\Core\Framework\DataAbstractionLayer\Search\Term\EntityScoreQueryBuilder())), new \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntityAggregatorHydrator($c), $b, '5s', 'query_then_fetch');
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearcherInterface' shared service.
     *
     * @return \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntitySearcher
     */
    protected static function getEntitySearcherInterfaceService($container)
    {
        $a = ($container->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'] ?? self::getElasticsearchHelperService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'];
        }

        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] = new \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntitySearcher(($container->services['OpenSearch\\Client'] ?? self::getClientService($container)), new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntitySearcher(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ??= new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper()), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\CriteriaQueryBuilder'] ?? self::getCriteriaQueryBuilderService($container))), $a, ($container->privates['Shopware\\Elasticsearch\\Framework\\DataAbstractionLayer\\CriteriaParser'] ?? self::getCriteriaParserService($container)), new \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntitySearchHydrator(), $b, '5s', 'query_then_fetch');
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\VersionManager' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\VersionManager
     */
    protected static function getVersionManagerService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'] ?? self::getEntityWriterService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] ?? self::getEntityWriteGatewayInterfaceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'];
        }
        $e = ($container->privates['serializer'] ?? self::getSerializerService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'];
        }

        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] = new \Shopware\Core\Framework\DataAbstractionLayer\VersionManager($a, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $b, $c, $d, $e, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition'] ?? self::getVersionCommitDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition'] ?? self::getVersionCommitDataDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition'] ?? self::getVersionDefinitionService($container)), ($container->privates['lock.default.factory'] ?? self::getLock_Default_FactoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommitData\VersionCommitDataDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommitData\VersionCommitDataDefinition
     */
    protected static function getVersionCommitDataDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition'] = $instance = new \Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommitData\VersionCommitDataDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommit\VersionCommitDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommit\VersionCommitDefinition
     */
    protected static function getVersionCommitDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition'] = $instance = new \Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommit\VersionCommitDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Version\VersionDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Version\VersionDefinition
     */
    protected static function getVersionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition'] = $instance = new \Shopware\Core\Framework\DataAbstractionLayer\Version\VersionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriteGatewayInterface' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityWriteGateway
     */
    protected static function getEntityWriteGatewayInterfaceService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'];
        }

        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityWriteGateway(125, ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), $a, new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\ExceptionHandlerRegistry(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\TechnicalNameExceptionHandler'] ??= new \Shopware\Core\Framework\DataAbstractionLayer\TechnicalNameExceptionHandler());
            yield 1 => ($container->privates['Shopware\\Core\\System\\Language\\LanguageExceptionHandler'] ??= new \Shopware\Core\System\Language\LanguageExceptionHandler());
            yield 2 => ($container->privates['Shopware\\Core\\System\\SalesChannel\\SalesChannelExceptionHandler'] ??= new \Shopware\Core\System\SalesChannel\SalesChannelExceptionHandler());
            yield 3 => ($container->privates['Shopware\\Core\\Content\\Category\\DataAbstractionLayer\\CategoryNonExistentExceptionHandler'] ??= new \Shopware\Core\Content\Category\DataAbstractionLayer\CategoryNonExistentExceptionHandler());
            yield 4 => ($container->privates['Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\ProductExceptionHandler'] ??= new \Shopware\Core\Content\Product\DataAbstractionLayer\ProductExceptionHandler());
            yield 5 => ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingExceptionHandler'] ??= new \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingExceptionHandler());
            yield 6 => ($container->privates['Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingExceptionHandler'] ??= new \Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingExceptionHandler());
            yield 7 => ($container->privates['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldExceptionHandler'] ??= new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldExceptionHandler());
            yield 8 => ($container->privates['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigExceptionHandler'] ??= new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigExceptionHandler());
            yield 9 => ($container->privates['Shopware\\Core\\Content\\Newsletter\\NewsletterExceptionHandler'] ??= new \Shopware\Core\Content\Newsletter\NewsletterExceptionHandler());
            yield 10 => ($container->privates['Shopware\\Core\\Content\\ProductExport\\DataAbstractionLayer\\ProductExportExceptionHandler'] ??= new \Shopware\Core\Content\ProductExport\DataAbstractionLayer\ProductExportExceptionHandler());
            yield 11 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\DataAbstractionLayer\\CustomerWishlistProductExceptionHandler'] ??= new \Shopware\Core\Checkout\Customer\DataAbstractionLayer\CustomerWishlistProductExceptionHandler());
            yield 12 => ($container->privates['Shopware\\Core\\Checkout\\Order\\OrderExceptionHandler'] ??= new \Shopware\Core\Checkout\Order\OrderExceptionHandler());
            yield 13 => ($container->privates['Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceExceptionHandler'] ??= new \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodPrice\ShippingMethodPriceExceptionHandler());
            yield 14 => ($container->privates['Shopware\\Storefront\\Theme\\DataAbstractionLayer\\ThemeExceptionHandler'] ??= new \Shopware\Storefront\Theme\DataAbstractionLayer\ThemeExceptionHandler());
        }, 15)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriter' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriter
     */
    protected static function getEntityWriterService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? self::getWriteCommandExtractorService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] ?? self::getEntityWriteGatewayInterfaceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'])) {
            return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'];
        }
        $c = ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container));
        $d = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container));

        return $container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'] = new \Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriter($a, new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityForeignKeyResolver($c, ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ??= new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper())), $b, ($container->privates['Shopware\\Core\\System\\Language\\CachedLanguageLoader'] ?? self::getCachedLanguageLoaderService($container)), $d, new \Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriteResultFactory($d, $c));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Event\BusinessEventCollector' shared service.
     *
     * @return \Shopware\Core\Framework\Event\BusinessEventCollector
     */
    protected static function getBusinessEventCollectorService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Event\\BusinessEventCollector'])) {
            return $container->services['Shopware\\Core\\Framework\\Event\\BusinessEventCollector'];
        }

        return $container->services['Shopware\\Core\\Framework\\Event\\BusinessEventCollector'] = new \Shopware\Core\Framework\Event\BusinessEventCollector(($container->services['Shopware\\Core\\Framework\\Event\\BusinessEventRegistry'] ??= new \Shopware\Core\Framework\Event\BusinessEventRegistry()), $a, ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Event\BusinessEventRegistry' shared service.
     *
     * @return \Shopware\Core\Framework\Event\BusinessEventRegistry
     */
    protected static function getBusinessEventRegistryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Event\\BusinessEventRegistry'] = new \Shopware\Core\Framework\Event\BusinessEventRegistry();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Feature\FeatureFlagRegistry' shared service.
     *
     * @return \Shopware\Core\Framework\Feature\FeatureFlagRegistry
     */
    protected static function getFeatureFlagRegistryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Feature\\FeatureFlagRegistry'] = new \Shopware\Core\Framework\Feature\FeatureFlagRegistry(($container->services['Shopware\\Core\\Framework\\Adapter\\Storage\\AbstractKeyValueStorage'] ?? self::getAbstractKeyValueStorageService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), $container->parameters['shopware.feature.flags'], true);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Increment\Controller\IncrementApiController' shared service.
     *
     * @return \Shopware\Core\Framework\Increment\Controller\IncrementApiController
     */
    protected static function getIncrementApiControllerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Increment\\Controller\\IncrementApiController'] = new \Shopware\Core\Framework\Increment\Controller\IncrementApiController(($container->services['shopware.increment.gateway.registry'] ?? self::getShopware_Increment_Gateway_RegistryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Log\LogEntryDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Log\LogEntryDefinition
     */
    protected static function getLogEntryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Log\\LogEntryDefinition'] = $instance = new \Shopware\Core\Framework\Log\LogEntryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\MessageQueue\Api\ConsumeMessagesController' shared service.
     *
     * @return \Shopware\Core\Framework\MessageQueue\Api\ConsumeMessagesController
     */
    protected static function getConsumeMessagesControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\MessageQueue\\Api\\ConsumeMessagesController'] = $instance = new \Shopware\Core\Framework\MessageQueue\Api\ConsumeMessagesController(($container->privates['messenger.receiver_locator'] ?? self::getMessenger_ReceiverLocatorService($container)), ($container->services['messenger.default_bus'] ?? self::getMessenger_DefaultBusService($container)), ($container->privates['messenger.listener.stop_worker_on_restart_signal_listener'] ?? self::getMessenger_Listener_StopWorkerOnRestartSignalListenerService($container)), new \Shopware\Core\Framework\MessageQueue\Subscriber\EarlyReturnMessagesListener(), ($container->privates['Shopware\\Core\\Framework\\MessageQueue\\Subscriber\\MessageQueueStatsSubscriber'] ?? self::getMessageQueueStatsSubscriberService($container)), 'v65', '128M', 20, ($container->privates['lock.default.factory'] ?? self::getLock_Default_FactoryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\MessageQueue\Api\ScheduledTaskController' shared service.
     *
     * @return \Shopware\Core\Framework\MessageQueue\Api\ScheduledTaskController
     */
    protected static function getScheduledTaskControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\MessageQueue\\Api\\ScheduledTaskController'] = $instance = new \Shopware\Core\Framework\MessageQueue\Api\ScheduledTaskController(($container->privates['Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\Scheduler\\TaskScheduler'] ?? self::getTaskSchedulerService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\MessageQueue\ScheduledTask\ScheduledTaskDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\MessageQueue\ScheduledTask\ScheduledTaskDefinition
     */
    protected static function getScheduledTaskDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition'] = $instance = new \Shopware\Core\Framework\MessageQueue\ScheduledTask\ScheduledTaskDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Migration\IndexerQueuer' shared service.
     *
     * @return \Shopware\Core\Framework\Migration\IndexerQueuer
     */
    protected static function getIndexerQueuerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Migration\\IndexerQueuer'] = new \Shopware\Core\Framework\Migration\IndexerQueuer(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Migration\MigrationCollectionLoader' shared service.
     *
     * @return \Shopware\Core\Framework\Migration\MigrationCollectionLoader
     */
    protected static function getMigrationCollectionLoaderService($container)
    {
        $a = ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container));
        $b = ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container));

        return $container->services['Shopware\\Core\\Framework\\Migration\\MigrationCollectionLoader'] = new \Shopware\Core\Framework\Migration\MigrationCollectionLoader($a, new \Shopware\Core\Framework\Migration\MigrationRuntime($a, $b), $b, new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core'] ??= new \Shopware\Core\Framework\Migration\MigrationSource('core'));
            yield 1 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core.V6_3'] ?? self::getMigrationSource_Core_V63Service($container));
            yield 2 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core.V6_4'] ?? self::getMigrationSource_Core_V64Service($container));
            yield 3 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core.V6_5'] ?? self::getMigrationSource_Core_V65Service($container));
            yield 4 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core.V6_6'] ?? self::getMigrationSource_Core_V66Service($container));
            yield 5 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core.V6_7'] ?? self::getMigrationSource_Core_V67Service($container));
            yield 6 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core.V6_8'] ??= new \Shopware\Core\Framework\Migration\MigrationSource('core.V6_8'));
            yield 7 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.null'] ??= new \Shopware\Core\Framework\Migration\MigrationSource('null', []));
            yield 8 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Framework'] ??= new \Shopware\Core\Framework\Migration\MigrationSource('Framework', [(\dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Migration') => 'Shopware\\Core\\Framework\\Migration']));
            yield 9 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Administration'] ??= new \Shopware\Core\Framework\Migration\MigrationSource('Administration', [(\dirname(__DIR__, 4).'/vendor/shopware/administration/Migration') => 'Shopware\\Administration\\Migration']));
            yield 10 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Elasticsearch'] ??= new \Shopware\Core\Framework\Migration\MigrationSource('Elasticsearch', [(\dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Migration') => 'Shopware\\Elasticsearch\\Migration']));
            yield 11 => ($container->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Storefront'] ??= new \Shopware\Core\Framework\Migration\MigrationSource('Storefront', [(\dirname(__DIR__, 4).'/vendor/shopware/storefront/Migration') => 'Shopware\\Storefront\\Migration']));
        }, 12));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\Aggregate\PluginTranslation\PluginTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\Aggregate\PluginTranslation\PluginTranslationDefinition
     */
    protected static function getPluginTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition'] = $instance = new \Shopware\Core\Framework\Plugin\Aggregate\PluginTranslation\PluginTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\KernelPluginCollection' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\KernelPluginCollection
     */
    protected static function getKernelPluginCollectionService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Plugin\\KernelPluginCollection'] = ($container->services['Shopware\\Core\\Framework\\Plugin\\KernelPluginLoader\\KernelPluginLoader'] ?? self::getKernelPluginLoaderService($container))->getPluginInstances();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\KernelPluginLoader\KernelPluginLoader' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\KernelPluginLoader\KernelPluginLoader
     */
    protected static function getKernelPluginLoaderService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Plugin\\KernelPluginLoader\\KernelPluginLoader'] = ($container->services['kernel'] ?? $container->get('kernel', 1))->getPluginLoader();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\PluginDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\PluginDefinition
     */
    protected static function getPluginDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Plugin\\PluginDefinition'] = $instance = new \Shopware\Core\Framework\Plugin\PluginDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\Util\PluginIdProvider' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\Util\PluginIdProvider
     */
    protected static function getPluginIdProviderService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Plugin\\Util\\PluginIdProvider'] = new \Shopware\Core\Framework\Plugin\Util\PluginIdProvider(($container->services['plugin.repository'] ?? self::getPlugin_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Routing\CanonicalRedirectService' shared service.
     *
     * @return \Shopware\Core\Framework\Routing\CanonicalRedirectService
     */
    protected static function getCanonicalRedirectServiceService($container)
    {
        $a = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Routing\\CanonicalRedirectService'])) {
            return $container->services['Shopware\\Core\\Framework\\Routing\\CanonicalRedirectService'];
        }

        return $container->services['Shopware\\Core\\Framework\\Routing\\CanonicalRedirectService'] = new \Shopware\Core\Framework\Routing\CanonicalRedirectService($a);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Routing\Facade\RequestFacadeFactory' shared service.
     *
     * @return \Shopware\Core\Framework\Routing\Facade\RequestFacadeFactory
     */
    protected static function getRequestFacadeFactoryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Routing\\Facade\\RequestFacadeFactory'] = new \Shopware\Core\Framework\Routing\Facade\RequestFacadeFactory(($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Routing\RequestTransformerInterface' shared autowired service.
     *
     * @return \Shopware\Storefront\Framework\Routing\RequestTransformer
     */
    protected static function getRequestTransformerInterfaceService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Routing\\RequestTransformerInterface'] = new \Shopware\Storefront\Framework\Routing\RequestTransformer(new \Shopware\Core\Framework\Routing\RequestTransformer(), ($container->services['Shopware\\Core\\Content\\Seo\\EmptyPathInfoResolver'] ?? self::getEmptyPathInfoResolverService($container)), $container->getParameter('shopware.routing.registered_api_prefixes'), new \Shopware\Storefront\Framework\Routing\CachedDomainLoader(new \Shopware\Storefront\Framework\Routing\DomainLoader(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container))), ($container->privates['cache.object'] ?? self::getCache_ObjectService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container))));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Rule\Api\RuleConfigController' shared service.
     *
     * @return \Shopware\Core\Framework\Rule\Api\RuleConfigController
     */
    protected static function getRuleConfigControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Rule\\Api\\RuleConfigController'] = $instance = new \Shopware\Core\Framework\Rule\Api\RuleConfigController(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\Framework\\Rule\\Container\\AndRule'] ??= new \Shopware\Core\Framework\Rule\Container\AndRule());
            yield 1 => ($container->privates['Shopware\\Core\\Framework\\Rule\\Container\\NotRule'] ??= new \Shopware\Core\Framework\Rule\Container\NotRule());
            yield 2 => ($container->privates['Shopware\\Core\\Framework\\Rule\\Container\\OrRule'] ??= new \Shopware\Core\Framework\Rule\Container\OrRule());
            yield 3 => ($container->privates['Shopware\\Core\\Framework\\Rule\\Container\\XorRule'] ??= new \Shopware\Core\Framework\Rule\Container\XorRule());
            yield 4 => ($container->privates['Shopware\\Core\\Framework\\Rule\\Container\\MatchAllLineItemsRule'] ??= new \Shopware\Core\Framework\Rule\Container\MatchAllLineItemsRule());
            yield 5 => ($container->privates['Shopware\\Core\\Framework\\Rule\\ScriptRule'] ??= new \Shopware\Core\Framework\Rule\ScriptRule());
            yield 6 => ($container->privates['Shopware\\Core\\Framework\\Rule\\DateRangeRule'] ??= new \Shopware\Core\Framework\Rule\DateRangeRule());
            yield 7 => ($container->privates['Shopware\\Core\\Framework\\Rule\\SimpleRule'] ??= new \Shopware\Core\Framework\Rule\SimpleRule());
            yield 8 => ($container->privates['Shopware\\Core\\Framework\\Rule\\SalesChannelRule'] ??= new \Shopware\Core\Framework\Rule\SalesChannelRule());
            yield 9 => ($container->privates['Shopware\\Core\\Framework\\Rule\\TimeRangeRule'] ??= new \Shopware\Core\Framework\Rule\TimeRangeRule());
            yield 10 => ($container->privates['Shopware\\Core\\Framework\\Rule\\WeekdayRule'] ??= new \Shopware\Core\Framework\Rule\WeekdayRule());
            yield 11 => ($container->privates['Shopware\\Core\\System\\Language\\Rule\\LanguageRule'] ??= new \Shopware\Core\System\Language\Rule\LanguageRule());
            yield 12 => ($container->privates['Shopware\\Core\\System\\Currency\\Rule\\CurrencyRule'] ??= new \Shopware\Core\System\Currency\Rule\CurrencyRule());
            yield 13 => ($container->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderTagRule'] ??= new \Shopware\Core\Content\Flow\Rule\OrderTagRule());
            yield 14 => ($container->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderTrackingCodeRule'] ??= new \Shopware\Core\Content\Flow\Rule\OrderTrackingCodeRule());
            yield 15 => ($container->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderDeliveryStatusRule'] ??= new \Shopware\Core\Content\Flow\Rule\OrderDeliveryStatusRule());
            yield 16 => ($container->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderCreatedByAdminRule'] ??= new \Shopware\Core\Content\Flow\Rule\OrderCreatedByAdminRule());
            yield 17 => ($container->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderTransactionStatusRule'] ??= new \Shopware\Core\Content\Flow\Rule\OrderTransactionStatusRule());
            yield 18 => ($container->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderStatusRule'] ??= new \Shopware\Core\Content\Flow\Rule\OrderStatusRule());
            yield 19 => ($container->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderCustomFieldRule'] ??= new \Shopware\Core\Content\Flow\Rule\OrderCustomFieldRule());
            yield 20 => ($container->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderDocumentTypeRule'] ??= new \Shopware\Core\Content\Flow\Rule\OrderDocumentTypeRule());
            yield 21 => ($container->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderDocumentTypeSentRule'] ??= new \Shopware\Core\Content\Flow\Rule\OrderDocumentTypeSentRule());
            yield 22 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartAmountRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\CartAmountRule());
            yield 23 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartPositionPriceRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\CartPositionPriceRule());
            yield 24 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\GoodsCountRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\GoodsCountRule());
            yield 25 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\GoodsPriceRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\GoodsPriceRule());
            yield 26 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemOfTypeRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemOfTypeRule());
            yield 27 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemRule());
            yield 28 => ($container->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionLineItemRule'] ??= new \Shopware\Core\Checkout\Promotion\Rule\PromotionLineItemRule());
            yield 29 => ($container->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionCodeOfTypeRule'] ??= new \Shopware\Core\Checkout\Promotion\Rule\PromotionCodeOfTypeRule());
            yield 30 => ($container->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionValueRule'] ??= new \Shopware\Core\Checkout\Promotion\Rule\PromotionValueRule());
            yield 31 => ($container->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionsInCartCountRule'] ??= new \Shopware\Core\Checkout\Promotion\Rule\PromotionsInCartCountRule());
            yield 32 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemTotalPriceRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemTotalPriceRule());
            yield 33 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemUnitPriceRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemUnitPriceRule());
            yield 34 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemWithQuantityRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemWithQuantityRule());
            yield 35 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemWrapperRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemWrapperRule());
            yield 36 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartShippingCostRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\CartShippingCostRule());
            yield 37 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartWeightRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\CartWeightRule());
            yield 38 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartVolumeRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\CartVolumeRule());
            yield 39 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartHasDeliveryFreeItemRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\CartHasDeliveryFreeItemRule());
            yield 40 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingCountryRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\BillingCountryRule());
            yield 41 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingStreetRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\BillingStreetRule());
            yield 42 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingZipCodeRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\BillingZipCodeRule());
            yield 43 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerGroupRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerGroupRule());
            yield 44 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerRequestedGroupRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerRequestedGroupRule());
            yield 45 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerTagRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerTagRule());
            yield 46 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerNumberRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerNumberRule());
            yield 47 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DifferentAddressesRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\DifferentAddressesRule());
            yield 48 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\EmailRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\EmailRule());
            yield 49 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsActiveRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\IsActiveRule());
            yield 50 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\LastNameRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\LastNameRule());
            yield 51 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsCompanyRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\IsCompanyRule());
            yield 52 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartTaxDisplayRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\CartTaxDisplayRule());
            yield 53 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartTotalPurchasePriceRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\CartTotalPurchasePriceRule());
            yield 54 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsGuestCustomerRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\IsGuestCustomerRule());
            yield 55 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsNewsletterRecipientRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\IsNewsletterRecipientRule());
            yield 56 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingCountryRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\ShippingCountryRule());
            yield 57 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingStreetRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\ShippingStreetRule());
            yield 58 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingCityRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\BillingCityRule());
            yield 59 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingCityRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\ShippingCityRule());
            yield 60 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingStateRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\BillingStateRule());
            yield 61 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingStateRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\ShippingStateRule());
            yield 62 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingZipCodeRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\ShippingZipCodeRule());
            yield 63 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerLoggedInRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerLoggedInRule());
            yield 64 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemsInCartCountRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemsInCartCountRule());
            yield 65 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\NumberOfReviewsRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\NumberOfReviewsRule());
            yield 66 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\OrderCountRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\OrderCountRule());
            yield 67 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DaysSinceLastOrderRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\DaysSinceLastOrderRule());
            yield 68 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemTagRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemTagRule());
            yield 69 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\AlwaysValidRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\AlwaysValidRule());
            yield 70 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPropertyRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemPropertyRule());
            yield 71 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemIsNewRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemIsNewRule());
            yield 72 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemOfManufacturerRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemOfManufacturerRule());
            yield 73 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPurchasePriceRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemPurchasePriceRule());
            yield 74 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemCreationDateRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemCreationDateRule());
            yield 75 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemReleaseDateRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemReleaseDateRule());
            yield 76 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemClearanceSaleRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemClearanceSaleRule());
            yield 77 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPromotedRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemPromotedRule());
            yield 78 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemInCategoryRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemInCategoryRule());
            yield 79 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemInProductStreamRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemInProductStreamRule());
            yield 80 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemTaxationRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemTaxationRule());
            yield 81 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionWidthRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionWidthRule());
            yield 82 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionHeightRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionHeightRule());
            yield 83 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionLengthRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionLengthRule());
            yield 84 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionWeightRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionWeightRule());
            yield 85 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionVolumeRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionVolumeRule());
            yield 86 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemListPriceRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemListPriceRule());
            yield 87 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemListPriceRatioRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemListPriceRatioRule());
            yield 88 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemCustomFieldRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemCustomFieldRule());
            yield 89 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemStockRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemStockRule());
            yield 90 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemActualStockRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemActualStockRule());
            yield 91 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\PaymentMethodRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\PaymentMethodRule());
            yield 92 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\ShippingMethodRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\ShippingMethodRule());
            yield 93 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemGoodsTotalRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemGoodsTotalRule());
            yield 94 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\OrderTotalAmountRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\OrderTotalAmountRule());
            yield 95 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerCustomFieldRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerCustomFieldRule());
            yield 96 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerBirthdayRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerBirthdayRule());
            yield 97 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerCreatedByAdminRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerCreatedByAdminRule());
            yield 98 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemProductStatesRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemProductStatesRule());
            yield 99 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerAgeRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerAgeRule());
            yield 100 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerSalutationRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CustomerSalutationRule());
            yield 101 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DaysSinceLastLoginRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\DaysSinceLastLoginRule());
            yield 102 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DaysSinceFirstLoginRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\DaysSinceFirstLoginRule());
            yield 103 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\AffiliateCodeRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\AffiliateCodeRule());
            yield 104 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\AffiliateCodeOfOrderRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\AffiliateCodeOfOrderRule());
            yield 105 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CampaignCodeOfOrderRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\CampaignCodeOfOrderRule());
            yield 106 => ($container->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CampaignCodeRule'] ??= new \Shopware\Core\Checkout\Customer\Rule\CampaignCodeRule());
            yield 107 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPropertyValueRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemPropertyValueRule());
            yield 108 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemVariantValueRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\LineItemVariantValueRule());
            yield 109 => ($container->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\AdminSalesChannelSourceRule'] ??= new \Shopware\Core\Checkout\Cart\Rule\AdminSalesChannelSourceRule());
        }, 110));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\Api\ScriptApiRoute' shared service.
     *
     * @return \Shopware\Core\Framework\Script\Api\ScriptApiRoute
     */
    protected static function getScriptApiRouteService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Script\\Api\\ScriptApiRoute'] = new \Shopware\Core\Framework\Script\Api\ScriptApiRoute(($container->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'] ?? self::getScriptExecutorService($container)), ($container->privates['Shopware\\Core\\Framework\\Script\\Execution\\ScriptLoader'] ?? self::getScriptLoaderService($container)), ($container->privates['Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseEncoder'] ?? self::getScriptResponseEncoderService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\Api\ScriptResponseFactoryFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\Script\Api\ScriptResponseFactoryFacadeHookFactory
     */
    protected static function getScriptResponseFactoryFacadeHookFactoryService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseFactoryFacadeHookFactory'] = new \Shopware\Core\Framework\Script\Api\ScriptResponseFactoryFacadeHookFactory(($container->services['router'] ?? self::getRouterService($container)), ($container->services['Shopware\\Storefront\\Controller\\ScriptController'] ?? self::getScriptControllerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\Api\ScriptStoreApiRoute' shared service.
     *
     * @return \Shopware\Core\Framework\Script\Api\ScriptStoreApiRoute
     */
    protected static function getScriptStoreApiRouteService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Script\\Api\\ScriptStoreApiRoute'] = new \Shopware\Core\Framework\Script\Api\ScriptStoreApiRoute(($container->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'] ?? self::getScriptExecutorService($container)), ($container->privates['Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseEncoder'] ?? self::getScriptResponseEncoderService($container)), ($container->privates['cache.object'] ?? self::getCache_ObjectService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\Execution\ScriptExecutor' shared service.
     *
     * @return \Shopware\Core\Framework\Script\Execution\ScriptExecutor
     */
    protected static function getScriptExecutorService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Framework\\Script\\Execution\\ScriptLoader'] ?? self::getScriptLoaderService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'])) {
            return $container->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'];
        }

        return $container->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'] = new \Shopware\Core\Framework\Script\Execution\ScriptExecutor($a, ($container->privates['Shopware\\Core\\Framework\\Script\\Debugging\\ScriptTraces'] ??= new \Shopware\Core\Framework\Script\Debugging\ScriptTraces()), $container, ($container->privates['twig.extension.trans'] ?? self::getTwig_Extension_TransService($container)), '6.7.0.0-RC5');
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\ScriptDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Script\ScriptDefinition
     */
    protected static function getScriptDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Script\\ScriptDefinition'] = $instance = new \Shopware\Core\Framework\Script\ScriptDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\ExtensionStoreActionsController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\ExtensionStoreActionsController
     */
    protected static function getExtensionStoreActionsControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreActionsController'] = $instance = new \Shopware\Core\Framework\Store\Api\ExtensionStoreActionsController(($container->privates['Shopware\\Core\\Framework\\Store\\Services\\ExtensionLifecycleService'] ?? self::getExtensionLifecycleServiceService($container)), ($container->privates['Shopware\\Core\\Framework\\Store\\Services\\ExtensionDownloader'] ?? self::getExtensionDownloaderService($container)), ($container->privates['Shopware\\Core\\Framework\\Plugin\\PluginService'] ?? self::getPluginServiceService($container)), ($container->privates['Shopware\\Core\\Framework\\Plugin\\PluginManagementService'] ?? self::getPluginManagementServiceService($container)), ($container->privates['filesystem'] ??= new \Symfony\Component\Filesystem\Filesystem()), true, ($container->privates['cache.object'] ?? self::getCache_ObjectService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\ExtensionStoreDataController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\ExtensionStoreDataController
     */
    protected static function getExtensionStoreDataControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreDataController'] = $instance = new \Shopware\Core\Framework\Store\Api\ExtensionStoreDataController(($container->privates['Shopware\\Core\\Framework\\Store\\Services\\AbstractExtensionDataProvider'] ?? self::getAbstractExtensionDataProviderService($container)), ($container->services['user.repository'] ?? self::getUser_RepositoryService($container)), ($container->services['language.repository'] ?? self::getLanguage_RepositoryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\ExtensionStoreLicensesController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\ExtensionStoreLicensesController
     */
    protected static function getExtensionStoreLicensesControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreLicensesController'] = $instance = new \Shopware\Core\Framework\Store\Api\ExtensionStoreLicensesController(new \Shopware\Core\Framework\Store\Services\ExtensionStoreLicensesService(($container->privates['Shopware\\Core\\Framework\\Store\\Services\\StoreClient'] ?? self::getStoreClientService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\FirstRunWizardController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\FirstRunWizardController
     */
    protected static function getFirstRunWizardControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Store\\Api\\FirstRunWizardController'] = $instance = new \Shopware\Core\Framework\Store\Api\FirstRunWizardController(($container->privates['Shopware\\Core\\Framework\\Store\\Services\\FirstRunWizardService'] ?? self::getFirstRunWizardServiceService($container)), ($container->services['plugin.repository'] ?? self::getPlugin_RepositoryService($container)), ($container->services['app.repository'] ?? self::getApp_RepositoryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\StoreController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\StoreController
     */
    protected static function getStoreControllerService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Store\\Api\\StoreController'] = $instance = new \Shopware\Core\Framework\Store\Api\StoreController(($container->privates['Shopware\\Core\\Framework\\Store\\Services\\StoreClient'] ?? self::getStoreClientService($container)), ($container->services['user.repository'] ?? self::getUser_RepositoryService($container)), ($container->privates['Shopware\\Core\\Framework\\Store\\Services\\AbstractExtensionDataProvider'] ?? self::getAbstractExtensionDataProviderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Authentication\StoreRequestOptionsProvider' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Authentication\StoreRequestOptionsProvider
     */
    protected static function getStoreRequestOptionsProviderService($container)
    {
        $a = ($container->services['user.repository'] ?? self::getUser_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'])) {
            return $container->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'];
        }
        $b = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'])) {
            return $container->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'];
        }
        $c = ($container->privates['Shopware\\Core\\Framework\\Store\\Authentication\\LocaleProvider'] ?? self::getLocaleProviderService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'])) {
            return $container->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'];
        }

        return $container->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'] = new \Shopware\Core\Framework\Store\Authentication\StoreRequestOptionsProvider($a, $b, ($container->privates['Shopware\\Core\\Framework\\Store\\Services\\InstanceService'] ??= new \Shopware\Core\Framework\Store\Services\InstanceService('6.7.0.0-RC5', $container->getEnv('INSTANCE_ID'))), $c);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\InAppPurchase' shared service.
     *
     * @return \Shopware\Core\Framework\Store\InAppPurchase
     */
    protected static function getInAppPurchaseService($container)
    {
        $a = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'])) {
            return $container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'];
        }
        $b = ($container->services['shopware.store_client'] ?? self::getShopware_StoreClientService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'])) {
            return $container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'] ?? self::getStoreRequestOptionsProviderService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'])) {
            return $container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'];
        }

        return $container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'] = new \Shopware\Core\Framework\Store\InAppPurchase(new \Shopware\Core\Framework\Store\InAppPurchase\Services\InAppPurchaseProvider($a, new \Shopware\Core\Framework\JWT\JWTDecoder(), new \Shopware\Core\Framework\Store\InAppPurchase\Services\KeyFetcher($b, $c, $a, ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)))));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\InAppPurchase\Api\InAppPurchasesController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\InAppPurchase\Api\InAppPurchasesController
     */
    protected static function getInAppPurchasesControllerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase\\Api\\InAppPurchasesController'] = new \Shopware\Core\Framework\Store\InAppPurchase\Api\InAppPurchasesController(($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'] ?? self::getInAppPurchaseService($container)), ($container->services['app.repository'] ?? self::getApp_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\InAppPurchase\Services\InAppPurchaseUpdater' shared service.
     *
     * @return \Shopware\Core\Framework\Store\InAppPurchase\Services\InAppPurchaseUpdater
     */
    protected static function getInAppPurchaseUpdaterService($container)
    {
        $a = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase\\Services\\InAppPurchaseUpdater'])) {
            return $container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase\\Services\\InAppPurchaseUpdater'];
        }
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase\\Services\\InAppPurchaseUpdater'])) {
            return $container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase\\Services\\InAppPurchaseUpdater'];
        }

        return $container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase\\Services\\InAppPurchaseUpdater'] = new \Shopware\Core\Framework\Store\InAppPurchase\Services\InAppPurchaseUpdater(($container->services['shopware.store_client'] ?? self::getShopware_StoreClientService($container)), $a, '/swplatform/inappfeatures/purchases', ($container->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'] ?? self::getStoreRequestOptionsProviderService($container)), ($container->services['Shopware\\Core\\Framework\\Store\\InAppPurchase'] ?? self::getInAppPurchaseService($container)), $b, ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Services\ShopSecretInvalidMiddleware' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Services\ShopSecretInvalidMiddleware
     */
    protected static function getShopSecretInvalidMiddlewareService($container)
    {
        $a = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));

        if (isset($container->services['Shopware\\Core\\Framework\\Store\\Services\\ShopSecretInvalidMiddleware'])) {
            return $container->services['Shopware\\Core\\Framework\\Store\\Services\\ShopSecretInvalidMiddleware'];
        }

        return $container->services['Shopware\\Core\\Framework\\Store\\Services\\ShopSecretInvalidMiddleware'] = new \Shopware\Core\Framework\Store\Services\ShopSecretInvalidMiddleware(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), $a);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Services\StoreSessionExpiredMiddleware' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Services\StoreSessionExpiredMiddleware
     */
    protected static function getStoreSessionExpiredMiddlewareService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Store\\Services\\StoreSessionExpiredMiddleware'] = new \Shopware\Core\Framework\Store\Services\StoreSessionExpiredMiddleware(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Telemetry\Metrics\Meter' shared service.
     *
     * @return \Shopware\Core\Framework\Telemetry\Metrics\Meter
     */
    protected static function getMeterService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['Shopware\\Core\\Framework\\Telemetry\\Metrics\\Meter'] = $container->createProxy('MeterGhost54923d6', static fn () => \MeterGhost54923d6::createLazyGhost(static fn ($proxy) => self::getMeterService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->privates['Shopware\\Core\\Framework\\Telemetry\\Metrics\\Transport\\TransportCollection'] ?? self::getTransportCollectionService($container)), ($container->privates['Shopware\\Core\\Framework\\Telemetry\\Metrics\\Config\\MetricConfigProvider'] ?? self::getMetricConfigProviderService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)), $container->getEnv('APP_ENV')) && false ?: $lazyLoad);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Update\Api\UpdateController' shared service.
     *
     * @return \Shopware\Core\Framework\Update\Api\UpdateController
     */
    protected static function getUpdateControllerService($container)
    {
        $a = ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container));
        $b = ($container->privates['Shopware\\Core\\Framework\\Store\\Services\\StoreClient'] ?? self::getStoreClientService($container));
        $c = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        $container->services['Shopware\\Core\\Framework\\Update\\Api\\UpdateController'] = $instance = new \Shopware\Core\Framework\Update\Api\UpdateController(new \Shopware\Core\Framework\Update\Services\ApiClient(($container->privates['http_client.uri_template'] ?? self::getHttpClient_UriTemplateService($container)), true, '6.7.0.0-RC5', \dirname(__DIR__, 4)), new \Shopware\Core\Framework\Update\Checkers\WriteableCheck(new \Shopware\Core\Framework\Update\Services\Filesystem(), \dirname(__DIR__, 4)), new \Shopware\Core\Framework\Update\Checkers\LicenseCheck($a, $b), new \Shopware\Core\Framework\Update\Services\ExtensionCompatibility($b, ($container->privates['Shopware\\Core\\Framework\\Store\\Services\\AbstractExtensionDataProvider'] ?? self::getAbstractExtensionDataProviderService($container)), $c), $c, $a, ($container->privates['Shopware\\Core\\Framework\\Store\\Services\\ExtensionLifecycleService'] ?? self::getExtensionLifecycleServiceService($container)), '6.7.0.0-RC5', $container->getEnv('bool:SHOPWARE_DISABLE_UPDATE_CHECK'));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Util\HtmlSanitizer' shared service.
     *
     * @return \Shopware\Core\Framework\Util\HtmlSanitizer
     */
    protected static function getHtmlSanitizerService($container)
    {
        return $container->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] = new \Shopware\Core\Framework\Util\HtmlSanitizer($container->targetDir.'', true, $container->parameters['shopware.html_sanitizer.sets'], $container->parameters['shopware.html_sanitizer.fields'], true);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Webhook\EventLog\WebhookEventLogDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Webhook\EventLog\WebhookEventLogDefinition
     */
    protected static function getWebhookEventLogDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition'] = $instance = new \Shopware\Core\Framework\Webhook\EventLog\WebhookEventLogDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Webhook\WebhookDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Webhook\WebhookDefinition
     */
    protected static function getWebhookDefinitionService($container)
    {
        $container->services['Shopware\\Core\\Framework\\Webhook\\WebhookDefinition'] = $instance = new \Shopware\Core\Framework\Webhook\WebhookDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Maintenance\SalesChannel\Service\SalesChannelCreator' shared service.
     *
     * @return \Shopware\Core\Maintenance\SalesChannel\Service\SalesChannelCreator
     */
    protected static function getSalesChannelCreatorService($container)
    {
        return $container->services['Shopware\\Core\\Maintenance\\SalesChannel\\Service\\SalesChannelCreator'] = new \Shopware\Core\Maintenance\SalesChannel\Service\SalesChannelCreator(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->services['sales_channel.repository'] ?? self::getSalesChannel_RepositoryService($container)), ($container->services['payment_method.repository'] ?? self::getPaymentMethod_RepositoryService($container)), ($container->services['shipping_method.repository'] ?? self::getShippingMethod_RepositoryService($container)), ($container->services['country.repository'] ?? self::getCountry_RepositoryService($container)), ($container->services['category.repository'] ?? self::getCategory_RepositoryService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Maintenance\User\Service\UserProvisioner' shared service.
     *
     * @return \Shopware\Core\Maintenance\User\Service\UserProvisioner
     */
    protected static function getUserProvisionerService($container)
    {
        return $container->services['Shopware\\Core\\Maintenance\\User\\Service\\UserProvisioner'] = new \Shopware\Core\Maintenance\User\Service\UserProvisioner(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\Profiling\Profiler' shared service.
     *
     * @return \Shopware\Core\Profiling\Profiler
     */
    protected static function getProfilerService($container)
    {
        return $container->services['Shopware\\Core\\Profiling\\Profiler'] = new \Shopware\Core\Profiling\Profiler(new RewindableGenerator(function () use ($container) {
            yield 'Symfony' => ($container->privates['Shopware\\Core\\Profiling\\Integration\\Stopwatch'] ?? self::getStopwatchService($container));
            yield 'Tideways' => ($container->privates['Shopware\\Core\\Profiling\\Integration\\Tideways'] ??= new \Shopware\Core\Profiling\Integration\Tideways());
            yield 'Datadog' => ($container->privates['Shopware\\Core\\Profiling\\Integration\\Datadog'] ??= new \Shopware\Core\Profiling\Integration\Datadog());
            yield 'ServerTiming' => ($container->privates['Shopware\\Core\\Profiling\\Integration\\ServerTiming'] ??= new \Shopware\Core\Profiling\Integration\ServerTiming());
        }, 4), []);
    }

    /*
     * Gets the public 'Shopware\Core\Service\Api\ServiceController' shared service.
     *
     * @return \Shopware\Core\Service\Api\ServiceController
     */
    protected static function getServiceControllerService($container)
    {
        return $container->services['Shopware\\Core\\Service\\Api\\ServiceController'] = new \Shopware\Core\Service\Api\ServiceController(($container->services['app.repository'] ?? self::getApp_RepositoryService($container)), ($container->services['messenger.default_bus'] ?? self::getMessenger_DefaultBusService($container)), ($container->privates['Shopware\\Core\\Framework\\App\\AppStateService'] ?? self::getAppStateServiceService($container)), ($container->privates['Shopware\\Core\\Framework\\App\\Lifecycle\\AppLifecycle'] ?? self::getAppLifecycleService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\Aggregate\CountryStateTranslation\CountryStateTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\Aggregate\CountryStateTranslation\CountryStateTranslationDefinition
     */
    protected static function getCountryStateTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition'] = $instance = new \Shopware\Core\System\Country\Aggregate\CountryStateTranslation\CountryStateTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\Aggregate\CountryState\CountryStateDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\Aggregate\CountryState\CountryStateDefinition
     */
    protected static function getCountryStateDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\CountryStateDefinition'] = $instance = new \Shopware\Core\System\Country\Aggregate\CountryState\CountryStateDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\Aggregate\CountryState\SalesChannel\SalesChannelCountryStateDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\Aggregate\CountryState\SalesChannel\SalesChannelCountryStateDefinition
     */
    protected static function getSalesChannelCountryStateDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition'] = $instance = new \Shopware\Core\System\Country\Aggregate\CountryState\SalesChannel\SalesChannelCountryStateDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\Aggregate\CountryTranslation\CountryTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\Aggregate\CountryTranslation\CountryTranslationDefinition
     */
    protected static function getCountryTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition'] = $instance = new \Shopware\Core\System\Country\Aggregate\CountryTranslation\CountryTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\CountryDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\CountryDefinition
     */
    protected static function getCountryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Country\\CountryDefinition'] = $instance = new \Shopware\Core\System\Country\CountryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\SalesChannel\CountryRoute' shared service.
     *
     * @return \Shopware\Core\System\Country\SalesChannel\CountryRoute
     */
    protected static function getCountryRouteService($container)
    {
        return $container->services['Shopware\\Core\\System\\Country\\SalesChannel\\CountryRoute'] = new \Shopware\Core\System\Country\SalesChannel\CountryRoute(($container->services['sales_channel.country.repository'] ?? self::getSalesChannel_Country_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\SalesChannel\CountryStateRoute' shared service.
     *
     * @return \Shopware\Core\System\Country\SalesChannel\CountryStateRoute
     */
    protected static function getCountryStateRouteService($container)
    {
        return $container->services['Shopware\\Core\\System\\Country\\SalesChannel\\CountryStateRoute'] = new \Shopware\Core\System\Country\SalesChannel\CountryStateRoute(($container->services['country_state.repository'] ?? self::getCountryState_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\SalesChannel\SalesChannelCountryDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\SalesChannel\SalesChannelCountryDefinition
     */
    protected static function getSalesChannelCountryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition'] = $instance = new \Shopware\Core\System\Country\SalesChannel\SalesChannelCountryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\Aggregate\CurrencyCountryRounding\CurrencyCountryRoundingDefinition' shared service.
     *
     * @return \Shopware\Core\System\Currency\Aggregate\CurrencyCountryRounding\CurrencyCountryRoundingDefinition
     */
    protected static function getCurrencyCountryRoundingDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition'] = $instance = new \Shopware\Core\System\Currency\Aggregate\CurrencyCountryRounding\CurrencyCountryRoundingDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\Aggregate\CurrencyTranslation\CurrencyTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Currency\Aggregate\CurrencyTranslation\CurrencyTranslationDefinition
     */
    protected static function getCurrencyTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition'] = $instance = new \Shopware\Core\System\Currency\Aggregate\CurrencyTranslation\CurrencyTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\CurrencyDefinition' shared service.
     *
     * @return \Shopware\Core\System\Currency\CurrencyDefinition
     */
    protected static function getCurrencyDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Currency\\CurrencyDefinition'] = $instance = new \Shopware\Core\System\Currency\CurrencyDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\CurrencyFormatter' shared service.
     *
     * @return \Shopware\Core\System\Currency\CurrencyFormatter
     */
    protected static function getCurrencyFormatterService($container)
    {
        return $container->services['Shopware\\Core\\System\\Currency\\CurrencyFormatter'] = new \Shopware\Core\System\Currency\CurrencyFormatter(($container->privates['Shopware\\Core\\System\\Locale\\LanguageLocaleCodeProvider'] ?? self::getLanguageLocaleCodeProviderService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\SalesChannel\CurrencyRoute' shared service.
     *
     * @return \Shopware\Core\System\Currency\SalesChannel\CurrencyRoute
     */
    protected static function getCurrencyRouteService($container)
    {
        return $container->services['Shopware\\Core\\System\\Currency\\SalesChannel\\CurrencyRoute'] = new \Shopware\Core\System\Currency\SalesChannel\CurrencyRoute(($container->services['sales_channel.currency.repository'] ?? self::getSalesChannel_Currency_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\SalesChannel\SalesChannelCurrencyDefinition' shared service.
     *
     * @return \Shopware\Core\System\Currency\SalesChannel\SalesChannelCurrencyDefinition
     */
    protected static function getSalesChannelCurrencyDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition'] = $instance = new \Shopware\Core\System\Currency\SalesChannel\SalesChannelCurrencyDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomEntity\Api\CustomEntityApiController' shared service.
     *
     * @return \Shopware\Core\System\CustomEntity\Api\CustomEntityApiController
     */
    protected static function getCustomEntityApiControllerService($container)
    {
        $container->services['Shopware\\Core\\System\\CustomEntity\\Api\\CustomEntityApiController'] = $instance = new \Shopware\Core\System\CustomEntity\Api\CustomEntityApiController(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['serializer'] ?? self::getSerializerService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? self::getRequestCriteriaBuilderService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\EntityProtection\\EntityProtectionValidator'] ?? self::getEntityProtectionValidatorService($container)), ($container->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] ?? self::getAclCriteriaValidatorService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomEntity\CustomEntityDefinition' shared service.
     *
     * @return \Shopware\Core\System\CustomEntity\CustomEntityDefinition
     */
    protected static function getCustomEntityDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition'] = $instance = new \Shopware\Core\System\CustomEntity\CustomEntityDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomEntity\CustomEntityRegistrar' shared service.
     *
     * @return \Shopware\Core\System\CustomEntity\CustomEntityRegistrar
     */
    protected static function getCustomEntityRegistrarService($container)
    {
        return $container->services['Shopware\\Core\\System\\CustomEntity\\CustomEntityRegistrar'] = new \Shopware\Core\System\CustomEntity\CustomEntityRegistrar($container);
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomEntity\Schema\CustomEntitySchemaUpdater' shared service.
     *
     * @return \Shopware\Core\System\CustomEntity\Schema\CustomEntitySchemaUpdater
     */
    protected static function getCustomEntitySchemaUpdaterService($container)
    {
        return $container->services['Shopware\\Core\\System\\CustomEntity\\Schema\\CustomEntitySchemaUpdater'] = new \Shopware\Core\System\CustomEntity\Schema\CustomEntitySchemaUpdater(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['lock.default.factory'] ?? self::getLock_Default_FactoryService($container)), new \Shopware\Core\System\CustomEntity\Schema\SchemaUpdater());
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomField\Aggregate\CustomFieldSetRelation\CustomFieldSetRelationDefinition' shared service.
     *
     * @return \Shopware\Core\System\CustomField\Aggregate\CustomFieldSetRelation\CustomFieldSetRelationDefinition
     */
    protected static function getCustomFieldSetRelationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition'] = $instance = new \Shopware\Core\System\CustomField\Aggregate\CustomFieldSetRelation\CustomFieldSetRelationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomField\Aggregate\CustomFieldSet\CustomFieldSetDefinition' shared service.
     *
     * @return \Shopware\Core\System\CustomField\Aggregate\CustomFieldSet\CustomFieldSetDefinition
     */
    protected static function getCustomFieldSetDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition'] = $instance = new \Shopware\Core\System\CustomField\Aggregate\CustomFieldSet\CustomFieldSetDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomField\Api\CustomFieldSetActionController' shared service.
     *
     * @return \Shopware\Core\System\CustomField\Api\CustomFieldSetActionController
     */
    protected static function getCustomFieldSetActionControllerService($container)
    {
        $container->services['Shopware\\Core\\System\\CustomField\\Api\\CustomFieldSetActionController'] = $instance = new \Shopware\Core\System\CustomField\Api\CustomFieldSetActionController(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomField\CustomFieldDefinition' shared service.
     *
     * @return \Shopware\Core\System\CustomField\CustomFieldDefinition
     */
    protected static function getCustomFieldDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\CustomField\\CustomFieldDefinition'] = $instance = new \Shopware\Core\System\CustomField\CustomFieldDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\DeliveryTime\Aggregate\DeliveryTimeTranslation\DeliveryTimeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\DeliveryTime\Aggregate\DeliveryTimeTranslation\DeliveryTimeTranslationDefinition
     */
    protected static function getDeliveryTimeTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition'] = $instance = new \Shopware\Core\System\DeliveryTime\Aggregate\DeliveryTimeTranslation\DeliveryTimeTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\DeliveryTime\DeliveryTimeDefinition' shared service.
     *
     * @return \Shopware\Core\System\DeliveryTime\DeliveryTimeDefinition
     */
    protected static function getDeliveryTimeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition'] = $instance = new \Shopware\Core\System\DeliveryTime\DeliveryTimeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Integration\Aggregate\IntegrationRole\IntegrationRoleDefinition' shared service.
     *
     * @return \Shopware\Core\System\Integration\Aggregate\IntegrationRole\IntegrationRoleDefinition
     */
    protected static function getIntegrationRoleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition'] = $instance = new \Shopware\Core\System\Integration\Aggregate\IntegrationRole\IntegrationRoleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Integration\IntegrationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Integration\IntegrationDefinition
     */
    protected static function getIntegrationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Integration\\IntegrationDefinition'] = $instance = new \Shopware\Core\System\Integration\IntegrationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
        $instance->addExtension(new \Shopware\Core\Framework\DataAbstractionLayer\FilteredBulkEntityExtension('integration', ($container->privates['Shopware\\Administration\\Notification\\NotificationBulkEntityExtension'] ??= new \Shopware\Administration\Notification\NotificationBulkEntityExtension())));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Language\LanguageDefinition' shared service.
     *
     * @return \Shopware\Core\System\Language\LanguageDefinition
     */
    protected static function getLanguageDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Language\\LanguageDefinition'] = $instance = new \Shopware\Core\System\Language\LanguageDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
        $instance->addExtension(($container->privates['Shopware\\Storefront\\Theme\\Extension\\LanguageExtension'] ??= new \Shopware\Storefront\Theme\Extension\LanguageExtension()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Language\SalesChannel\LanguageRoute' shared service.
     *
     * @return \Shopware\Core\System\Language\SalesChannel\LanguageRoute
     */
    protected static function getLanguageRouteService($container)
    {
        return $container->services['Shopware\\Core\\System\\Language\\SalesChannel\\LanguageRoute'] = new \Shopware\Core\System\Language\SalesChannel\LanguageRoute(($container->services['sales_channel.language.repository'] ?? self::getSalesChannel_Language_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\Language\SalesChannel\SalesChannelLanguageDefinition' shared service.
     *
     * @return \Shopware\Core\System\Language\SalesChannel\SalesChannelLanguageDefinition
     */
    protected static function getSalesChannelLanguageDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition'] = $instance = new \Shopware\Core\System\Language\SalesChannel\SalesChannelLanguageDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));
        $instance->addExtension(($container->privates['Shopware\\Storefront\\Theme\\Extension\\LanguageExtension'] ??= new \Shopware\Storefront\Theme\Extension\LanguageExtension()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Locale\Aggregate\LocaleTranslation\LocaleTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Locale\Aggregate\LocaleTranslation\LocaleTranslationDefinition
     */
    protected static function getLocaleTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition'] = $instance = new \Shopware\Core\System\Locale\Aggregate\LocaleTranslation\LocaleTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Locale\LocaleDefinition' shared service.
     *
     * @return \Shopware\Core\System\Locale\LocaleDefinition
     */
    protected static function getLocaleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Locale\\LocaleDefinition'] = $instance = new \Shopware\Core\System\Locale\LocaleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeSalesChannel\NumberRangeSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeSalesChannel\NumberRangeSalesChannelDefinition
     */
    protected static function getNumberRangeSalesChannelDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeSalesChannel\NumberRangeSalesChannelDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeState\NumberRangeStateDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeState\NumberRangeStateDefinition
     */
    protected static function getNumberRangeStateDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeState\NumberRangeStateDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeTranslation\NumberRangeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeTranslation\NumberRangeTranslationDefinition
     */
    protected static function getNumberRangeTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeTranslation\NumberRangeTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeTypeTranslation\NumberRangeTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeTypeTranslation\NumberRangeTypeTranslationDefinition
     */
    protected static function getNumberRangeTypeTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeTypeTranslation\NumberRangeTypeTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeType\NumberRangeTypeDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeType\NumberRangeTypeDefinition
     */
    protected static function getNumberRangeTypeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeType\NumberRangeTypeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Api\NumberRangeController' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Api\NumberRangeController
     */
    protected static function getNumberRangeControllerService($container)
    {
        $container->services['Shopware\\Core\\System\\NumberRange\\Api\\NumberRangeController'] = $instance = new \Shopware\Core\System\NumberRange\Api\NumberRangeController(($container->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'] ?? self::getNumberRangeValueGeneratorInterfaceService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\NumberRangeDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\NumberRangeDefinition
     */
    protected static function getNumberRangeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition'] = $instance = new \Shopware\Core\System\NumberRange\NumberRangeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\ValueGenerator\NumberRangeValueGeneratorInterface' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\ValueGenerator\NumberRangeValueGenerator
     */
    protected static function getNumberRangeValueGeneratorInterfaceService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'])) {
            return $container->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'];
        }

        return $container->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'] = new \Shopware\Core\System\NumberRange\ValueGenerator\NumberRangeValueGenerator(new \Shopware\Core\System\NumberRange\ValueGenerator\Pattern\ValueGeneratorPatternRegistry(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\Pattern\\ValueGeneratorPatternIncrement'] ?? self::getValueGeneratorPatternIncrementService($container));
            yield 1 => ($container->privates['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\Pattern\\ValueGeneratorPatternDate'] ??= new \Shopware\Core\System\NumberRange\ValueGenerator\Pattern\ValueGeneratorPatternDate());
        }, 2)), $a, ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelAnalytics\SalesChannelAnalyticsDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelAnalytics\SalesChannelAnalyticsDefinition
     */
    protected static function getSalesChannelAnalyticsDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelAnalytics\SalesChannelAnalyticsDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCountry\SalesChannelCountryDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCountry\SalesChannelCountryDefinition
     */
    protected static function getSalesChannelCountryDefinition2Service($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCountry\SalesChannelCountryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCurrency\SalesChannelCurrencyDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCurrency\SalesChannelCurrencyDefinition
     */
    protected static function getSalesChannelCurrencyDefinition2Service($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCurrency\SalesChannelCurrencyDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelDomain\SalesChannelDomainDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelDomain\SalesChannelDomainDefinition
     */
    protected static function getSalesChannelDomainDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelDomain\SalesChannelDomainDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelLanguage\SalesChannelLanguageDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelLanguage\SalesChannelLanguageDefinition
     */
    protected static function getSalesChannelLanguageDefinition2Service($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelLanguage\SalesChannelLanguageDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelPaymentMethod\SalesChannelPaymentMethodDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelPaymentMethod\SalesChannelPaymentMethodDefinition
     */
    protected static function getSalesChannelPaymentMethodDefinition2Service($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelPaymentMethod\SalesChannelPaymentMethodDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelShippingMethod\SalesChannelShippingMethodDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelShippingMethod\SalesChannelShippingMethodDefinition
     */
    protected static function getSalesChannelShippingMethodDefinition2Service($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelShippingMethod\SalesChannelShippingMethodDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTranslation\SalesChannelTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTranslation\SalesChannelTranslationDefinition
     */
    protected static function getSalesChannelTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTranslation\SalesChannelTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTypeTranslation\SalesChannelTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTypeTranslation\SalesChannelTypeTranslationDefinition
     */
    protected static function getSalesChannelTypeTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTypeTranslation\SalesChannelTypeTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelType\SalesChannelTypeDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelType\SalesChannelTypeDefinition
     */
    protected static function getSalesChannelTypeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelType\SalesChannelTypeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Context\SalesChannelContextFactory' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Context\CachedSalesChannelContextFactory
     */
    protected static function getSalesChannelContextFactoryService($container)
    {
        $a = ($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $b = ($container->services['customer_group.repository'] ?? self::getCustomerGroup_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $c = ($container->services['customer_address.repository'] ?? self::getCustomerAddress_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $d = ($container->services['payment_method.repository'] ?? self::getPaymentMethod_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $e = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $f = ($container->services['currency_country_rounding.repository'] ?? self::getCurrencyCountryRounding_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $g = ($container->services['sales_channel.repository'] ?? self::getSalesChannel_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $h = ($container->services['currency.repository'] ?? self::getCurrency_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $i = ($container->services['country.repository'] ?? self::getCountry_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $j = ($container->services['tax.repository'] ?? self::getTax_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $k = ($container->services['shipping_method.repository'] ?? self::getShippingMethod_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $l = ($container->services['country_state.repository'] ?? self::getCountryState_RepositoryService($container));

        if (isset($container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $m = ($container->privates['cache.object'] ?? self::getCache_ObjectService($container));

        return $container->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'] = new \Shopware\Core\System\SalesChannel\Context\CachedSalesChannelContextFactory(new \Shopware\Core\System\SalesChannel\Context\SalesChannelContextFactory($a, $b, $c, $d, ($container->privates['Shopware\\Core\\Checkout\\Cart\\Tax\\TaxDetector'] ??= new \Shopware\Core\Checkout\Cart\Tax\TaxDetector()), new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\EntireCountryRuleTypeFilter'] ??= new \Shopware\Core\System\Tax\TaxRuleType\EntireCountryRuleTypeFilter());
            yield 1 => ($container->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\IndividualStatesRuleTypeFilter'] ??= new \Shopware\Core\System\Tax\TaxRuleType\IndividualStatesRuleTypeFilter());
            yield 2 => ($container->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\ZipCodeRangeRuleTypeFilter'] ??= new \Shopware\Core\System\Tax\TaxRuleType\ZipCodeRangeRuleTypeFilter());
            yield 3 => ($container->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\ZipCodeRuleTypeFilter'] ??= new \Shopware\Core\System\Tax\TaxRuleType\ZipCodeRuleTypeFilter());
        }, 4), $e, $f, new \Shopware\Core\System\SalesChannel\Context\CachedBaseSalesChannelContextFactory(new \Shopware\Core\System\SalesChannel\Context\BaseSalesChannelContextFactory($g, $h, $b, $i, $j, $d, $k, $l, $f, new \Shopware\Core\System\SalesChannel\Context\ContextFactory(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), $e)), $m)), $m);
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Entity\SalesChannelDefinitionInstanceRegistry' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Entity\SalesChannelDefinitionInstanceRegistry
     */
    protected static function getSalesChannelDefinitionInstanceRegistryService($container)
    {
        return $container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] = new \Shopware\Core\System\SalesChannel\Entity\SalesChannelDefinitionInstanceRegistry('sales_channel_definition.', $container, ['log_entry' => 'Shopware\\Core\\Framework\\Log\\LogEntryDefinition', 'acl_role' => 'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition', 'acl_user_role' => 'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition', 'app' => 'Shopware\\Core\\Framework\\App\\AppDefinition', 'app_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition', 'app_action_button' => 'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition', 'app_action_button_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition', 'app_template' => 'Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition', 'app_payment_method' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition', 'app_script_condition' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition', 'app_script_condition_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition', 'app_cms_block' => 'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition', 'app_cms_block_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition', 'app_flow_action' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition', 'app_flow_action_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition', 'app_flow_event' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowEvent\\AppFlowEventDefinition', 'app_shipping_method' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppShippingMethod\\AppShippingMethodDefinition', 'custom_field' => 'Shopware\\Core\\System\\CustomField\\CustomFieldDefinition', 'custom_field_set' => 'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition', 'custom_field_set_relation' => 'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition', 'version' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition', 'version_commit' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition', 'version_commit_data' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition', 'plugin' => 'Shopware\\Core\\Framework\\Plugin\\PluginDefinition', 'plugin_translation' => 'Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition', 'scheduled_task' => 'Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition', 'script' => 'Shopware\\Core\\Framework\\Script\\ScriptDefinition', 'language' => 'Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition', 'seo_url' => 'Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition', 'seo_url_template' => 'Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition', 'main_category' => 'Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition', 'webhook' => 'Shopware\\Core\\Framework\\Webhook\\WebhookDefinition', 'webhook_event_log' => 'Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition', 'sales_channel' => 'Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition', 'sales_channel_translation' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition', 'sales_channel_country' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition', 'sales_channel_currency' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition', 'sales_channel_domain' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition', 'sales_channel_language' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition', 'sales_channel_payment_method' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition', 'sales_channel_shipping_method' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition', 'sales_channel_type' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition', 'sales_channel_type_translation' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition', 'sales_channel_analytics' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition', 'country' => 'Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition', 'country_state' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition', 'country_state_translation' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition', 'country_translation' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition', 'currency' => 'Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition', 'currency_country_rounding' => 'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition', 'currency_translation' => 'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition', 'custom_entity' => 'Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition', 'locale' => 'Shopware\\Core\\System\\Locale\\LocaleDefinition', 'locale_translation' => 'Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition', 'snippet_set' => 'Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition', 'snippet' => 'Shopware\\Core\\System\\Snippet\\SnippetDefinition', 'salutation' => 'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition', 'salutation_translation' => 'Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition', 'tax' => 'Shopware\\Core\\System\\Tax\\TaxDefinition', 'tax_rule' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition', 'tax_rule_type' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition', 'tax_rule_type_translation' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition', 'tax_provider' => 'Shopware\\Core\\System\\TaxProvider\\TaxProviderDefinition', 'tax_provider_translation' => 'Shopware\\Core\\System\\TaxProvider\\Aggregate\\TaxProviderTranslation\\TaxProviderTranslationDefinition', 'unit' => 'Shopware\\Core\\System\\Unit\\UnitDefinition', 'unit_translation' => 'Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition', 'user' => 'Shopware\\Core\\System\\User\\UserDefinition', 'user_config' => 'Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition', 'user_access_key' => 'Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition', 'user_recovery' => 'Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition', 'integration' => 'Shopware\\Core\\System\\Integration\\IntegrationDefinition', 'integration_role' => 'Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition', 'state_machine' => 'Shopware\\Core\\System\\StateMachine\\StateMachineDefinition', 'state_machine_translation' => 'Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition', 'state_machine_state' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition', 'state_machine_state_translation' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition', 'state_machine_transition' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition', 'state_machine_history' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition', 'system_config' => 'Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition', 'number_range' => 'Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition', 'number_range_sales_channel' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition', 'number_range_state' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition', 'number_range_type' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition', 'number_range_type_translation' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition', 'number_range_translation' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition', 'tag' => 'Shopware\\Core\\System\\Tag\\TagDefinition', 'category' => 'Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition', 'category_translation' => 'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition', 'category_tag' => 'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition', 'media' => 'Shopware\\Core\\Content\\Media\\MediaDefinition', 'media_default_folder' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition', 'media_thumbnail' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition', 'media_translation' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition', 'media_folder' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition', 'media_thumbnail_size' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition', 'media_folder_configuration' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition', 'media_folder_configuration_media_thumbnail_size' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition', 'media_tag' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition', 'product' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition', 'product_stream_mapping' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition', 'product_category' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition', 'product_custom_field_set' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition', 'product_tag' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition', 'product_configurator_setting' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition', 'product_price' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition', 'product_property' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition', 'product_search_keyword' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition', 'product_keyword_dictionary' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition', 'product_review' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition', 'product_manufacturer' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition', 'product_manufacturer_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition', 'product_media' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition', 'product_download' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductDownload\\ProductDownloadDefinition', 'product_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition', 'product_option' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition', 'product_category_tree' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition', 'product_cross_selling' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition', 'product_cross_selling_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition', 'product_cross_selling_assigned_products' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition', 'product_feature_set' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition', 'product_feature_set_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition', 'product_sorting' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition', 'product_sorting_translation' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition', 'product_search_config' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition', 'product_search_config_field' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition', 'product_visibility' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition', 'delivery_time' => 'Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition', 'newsletter_recipient' => 'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition', 'newsletter_recipient_tag' => 'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition', 'rule' => 'Shopware\\Core\\Content\\Rule\\RuleDefinition', 'rule_condition' => 'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition', 'rule_tag' => 'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition', 'product_stream' => 'Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition', 'product_stream_translation' => 'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition', 'product_stream_filter' => 'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition', 'product_export' => 'Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition', 'property_group' => 'Shopware\\Core\\Content\\Property\\PropertyGroupDefinition', 'property_group_option' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition', 'property_group_option_translation' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition', 'property_group_translation' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition', 'cms_page' => 'Shopware\\Core\\Content\\Cms\\CmsPageDefinition', 'cms_page_translation' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition', 'cms_section' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition', 'cms_block' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition', 'cms_slot' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition', 'cms_slot_translation' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition', 'mail_template' => 'Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition', 'mail_template_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition', 'mail_template_type' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition', 'mail_template_type_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition', 'mail_template_media' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition', 'mail_header_footer' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition', 'mail_header_footer_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition', 'delivery_time_translation' => 'Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition', 'import_export_profile' => 'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition', 'import_export_log' => 'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition', 'import_export_file' => 'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition', 'import_export_profile_translation' => 'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition', 'landing_page' => 'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition', 'landing_page_translation' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition', 'landing_page_tag' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition', 'landing_page_sales_channel' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition', 'flow' => 'Shopware\\Core\\Content\\Flow\\FlowDefinition', 'flow_sequence' => 'Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition', 'flow_template' => 'Shopware\\Core\\Content\\Flow\\Aggregate\\FlowTemplate\\FlowTemplateDefinition', 'customer' => 'Shopware\\Core\\Checkout\\Customer\\CustomerDefinition', 'customer_group_translation' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition', 'customer_address' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition', 'customer_recovery' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition', 'customer_group' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition', 'customer_group_registration_sales_channels' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition', 'customer_tag' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition', 'customer_wishlist' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition', 'customer_wishlist_product' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition', 'document' => 'Shopware\\Core\\Checkout\\Document\\DocumentDefinition', 'document_type' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition', 'document_type_translation' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition', 'document_base_config' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition', 'document_base_config_sales_channel' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition', 'order' => 'Shopware\\Core\\Checkout\\Order\\OrderDefinition', 'order_address' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition', 'order_customer' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition', 'order_delivery' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition', 'order_delivery_position' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition', 'order_line_item' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition', 'order_line_item_download' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItemDownload\\OrderLineItemDownloadDefinition', 'order_tag' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition', 'order_transaction' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition', 'order_transaction_capture' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition', 'order_transaction_capture_refund' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition', 'order_transaction_capture_refund_position' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition', 'payment_method' => 'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition', 'payment_method_translation' => 'Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition', 'promotion' => 'Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition', 'promotion_sales_channel' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition', 'promotion_individual_code' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition', 'promotion_discount' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition', 'promotion_discount_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition', 'promotion_setgroup' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition', 'promotion_setgroup_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition', 'promotion_order_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition', 'promotion_persona_customer' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition', 'promotion_persona_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition', 'promotion_cart_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition', 'promotion_translation' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition', 'promotion_discount_prices' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition', 'shipping_method' => 'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition', 'shipping_method_tag' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition', 'shipping_method_price' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition', 'shipping_method_translation' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition', 'app_administration_snippet' => 'Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition', 'notification' => 'Shopware\\Administration\\Notification\\NotificationDefinition', 'theme' => 'Shopware\\Storefront\\Theme\\ThemeDefinition', 'theme_translation' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition', 'theme_sales_channel' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition', 'theme_media' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition', 'theme_child' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition'], ['language' => 'sales_channel.language.repository', 'seo_url' => 'sales_channel.seo_url.repository', 'main_category' => 'sales_channel.main_category.repository', 'country' => 'sales_channel.country.repository', 'country_state' => 'sales_channel.country_state.repository', 'currency' => 'sales_channel.currency.repository', 'salutation' => 'sales_channel.salutation.repository', 'category' => 'sales_channel.category.repository', 'product' => 'sales_channel.product.repository', 'newsletter_recipient' => 'sales_channel.newsletter_recipient.repository', 'landing_page' => 'sales_channel.landing_page.repository', 'payment_method' => 'sales_channel.payment_method.repository', 'shipping_method' => 'sales_channel.shipping_method.repository']);
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\SalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\SalesChannelDefinition
     */
    protected static function getSalesChannelDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\SalesChannelDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
        $instance->addExtension(($container->privates['Shopware\\Storefront\\Theme\\Extension\\SalesChannelExtension'] ??= new \Shopware\Storefront\Theme\Extension\SalesChannelExtension()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\SalesChannel\ContextRoute' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\SalesChannel\ContextRoute
     */
    protected static function getContextRouteService($container)
    {
        return $container->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextRoute'] = new \Shopware\Core\System\SalesChannel\SalesChannel\ContextRoute();
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\SalesChannel\ContextSwitchRoute' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\SalesChannel\ContextSwitchRoute
     */
    protected static function getContextSwitchRouteService($container)
    {
        return $container->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextSwitchRoute'] = new \Shopware\Core\System\SalesChannel\SalesChannel\ContextSwitchRoute(($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? self::getSalesChannelContextPersisterService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\SalesChannel\StoreApiInfoController' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\SalesChannel\StoreApiInfoController
     */
    protected static function getStoreApiInfoControllerService($container)
    {
        return $container->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\StoreApiInfoController'] = new \Shopware\Core\System\SalesChannel\SalesChannel\StoreApiInfoController(($container->privates['Shopware\\Core\\Framework\\Api\\ApiDefinition\\DefinitionService'] ?? self::getDefinitionServiceService($container)), ($container->services['twig'] ?? self::getTwigService($container)), $container->parameters['shopware.security.csp_templates'], ($container->privates['Shopware\\Core\\Framework\\Api\\Route\\ApiRouteInfoResolver'] ?? self::getApiRouteInfoResolverService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\Salutation\Aggregate\SalutationTranslation\SalutationTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Salutation\Aggregate\SalutationTranslation\SalutationTranslationDefinition
     */
    protected static function getSalutationTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition'] = $instance = new \Shopware\Core\System\Salutation\Aggregate\SalutationTranslation\SalutationTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Salutation\SalesChannel\SalesChannelSalutationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Salutation\SalesChannel\SalesChannelSalutationDefinition
     */
    protected static function getSalesChannelSalutationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition'] = $instance = new \Shopware\Core\System\Salutation\SalesChannel\SalesChannelSalutationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? self::getSalesChannelDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Salutation\SalesChannel\SalutationRoute' shared service.
     *
     * @return \Shopware\Core\System\Salutation\SalesChannel\SalutationRoute
     */
    protected static function getSalutationRouteService($container)
    {
        return $container->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\SalutationRoute'] = new \Shopware\Core\System\Salutation\SalesChannel\SalutationRoute(($container->services['sales_channel.salutation.repository'] ?? self::getSalesChannel_Salutation_RepositoryService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\Salutation\SalutationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Salutation\SalutationDefinition
     */
    protected static function getSalutationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Salutation\\SalutationDefinition'] = $instance = new \Shopware\Core\System\Salutation\SalutationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\Aggregate\SnippetSet\SnippetSetDefinition' shared service.
     *
     * @return \Shopware\Core\System\Snippet\Aggregate\SnippetSet\SnippetSetDefinition
     */
    protected static function getSnippetSetDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition'] = $instance = new \Shopware\Core\System\Snippet\Aggregate\SnippetSet\SnippetSetDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\Api\SnippetController' shared service.
     *
     * @return \Shopware\Core\System\Snippet\Api\SnippetController
     */
    protected static function getSnippetControllerService($container)
    {
        $container->services['Shopware\\Core\\System\\Snippet\\Api\\SnippetController'] = $instance = new \Shopware\Core\System\Snippet\Api\SnippetController(($container->privates['Shopware\\Core\\System\\Snippet\\SnippetService'] ?? self::getSnippetServiceService($container)), ($container->services['Shopware\\Core\\System\\Snippet\\Files\\SnippetFileCollection'] ?? self::getSnippetFileCollectionService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\Files\SnippetFileCollection' shared service.
     *
     * @return \Shopware\Core\System\Snippet\Files\SnippetFileCollection
     */
    protected static function getSnippetFileCollectionService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['Shopware\\Core\\System\\Snippet\\Files\\SnippetFileCollection'] = $container->createProxy('SnippetFileCollectionProxy685ae73', static fn () => \SnippetFileCollectionProxy685ae73::createLazyProxy(static fn () => self::getSnippetFileCollectionService($container, false)));
        }

        return ($container->privates['Shopware\\Core\\System\\Snippet\\Files\\SnippetFileCollectionFactory'] ?? self::getSnippetFileCollectionFactoryService($container))->createSnippetFileCollection();
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\Filter\SnippetFilterFactory' shared service.
     *
     * @return \Shopware\Core\System\Snippet\Filter\SnippetFilterFactory
     */
    protected static function getSnippetFilterFactoryService($container)
    {
        return $container->services['Shopware\\Core\\System\\Snippet\\Filter\\SnippetFilterFactory'] = new \Shopware\Core\System\Snippet\Filter\SnippetFilterFactory(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Core\\System\\Snippet\\Filter\\AuthorFilter'] ??= new \Shopware\Core\System\Snippet\Filter\AuthorFilter());
            yield 1 => ($container->privates['Shopware\\Core\\System\\Snippet\\Filter\\AddedFilter'] ??= new \Shopware\Core\System\Snippet\Filter\AddedFilter());
            yield 2 => ($container->privates['Shopware\\Core\\System\\Snippet\\Filter\\EditedFilter'] ??= new \Shopware\Core\System\Snippet\Filter\EditedFilter());
            yield 3 => ($container->privates['Shopware\\Core\\System\\Snippet\\Filter\\EmptySnippetFilter'] ??= new \Shopware\Core\System\Snippet\Filter\EmptySnippetFilter());
            yield 4 => ($container->privates['Shopware\\Core\\System\\Snippet\\Filter\\NamespaceFilter'] ??= new \Shopware\Core\System\Snippet\Filter\NamespaceFilter());
            yield 5 => ($container->privates['Shopware\\Core\\System\\Snippet\\Filter\\TermFilter'] ??= new \Shopware\Core\System\Snippet\Filter\TermFilter());
            yield 6 => ($container->privates['Shopware\\Core\\System\\Snippet\\Filter\\TranslationKeyFilter'] ??= new \Shopware\Core\System\Snippet\Filter\TranslationKeyFilter());
        }, 7));
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\SnippetDefinition' shared service.
     *
     * @return \Shopware\Core\System\Snippet\SnippetDefinition
     */
    protected static function getSnippetDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Snippet\\SnippetDefinition'] = $instance = new \Shopware\Core\System\Snippet\SnippetDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Aggregation\StateMachineHistory\StateMachineHistoryDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Aggregation\StateMachineHistory\StateMachineHistoryDefinition
     */
    protected static function getStateMachineHistoryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition'] = $instance = new \Shopware\Core\System\StateMachine\Aggregation\StateMachineHistory\StateMachineHistoryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateDefinition
     */
    protected static function getStateMachineStateDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition'] = $instance = new \Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateTranslationDefinition
     */
    protected static function getStateMachineStateTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition'] = $instance = new \Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Aggregation\StateMachineTransition\StateMachineTransitionDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Aggregation\StateMachineTransition\StateMachineTransitionDefinition
     */
    protected static function getStateMachineTransitionDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition'] = $instance = new \Shopware\Core\System\StateMachine\Aggregation\StateMachineTransition\StateMachineTransitionDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Api\StateMachineActionController' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Api\StateMachineActionController
     */
    protected static function getStateMachineActionControllerService($container)
    {
        $container->services['Shopware\\Core\\System\\StateMachine\\Api\\StateMachineActionController'] = $instance = new \Shopware\Core\System\StateMachine\Api\StateMachineActionController(($container->privates['Shopware\\Core\\System\\StateMachine\\StateMachineRegistry'] ?? self::getStateMachineRegistryService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\StateMachineDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\StateMachineDefinition
     */
    protected static function getStateMachineDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\StateMachine\\StateMachineDefinition'] = $instance = new \Shopware\Core\System\StateMachine\StateMachineDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\StateMachineTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\StateMachineTranslationDefinition
     */
    protected static function getStateMachineTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition'] = $instance = new \Shopware\Core\System\StateMachine\StateMachineTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SystemConfig\Api\SystemConfigController' shared service.
     *
     * @return \Shopware\Core\System\SystemConfig\Api\SystemConfigController
     */
    protected static function getSystemConfigControllerService($container)
    {
        $a = ($container->privates['Shopware\\Core\\System\\SystemConfig\\Service\\ConfigurationService'] ?? self::getConfigurationServiceService($container));

        $container->services['Shopware\\Core\\System\\SystemConfig\\Api\\SystemConfigController'] = $instance = new \Shopware\Core\System\SystemConfig\Api\SystemConfigController($a, ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), new \Shopware\Core\System\SystemConfig\Validation\SystemConfigValidator($a, ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SystemConfig\Facade\SystemConfigFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\System\SystemConfig\Facade\SystemConfigFacadeHookFactory
     */
    protected static function getSystemConfigFacadeHookFactoryService($container)
    {
        return $container->services['Shopware\\Core\\System\\SystemConfig\\Facade\\SystemConfigFacadeHookFactory'] = new \Shopware\Core\System\SystemConfig\Facade\SystemConfigFacadeHookFactory(($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\SystemConfig\SystemConfigDefinition' shared service.
     *
     * @return \Shopware\Core\System\SystemConfig\SystemConfigDefinition
     */
    protected static function getSystemConfigDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition'] = $instance = new \Shopware\Core\System\SystemConfig\SystemConfigDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SystemConfig\SystemConfigService' shared service.
     *
     * @return \Shopware\Core\System\SystemConfig\SystemConfigService
     */
    protected static function getSystemConfigServiceService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] = $container->createProxy('SystemConfigServiceGhost3f5cc89', static fn () => \SystemConfigServiceGhost3f5cc89::createLazyGhost(static fn ($proxy) => self::getSystemConfigServiceService($container, $proxy)));
        }

        return ($lazyLoad->__construct(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['Shopware\\Core\\System\\SystemConfig\\Util\\ConfigReader'] ??= new \Shopware\Core\System\SystemConfig\Util\ConfigReader()), ($container->privates['Shopware\\Core\\System\\SystemConfig\\MemoizedSystemConfigLoader'] ?? self::getMemoizedSystemConfigLoaderService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\System\\SystemConfig\\SymfonySystemConfigService'] ?? self::getSymfonySystemConfigServiceService($container))) && false ?: $lazyLoad);
    }

    /*
     * Gets the public 'Shopware\Core\System\Tag\Service\FilterTagIdsService' shared service.
     *
     * @return \Shopware\Core\System\Tag\Service\FilterTagIdsService
     */
    protected static function getFilterTagIdsServiceService($container)
    {
        return $container->services['Shopware\\Core\\System\\Tag\\Service\\FilterTagIdsService'] = new \Shopware\Core\System\Tag\Service\FilterTagIdsService(($container->services['Shopware\\Core\\System\\Tag\\TagDefinition'] ?? self::getTagDefinitionService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), ($container->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\CriteriaQueryBuilder'] ?? self::getCriteriaQueryBuilderService($container)));
    }

    /*
     * Gets the public 'Shopware\Core\System\Tag\TagDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tag\TagDefinition
     */
    protected static function getTagDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Tag\\TagDefinition'] = $instance = new \Shopware\Core\System\Tag\TagDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\TaxProvider\Aggregate\TaxProviderTranslation\TaxProviderTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\TaxProvider\Aggregate\TaxProviderTranslation\TaxProviderTranslationDefinition
     */
    protected static function getTaxProviderTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\TaxProvider\\Aggregate\\TaxProviderTranslation\\TaxProviderTranslationDefinition'] = $instance = new \Shopware\Core\System\TaxProvider\Aggregate\TaxProviderTranslation\TaxProviderTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\TaxProvider\TaxProviderDefinition' shared service.
     *
     * @return \Shopware\Core\System\TaxProvider\TaxProviderDefinition
     */
    protected static function getTaxProviderDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\TaxProvider\\TaxProviderDefinition'] = $instance = new \Shopware\Core\System\TaxProvider\TaxProviderDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Tax\Aggregate\TaxRuleTypeTranslation\TaxRuleTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tax\Aggregate\TaxRuleTypeTranslation\TaxRuleTypeTranslationDefinition
     */
    protected static function getTaxRuleTypeTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition'] = $instance = new \Shopware\Core\System\Tax\Aggregate\TaxRuleTypeTranslation\TaxRuleTypeTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Tax\Aggregate\TaxRuleType\TaxRuleTypeDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tax\Aggregate\TaxRuleType\TaxRuleTypeDefinition
     */
    protected static function getTaxRuleTypeDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition'] = $instance = new \Shopware\Core\System\Tax\Aggregate\TaxRuleType\TaxRuleTypeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Tax\Aggregate\TaxRule\TaxRuleDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tax\Aggregate\TaxRule\TaxRuleDefinition
     */
    protected static function getTaxRuleDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition'] = $instance = new \Shopware\Core\System\Tax\Aggregate\TaxRule\TaxRuleDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Tax\TaxDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tax\TaxDefinition
     */
    protected static function getTaxDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Tax\\TaxDefinition'] = $instance = new \Shopware\Core\System\Tax\TaxDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Unit\Aggregate\UnitTranslation\UnitTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Unit\Aggregate\UnitTranslation\UnitTranslationDefinition
     */
    protected static function getUnitTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition'] = $instance = new \Shopware\Core\System\Unit\Aggregate\UnitTranslation\UnitTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Unit\UnitDefinition' shared service.
     *
     * @return \Shopware\Core\System\Unit\UnitDefinition
     */
    protected static function getUnitDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\Unit\\UnitDefinition'] = $instance = new \Shopware\Core\System\Unit\UnitDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\UsageData\Api\ConsentController' shared service.
     *
     * @return \Shopware\Core\System\UsageData\Api\ConsentController
     */
    protected static function getConsentControllerService($container)
    {
        $container->services['Shopware\\Core\\System\\UsageData\\Api\\ConsentController'] = $instance = new \Shopware\Core\System\UsageData\Api\ConsentController(($container->privates['Shopware\\Core\\System\\UsageData\\Consent\\ConsentService'] ?? self::getConsentServiceService($container)), ($container->privates['Shopware\\Core\\System\\UsageData\\Consent\\BannerService'] ?? self::getBannerServiceService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Aggregate\UserAccessKey\UserAccessKeyDefinition' shared service.
     *
     * @return \Shopware\Core\System\User\Aggregate\UserAccessKey\UserAccessKeyDefinition
     */
    protected static function getUserAccessKeyDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition'] = $instance = new \Shopware\Core\System\User\Aggregate\UserAccessKey\UserAccessKeyDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Aggregate\UserConfig\UserConfigDefinition' shared service.
     *
     * @return \Shopware\Core\System\User\Aggregate\UserConfig\UserConfigDefinition
     */
    protected static function getUserConfigDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition'] = $instance = new \Shopware\Core\System\User\Aggregate\UserConfig\UserConfigDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Aggregate\UserRecovery\UserRecoveryDefinition' shared service.
     *
     * @return \Shopware\Core\System\User\Aggregate\UserRecovery\UserRecoveryDefinition
     */
    protected static function getUserRecoveryDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition'] = $instance = new \Shopware\Core\System\User\Aggregate\UserRecovery\UserRecoveryDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Api\UserRecoveryController' shared service.
     *
     * @return \Shopware\Core\System\User\Api\UserRecoveryController
     */
    protected static function getUserRecoveryControllerService($container)
    {
        $container->services['Shopware\\Core\\System\\User\\Api\\UserRecoveryController'] = $instance = new \Shopware\Core\System\User\Api\UserRecoveryController(new \Shopware\Core\System\User\Recovery\UserRecoveryService(($container->services['user_recovery.repository'] ?? self::getUserRecovery_RepositoryService($container)), ($container->services['user.repository'] ?? self::getUser_RepositoryService($container)), ($container->services['router'] ?? self::getRouterService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? self::getSalesChannelContextServiceService($container)), ($container->services['sales_channel.repository'] ?? self::getSalesChannel_RepositoryService($container))), ($container->privates['shopware.rate_limiter'] ?? self::getShopware_RateLimiterService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Api\UserValidationController' shared service.
     *
     * @return \Shopware\Core\System\User\Api\UserValidationController
     */
    protected static function getUserValidationControllerService($container)
    {
        $container->services['Shopware\\Core\\System\\User\\Api\\UserValidationController'] = $instance = new \Shopware\Core\System\User\Api\UserValidationController(new \Shopware\Core\System\User\Service\UserValidationService(($container->services['user.repository'] ?? self::getUser_RepositoryService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\UserDefinition' shared service.
     *
     * @return \Shopware\Core\System\User\UserDefinition
     */
    protected static function getUserDefinitionService($container)
    {
        $container->services['Shopware\\Core\\System\\User\\UserDefinition'] = $instance = new \Shopware\Core\System\User\UserDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));
        $instance->addExtension(new \Shopware\Core\Framework\DataAbstractionLayer\FilteredBulkEntityExtension('user', ($container->privates['Shopware\\Administration\\Notification\\NotificationBulkEntityExtension'] ??= new \Shopware\Administration\Notification\NotificationBulkEntityExtension())));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Elasticsearch\Admin\AdminElasticsearchHelper' shared service.
     *
     * @return \Shopware\Elasticsearch\Admin\AdminElasticsearchHelper
     */
    protected static function getAdminElasticsearchHelperService($container)
    {
        return $container->services['Shopware\\Elasticsearch\\Admin\\AdminElasticsearchHelper'] = new \Shopware\Elasticsearch\Admin\AdminElasticsearchHelper($container->getEnv('bool:SHOPWARE_ADMIN_ES_ENABLED'), $container->getEnv('bool:SHOPWARE_ADMIN_ES_REFRESH_INDICES'), $container->getEnv('string:SHOPWARE_ADMIN_ES_INDEX_PREFIX'));
    }

    /*
     * Gets the public 'Shopware\Elasticsearch\Admin\AdminSearchController' shared service.
     *
     * @return \Shopware\Elasticsearch\Admin\AdminSearchController
     */
    protected static function getAdminSearchController2Service($container)
    {
        return $container->services['Shopware\\Elasticsearch\\Admin\\AdminSearchController'] = new \Shopware\Elasticsearch\Admin\AdminSearchController(($container->privates['Shopware\\Elasticsearch\\Admin\\AdminSearcher'] ?? self::getAdminSearcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)), ($container->privates['Shopware\\Core\\Framework\\Api\\Serializer\\JsonEntityEncoder'] ?? self::getJsonEntityEncoderService($container)), ($container->services['Shopware\\Elasticsearch\\Admin\\AdminElasticsearchHelper'] ??= new \Shopware\Elasticsearch\Admin\AdminElasticsearchHelper($container->getEnv('bool:SHOPWARE_ADMIN_ES_ENABLED'), $container->getEnv('bool:SHOPWARE_ADMIN_ES_REFRESH_INDICES'), $container->getEnv('string:SHOPWARE_ADMIN_ES_INDEX_PREFIX'))));
    }

    /*
     * Gets the public 'Shopware\Elasticsearch\Framework\ElasticsearchHelper' shared service.
     *
     * @return \Shopware\Elasticsearch\Framework\ElasticsearchHelper
     */
    protected static function getElasticsearchHelperService($container)
    {
        $a = ($container->privates['Shopware\\Elasticsearch\\Framework\\ElasticsearchRegistry'] ?? self::getElasticsearchRegistryService($container));

        if (isset($container->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'])) {
            return $container->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'];
        }

        return $container->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'] = new \Shopware\Elasticsearch\Framework\ElasticsearchHelper('prod', $container->getEnv('bool:SHOPWARE_ES_ENABLED'), $container->getEnv('bool:SHOPWARE_ES_INDEXING_ENABLED'), $container->getEnv('string:SHOPWARE_ES_INDEX_PREFIX'), $container->getEnv('string:SHOPWARE_ES_THROW_EXCEPTION'), ($container->services['OpenSearch\\Client'] ?? self::getClientService($container)), $a, ($container->privates['Shopware\\Elasticsearch\\Framework\\DataAbstractionLayer\\CriteriaParser'] ?? self::getCriteriaParserService($container)), ($container->services['monolog.logger.elasticsearch'] ?? self::getMonolog_Logger_ElasticsearchService($container)));
    }

    /*
     * Gets the public 'Shopware\Elasticsearch\Framework\Indexing\CreateAliasTaskHandler' shared service.
     *
     * @return \Shopware\Elasticsearch\Framework\Indexing\CreateAliasTaskHandler
     */
    protected static function getCreateAliasTaskHandlerService($container)
    {
        $a = ($container->services['scheduled_task.repository'] ?? self::getScheduledTask_RepositoryService($container));

        if (isset($container->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'])) {
            return $container->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'];
        }
        $b = ($container->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'] ?? self::getElasticsearchHelperService($container));

        if (isset($container->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'])) {
            return $container->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'];
        }
        $c = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'])) {
            return $container->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'];
        }

        return $container->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'] = new \Shopware\Elasticsearch\Framework\Indexing\CreateAliasTaskHandler($a, ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)), ($container->services['OpenSearch\\Client'] ?? self::getClientService($container)), ($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)), $b, $container->parameters['elasticsearch.index.config'], $c);
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AccountOrderController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AccountOrderController
     */
    protected static function getAccountOrderControllerService($container)
    {
        $a = ($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container));
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));
        $c = ($container->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute'] ?? self::getOrderRouteService($container));
        $d = ($container->services['translator'] ?? self::getTranslatorService($container));
        $e = ($container->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? self::getOrderServiceService($container));

        $container->services['Shopware\\Storefront\\Controller\\AccountOrderController'] = $instance = new \Shopware\Storefront\Controller\AccountOrderController(new \Shopware\Storefront\Page\Account\Order\AccountOrderPageLoader($a, $b, $c, ($container->privates['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountService'] ?? self::getAccountServiceService($container)), $d), new \Shopware\Storefront\Page\Account\Order\AccountEditOrderPageLoader($a, $b, $c, ($container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'] ?? self::getCheckoutGatewayRouteService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? self::getOrderConverterService($container)), $e, $d, ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? self::getCartServiceService($container))), ($container->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextSwitchRoute'] ?? self::getContextSwitchRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\CancelOrderRoute'] ?? self::getCancelOrderRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\SetPaymentOrderRoute'] ?? self::getSetPaymentOrderRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\HandlePaymentMethodRoute'] ?? self::getHandlePaymentMethodRouteService($container)), $b, new \Shopware\Storefront\Page\Account\Order\AccountOrderDetailPageLoader($a, $b, $c), $c, ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? self::getSalesChannelContextServiceService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), $e, ($container->privates['Shopware\\Storefront\\Pagelet\\Header\\HeaderPageletLoader'] ?? self::getHeaderPageletLoaderService($container)), ($container->privates['Shopware\\Storefront\\Pagelet\\Footer\\FooterPageletLoader'] ?? self::getFooterPageletLoaderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AccountProfileController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AccountProfileController
     */
    protected static function getAccountProfileControllerService($container)
    {
        $a = ($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container));
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));
        $c = ($container->services['translator'] ?? self::getTranslatorService($container));

        $container->services['Shopware\\Storefront\\Controller\\AccountProfileController'] = $instance = new \Shopware\Storefront\Controller\AccountProfileController(new \Shopware\Storefront\Page\Account\Overview\AccountOverviewPageLoader($a, $b, ($container->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute'] ?? self::getOrderRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRoute'] ?? self::getCustomerRouteService($container)), ($container->privates['Shopware\\Storefront\\Pagelet\\Newsletter\\Account\\NewsletterAccountPageletLoader'] ?? self::getNewsletterAccountPageletLoaderService($container)), $c), new \Shopware\Storefront\Page\Account\Profile\AccountProfilePageLoader($a, $b, ($container->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\SalutationRoute'] ?? self::getSalutationRouteService($container)), ($container->privates['Shopware\\Core\\System\\Salutation\\AbstractSalutationsSorter'] ??= new \Shopware\Core\System\Salutation\SalutationSorter()), $c), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeCustomerProfileRoute'] ?? self::getChangeCustomerProfileRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangePasswordRoute'] ?? self::getChangePasswordRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeEmailRoute'] ?? self::getChangeEmailRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteCustomerRoute'] ?? self::getDeleteCustomerRouteService($container)), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AddressController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AddressController
     */
    protected static function getAddressControllerService($container)
    {
        $a = ($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container));
        $b = ($container->services['Shopware\\Core\\System\\Country\\SalesChannel\\CountryRoute'] ?? self::getCountryRouteService($container));
        $c = ($container->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\SalutationRoute'] ?? self::getSalutationRouteService($container));
        $d = ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ListAddressRoute'] ?? self::getListAddressRouteService($container));
        $e = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));
        $f = ($container->services['translator'] ?? self::getTranslatorService($container));

        $container->services['Shopware\\Storefront\\Controller\\AddressController'] = $instance = new \Shopware\Storefront\Controller\AddressController(new \Shopware\Storefront\Page\Address\Listing\AddressListingPageLoader($a, $b, $c, $d, $e, ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? self::getCartServiceService($container)), $f), new \Shopware\Storefront\Page\Address\Detail\AddressDetailPageLoader($a, $b, $c, $e, $d, ($container->privates['Shopware\\Core\\System\\Salutation\\AbstractSalutationsSorter'] ??= new \Shopware\Core\System\Salutation\SalutationSorter()), $f), ($container->privates['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountService'] ?? self::getAccountServiceService($container)), $d, ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\UpsertAddressRoute'] ?? self::getUpsertAddressRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteAddressRoute'] ?? self::getDeleteAddressRouteService($container)), ($container->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextSwitchRoute'] ?? self::getContextSwitchRouteService($container)), ($container->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? self::getSalesChannelContextServiceService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\Api\CaptchaController' shared service.
     *
     * @return \Shopware\Storefront\Controller\Api\CaptchaController
     */
    protected static function getCaptchaControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\Api\\CaptchaController'] = $instance = new \Shopware\Storefront\Controller\Api\CaptchaController(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Storefront\\Framework\\Captcha\\HoneypotCaptcha'] ?? self::getHoneypotCaptchaService($container));
            yield 1 => ($container->privates['Shopware\\Storefront\\Framework\\Captcha\\BasicCaptcha'] ?? self::getBasicCaptchaService($container));
            yield 2 => ($container->privates['Shopware\\Storefront\\Framework\\Captcha\\GoogleReCaptchaV2'] ?? self::getGoogleReCaptchaV2Service($container));
            yield 3 => ($container->privates['Shopware\\Storefront\\Framework\\Captcha\\GoogleReCaptchaV3'] ?? self::getGoogleReCaptchaV3Service($container));
        }, 4));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AppController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AppController
     */
    protected static function getAppControllerService($container)
    {
        return $container->services['Shopware\\Storefront\\Controller\\AppController'] = new \Shopware\Storefront\Controller\AppController(($container->services['Shopware\\Core\\Framework\\App\\Api\\AppJWTGenerateRoute'] ?? self::getAppJWTGenerateRouteService($container)));
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AuthController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AuthController
     */
    protected static function getAuthController2Service($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\AuthController'] = $instance = new \Shopware\Storefront\Controller\AuthController(($container->privates['Shopware\\Storefront\\Page\\Account\\Login\\AccountLoginPageLoader'] ?? self::getAccountLoginPageLoaderService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SendPasswordRecoveryMailRoute'] ?? self::getSendPasswordRecoveryMailRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ResetPasswordRoute'] ?? self::getResetPasswordRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoginRoute'] ?? self::getLoginRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute'] ?? self::getLogoutRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ImitateCustomerRoute'] ?? self::getImitateCustomerRouteService($container)), ($container->privates['Shopware\\Storefront\\Checkout\\Cart\\SalesChannel\\StorefrontCartFacade'] ?? self::getStorefrontCartFacadeService($container)), new \Shopware\Storefront\Page\Account\RecoverPassword\AccountRecoverPasswordPageLoader(($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRecoveryIsExpiredRoute'] ?? self::getCustomerRecoveryIsExpiredRouteService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CaptchaController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CaptchaController
     */
    protected static function getCaptchaController2Service($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\CaptchaController'] = $instance = new \Shopware\Storefront\Controller\CaptchaController(new \Shopware\Storefront\Pagelet\Captcha\BasicCaptchaPageletLoader(($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), new \Shopware\Storefront\Framework\Captcha\BasicCaptcha\BasicCaptchaGenerator(), ($container->privates['Shopware\\Core\\Content\\Category\\Service\\NavigationLoader'] ?? self::getNavigationLoaderService($container))), ($container->privates['Shopware\\Storefront\\Framework\\Captcha\\BasicCaptcha'] ?? self::getBasicCaptchaService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CartLineItemController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CartLineItemController
     */
    protected static function getCartLineItemControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\CartLineItemController'] = $instance = new \Shopware\Storefront\Controller\CartLineItemController(($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? self::getCartServiceService($container)), ($container->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\PromotionItemBuilder'] ??= new \Shopware\Core\Checkout\Promotion\Cart\PromotionItemBuilder()), ($container->privates['Shopware\\Core\\Checkout\\Cart\\LineItemFactoryHandler\\ProductLineItemFactory'] ?? self::getProductLineItemFactoryService($container)), ($container->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] ?? self::getHtmlSanitizerService($container)), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductListRoute'] ?? self::getProductListRouteService($container)), ($container->privates['Shopware\\Core\\Checkout\\Cart\\LineItemFactoryRegistry'] ?? self::getLineItemFactoryRegistryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CheckoutController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CheckoutController
     */
    protected static function getCheckoutControllerService($container)
    {
        $a = ($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container));
        $b = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));
        $c = ($container->privates['Shopware\\Storefront\\Checkout\\Cart\\SalesChannel\\StorefrontCartFacade'] ?? self::getStorefrontCartFacadeService($container));
        $d = ($container->services['Shopware\\Core\\Checkout\\Gateway\\SalesChannel\\CheckoutGatewayRoute'] ?? self::getCheckoutGatewayRouteService($container));
        $e = ($container->services['translator'] ?? self::getTranslatorService($container));

        $container->services['Shopware\\Storefront\\Controller\\CheckoutController'] = $instance = new \Shopware\Storefront\Controller\CheckoutController(($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? self::getCartServiceService($container)), new \Shopware\Storefront\Page\Checkout\Cart\CheckoutCartPageLoader($a, $b, $c, $d, ($container->services['Shopware\\Core\\System\\Country\\SalesChannel\\CountryRoute'] ?? self::getCountryRouteService($container)), $e), new \Shopware\Storefront\Page\Checkout\Confirm\CheckoutConfirmPageLoader($b, $c, $d, $a, ($container->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\AddressValidationFactory'] ?? self::getAddressValidationFactoryService($container)), ($container->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? self::getDataValidatorService($container)), $e), new \Shopware\Storefront\Page\Checkout\Finish\CheckoutFinishPageLoader($b, $a, ($container->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute'] ?? self::getOrderRouteService($container)), $e), ($container->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? self::getOrderServiceService($container)), ($container->privates['Shopware\\Core\\Checkout\\Payment\\PaymentProcessor'] ?? self::getPaymentProcessorService($container)), new \Shopware\Storefront\Page\Checkout\Offcanvas\OffcanvasCartPageLoader($b, $c, $a, ($container->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\ShippingMethodRoute'] ?? self::getShippingMethodRouteService($container))), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute'] ?? self::getLogoutRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'] ?? self::getCartLoadRouteService($container)), ($container->privates['Shopware\\Storefront\\Pagelet\\Header\\HeaderPageletLoader'] ?? self::getHeaderPageletLoaderService($container)), ($container->privates['Shopware\\Storefront\\Pagelet\\Footer\\FooterPageletLoader'] ?? self::getFooterPageletLoaderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CmsController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CmsController
     */
    protected static function getCmsControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\CmsController'] = $instance = new \Shopware\Storefront\Controller\CmsController(($container->services['Shopware\\Core\\Content\\Cms\\SalesChannel\\CmsRoute'] ?? self::getCmsRouteService($container)), ($container->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CategoryRoute'] ?? self::getCategoryRouteService($container)), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute'] ?? self::getResolveCriteriaProductListingRouteService($container)), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\ProductDetailRoute'] ?? self::getProductDetailRouteService($container)), ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewLoader'] ?? self::getProductReviewLoaderService($container)), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\FindVariant\\FindProductVariantRoute'] ?? self::getFindProductVariantRouteService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\ContextController' shared service.
     *
     * @return \Shopware\Storefront\Controller\ContextController
     */
    protected static function getContextControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\ContextController'] = $instance = new \Shopware\Storefront\Controller\ContextController(($container->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextSwitchRoute'] ?? self::getContextSwitchRouteService($container)), ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack()), ($container->privates['router.default'] ?? self::getRouter_DefaultService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CookieController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CookieController
     */
    protected static function getCookieControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\CookieController'] = $instance = new \Shopware\Storefront\Controller\CookieController(new \Shopware\Storefront\Framework\Cookie\AppCookieProvider(new \Shopware\Storefront\Framework\Cookie\CookieProvider(), ($container->services['app.repository'] ?? self::getApp_RepositoryService($container))), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['sales_channel_analytics.repository'] ?? self::getSalesChannelAnalytics_RepositoryService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CountryStateController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CountryStateController
     */
    protected static function getCountryStateControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\CountryStateController'] = $instance = new \Shopware\Storefront\Controller\CountryStateController(new \Shopware\Storefront\Pagelet\Country\CountryStateDataPageletLoader(($container->services['Shopware\\Core\\System\\Country\\SalesChannel\\CountryStateRoute'] ?? self::getCountryStateRouteService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\DocumentController' shared service.
     *
     * @return \Shopware\Storefront\Controller\DocumentController
     */
    protected static function getDocumentController2Service($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\DocumentController'] = $instance = new \Shopware\Storefront\Controller\DocumentController(($container->services['Shopware\\Core\\Checkout\\Document\\SalesChannel\\DocumentRoute'] ?? self::getDocumentRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute'] ?? self::getLogoutRouteService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\DownloadController' shared service.
     *
     * @return \Shopware\Storefront\Controller\DownloadController
     */
    protected static function getDownloadControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\DownloadController'] = $instance = new \Shopware\Storefront\Controller\DownloadController(($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DownloadRoute'] ?? self::getDownloadRouteService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\ErrorController' shared service.
     *
     * @return \Shopware\Storefront\Controller\ErrorController
     */
    protected static function getErrorControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\ErrorController'] = $instance = new \Shopware\Storefront\Controller\ErrorController(new \Shopware\Storefront\Framework\Twig\ErrorTemplateResolver(($container->services['twig'] ?? self::getTwigService($container))), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), new \Shopware\Storefront\Page\Navigation\Error\ErrorPageLoader(($container->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? self::getSalesChannelCmsPageLoaderService($container)), ($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\FormController' shared service.
     *
     * @return \Shopware\Storefront\Controller\FormController
     */
    protected static function getFormControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\FormController'] = $instance = new \Shopware\Storefront\Controller\FormController(($container->services['Shopware\\Core\\Content\\ContactForm\\SalesChannel\\ContactFormRoute'] ?? self::getContactFormRouteService($container)), ($container->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterSubscribeRoute'] ?? self::getNewsletterSubscribeRouteService($container)), ($container->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterUnsubscribeRoute'] ?? self::getNewsletterUnsubscribeRouteService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\LandingPageController' shared service.
     *
     * @return \Shopware\Storefront\Controller\LandingPageController
     */
    protected static function getLandingPageControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\LandingPageController'] = $instance = new \Shopware\Storefront\Controller\LandingPageController(new \Shopware\Storefront\Page\LandingPage\LandingPageLoader(($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), ($container->services['Shopware\\Core\\Content\\LandingPage\\SalesChannel\\LandingPageRoute'] ?? self::getLandingPageRouteService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container))));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\MaintenanceController' shared service.
     *
     * @return \Shopware\Storefront\Controller\MaintenanceController
     */
    protected static function getMaintenanceControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\MaintenanceController'] = $instance = new \Shopware\Storefront\Controller\MaintenanceController(($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), new \Shopware\Storefront\Page\Maintenance\MaintenancePageLoader(($container->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? self::getSalesChannelCmsPageLoaderService($container)), ($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container))), ($container->privates['Shopware\\Storefront\\Framework\\Routing\\MaintenanceModeResolver'] ?? self::getMaintenanceModeResolver2Service($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\NavigationController' shared service.
     *
     * @return \Shopware\Storefront\Controller\NavigationController
     */
    protected static function getNavigationControllerService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        $container->services['Shopware\\Storefront\\Controller\\NavigationController'] = $instance = new \Shopware\Storefront\Controller\NavigationController(new \Shopware\Storefront\Page\Navigation\NavigationPageLoader(($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), $a, ($container->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CategoryRoute'] ?? self::getCategoryRouteService($container)), ($container->services['Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface'] ?? self::getSeoUrlPlaceholderHandlerInterfaceService($container))), new \Shopware\Storefront\Pagelet\Menu\Offcanvas\MenuOffcanvasPageletLoader($a, ($container->privates['Shopware\\Core\\Content\\Category\\Service\\NavigationLoader'] ?? self::getNavigationLoaderService($container))), ($container->privates['Shopware\\Storefront\\Pagelet\\Header\\HeaderPageletLoader'] ?? self::getHeaderPageletLoaderService($container)), ($container->privates['Shopware\\Storefront\\Pagelet\\Footer\\FooterPageletLoader'] ?? self::getFooterPageletLoaderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\NewsletterController' shared service.
     *
     * @return \Shopware\Storefront\Controller\NewsletterController
     */
    protected static function getNewsletterControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\NewsletterController'] = $instance = new \Shopware\Storefront\Controller\NewsletterController(new \Shopware\Storefront\Page\Newsletter\Subscribe\NewsletterSubscribePageLoader(($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container))), ($container->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterConfirmRoute'] ?? self::getNewsletterConfirmRouteService($container)), ($container->privates['Shopware\\Storefront\\Pagelet\\Newsletter\\Account\\NewsletterAccountPageletLoader'] ?? self::getNewsletterAccountPageletLoaderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\ProductController' shared service.
     *
     * @return \Shopware\Storefront\Controller\ProductController
     */
    protected static function getProductControllerService($container)
    {
        $a = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));
        $b = ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\ProductDetailRoute'] ?? self::getProductDetailRouteService($container));

        $container->services['Shopware\\Storefront\\Controller\\ProductController'] = $instance = new \Shopware\Storefront\Controller\ProductController(new \Shopware\Storefront\Page\Product\ProductPageLoader(($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), $a, $b), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\FindVariant\\FindProductVariantRoute'] ?? self::getFindProductVariantRouteService($container)), new \Shopware\Storefront\Page\Product\QuickView\MinimalQuickViewPageLoader($a, $b), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewSaveRoute'] ?? self::getProductReviewSaveRouteService($container)), ($container->services['Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface'] ?? self::getSeoUrlPlaceholderHandlerInterfaceService($container)), ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewLoader'] ?? self::getProductReviewLoaderService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\RegisterController' shared service.
     *
     * @return \Shopware\Storefront\Controller\RegisterController
     */
    protected static function getRegisterControllerService($container)
    {
        $a = ($container->privates['Shopware\\Storefront\\Page\\Account\\Login\\AccountLoginPageLoader'] ?? self::getAccountLoginPageLoaderService($container));

        $container->services['Shopware\\Storefront\\Controller\\RegisterController'] = $instance = new \Shopware\Storefront\Controller\RegisterController($a, ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterRoute'] ?? self::getRegisterRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterConfirmRoute'] ?? self::getRegisterConfirmRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? self::getCartServiceService($container)), ($container->services['Shopware\\Storefront\\Page\\Checkout\\Register\\CheckoutRegisterPageLoader'] ?? self::getCheckoutRegisterPageLoaderService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), ($container->services['customer.repository'] ?? self::getCustomer_RepositoryService($container)), new \Shopware\Storefront\Page\Account\CustomerGroupRegistration\CustomerGroupRegistrationPageLoader($a, ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerGroupRegistrationSettingsRoute'] ?? self::getCustomerGroupRegistrationSettingsRouteService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container))), ($container->services['sales_channel_domain.repository'] ?? self::getSalesChannelDomain_RepositoryService($container)), ($container->privates['Shopware\\Storefront\\Pagelet\\Header\\HeaderPageletLoader'] ?? self::getHeaderPageletLoaderService($container)), ($container->privates['Shopware\\Storefront\\Pagelet\\Footer\\FooterPageletLoader'] ?? self::getFooterPageletLoaderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\ScriptController' shared service.
     *
     * @return \Shopware\Storefront\Controller\ScriptController
     */
    protected static function getScriptControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\ScriptController'] = $instance = new \Shopware\Storefront\Controller\ScriptController(($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), ($container->privates['Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseEncoder'] ?? self::getScriptResponseEncoderService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\SearchController' shared service.
     *
     * @return \Shopware\Storefront\Controller\SearchController
     */
    protected static function getSearchControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\SearchController'] = $instance = new \Shopware\Storefront\Controller\SearchController(($container->services['Shopware\\Storefront\\Page\\Search\\SearchPageLoader'] ?? self::getSearchPageLoaderService($container)), new \Shopware\Storefront\Page\Suggest\SuggestPageLoader(($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\ResolvedCriteriaProductSuggestRoute'] ?? self::getResolvedCriteriaProductSuggestRouteService($container)), ($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container))), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute'] ?? self::getResolvedCriteriaProductSearchRouteService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\SitemapController' shared service.
     *
     * @return \Shopware\Storefront\Controller\SitemapController
     */
    protected static function getSitemapControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\SitemapController'] = $instance = new \Shopware\Storefront\Controller\SitemapController(new \Shopware\Storefront\Page\Sitemap\SitemapPageLoader(($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Content\\Sitemap\\SalesChannel\\SitemapRoute'] ?? self::getSitemapRouteService($container))), ($container->services['Shopware\\Core\\Content\\Sitemap\\SalesChannel\\SitemapFileRoute'] ?? self::getSitemapFileRouteService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\VerificationHashController' shared service.
     *
     * @return \Shopware\Storefront\Controller\VerificationHashController
     */
    protected static function getVerificationHashControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\VerificationHashController'] = $instance = new \Shopware\Storefront\Controller\VerificationHashController(($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)));

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\WellKnownController' shared service.
     *
     * @return \Shopware\Storefront\Controller\WellKnownController
     */
    protected static function getWellKnownControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Controller\\WellKnownController'] = $instance = new \Shopware\Storefront\Controller\WellKnownController();

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\WishlistController' shared service.
     *
     * @return \Shopware\Storefront\Controller\WishlistController
     */
    protected static function getWishlistControllerService($container)
    {
        $a = ($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container));
        $b = ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoadWishlistRoute'] ?? self::getLoadWishlistRouteService($container));
        $c = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        $container->services['Shopware\\Storefront\\Controller\\WishlistController'] = $instance = new \Shopware\Storefront\Controller\WishlistController(new \Shopware\Storefront\Page\Wishlist\WishlistPageLoader($a, $b, $c), $b, ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AddWishlistProductRoute'] ?? self::getAddWishlistProductRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RemoveWishlistProductRoute'] ?? self::getRemoveWishlistProductRouteService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\MergeWishlistProductRoute'] ?? self::getMergeWishlistProductRouteService($container)), new \Shopware\Storefront\Page\Wishlist\GuestWishlistPageLoader($a, $c), new \Shopware\Storefront\Pagelet\Wishlist\GuestWishlistPageletLoader(($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductListRoute'] ?? self::getProductListRouteService($container)), ($container->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? self::getSystemConfigServiceService($container)), $c, ($container->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] ??= new \Shopware\Core\Content\Product\SalesChannel\ProductCloseoutFilterFactory())), $c);

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Framework\Media\StorefrontMediaValidatorRegistry' shared autowired service.
     *
     * @return \Shopware\Storefront\Framework\Media\StorefrontMediaValidatorRegistry
     */
    protected static function getStorefrontMediaValidatorRegistryService($container)
    {
        return $container->services['Shopware\\Storefront\\Framework\\Media\\StorefrontMediaValidatorRegistry'] = new \Shopware\Storefront\Framework\Media\StorefrontMediaValidatorRegistry(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['Shopware\\Storefront\\Framework\\Media\\Validator\\StorefrontMediaImageValidator'] ??= new \Shopware\Storefront\Framework\Media\Validator\StorefrontMediaImageValidator());
            yield 1 => ($container->privates['Shopware\\Storefront\\Framework\\Media\\Validator\\StorefrontMediaDocumentValidator'] ??= new \Shopware\Storefront\Framework\Media\Validator\StorefrontMediaDocumentValidator());
        }, 2));
    }

    /*
     * Gets the public 'Shopware\Storefront\Page\Checkout\Register\CheckoutRegisterPageLoader' shared autowired service.
     *
     * @return \Shopware\Storefront\Page\Checkout\Register\CheckoutRegisterPageLoader
     */
    protected static function getCheckoutRegisterPageLoaderService($container)
    {
        return $container->services['Shopware\\Storefront\\Page\\Checkout\\Register\\CheckoutRegisterPageLoader'] = new \Shopware\Storefront\Page\Checkout\Register\CheckoutRegisterPageLoader(($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), ($container->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ListAddressRoute'] ?? self::getListAddressRouteService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? self::getCartServiceService($container)), ($container->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\SalutationRoute'] ?? self::getSalutationRouteService($container)), ($container->services['Shopware\\Core\\System\\Country\\SalesChannel\\CountryRoute'] ?? self::getCountryRouteService($container)), ($container->services['translator'] ?? self::getTranslatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Storefront\Page\Search\SearchPageLoader' shared autowired service.
     *
     * @return \Shopware\Storefront\Page\Search\SearchPageLoader
     */
    protected static function getSearchPageLoaderService($container)
    {
        return $container->services['Shopware\\Storefront\\Page\\Search\\SearchPageLoader'] = new \Shopware\Storefront\Page\Search\SearchPageLoader(($container->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? self::getGenericPageLoaderService($container)), ($container->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute'] ?? self::getResolvedCriteriaProductSearchRouteService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['translator'] ?? self::getTranslatorService($container)));
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Aggregate\ThemeChildDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\Aggregate\ThemeChildDefinition
     */
    protected static function getThemeChildDefinitionService($container)
    {
        $container->services['Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition'] = $instance = new \Shopware\Storefront\Theme\Aggregate\ThemeChildDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Aggregate\ThemeMediaDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\Aggregate\ThemeMediaDefinition
     */
    protected static function getThemeMediaDefinitionService($container)
    {
        $container->services['Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition'] = $instance = new \Shopware\Storefront\Theme\Aggregate\ThemeMediaDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Aggregate\ThemeSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\Aggregate\ThemeSalesChannelDefinition
     */
    protected static function getThemeSalesChannelDefinitionService($container)
    {
        $container->services['Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition'] = $instance = new \Shopware\Storefront\Theme\Aggregate\ThemeSalesChannelDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Aggregate\ThemeTranslationDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\Aggregate\ThemeTranslationDefinition
     */
    protected static function getThemeTranslationDefinitionService($container)
    {
        $container->services['Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition'] = $instance = new \Shopware\Storefront\Theme\Aggregate\ThemeTranslationDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Controller\ThemeController' shared service.
     *
     * @return \Shopware\Storefront\Theme\Controller\ThemeController
     */
    protected static function getThemeControllerService($container)
    {
        $container->services['Shopware\\Storefront\\Theme\\Controller\\ThemeController'] = $instance = new \Shopware\Storefront\Theme\Controller\ThemeController(($container->privates['Shopware\\Storefront\\Theme\\ThemeService'] ?? self::getThemeServiceService($container)), ($container->privates['Shopware\\Storefront\\Theme\\ScssPhpCompiler'] ??= new \Shopware\Storefront\Theme\ScssPhpCompiler()), $container->parameters['storefront.theme.allowed_scss_values']);

        $instance->setContainer($container);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\DatabaseSalesChannelThemeLoader' shared service.
     *
     * @return \Shopware\Storefront\Theme\DatabaseSalesChannelThemeLoader
     */
    protected static function getDatabaseSalesChannelThemeLoaderService($container)
    {
        return $container->services['Shopware\\Storefront\\Theme\\DatabaseSalesChannelThemeLoader'] = new \Shopware\Storefront\Theme\DatabaseSalesChannelThemeLoader(($container->services['Doctrine\\DBAL\\Connection'] ?? self::getConnectionService($container)));
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\StorefrontPluginRegistry' shared service.
     *
     * @return \Shopware\Storefront\Theme\StorefrontPluginRegistry
     */
    protected static function getStorefrontPluginRegistryService($container)
    {
        $a = ($container->privates['Shopware\\Storefront\\Theme\\StorefrontPluginConfiguration\\StorefrontPluginConfigurationFactory'] ?? self::getStorefrontPluginConfigurationFactoryService($container));

        if (isset($container->services['Shopware\\Storefront\\Theme\\StorefrontPluginRegistry'])) {
            return $container->services['Shopware\\Storefront\\Theme\\StorefrontPluginRegistry'];
        }

        return $container->services['Shopware\\Storefront\\Theme\\StorefrontPluginRegistry'] = new \Shopware\Storefront\Theme\StorefrontPluginRegistry(($container->services['kernel'] ?? $container->get('kernel', 1)), $a, ($container->privates['Shopware\\Core\\Framework\\App\\ActiveAppsLoader'] ?? self::getActiveAppsLoaderService($container)));
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\ThemeDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\ThemeDefinition
     */
    protected static function getThemeDefinitionService($container)
    {
        $container->services['Shopware\\Storefront\\Theme\\ThemeDefinition'] = $instance = new \Shopware\Storefront\Theme\ThemeDefinition();

        $instance->compile(($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? self::getDefinitionInstanceRegistryService($container)));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\ThemeFilesystemResolver' shared service.
     *
     * @return \Shopware\Storefront\Theme\ThemeFilesystemResolver
     */
    protected static function getThemeFilesystemResolverService($container)
    {
        $a = ($container->privates['Shopware\\Core\\Framework\\App\\Source\\SourceResolver'] ?? self::getSourceResolverService($container));

        if (isset($container->services['Shopware\\Storefront\\Theme\\ThemeFilesystemResolver'])) {
            return $container->services['Shopware\\Storefront\\Theme\\ThemeFilesystemResolver'];
        }

        return $container->services['Shopware\\Storefront\\Theme\\ThemeFilesystemResolver'] = new \Shopware\Storefront\Theme\ThemeFilesystemResolver($a, ($container->services['kernel'] ?? $container->get('kernel', 1)));
    }

    /*
     * Gets the public 'Symfony\Bundle\FrameworkBundle\Controller\RedirectController' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Controller\RedirectController
     */
    protected static function getRedirectControllerService($container)
    {
        $a = ($container->privates['router.request_context'] ?? self::getRouter_RequestContextService($container));

        return $container->services['Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController'] = new \Symfony\Bundle\FrameworkBundle\Controller\RedirectController(($container->services['router'] ?? self::getRouterService($container)), $a->getHttpPort(), $a->getHttpsPort());
    }

    /*
     * Gets the public 'Symfony\Bundle\FrameworkBundle\Controller\TemplateController' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Controller\TemplateController
     */
    protected static function getTemplateControllerService($container)
    {
        return $container->services['Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController'] = new \Symfony\Bundle\FrameworkBundle\Controller\TemplateController(($container->services['twig'] ?? self::getTwigService($container)));
    }

    /*
     * Gets the public '_dummy_es_env_usage' shared service.
     *
     * @return \ArrayIterator
     */
    protected static function getDummyEsEnvUsageService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['_dummy_es_env_usage'] = $container->createProxy('ArrayIteratorProxy9d5ac06', static fn () => \ArrayIteratorProxy9d5ac06::createLazyProxy(static fn () => self::getDummyEsEnvUsageService($container, false)));
        }

        return new \ArrayIterator([$container->getEnv('bool:SHOPWARE_ES_ENABLED'), $container->getEnv('bool:SHOPWARE_ES_INDEXING_ENABLED'), $container->getEnv('string:OPENSEARCH_URL'), $container->getEnv('string:SHOPWARE_ES_INDEX_PREFIX'), $container->getEnv('bool:SHOPWARE_ES_THROW_EXCEPTION'), $container->getEnv('int:SHOPWARE_ES_INDEXING_BATCH_SIZE')]);
    }

    /*
     * Gets the public 'acl_role.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAclRole_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['acl_role.repository'])) {
            return $container->services['acl_role.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['acl_role.repository'])) {
            return $container->services['acl_role.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['acl_role.repository'])) {
            return $container->services['acl_role.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['acl_role.repository'])) {
            return $container->services['acl_role.repository'];
        }

        return $container->services['acl_role.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition'] ?? self::getAclRoleDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'acl_user_role.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAclUserRole_RepositoryService($container)
    {
        return $container->services['acl_user_role.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition'] ?? self::getAclUserRoleDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'admin.openSearch.client' shared service.
     *
     * @return \OpenSearch\Client
     */
    protected static function getAdmin_OpenSearch_ClientService($container, $lazyLoad = true)
    {
        if (true === $lazyLoad) {
            return $container->services['admin.openSearch.client'] = $container->createProxy('ClientProxyDf0d0fc', static fn () => \ClientProxyDf0d0fc::createLazyProxy(static fn () => self::getAdmin_OpenSearch_ClientService($container, false)));
        }

        return \Shopware\Elasticsearch\Framework\ClientFactory::createClient($container->getEnv('string:ADMIN_OPENSEARCH_URL'), ($container->services['monolog.logger.elasticsearch'] ?? self::getMonolog_Logger_ElasticsearchService($container)), false, $container->parameters['elasticsearch.ssl']);
    }

    /*
     * Gets the public 'administration.filesystem.private' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected static function getAdministration_Filesystem_PrivateService($container)
    {
        return $container->services['administration.filesystem.private'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), 'plugins/administration');
    }

    /*
     * Gets the public 'administration.filesystem.public' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected static function getAdministration_Filesystem_PublicService($container)
    {
        return $container->services['administration.filesystem.public'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($container->services['shopware.filesystem.public'] ?? self::getShopware_Filesystem_PublicService($container)), 'plugins/administration');
    }

    /*
     * Gets the public 'app.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getApp_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['app.repository'])) {
            return $container->services['app.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['app.repository'])) {
            return $container->services['app.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['app.repository'])) {
            return $container->services['app.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['app.repository'])) {
            return $container->services['app.repository'];
        }

        return $container->services['app.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\AppDefinition'] ?? self::getAppDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_action_button.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppActionButton_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['app_action_button.repository'])) {
            return $container->services['app_action_button.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['app_action_button.repository'])) {
            return $container->services['app_action_button.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['app_action_button.repository'])) {
            return $container->services['app_action_button.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['app_action_button.repository'])) {
            return $container->services['app_action_button.repository'];
        }

        return $container->services['app_action_button.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition'] ?? self::getActionButtonDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_action_button_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppActionButtonTranslation_RepositoryService($container)
    {
        return $container->services['app_action_button_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition'] ?? self::getActionButtonTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_administration_snippet.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppAdministrationSnippet_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['app_administration_snippet.repository'])) {
            return $container->services['app_administration_snippet.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['app_administration_snippet.repository'])) {
            return $container->services['app_administration_snippet.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['app_administration_snippet.repository'])) {
            return $container->services['app_administration_snippet.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['app_administration_snippet.repository'])) {
            return $container->services['app_administration_snippet.repository'];
        }

        return $container->services['app_administration_snippet.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition'] ?? self::getAppAdministrationSnippetDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_cms_block.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppCmsBlock_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['app_cms_block.repository'])) {
            return $container->services['app_cms_block.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['app_cms_block.repository'])) {
            return $container->services['app_cms_block.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['app_cms_block.repository'])) {
            return $container->services['app_cms_block.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['app_cms_block.repository'])) {
            return $container->services['app_cms_block.repository'];
        }

        return $container->services['app_cms_block.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition'] ?? self::getAppCmsBlockDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_cms_block_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppCmsBlockTranslation_RepositoryService($container)
    {
        return $container->services['app_cms_block_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition'] ?? self::getAppCmsBlockTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_flow_action.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppFlowAction_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['app_flow_action.repository'])) {
            return $container->services['app_flow_action.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['app_flow_action.repository'])) {
            return $container->services['app_flow_action.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['app_flow_action.repository'])) {
            return $container->services['app_flow_action.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['app_flow_action.repository'])) {
            return $container->services['app_flow_action.repository'];
        }

        return $container->services['app_flow_action.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition'] ?? self::getAppFlowActionDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_flow_action_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppFlowActionTranslation_RepositoryService($container)
    {
        return $container->services['app_flow_action_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition'] ?? self::getAppFlowActionTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_flow_event.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppFlowEvent_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['app_flow_event.repository'])) {
            return $container->services['app_flow_event.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['app_flow_event.repository'])) {
            return $container->services['app_flow_event.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['app_flow_event.repository'])) {
            return $container->services['app_flow_event.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['app_flow_event.repository'])) {
            return $container->services['app_flow_event.repository'];
        }

        return $container->services['app_flow_event.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowEvent\\AppFlowEventDefinition'] ?? self::getAppFlowEventDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_payment_method.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppPaymentMethod_RepositoryService($container)
    {
        return $container->services['app_payment_method.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition'] ?? self::getAppPaymentMethodDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_script_condition.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppScriptCondition_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['app_script_condition.repository'])) {
            return $container->services['app_script_condition.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['app_script_condition.repository'])) {
            return $container->services['app_script_condition.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['app_script_condition.repository'])) {
            return $container->services['app_script_condition.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['app_script_condition.repository'])) {
            return $container->services['app_script_condition.repository'];
        }

        return $container->services['app_script_condition.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition'] ?? self::getAppScriptConditionDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_script_condition_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppScriptConditionTranslation_RepositoryService($container)
    {
        return $container->services['app_script_condition_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition'] ?? self::getAppScriptConditionTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_shipping_method.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppShippingMethod_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['app_shipping_method.repository'])) {
            return $container->services['app_shipping_method.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['app_shipping_method.repository'])) {
            return $container->services['app_shipping_method.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['app_shipping_method.repository'])) {
            return $container->services['app_shipping_method.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['app_shipping_method.repository'])) {
            return $container->services['app_shipping_method.repository'];
        }

        return $container->services['app_shipping_method.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppShippingMethod\\AppShippingMethodDefinition'] ?? self::getAppShippingMethodDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_template.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppTemplate_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['app_template.repository'])) {
            return $container->services['app_template.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['app_template.repository'])) {
            return $container->services['app_template.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['app_template.repository'])) {
            return $container->services['app_template.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['app_template.repository'])) {
            return $container->services['app_template.repository'];
        }

        return $container->services['app_template.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition'] ?? self::getTemplateDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'app_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getAppTranslation_RepositoryService($container)
    {
        return $container->services['app_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition'] ?? self::getAppTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'cache.app' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected static function getCache_AppService($container)
    {
        $container->services['cache.app'] = $instance = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('jzVhlK49Qg', 0, ($container->targetDir.''.'/pools/app'), ($container->privates['cache.default_marshaller'] ??= new \Symfony\Component\Cache\Marshaller\DefaultMarshaller(NULL, false)));

        $instance->setLogger(($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));

        return $instance;
    }

    /*
     * Gets the public 'cache.app_clearer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer
     */
    protected static function getCache_AppClearerService($container)
    {
        return $container->services['cache.app_clearer'] = new \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer(['cache.app' => ($container->services['cache.app'] ?? self::getCache_AppService($container)), 'cache.messenger.restart_workers_signal' => ($container->privates['cache.messenger.restart_workers_signal'] ?? self::getCache_Messenger_RestartWorkersSignalService($container)), 'cache.rate_limiter' => ($container->privates['cache.rate_limiter'] ?? self::getCache_RateLimiterService($container)), 'cache.object' => ($container->privates['.cache.object.inner'] ?? self::get_Cache_Object_InnerService($container)), 'cache.http' => ($container->privates['.cache.http.inner'] ?? self::get_Cache_Http_InnerService($container)), 'cache.tags' => ($container->privates['cache.tags'] ?? self::getCache_TagsService($container))]);
    }

    /*
     * Gets the public 'cache.global_clearer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer
     */
    protected static function getCache_GlobalClearerService($container)
    {
        return $container->services['cache.global_clearer'] = new \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer(['cache.app' => ($container->services['cache.app'] ?? self::getCache_AppService($container)), 'cache.system' => ($container->services['cache.system'] ?? self::getCache_SystemService($container)), 'cache.validator' => ($container->privates['cache.validator'] ?? self::getCache_ValidatorService($container)), 'cache.serializer' => ($container->privates['cache.serializer'] ?? self::getCache_SerializerService($container)), 'cache.property_info' => ($container->privates['cache.property_info'] ?? self::getCache_PropertyInfoService($container)), 'cache.messenger.restart_workers_signal' => ($container->privates['cache.messenger.restart_workers_signal'] ?? self::getCache_Messenger_RestartWorkersSignalService($container)), 'cache.rate_limiter' => ($container->privates['cache.rate_limiter'] ?? self::getCache_RateLimiterService($container)), 'cache.object' => ($container->privates['.cache.object.inner'] ?? self::get_Cache_Object_InnerService($container)), 'cache.http' => ($container->privates['.cache.http.inner'] ?? self::get_Cache_Http_InnerService($container)), 'cache.tags' => ($container->privates['cache.tags'] ?? self::getCache_TagsService($container)), 'cache.property_access' => ($container->privates['cache.property_access'] ?? self::getCache_PropertyAccessService($container)), 'cache.validator_expression_language' => ($container->services['cache.validator_expression_language'] ?? self::getCache_ValidatorExpressionLanguageService($container)), 'cache.pentatrion_vite_fallback' => ($container->services['cache.pentatrion_vite_fallback'] ?? self::getCache_PentatrionViteFallbackService($container))]);
    }

    /*
     * Gets the public 'cache.pentatrion_vite_fallback' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_PentatrionViteFallbackService($container)
    {
        return $container->services['cache.pentatrion_vite_fallback'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('qklmknHB3B', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the public 'cache.system' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_SystemService($container)
    {
        return $container->services['cache.system'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('hLnv+kPzv0', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the public 'cache.system_clearer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer
     */
    protected static function getCache_SystemClearerService($container)
    {
        return $container->services['cache.system_clearer'] = new \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer(['cache.system' => ($container->services['cache.system'] ?? self::getCache_SystemService($container)), 'cache.validator' => ($container->privates['cache.validator'] ?? self::getCache_ValidatorService($container)), 'cache.serializer' => ($container->privates['cache.serializer'] ?? self::getCache_SerializerService($container)), 'cache.property_info' => ($container->privates['cache.property_info'] ?? self::getCache_PropertyInfoService($container)), 'cache.property_access' => ($container->privates['cache.property_access'] ?? self::getCache_PropertyAccessService($container)), 'cache.validator_expression_language' => ($container->services['cache.validator_expression_language'] ?? self::getCache_ValidatorExpressionLanguageService($container)), 'cache.pentatrion_vite_fallback' => ($container->services['cache.pentatrion_vite_fallback'] ?? self::getCache_PentatrionViteFallbackService($container))]);
    }

    /*
     * Gets the public 'cache.validator_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected static function getCache_ValidatorExpressionLanguageService($container)
    {
        return $container->services['cache.validator_expression_language'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('rP0vJB4NIf', 0, $container->getParameter('container.build_id'), ($container->targetDir.''.'/pools/system'), ($container->privates['monolog.logger.cache'] ?? self::getMonolog_Logger_CacheService($container)));
    }

    /*
     * Gets the public 'cache_warmer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerAggregate
     */
    protected static function getCacheWarmerService($container)
    {
        return $container->services['cache_warmer'] = new \Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerAggregate(new RewindableGenerator(function () use ($container) {
            yield 0 => ($container->privates['config_builder.warmer'] ?? self::getConfigBuilder_WarmerService($container));
            yield 1 => ($container->privates['translation.warmer'] ?? self::getTranslation_WarmerService($container));
            yield 2 => ($container->privates['router.cache_warmer'] ?? self::getRouter_CacheWarmerService($container));
            yield 3 => ($container->privates['serializer.mapping.cache_warmer'] ?? self::getSerializer_Mapping_CacheWarmerService($container));
            yield 4 => ($container->privates['validator.mapping.cache_warmer'] ?? self::getValidator_Mapping_CacheWarmerService($container));
            yield 5 => ($container->privates['pentatrion_vite.cache_warmer'] ?? self::getPentatrionVite_CacheWarmerService($container));
        }, 6), false, ($container->targetDir.''.'/Shopware_Core_KernelProdContainerDeprecations.log'));
    }

    /*
     * Gets the public 'category.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCategory_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['category.repository'])) {
            return $container->services['category.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['category.repository'])) {
            return $container->services['category.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['category.repository'])) {
            return $container->services['category.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['category.repository'])) {
            return $container->services['category.repository'];
        }

        return $container->services['category.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Content\\Category\\CategoryDefinition'] ?? self::getCategoryDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'category_tag.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCategoryTag_RepositoryService($container)
    {
        return $container->services['category_tag.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition'] ?? self::getCategoryTagDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'category_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCategoryTranslation_RepositoryService($container)
    {
        return $container->services['category_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition'] ?? self::getCategoryTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'checkout.filesystem.private' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected static function getCheckout_Filesystem_PrivateService($container)
    {
        return $container->services['checkout.filesystem.private'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), 'plugins/checkout');
    }

    /*
     * Gets the public 'checkout.filesystem.public' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected static function getCheckout_Filesystem_PublicService($container)
    {
        return $container->services['checkout.filesystem.public'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($container->services['shopware.filesystem.public'] ?? self::getShopware_Filesystem_PublicService($container)), 'plugins/checkout');
    }

    /*
     * Gets the public 'cms_block.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCmsBlock_RepositoryService($container)
    {
        return $container->services['cms_block.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition'] ?? self::getCmsBlockDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'cms_page.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCmsPage_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['cms_page.repository'])) {
            return $container->services['cms_page.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['cms_page.repository'])) {
            return $container->services['cms_page.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['cms_page.repository'])) {
            return $container->services['cms_page.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['cms_page.repository'])) {
            return $container->services['cms_page.repository'];
        }

        return $container->services['cms_page.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Content\\Cms\\CmsPageDefinition'] ?? self::getCmsPageDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'cms_page_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCmsPageTranslation_RepositoryService($container)
    {
        return $container->services['cms_page_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition'] ?? self::getCmsPageTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'cms_section.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCmsSection_RepositoryService($container)
    {
        return $container->services['cms_section.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition'] ?? self::getCmsSectionDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'cms_slot.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCmsSlot_RepositoryService($container)
    {
        return $container->services['cms_slot.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition'] ?? self::getCmsSlotDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'cms_slot_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCmsSlotTranslation_RepositoryService($container)
    {
        return $container->services['cms_slot_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition'] ?? self::getCmsSlotTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'console.command_loader' shared service.
     *
     * @return \Symfony\Component\Console\CommandLoader\ContainerCommandLoader
     */
    protected static function getConsole_CommandLoaderService($container)
    {
        return $container->services['console.command_loader'] = new \Symfony\Component\Console\CommandLoader\ContainerCommandLoader(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'Shopware\\Core\\Framework\\Migration\\Command\\CreateMigrationCommand' => ['privates', '.Shopware\\Core\\Framework\\Migration\\Command\\CreateMigrationCommand.lazy', 'getCreateMigrationCommand_Lazy2Service', false],
            'Shopware\\Core\\Framework\\Migration\\Command\\RefreshMigrationCommand' => ['privates', '.Shopware\\Core\\Framework\\Migration\\Command\\RefreshMigrationCommand.lazy', 'getRefreshMigrationCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Migration\\Command\\MigrationCommand' => ['privates', '.Shopware\\Core\\Framework\\Migration\\Command\\MigrationCommand.lazy', 'getMigrationCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Demodata\\PersonalData\\CleanPersonalDataCommand' => ['privates', '.Shopware\\Core\\Framework\\Demodata\\PersonalData\\CleanPersonalDataCommand.lazy', 'getCleanPersonalDataCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Migration\\Command\\MigrationDestructiveCommand' => ['privates', '.Shopware\\Core\\Framework\\Migration\\Command\\MigrationDestructiveCommand.lazy', 'getMigrationDestructiveCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogCreateCommand' => ['privates', '.Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogCreateCommand.lazy', 'getChangelogCreateCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogReleaseCommand' => ['privates', '.Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogReleaseCommand.lazy', 'getChangelogReleaseCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogChangeCommand' => ['privates', '.Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogChangeCommand.lazy', 'getChangelogChangeCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogCheckCommand' => ['privates', '.Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogCheckCommand.lazy', 'getChangelogCheckCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Feature\\Command\\FeatureDumpCommand' => ['privates', '.Shopware\\Core\\Framework\\Feature\\Command\\FeatureDumpCommand.lazy', 'getFeatureDumpCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Feature\\Command\\FeatureDisableCommand' => ['privates', '.Shopware\\Core\\Framework\\Feature\\Command\\FeatureDisableCommand.lazy', 'getFeatureDisableCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Feature\\Command\\FeatureEnableCommand' => ['privates', '.Shopware\\Core\\Framework\\Feature\\Command\\FeatureEnableCommand.lazy', 'getFeatureEnableCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Feature\\Command\\FeatureListCommand' => ['privates', '.Shopware\\Core\\Framework\\Feature\\Command\\FeatureListCommand.lazy', 'getFeatureListCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Adapter\\Command\\S3FilesystemVisibilityCommand' => ['privates', '.Shopware\\Core\\Framework\\Adapter\\Command\\S3FilesystemVisibilityCommand.lazy', 'getS3FilesystemVisibilityCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Adapter\\Command\\CacheInvalidateDelayedCommand' => ['privates', '.Shopware\\Core\\Framework\\Adapter\\Command\\CacheInvalidateDelayedCommand.lazy', 'getCacheInvalidateDelayedCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Adapter\\Command\\CacheClearAllCommand' => ['privates', '.Shopware\\Core\\Framework\\Adapter\\Command\\CacheClearAllCommand.lazy', 'getCacheClearAllCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Adapter\\Command\\CacheClearHttpCommand' => ['privates', '.Shopware\\Core\\Framework\\Adapter\\Command\\CacheClearHttpCommand.lazy', 'getCacheClearHttpCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Api\\Command\\DumpSchemaCommand' => ['privates', '.Shopware\\Core\\Framework\\Api\\Command\\DumpSchemaCommand.lazy', 'getDumpSchemaCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Api\\Command\\DumpClassSchemaCommand' => ['privates', '.Shopware\\Core\\Framework\\Api\\Command\\DumpClassSchemaCommand.lazy', 'getDumpClassSchemaCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Api\\Command\\CreateIntegrationCommand' => ['privates', '.Shopware\\Core\\Framework\\Api\\Command\\CreateIntegrationCommand.lazy', 'getCreateIntegrationCommand_LazyService', false],
            'Shopware\\Core\\Framework\\App\\Command\\RefreshAppCommand' => ['privates', '.Shopware\\Core\\Framework\\App\\Command\\RefreshAppCommand.lazy', 'getRefreshAppCommand_LazyService', false],
            'Shopware\\Core\\Framework\\App\\Command\\InstallAppCommand' => ['privates', '.Shopware\\Core\\Framework\\App\\Command\\InstallAppCommand.lazy', 'getInstallAppCommand_LazyService', false],
            'Shopware\\Core\\Framework\\App\\Command\\UninstallAppCommand' => ['privates', '.Shopware\\Core\\Framework\\App\\Command\\UninstallAppCommand.lazy', 'getUninstallAppCommand_LazyService', false],
            'Shopware\\Core\\Framework\\App\\Command\\ActivateAppCommand' => ['privates', '.Shopware\\Core\\Framework\\App\\Command\\ActivateAppCommand.lazy', 'getActivateAppCommand_LazyService', false],
            'Shopware\\Core\\Framework\\App\\Command\\DeactivateAppCommand' => ['privates', '.Shopware\\Core\\Framework\\App\\Command\\DeactivateAppCommand.lazy', 'getDeactivateAppCommand_LazyService', false],
            'Shopware\\Core\\Framework\\App\\Command\\CreateAppCommand' => ['privates', '.Shopware\\Core\\Framework\\App\\Command\\CreateAppCommand.lazy', 'getCreateAppCommand_LazyService', false],
            'Shopware\\Core\\Framework\\App\\Command\\ValidateAppCommand' => ['privates', '.Shopware\\Core\\Framework\\App\\Command\\ValidateAppCommand.lazy', 'getValidateAppCommand_LazyService', false],
            'Shopware\\Core\\Framework\\App\\Command\\ResolveAppUrlChangeCommand' => ['privates', '.Shopware\\Core\\Framework\\App\\Command\\ResolveAppUrlChangeCommand.lazy', 'getResolveAppUrlChangeCommand_LazyService', false],
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateEntitiesCommand' => ['privates', '.Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateEntitiesCommand.lazy', 'getCreateEntitiesCommand_LazyService', false],
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateMigrationCommand' => ['privates', '.Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateMigrationCommand.lazy', 'getCreateMigrationCommand_LazyService', false],
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateHydratorCommand' => ['privates', '.Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateHydratorCommand.lazy', 'getCreateHydratorCommand_LazyService', false],
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\RefreshIndexCommand' => ['privates', '.Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\RefreshIndexCommand.lazy', 'getRefreshIndexCommand_LazyService', false],
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\DataAbstractionLayerValidateCommand' => ['privates', '.Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\DataAbstractionLayerValidateCommand.lazy', 'getDataAbstractionLayerValidateCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Demodata\\Command\\DemodataCommand' => ['privates', '.Shopware\\Core\\Framework\\Demodata\\Command\\DemodataCommand.lazy', 'getDemodataCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Event\\Command\\DebugDumpBusinessEventsCommand' => ['privates', '.Shopware\\Core\\Framework\\Event\\Command\\DebugDumpBusinessEventsCommand.lazy', 'getDebugDumpBusinessEventsCommand_LazyService', false],
            'console.command.assets_install' => ['privates', '.console.command.assets_install.lazy', 'get_Console_Command_AssetsInstall_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\BundleDumpCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\BundleDumpCommand.lazy', 'getBundleDumpCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\PluginRefreshCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\PluginRefreshCommand.lazy', 'getPluginRefreshCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\PluginListCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\PluginListCommand.lazy', 'getPluginListCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\PluginZipImportCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\PluginZipImportCommand.lazy', 'getPluginZipImportCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginInstallCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginInstallCommand.lazy', 'getPluginInstallCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginActivateCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginActivateCommand.lazy', 'getPluginActivateCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUpdateCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUpdateCommand.lazy', 'getPluginUpdateCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginDeactivateCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginDeactivateCommand.lazy', 'getPluginDeactivateCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUninstallCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUninstallCommand.lazy', 'getPluginUninstallCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUpdateAllCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUpdateAllCommand.lazy', 'getPluginUpdateAllCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Plugin\\Command\\PluginCreateCommand' => ['privates', '.Shopware\\Core\\Framework\\Plugin\\Command\\PluginCreateCommand.lazy', 'getPluginCreateCommand_LazyService', false],
            'Shopware\\Core\\Framework\\MessageQueue\\Command\\RegisterScheduledTasksCommand' => ['privates', '.Shopware\\Core\\Framework\\MessageQueue\\Command\\RegisterScheduledTasksCommand.lazy', 'getRegisterScheduledTasksCommand_LazyService', false],
            'Shopware\\Core\\Framework\\MessageQueue\\Command\\ScheduledTaskRunner' => ['privates', '.Shopware\\Core\\Framework\\MessageQueue\\Command\\ScheduledTaskRunner.lazy', 'getScheduledTaskRunner_LazyService', false],
            'Shopware\\Core\\Framework\\MessageQueue\\Command\\ListScheduledTaskCommand' => ['privates', '.Shopware\\Core\\Framework\\MessageQueue\\Command\\ListScheduledTaskCommand.lazy', 'getListScheduledTaskCommand_LazyService', false],
            'Shopware\\Core\\Framework\\MessageQueue\\Command\\RunSingleScheduledTaskCommand' => ['privates', '.Shopware\\Core\\Framework\\MessageQueue\\Command\\RunSingleScheduledTaskCommand.lazy', 'getRunSingleScheduledTaskCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Store\\Command\\StoreDownloadCommand' => ['privates', '.Shopware\\Core\\Framework\\Store\\Command\\StoreDownloadCommand.lazy', 'getStoreDownloadCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Store\\Command\\StoreLoginCommand' => ['privates', '.Shopware\\Core\\Framework\\Store\\Command\\StoreLoginCommand.lazy', 'getStoreLoginCommand_LazyService', false],
            'Shopware\\Core\\Framework\\SystemCheck\\Command\\SystemCheckCommand' => ['privates', '.Shopware\\Core\\Framework\\SystemCheck\\Command\\SystemCheckCommand.lazy', 'getSystemCheckCommand_LazyService', false],
            'Shopware\\Core\\System\\Snippet\\Command\\ValidateSnippetsCommand' => ['privates', '.Shopware\\Core\\System\\Snippet\\Command\\ValidateSnippetsCommand.lazy', 'getValidateSnippetsCommand_LazyService', false],
            'Shopware\\Core\\System\\StateMachine\\Command\\WorkflowDumpCommand' => ['privates', '.Shopware\\Core\\System\\StateMachine\\Command\\WorkflowDumpCommand.lazy', 'getWorkflowDumpCommand_LazyService', false],
            'Shopware\\Core\\System\\SystemConfig\\Command\\ConfigGet' => ['privates', '.Shopware\\Core\\System\\SystemConfig\\Command\\ConfigGet.lazy', 'getConfigGet_LazyService', false],
            'Shopware\\Core\\System\\SystemConfig\\Command\\ConfigSet' => ['privates', '.Shopware\\Core\\System\\SystemConfig\\Command\\ConfigSet.lazy', 'getConfigSet_LazyService', false],
            'Shopware\\Core\\System\\NumberRange\\Command\\MigrateIncrementStorageCommand' => ['privates', '.Shopware\\Core\\System\\NumberRange\\Command\\MigrateIncrementStorageCommand.lazy', 'getMigrateIncrementStorageCommand_LazyService', false],
            'Shopware\\Core\\Content\\Media\\Commands\\GenerateThumbnailsCommand' => ['privates', '.Shopware\\Core\\Content\\Media\\Commands\\GenerateThumbnailsCommand.lazy', 'getGenerateThumbnailsCommand_LazyService', false],
            'Shopware\\Core\\Content\\Media\\Commands\\GenerateMediaTypesCommand' => ['privates', '.Shopware\\Core\\Content\\Media\\Commands\\GenerateMediaTypesCommand.lazy', 'getGenerateMediaTypesCommand_LazyService', false],
            'Shopware\\Core\\Content\\Media\\Commands\\DeleteNotUsedMediaCommand' => ['privates', '.Shopware\\Core\\Content\\Media\\Commands\\DeleteNotUsedMediaCommand.lazy', 'getDeleteNotUsedMediaCommand_LazyService', false],
            'Shopware\\Core\\Content\\Media\\Commands\\DeleteThumbnailsCommand' => ['privates', '.Shopware\\Core\\Content\\Media\\Commands\\DeleteThumbnailsCommand.lazy', 'getDeleteThumbnailsCommand_LazyService', false],
            'Shopware\\Core\\Content\\Media\\Infrastructure\\Command\\UpdatePathCommand' => ['privates', '.Shopware\\Core\\Content\\Media\\Infrastructure\\Command\\UpdatePathCommand.lazy', 'getUpdatePathCommand_LazyService', false],
            'Shopware\\Core\\Content\\ProductExport\\Command\\ProductExportGenerateCommand' => ['privates', '.Shopware\\Core\\Content\\ProductExport\\Command\\ProductExportGenerateCommand.lazy', 'getProductExportGenerateCommand_LazyService', false],
            'Shopware\\Core\\Content\\ImportExport\\Command\\DeleteExpiredFilesCommand' => ['privates', '.Shopware\\Core\\Content\\ImportExport\\Command\\DeleteExpiredFilesCommand.lazy', 'getDeleteExpiredFilesCommand_LazyService', false],
            'Shopware\\Core\\Content\\ImportExport\\Command\\ImportEntityCommand' => ['privates', '.Shopware\\Core\\Content\\ImportExport\\Command\\ImportEntityCommand.lazy', 'getImportEntityCommand_LazyService', false],
            'Shopware\\Core\\Content\\Sitemap\\Commands\\SitemapGenerateCommand' => ['privates', '.Shopware\\Core\\Content\\Sitemap\\Commands\\SitemapGenerateCommand.lazy', 'getSitemapGenerateCommand_LazyService', false],
            'Shopware\\Core\\Checkout\\Cart\\Command\\CartMigrateCommand' => ['privates', '.Shopware\\Core\\Checkout\\Cart\\Command\\CartMigrateCommand.lazy', 'getCartMigrateCommand_LazyService', false],
            'Shopware\\Core\\Checkout\\Customer\\Command\\DeleteUnusedGuestCustomersCommand' => ['privates', '.Shopware\\Core\\Checkout\\Customer\\Command\\DeleteUnusedGuestCustomersCommand.lazy', 'getDeleteUnusedGuestCustomersCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemInstallCommand' => ['privates', '.Shopware\\Core\\Maintenance\\System\\Command\\SystemInstallCommand.lazy', 'getSystemInstallCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemIsInstalledCommand' => ['privates', '.Shopware\\Core\\Maintenance\\System\\Command\\SystemIsInstalledCommand.lazy', 'getSystemIsInstalledCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemGenerateAppSecretCommand' => ['privates', '.Shopware\\Core\\Maintenance\\System\\Command\\SystemGenerateAppSecretCommand.lazy', 'getSystemGenerateAppSecretCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemSetupCommand' => ['privates', '.Shopware\\Core\\Maintenance\\System\\Command\\SystemSetupCommand.lazy', 'getSystemSetupCommand_LazyService', false],
            'Symfony\\Component\\Dotenv\\Command\\DotenvDumpCommand' => ['privates', '.Symfony\\Component\\Dotenv\\Command\\DotenvDumpCommand.lazy', 'getDotenvDumpCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemUpdatePrepareCommand' => ['privates', '.Shopware\\Core\\Maintenance\\System\\Command\\SystemUpdatePrepareCommand.lazy', 'getSystemUpdatePrepareCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemUpdateFinishCommand' => ['privates', '.Shopware\\Core\\Maintenance\\System\\Command\\SystemUpdateFinishCommand.lazy', 'getSystemUpdateFinishCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelUpdateDomainCommand' => ['privates', '.Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelUpdateDomainCommand.lazy', 'getSalesChannelUpdateDomainCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemConfigureShopCommand' => ['privates', '.Shopware\\Core\\Maintenance\\System\\Command\\SystemConfigureShopCommand.lazy', 'getSystemConfigureShopCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelCreateCommand' => ['privates', '.Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelCreateCommand.lazy', 'getSalesChannelCreateCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelListCommand' => ['privates', '.Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelListCommand.lazy', 'getSalesChannelListCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelMaintenanceEnableCommand' => ['privates', '.Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelMaintenanceEnableCommand.lazy', 'getSalesChannelMaintenanceEnableCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelMaintenanceDisableCommand' => ['privates', '.Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelMaintenanceDisableCommand.lazy', 'getSalesChannelMaintenanceDisableCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\User\\Command\\UserCreateCommand' => ['privates', '.Shopware\\Core\\Maintenance\\User\\Command\\UserCreateCommand.lazy', 'getUserCreateCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\User\\Command\\UserChangePasswordCommand' => ['privates', '.Shopware\\Core\\Maintenance\\User\\Command\\UserChangePasswordCommand.lazy', 'getUserChangePasswordCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\User\\Command\\UserListCommand' => ['privates', '.Shopware\\Core\\Maintenance\\User\\Command\\UserListCommand.lazy', 'getUserListCommand_LazyService', false],
            'Shopware\\Core\\Maintenance\\Staging\\Command\\SystemSetupStagingCommand' => ['privates', '.Shopware\\Core\\Maintenance\\Staging\\Command\\SystemSetupStagingCommand.lazy', 'getSystemSetupStagingCommand_LazyService', false],
            'Shopware\\Core\\Framework\\Adapter\\Command\\CacheWatchDelayedCommand' => ['privates', '.Shopware\\Core\\Framework\\Adapter\\Command\\CacheWatchDelayedCommand.lazy', 'getCacheWatchDelayedCommand_LazyService', false],
            'Shopware\\Core\\Service\\Command\\Install' => ['privates', '.Shopware\\Core\\Service\\Command\\Install.lazy', 'getInstall_LazyService', false],
            'Shopware\\Administration\\Command\\DeleteAdminFilesAfterBuildCommand' => ['privates', '.Shopware\\Administration\\Command\\DeleteAdminFilesAfterBuildCommand.lazy', 'getDeleteAdminFilesAfterBuildCommand_LazyService', false],
            'Shopware\\Administration\\Command\\DeleteExtensionLocalPublicFilesCommand' => ['privates', '.Shopware\\Administration\\Command\\DeleteExtensionLocalPublicFilesCommand.lazy', 'getDeleteExtensionLocalPublicFilesCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchIndexingCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchIndexingCommand.lazy', 'getElasticsearchIndexingCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchTestAnalyzerCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchTestAnalyzerCommand.lazy', 'getElasticsearchTestAnalyzerCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchStatusCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchStatusCommand.lazy', 'getElasticsearchStatusCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchResetCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchResetCommand.lazy', 'getElasticsearchResetCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchUpdateMappingCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchUpdateMappingCommand.lazy', 'getElasticsearchUpdateMappingCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchCreateAliasCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchCreateAliasCommand.lazy', 'getElasticsearchCreateAliasCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchCleanIndicesCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchCleanIndicesCommand.lazy', 'getElasticsearchCleanIndicesCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminIndexingCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminIndexingCommand.lazy', 'getElasticsearchAdminIndexingCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminResetCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminResetCommand.lazy', 'getElasticsearchAdminResetCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminTestCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminTestCommand.lazy', 'getElasticsearchAdminTestCommand_LazyService', false],
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminUpdateMappingCommand' => ['privates', '.Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminUpdateMappingCommand.lazy', 'getElasticsearchAdminUpdateMappingCommand_LazyService', false],
            'Shopware\\Storefront\\Framework\\Command\\SalesChannelCreateStorefrontCommand' => ['privates', '.Shopware\\Storefront\\Framework\\Command\\SalesChannelCreateStorefrontCommand.lazy', 'getSalesChannelCreateStorefrontCommand_LazyService', false],
            'Shopware\\Storefront\\Theme\\Command\\ThemeCreateCommand' => ['privates', '.Shopware\\Storefront\\Theme\\Command\\ThemeCreateCommand.lazy', 'getThemeCreateCommand_LazyService', false],
            'Shopware\\Storefront\\Theme\\Command\\ThemeChangeCommand' => ['privates', '.Shopware\\Storefront\\Theme\\Command\\ThemeChangeCommand.lazy', 'getThemeChangeCommand_LazyService', false],
            'Shopware\\Storefront\\Theme\\Command\\ThemeCompileCommand' => ['privates', '.Shopware\\Storefront\\Theme\\Command\\ThemeCompileCommand.lazy', 'getThemeCompileCommand_LazyService', false],
            'Shopware\\Storefront\\Theme\\Command\\ThemeDumpCommand' => ['privates', '.Shopware\\Storefront\\Theme\\Command\\ThemeDumpCommand.lazy', 'getThemeDumpCommand_LazyService', false],
            'Shopware\\Storefront\\Theme\\Command\\ThemeRefreshCommand' => ['privates', '.Shopware\\Storefront\\Theme\\Command\\ThemeRefreshCommand.lazy', 'getThemeRefreshCommand_LazyService', false],
            'Shopware\\Storefront\\Theme\\Command\\ThemePrepareIconsCommand' => ['privates', '.Shopware\\Storefront\\Theme\\Command\\ThemePrepareIconsCommand.lazy', 'getThemePrepareIconsCommand_LazyService', false],
            'console.command.about' => ['privates', '.console.command.about.lazy', 'get_Console_Command_About_LazyService', false],
            'console.command.cache_clear' => ['privates', '.console.command.cache_clear.lazy', 'get_Console_Command_CacheClear_LazyService', false],
            'console.command.cache_pool_clear' => ['privates', '.console.command.cache_pool_clear.lazy', 'get_Console_Command_CachePoolClear_LazyService', false],
            'console.command.cache_pool_prune' => ['privates', '.console.command.cache_pool_prune.lazy', 'get_Console_Command_CachePoolPrune_LazyService', false],
            'console.command.cache_pool_invalidate_tags' => ['privates', '.console.command.cache_pool_invalidate_tags.lazy', 'get_Console_Command_CachePoolInvalidateTags_LazyService', false],
            'console.command.cache_pool_delete' => ['privates', '.console.command.cache_pool_delete.lazy', 'get_Console_Command_CachePoolDelete_LazyService', false],
            'console.command.cache_pool_list' => ['privates', '.console.command.cache_pool_list.lazy', 'get_Console_Command_CachePoolList_LazyService', false],
            'console.command.cache_warmup' => ['privates', '.console.command.cache_warmup.lazy', 'get_Console_Command_CacheWarmup_LazyService', false],
            'console.command.config_debug' => ['privates', '.console.command.config_debug.lazy', 'get_Console_Command_ConfigDebug_LazyService', false],
            'console.command.config_dump_reference' => ['privates', '.console.command.config_dump_reference.lazy', 'get_Console_Command_ConfigDumpReference_LazyService', false],
            'console.command.container_debug' => ['privates', '.console.command.container_debug.lazy', 'get_Console_Command_ContainerDebug_LazyService', false],
            'console.command.container_lint' => ['privates', '.console.command.container_lint.lazy', 'get_Console_Command_ContainerLint_LazyService', false],
            'console.command.debug_autowiring' => ['privates', '.console.command.debug_autowiring.lazy', 'get_Console_Command_DebugAutowiring_LazyService', false],
            'console.command.dotenv_debug' => ['privates', '.console.command.dotenv_debug.lazy', 'get_Console_Command_DotenvDebug_LazyService', false],
            'console.command.event_dispatcher_debug' => ['privates', '.console.command.event_dispatcher_debug.lazy', 'get_Console_Command_EventDispatcherDebug_LazyService', false],
            'console.command.messenger_consume_messages' => ['privates', '.console.command.messenger_consume_messages.lazy', 'get_Console_Command_MessengerConsumeMessages_LazyService', false],
            'console.command.messenger_setup_transports' => ['privates', '.console.command.messenger_setup_transports.lazy', 'get_Console_Command_MessengerSetupTransports_LazyService', false],
            'console.command.messenger_debug' => ['privates', '.console.command.messenger_debug.lazy', 'get_Console_Command_MessengerDebug_LazyService', false],
            'console.command.messenger_stop_workers' => ['privates', '.console.command.messenger_stop_workers.lazy', 'get_Console_Command_MessengerStopWorkers_LazyService', false],
            'console.command.messenger_failed_messages_retry' => ['privates', '.console.command.messenger_failed_messages_retry.lazy', 'get_Console_Command_MessengerFailedMessagesRetry_LazyService', false],
            'console.command.messenger_failed_messages_show' => ['privates', '.console.command.messenger_failed_messages_show.lazy', 'get_Console_Command_MessengerFailedMessagesShow_LazyService', false],
            'console.command.messenger_failed_messages_remove' => ['privates', '.console.command.messenger_failed_messages_remove.lazy', 'get_Console_Command_MessengerFailedMessagesRemove_LazyService', false],
            'console.command.messenger_stats' => ['privates', '.console.command.messenger_stats.lazy', 'get_Console_Command_MessengerStats_LazyService', false],
            'console.command.scheduler_debug' => ['privates', '.console.command.scheduler_debug.lazy', 'get_Console_Command_SchedulerDebug_LazyService', false],
            'console.command.router_debug' => ['privates', '.console.command.router_debug.lazy', 'get_Console_Command_RouterDebug_LazyService', false],
            'console.command.router_match' => ['privates', '.console.command.router_match.lazy', 'get_Console_Command_RouterMatch_LazyService', false],
            'console.command.serializer_debug' => ['privates', '.console.command.serializer_debug.lazy', 'get_Console_Command_SerializerDebug_LazyService', false],
            'console.command.translation_debug' => ['privates', '.console.command.translation_debug.lazy', 'get_Console_Command_TranslationDebug_LazyService', false],
            'console.command.translation_extract' => ['privates', '.console.command.translation_extract.lazy', 'get_Console_Command_TranslationExtract_LazyService', false],
            'console.command.validator_debug' => ['privates', '.console.command.validator_debug.lazy', 'get_Console_Command_ValidatorDebug_LazyService', false],
            'console.command.translation_pull' => ['privates', '.console.command.translation_pull.lazy', 'get_Console_Command_TranslationPull_LazyService', false],
            'console.command.translation_push' => ['privates', '.console.command.translation_push.lazy', 'get_Console_Command_TranslationPush_LazyService', false],
            'console.command.xliff_lint' => ['privates', '.console.command.xliff_lint.lazy', 'get_Console_Command_XliffLint_LazyService', false],
            'console.command.yaml_lint' => ['privates', '.console.command.yaml_lint.lazy', 'get_Console_Command_YamlLint_LazyService', false],
            'console.command.translation_lint' => ['privates', '.console.command.translation_lint.lazy', 'get_Console_Command_TranslationLint_LazyService', false],
            'console.command.secrets_set' => ['privates', '.console.command.secrets_set.lazy', 'get_Console_Command_SecretsSet_LazyService', false],
            'console.command.secrets_remove' => ['privates', '.console.command.secrets_remove.lazy', 'get_Console_Command_SecretsRemove_LazyService', false],
            'console.command.secrets_generate_key' => ['privates', '.console.command.secrets_generate_key.lazy', 'get_Console_Command_SecretsGenerateKey_LazyService', false],
            'console.command.secrets_list' => ['privates', '.console.command.secrets_list.lazy', 'get_Console_Command_SecretsList_LazyService', false],
            'console.command.secrets_reveal' => ['privates', '.console.command.secrets_reveal.lazy', 'get_Console_Command_SecretsReveal_LazyService', false],
            'console.command.secrets_decrypt_to_local' => ['privates', '.console.command.secrets_decrypt_to_local.lazy', 'get_Console_Command_SecretsDecryptToLocal_LazyService', false],
            'console.command.secrets_encrypt_from_local' => ['privates', '.console.command.secrets_encrypt_from_local.lazy', 'get_Console_Command_SecretsEncryptFromLocal_LazyService', false],
            'console.command.mailer_test' => ['privates', '.console.command.mailer_test.lazy', 'get_Console_Command_MailerTest_LazyService', false],
            'twig.command.debug' => ['privates', '.twig.command.debug.lazy', 'get_Twig_Command_Debug_LazyService', false],
            'twig.command.lint' => ['privates', '.twig.command.lint.lazy', 'get_Twig_Command_Lint_LazyService', false],
            'make.auto_command.composer_generator' => ['privates', 'make.auto_command.composer_generator', 'getMake_AutoCommand_ComposerGeneratorService', false],
            'make.auto_command.plugin_class_generator' => ['privates', 'make.auto_command.plugin_class_generator', 'getMake_AutoCommand_PluginClassGeneratorService', false],
            'make.auto_command.tests_generator' => ['privates', 'make.auto_command.tests_generator', 'getMake_AutoCommand_TestsGeneratorService', false],
            'make.auto_command.command_generator' => ['privates', 'make.auto_command.command_generator', 'getMake_AutoCommand_CommandGeneratorService', false],
            'make.auto_command.scheduled_task_generator' => ['privates', 'make.auto_command.scheduled_task_generator', 'getMake_AutoCommand_ScheduledTaskGeneratorService', false],
            'make.auto_command.event_subscriber_generator' => ['privates', 'make.auto_command.event_subscriber_generator', 'getMake_AutoCommand_EventSubscriberGeneratorService', false],
            'make.auto_command.storefront_controller_generator' => ['privates', 'make.auto_command.storefront_controller_generator', 'getMake_AutoCommand_StorefrontControllerGeneratorService', false],
            'make.auto_command.store_api_route_generator' => ['privates', 'make.auto_command.store_api_route_generator', 'getMake_AutoCommand_StoreApiRouteGeneratorService', false],
            'make.auto_command.entity_generator' => ['privates', 'make.auto_command.entity_generator', 'getMake_AutoCommand_EntityGeneratorService', false],
            'make.auto_command.config_generator' => ['privates', 'make.auto_command.config_generator', 'getMake_AutoCommand_ConfigGeneratorService', false],
            'make.auto_command.javascript_plugin_generator' => ['privates', 'make.auto_command.javascript_plugin_generator', 'getMake_AutoCommand_JavascriptPluginGeneratorService', false],
            'make.auto_command.admin_module_generator' => ['privates', 'make.auto_command.admin_module_generator', 'getMake_AutoCommand_AdminModuleGeneratorService', false],
            'make.auto_command.custom_fieldset_generator' => ['privates', 'make.auto_command.custom_fieldset_generator', 'getMake_AutoCommand_CustomFieldsetGeneratorService', false],
        ], [
            'Shopware\\Core\\Framework\\Migration\\Command\\CreateMigrationCommand' => '?',
            'Shopware\\Core\\Framework\\Migration\\Command\\RefreshMigrationCommand' => '?',
            'Shopware\\Core\\Framework\\Migration\\Command\\MigrationCommand' => '?',
            'Shopware\\Core\\Framework\\Demodata\\PersonalData\\CleanPersonalDataCommand' => '?',
            'Shopware\\Core\\Framework\\Migration\\Command\\MigrationDestructiveCommand' => '?',
            'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogCreateCommand' => '?',
            'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogReleaseCommand' => '?',
            'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogChangeCommand' => '?',
            'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogCheckCommand' => '?',
            'Shopware\\Core\\Framework\\Feature\\Command\\FeatureDumpCommand' => '?',
            'Shopware\\Core\\Framework\\Feature\\Command\\FeatureDisableCommand' => '?',
            'Shopware\\Core\\Framework\\Feature\\Command\\FeatureEnableCommand' => '?',
            'Shopware\\Core\\Framework\\Feature\\Command\\FeatureListCommand' => '?',
            'Shopware\\Core\\Framework\\Adapter\\Command\\S3FilesystemVisibilityCommand' => '?',
            'Shopware\\Core\\Framework\\Adapter\\Command\\CacheInvalidateDelayedCommand' => '?',
            'Shopware\\Core\\Framework\\Adapter\\Command\\CacheClearAllCommand' => '?',
            'Shopware\\Core\\Framework\\Adapter\\Command\\CacheClearHttpCommand' => '?',
            'Shopware\\Core\\Framework\\Api\\Command\\DumpSchemaCommand' => '?',
            'Shopware\\Core\\Framework\\Api\\Command\\DumpClassSchemaCommand' => '?',
            'Shopware\\Core\\Framework\\Api\\Command\\CreateIntegrationCommand' => '?',
            'Shopware\\Core\\Framework\\App\\Command\\RefreshAppCommand' => '?',
            'Shopware\\Core\\Framework\\App\\Command\\InstallAppCommand' => '?',
            'Shopware\\Core\\Framework\\App\\Command\\UninstallAppCommand' => '?',
            'Shopware\\Core\\Framework\\App\\Command\\ActivateAppCommand' => '?',
            'Shopware\\Core\\Framework\\App\\Command\\DeactivateAppCommand' => '?',
            'Shopware\\Core\\Framework\\App\\Command\\CreateAppCommand' => '?',
            'Shopware\\Core\\Framework\\App\\Command\\ValidateAppCommand' => '?',
            'Shopware\\Core\\Framework\\App\\Command\\ResolveAppUrlChangeCommand' => '?',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateEntitiesCommand' => '?',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateMigrationCommand' => '?',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateHydratorCommand' => '?',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\RefreshIndexCommand' => '?',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\DataAbstractionLayerValidateCommand' => '?',
            'Shopware\\Core\\Framework\\Demodata\\Command\\DemodataCommand' => '?',
            'Shopware\\Core\\Framework\\Event\\Command\\DebugDumpBusinessEventsCommand' => '?',
            'console.command.assets_install' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\BundleDumpCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\PluginRefreshCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\PluginListCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\PluginZipImportCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginInstallCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginActivateCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUpdateCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginDeactivateCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUninstallCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUpdateAllCommand' => '?',
            'Shopware\\Core\\Framework\\Plugin\\Command\\PluginCreateCommand' => '?',
            'Shopware\\Core\\Framework\\MessageQueue\\Command\\RegisterScheduledTasksCommand' => '?',
            'Shopware\\Core\\Framework\\MessageQueue\\Command\\ScheduledTaskRunner' => '?',
            'Shopware\\Core\\Framework\\MessageQueue\\Command\\ListScheduledTaskCommand' => '?',
            'Shopware\\Core\\Framework\\MessageQueue\\Command\\RunSingleScheduledTaskCommand' => '?',
            'Shopware\\Core\\Framework\\Store\\Command\\StoreDownloadCommand' => '?',
            'Shopware\\Core\\Framework\\Store\\Command\\StoreLoginCommand' => '?',
            'Shopware\\Core\\Framework\\SystemCheck\\Command\\SystemCheckCommand' => '?',
            'Shopware\\Core\\System\\Snippet\\Command\\ValidateSnippetsCommand' => '?',
            'Shopware\\Core\\System\\StateMachine\\Command\\WorkflowDumpCommand' => '?',
            'Shopware\\Core\\System\\SystemConfig\\Command\\ConfigGet' => '?',
            'Shopware\\Core\\System\\SystemConfig\\Command\\ConfigSet' => '?',
            'Shopware\\Core\\System\\NumberRange\\Command\\MigrateIncrementStorageCommand' => '?',
            'Shopware\\Core\\Content\\Media\\Commands\\GenerateThumbnailsCommand' => '?',
            'Shopware\\Core\\Content\\Media\\Commands\\GenerateMediaTypesCommand' => '?',
            'Shopware\\Core\\Content\\Media\\Commands\\DeleteNotUsedMediaCommand' => '?',
            'Shopware\\Core\\Content\\Media\\Commands\\DeleteThumbnailsCommand' => '?',
            'Shopware\\Core\\Content\\Media\\Infrastructure\\Command\\UpdatePathCommand' => '?',
            'Shopware\\Core\\Content\\ProductExport\\Command\\ProductExportGenerateCommand' => '?',
            'Shopware\\Core\\Content\\ImportExport\\Command\\DeleteExpiredFilesCommand' => '?',
            'Shopware\\Core\\Content\\ImportExport\\Command\\ImportEntityCommand' => '?',
            'Shopware\\Core\\Content\\Sitemap\\Commands\\SitemapGenerateCommand' => '?',
            'Shopware\\Core\\Checkout\\Cart\\Command\\CartMigrateCommand' => '?',
            'Shopware\\Core\\Checkout\\Customer\\Command\\DeleteUnusedGuestCustomersCommand' => '?',
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemInstallCommand' => '?',
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemIsInstalledCommand' => '?',
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemGenerateAppSecretCommand' => '?',
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemSetupCommand' => '?',
            'Symfony\\Component\\Dotenv\\Command\\DotenvDumpCommand' => '?',
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemUpdatePrepareCommand' => '?',
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemUpdateFinishCommand' => '?',
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelUpdateDomainCommand' => '?',
            'Shopware\\Core\\Maintenance\\System\\Command\\SystemConfigureShopCommand' => '?',
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelCreateCommand' => '?',
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelListCommand' => '?',
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelMaintenanceEnableCommand' => '?',
            'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelMaintenanceDisableCommand' => '?',
            'Shopware\\Core\\Maintenance\\User\\Command\\UserCreateCommand' => '?',
            'Shopware\\Core\\Maintenance\\User\\Command\\UserChangePasswordCommand' => '?',
            'Shopware\\Core\\Maintenance\\User\\Command\\UserListCommand' => '?',
            'Shopware\\Core\\Maintenance\\Staging\\Command\\SystemSetupStagingCommand' => '?',
            'Shopware\\Core\\Framework\\Adapter\\Command\\CacheWatchDelayedCommand' => '?',
            'Shopware\\Core\\Service\\Command\\Install' => '?',
            'Shopware\\Administration\\Command\\DeleteAdminFilesAfterBuildCommand' => '?',
            'Shopware\\Administration\\Command\\DeleteExtensionLocalPublicFilesCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchIndexingCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchTestAnalyzerCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchStatusCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchResetCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchUpdateMappingCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchCreateAliasCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchCleanIndicesCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminIndexingCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminResetCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminTestCommand' => '?',
            'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminUpdateMappingCommand' => '?',
            'Shopware\\Storefront\\Framework\\Command\\SalesChannelCreateStorefrontCommand' => '?',
            'Shopware\\Storefront\\Theme\\Command\\ThemeCreateCommand' => '?',
            'Shopware\\Storefront\\Theme\\Command\\ThemeChangeCommand' => '?',
            'Shopware\\Storefront\\Theme\\Command\\ThemeCompileCommand' => '?',
            'Shopware\\Storefront\\Theme\\Command\\ThemeDumpCommand' => '?',
            'Shopware\\Storefront\\Theme\\Command\\ThemeRefreshCommand' => '?',
            'Shopware\\Storefront\\Theme\\Command\\ThemePrepareIconsCommand' => '?',
            'console.command.about' => '?',
            'console.command.cache_clear' => '?',
            'console.command.cache_pool_clear' => '?',
            'console.command.cache_pool_prune' => '?',
            'console.command.cache_pool_invalidate_tags' => '?',
            'console.command.cache_pool_delete' => '?',
            'console.command.cache_pool_list' => '?',
            'console.command.cache_warmup' => '?',
            'console.command.config_debug' => '?',
            'console.command.config_dump_reference' => '?',
            'console.command.container_debug' => '?',
            'console.command.container_lint' => '?',
            'console.command.debug_autowiring' => '?',
            'console.command.dotenv_debug' => '?',
            'console.command.event_dispatcher_debug' => '?',
            'console.command.messenger_consume_messages' => '?',
            'console.command.messenger_setup_transports' => '?',
            'console.command.messenger_debug' => '?',
            'console.command.messenger_stop_workers' => '?',
            'console.command.messenger_failed_messages_retry' => '?',
            'console.command.messenger_failed_messages_show' => '?',
            'console.command.messenger_failed_messages_remove' => '?',
            'console.command.messenger_stats' => '?',
            'console.command.scheduler_debug' => '?',
            'console.command.router_debug' => '?',
            'console.command.router_match' => '?',
            'console.command.serializer_debug' => '?',
            'console.command.translation_debug' => '?',
            'console.command.translation_extract' => '?',
            'console.command.validator_debug' => '?',
            'console.command.translation_pull' => '?',
            'console.command.translation_push' => '?',
            'console.command.xliff_lint' => '?',
            'console.command.yaml_lint' => '?',
            'console.command.translation_lint' => '?',
            'console.command.secrets_set' => '?',
            'console.command.secrets_remove' => '?',
            'console.command.secrets_generate_key' => '?',
            'console.command.secrets_list' => '?',
            'console.command.secrets_reveal' => '?',
            'console.command.secrets_decrypt_to_local' => '?',
            'console.command.secrets_encrypt_from_local' => '?',
            'console.command.mailer_test' => '?',
            'twig.command.debug' => '?',
            'twig.command.lint' => '?',
            'make.auto_command.composer_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.plugin_class_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.tests_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.command_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.scheduled_task_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.event_subscriber_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.storefront_controller_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.store_api_route_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.entity_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.config_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.javascript_plugin_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.admin_module_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
            'make.auto_command.custom_fieldset_generator' => 'Shopware\\Core\\Framework\\Plugin\\Command\\MakerCommand',
        ]), ['database:create-migration' => 'Shopware\\Core\\Framework\\Migration\\Command\\CreateMigrationCommand', 'database:refresh-migration' => 'Shopware\\Core\\Framework\\Migration\\Command\\RefreshMigrationCommand', 'database:migrate' => 'Shopware\\Core\\Framework\\Migration\\Command\\MigrationCommand', 'database:clean-personal-data' => 'Shopware\\Core\\Framework\\Demodata\\PersonalData\\CleanPersonalDataCommand', 'database:migrate-destructive' => 'Shopware\\Core\\Framework\\Migration\\Command\\MigrationDestructiveCommand', 'changelog:create' => 'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogCreateCommand', 'changelog:release' => 'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogReleaseCommand', 'changelog:change' => 'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogChangeCommand', 'changelog:check' => 'Shopware\\Core\\Framework\\Changelog\\Command\\ChangelogCheckCommand', 'feature:dump' => 'Shopware\\Core\\Framework\\Feature\\Command\\FeatureDumpCommand', 'administration:dump:features' => 'Shopware\\Core\\Framework\\Feature\\Command\\FeatureDumpCommand', 'feature:disable' => 'Shopware\\Core\\Framework\\Feature\\Command\\FeatureDisableCommand', 'feature:enable' => 'Shopware\\Core\\Framework\\Feature\\Command\\FeatureEnableCommand', 'feature:list' => 'Shopware\\Core\\Framework\\Feature\\Command\\FeatureListCommand', 's3:set-visibility' => 'Shopware\\Core\\Framework\\Adapter\\Command\\S3FilesystemVisibilityCommand', 'cache:clear:delayed' => 'Shopware\\Core\\Framework\\Adapter\\Command\\CacheInvalidateDelayedCommand', 'cache:clear:all' => 'Shopware\\Core\\Framework\\Adapter\\Command\\CacheClearAllCommand', 'cache:clear:http' => 'Shopware\\Core\\Framework\\Adapter\\Command\\CacheClearHttpCommand', 'framework:schema' => 'Shopware\\Core\\Framework\\Api\\Command\\DumpSchemaCommand', 'framework:dump:class:schema' => 'Shopware\\Core\\Framework\\Api\\Command\\DumpClassSchemaCommand', 'integration:create' => 'Shopware\\Core\\Framework\\Api\\Command\\CreateIntegrationCommand', 'app:refresh' => 'Shopware\\Core\\Framework\\App\\Command\\RefreshAppCommand', 'app:update' => 'Shopware\\Core\\Framework\\App\\Command\\RefreshAppCommand', 'app:install' => 'Shopware\\Core\\Framework\\App\\Command\\InstallAppCommand', 'app:uninstall' => 'Shopware\\Core\\Framework\\App\\Command\\UninstallAppCommand', 'app:activate' => 'Shopware\\Core\\Framework\\App\\Command\\ActivateAppCommand', 'app:deactivate' => 'Shopware\\Core\\Framework\\App\\Command\\DeactivateAppCommand', 'app:create' => 'Shopware\\Core\\Framework\\App\\Command\\CreateAppCommand', 'app:validate' => 'Shopware\\Core\\Framework\\App\\Command\\ValidateAppCommand', 'app:url-change:resolve' => 'Shopware\\Core\\Framework\\App\\Command\\ResolveAppUrlChangeCommand', 'dal:create:entities' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateEntitiesCommand', 'dal:migration:create' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateMigrationCommand', 'dal:create:hydrators' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\CreateHydratorCommand', 'dal:refresh:index' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\RefreshIndexCommand', 'dal:validate' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Command\\DataAbstractionLayerValidateCommand', 'framework:demodata' => 'Shopware\\Core\\Framework\\Demodata\\Command\\DemodataCommand', 'debug:business-events' => 'Shopware\\Core\\Framework\\Event\\Command\\DebugDumpBusinessEventsCommand', 'assets:install' => 'console.command.assets_install', 'bundle:dump' => 'Shopware\\Core\\Framework\\Plugin\\Command\\BundleDumpCommand', 'administration:dump:plugins' => 'Shopware\\Core\\Framework\\Plugin\\Command\\BundleDumpCommand', 'administration:dump:bundles' => 'Shopware\\Core\\Framework\\Plugin\\Command\\BundleDumpCommand', 'plugin:refresh' => 'Shopware\\Core\\Framework\\Plugin\\Command\\PluginRefreshCommand', 'plugin:list' => 'Shopware\\Core\\Framework\\Plugin\\Command\\PluginListCommand', 'plugin:zip-import' => 'Shopware\\Core\\Framework\\Plugin\\Command\\PluginZipImportCommand', 'plugin:install' => 'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginInstallCommand', 'plugin:activate' => 'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginActivateCommand', 'plugin:update' => 'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUpdateCommand', 'plugin:deactivate' => 'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginDeactivateCommand', 'plugin:uninstall' => 'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUninstallCommand', 'plugin:update:all' => 'Shopware\\Core\\Framework\\Plugin\\Command\\Lifecycle\\PluginUpdateAllCommand', 'plugin:create' => 'Shopware\\Core\\Framework\\Plugin\\Command\\PluginCreateCommand', 'scheduled-task:register' => 'Shopware\\Core\\Framework\\MessageQueue\\Command\\RegisterScheduledTasksCommand', 'scheduled-task:run' => 'Shopware\\Core\\Framework\\MessageQueue\\Command\\ScheduledTaskRunner', 'scheduled-task:list' => 'Shopware\\Core\\Framework\\MessageQueue\\Command\\ListScheduledTaskCommand', 'scheduled-task:run-single' => 'Shopware\\Core\\Framework\\MessageQueue\\Command\\RunSingleScheduledTaskCommand', 'store:download' => 'Shopware\\Core\\Framework\\Store\\Command\\StoreDownloadCommand', 'store:login' => 'Shopware\\Core\\Framework\\Store\\Command\\StoreLoginCommand', 'system:check' => 'Shopware\\Core\\Framework\\SystemCheck\\Command\\SystemCheckCommand', 'snippets:validate' => 'Shopware\\Core\\System\\Snippet\\Command\\ValidateSnippetsCommand', 'state-machine:dump' => 'Shopware\\Core\\System\\StateMachine\\Command\\WorkflowDumpCommand', 'system:config:get' => 'Shopware\\Core\\System\\SystemConfig\\Command\\ConfigGet', 'system:config:set' => 'Shopware\\Core\\System\\SystemConfig\\Command\\ConfigSet', 'number-range:migrate' => 'Shopware\\Core\\System\\NumberRange\\Command\\MigrateIncrementStorageCommand', 'media:generate-thumbnails' => 'Shopware\\Core\\Content\\Media\\Commands\\GenerateThumbnailsCommand', 'media:generate-media-types' => 'Shopware\\Core\\Content\\Media\\Commands\\GenerateMediaTypesCommand', 'media:delete-unused' => 'Shopware\\Core\\Content\\Media\\Commands\\DeleteNotUsedMediaCommand', 'media:delete-local-thumbnails' => 'Shopware\\Core\\Content\\Media\\Commands\\DeleteThumbnailsCommand', 'media:update-path' => 'Shopware\\Core\\Content\\Media\\Infrastructure\\Command\\UpdatePathCommand', 'product-export:generate' => 'Shopware\\Core\\Content\\ProductExport\\Command\\ProductExportGenerateCommand', 'import-export:delete-expired' => 'Shopware\\Core\\Content\\ImportExport\\Command\\DeleteExpiredFilesCommand', 'import:entity' => 'Shopware\\Core\\Content\\ImportExport\\Command\\ImportEntityCommand', 'sitemap:generate' => 'Shopware\\Core\\Content\\Sitemap\\Commands\\SitemapGenerateCommand', 'cart:migrate' => 'Shopware\\Core\\Checkout\\Cart\\Command\\CartMigrateCommand', 'customer:delete-unused-guests' => 'Shopware\\Core\\Checkout\\Customer\\Command\\DeleteUnusedGuestCustomersCommand', 'system:install' => 'Shopware\\Core\\Maintenance\\System\\Command\\SystemInstallCommand', 'system:is-installed' => 'Shopware\\Core\\Maintenance\\System\\Command\\SystemIsInstalledCommand', 'system:generate-app-secret' => 'Shopware\\Core\\Maintenance\\System\\Command\\SystemGenerateAppSecretCommand', 'system:setup' => 'Shopware\\Core\\Maintenance\\System\\Command\\SystemSetupCommand', 'dotenv:dump' => 'Symfony\\Component\\Dotenv\\Command\\DotenvDumpCommand', 'system:update:prepare' => 'Shopware\\Core\\Maintenance\\System\\Command\\SystemUpdatePrepareCommand', 'system:update:finish' => 'Shopware\\Core\\Maintenance\\System\\Command\\SystemUpdateFinishCommand', 'sales-channel:update:domain' => 'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelUpdateDomainCommand', 'system:configure-shop' => 'Shopware\\Core\\Maintenance\\System\\Command\\SystemConfigureShopCommand', 'sales-channel:create' => 'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelCreateCommand', 'sales-channel:list' => 'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelListCommand', 'sales-channel:maintenance:enable' => 'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelMaintenanceEnableCommand', 'sales-channel:maintenance:disable' => 'Shopware\\Core\\Maintenance\\SalesChannel\\Command\\SalesChannelMaintenanceDisableCommand', 'user:create' => 'Shopware\\Core\\Maintenance\\User\\Command\\UserCreateCommand', 'user:change-password' => 'Shopware\\Core\\Maintenance\\User\\Command\\UserChangePasswordCommand', 'user:list' => 'Shopware\\Core\\Maintenance\\User\\Command\\UserListCommand', 'system:setup:staging' => 'Shopware\\Core\\Maintenance\\Staging\\Command\\SystemSetupStagingCommand', 'cache:watch:delayed' => 'Shopware\\Core\\Framework\\Adapter\\Command\\CacheWatchDelayedCommand', 'services:install' => 'Shopware\\Core\\Service\\Command\\Install', 'administration:delete-files-after-build' => 'Shopware\\Administration\\Command\\DeleteAdminFilesAfterBuildCommand', 'administration:delete-extension-local-public-files' => 'Shopware\\Administration\\Command\\DeleteExtensionLocalPublicFilesCommand', 'es:index' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchIndexingCommand', 'es:test:analyzer' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchTestAnalyzerCommand', 'es:status' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchStatusCommand', 'es:reset' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchResetCommand', 'es:mapping:update' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchUpdateMappingCommand', 'es:create:alias' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchCreateAliasCommand', 'es:index:cleanup' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchCleanIndicesCommand', 'es:admin:index' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminIndexingCommand', 'es:admin:reset' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminResetCommand', 'es:admin:test' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminTestCommand', 'es:admin:mapping:update' => 'Shopware\\Elasticsearch\\Framework\\Command\\ElasticsearchAdminUpdateMappingCommand', 'sales-channel:create:storefront' => 'Shopware\\Storefront\\Framework\\Command\\SalesChannelCreateStorefrontCommand', 'theme:create' => 'Shopware\\Storefront\\Theme\\Command\\ThemeCreateCommand', 'theme:change' => 'Shopware\\Storefront\\Theme\\Command\\ThemeChangeCommand', 'theme:compile' => 'Shopware\\Storefront\\Theme\\Command\\ThemeCompileCommand', 'theme:dump' => 'Shopware\\Storefront\\Theme\\Command\\ThemeDumpCommand', 'theme:refresh' => 'Shopware\\Storefront\\Theme\\Command\\ThemeRefreshCommand', 'theme:prepare-icons' => 'Shopware\\Storefront\\Theme\\Command\\ThemePrepareIconsCommand', 'about' => 'console.command.about', 'cache:clear' => 'console.command.cache_clear', 'cache:pool:clear' => 'console.command.cache_pool_clear', 'cache:pool:prune' => 'console.command.cache_pool_prune', 'cache:pool:invalidate-tags' => 'console.command.cache_pool_invalidate_tags', 'cache:pool:delete' => 'console.command.cache_pool_delete', 'cache:pool:list' => 'console.command.cache_pool_list', 'cache:warmup' => 'console.command.cache_warmup', 'debug:config' => 'console.command.config_debug', 'config:dump-reference' => 'console.command.config_dump_reference', 'debug:container' => 'console.command.container_debug', 'lint:container' => 'console.command.container_lint', 'debug:autowiring' => 'console.command.debug_autowiring', 'debug:dotenv' => 'console.command.dotenv_debug', 'debug:event-dispatcher' => 'console.command.event_dispatcher_debug', 'messenger:consume' => 'console.command.messenger_consume_messages', 'messenger:setup-transports' => 'console.command.messenger_setup_transports', 'debug:messenger' => 'console.command.messenger_debug', 'messenger:stop-workers' => 'console.command.messenger_stop_workers', 'messenger:failed:retry' => 'console.command.messenger_failed_messages_retry', 'messenger:failed:show' => 'console.command.messenger_failed_messages_show', 'messenger:failed:remove' => 'console.command.messenger_failed_messages_remove', 'messenger:stats' => 'console.command.messenger_stats', 'debug:scheduler' => 'console.command.scheduler_debug', 'debug:router' => 'console.command.router_debug', 'router:match' => 'console.command.router_match', 'debug:serializer' => 'console.command.serializer_debug', 'debug:translation' => 'console.command.translation_debug', 'translation:extract' => 'console.command.translation_extract', 'debug:validator' => 'console.command.validator_debug', 'translation:pull' => 'console.command.translation_pull', 'translation:push' => 'console.command.translation_push', 'lint:xliff' => 'console.command.xliff_lint', 'lint:yaml' => 'console.command.yaml_lint', 'lint:translations' => 'console.command.translation_lint', 'secrets:set' => 'console.command.secrets_set', 'secrets:remove' => 'console.command.secrets_remove', 'secrets:generate-keys' => 'console.command.secrets_generate_key', 'secrets:list' => 'console.command.secrets_list', 'secrets:reveal' => 'console.command.secrets_reveal', 'secrets:decrypt-to-local' => 'console.command.secrets_decrypt_to_local', 'secrets:encrypt-from-local' => 'console.command.secrets_encrypt_from_local', 'mailer:test' => 'console.command.mailer_test', 'debug:twig' => 'twig.command.debug', 'lint:twig' => 'twig.command.lint', 'make:plugin:composer' => 'make.auto_command.composer_generator', 'make:plugin:plugin-class' => 'make.auto_command.plugin_class_generator', 'make:plugin:tests' => 'make.auto_command.tests_generator', 'make:plugin:command' => 'make.auto_command.command_generator', 'make:plugin:scheduled-task' => 'make.auto_command.scheduled_task_generator', 'make:plugin:event-subscriber' => 'make.auto_command.event_subscriber_generator', 'make:plugin:storefront-controller' => 'make.auto_command.storefront_controller_generator', 'make:plugin:store-api-route' => 'make.auto_command.store_api_route_generator', 'make:plugin:entity' => 'make.auto_command.entity_generator', 'make:plugin:config' => 'make.auto_command.config_generator', 'make:plugin:javascript-plugin' => 'make.auto_command.javascript_plugin_generator', 'make:plugin:admin-module' => 'make.auto_command.admin_module_generator', 'make:plugin:custom-fieldset' => 'make.auto_command.custom_fieldset_generator']);
    }

    /*
     * Gets the public 'container.env_var_processors_locator' shared service.
     *
     * @return \Symfony\Component\DependencyInjection\ServiceLocator
     */
    protected static function getContainer_EnvVarProcessorsLocatorService($container)
    {
        return $container->services['container.env_var_processors_locator'] = new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'base64' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'bool' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'not' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'const' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'csv' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'file' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'float' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'int' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'json' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'key' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'url' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'query_string' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'resolve' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'default' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'string' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'trim' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'require' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'enum' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'shuffle' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'defined' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
            'urlencode' => ['privates', 'container.env_var_processor', 'getContainer_EnvVarProcessorService', false],
        ], [
            'base64' => '?',
            'bool' => '?',
            'not' => '?',
            'const' => '?',
            'csv' => '?',
            'file' => '?',
            'float' => '?',
            'int' => '?',
            'json' => '?',
            'key' => '?',
            'url' => '?',
            'query_string' => '?',
            'resolve' => '?',
            'default' => '?',
            'string' => '?',
            'trim' => '?',
            'require' => '?',
            'enum' => '?',
            'shuffle' => '?',
            'defined' => '?',
            'urlencode' => '?',
        ]);
    }

    /*
     * Gets the public 'container.get_routing_condition_service' shared service.
     *
     * @return \Closure
     */
    protected static function getContainer_GetRoutingConditionServiceService($container)
    {
        return $container->services['container.get_routing_condition_service'] = ($container->privates['.service_locator.GIuJv7e'] ??= new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [], []))->get(...);
    }

    /*
     * Gets the public 'content.filesystem.private' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected static function getContent_Filesystem_PrivateService($container)
    {
        return $container->services['content.filesystem.private'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), 'plugins/content');
    }

    /*
     * Gets the public 'content.filesystem.public' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected static function getContent_Filesystem_PublicService($container)
    {
        return $container->services['content.filesystem.public'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($container->services['shopware.filesystem.public'] ?? self::getShopware_Filesystem_PublicService($container)), 'plugins/content');
    }

    /*
     * Gets the public 'country.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCountry_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['country.repository'])) {
            return $container->services['country.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['country.repository'])) {
            return $container->services['country.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['country.repository'])) {
            return $container->services['country.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['country.repository'])) {
            return $container->services['country.repository'];
        }

        return $container->services['country.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\Country\\CountryDefinition'] ?? self::getCountryDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'country_state.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCountryState_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['country_state.repository'])) {
            return $container->services['country_state.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['country_state.repository'])) {
            return $container->services['country_state.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['country_state.repository'])) {
            return $container->services['country_state.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['country_state.repository'])) {
            return $container->services['country_state.repository'];
        }

        return $container->services['country_state.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\CountryStateDefinition'] ?? self::getCountryStateDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'country_state_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCountryStateTranslation_RepositoryService($container)
    {
        return $container->services['country_state_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition'] ?? self::getCountryStateTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'country_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCountryTranslation_RepositoryService($container)
    {
        return $container->services['country_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition'] ?? self::getCountryTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'currency.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCurrency_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['currency.repository'])) {
            return $container->services['currency.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['currency.repository'])) {
            return $container->services['currency.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['currency.repository'])) {
            return $container->services['currency.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['currency.repository'])) {
            return $container->services['currency.repository'];
        }

        return $container->services['currency.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\Currency\\CurrencyDefinition'] ?? self::getCurrencyDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'currency_country_rounding.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCurrencyCountryRounding_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['currency_country_rounding.repository'])) {
            return $container->services['currency_country_rounding.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['currency_country_rounding.repository'])) {
            return $container->services['currency_country_rounding.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['currency_country_rounding.repository'])) {
            return $container->services['currency_country_rounding.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['currency_country_rounding.repository'])) {
            return $container->services['currency_country_rounding.repository'];
        }

        return $container->services['currency_country_rounding.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition'] ?? self::getCurrencyCountryRoundingDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'currency_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCurrencyTranslation_RepositoryService($container)
    {
        return $container->services['currency_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition'] ?? self::getCurrencyTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'custom_entity.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomEntity_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['custom_entity.repository'])) {
            return $container->services['custom_entity.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['custom_entity.repository'])) {
            return $container->services['custom_entity.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['custom_entity.repository'])) {
            return $container->services['custom_entity.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['custom_entity.repository'])) {
            return $container->services['custom_entity.repository'];
        }

        return $container->services['custom_entity.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition'] ?? self::getCustomEntityDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'custom_field.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomField_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['custom_field.repository'])) {
            return $container->services['custom_field.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['custom_field.repository'])) {
            return $container->services['custom_field.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['custom_field.repository'])) {
            return $container->services['custom_field.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['custom_field.repository'])) {
            return $container->services['custom_field.repository'];
        }

        return $container->services['custom_field.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\CustomField\\CustomFieldDefinition'] ?? self::getCustomFieldDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'custom_field_set.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomFieldSet_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['custom_field_set.repository'])) {
            return $container->services['custom_field_set.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['custom_field_set.repository'])) {
            return $container->services['custom_field_set.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['custom_field_set.repository'])) {
            return $container->services['custom_field_set.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['custom_field_set.repository'])) {
            return $container->services['custom_field_set.repository'];
        }

        return $container->services['custom_field_set.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition'] ?? self::getCustomFieldSetDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'custom_field_set_relation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomFieldSetRelation_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['custom_field_set_relation.repository'])) {
            return $container->services['custom_field_set_relation.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['custom_field_set_relation.repository'])) {
            return $container->services['custom_field_set_relation.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['custom_field_set_relation.repository'])) {
            return $container->services['custom_field_set_relation.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['custom_field_set_relation.repository'])) {
            return $container->services['custom_field_set_relation.repository'];
        }

        return $container->services['custom_field_set_relation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition'] ?? self::getCustomFieldSetRelationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'customer.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomer_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['customer.repository'])) {
            return $container->services['customer.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['customer.repository'])) {
            return $container->services['customer.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['customer.repository'])) {
            return $container->services['customer.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['customer.repository'])) {
            return $container->services['customer.repository'];
        }

        return $container->services['customer.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Customer\\CustomerDefinition'] ?? self::getCustomerDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'customer_address.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomerAddress_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['customer_address.repository'])) {
            return $container->services['customer_address.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['customer_address.repository'])) {
            return $container->services['customer_address.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['customer_address.repository'])) {
            return $container->services['customer_address.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['customer_address.repository'])) {
            return $container->services['customer_address.repository'];
        }

        return $container->services['customer_address.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition'] ?? self::getCustomerAddressDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'customer_group.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomerGroup_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['customer_group.repository'])) {
            return $container->services['customer_group.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['customer_group.repository'])) {
            return $container->services['customer_group.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['customer_group.repository'])) {
            return $container->services['customer_group.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['customer_group.repository'])) {
            return $container->services['customer_group.repository'];
        }

        return $container->services['customer_group.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition'] ?? self::getCustomerGroupDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'customer_group_registration_sales_channels.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomerGroupRegistrationSalesChannels_RepositoryService($container)
    {
        return $container->services['customer_group_registration_sales_channels.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition'] ?? self::getCustomerGroupRegistrationSalesChannelDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'customer_group_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomerGroupTranslation_RepositoryService($container)
    {
        return $container->services['customer_group_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition'] ?? self::getCustomerGroupTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'customer_recovery.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomerRecovery_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['customer_recovery.repository'])) {
            return $container->services['customer_recovery.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['customer_recovery.repository'])) {
            return $container->services['customer_recovery.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['customer_recovery.repository'])) {
            return $container->services['customer_recovery.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['customer_recovery.repository'])) {
            return $container->services['customer_recovery.repository'];
        }

        return $container->services['customer_recovery.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition'] ?? self::getCustomerRecoveryDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'customer_tag.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomerTag_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['customer_tag.repository'])) {
            return $container->services['customer_tag.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['customer_tag.repository'])) {
            return $container->services['customer_tag.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['customer_tag.repository'])) {
            return $container->services['customer_tag.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['customer_tag.repository'])) {
            return $container->services['customer_tag.repository'];
        }

        return $container->services['customer_tag.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition'] ?? self::getCustomerTagDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'customer_wishlist.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomerWishlist_RepositoryService($container)
    {
        return $container->services['customer_wishlist.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition'] ?? self::getCustomerWishlistDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'customer_wishlist_product.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getCustomerWishlistProduct_RepositoryService($container)
    {
        return $container->services['customer_wishlist_product.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition'] ?? self::getCustomerWishlistProductDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'debug.error_handler_configurator' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Debug\ErrorHandlerConfigurator
     */
    protected static function getDebug_ErrorHandlerConfiguratorService($container)
    {
        $a = new \Monolog\Logger('php');
        $a->pushHandler(($container->privates['monolog.handler.console'] ?? self::getMonolog_Handler_ConsoleService($container)));
        $a->pushHandler(($container->privates['Shopware\\Core\\Framework\\Log\\Monolog\\ExcludeFlowEventHandler'] ?? self::getExcludeFlowEventHandlerService($container)));

        return $container->services['debug.error_handler_configurator'] = new \Symfony\Component\HttpKernel\Debug\ErrorHandlerConfigurator($a, NULL, 0, false, false, NULL);
    }

    /*
     * Gets the public 'delivery_time.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getDeliveryTime_RepositoryService($container)
    {
        return $container->services['delivery_time.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition'] ?? self::getDeliveryTimeDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'delivery_time_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getDeliveryTimeTranslation_RepositoryService($container)
    {
        return $container->services['delivery_time_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition'] ?? self::getDeliveryTimeTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'document.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getDocument_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['document.repository'])) {
            return $container->services['document.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['document.repository'])) {
            return $container->services['document.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['document.repository'])) {
            return $container->services['document.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['document.repository'])) {
            return $container->services['document.repository'];
        }

        return $container->services['document.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Document\\DocumentDefinition'] ?? self::getDocumentDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'document_base_config.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getDocumentBaseConfig_RepositoryService($container)
    {
        $a = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container));

        if (isset($container->services['document_base_config.repository'])) {
            return $container->services['document_base_config.repository'];
        }
        $b = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container));

        if (isset($container->services['document_base_config.repository'])) {
            return $container->services['document_base_config.repository'];
        }
        $c = ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container));

        if (isset($container->services['document_base_config.repository'])) {
            return $container->services['document_base_config.repository'];
        }
        $d = ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container));

        if (isset($container->services['document_base_config.repository'])) {
            return $container->services['document_base_config.repository'];
        }

        return $container->services['document_base_config.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition'] ?? self::getDocumentBaseConfigDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), $a, $b, $c, $d, ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'document_base_config_sales_channel.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getDocumentBaseConfigSalesChannel_RepositoryService($container)
    {
        return $container->services['document_base_config_sales_channel.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition'] ?? self::getDocumentBaseConfigSalesChannelDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'document_type.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getDocumentType_RepositoryService($container)
    {
        return $container->services['document_type.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition'] ?? self::getDocumentTypeDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'document_type_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected static function getDocumentTypeTranslation_RepositoryService($container)
    {
        return $container->services['document_type_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($container->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition'] ?? self::getDocumentTypeTranslationDefinitionService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? self::getEntityReaderInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? self::getVersionManagerService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? self::getEntitySearcherInterfaceService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? self::getEntityAggregatorInterfaceService($container)), ($container->services['event_dispatcher'] ?? self::getEventDispatcherService($container)), ($container->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? self::getEntityLoadedEventFactoryService($container)));
    }

    /*
     * Gets the public 'elasticsearch.filesystem.private' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected static function getElasticsearch_Filesystem_PrivateService($container)
    {
        return $container->services['elasticsearch.filesystem.private'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($container->services['shopware.filesystem.private'] ?? self::getShopware_Filesystem_PrivateService($container)), 'plugins/elasticsearch');
    }

    /*
     * Gets the public 'elasticsearch.filesystem.public' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected static function getElasticsearch_Filesystem_PublicService($container)
    {
        return $container->services['elasticsearch.filesystem.public'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($container->services['shopware.filesystem.public'] ?? self::getShopware_Filesystem_PublicService($container)), 'plugins/elasticsearch');
    }

    /*
     * Gets the public 'error_controller' shared service.
     *
     * @return \Symfony\Component\HttpKernel\Controller\ErrorController
     */
    protected static function getErrorController2Service($container)
    {
        $a = ($container->services['request_stack'] ??= new \Symfony\Component\HttpFoundation\RequestStack());

        return $container->services['error_controller'] = new \Symfony\Component\HttpKernel\Controller\ErrorController(($container->services['http_kernel'] ?? self::getHttpKernelService($container)), 'error_controller', new \Symfony\Component\ErrorHandler\ErrorRenderer\SerializerErrorRenderer(($container->privates['serializer'] ?? self::getSerializerService($container)), \Symfony\Component\ErrorHandler\ErrorRenderer\SerializerErrorRenderer::getPreferredFormat($a), new \Symfony\Bridge\Twig\ErrorRenderer\TwigErrorRenderer(($container->services['twig'] ?? self::getTwigService($container)), new \Symfony\Component\ErrorHandler\ErrorRenderer\HtmlErrorRenderer(\Symfony\Component\ErrorHandler\ErrorRenderer\HtmlErrorRenderer::isDebug($a, false), 'UTF-8', ($container->privates['debug.file_link_formatter'] ??= new \Symfony\Component\ErrorHandler\ErrorRenderer\FileLinkFormatter(NULL)), \dirname(__DIR__, 4), \Symfony\Component\ErrorHandler\ErrorRenderer\HtmlErrorRenderer::getAndCleanOutputBuffer($a), ($container->privates['monolog.logger'] ?? self::getMonolog_LoggerService($container))), \Symfony\Bridge\Twig\ErrorRenderer\TwigErrorRenderer::isDebug($a, false)), \Symfony\Component\ErrorHandler\ErrorRenderer\HtmlErrorRenderer::isDebug($a, false)));
    }

    /*
     * Gets the public 'event_dispatcher' shared service.
     *
     * @return \Shopware\Core\Framework\Event\NestedEventDispatcher
     */
    protected static function getEventDispatcherService($container)
    {
        $container->services['event_dispatcher'] = $instance = new \Shopware\Core\Framework\Event\NestedEventDispatcher(new \Shopware\Core\Framework\Webhook\WebhookDispatcher(new \Shopware\Core\Content\Flow\Dispatching\FlowDispatcher(new \Symfony\Component\EventDispatcher\EventDispatcher(), new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($container->getService ??= $container->getService(...), [
            'logger' => ['privates', 'monolog.logger', 'getMonolog_LoggerService', false],
            'Doctrine\\DBAL\\Connection' => ['services', 'Doctrine\\DBAL\\Connection', 'getConnectionService', false],
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowFactory' => ['services', 'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowFactory', 'getFlowFactoryService', false],
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor' => ['services', 'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor', 'getFlowExecutorService', false],
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowLoader' => ['services', 'Shopware\\Core\\Content\\Flow\\Dispatching\\CachedFlowLoader', 'getCachedFlowLoaderService', false],
            'Shopware\\Core\\Content\\Flow\\Dispatching\\BufferedFlowQueue' => ['privates', 'Shopware\\Core\\Content\\Flow\\Dispatching\\BufferedFlowQueue', 'getBufferedFlowQueueService', false],
        ], [
            'logger' => '?',
            'Doctrine\\DBAL\\Connection' => '?',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowFactory' => '?',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor' => '?',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowLoader' => '?',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\BufferedFlowQueue' => '?',
        ])), ($container->privates['Shopware\\Core\\Framework\\Webhook\\Service\\WebhookManager'] ?? self::getWebhookManagerService($container))));

        $instance->addListener('kernel.request', [#[\Closure(name: 'Shopware\\Core\\Framework\\Routing\\RouteParamsCleanupListener')] fn () => ($container->privates['Shopware\\Core\\Framework\\Routing\\RouteParamsCleanupListener'] ??= new \Shopware\Core\Framework\Routing\RouteParamsCleanupListener()), '__invoke'], 0);
        $instance->addListener('Shopware\\Core\\Content\\Category\\Event\\CategoryIndexerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateCategoryRouteByCategoryIds'], 2000);
        $instance->addListener('Shopware\\Core\\Content\\LandingPage\\Event\\LandingPageIndexerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateIndexedLandingPages'], 2000);
        $instance->addListener('Shopware\\Core\\Content\\Product\\Events\\InvalidateProductCache', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateProduct'], 2001);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateCmsPageIds'], 2001);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateCurrencyRoute'], 2002);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateLanguageRoute'], 2003);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateNavigationRoute'], 2004);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidatePaymentMethodRoute'], 2005);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateManufacturerFilters'], 2007);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidatePropertyFilters'], 2008);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateContext'], 2010);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateShippingMethodRoute'], 2011);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateSnippets'], 2012);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateStreamsBeforeIndexing'], 2013);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateStreamIds'], 2014);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateCountryRoute'], 2015);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateSalutationRoute'], 2016);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateInitialStateIdLoader'], 2017);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWrittenContainerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateCountryStateRoute'], 2018);
        $instance->addListener('Shopware\\Core\\Content\\Rule\\Event\\RuleIndexerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateRules'], 2000);
        $instance->addListener('Shopware\\Core\\Framework\\Plugin\\Event\\PluginPostInstallEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateRules'], 2000);
        $instance->addListener('Shopware\\Core\\Framework\\Plugin\\Event\\PluginPostInstallEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateConfig'], 2001);
        $instance->addListener('Shopware\\Core\\Framework\\Plugin\\Event\\PluginPostActivateEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateRules'], 2000);
        $instance->addListener('Shopware\\Core\\Framework\\Plugin\\Event\\PluginPostActivateEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateConfig'], 2001);
        $instance->addListener('Shopware\\Core\\Framework\\Plugin\\Event\\PluginPostUpdateEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateRules'], 2000);
        $instance->addListener('Shopware\\Core\\Framework\\Plugin\\Event\\PluginPostUpdateEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateConfig'], 2001);
        $instance->addListener('Shopware\\Core\\Framework\\Plugin\\Event\\PluginPostDeactivateEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateRules'], 2000);
        $instance->addListener('Shopware\\Core\\Framework\\Plugin\\Event\\PluginPostDeactivateEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateConfig'], 2001);
        $instance->addListener('Shopware\\Core\\System\\SystemConfig\\Event\\SystemConfigChangedHook', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateConfigKey'], 2000);
        $instance->addListener('Shopware\\Core\\Content\\Sitemap\\Event\\SitemapGeneratedEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateSitemap'], 2000);
        $instance->addListener('Shopware\\Core\\Content\\Media\\Event\\MediaIndexerEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidationSubscriber'] ?? self::getCacheInvalidationSubscriberService($container)), 'invalidateMedia'], 2000);
        $instance->addListener('Shopware\\Core\\Framework\\Adapter\\Cache\\Event\\AddCacheTagEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheTagCollector')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheTagCollector'] ?? self::getCacheTagCollectorService($container)), '__invoke'], 0);
        $instance->addListener('Shopware\\Core\\Framework\\Event\\BeforeSendResponseEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Cache\\Http\\CacheControlListener')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\Http\\CacheControlListener'] ??= new \Shopware\Core\Framework\Adapter\Cache\Http\CacheControlListener(false)), '__invoke'], 0);
        $instance->addListener('console.terminate', [#[\Closure(name: 'Shopware\\Core\\Framework\\App\\ActiveAppsLoader')] fn () => ($container->privates['Shopware\\Core\\Framework\\App\\ActiveAppsLoader'] ?? self::getActiveAppsLoaderService($container)), 'reset'], 0);
        $instance->addListener('Symfony\\Component\\Messenger\\Event\\SendMessageToTransportsEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\MessageQueue\\Subscriber\\MessageQueueSizeRestrictListener')] fn () => ($container->privates['Shopware\\Core\\Framework\\MessageQueue\\Subscriber\\MessageQueueSizeRestrictListener'] ?? self::getMessageQueueSizeRestrictListenerService($container)), '__invoke'], 0);
        $instance->addListener('Shopware\\Storefront\\Event\\StorefrontRenderEvent', [#[\Closure(name: 'Shopware\\Core\\System\\SalesChannel\\Subscriber\\SalesChannelAnalyticsLoader')] fn () => ($container->privates['Shopware\\Core\\System\\SalesChannel\\Subscriber\\SalesChannelAnalyticsLoader'] ?? self::getSalesChannelAnalyticsLoaderService($container)), 'loadAnalytics'], 2000);
        $instance->addListener('media.loaded', [#[\Closure(name: 'Shopware\\Core\\Content\\Media\\Subscriber\\MediaLoadedSubscriber')] fn () => ($container->privates['Shopware\\Core\\Content\\Media\\Subscriber\\MediaLoadedSubscriber'] ??= new \Shopware\Core\Content\Media\Subscriber\MediaLoadedSubscriber()), 'unserialize'], 100);
        $instance->addListener('media.loaded', [#[\Closure(name: 'Shopware\\Core\\Content\\Media\\Core\\Application\\MediaUrlLoader')] fn () => ($container->privates['Shopware\\Core\\Content\\Media\\Core\\Application\\MediaUrlLoader'] ?? self::getMediaUrlLoaderService($container)), 'loaded'], 20);
        $instance->addListener('media.partial_loaded', [#[\Closure(name: 'Shopware\\Core\\Content\\Media\\Core\\Application\\MediaUrlLoader')] fn () => ($container->privates['Shopware\\Core\\Content\\Media\\Core\\Application\\MediaUrlLoader'] ?? self::getMediaUrlLoaderService($container)), 'loaded'], 19);
        $instance->addListener('Shopware\\Core\\Content\\Media\\Core\\Event\\UpdateMediaPathEvent', [#[\Closure(name: 'Shopware\\Core\\Content\\Media\\Core\\Application\\MediaPathUpdater')] fn () => ($container->privates['Shopware\\Core\\Content\\Media\\Core\\Application\\MediaPathUpdater'] ?? self::getMediaPathUpdaterService($container)), 'updateMedia'], 0);
        $instance->addListener('Shopware\\Core\\Content\\Media\\Core\\Event\\UpdateThumbnailPathEvent', [#[\Closure(name: 'Shopware\\Core\\Content\\Media\\Core\\Application\\MediaPathUpdater')] fn () => ($container->privates['Shopware\\Core\\Content\\Media\\Core\\Application\\MediaPathUpdater'] ?? self::getMediaPathUpdaterService($container)), 'updateThumbnails'], 0);
        $instance->addListener('Shopware\\Core\\Content\\Media\\Event\\MediaPathChangedEvent', [#[\Closure(name: 'Shopware\\Core\\Content\\Media\\Infrastructure\\Path\\BanMediaUrl')] fn () => ($container->privates['Shopware\\Core\\Content\\Media\\Infrastructure\\Path\\BanMediaUrl'] ?? self::getBanMediaUrlService($container)), 'changed'], 0);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityWriteEvent', [#[\Closure(name: 'Shopware\\Core\\Content\\Product\\Stock\\AvailableStockMirrorSubscriber')] fn () => ($container->privates['Shopware\\Core\\Content\\Product\\Stock\\AvailableStockMirrorSubscriber'] ??= new \Shopware\Core\Content\Product\Stock\AvailableStockMirrorSubscriber()), '__invoke'], 0);
        $instance->addListener('Shopware\\Core\\Maintenance\\Staging\\Event\\SetupStagingEvent', [#[\Closure(name: 'Shopware\\Core\\Maintenance\\Staging\\Handler\\StagingAppHandler')] fn () => ($container->privates['Shopware\\Core\\Maintenance\\Staging\\Handler\\StagingAppHandler'] ?? self::getStagingAppHandlerService($container)), '__invoke'], 0);
        $instance->addListener('Shopware\\Core\\Maintenance\\Staging\\Event\\SetupStagingEvent', [#[\Closure(name: 'Shopware\\Core\\Maintenance\\Staging\\Handler\\StagingMailHandler')] fn () => ($container->privates['Shopware\\Core\\Maintenance\\Staging\\Handler\\StagingMailHandler'] ?? self::getStagingMailHandlerService($container)), '__invoke'], 0);
        $instance->addListener('Shopware\\Core\\Maintenance\\Staging\\Event\\SetupStagingEvent', [#[\Closure(name: 'Shopware\\Core\\Maintenance\\Staging\\Handler\\StagingSalesChannelHandler')] fn () => ($container->privates['Shopware\\Core\\Maintenance\\Staging\\Handler\\StagingSalesChannelHandler'] ?? self::getStagingSalesChannelHandlerService($container)), '__invoke'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'Shopware\\Core\\Profiling\\Integration\\ServerTiming')] fn () => ($container->privates['Shopware\\Core\\Profiling\\Integration\\ServerTiming'] ??= new \Shopware\Core\Profiling\Integration\ServerTiming()), 'onResponseEvent'], 0);
        $instance->addListener('Shopware\\Core\\Framework\\Update\\Event\\UpdatePostFinishEvent', [#[\Closure(name: 'Shopware\\Elasticsearch\\Framework\\SystemUpdateListener')] fn () => ($container->privates['Shopware\\Elasticsearch\\Framework\\SystemUpdateListener'] ?? self::getSystemUpdateListenerService($container)), '__invoke'], 0);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Shopware\\Storefront\\Framework\\Twig\\TwigDateRequestListener')] fn () => ($container->privates['Shopware\\Storefront\\Framework\\Twig\\TwigDateRequestListener'] ??= new \Shopware\Storefront\Framework\Twig\TwigDateRequestListener($container)), '__invoke'], 0);
        $instance->addListener('Shopware\\Core\\Framework\\Event\\BeforeSendResponseEvent', [#[\Closure(name: 'Shopware\\Storefront\\Framework\\Routing\\CanonicalLinkListener')] fn () => ($container->privates['Shopware\\Storefront\\Framework\\Routing\\CanonicalLinkListener'] ??= new \Shopware\Storefront\Framework\Routing\CanonicalLinkListener()), '__invoke'], 0);
        $instance->addListener('kernel.exception', [#[\Closure(name: 'Shopware\\Storefront\\Framework\\Routing\\DomainNotMappedListener')] fn () => ($container->privates['Shopware\\Storefront\\Framework\\Routing\\DomainNotMappedListener'] ??= new \Shopware\Storefront\Framework\Routing\DomainNotMappedListener($container)), '__invoke'], 0);
        $instance->addListener('kernel.controller', [#[\Closure(name: 'Shopware\\Core\\Framework\\Routing\\ContextResolverListener')] fn () => ($container->privates['Shopware\\Core\\Framework\\Routing\\ContextResolverListener'] ?? self::getContextResolverListenerService($container)), 'resolveContext'], -10);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Shopware\\Core\\Framework\\Routing\\CoreSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Routing\\CoreSubscriber'] ?? self::getCoreSubscriberService($container)), 'initializeCspNonce'], 0);
        $instance->addListener('kernel.response', [#[\Closure(name: 'Shopware\\Core\\Framework\\Routing\\CoreSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Routing\\CoreSubscriber'] ?? self::getCoreSubscriberService($container)), 'setSecurityHeaders'], 0);
        $instance->addListener('kernel.controller', [#[\Closure(name: 'Shopware\\Core\\Framework\\Routing\\RouteScopeListener')] fn () => ($container->privates['Shopware\\Core\\Framework\\Routing\\RouteScopeListener'] ?? self::getRouteScopeListenerService($container)), 'checkScope'], -20);
        $instance->addListener('kernel.request', [#[\Closure(name: 'Shopware\\Core\\Framework\\Routing\\RouteEventSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Routing\\RouteEventSubscriber'] ?? self::getRouteEventSubscriberService($container)), 'request'], -10);
        $instance->addListener('kernel.controller', [#[\Closure(name: 'Shopware\\Core\\Framework\\Routing\\RouteEventSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Routing\\RouteEventSubscriber'] ?? self::getRouteEventSubscriberService($container)), 'controller'], -10);
        $instance->addListener('kernel.response', [#[\Closure(name: 'Shopware\\Core\\Framework\\Routing\\RouteEventSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Routing\\RouteEventSubscriber'] ?? self::getRouteEventSubscriberService($container)), 'response'], -10);
        $instance->addListener('Shopware\\Storefront\\Event\\StorefrontRenderEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Routing\\RouteEventSubscriber')] fn () => ($container->privates['Shopware\\Core\\Framework\\Routing\\RouteEventSubscriber'] ?? self::getRouteEventSubscriberService($container)), 'render'], -10);
        $instance->addListener('app_template.written', [#[\Closure(name: 'Shopware\\Core\\Framework\\Adapter\\Twig\\EntityTemplateLoader')] fn () => ($container->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\EntityTemplateLoader'] ?? self::getEntityTemplateLoaderService($container)), 'reset'], 0);
        $instance->addListener('flow.log', [#[\Closure(name: 'Shopware\\Core\\Framework\\Log\\LoggingService')] fn () => ($container->privates['Shopware\\Core\\Framework\\Log\\LoggingService'] ?? self::getLoggingServiceService($container)), 'logFlowEvent'], 0);
        $instance->addListener('Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\Validation\\PreWriteValidationEvent', [#[\Closure(name: 'Shopware\\Core\\Framework\\Api\\Acl\\AclWriteValidator')] fn () => ($container->privates['Shopware\\Core\\Framework\\Api\\Acl\\AclWriteValidator'] ?? self::getAclWriteValidatorService($container)), 'preValidate'], 0);
        $inst