const r=`{% block sw_settings_number_range_detail %} <sw-page class="sw-settings-number-range-detail"> {% block sw_settings_number_range_detail_header %} <template #smart-bar-header> <h2>{{ placeholder(numberRange, 'name', $tc('sw-settings-number-range.detail.textHeadline')) }}</h2> </template> {% endblock %} {% block sw_settings_number_range_detail_language_switch %} <template #language-switch> <sw-language-switch :save-changes-function="saveOnLanguageChange" :abort-change-function="abortOnLanguageChange" @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_settings_number_range_detail_actions %} <template #smart-bar-actions> {% block sw_settings_number_range_detail_actions_abort %} <mt-button v-tooltip.bottom="tooltipCancel" :disabled="isLoading" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_number_range_detail_actions_save %} <sw-button-process v-tooltip.bottom="tooltipSave" class="sw-settings-number-range-detail__save-action" variant="primary" :is-loading="isLoading" :process-success="isSaveSuccessful" :disabled="!acl.can('number_ranges.editor')" @update:process-success="saveFinish" @click.prevent="onSave" > {{ $tc('global.default.save') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_settings_number_range_detail_content %} <template #content> <sw-card-view> <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </template> <template v-else> {% block sw_settings_number_range_detail_language_info %} <sw-language-info :entity-description="identifier" /> {% endblock %} {% block sw_settings_number_range_detail_content_card %} <mt-card :title="$tc('sw-settings-number-range.detail.configCard')" position-identifier="sw-settings-number-range-detail-content" > {% block sw_settings_number_range_detail_content_global_warning %} <mt-banner v-if="numberRange && numberRange.type && numberRange.type.global" class="sw-number_range-quickinfo__alert-global-type" variant="attention" :title="$tc('sw-settings-number-range.general.infoGlobalTypeTitle', {typeName: numberRange.type.typeName}, 0)" > {{ $tc('sw-settings-number-range.general.infoGlobalType', {typeName: numberRange.type.typeName}, 0) }} </mt-banner> {% endblock %} <sw-container columns="repeat(auto-fit, minmax(250px, 1fr))" gap="0px 30px" > {% block sw_settings_number_range_detail_content_field_name %} <mt-text-field v-model="numberRange.name" name="sw-field--numberRange-name" :label="$tc('sw-settings-number-range.detail.labelName')" :placeholder="placeholder(numberRange,'name', $tc('sw-settings-number-range.detail.placeholderName'))" validation="required" required :disabled="!acl.can('number_ranges.editor')" :error="numberRangeNameError" /> {% endblock %} {% block sw_settings_number_range_detail_content_field_description %} <mt-text-field v-model="numberRange.description" name="sw-field--numberRange-description" :label="$tc('sw-settings-number-range.detail.labelDescription')" :placeholder="placeholder(numberRange,'description', $tc('sw-settings-number-range.detail.placeholderDescription'))" :disabled="!acl.can('number_ranges.editor')" /> {% endblock %} </sw-container> <sw-container columns="repeat(auto-fit, minmax(200px, 1fr))" gap="0px 30px" > {% block sw_settings_number_range_detail_content_field_prefix %} <mt-text-field v-model="prefix" name="sw-field--prefix" :disabled="advanced || !acl.can('number_ranges.editor')" :label="$tc('sw-settings-number-range.detail.labelPrefix')" :placeholder="advanced?$tc('sw-settings-number-range.detail.placeholderSimpleModeImpossible'):$tc('sw-settings-number-range.detail.placeholderPrefix')" @update:model-value="onChangePattern()" /> {% endblock %} {% block sw_settings_number_range_detail_content_field_start %} <mt-number-field v-model="numberRange.start" name="sw-field--numberRange-start" number-type="int" :disabled="!acl.can('number_ranges.editor')" :label="$tc('sw-settings-number-range.detail.labelStart')" :placeholder="$tc('sw-settings-number-range.detail.placeholderStart')" required validation="required" @update:model-v-salue="onChangePattern()" /> {% endblock %} {% block sw_settings_number_range_detail_content_field_suffix %} <mt-text-field v-model="suffix" name="sw-field--suffix" :disabled="advanced || !acl.can('number_ranges.editor')" :label="$tc('sw-settings-number-range.detail.labelSuffix')" :placeholder="advanced?$tc('sw-settings-number-range.detail.placeholderSimpleModeImpossible'):$tc('sw-settings-number-range.detail.placeholderSuffix')" @update:model-value="onChangePattern()" /> {% endblock %} {% block sw_settings_number_range_detail_content_field_pattern %} <mt-text-field v-if="advanced" v-model="numberRange.pattern" name="sw-field--numberRange-pattern" :label="$tc('sw-settings-number-range.detail.labelPattern')" :placeholder="$tc('sw-settings-number-range.detail.placeholderPattern')" :disabled="!acl.can('number_ranges.editor')" @update:model-value="onChangePattern()" /> <div v-if="!advanced"></div> {% endblock %} </sw-container> <sw-container columns="1fr 1fr" gap="0px 30px" > {% block sw_settings_number_range_detail_content_field_default %} <div class="sw-settings-number-range-detail__field_default"> <mt-switch v-model="advanced" name="sw-field--advanced" bordered :disabled="!acl.can('number_ranges.editor')" :label="$tc('sw-settings-number-range.detail.labelAdvanced')" /> <sw-help-text :width="380" :text="$t('sw-settings-number-range.detail.helpTextAdvancedField')" /> </div> {% endblock %} </sw-container> <sw-container columns="repeat(auto-fit, minmax(250px, 1fr))" gap="0px 30px" > {% block sw_settings_number_range_detail_content_field_current_number %} <mt-text-field v-if="state" v-model="stateInput" name="sw-field--state" :disabled="true" :label="$tc('sw-settings-number-range.detail.labelCurrentNumber')" :placeholder="numberRange.start?numberRange.start.toString():''" /> {% endblock %} {% block sw_settings_number_range_detail_content_field_preview %} <mt-text-field v-model="previewInput" name="sw-field--preview" :disabled="true" :label="$tc('sw-settings-number-range.detail.labelPreview')" /> {% endblock %} </sw-container> </mt-card> {% endblock %} {% block sw_settings_number_range_detail_assignment_card %} <mt-card :title="$tc('sw-settings-number-range.detail.assignmentCard')" position-identifier="sw-settings-number-range-detail-assignment" class="sw-settings-number-range-detail-assignment" > {% block sw_settings_number_range_detail_assignment_card_global_warning %} <mt-banner v-if="numberRange !== null && numberRange.global" class="sw-number_range-quickinfo__alert-global-type" variant="info" :title="$tc('sw-settings-number-range.general.infoGlobalTitle', {name: numberRange.name}, 0)" > {{ $tc('sw-settings-number-range.general.infoGlobal', {name: numberRange.name}, 0) }} </mt-banner> <mt-banner v-if=" numberRange.type !== null && numberRange.numberRangeSalesChannels && numberRange.numberRangeSalesChannels.length > 0" class="sw-number_range-quickinfo__alert-global-type" variant="attention" > {{ $tc('sw-settings-number-range.general.infoSalesChannelBound', {name: numberRange.name}, 0) }} </mt-banner> {% endblock %} <sw-container columns="repeat(auto-fit, minmax(100%, 1fr))" gap="0px 30px" > {% block sw_settings_number_range_detail_content_global_product_warning %} {% endblock %} {% block sw_sales_channel_detail_base_general_input_type %} <sw-entity-single-select v-if="numberRange.type" id="numberRangeTypes" v-model:value="numberRange.typeId" name="sw-field--numberRange-typeId" entity="number_range_type" class="sw-number-range-detail__select-type" :disabled="disableNumberRangeTypeSelect" required show-clearable-button label-property="typeName" :label="$tc('sw-settings-number-range.detail.labelType')" :criteria="numberRange.type.global ? numberRangeTypeCriteriaGlobal : numberRangeTypeCriteria" :error="numberRangeTypeIdError" @update:value="onChangeType" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_sales_channel %} <sw-multi-select v-if="numberRange && (!numberRange.global || numberRange.global === false)" class="sw-number-range-detail__select-type" :label="$tc('sw-settings-number-range.detail.labelSalesChannel')" :disabled="!numberRange.typeId || !acl.can('number_ranges.editor')" :value="selectedNumberRangeSalesChannels" :options="salesChannels" name="sw-field--selectedNumberRangeSalesChannels" label-property="translated.name" value-property="id" @item-add="addSalesChannel" @item-remove="removeSalesChannel" /> {% endblock %} </sw-container> </mt-card> {% endblock %} {% block sw_settings_number_range_detail_custom_field_sets %} <mt-card v-if="showCustomFields" position-identifier="sw-settings-number-range-detail-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="numberRange" :disabled="!acl.can('number_ranges.editor')" :sets="customFieldSets" /> </mt-card> {% endblock %} </template> </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Component:i,Mixin:s,Data:{Criteria:t}}=Shopware,{mapPropertyErrors:l}=i.getComponentHelper(),o={template:r,inject:["numberRangeService","repositoryFactory","acl","customFieldDataProviderService"],mixins:[s.getByName("notification"),s.getByName("placeholder")],shortcuts:{"SYSTEMKEY+S":"onSave",ESCAPE:"onCancel"},data(){return{numberRangeId:void 0,numberRange:{},salesChannels:[],advanced:!1,simplePossible:!0,prefix:"",suffix:"",preview:"",state:1,isLoading:!1,isSaveSuccessful:!1,customFieldSets:null}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{identifier(){return this.placeholder(this.numberRange,"name")},disableNumberRangeTypeSelect(){return this.numberRange.type.global||this.numberRange.global||this.numberRange.type!==null&&this.numberRange.numberRangeSalesChannels&&this.numberRange.numberRangeSalesChannels.length>0||!this.acl.can("number_ranges.editor")},numberRangeRepository(){return this.repositoryFactory.create("number_range")},numberRangeCriteria(){const e=new t(1,25);return e.addAssociation("type"),e.addAssociation("numberRangeSalesChannels"),e},numberRangeTypeRepository(){return this.repositoryFactory.create("number_range_type")},numberRangeTypeCriteria(){const e=new t(1,25);return e.addFilter(t.equals("global",!1)),e.addSorting(t.sort("typeName","ASC")),e},numberRangeTypeCriteriaGlobal(){const e=new t(1,25);return e.addFilter(t.equals("global",!0)),e.addSorting(t.sort("typeName","ASC")),e},salesChannelCriteria(){const e=new t(1,25);return e.addFilter(t.multi("OR",[t.equals("numberRangeSalesChannels.numberRange.id",this.numberRange.id),t.not("OR",[t.equals("numberRangeSalesChannels.numberRangeTypeId",this.numberRange.typeId)])])),e.addAssociation("numberRangeSalesChannels"),e},salesChannelRepository(){return this.repositoryFactory.create("sales_channel")},numberRangeSalesChannelsRepository(){return this.repositoryFactory.create("number_range_sales_channel")},selectedNumberRangeSalesChannels(){return this.numberRange.numberRangeSalesChannels?this.numberRange.numberRangeSalesChannels.map(e=>e.salesChannelId):[]},tooltipSave(){return this.acl.can("number_ranges.editor")?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.acl.can("number_ranges.editor"),showOnDisabledElements:!0}},tooltipCancel(){return{message:"ESC",appearance:"light"}},showCustomFields(){return this.customFieldSets&&this.customFieldSets.length>0},...l("numberRange",["name","typeId"]),stateInput:{get(){return String(this.state)},set(e){this.state=Number(e)}},previewInput:{get(){return String(this.preview)},set(e){this.preview=Number(e)}}},watch:{"numberRange.pattern"(){this.getPreview()},"numberRange.start"(){this.getPreview()}},created(){this.createdComponent()},methods:{async createdComponent(){this.isLoading=!0,this.$route.params.id&&this.numberRange.isLoading!==!0&&(this.numberRangeId=this.$route.params.id,await Promise.all([this.loadEntityData(),this.loadCustomFieldSets()])),this.isLoading=!1},async loadEntityData(){this.numberRange=await this.numberRangeRepository.get(this.numberRangeId,Shopware.Context.api,this.numberRangeCriteria),this.getState(),this.splitPattern(),await this.loadSalesChannels()},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("number_range").then(e=>{this.customFieldSets=e})},splitPattern(){if(this.numberRange.pattern==="")return;const e=/([^{}]*)({[^{}]*?})([^{}]*)/gi,n=e.exec(this.numberRange.pattern);n&&n.length===4&&n[2]==="{n}"&&this.numberRange.pattern.match(e).length===1?(this.prefix=n[1]?n[1]:"",this.suffix=n[3]?n[3]:"",this.simplePossible=!0):(this.advanced=!0,this.simplePossible=!1)},getPreview(){return this.numberRange.type.technicalName?this.numberRangeService.previewPattern(this.numberRange.type.technicalName,this.numberRange.pattern,this.numberRange.start).then(e=>{this.preview=e.number}):Promise.resolve()},getState(){return this.numberRange.type.technicalName?this.numberRangeService.previewPattern(this.numberRange.type.technicalName,"{n}",0).then(e=>e.number>1?(this.state=e.number-1,Promise.resolve()):(this.state=this.numberRange.start,Promise.resolve())):Promise.resolve()},loadSalesChannels(){return this.salesChannelRepository.search(this.salesChannelCriteria).then(e=>{this.salesChannels=e})},onSave(){if(!this.acl.can("number_ranges.editor"))return!1;this.isSaveSuccessful=!1;const e=this.numberRange.name||this.placeholder(this.numberRange,"name");return this.onChangePattern(),this.numberRange.pattern?(this.state>1&&this.state>=this.numberRange.start&&this.createNotificationInfo({message:this.$tc("sw-settings-number-range.detail.infoStartDecrementMessage")}),this.isLoading=!0,this.numberRangeRepository.save(this.numberRange).then(()=>{this.isSaveSuccessful=!0}).catch(n=>{throw this.isLoading=!1,this.createNotificationError({message:this.$tc("sw-settings-number-range.detail.messageSaveError",{name:e},0)}),n}).finally(()=>{this.isLoading=!1,this.getState()})):(this.createNotificationError({message:this.$tc("sw-settings-number-range.detail.errorPatternNeededMessage")}),!1)},saveFinish(){this.isSaveSuccessful=!1},onCancel(){this.$router.push({name:"sw.settings.number.range.index"})},onChangeLanguage(){this.createdComponent()},abortOnLanguageChange(){return this.numberRangeRepository.hasChanges(this.numberRange)},saveOnLanguageChange(){return this.onSave()},onChangePattern(){if(this.prefix===null&&(this.prefix=""),this.suffix===null&&(this.suffix=""),this.advanced!==!0){this.numberRange.pattern=`${this.prefix}{n}${this.suffix}`;return}this.splitPattern()},onChangeType(){this.loadSalesChannels()},addSalesChannel(e){const n=this.numberRangeSalesChannelsRepository.create();n.numberRangeId=this.numberRange.id,n.numberRangeTypeId=this.numberRange.typeId,n.salesChannelId=e.id,this.numberRange.numberRangeSalesChannels.push(n),this.numberRange.numberRangeSalesChannels.length<=1&&this.$nextTick().then(()=>{const a=document.querySelector(".sw-card-view__content");a&&(a.scrollTop+=78)})},removeSalesChannel(e){const n=this.numberRange.numberRangeSalesChannels.find(a=>a.salesChannelId===e.id);this.numberRange.numberRangeSalesChannels.remove(n.id)},noSalesChannelSelected(){return this.numberRange.global===!1&&(this.numberRange.type.global===!1||this.numberRange.type.global===null)&&(!this.numberRange.numberRangeSalesChannels||this.numberRange.numberRangeSalesChannels.length===0)}}};export{o as default};
