const n=`{% block sw_cms_list %} <sw-page class="sw-cms-list"> {% block sw_cms_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="cms_page" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_cms_list_toolbar %} <template #smart-bar-header> <h2>{{ $tc('sw-cms.general.moduleTitle') }}</h2> </template> <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> <template #smart-bar-actions> <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('cms.creator'), showOnDisabledElements: true }" variant="primary" :disabled="!acl.can('cms.creator') || undefined" size="default" @click="onCreateNewLayout" > {{ $tc('sw-cms.general.createNewLayout') }} </mt-button> </template> {% endblock %} {% block sw_cms_list_card_view %} <template #content> <sw-card-view> {% block sw_cms_list_content %} <div class="sw-cms-list__content"> {% block sw_cms_list_sidebar %} <div class="sw-cms-list__sidebar"> {% block sw_cms_list_sidebar_tabs %} <sw-tabs is-vertical small position-identifier="sw-cms-list-sidebar" class="sw-cms-list__type-nav" > <sw-tabs-item v-for="pageType in sortPageTypes" :key="pageType.name" :disabled="pageType.disabled || undefined" :active="pageType.active" @click="onSortPageType(pageType.value)" > {{ pageType.name }} </sw-tabs-item> </sw-tabs> {% endblock %} </div> {% endblock %} {% block sw_cms_list_listing %} <div class="sw-cms-list__listing"> {% block sw_cms_list_listing_actions %} <div class="sw-cms-list__actions"> {% block sw_cms_list_listing_title %} <h3>{{ $tc('sw-cms.general.greeting') }}</h3> {% endblock %} {% block sw_cms_list_listing_actions_sorting %} <div class="sw-cms-list__actions-sorting"> {% block sw_cms_list_listing_actions_sorting_select %} <sw-sorting-select :sort-by="sortBy" :sort-direction="sortDirection" @sorting-changed="onSort" /> {% endblock %} </div> {% endblock %} {% block sw_cms_list_listing_actions_mode %} <div class="sw-cms-list__actions-mode" role="button" tabindex="0" @click="onListModeChange" @keydown.enter="onListModeChange" > <mt-icon v-if="listMode === 'grid'" name="regular-view-normal" size="16" /> <mt-icon v-if="listMode === 'list'" name="regular-view-grid" size="16" /> </div> {% endblock %} </div> {% endblock %} {% block sw_cms_list_listing_list %} <div class="sw-cms-list__list"> {% block sw_cms_list_listing_list_grid %} <div v-if="listMode === 'grid'" class="sw-cms-list__list-grid" > {% block sw_cms_list_listing_list_grid_content %} <div class="sw-cms-list__list-grid-content"> <template v-if="!isLoading"> {% block sw_cms_list_listing_list_item %} <sw-cms-list-item v-for="(cmsPage, index) in pages" :key="cmsPage.id" :class="'sw-cms-list-item--' + index" :page="cmsPage" :active="layoutIsLinked(cmsPage.id)" :is-default="[defaultProductId, defaultCategoryId].includes(cmsPage.id)" @item-click="onListItemClick" @preview-image-change="onPreviewChange" @cms-page-delete="onDeleteCmsPage" > <template #contextMenu> <sw-context-button class="sw-cms-list-item__options"> {% block sw_cms_list_listing_list_item_option_add_preview %} <sw-context-menu-item class="sw-cms-list-item__option-preview" :disabled="!acl.can('cms.editor') || undefined" @click="onPreviewChange(cmsPage)" > {{ $tc('sw-cms.components.cmsListItem.addPreviewImage') }} </sw-context-menu-item> {% endblock %} <sw-context-menu-item v-if="showDefaultLayoutContextMenu(cmsPage)" class="sw-cms-list-item__option-set-as-default" :disabled="!acl.can('system_config:update') || !acl.can('system_config:create') || !acl.can('system_config:delete') || undefined" @click="onOpenLayoutSetAsDefault(cmsPage)" > <template v-if="cmsPage.type == 'product_detail'"> {{ $tc('sw-cms.components.cmsListItem.setAsDefaultProductDetail') }} </template> <template v-else> {{ $tc('sw-cms.components.cmsListItem.setAsDefaultProductList') }} </template> </sw-context-menu-item> {% block sw_cms_list_listing_list_item_option_duplicate %} <sw-context-menu-item :disabled="!acl.can('cms.creator') || undefined" class="sw-cms-list-item__option-duplicate" @click="onDuplicateCmsPage(cmsPage)" > {{ $tc('sw-cms.components.cmsListItem.duplicate') }} </sw-context-menu-item> {% endblock %} {% block sw_cms_list_listing_list_item_option_remove_preview %} <sw-context-menu-item v-if="cmsPage.previewMediaId" class="sw-cms-list-item__option-preview" variant="danger" :disabled="!acl.can('cms.editor') || undefined" @click="onPreviewImageRemove(cmsPage)" > {{ $tc('sw-cms.components.cmsListItem.removePreviewImage') }} </sw-context-menu-item> {% endblock %} {% block sw_cms_list_listing_list_item_option_delete %} <sw-context-menu-item v-if="!cmsPage.locked && defaultProductId !== cmsPage.id && defaultCategoryId !== cmsPage.id" v-tooltip="deleteDisabledToolTip(cmsPage)" class="sw-cms-list-item__option-delete" variant="danger" :disabled="optionContextDeleteDisabled(cmsPage) || undefined" @click="onDeleteCmsPage(cmsPage)" > {{ $tc('sw-cms.components.cmsListItem.delete') }} </sw-context-menu-item> {% endblock %} </sw-context-button> </template> </sw-cms-list-item> {% endblock %} </template> <template v-else> <sw-skeleton v-for="index in 9" :key="\`cms-list-skeleton-\${index}\`" variant="gallery" /> </template> </div> {% endblock %} {% block sw_cms_list_listing_pagination %} <sw-pagination v-if="!isLoading" class="sw-cms-list__list-pagination" :page="page" :limit="limit" :total="total" :steps="[9]" @page-change="onPageChange" /> {% endblock %} </div> {% endblock %} {% block sw_cms_list_listing_list_card %} <mt-card v-else-if="listMode === 'list'" position-identifier="sw-cms-list-list-mode" class="sw-cms-list__list-card" > <template #grid> {% block sw_cms_list_listing_list_data_grid %} <sw-data-grid class="sw-cms-list__list-data-grid" identifier="sw-cms-list" :is-loading="isLoading" :data-source="pages" :columns="columnConfig" :skeleton-item-amount="limit" :sort-by="sortBy" :sort-direction="sortDirection" :allow-inline-edit="false" :allow-column-edit="false" show-settings :show-selection="false" > {% block sw_cms_list_listing_list_data_grid_column_name %} <template #column-name="{ item }"> <mt-icon v-if="item.locked" name="regular-lock" class="sw-cms-list__icon-lock" size="14" /> <router-link :to="{ name: 'sw.cms.detail', params: { id: item.id } }"> {{ item.translated.name }} </router-link> </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_column_type %} <template #column-type="{ item }"> {{ getPageType(item) }} </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_column_assignments %} <template #column-assignments="{ item }"> <mt-icon size="10px" :name="layoutIsLinked(item.id) ? 'regular-checkmark-xs' : 'regular-times-xs'" :class="layoutIsLinked(item.id) ? 'is--active' : 'is--inactive'" /> </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_column_assignment_list %} <template #column-assignedPages="{ item }"> <div v-tooltip="getPagesTooltip(item)"> {{ getPagesString(item) }} </div> </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_column_created %} <template #column-createdAt="{ item }"> {{ dateFilter(item.createdAt, { hour: '2-digit', minute: '2-digit' }) }} </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_column_updated %} <template #column-updatedAt="{ item }"> {{ dateFilter(item.updatedAt, { hour: '2-digit', minute: '2-digit' }) }} </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_actions %} <template #actions="{ item }"> {% block sw_cms_list_listing_list_data_grid_actions_edit %} <sw-context-menu-item :router-link="{ name: 'sw.cms.detail', params: { id: item.id } }" class="sw-cms-list__context-menu-item-edit" :disabled="!acl.can('cms.editor') || undefined" > <template v-if="item.locked"> {{ $tc('sw-cms.components.cmsListItem.view') }} </template> <template v-else> {{ $tc('sw-cms.components.cmsListItem.edit') }} </template> </sw-context-menu-item> {% endblock %} <sw-context-menu-item v-if="showDefaultLayoutContextMenu(item)" class="sw-cms-list-item__option-set-as-default" :disabled="!acl.can('system_config:update') || !acl.can('system_config:create') || !acl.can('system_config:delete') || undefined" @click="onOpenLayoutSetAsDefault(item)" > <template v-if="item.type == 'product_detail'"> {{ $tc('sw-cms.components.cmsListItem.setAsDefaultProductDetail') }} </template> <template v-else> {{ $tc('sw-cms.components.cmsListItem.setAsDefaultProductList') }} </template> </sw-context-menu-item> {% block sw_cms_list_listing_list_data_grid_actions_edit_duplicate %} <sw-context-menu-item :disabled="!acl.can('cms.creator') || undefined" class="sw-cms-list__context-menu-item-duplicate" @click="onDuplicateCmsPage(item)" > {{ $tc('sw-cms.components.cmsListItem.duplicate') }} </sw-context-menu-item> {% endblock %} {% block sw_cms_list_listing_list_item_option_rename %} <sw-context-menu-item v-if="!item.locked" :disabled="!acl.can('cms.editor') || undefined" class="sw-cms-list__context-menu-item-rename" @click="onRenameCmsPage(item)" > {{ $tc('sw-cms.components.cmsListItem.rename') }} </sw-context-menu-item> {% endblock %} {% block sw_cms_list_listing_list_data_grid_actions_edit_delete %} <sw-context-menu-item v-if="!item.locked && defaultProductId !== item.id && defaultCategoryId !== item.id" v-tooltip="deleteDisabledToolTip(item)" variant="danger" class="sw-cms-list__context-menu-item-delete" :disabled="optionContextDeleteDisabled(item) || undefined" @click="onDeleteCmsPage(item)" > {{ $tc('sw-cms.components.cmsListItem.delete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_cms_list_listing_list_data_grid_pagination %} <template #pagination> <sw-pagination :page="page" :limit="limit" :total="total" :steps="[5, 10, 25, 50]" @page-change="onPageChange" /> </template> {% endblock %} </sw-data-grid> {% endblock %} </template> </mt-card> {% endblock %} </div> {% endblock %} {% block sw_cms_list_listing_list_empty_state %} <sw-empty-state v-if="isValidTerm(term) && !isLoading && !total" :title="$tc('sw-empty-state.messageNoResultTitle')" :style="{ minHeight: '200px' }" > <template #default> {{ $tc('sw-empty-state.messageNoResultSublineBefore') }} <router-link class="sw-empty-state__description-link" :to="{ name: 'sw.profile.index.searchPreferences' }" > {{ $tc('sw-empty-state.messageNoResultSublineLink') }} </router-link> {{ $tc('sw-empty-state.messageNoResultSublineAfter') }} </template> </sw-empty-state> {% endblock %} </div> {% endblock %} </div> {% endblock %} {% block sw_cms_list_media_modal %} <sw-media-modal-v2 v-if="showMediaModal" :caption="$tc('sw-cms.components.cmsListItem.modal.captionMediaUpload')" :entity-context="'cms_page'" :allow-multi-select="false" @media-modal-selection-change="onPreviewImageChange" @modal-close="onModalClose" /> {% endblock %} <sw-confirm-modal v-if="showLayoutSetAsDefaultModal" class="sw-cms-list__confirm-set-as-default-modal" :title="$tc('sw-cms.components.setDefaultLayoutModal.title')" :text="$tc('sw-cms.components.setDefaultLayoutModal.infoText', {}, newDefaultLayout.type === 'product_detail')" @confirm="onConfirmLayoutSetAsDefault" @cancel="onCloseLayoutSetAsDefault" @close="onCloseLayoutSetAsDefault" /> {% block sw_cms_list_rename_modal %} <sw-modal v-if="showRenameModal" :title="$tc('sw-cms.components.cmsListItem.modal.renameModalTitle')" variant="small" @modal-close="onCloseRenameModal" > {% block sw_cms_list_rename_modal_confirm_rename_input %} <div class="sw_tree__confirm-rename-text"> {{ $tc('sw-cms.components.cmsListItem.modal.textRenameConfirm', { pageName: currentPage.translated.name || currentPage.name }, 0) }} </div> <mt-text-field v-model="newName" class="sw_tree__confirm-rename-text-field" size="default" /> {% endblock %} {% block sw_cms_list_rename_modal_footer %} <template #modal-footer> {% block sw_cms_list_rename_modal_cancel %} <mt-button size="small" variant="secondary" @click="onCloseRenameModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_cms_list_rename_modal_confirm %} <mt-button size="small" variant="primary" @click="onConfirmPageRename" > {{ $tc('sw-cms.components.cmsListItem.modal.buttonRename') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_cms_list_delete_modal %} <sw-modal v-if="showDeleteModal" :title="$tc('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_cms_list_delete_modal_confirm_delete_text %} <div class="sw_tree__confirm-delete-text"> {{ $tc('sw-cms.components.cmsListItem.modal.textDeleteConfirm', { pageName: currentPage.translated.name || currentPage.name }, 0) }} </div> {% endblock %} {% block sw_cms_list_delete_modal_footer %} <template #modal-footer> {% block sw_cms_list_delete_modal_cancel %} <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_cms_list_delete_modal_confirm %} <mt-button variant="critical" size="small" @click="onConfirmPageDelete" > {{ $tc('sw-cms.components.cmsListItem.modal.buttonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </sw-card-view> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:l}=Shopware,{Criteria:i}=Shopware.Data,c={template:n,inject:["repositoryFactory","acl","feature","systemConfigApiService","cmsPageTypeService"],mixins:[l.getByName("listing"),l.getByName("notification"),l.getByName("user-settings")],data(){return{pages:[],linkedLayouts:[],isLoading:!1,cardViewIdentifier:"grid.cms.sw-cms-list-grid",sortBy:"createdAt",sortDirection:"DESC",limit:9,limitDefaults:{gridView:10,cardView:9},associationLimit:25,term:"",currentPageType:null,showMediaModal:!1,currentPage:null,showRenameModal:!1,newName:null,showDeleteModal:!1,defaultMediaFolderId:null,listMode:"grid",assignablePageTypes:["categories","products"],searchConfigEntity:"cms_page",showLayoutSetAsDefaultModal:!1,defaultCategoryId:"",defaultProductId:"",newDefaultLayout:void 0,maxVisibleAssignedPages:3}},metaInfo(){return{title:this.$createTitle()}},computed:{pageRepository(){return this.repositoryFactory.create("cms_page")},defaultFolderRepository(){return this.repositoryFactory.create("media_default_folder")},columnConfig(){return this.getColumnConfig()},sortPageTypes(){const e={value:"",name:this.$tc("sw-cms.sorting.labelSortByAllPages"),active:!0};return this.cmsPageTypeService.getTypes().reduce((t,s)=>(t.push({value:s.name,name:this.$tc(s.title)}),t),[e])},listCriteria(){const e=new i(this.page,this.limit);return e.getAssociation("categories").addSorting(i.sort("name","ASC")).setLimit(this.associationLimit),e.getAssociation("products").addSorting(i.sort("name","ASC")).setLimit(this.associationLimit),e.addAssociation("previewMedia").addSorting(i.sort(this.sortBy,this.sortDirection)),this.term!==null&&e.setTerm(this.term),this.currentPageType!==null&&e.addFilter(i.equals("cms_page.type",this.currentPageType)),this.addLinkedLayoutsAggregation(e),e},associatedCategoryBuckets(){var e,t;return((t=(e=this.pages.aggregations)==null?void 0:e.categories)==null?void 0:t.buckets)||[]},associatedProductBuckets(){var e,t;return((t=(e=this.pages.aggregations)==null?void 0:e.products)==null?void 0:t.buckets)||[]},isLinkedCriteria(){return[{type:"multi",operator:"OR",queries:this.assignablePageTypes.map(e=>i.not("OR",[i.equals(`${e}.id`,null)]))}]},dateFilter(){return Shopware.Filter.getByName("date")}},created(){this.createdComponent()},methods:{createdComponent(){Shopware.Store.get("adminMenu").collapseSidebar(),this.acl.can("user_config:read")&&this.loadGridUserSettings(),this.acl.can("system_config:read")&&this.getDefaultLayouts(),this.setPageContext(),this.resetList()},async loadGridUserSettings(){const e=await this.getUserSettings(this.cardViewIdentifier);e&&(this.listMode=e.listMode,this.sortBy=e.sortBy,this.sortDirection=e.sortDirection,this.updateLimit())},updateLimit(){this.limit=this.listMode==="grid"?this.limitDefaults.cardView:this.limitDefaults.gridView},saveGridUserSettings(){if(!this.acl.can("user_config:create")||!this.acl.can("user_config:update")){console.warn("Did not persist user config, as permissions are missing.");return}this.saveUserSettings(this.cardViewIdentifier,{listMode:this.listMode,sortBy:this.sortBy,sortDirection:this.sortDirection})},setPageContext(){this.getDefaultFolderId().then(e=>{this.defaultMediaFolderId=e})},async getList(){this.isLoading=!0;const e=await this.addQueryScores(this.term,this.listCriteria);return this.entitySearchable?this.pageRepository.search(e).then(t=>{var s;return this.total=t.total,this.pages=t,(s=t.aggregations)!=null&&s.linkedLayouts&&(this.linkedLayouts=t.aggregations.linkedLayouts.entities),this.isLoading=!1,this.pages}).catch(()=>{this.isLoading=!1}):(this.isLoading=!1,this.total=0,!1)},addLinkedLayoutsAggregation(e){const t=i.filter("linkedLayoutsFilter",this.isLinkedCriteria,{name:"linkedLayouts",type:"entity",definition:"cms_page",field:"id"});e.addAggregation(t)},showDefaultLayoutContextMenu(e){return this.acl.can("system_config:read")?e.type==="product_list"?this.defaultCategoryId!==e.id:e.type==="product_detail"?this.defaultProductId!==e.id:!1:!1},async getDefaultLayouts(){const e=await this.systemConfigApiService.getValues("core.cms");this.defaultCategoryId=e["core.cms.default_category_cms_page"],this.defaultProductId=e["core.cms.default_product_cms_page"]},onOpenLayoutSetAsDefault(e){this.newDefaultLayout={id:e.id,type:e.type},this.showLayoutSetAsDefaultModal=!0},onCloseLayoutSetAsDefault(){this.newDefaultLayout=void 0,this.showLayoutSetAsDefaultModal=!1},async onConfirmLayoutSetAsDefault(){let e="category_cms_page";const{id:t,type:s}=this.newDefaultLayout;s==="product_detail"?(this.defaultProductId=t,e="product_cms_page"):this.defaultCategoryId=t,await this.systemConfigApiService.saveValues({[`core.cms.default_${e}`]:t}),this.showLayoutSetAsDefaultModal=!1},layoutIsLinked(e){return this.linkedLayouts.some(t=>t.id===e)},resetList(){this.page=1,this.pages=[],this.updateRoute({page:this.page,limit:this.limit,term:this.term,sortBy:this.sortBy,sortDirection:this.sortDirection}),this.getList()},getDefaultFolderId(){const e=new i(1,1);return e.addAssociation("folder"),e.addFilter(i.equals("entity","cms_page")),this.defaultFolderRepository.search(e).then(t=>{var a;const s=t.first();return(a=s.folder)!=null&&a.id?s.folder.id:null})},onChangeLanguage(e){Shopware.Store.get("context").setApiLanguageId(e),this.resetList()},onListItemClick(e){this.$router.push({name:"sw.cms.detail",params:{id:e.id}})},onSortingChanged(e){[this.sortBy,this.sortDirection]=e.split(":"),this.resetList(),this.saveGridUserSettings()},onSearch(e=null){!e.length||e.length<=0?this.term=null:this.term=e,this.resetList()},onSortPageType(e=null){!e.length||e.length<=0?this.currentPageType=null:this.currentPageType=e,this.resetList()},onPageChange({page:e,limit:t}){this.page=e,this.limit=t,this.getList(),this.updateRoute({page:this.page,limit:this.limit})},onCreateNewLayout(){this.$router.push({name:"sw.cms.create"})},onListModeChange(){this.listMode=this.listMode==="grid"?"list":"grid",this.updateLimit(),this.resetList(),this.saveGridUserSettings()},onPreviewChange(e){this.showMediaModal=!0,this.currentPage=e},onPreviewImageRemove(e){e.previewMediaId=null,e.previewMedia=null,this.saveCmsPage(e)},onModalClose(){this.showMediaModal=!1,this.currentPage=null},onPreviewImageChange([e]){this.currentPage.previewMediaId=e.id,this.saveCmsPage(this.currentPage),this.currentPage.previewMedia=e},onRenameCmsPage(e){this.currentPage=e,this.showRenameModal=!0},onCloseRenameModal(){this.currentPage=null,this.showRenameModal=!1},onConfirmPageRename(){this.newName&&(this.currentPage.name=this.newName,this.saveCmsPage(this.currentPage),this.getList()),this.newName=null,this.currentPage=null,this.showRenameModal=!1},onDeleteCmsPage(e){this.currentPage=e,this.showDeleteModal=!0},onDuplicateCmsPage(e,t={overwrites:{}}){t.overwrites||(t.overwrites={}),t.overwrites.name||(t.overwrites.name=`${e.name} - ${this.$tc("global.default.copy")}`),this.isLoading=!0,this.pageRepository.clone(e.id,t,Shopware.Context.api).then(()=>{this.resetList(),this.isLoading=!1}).catch(()=>{this.isLoading=!1,this.createNotificationError({message:this.$tc("global.notification.unspecifiedSaveErrorMessage")})})},onCloseDeleteModal(){this.currentPage=null,this.showDeleteModal=!1},onConfirmPageDelete(){this.deleteCmsPage(this.currentPage),this.currentPage=null,this.showDeleteModal=!1},saveCmsPage(e,t=Shopware.Context.api){return this.isLoading=!0,this.pageRepository.save(e,t).then(()=>{this.isLoading=!1}).catch(()=>{this.isLoading=!1})},deleteCmsPage(e){const t=this.$tc("sw-cms.components.cmsListItem.notificationDeleteErrorMessage");return this.isLoading=!0,this.pageRepository.delete(e.id).then(()=>{this.resetList()}).catch(()=>{this.isLoading=!1,this.createNotificationError({message:t})})},getColumnConfig(){return[{property:"name",label:this.$tc("sw-cms.list.gridHeaderName"),inlineEdit:"string",primary:!0,sortable:!1},{property:"type",label:this.$tc("sw-cms.list.gridHeaderType"),sortable:!1},{property:"assignments",label:this.$tc("sw-cms.list.gridHeaderAssignments"),sortable:!1},{property:"assignedPages",label:this.$tc("sw-cms.list.gridHeaderAssignedPages"),sortable:!1,visible:!1},{property:"createdAt",label:this.$tc("sw-cms.list.gridHeaderCreated"),sortable:!1},{property:"updatedAt",label:this.$tc("sw-cms.list.gridHeaderUpdated"),sortable:!1,visible:!1}]},deleteDisabledToolTip(e){return e.type==="product_detail"?{showDelay:300,message:this.$tc("sw-cms.general.deleteDisabledProductToolTip"),disabled:!this.layoutIsLinked(e.id)}:{showDelay:300,message:this.$tc("sw-cms.general.deleteDisabledToolTip"),disabled:!this.layoutIsLinked(e.id)}},getPageType(e){var o;const t=[this.defaultProductId,this.defaultCategoryId].includes(e.id),s=this.$tc("sw-cms.components.cmsListItem.defaultLayout"),a=this.$tc((o=this.cmsPageTypeService.getType(e.type))==null?void 0:o.title);return t?`${s} - ${a}`:a},getPageCategoryCount(e){return e.categories.length},getPageProductCount(e){return e.products.length},getPageCount(e){const t=this.getPageCategoryCount(e)+this.getPageProductCount(e);return t>0?t:"-"},getPages(e){return[...e.categories.map(t=>t.name),...e.products.map(t=>t.name)]},getPagesString(e){const t=this.getPages(e);let s=[...t].splice(0,this.maxVisibleAssignedPages).join(", ");return this.maxVisibleAssignedPages<t.length&&(s+=", ..."),s},getPagesTooltip(e){const t=this.getPages(e);let s=t.join(", ");return this.associationLimit<this.getPageCount(e)&&(s+=", ..."),{width:300,message:s,disabled:this.maxVisibleAssignedPages>=t.length}},optionContextDeleteDisabled(e){return this.getPageCategoryCount(e)>0||this.getPageProductCount(e)>0||!this.acl.can("cms.deleter")}}};export{c as default};
