const c=`{% block sw_order_state_history_card %} <mt-card :title="title" :is-loading="isLoading || statesLoading" class="sw-order-state-card" position-identifier="sw-order-state-history-card" > {% block sw_order_state_change_card_modal %} <sw-order-state-change-modal v-if="showModal" :order="order" :is-loading="isLoading" :technical-name="technicalName" @page-leave="onLeaveModalClose" @page-leave-confirm="onLeaveModalConfirm" /> {% endblock %} {% block sw_order_state_history_card_container %} <sw-container columns="repeat(auto-fit, minmax(250px, 1fr))" gap="30px 30px" > {% block sw_order_state_history_card_transaction %} <sw-order-state-history-card-entry v-if="transaction" v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('order.editor'), showOnDisabledElements: true }" class="sw-order-state-history-card__payment-state" :disabled="!acl.can('order.editor') || undefined" :history="transactionHistory" :transition-options="transactionOptions" state-machine-name="order_transaction.state" :title="$tc('sw-order.stateCard.headlineTransactionState')" @state-select="onTransactionStateSelected" /> <template v-else> <div> <h2>{{ $tc('sw-order.stateCard.headlineTransactionState') }}</h2> {{ $tc('sw-order.stateCard.labelNoTransactionState') }} </div> </template> {% endblock %} {% block sw_order_state_history_card_delivery %} <sw-order-state-history-card-entry v-if="delivery" v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('order.editor'), showOnDisabledElements: true }" class="sw-order-state-history-card__delivery-state" :history="deliveryHistory" :disabled="!acl.can('order.editor') || undefined" :transition-options="deliveryOptions" state-machine-name="order_delivery.state" :title="$tc('sw-order.stateCard.headlineDeliveryState')" @state-select="onDeliveryStateSelected" /> <template v-else> <div> <h2>{{ $tc('sw-order.stateCard.headlineDeliveryState') }}</h2> {{ $tc('sw-order.stateCard.labelNoDeliveryState') }} </div> </template> {% endblock %} {% block sw_order_state_history_card_order%} <sw-order-state-history-card-entry v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('order.editor'), showOnDisabledElements: true }" class="sw-order-state-history-card__order-state" :history="orderHistory" :disabled="!acl.can('order.editor') || undefined" :transition-options="orderOptions" state-machine-name="order.state" :title="$tc('sw-order.stateCard.headlineOrderState')" @state-select="onOrderStateSelected" /> {% endblock %} </sw-container> {% endblock %} </mt-card> {% endblock %}`,{Mixin:l}=Shopware,{Criteria:o}=Shopware.Data,h={template:c,inject:["swOrderDetailAskAndSaveEdits","orderService","stateMachineService","orderStateMachineService","repositoryFactory","acl"],emits:["options-change","order-state-change"],mixins:[l.getByName("notification")],props:{title:{type:String,required:!0},order:{type:Object,required:!0},isLoading:{type:Boolean,required:!1,default:!1}},data(){return{showModal:!1,orderHistory:[],orderOptions:[],transactionHistory:[],transactionOptions:[],deliveryHistory:[],deliveryOptions:[],statesLoading:!0,modalConfirmed:!1,currentActionName:null,currentStateType:null,technicalName:""}},computed:{stateMachineStateRepository(){return this.repositoryFactory.create("state_machine_state")},mailTemplateRepository(){return this.repositoryFactory.create("mail_template")},stateMachineHistoryRepository(){return this.repositoryFactory.create("state_machine_history")},transaction(){for(let t=0;t<this.order.transactions.length;t+=1)if(!["cancelled","failed"].includes(this.order.transactions[t].stateMachineState.technicalName))return this.order.transactions[t];return this.order.transactions.last()},delivery(){return this.order.deliveries[0]},stateMachineHistoryCriteria(){var r,i;const t=new o(1,null),e=[this.order.id,...((r=this.order.transactions)==null?void 0:r.getIds())||[],...((i=this.order.deliveries)==null?void 0:i.getIds())||[]];return t.addFilter(o.equalsAny("state_machine_history.referencedId",e)),t.addFilter(o.equalsAny("state_machine_history.entityName",["order","order_transaction","order_delivery"])),t.addAssociation("fromStateMachineState"),t.addAssociation("toStateMachineState"),t.addAssociation("user"),t.addSorting({field:"state_machine_history.createdAt",order:"ASC"}),t}},created(){this.createdComponent()},methods:{createdComponent(){this.loadHistory()},loadHistory(){this.statesLoading=!0,this.modalConfirmed=!1,Promise.all([this.getStateHistoryEntries(),this.getTransitionOptions()]).then(()=>{this.$emit("options-change","order.states",this.orderOptions),this.transaction&&this.$emit("options-change","order_transaction.states",this.transactionOptions),this.delivery&&this.$emit("options-change","order_delivery.states",this.deliveryOptions)}).catch(t=>{this.createNotificationError(t)}).finally(()=>{this.statesLoading=!1})},getStateHistoryEntries(){return this.stateMachineHistoryRepository.search(this.stateMachineHistoryCriteria).then(t=>(this.orderHistory=this.buildStateHistory(this.order,this.fetchEntries([this.order.id],t)),this.transaction&&this.order.transactions&&(this.transactionHistory=this.buildStateHistory(this.transaction,this.fetchEntries(this.order.transactions.getIds(),t))),this.delivery&&this.order.deliveries&&(this.deliveryHistory=this.buildStateHistory(this.delivery,this.fetchEntries(this.order.deliveries.getIds(),t))),Promise.resolve(t)))},fetchEntries(t,e){return!t.length||!e.length?[]:e.filter(r=>t.includes(r.referencedId))},buildStateHistory(t,e){if(e.length===0)return[{state:t.stateMachineState,createdAt:t.createdAt,user:null}];const r=[];return r.push({state:e[0].fromStateMachineState,createdAt:e[0].createdAt,user:null}),e.forEach(i=>{r.push({state:i.toStateMachineState,createdAt:i.createdAt,user:i.user?i.user:null})}),r},getTransitionOptions(){const t=[this.stateMachineService.getState("order",this.order.id)];return this.transaction&&t.push(this.stateMachineService.getState("order_transaction",this.transaction.id)),this.delivery&&t.push(this.stateMachineService.getState("order_delivery",this.delivery.id)),Promise.all([this.getAllStates(),...t]).then(e=>{const r=e[0],i=e[1];if(this.orderOptions=this.buildTransitionOptions("order.state",r,i.data.transitions),this.transaction){const s=e[2];this.transactionOptions=this.buildTransitionOptions("order_transaction.state",r,s.data.transitions)}if(this.delivery){const s=e[3];this.deliveryOptions=this.buildTransitionOptions("order_delivery.state",r,s.data.transitions)}return Promise.resolve()})},getAllStates(){return this.stateMachineStateRepository.search(this.stateMachineStateCriteria())},stateMachineStateCriteria(){const t=new o(1,null);return t.addSorting({field:"name",order:"ASC"}),t.addAssociation("stateMachine"),t.addFilter(o.equalsAny("state_machine_state.stateMachine.technicalName",["order.state","order_transaction.state","order_delivery.state"])),t},buildTransitionOptions(t,e,r){const s=e.filter(a=>a.stateMachine.technicalName===t).map((a,n)=>({stateName:a.technicalName,id:n,name:a.translated.name,disabled:!0}));return s.forEach(a=>{const n=r.filter(d=>d.toStateName===a.stateName);n.length>=1&&(a.disabled=!1,a.id=n[0].actionName)}),s},async onOrderStateSelected(t){if(!t){this.createStateChangeErrorNotification(this.$tc("sw-order.stateCard.labelErrorNoAction"));return}if(await this.swOrderDetailAskAndSaveEdits()){if(this.modalConfirmed===!1){this.currentActionName=t,this.currentStateType="orderState",this.showModal=!0;return}this.modalConfirmed=!1}},onCancelCreation(){this.showModal=!1},async onTransactionStateSelected(t){if(!t){this.createStateChangeErrorNotification(this.$tc("sw-order.stateCard.labelErrorNoAction"));return}if(await this.swOrderDetailAskAndSaveEdits()){if(this.modalConfirmed===!1){this.currentActionName=t,this.currentStateType="orderTransactionState",this.showModal=!0;return}this.modalConfirmed=!1}},async onDeliveryStateSelected(t){if(!t){this.createStateChangeErrorNotification(this.$tc("sw-order.stateCard.labelErrorNoAction"));return}if(await this.swOrderDetailAskAndSaveEdits()){if(this.modalConfirmed===!1){this.currentActionName=t,this.currentStateType="orderDeliveryState",this.showModal=!0;return}this.modalConfirmed=!1}},onLeaveModalClose(){this.modalConfirmed=!1,this.currentActionName=null,this.currentStateType=null,this.showModal=!1},onLeaveModalConfirm(t,e=!0){this.showModal=!1,this.currentStateType==="orderTransactionState"?this.orderStateMachineService.transitionOrderTransactionState(this.transaction.id,this.currentActionName,{documentIds:t,sendMail:e}).then(()=>{this.$emit("order-state-change"),this.loadHistory()}).catch(r=>{this.createStateChangeErrorNotification(r)}):this.currentStateType==="orderState"?this.orderStateMachineService.transitionOrderState(this.order.id,this.currentActionName,{documentIds:t,sendMail:e}).then(()=>{this.$emit("order-state-change"),this.loadHistory()}).catch(r=>{this.createStateChangeErrorNotification(r)}):this.currentStateType==="orderDeliveryState"&&this.orderStateMachineService.transitionOrderDeliveryState(this.delivery.id,this.currentActionName,{documentIds:t,sendMail:e}).then(()=>{this.$emit("order-state-change"),this.loadHistory()}).catch(r=>{this.createStateChangeErrorNotification(r)}),this.currentActionName=null,this.currentStateType=null},createStateChangeErrorNotification(t){this.createNotificationError({message:this.$tc("sw-order.stateCard.labelErrorStateChange")+t})}}};export{h as default};
