const o=`{% block sw_order_create_general %} <div class="sw-order-create-general"> <mt-card class="sw-order-create-general__general-info" position-identifier="sw-order-create-general-info" :title="$tc('sw-order.createBase.generalTab.labelGeneralInfoCard')" > <sw-order-create-general-info :cart="cart" :context="context" :is-loading="isLoading" /> </mt-card> <sw-extension-component-section position-identifier="sw-order-create-base-line-items__before" /> <mt-card class="sw-order-create-general__line-items" position-identifier="sw-order-create-line-items" :is-loading="isLoading" :title="$tc('sw-order.createBase.generalTab.labelLineItemsCard')" > <template #grid> <sw-order-line-items-grid-sales-channel editable :cart="cart" :currency="currency" :sales-channel-id="context.salesChannel.id" :is-loading="isLoading" :is-customer-active="isCustomerActive" @on-save-item="onSaveItem" @on-remove-items="onRemoveItems" /> <sw-card-section v-show="cart.lineItems.length" divider="top" slim > <sw-container class="sw-order-create-summary" columns="1fr 1fr" > <sw-description-list class="sw-order-create-summary__data" grid="1fr 1fr" > <dt>{{ $tc('sw-order.createBase.summaryLabelAmount') }}</dt> <dd>{{ currencyFilter(cart.price ? cart.price.positionPrice : 0, currency.isoCode, currency.totalRounding.decimals) }}</dd> <template v-if="cartDelivery"> <dt>{{ $tc('sw-order.createBase.summaryLabelShippingCosts') }}</dt> <dd> <sw-order-saveable-field v-tooltip="{ showDelay: 300, message: shippingCostsDetail, disabled: taxStatus === 'tax-free' }" type="number" editable :value="cartDelivery.shippingCosts.totalPrice" @value-change="onShippingChargeEdited" @update:value="onShippingChargeUpdated" > {{ currencyFilter(cartDelivery.shippingCosts.totalPrice, currency.isoCode, currency.totalRounding.decimals) }} </sw-order-saveable-field> </dd> </template> <template v-for="(delivery, index) in cartDeliveryDiscounts" :key="index" > <dt> {{ $tc('sw-order.createBase.discountLabelShippingCosts') }} </dt> <dd> {{ currencyFilter(delivery.shippingCosts.totalPrice, currency.isoCode, currency.totalRounding.decimals) }} </dd> </template> <template v-if="taxStatus !== 'tax-free'"> <dt><strong>{{ $tc('sw-order.createBase.summaryLabelAmountWithoutTaxes') }}</strong></dt> <dd> <strong>{{ currencyFilter(cart.price ? cart.price.netPrice : 0, currency.isoCode, currency.totalRounding.decimals) }}</strong> </dd> </template> <template v-if="taxStatus !== 'tax-free'"> <template v-for="(calculatedTax, index) in filteredCalculatedTaxes" :key="index" > <dt> {{ $tc('sw-order.createBase.summaryLabelTaxes', { taxRate: calculatedTax.taxRate }, 1) }} </dt> <dd> {{ currencyFilter(calculatedTax.tax, currency.isoCode, currency.totalRounding.decimals) }} </dd> </template> </template> <template v-if="taxStatus !== 'tax-free'"> <dt><strong>{{ $tc('sw-order.createBase.summaryLabelAmountTotal') }}</strong></dt> <dd> <strong>{{ currencyFilter(orderTotal, currency.isoCode, currency.totalRounding.decimals) }}</strong> </dd> <template v-if="displayRounded"> <dt><strong>{{ $tc('sw-order.createBase.summaryLabelAmountTotalRounded') }}</strong> </dt> <dd> <strong>{{ currencyFilter(cart.price ? cart.price.totalPrice : 0, currency.isoCode, currency.totalRounding.decimals) }}</strong> </dd> </template> </template> <template v-if="taxStatus === 'tax-free'"> <dt><strong>{{ $tc('sw-order.detailBase.summaryLabelAmount') }}</strong></dt> <dd> <strong>{{ currencyFilter(cart.price ? cart.price.totalPrice : 0, currency.isoCode, currency.totalRounding.decimals) }}</strong> </dd> </template> </sw-description-list> </sw-container> </sw-card-section> </template> </mt-card> <sw-extension-component-section position-identifier="sw-order-create-base-line-items__after" /> </div> {% endblock %}`,{Component:c,Store:t,Mixin:s,Utils:d}=Shopware,{get:n,format:l,array:u}=d,m=c.wrapComponentConfig({template:o,mixins:[s.getByName("notification"),s.getByName("cart-notification")],data(){return{isLoading:!1}},computed:{customer(){return t.get("swOrder").customer},cart(){return t.get("swOrder").cart},currency(){return t.get("swOrder").context.currency},context(){return t.get("swOrder").context},isCustomerActive(){return t.get("swOrder").isCustomerActive},cartDelivery(){return n(this.cart,"deliveries[0]",null)},cartDeliveryDiscounts(){return u.slice(this.cart.deliveries,1)||[]},taxStatus(){return n(this.cart,"price.taxStatus","")},shippingCostsDetail(){if(!this.cartDelivery)return null;const r=this.sortByTaxRate(this.cartDelivery.shippingCosts.calculatedTaxes).map(a=>{var i;return this.$t("sw-order.createBase.shippingCostsTax",{taxRate:a.taxRate,tax:l.currency(a.tax,this.currency.isoCode,(i=this.currency.totalRounding)==null?void 0:i.decimals)},0)});return`${this.$tc("sw-order.createBase.tax")}<br>${r.join("<br>")}`},filteredCalculatedTaxes(){return!this.cart.price||!this.cart.price.calculatedTaxes?[]:this.sortByTaxRate(this.cart.price.calculatedTaxes??[]).filter(e=>e.tax!==0)},displayRounded(){return this.cart.price?this.cart.price.rawTotal!==this.cart.price.totalPrice:!1},orderTotal(){return this.cart.price?this.displayRounded?this.cart.price.rawTotal:this.cart.price.totalPrice:0},currencyFilter(){return Shopware.Filter.getByName("currency")}},created(){this.createdComponent()},methods:{createdComponent(){if(!this.customer){this.$nextTick(()=>{this.$router.push({name:"sw.order.create.initial"})});return}this.isLoading=!0,this.loadCart().finally(()=>{this.isLoading=!1})},async onSaveItem(e){this.isLoading=!0,this.customer&&await t.get("swOrder").saveLineItem({salesChannelId:this.customer.salesChannelId,contextToken:this.cart.token,item:e}).finally(()=>{this.isLoading=!1})},onShippingChargeEdited(){this.isLoading=!0,this.customer&&t.get("swOrder").modifyShippingCosts({salesChannelId:this.customer.salesChannelId,contextToken:this.cart.token,shippingCosts:this.cartDelivery.shippingCosts}).catch(e=>{this.$emit("error",e)}).finally(()=>{this.isLoading=!1})},async onRemoveItems(e){this.isLoading=!0,this.customer&&await t.get("swOrder").removeLineItems({salesChannelId:this.customer.salesChannelId,contextToken:this.cart.token,lineItemKeys:e}).then(()=>{e.forEach(r=>{const a=t.get("swOrder").promotionCodes.find(i=>i.discountId===r);a&&t.get("swOrder").setPromotionCodes(t.get("swOrder").promotionCodes.filter(i=>i.discountId!==a.discountId))})}).finally(()=>{this.isLoading=!1})},async loadCart(){this.customer&&await t.get("swOrder").getCart({salesChannelId:this.customer.salesChannelId,contextToken:this.cart.token})},sortByTaxRate(e){return e.sort((r,a)=>r.taxRate-a.taxRate)},onShippingChargeUpdated(e){const r=Math.abs(e);this.cartDelivery.shippingCosts.unitPrice=r,this.cartDelivery.shippingCosts.totalPrice=r}}});export{m as default};
