const n=`{% block sw_settings_user_detail %} <sw-page class="sw-settings-user-detail"> {% block sw_settings_user_detail_header %} <template #smart-bar-header> <h2 v-if="!isLoading"> {{ fullName }} </h2> </template> {% endblock %} {% block sw_settings_user_detail_actions %} <template #smart-bar-actions> {% block sw_settings_user_detail_actions_cancel %} <mt-button v-tooltip.bottom="tooltipCancel" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_user_detail_actions_save %} <sw-button-process v-tooltip.bottom="tooltipSave" class="sw-settings-user-detail__save-action" :is-loading="isLoading" :process-success="isSaveSuccessful" :disabled="isLoading || !acl.can('users_and_permissions.editor') || undefined" variant="primary" @update:process-success="saveFinish" @click.prevent="onSave" > {{ $tc('sw-users-permissions.users.user-detail.labelButtonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_settings_user_detail_content %} <template #content> <sw-card-view> {% block sw_settings_user_detail_content_inner %} <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </template> {# v-show is used here as underlying components influence the loading state and v-if would destroy this behaviour #} <div v-show="!isLoading"> {% block sw_setting_user_detail_card_basic_information %} <mt-card position-identifier="sw-users-permissions-user-detail" :title="$tc('sw-users-permissions.users.user-detail.labelCard')" :is-loading="isLoading" > {% block sw_settings_user_detail_content_grid %} <div v-if="user" class="sw-settings-user-detail__grid" > {% block sw_settings_user_detail_content_first_name %} <mt-text-field v-model="user.firstName" name="sw-field--user-firstName" class="sw-settings-user-detail__grid-firstName" :disabled="!acl.can('users_and_permissions.editor') || undefined" :error="userFirstNameError" required :label="$tc('sw-users-permissions.users.user-detail.labelFirstName')" /> {% endblock %} {% block sw_settings_user_detail_content_last_name %} <mt-text-field v-model="user.lastName" name="sw-field--user-lastName" class="sw-settings-user-detail__grid-lastName" :disabled="!acl.can('users_and_permissions.editor') || undefined" :error="userLastNameError" required :label="$tc('sw-users-permissions.users.user-detail.labelLastName')" /> {% endblock %} {% block sw_settings_user_detail_content_email %} <mt-text-field v-model="user.email" name="sw-field--user-email" class="sw-settings-user-detail__grid-eMail" :error="userEmailError" :disabled="!acl.can('users_and_permissions.editor') || undefined" required :label="$tc('sw-users-permissions.users.user-detail.labelEmail')" /> {% endblock %} {% block sw_settings_user_detail_content_username %} <mt-text-field v-model="user.username" name="sw-field--user-username" class="sw-settings-user-detail__grid-username" :error-message="isUsernameUsed ? $tc('sw-users-permissions.users.user-detail.errorUsernameUsed') : ''" :error="userUsernameError" :disabled="!acl.can('users_and_permissions.editor') || undefined" required :label="$tc('sw-users-permissions.users.user-detail.labelUsername')" @update:model-value="checkUsername" /> {% endblock %} {% block sw_settings_user_detail_content_media_upload %} <sw-upload-listener :upload-tag="user.id" auto-upload @media-upload-finish="setMediaItem" /> <sw-media-upload-v2 class="sw-settings-user-detail__grid-profile-picture" :source="avatarMedia" :label="$tc('sw-users-permissions.users.user-detail.labelProfilePicture')" :upload-tag="user.id" :allow-multi-select="false" :source-context="user" :disabled="!acl.can('users_and_permissions.editor') || undefined" default-folder="user" @media-drop="onDropMedia" @media-upload-sidebar-open="onOpenMedia" @media-upload-remove-image="onUnlinkLogo" /> {% endblock %} {% block sw_settings_user_detail_content_password %} <mt-password-field class="sw-settings-user-detail__grid-password" :model-value="user.password" name="sw-field--user-password" :disabled="!acl.can('users_and_permissions.editor') || undefined" :label="$tc('sw-users-permissions.users.user-detail.labelPassword')" :error="userPasswordError" autocomplete="off" @update:model-value="setPassword" /> {% endblock %} {% block sw_settings_user_detail_grid_content_language %} <mt-select v-model="user.localeId" name="sw-field--user-localeId" class="sw-settings-user-detail__grid-language" :label="$tc('sw-users-permissions.users.user-detail.labelLanguage')" :disabled="!acl.can('users_and_permissions.editor') || undefined" :error="userLocaleIdError" :options="localeOptions" required :placeholder="$tc('sw-users-permissions.users.user-detail.labelLanguagePlaceholder')" /> {% endblock %} {% block sw_settings_user_detail_grid_content_timezone %} <sw-single-select v-model:value="user.timeZone" name="sw-field--user-timeZone" class="sw-settings-user-detail__grid-timezone" :options="timezoneOptions" required :label="$tc('sw-users-permissions.users.user-detail.labelTimezone')" :is-loading="timezoneOptions.length <= 0" :disabled="!acl.can('user.update_profile') || undefined" /> {% endblock %} {% block sw_settings_user_detail_grid_content_acl_is_admin %} <mt-switch v-model="user.admin" name="sw-field--user-admin" class="sw-settings-user-detail__grid-is-admin" :label="$tc('sw-users-permissions.users.user-detail.labelAdministrator')" :disabled="isCurrentUser || !acl.can('users_and_permissions.editor') || undefined" /> {% endblock %} {% block sw_settings_user_detail_grid_content_job_title %} <mt-text-field v-model="user.title" name="sw-field--user-title" class="sw-settings-user-detail__grid-jobTitle" :disabled="!acl.can('users_and_permissions.editor') || undefined" :label="$tc('sw-users-permissions.users.user-detail.labelJobTitle')" /> {% endblock %} {% block sw_settings_user_detail_grid_content_acl_roles %} <sw-entity-multi-select v-model:entity-collection="user.aclRoles" v-tooltip="{ showDelay: 300, message: $tc('sw-users-permissions.users.user-detail.disabledRoleSelectWarning'), disabled: !user.admin || !acl.can('users_and_permissions.editor') }" name="sw-field--user-aclRoles" class="sw-settings-user-detail__grid-aclRoles" :label="$tc('sw-users-permissions.users.user-detail.labelRoles')" :disabled="user.admin || !acl.can('users_and_permissions.editor') || undefined" :criteria="aclRoleCriteria" label-property="name" /> {% endblock %} </div> {% endblock %} {% block sw_settings_user_detail_content_confirm_password_modal %} <sw-verify-user-modal v-if="confirmPasswordModal" @verified="saveUser" @close="onCloseConfirmPasswordModal" /> {% endblock %} </mt-card> {% endblock %} {% block sw_setting_user_detail_card_integrations %} <mt-card :title="$tc('sw-users-permissions.users.user-detail.labelIntegrationsCard')" position-identifier="sw-users-permissions-user-detail-integrations" > {% block sw_settings_user_detail_grid_toolbar %} <template #toolbar> {% block sw_settings_user_detail_grid_add_key %} <mt-button variant="primary" size="small" :disabled="!$route.params.id || !acl.can('users_and_permissions.editor') || undefined" @click="addAccessKey" > {{ $tc('sw-users-permissions.users.user-detail.addAccessKey') }} </mt-button> {% endblock %} </template> {% endblock %} {% block sw_settings_user_detail_key_grid %} <template #grid> {% block sw_settings_user_detail_key_grid_content %} <sw-data-grid :is-loading="isLoading" :data-source="integrations" :columns="integrationColumns" identifier="user-grid" :show-settings="true" :skeleton-item-amount="skeletonItemAmount" > {% block sw_settings_user_detail_grid_columns_actions %} <template #actions="{ item }"> {% block sw_settings_user_detail_grid_columns_actions_edit %} <sw-context-menu-item class="sw-settings-user-detail__grid-context-menu-edit sw-product-list__edit-action" :disabled="!acl.can('users_and_permissions.editor') || undefined" @click="onShowDetailModal(item.id)" > {{ $tc('sw-users-permissions.users.user-detail.contextMenuEdit') }} </sw-context-menu-item> {% endblock %} {% block sw_settings_user_detail_grid_columns_actions_delete %} <sw-context-menu-item class="sw-settings-user-detail__grid-context-menu-delete" :disabled="!acl.can('users_and_permissions.editor') || undefined" variant="danger" @click="showDeleteModal = item.id" > {{ $tc('sw-users-permissions.users.user-detail.contextMenuDelete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} </sw-data-grid> <sw-empty-state v-if="integrations.length === 0" :absolute="false" :title="$tc('sw-users-permissions.users.user-detail.noAccessKeysTitle')" :subline="$tc('sw-users-permissions.users.user-detail.noAccessKeysSubline')" auto-height /> {% endblock %} </template> {% endblock %} </mt-card> {% endblock %} </div> {% endblock %} </sw-card-view> {% block sw_settings_user_detail_grid_inner_slot_media_modal %} <sw-media-modal-v2 v-if="showMediaModal" :allow-multi-select="false" :initial-folder-id="mediaDefaultFolderId" entity-context="user" @modal-close="showMediaModal = false" @media-modal-selection-change="onMediaSelectionChange" /> {% endblock %} {% block sw_settings_user_detail_grid_inner_slot_delete_modal %} <sw-modal v-if="showDeleteModal" :title="$tc('global.default.warning')" @modal-close="onCloseDeleteModal" > {% block sw_settings_user_detail_grid_inner_slot_delete_modal_confirm_text %} <p> {{ $tc('sw-users-permissions.users.user-detail.modal.confirmDelete') }} </p> {% endblock %} {% block sw_settings_user_detail_grid_inner_slot_delete_modal_footer %} <template #modal-footer> <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> <mt-button size="small" variant="critical" @click="onConfirmDelete(showDeleteModal)" > {{ $tc('sw-users-permissions.users.user-detail.modal.buttonDelete') }} </mt-button> </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_settings_user_detail_detail_modal %} <sw-modal v-if="currentIntegration" size="550px" class="sw-settings-user-detail__detail" :is-loading="isModalLoading" :title="showSecretAccessKey ? $tc('global.default.warning') : $tc('sw-users-permissions.users.user-detail.modal.detailModalTitleEdit')" @modal-close="onCloseDetailModal" > {% block sw_settings_user_detail_detail_modal_inner %} {% block sw_settings_user_detail_detail_modal_inner_field_access_key %} <mt-text-field v-model="currentIntegration.accessKey" :label="$tc('sw-users-permissions.users.user-detail.modal.idFieldLabel')" :disabled="true" :copyable="true" :copyable-tooltip="true" /> {% endblock %} {% block sw_settings_user_detail_detail_modal_inner_field_secret_access_key %} {% block sw_settings_user_detail_detail_modal_inner_field_secret_access_key_field %} <mt-text-field v-if="showSecretAccessKey" v-model="currentIntegration.secretAccessKey" :label="$tc('sw-users-permissions.users.user-detail.modal.secretFieldLabel')" :disabled="true" :password-toggle-able="false" :copyable="showSecretAccessKey" :copyable-tooltip="true" /> <mt-password-field v-else v-model="currentIntegration.secretAccessKey" :label="$tc('sw-users-permissions.users.user-detail.modal.secretFieldLabel')" :disabled="true" :password-toggle-able="false" :copyable="showSecretAccessKey" :copyable-tooltip="true" autocomplete="off" /> {% endblock %} {% block sw_settings_user_detail_detail_modal_inner_field_secret_access_key_button %} <mt-button v-if="!showSecretAccessKey" class="sw-settings-user-detail__secret-help-text-button sw-field" variant="critical" :block="true" @click="addAccessKey" > {{ $tc('sw-users-permissions.users.user-detail.modal.buttonCreateNewApiKeys') }} </mt-button> {% endblock %} {% block sw_settings_user_detail_detail_modal_inner_field_help_text %} <mt-banner v-if="!showSecretAccessKey" variant="attention" class="sw-settings-user-detail__secret-help-text-alert" > {{ $tc('sw-users-permissions.users.user-detail.modal.hintCreateNewApiKeys') }} </mt-banner> {% endblock %} {% endblock %} {% block sw_settings_user_detail_detail_modal_inner_help_text %} <mt-banner v-else variant="attention" class="sw-settings-user-detail__secret-help-text-alert" > {{ $tc('sw-users-permissions.users.user-detail.modal.secretHelpText') }} </mt-banner> {% endblock %} {% block sw_settings_user_detail_detail_modal_inner_footer %} <template #modal-footer> {% block sw_settings_user_detail_detail_modal_inner_footer_cancel %} <mt-button size="small" :disabled="isModalLoading || undefined" variant="secondary" @click="onCloseDetailModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_user_detail_detail_modal_inner_footer_apply %} <mt-button size="small" class="sw-settings-user-detail__save-action" :disabled="isModalLoading && !!currentIntegration.label || undefined" variant="primary" @click="onSaveIntegration" > {{ showSecretAccessKey ? $tc('sw-users-permissions.users.user-detail.modal.buttonApply') : $tc('sw-users-permissions.users.user-detail.modal.buttonApplyEdit') }} </mt-button> {% endblock %} </template> {% endblock %} {% endblock %} </sw-modal> {% endblock %} </template> {% endblock %} </sw-page> {% endblock %}`,{Component:d,Mixin:r}=Shopware,{Criteria:t}=Shopware.Data,{mapPropertyErrors:c}=d.getComponentHelper(),{warn:u}=Shopware.Utils.debug,{ShopwareError:m}=Shopware.Classes,_={template:n,inject:["userService","loginService","mediaDefaultFolderService","userValidationService","integrationService","repositoryFactory","acl"],mixins:[r.getByName("notification"),r.getByName("salutation")],shortcuts:{"SYSTEMKEY+S":"onSave",ESCAPE:"onCancel"},data(){return{isLoading:!1,userId:"",user:null,currentUser:null,languages:[],integrations:[],currentIntegration:null,mediaItem:null,newPassword:"",newPasswordConfirm:"",isEmailAlreadyInUse:!1,isUsernameUsed:!1,isIntegrationsLoading:!1,isSaveSuccessful:!1,isModalLoading:!1,showSecretAccessKey:!1,showDeleteModal:null,skeletonItemAmount:3,confirmPasswordModal:!1,timezoneOptions:[],mediaDefaultFolderId:null,showMediaModal:!1}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{...c("user",["firstName","lastName","email","username","localeId","password"]),identifier(){return this.fullName},fullName(){return this.salutation(this.user,this.$tc("sw-users-permissions.users.user-detail.labelNewUser"))},userRepository(){return this.repositoryFactory.create("user")},userCriteria(){const e=new t(1,25);return e.addAssociation("accessKeys"),e.addAssociation("locale"),e.addAssociation("aclRoles"),e},aclRoleCriteria(){const e=new t(1,25);return e.addFilter(t.equals("app.id",null)),e.addFilter(t.equals("deletedAt",null)),e},languageRepository(){return this.repositoryFactory.create("language")},languageCriteria(){const e=new t(1,500);return e.addAssociation("locale"),e.addSorting(t.sort("locale.name","ASC")),e.addSorting(t.sort("locale.territory","ASC")),e},localeRepository(){return this.repositoryFactory.create("locale")},avatarMedia(){return this.mediaItem},isError(){return this.isEmailAlreadyInUse||this.isUsernameUsed||!this.hasLanguage},hasLanguage(){return this.user&&this.user.localeId},disableConfirm(){return this.newPassword!==this.newPasswordConfirm||this.newPassword===""||this.newPassword===null},isCurrentUser(){return!this.user||!this.currentUser?!1:this.userId===this.currentUser.id},mediaRepository(){return this.repositoryFactory.create("media")},integrationColumns(){return[{property:"accessKey",label:this.$tc("sw-users-permissions.users.user-detail.labelAccessKey")}]},languageId(){return Shopware.Store.get("session").languageId},tooltipSave(){return{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}},tooltipCancel(){return{message:"ESC",appearance:"light"}},localeOptions(){return this.languages.map(e=>({id:e.locale.id,value:e.locale.id,label:e.customLabel}))}},watch:{languageId(){this.createdComponent()}},created(){this.createdComponent()},methods:{createdComponent(){if(Shopware.ExtensionAPI.publishData({id:"sw-users-permissions-user-detail__currentUser",path:"currentUser",scope:this}),Shopware.ExtensionAPI.publishData({id:"sw-users-permissions-user-detail__user",path:"user",scope:this}),this.isLoading=!0,!this.languageId){this.isLoading=!1;return}this.getMediaDefaultFolderId().then(i=>{this.mediaDefaultFolderId=i}).catch(()=>{this.mediaDefaultFolderId=null}),this.timezoneOptions=Shopware.Service("timezoneService").getTimezoneOptions();const s=[new Promise(i=>{Shopware.Store.get("context").api.languageId=this.languageId,i(this.languageId)}),this.loadLanguages(),this.loadUser(),this.loadCurrentUser()];Promise.all(s).then(()=>{this.isLoading=!1})},loadLanguages(){return this.languageRepository.search(this.languageCriteria).then(e=>(this.languages=[],e.forEach(s=>{s.customLabel=`${s.locale.translated.name} (${s.locale.translated.territory})`,this.languages.push(s)}),this.languages))},loadUser(){return this.userId=this.$route.params.id,this.userRepository.get(this.userId,Shopware.Context.api,this.userCriteria).then(e=>{this.user=e,this.user.avatarId&&this.loadMediaItem(this.user.avatarId),this.keyRepository=this.repositoryFactory.create(e.accessKeys.entity,this.user.accessKeys.source),this.loadKeys()})},loadCurrentUser(){return this.userService.getUser().then(e=>{this.currentUser=e.data})},loadKeys(){this.integrations=this.user.accessKeys},addAccessKey(){const e=this.keyRepository.create();this.isModalLoading=!0,e.quantityStart=1,this.integrationService.generateKey({},{},!0).then(s=>{e.accessKey=s.accessKey,e.secretAccessKey=s.secretAccessKey,this.currentIntegration=e,this.isModalLoading=!1,this.showSecretAccessKey=!0})},checkEmail(){return this.user.email?this.userValidationService.checkUserEmail({email:this.user.email,id:this.user.id}).then(({emailIsUnique:e})=>{this.isEmailAlreadyInUse=!e}):Promise.resolve()},checkUsername(){return this.userValidationService.checkUserUsername({username:this.user.username,id:this.user.id}).then(({usernameIsUnique:e})=>{this.isUsernameUsed=!e})},loadMediaItem(e){this.mediaRepository.get(e).then(s=>{this.mediaItem=s,this.user.avatarMedia=s})},setMediaItem({targetId:e}){this.user.avatarId=e,this.loadMediaItem(e)},onUnlinkLogo(){this.mediaItem=null,this.user.avatarMedia=null,this.user.avatarId=null},onDropMedia(e){this.setMediaItem({targetId:e.id})},onOpenMedia(){this.showMediaModal=!0},onMediaSelectionChange([e]){this.mediaItem=e,this.user.avatarMedia=e,this.user.avatarId=e.id},getMediaDefaultFolderId(){return this.mediaDefaultFolderService.getDefaultFolderId("user")},onSearch(e){this.term=e,this.clearSelection()},saveFinish(){this.isSaveSuccessful=!1},onSave(){this.confirmPasswordModal=!0},saveUser(e){this.isSaveSuccessful=!1,this.isLoading=!0;let s=[];return this.currentUser.id===this.user.id&&(s=[Shopware.Service("localeHelper").setLocaleWithId(this.user.localeId)]),Promise.all(s).then(this.checkEmail().then(()=>{if(this.isEmailAlreadyInUse){const a=`user.${this.user.id}.email`,o=new m({code:"USER_EMAIL_ALREADY_EXISTS",detail:this.$tc("sw-users-permissions.users.user-detail.errorEmailUsed")});return Shopware.Store.get("error").addApiError({expression:a,error:o}),Promise.resolve()}this.isLoading=!0;const i=this.$tc("global.default.error"),l=this.$tc("sw-users-permissions.users.user-detail.notification.saveError.message",{name:this.fullName},0);return this.userRepository.save(this.user,e).then(()=>this.updateCurrentUser()).then(()=>{this.createdComponent(),this.confirmPasswordModal=!1,this.isSaveSuccessful=!0}).catch(a=>{throw this.createNotificationError({title:i,message:l}),u(this._name,a.message,a.response),this.isLoading=!1,a}).finally(()=>{this.isLoading=!1})}).catch(()=>Promise.reject()).finally(()=>{this.isLoading=!1}))},updateCurrentUser(){return this.userService.getUser().then(e=>{const s=e.data;return delete s.password,Shopware.Store.get("session").setCurrentUser(s)})},onCancel(){this.$router.push({name:"sw.users.permissions.index"})},setPassword(e){if(typeof e=="string"&&e.length<=0){delete this.user.password;return}this.user.password=e},onShowDetailModal(e){if(!e){this.addAccessKey();return}this.currentIntegration=this.user.accessKeys.get(e)},onCloseDetailModal(){this.currentIntegration=null,this.showSecretAccessKey=!1,this.isModalLoading=!1},onSaveIntegration(){this.currentIntegration&&(this.user.accessKeys.has(this.currentIntegration.id)||this.user.accessKeys.add(this.currentIntegration),this.onCloseDetailModal())},onCloseDeleteModal(){this.showDeleteModal=null},onConfirmDelete(e){e&&(this.onCloseDeleteModal(),this.user.accessKeys.remove(e))},onCloseConfirmPasswordModal(){this.confirmPasswordModal=!1}}};export{_ as default};
