const l=`{% block sw_tax_rule_card %} <mt-card :title="$tc('sw-settings-tax.taxRuleCard.cardTitle')" class="sw-tax-rule-card" position-identifier="sw-tax-rule" :class="taxRuleCardClasses" :is-loading="isLoading || taxRulesLoading || cardLoading" > <template #grid> <template v-if="!taxRulesEmpty && !disabled"> {% block sw_tax_rule_card_header %} <sw-card-section divider="bottom" secondary slim > {% block sw_tax_rule_card_header_filter %} <sw-card-filter :placeholder="$tc('sw-settings-tax.taxRuleCard.searchBarPlaceholder')" @sw-card-filter-term-change="onSearchTermChange" > <template #filter> {% block sw_tax_rule_card_header_create_rule_button %} <mt-button v-tooltip.bottom="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('tax.editor'), showOnDisabledElements: true }" class="sw-tax-rule-grid-button" size="small" :disabled="!acl.can('tax.editor') || undefined" variant="secondary" @click="showModal = true" > {% block sw_tax_rule_card_header_create_document_button_label %} {{ $tc('sw-settings-tax.taxRuleCard.labelCreateNew') }} {% endblock %} </mt-button> {% endblock %} </template> </sw-card-filter> {% endblock %} </sw-card-section> {% endblock %} {% block sw_tax_rule_card_grid %} <sw-data-grid :data-source="taxRules" :columns="getColumns" :full-page="false" :show-settings="true" :show-selection="false" :show-actions="true" :is-loading="isLoading" :allow-column-edit="false" :allow-inline-edit="false" v-bind="{sortBy, sortDirection}" identifier="sw-tax-rule-grid" @column-sort="onColumnSort" > {% block sw_settings_tax_rule_grid_column_tax_rate %} <template #column-taxRate="{ item, isInlineEdit, compact }"> <template v-if="isInlineEdit"> <mt-number-field v-model="item.taxRate" :digits="3" :size="compact ? 'small' : 'default'" > <template #suffix> <span> <span v-html="$sanitize($tc('sw-settings-tax.general.taxRateSymbol'))"></span> </span> </template> </mt-number-field> </template> <template v-else> {{ item.taxRate }}% </template> </template> {% endblock %} {% block sw_settings_tax_rule_grid_column_tax_rule_type_type_name %} <template #column-type.typeName="{ item }"> <component :is="getTypeCellComponent(item)" v-if="hasTypeCellComponent(item)" :tax-rule="item" /> <template v-else> {{ item.type.typeName }} </template> </template> {% endblock %} {% block sw_settings_tax_rule_grid_column_tax_rule_active_from %} <template #column-activeFrom="{ item }"> {{ dateFilter(item.activeFrom, { hour: '2-digit', minute: '2-digit', day: '2-digit', month: '2-digit', year: 'numeric' }) }} </template> {% endblock %} {% block sw_settings_tax_list_grid_columns_actions %} <template #actions="{ item }"> {% block sw_settings_tax_list_grid_columns_actions_edit %} <sw-context-menu-item class="sw-tax-list__edit-action" :disabled="!acl.can('tax.editor') || undefined" @click="showRuleModal(item)" > {{ $tc('sw-settings-tax.list.contextMenuEdit') }} </sw-context-menu-item> {% endblock %} {% block sw_settings_tax_list_grid_columns_actions_delete %} <sw-context-menu-item class="sw-tax-list__delete-action" variant="danger" :disabled="!acl.can('tax.editor') || undefined" @click="onDelete(item.id)" > {{ $tc('sw-settings-tax.list.contextMenuDelete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_settings_tax_list_grid_action_modals %} <template #action-modals="{ item }"> {% block sw_settings_tax_list_delete_modal %} <sw-modal v-if="showDeleteModal === item.id" :title="$tc('global.default.warning')" variant="small" @modal-close="onCloseDeleteModal" > {% block sw_settings_tax_list_delete_modal_confirm_delete_text %} <p class="sw-settings-tax-list__confirm-delete-text"> {{ $tc('sw-settings-tax.taxRuleCard.textDeleteConfirm', { name: item.country.name, type: item.type.typeName }, 0) }} </p> {% endblock %} {% block sw_settings_tax_list_delete_modal_footer %} <template #modal-footer> {% block sw_settings_tax_list_delete_modal_cancel %} <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_tax_list_delete_modal_confirm %} <mt-button variant="critical" size="small" @click="onConfirmDelete(item.id)" > {{ $tc('sw-settings-tax.list.buttonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </template> {% endblock %} {% block sw_settings_tax_list_grid_pagination %} <template #pagination> <sw-pagination v-bind="{ page, limit, total }" :total-visible="7" @page-change="paginate" /> </template> {% endblock %} </sw-data-grid> {% endblock %} </template> </template> {% block sw_tax_rule_card_grid_column_modal %} <sw-settings-tax-rule-modal v-if="showModal" :tax="tax" :current-rule="currentRule" @modal-close="onModalClose" /> {% endblock %} {% block sw_tax_rule_card_empty_state %} <template v-if="taxRulesEmpty || disabled"> <div class="sw-settings-tax-rule-card__empty-state"> {% block sw_tax_rule_card_empty_state_image %} <img :src="assetFilter('administration/administration/static/img/empty-states/settings-empty-state.svg')" alt="" > {% endblock %} {% block sw_tax_rule_card_empty_state_label %} <div class="sw-settings-tax-rule-card__empty-state--label"> <p v-if="disabled"> {{ $tc('sw-settings-tax.taxRuleCard.createStateDescription') }} </p> <p v-else> {{ $tc('sw-settings-tax.taxRuleCard.emptyStateDescription') }} </p> </div> {% endblock %} {% block sw_tax_rule_card_empty_state_button %} <mt-button v-tooltip.bottom="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('tax.editor'), showOnDisabledElements: true }" class="sw-settings-tax-rule-card__empty-state--button" ghost size="small" :disabled="disabled || !acl.can('tax.editor') || undefined" variant="secondary" @click="showModal = true" > {{ $tc('sw-settings-tax.taxRuleCard.labelCreateNew') }} </mt-button> {% endblock %} </div> </template> {% endblock %} </mt-card> {% endblock %}`,{Criteria:e}=Shopware.Data,s={template:l,inject:["repositoryFactory","acl"],props:{tax:{type:Object,required:!0},isLoading:{type:Boolean,required:!0},disabled:{type:Boolean,required:!1,default:!1}},data(){return{taxRulesLoading:!1,cardLoading:!1,taxRules:[],showModal:!1,showDeleteModal:!1,currentRule:null,term:"",page:1,limit:25,sortBy:"country.name",sortDirection:"ASC",total:void 0}},computed:{taxRuleRepository(){return this.repositoryFactory.create("tax_rule")},taxRulesEmpty(){return this.taxRules.length===0&&!this.term},taxRuleCardClasses(){return{"sw-tax-rule-card--is-empty":this.taxRulesEmpty}},taxRuleCriteria(){const t=new e(this.page,this.limit);return t.addSorting(e.sort(this.sortBy,this.sortDirection)),t.addAssociation("type"),t.addAssociation("country"),t.addFilter(e.equals("taxId",this.tax.id)),this.term&&t.addFilter(e.multi("OR",[e.contains("taxRate",this.term),e.contains("type.technicalName",this.term),e.contains("type.typeName",this.term),e.contains("country.name",this.term)])),t},getColumns(){return[{property:"country.name",dataIndex:"country.name",label:"sw-settings-tax.taxRuleCard.labelCountryName",primary:!0},{property:"type.typeName",dataIndex:"type.typeName",label:"sw-settings-tax.taxRuleCard.labelAppliesOn"},{property:"taxRate",dataIndex:"taxRate",label:"sw-settings-tax.taxRuleCard.labelTaxRate"},{property:"activeFrom",dataIndex:"activeFrom",label:"sw-settings-tax.taxRuleCard.labelActiveFrom"}]},assetFilter(){return Shopware.Filter.getByName("asset")},dateFilter(){return Shopware.Filter.getByName("date")}},created(){this.createdComponent()},methods:{createdComponent(){this.getList()},getList(){return this.taxRulesLoading=!0,this.taxRuleRepository.search(this.taxRuleCriteria).then(t=>(this.total=t.total,this.taxRules=t,this.taxRulesLoading=!1,Promise.resolve()))},paginate({page:t,limit:a}){this.page=t,this.limit=a,this.getList()},onColumnSort(t){this.sortDirection==="ASC"&&t.dataIndex===this.sortBy?this.sortDirection="DESC":this.sortDirection="ASC",this.sortBy=t.dataIndex,this.getList()},onSearchTermChange(t){this.term=t,this.getList()},onModalClose(){this.showModal=!1,this.currentRule=null,this.$nextTick(()=>this.getList())},showRuleModal(t){this.currentRule=t,this.showModal=!0},onDelete(t){this.showDeleteModal=t},onCloseDeleteModal(){this.showDeleteModal=!1},onConfirmDelete(t){return this.showDeleteModal=!1,this.taxRuleRepository.delete(t).then(()=>{this.getList()})},hasTypeCellComponent(t){const a=`sw-settings-tax-rule-type-${t.type.technicalName.replace(/_/g,"-")}-cell`;return Shopware.Component.getComponentRegistry().has(a)},getTypeCellComponent(t){return`sw-settings-tax-rule-type-${t.type.technicalName.replace(/_/g,"-")}-cell`}}};export{s as default};
