const l=`{% block sw_settings_payment_detail %} <sw-page class="sw-settings-payment-detail"> {% block sw_settings_payment_detail_header %} <template #smart-bar-header> <h2>{{ placeholder(paymentMethod, 'name', $tc('sw-settings-payment.detail.textHeadline')) }}</h2> </template> {% endblock %} {% block sw_settings_payment_detail_actions %} <template #smart-bar-actions> {% block sw_settings_payment_detail_actions_abort %} <mt-button v-tooltip.bottom="tooltipCancel" :disabled="isLoading || undefined" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_payment_detail_actions_save %} <sw-button-process v-tooltip.bottom="tooltipSave" class="sw-payment-detail__save-action" :is-loading="isLoading" :process-success="isSaveSuccessful" :disabled="isLoading || !acl.can('payment.editor') || undefined" variant="primary" @update:process-success="saveFinish" @click.prevent="onSave" > {{ $tc('sw-settings-payment.detail.buttonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_settings_payment_detail_language_switch %} <template #language-switch> <sw-language-switch :save-changes-function="saveOnLanguageChange" :abort-change-function="abortOnLanguageChange" @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_settings_payment_detail_content %} <template #content> <sw-card-view> <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </template> <template v-else> {% block sw_product_stream_detail_content_language_info %} <sw-language-info :entity-description="placeholder(paymentMethod, 'name', $tc('sw-settings-payment.detail.textHeadline'))" /> {% endblock %} {% block sw_settings_payment_detail_content_card %} <mt-card position-identifier="sw-settings-payment-detail-content" :title="$tc('sw-settings-payment.detail.titleCard')" :is-loading="isLoading" > <template v-if="!isLoading"> {% block sw_settings_payment_detail_content_field_plugin %} <sw-plugin-box v-if="!!paymentMethod.pluginId" :plugin-id="paymentMethod.pluginId" /> {% endblock %} <sw-container columns="3fr 3fr 1fr" gap="0px 30px" > {% block sw_settings_payment_detail_content_field_name %} <mt-text-field v-model="paymentMethod.name" name="sw-field--paymentMethod-name" class="sw-settings-payment-detail__field-name" required :disabled="!acl.can('payment.editor') || undefined" :label="$tc('sw-settings-payment.detail.labelName')" :placeholder="placeholder(paymentMethod, 'name', $tc('sw-settings-payment.detail.placeholderName'))" :error="paymentMethodNameError" /> {% endblock %} {% block sw_settings_payment_detail_content_field_technical_name %} <mt-text-field v-model="paymentMethod.technicalName" name="sw-field--paymentMethod-technicalName" class="sw-settings-payment-detail__field-technical-name" required :disabled="!acl.can('payment.editor') || technicalNameIsProvided || undefined" :label="$tc('sw-settings-payment.detail.labelTechnicalName')" :placeholder="placeholder(paymentMethod, 'technicalName', $tc('sw-settings-payment.detail.placeholderTechnicalName'))" :error="paymentMethodTechnicalNameError" :help-text="$tc('sw-settings-payment.detail.helpTextTechnicalName')" > <template #hint> <span v-if="technicalNameIsProvided">{{ $tc('sw-settings-payment.detail.hintTextTechnicalNameIsProvided', { name: paymentMethod.translated?.name ?? paymentMethod.name }) }}</span> </template> </mt-text-field> {% endblock %} {% block sw_settings_payment_detail_content_field_position %} <mt-number-field v-model="paymentMethod.position" name="sw-field--paymentMethod-position" class="sw-settings-payment-detail__field-position" :disabled="!acl.can('payment.editor') || undefined" :label="$tc('sw-settings-payment.detail.labelPosition')" :placeholder="$tc('sw-settings-payment.detail.placeholderPosition')" /> {% endblock %} </sw-container> <sw-container columns="repeat(auto-fit, minmax(250px, 1fr))" gap="0px 30px" > {% block sw_settings_payment_detail_base_content_field_description %} <mt-textarea v-model="paymentMethod.description" name="sw-field--paymentMethod-description" :disabled="!acl.can('payment.editor') || undefined" :model-value="paymentMethod.description" class="sw-settings-payment-detail__description" :label="$tc('sw-settings-payment.detail.labelDescription')" :placeholder="placeholder(paymentMethod, 'description', $tc('sw-settings-payment.detail.placeholderDescription'))" /> {% endblock %} {% block sw_settings_payment_detail_base_content_media_upload %} <sw-upload-listener :upload-tag="uploadTag" auto-upload @media-upload-finish="setMediaItem" /> <sw-media-upload-v2 :disabled="!acl.can('payment.editor') || undefined" :upload-tag="uploadTag" :source="mediaItem" class="sw-settings-payment-detail__logo-image-upload" :allow-multi-select="false" variant="regular" :label="$tc('sw-settings-payment.detail.labelLogoUpload')" :default-folder="paymentMethod.getEntityName()" @media-drop="onDropMedia" @media-upload-sidebar-open="openMediaSidebar" @media-upload-remove-image="onUnlinkLogo" /> {% endblock %} </sw-container> <sw-container columns="repeat(auto-fit, minmax(250px, 2fr))" gap="0px 30px" > {% block sw_settings_payment_detail_content_field_active %} <mt-switch v-model="paymentMethod.active" name="sw-field--paymentMethod-active" class="sw-settings-payment-detail__field-active" :disabled="!acl.can('payment.editor') || undefined" :label="$tc('sw-settings-payment.detail.labelActive')" /> {% endblock %} {% block sw_settings_payment_detail_content_field_after_order_enabled %} <mt-switch v-model="paymentMethod.afterOrderEnabled" name="sw-field--paymentMethod-afterOrderEnabled" class="sw-settings-payment-detail__field-after-order" :disabled="!acl.can('payment.editor') || undefined" :label="$tc('sw-settings-payment.detail.labelAfterOrderEnabled')" /> {% endblock %} </sw-container> </template> </mt-card> {% endblock %} {% block sw_settings_payment_detail_top_rule %} <mt-card class="sw-settings-payment-detail__condition_container" position-identifier="sw-settings-payment-detail-condition-container" :title="$tc('sw-settings-payment.detail.topRule')" :is-loading="isLoading" > {% block sw_settings_payment_detail_top_rule_select %} <sw-select-rule-create v-if="!isLoading" class="sw-settings-payment-detail__field-availability-rule" :disabled="!acl.can('payment.editor') || undefined" :rule-id="paymentMethod.availabilityRuleId" :rule-filter="ruleFilter" :placeholder="$tc('sw-settings-payment.detail.placeholderAvailabilityRule')" rule-aware-group-key="paymentMethods" @save-rule="onSaveRule" @dismiss-rule="onDismissRule" /> {% endblock %} </mt-card> {% endblock %} {% block sw_settings_payment_detail_custom_field_sets %} <mt-card v-if="showCustomFields" position-identifier="sw-settings-payment-detail-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="paymentMethod" :disabled="!acl.can('payment.editor') || undefined" :sets="customFieldSets" /> </mt-card> {% endblock %} {% block sw_settings_payment_detail_delete_payment_method %} <mt-card v-if="!isNewPaymentMethod && acl.can('payment.deleter')" position-identifier="sw-settings-payment-detail-delete" class="sw-settings-payment-detail-delete" :title="$tc('sw-settings-payment.detail.delete.textHeadline')" :is-loading="isLoading" > <mt-banner v-if="forbidDelete" variant="info" > {{ $tc('sw-settings-payment.detail.delete.textAlert') }} </mt-banner> <div class="sw-settings-payment-detail-delete__container"> <mt-button variant="critical" ghost :disabled="forbidDelete || !acl.can('payment.deleter') || undefined" @click="showDeleteModal = true" > {{ $tc('sw-settings-payment.detail.delete.textButton') }} </mt-button> </div> </mt-card> {% endblock %} {% block sw_settings_payment_detail_delete_modal %} <sw-modal v-if="showDeleteModal && acl.can('payment.deleter')" :title="$tc('global.default.warning')" variant="default" @modal-close="showDeleteModal = false" > {% block sw_settings_payment_detail_delete_modal_info %} <div class="sw_theme_manager__confirm-delete-text"> <p class="text-secondary"> {{ $tc('sw-settings-payment.detail.delete.modal.textConfirmation') }} </p> </div> {% endblock %} {% block sw_settings_payment_detail_delete_modal_footer %} <template #modal-footer> {% block sw_settings_payment_detail_reset_modal_cancel %} <mt-button size="small" variant="secondary" @click="showDeleteModal = false" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_settings_payment_detail_reset_modal_confirm %} <mt-button :disabled="deletionInProcess || undefined" variant="critical" size="small" @click="deletePaymentMethod" > {{ $tc('sw-settings-payment.detail.delete.modal.buttonDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </template> </sw-card-view> </template> {% endblock %} <template #sidebar> <sw-sidebar :propagate-width="true"> <sw-sidebar-media-item ref="mediaSidebarItem"> <template #context-menu-items="media" > <sw-context-menu-item @click="setMediaFromSidebar(media.mediaItem)"> {{ $tc('sw-settings-payment.detail.sidebar.labelUseAsLogo') }} </sw-context-menu-item> </template> </sw-sidebar-media-item> </sw-sidebar> </template> </sw-page> {% endblock %}`,{Mixin:n}=Shopware,{Criteria:i}=Shopware.Data,{warn:d}=Shopware.Utils.debug,{mapPropertyErrors:o}=Shopware.Component.getComponentHelper(),m={template:l,inject:["repositoryFactory","acl","customFieldDataProviderService"],mixins:[n.getByName("notification"),n.getByName("placeholder")],shortcuts:{"SYSTEMKEY+S":{active(){return this.acl.can("payment.editor")},method:"onSave"},ESCAPE:"onCancel"},data(){return{paymentMethod:null,mediaItem:null,uploadTag:"sw-payment-method-upload-tag",isLoading:!1,isSaveSuccessful:!1,customFieldSets:null,showDeleteModal:!1,deletionInProcess:!1}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{isNewPaymentMethod(){return this.paymentMethod._isNew},identifier(){return this.placeholder(this.paymentMethod,"name")},paymentMethodRepository(){return this.repositoryFactory.create("payment_method")},ruleRepository(){return this.repositoryFactory.create("rule")},mediaRepository(){return this.repositoryFactory.create("media")},tooltipSave(){return this.acl.can("payment.editor")?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.acl.can("payment.editor"),showOnDisabledElements:!0}},tooltipCancel(){return{message:"ESC",appearance:"light"}},ruleFilter(){const e=new i(1,25);return e.addFilter(i.multi("OR",[i.contains("rule.moduleTypes.types","payment"),i.equals("rule.moduleTypes",null)])),e.addAssociation("conditions").addSorting(i.sort("name","ASC",!1)),e},showCustomFields(){return this.paymentMethod&&this.customFieldSets&&this.customFieldSets.length>0},paymentMethodCriteria(){const e=new i;return e.setIds([this.paymentMethodId]),this.acl.can("payment.deleter")&&(e.getAssociation("customers").setLimit(1),e.getAssociation("salesChannels").setLimit(1),e.getAssociation("salesChannelDefaultAssignments").setLimit(1),e.getAssociation("orderTransactions").setLimit(1)),e},forbidDelete(){var e,t,a,s;return((e=this.paymentMethod.orderTransactions)==null?void 0:e.length)!==0||((t=this.paymentMethod.salesChannels)==null?void 0:t.length)!==0||((a=this.paymentMethod.customers)==null?void 0:a.length)!==0||((s=this.paymentMethod.salesChannelDefaultAssignments)==null?void 0:s.length)!==0},technicalNameIsProvided(){var e,t,a;return!!((e=this.paymentMethod)!=null&&e.pluginId)||!!((a=(t=this.paymentMethod)==null?void 0:t.appPaymentMethod)!=null&&a.id)},...o("paymentMethod",["name","technicalName"])},watch:{"paymentMethod.mediaId"(){this.paymentMethod.mediaId&&this.setMediaItem({targetId:this.paymentMethod.mediaId})}},created(){this.createdComponent()},methods:{createdComponent(){this.paymentMethodId=this.$route.params.id,this.loadEntityData(),this.loadCustomFieldSets()},onSaveRule(e){this.paymentMethod.availabilityRuleId=e},onDismissRule(){this.paymentMethod.availabilityRuleId=null},abortOnLanguageChange(){return this.paymentMethodRepository.hasChanges(this.paymentMethod)},saveOnLanguageChange(){return this.onSave()},onChangeLanguage(){this.loadEntityData()},loadEntityData(){this.isLoading=!0,this.paymentMethodRepository.search(this.paymentMethodCriteria).then(e=>e.first()).then(e=>{this.paymentMethod=e,e!=null&&e.mediaId&&this.setMediaItem({targetId:e.mediaId})}).finally(()=>{this.isLoading=!1})},loadCustomFieldSets(){this.customFieldDataProviderService.getCustomFieldSets("payment_method").then(e=>{this.customFieldSets=e})},saveFinish(){this.isSaveSuccessful=!1},onSave(){return this.isSaveSuccessful=!1,this.isLoading=!0,this.paymentMethodRepository.save(this.paymentMethod).then(()=>{this.isSaveSuccessful=!0,this.$refs.mediaSidebarItem.getList(),this.loadEntityData()}).catch(e=>{throw this.onError(e),d(this._name,e.message,e.response),e}).finally(()=>{this.isLoading=!1})},onError(e){let t=null;try{t=e.response.data.errors[0].detail}catch{t=""}this.createNotificationError({title:this.$tc("global.default.error"),message:`${this.$tc("sw-settings-payment.detail.messageSaveError",{name:this.paymentMethod.name},0)} ${t}`})},onCancel(){this.$router.push({name:"sw.settings.payment.overview"})},setMediaItem({targetId:e}){this.mediaRepository.get(e).then(t=>{this.mediaItem=t,this.paymentMethod.mediaId=e})},setMediaFromSidebar(e){this.mediaItem=e,this.paymentMethod.mediaId=e.id},onUnlinkLogo(){this.mediaItem=null,this.paymentMethod.mediaId=null},onDropMedia(e){this.setMediaItem({targetId:e.id})},openMediaSidebar(){this.$refs.mediaSidebarItem.openContent()},async deletePaymentMethod(){this.acl.can("payment.deleter")&&(this.deletionInProcess=!0,await this.paymentMethodRepository.delete(this.paymentMethod.id),await this.$router.replace({name:"sw.settings.payment.overview"}))}}};export{m as default};
