const _=`{% block sw_product_stream_list %} <sw-page class="sw-product-stream-list"> {% block sw_product_stream_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="product_stream" :placeholder="$tc('sw-product-stream.general.placeholderSearchBar')" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_product_stream_list_smart_bar_header %} <template #smart-bar-header> {% block sw_product_stream_list_smart_bar_header_title %} <h2> {% block sw_product_stream_list_smart_bar_header_title_text %} {{ $tc('sw-product-stream.list.textProductStreamOverview') }} {% endblock %} {% block sw_product_stream_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_product_stream_list_smart_bar_actions %} <template #smart-bar-actions> {% block sw_product_stream_list_smart_bar_actions_add %} <mt-button v-tooltip.bottom="getNoPermissionsTooltip('product_stream.creator')" class="sw-product-stream-list__create-action" :disabled="!acl.can('product_stream.creator')" variant="primary" size="default" @click="$router.push({ name: 'sw.product.stream.create' })" > {{ $tc('sw-product-stream.list.buttonAddProductStream') }} </mt-button> {% endblock %} </template> {% endblock %} {% block sw_manufacturer_list_language_switch %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% endblock %} <template #content> {% block sw_product_stream_list_content %} <div class="sw-product-stream-list__content"> {% block sw_product_stream_list_grid %} <sw-entity-listing v-if="isLoading || (productStreams && entitySearchable)" ref="swProductStreamGrid" class="sw-product-stream-list-grid" :items="productStreams" :columns="getProductStreamColumns()" :repository="productStreamRepository" detail-route="sw.product.stream.detail" :show-selection="acl.can('product_stream.deleter')" :is-loading="isLoading" :disable-data-fetching="true" :sort-by="currentSortBy" :sort-direction="sortDirection" :criteria-limit="limit" :allow-inline-edit="acl.can('product_stream.editor')" identifier="sw-product-stream-list" @page-change="onPageChange" @column-sort="onSortColumn" @inline-edit-save="onInlineEditSave" @items-delete-finish="getList" @delete-item-failed="onDeleteItemFailed" @delete-items-failed="onDeleteItemsFailed" > {% block sw_product_stream_list_grid_bulk %} <template #bulk> <span v-if="!acl.can('product_stream.deleter')"></span> </template> {% endblock %} {% block sw_product_stream_list_grid_column_invalid %} <template #column-invalid="{item}"> <template v-if="item.invalid"> {{ $tc('sw-product-stream.list.status.invalid') }} </template> <template v-else> {{ $tc('sw-product-stream.list.status.valid') }} </template> </template> {% endblock %} {% block sw_product_stream_list_grid_colum_updated_at %} <template #column-updatedAt="{item}"> <template v-if="item.updatedAt"> {{ dateFilter(item.updatedAt) }} </template> <template v-else> {{ dateFilter(item.createdAt) }} </template> </template> {% endblock %} {% block sw_product_stream_list_grid_more_actions %} <template #more-actions="{item}"> {% block sw_product_stream_list_grid_duplicate_action %} <sw-context-menu-item :disabled="!acl.can('product_stream.creator')" class="sw-entity-listing__context-menu-edit-duplicate" @click="onDuplicate(item)" > {{ $tc('global.default.duplicate') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_product_stream_list_grid_delete_action %} <template #delete-action="{item, showDelete, allowDelete}"> <sw-context-menu-item :disabled="!acl.can('product_stream.deleter') || !allowDelete" class="sw-entity-listing__context-menu-edit-delete" variant="danger" @click="showDelete(item.id)" > {{ $tc('global.default.delete') }} </sw-context-menu-item> </template> {% endblock %} </sw-entity-listing> {% endblock %} {% block sw_product_stream_list_empty_state %} <template v-else-if="!isLoading && !total"> <sw-empty-state v-if="isValidTerm(term)" :title="$tc('sw-empty-state.messageNoResultTitle')" > <template #default> {{ $tc('sw-empty-state.messageNoResultSublineBefore') }} <router-link class="sw-empty-state__description-link" :to="{ name: 'sw.profile.index.searchPreferences' }" > {{ $tc('sw-empty-state.messageNoResultSublineLink') }} </router-link> {{ $tc('sw-empty-state.messageNoResultSublineAfter') }} </template> </sw-empty-state> <sw-empty-state v-else :title="$tc('sw-product-stream.list.messageEmpty')" /> </template> {% endblock %} </div> {% endblock %} </template> {% block sw_product_stream_list_sidebar %} <template #sidebar> <sw-sidebar> {% block sw_product_stream_list_sidebar_refresh %} <sw-sidebar-item icon="regular-undo" :title="$tc('sw-product-stream.list.titleSidebarItemRefresh')" @click="onRefresh" /> {% endblock %} </sw-sidebar> </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:m}=Shopware,{Criteria:r}=Shopware.Data,h={template:_,inject:["repositoryFactory","acl"],mixins:[m.getByName("listing"),m.getByName("notification")],data(){return{productStreams:null,sortBy:"createdAt",sortDirection:"DESC",isLoading:!1,showDeleteModal:!1,searchConfigEntity:"product_stream"}},metaInfo(){return{title:this.$createTitle()}},computed:{productStreamRepository(){return this.repositoryFactory.create("product_stream")},dateFilter(){return Shopware.Filter.getByName("date")}},methods:{onInlineEditSave(t,e){return t.then(()=>{this.createNotificationSuccess({message:this.$tc("sw-product-stream.detail.messageSaveSuccess",{name:e.name},0)})}).catch(()=>{this.getList(),this.createNotificationError({message:this.$tc("sw-product-stream.detail.messageSaveError")})})},onChangeLanguage(){return this.getList()},async getList(){this.isLoading=!0;let t=new r(this.page,this.limit);return t.setTerm(this.term),this.acl.can("category:read")&&t.addAggregation(r.terms("product_stream","id",null,null,r.count("categories","product_stream.categories.id"))),this.naturalSorting=this.sortBy==="createdAt",t.addSorting(r.sort(this.sortBy,this.sortDirection,this.naturalSorting)),t=await this.addQueryScores(this.term,t),this.entitySearchable?(this.freshSearchTerm&&t.resetSorting(),this.productStreamRepository.search(t).then(e=>(this.total=e.total,this.productStreams=e,this.isLoading=!1,e)).catch(()=>{this.isLoading=!1})):(this.isLoading=!1,this.total=0,!1)},getProductStreamColumns(){return[{property:"name",dataIndex:"name",inlineEdit:"string",label:"sw-product-stream.list.columnName",routerLink:"sw.product.stream.detail",width:"250px",allowResize:!0,primary:!0},{property:"description",label:"sw-product-stream.list.columnDescription",width:"250px",allowResize:!0},{property:"updatedAt",label:"sw-product-stream.list.columnDateUpdated",align:"right",allowResize:!0},{property:"invalid",label:"sw-product-stream.list.columnStatus",allowResize:!0}]},getNoPermissionsTooltip(t,e=!0){return{showDelay:300,message:this.$tc("sw-privileges.tooltip.warning"),appearance:"dark",showOnDisabledElements:e,disabled:this.acl.can(t)||this.allowDelete}},onDeleteItemFailed({id:t,errorResponse:e}){var o,l,c,n,d;const a=(o=this.productStreams)==null?void 0:o.get(t),s=((d=(n=(c=(l=e==null?void 0:e.response)==null?void 0:l.data)==null?void 0:c.errors)==null?void 0:n[0])==null?void 0:d.detail)||null;if(!a)return;if(!this.productStreams.aggregations.product_stream){this.createNotificationError({message:s});return}const i=this.productStreams.aggregations.product_stream.buckets.filter(p=>p.key===t).at(0).categories.count,u=a.name;if(i===0){this.createNotificationError({message:s});return}this.createNotificationError({message:this.$tc("sw-product-stream.general.errorCategory",{name:u,count:i},i)})},onDeleteItemsFailed({selectedIds:t,errorResponse:e}){t.forEach(a=>{this.onDeleteItemFailed({id:a,errorResponse:e})})},onDuplicate(t){const e={cloneChildren:!0,overwrites:{name:`${t.name||t.translated.name} ${this.$tc("global.default.copy")}`}};this.isLoading=!0,this.productStreamRepository.clone(t.id,e,Shopware.Context.api).then(a=>{const s={name:"sw.product.stream.detail",params:{id:a.id}};this.$router.push(s)}).catch(()=>{this.isLoading=!1,this.createNotificationError({message:this.$tc("global.notification.unspecifiedSaveErrorMessage")})})}}};export{h as default};
