<?php declare(strict_types=1);

namespace Shopware\Storefront\Test\Theme\fixtures;

/**
 * @internal
 */
class ThemeFixtures
{
    /**
     * @return array<string, mixed>
     */
    public static function getThemeFields(): array
    {
        return [
            'themeColors' => [
                'label' => 'themeColors',
                'sections' => [
                    'default' => [
                        'label' => '',
                        'sw-color-brand-primary' => [
                            'label' => [
                                'en-GB' => 'Primary colour',
                                'de-DE' => 'Primärfarbe',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-color-brand-secondary' => [
                            'label' => [
                                'en-GB' => 'Secondary colour',
                                'de-DE' => 'Sekundärfarbe',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-border-color' => [
                            'label' => [
                                'en-GB' => 'Border',
                                'de-DE' => 'Rahmen',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-background-color' => [
                            'label' => [
                                'en-GB' => 'Background',
                                'de-DE' => 'Hintergrund',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                    ],
                ],
            ],
            'typography' => [
                'label' => 'typography',
                'sections' => [
                    'default' => [
                        'sw-font-family-base' => [
                            'label' => [
                                'en-GB' => 'Fonttype text',
                                'de-DE' => 'Schriftart Text',
                            ],
                            'type' => 'fontFamily',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-font-family-headline' => [
                            'label' => [
                                'en-GB' => 'Fonttype headline',
                                'de-DE' => 'Schriftart Überschrift',
                            ],
                            'type' => 'fontFamily',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-headline-color' => [
                            'label' => [
                                'en-GB' => 'Headline colour',
                                'de-DE' => 'Überschriftfarbe',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-text-color' => [
                            'label' => [
                                'en-GB' => 'Text colour',
                                'de-DE' => 'Textfarbe',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'label' => '',
                    ],
                ],
            ],
            'media' => [
                'label' => 'media',
                'sections' => [
                    'default' => [
                        'label' => '',
                        'sw-logo-desktop' => [
                            'label' => [
                                'en-GB' => 'Desktop',
                                'de-DE' => 'Desktop',
                            ],
                            'helpText' => [
                                'en-GB' => 'Displayed on viewport sizes above 991px and as a fallback on smaller viewports, if no other logo is set.',
                                'de-DE' => 'Wird bei Ansichten über 991px angezeigt und als Alternative bei kleineren Auflösungen, für die kein anderes Logo eingestellt ist.',
                            ],
                            'type' => 'media',
                            'custom' => null,
                        ],
                        'sw-logo-tablet' => [
                            'label' => [
                                'en-GB' => 'Tablet',
                                'de-DE' => 'Tablet',
                            ],
                            'helpText' => [
                                'en-GB' => 'Displayed between a viewport of 767px to 991px',
                                'de-DE' => 'Wird zwischen einem viewport von 767px bis 991px angezeigt',
                            ],
                            'type' => 'media',
                            'custom' => null,
                        ],
                        'sw-logo-mobile' => [
                            'label' => [
                                'en-GB' => 'Mobile',
                                'de-DE' => 'Mobil',
                            ],
                            'helpText' => [
                                'en-GB' => 'Displayed up to a viewport of 767px',
                                'de-DE' => 'Wird bis zu einem Viewport von 767px angezeigt',
                            ],
                            'type' => 'media',
                            'custom' => null,
                        ],
                        'sw-logo-share' => [
                            'label' => [
                                'en-GB' => 'App & share icon',
                                'de-DE' => 'App- & Share-Icon',
                            ],
                            'type' => 'media',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-logo-favicon' => [
                            'label' => [
                                'en-GB' => 'Favicon',
                                'de-DE' => 'Favicon',
                            ],
                            'type' => 'media',
                            'helpText' => null,
                            'custom' => null,
                        ],
                    ],
                ],
            ],
            'eCommerce' => [
                'label' => 'eCommerce',
                'sections' => [
                    'default' => [
                        'label' => '',
                        'sw-color-price' => [
                            'label' => [
                                'en-GB' => 'Price',
                                'de-DE' => 'Preis',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-color-buy-button' => [
                            'label' => [
                                'en-GB' => 'Buy button',
                                'de-DE' => 'Kaufen-Button',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-color-buy-button-text' => [
                            'label' => [
                                'en-GB' => 'Buy button text',
                                'de-DE' => 'Kaufen-Button Text',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                    ],
                ],
            ],
            'statusColors' => [
                'label' => 'statusColors',
                'sections' => [
                    'default' => [
                        'label' => '',
                        'sw-color-success' => [
                            'label' => [
                                'en-GB' => 'Success',
                                'de-DE' => 'Erfolg',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-color-info' => [
                            'label' => [
                                'en-GB' => 'Information',
                                'de-DE' => 'Information',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-color-warning' => [
                            'label' => [
                                'en-GB' => 'Notice',
                                'de-DE' => 'Hinweis',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                        'sw-color-danger' => [
                            'label' => [
                                'en-GB' => 'Error',
                                'de-DE' => 'Fehler',
                            ],
                            'type' => 'color',
                            'helpText' => null,
                            'custom' => null,
                        ],
                    ],
                ],
            ],
            'unordered' => [
                'label' => 'unordered',
                'sections' => [
                ],
            ],
        ];
    }

    /**
     * @return array<string, mixed>
     */
    public static function getThemeStructuredFields(): array
    {
        return [
            'tabs' => [
                'default' => [
                    'label' => '',
                    'blocks' => [
                        'themeColors' => [
                            'label' => 'themeColors',
                            'sections' => [
                                'default' => [
                                    'label' => '',
                                    'fields' => [
                                        'sw-color-brand-primary' => [
                                            'label' => [
                                                'en-GB' => 'Primary colour',
                                                'de-DE' => 'Primärfarbe',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-color-brand-secondary' => [
                                            'label' => [
                                                'en-GB' => 'Secondary colour',
                                                'de-DE' => 'Sekundärfarbe',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-border-color' => [
                                            'label' => [
                                                'en-GB' => 'Border',
                                                'de-DE' => 'Rahmen',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-background-color' => [
                                            'label' => [
                                                'en-GB' => 'Background',
                                                'de-DE' => 'Hintergrund',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                    ],
                                ],
                            ],
                        ],
                        'statusColors' => [
                            'label' => 'statusColors',
                            'sections' => [
                                'default' => [
                                    'label' => '',
                                    'fields' => [
                                        'sw-color-success' => [
                                            'label' => [
                                                'en-GB' => 'Success',
                                                'de-DE' => 'Erfolg',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-color-info' => [
                                            'label' => [
                                                'en-GB' => 'Information',
                                                'de-DE' => 'Information',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-color-warning' => [
                                            'label' => [
                                                'en-GB' => 'Notice',
                                                'de-DE' => 'Hinweis',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-color-danger' => [
                                            'label' => [
                                                'en-GB' => 'Error',
                                                'de-DE' => 'Fehler',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                    ],
                                ],
                            ],
                        ],
                        'typography' => [
                            'label' => 'typography',
                            'sections' => [
                                'default' => [
                                    'label' => '',
                                    'fields' => [
                                        'sw-font-family-base' => [
                                            'label' => [
                                                'en-GB' => 'Fonttype text',
                                                'de-DE' => 'Schriftart Text',
                                            ],
                                            'helpText' => null,
                                            'type' => 'fontFamily',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-text-color' => [
                                            'label' => [
                                                'en-GB' => 'Text colour',
                                                'de-DE' => 'Textfarbe',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-font-family-headline' => [
                                            'label' => [
                                                'en-GB' => 'Fonttype headline',
                                                'de-DE' => 'Schriftart Überschrift',
                                            ],
                                            'helpText' => null,
                                            'type' => 'fontFamily',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-headline-color' => [
                                            'label' => [
                                                'en-GB' => 'Headline colour',
                                                'de-DE' => 'Überschriftfarbe',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                    ],
                                ],
                            ],
                        ],
                        'eCommerce' => [
                            'label' => 'eCommerce',
                            'sections' => [
                                'default' => [
                                    'label' => '',
                                    'fields' => [
                                        'sw-color-price' => [
                                            'label' => [
                                                'en-GB' => 'Price',
                                                'de-DE' => 'Preis',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-color-buy-button' => [
                                            'label' => [
                                                'en-GB' => 'Buy button',
                                                'de-DE' => 'Kaufen-Button',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-color-buy-button-text' => [
                                            'label' => [
                                                'en-GB' => 'Buy button text',
                                                'de-DE' => 'Kaufen-Button Text',
                                            ],
                                            'helpText' => null,
                                            'type' => 'color',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                    ],
                                ],
                            ],
                        ],
                        'media' => [
                            'label' => 'media',
                            'sections' => [
                                'default' => [
                                    'label' => '',
                                    'fields' => [
                                        'sw-logo-desktop' => [
                                            'label' => [
                                                'en-GB' => 'Desktop',
                                                'de-DE' => 'Desktop',
                                            ],
                                            'helpText' => [
                                                'en-GB' => 'Displayed on viewport sizes above 991px and as a fallback on smaller viewports, if no other logo is set.',
                                                'de-DE' => 'Wird bei Ansichten über 991px angezeigt und als Alternative bei kleineren Auflösungen, für die kein anderes Logo eingestellt ist.',
                                            ],
                                            'type' => 'media',
                                            'custom' => null,
                                            'fullWidth' => true,
                                        ],
                                        'sw-logo-tablet' => [
                                            'label' => [
                                                'en-GB' => 'Tablet',
                                                'de-DE' => 'Tablet',
                                            ],
                                            'helpText' => [
                                                'en-GB' => 'Displayed between a viewport of 767px to 991px',
                                                'de-DE' => 'Wird zwischen einem viewport von 767px bis 991px angezeigt',
                                            ],
                                            'type' => 'media',
                                            'custom' => null,
                                            'fullWidth' => true,
                                        ],
                                        'sw-logo-mobile' => [
                                            'label' => [
                                                'en-GB' => 'Mobile',
                                                'de-DE' => 'Mobil',
                                            ],
                                            'helpText' => [
                                                'en-GB' => 'Displayed up to a viewport of 767px',
                                                'de-DE' => 'Wird bis zu einem Viewport von 767px angezeigt',
                                            ],
                                            'type' => 'media',
                                            'custom' => null,
                                            'fullWidth' => true,
                                        ],
                                        'sw-logo-share' => [
                                            'label' => [
                                                'en-GB' => 'App & share icon',
                                                'de-DE' => 'App- & Share-Icon',
                                            ],
                                            'helpText' => null,
                                            'type' => 'media',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                        'sw-logo-favicon' => [
                                            'label' => [
                                                'en-GB' => 'Favicon',
                                                'de-DE' => 'Favicon',
                                            ],
                                            'helpText' => null,
                                            'type' => 'media',
                                            'custom' => null,
                                            'fullWidth' => null,
                                        ],
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

    /**
     * @return array<string, mixed>
     */
    public static function getThemeInheritedConfig(string $faviconId, string $demostoreLogoId): array
    {
        $config = [
            'blocks' => [
                'themeColors' => [
                    'label' => [
                        'en-GB' => 'Theme colours',
                        'de-DE' => 'Theme-Farben',
                    ],
                ],
                'typography' => [
                    'label' => [
                        'en-GB' => 'Typography',
                        'de-DE' => 'Typografie',
                    ],
                ],
                'media' => [
                    'label' => [
                        'en-GB' => 'Media',
                        'de-DE' => 'Medien',
                    ],
                ],
                'eCommerce' => [
                    'label' => [
                        'en-GB' => 'E-Commerce',
                        'de-DE' => 'E-Commerce',
                    ],
                ],
                'statusColors' => [
                    'label' => [
                        'en-GB' => 'Status messages',
                        'de-DE' => 'Status-Ausgaben',
                    ],
                ],
                'unordered' => [
                    'label' => [
                        'en-GB' => 'Misc',
                        'de-DE' => 'Sonstige',
                    ],
                ],
            ],
            'fields' => [
                'sw-color-brand-primary' => [
                    'name' => 'sw-color-brand-primary',
                    'label' => [
                        'en-GB' => 'Primary colour',
                        'de-DE' => 'Primärfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#ff00ff',
                    'editable' => true,
                    'block' => 'themeColors',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-brand-secondary' => [
                    'name' => 'sw-color-brand-secondary',
                    'label' => [
                        'en-GB' => 'Secondary colour',
                        'de-DE' => 'Sekundärfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#3d444d',
                    'editable' => true,
                    'block' => 'themeColors',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-success' => [
                    'name' => 'sw-color-success',
                    'label' => [
                        'en-GB' => 'Success',
                        'de-DE' => 'Erfolg',
                    ],
                    'type' => 'color',
                    'value' => '#3cc261',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-info' => [
                    'name' => 'sw-color-info',
                    'label' => [
                        'en-GB' => 'Information',
                        'de-DE' => 'Information',
                    ],
                    'type' => 'color',
                    'value' => '#26b6cf',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-warning' => [
                    'name' => 'sw-color-warning',
                    'label' => [
                        'en-GB' => 'Notice',
                        'de-DE' => 'Hinweis',
                    ],
                    'type' => 'color',
                    'value' => '#ffbd5d',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 300,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-danger' => [
                    'name' => 'sw-color-danger',
                    'label' => [
                        'en-GB' => 'Error',
                        'de-DE' => 'Fehler',
                    ],
                    'type' => 'color',
                    'value' => '#e52427',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 400,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-text-color' => [
                    'name' => 'sw-text-color',
                    'label' => [
                        'en-GB' => 'Text colour',
                        'de-DE' => 'Textfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#2b3136',
                    'editable' => true,
                    'block' => 'typography',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-border-color' => [
                    'name' => 'sw-border-color',
                    'label' => [
                        'en-GB' => 'Border',
                        'de-DE' => 'Rahmen',
                    ],
                    'type' => 'color',
                    'value' => '#798490',
                    'editable' => true,
                    'block' => 'themeColors',
                    'section' => null,
                    'order' => 300,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-background-color' => [
                    'label' => [
                        'en-GB' => 'Background',
                        'de-DE' => 'Hintergrund',
                    ],
                    'type' => 'color',
                    'value' => '#fff',
                    'editable' => true,
                    'block' => 'themeColors',
                    'order' => 400,
                    'name' => 'sw-background-color',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-price' => [
                    'name' => 'sw-color-price',
                    'label' => [
                        'en-GB' => 'Price',
                        'de-DE' => 'Preis',
                    ],
                    'type' => 'color',
                    'value' => '#2b3136',
                    'editable' => true,
                    'block' => 'eCommerce',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-buy-button' => [
                    'name' => 'sw-color-buy-button',
                    'label' => [
                        'en-GB' => 'Buy button',
                        'de-DE' => 'Kaufen-Button',
                    ],
                    'type' => 'color',
                    'value' => '#0b539b',
                    'editable' => true,
                    'block' => 'eCommerce',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-buy-button-text' => [
                    'label' => [
                        'en-GB' => 'Buy button text',
                        'de-DE' => 'Kaufen-Button Text',
                    ],
                    'type' => 'color',
                    'value' => '#fff',
                    'editable' => true,
                    'block' => 'eCommerce',
                    'order' => 300,
                    'name' => 'sw-color-buy-button-text',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-font-family-base' => [
                    'name' => 'sw-font-family-base',
                    'label' => [
                        'en-GB' => 'Fonttype text',
                        'de-DE' => 'Schriftart Text',
                    ],
                    'type' => 'fontFamily',
                    'value' => '\'Inter\', sans-serif',
                    'editable' => true,
                    'block' => 'typography',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-font-family-headline' => [
                    'name' => 'sw-font-family-headline',
                    'label' => [
                        'en-GB' => 'Fonttype headline',
                        'de-DE' => 'Schriftart Überschrift',
                    ],
                    'type' => 'fontFamily',
                    'value' => '\'Inter\', sans-serif',
                    'editable' => true,
                    'block' => 'typography',
                    'section' => null,
                    'order' => 300,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-headline-color' => [
                    'label' => [
                        'en-GB' => 'Headline colour',
                        'de-DE' => 'Überschriftfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#2b3136',
                    'editable' => true,
                    'block' => 'typography',
                    'order' => 400,
                    'name' => 'sw-headline-color',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-logo-desktop' => [
                    'label' => [
                        'en-GB' => 'Desktop',
                        'de-DE' => 'Desktop',
                    ],
                    'helpText' => [
                        'en-GB' => 'Displayed on viewport sizes above 991px and as a fallback on smaller viewports, if no other logo is set.',
                        'de-DE' => 'Wird bei Ansichten über 991px angezeigt und als Alternative bei kleineren Auflösungen, für die kein anderes Logo eingestellt ist.',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/demostore-logo.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 100,
                    'name' => 'sw-logo-desktop',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => true,
                ],
                'sw-logo-tablet' => [
                    'label' => [
                        'en-GB' => 'Tablet',
                        'de-DE' => 'Tablet',
                    ],
                    'helpText' => [
                        'en-GB' => 'Displayed between a viewport of 767px to 991px',
                        'de-DE' => 'Wird zwischen einem viewport von 767px bis 991px angezeigt',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/demostore-logo.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 200,
                    'name' => 'sw-logo-tablet',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => true,
                ],
                'sw-logo-mobile' => [
                    'label' => [
                        'en-GB' => 'Mobile',
                        'de-DE' => 'Mobil',
                    ],
                    'helpText' => [
                        'en-GB' => 'Displayed up to a viewport of 767px',
                        'de-DE' => 'Wird bis zu einem Viewport von 767px angezeigt',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/demostore-logo.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 300,
                    'name' => 'sw-logo-mobile',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => true,
                ],
                'sw-logo-share' => [
                    'label' => [
                        'en-GB' => 'App & share icon',
                        'de-DE' => 'App- & Share-Icon',
                    ],
                    'type' => 'media',
                    'value' => '',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 400,
                    'name' => 'sw-logo-share',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-logo-favicon' => [
                    'label' => [
                        'en-GB' => 'Favicon',
                        'de-DE' => 'Favicon',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/favicon.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 500,
                    'name' => 'sw-logo-favicon',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
            ],
        ];

        $config += [
            'currentFields' => [
                'sw-color-brand-primary' => [
                    'value' => '#ff00ff',
                    'isInherited' => false,
                ],
                'sw-color-brand-secondary' => [
                    'value' => null,
                    'isInherited' => false,
                ],
                'sw-border-color' => [
                    'value' => '#798490',
                    'isInherited' => false,
                ],
                'sw-background-color' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-color-success' => [
                    'value' => '#3cc261',
                    'isInherited' => false,
                ],
                'sw-color-info' => [
                    'value' => '#26b6cf',
                    'isInherited' => false,
                ],
                'sw-color-warning' => [
                    'value' => '#ffbd5d',
                    'isInherited' => false,
                ],
                'sw-color-danger' => [
                    'value' => '#e52427',
                    'isInherited' => false,
                ],
                'sw-font-family-base' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-text-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-font-family-headline' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-headline-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-price' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-buy-button' => [
                    'value' => '#0b539b',
                    'isInherited' => false,
                ],
                'sw-color-buy-button-text' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-logo-desktop' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-tablet' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-mobile' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-share' => [
                    'value' => '',
                    'isInherited' => false,
                ],
                'sw-logo-favicon' => [
                    'value' => $faviconId,
                    'isInherited' => false,
                ],
            ],
            'baseThemeFields' => [
                'sw-color-brand-primary' => [
                    'value' => '#0b539b',
                    'isInherited' => false,
                ],
                'sw-color-brand-secondary' => [
                    'value' => '#3d444d',
                    'isInherited' => false,
                ],
                'sw-border-color' => [
                    'value' => '#798490',
                    'isInherited' => false,
                ],
                'sw-background-color' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-color-success' => [
                    'value' => '#3cc261',
                    'isInherited' => false,
                ],
                'sw-color-info' => [
                    'value' => '#26b6cf',
                    'isInherited' => false,
                ],
                'sw-color-warning' => [
                    'value' => '#ffbd5d',
                    'isInherited' => false,
                ],
                'sw-color-danger' => [
                    'value' => '#e52427',
                    'isInherited' => false,
                ],
                'sw-font-family-base' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-text-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-font-family-headline' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-headline-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-price' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-buy-button' => [
                    'value' => '#0b539b',
                    'isInherited' => false,
                ],
                'sw-color-buy-button-text' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-logo-desktop' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-tablet' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-mobile' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-share' => [
                    'value' => null,
                    'isInherited' => false,
                ],
                'sw-logo-favicon' => [
                    'value' => $faviconId,
                    'isInherited' => false,
                ],
            ],
        ];

        return $config;
    }

    /**
     * @return array<string, mixed>
     */
    public static function getThemeInheritedBlankConfig(string $faviconId, string $demostoreLogoId): array
    {
        $config = [
            'blocks' => [
                'themeColors' => [
                    'label' => [
                        'en-GB' => 'Theme colours',
                        'de-DE' => 'Theme-Farben',
                    ],
                ],
                'typography' => [
                    'label' => [
                        'en-GB' => 'Typography',
                        'de-DE' => 'Typografie',
                    ],
                ],
                'media' => [
                    'label' => [
                        'en-GB' => 'Media',
                        'de-DE' => 'Medien',
                    ],
                ],
                'eCommerce' => [
                    'label' => [
                        'en-GB' => 'E-Commerce',
                        'de-DE' => 'E-Commerce',
                    ],
                ],
                'statusColors' => [
                    'label' => [
                        'en-GB' => 'Status messages',
                        'de-DE' => 'Status-Ausgaben',
                    ],
                ],
                'unordered' => [
                    'label' => [
                        'en-GB' => 'Misc',
                        'de-DE' => 'Sonstige',
                    ],
                ],
            ],
            'fields' => [
                'sw-color-brand-primary' => [
                    'name' => 'sw-color-brand-primary',
                    'label' => [
                        'en-GB' => 'Primary colour',
                        'de-DE' => 'Primärfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#ff00ff',
                    'editable' => true,
                    'block' => 'themeColors',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-brand-secondary' => [
                    'name' => 'sw-color-brand-secondary',
                    'label' => [
                        'en-GB' => 'Secondary colour',
                        'de-DE' => 'Sekundärfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#3d444d',
                    'editable' => true,
                    'block' => 'themeColors',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-success' => [
                    'name' => 'sw-color-success',
                    'label' => [
                        'en-GB' => 'Success',
                        'de-DE' => 'Erfolg',
                    ],
                    'type' => 'color',
                    'value' => '#3cc261',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-info' => [
                    'name' => 'sw-color-info',
                    'label' => [
                        'en-GB' => 'Information',
                        'de-DE' => 'Information',
                    ],
                    'type' => 'color',
                    'value' => '#26b6cf',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-warning' => [
                    'name' => 'sw-color-warning',
                    'label' => [
                        'en-GB' => 'Notice',
                        'de-DE' => 'Hinweis',
                    ],
                    'type' => 'color',
                    'value' => '#ffbd5d',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 300,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-danger' => [
                    'name' => 'sw-color-danger',
                    'label' => [
                        'en-GB' => 'Error',
                        'de-DE' => 'Fehler',
                    ],
                    'type' => 'color',
                    'value' => '#e52427',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 400,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-text-color' => [
                    'name' => 'sw-text-color',
                    'label' => [
                        'en-GB' => 'Text colour',
                        'de-DE' => 'Textfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#2b3136',
                    'editable' => true,
                    'block' => 'typography',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-border-color' => [
                    'name' => 'sw-border-color',
                    'label' => [
                        'en-GB' => 'Border',
                        'de-DE' => 'Rahmen',
                    ],
                    'type' => 'color',
                    'value' => '#798490',
                    'editable' => true,
                    'block' => 'themeColors',
                    'section' => null,
                    'order' => 300,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-background-color' => [
                    'label' => [
                        'en-GB' => 'Background',
                        'de-DE' => 'Hintergrund',
                    ],
                    'type' => 'color',
                    'value' => '#fff',
                    'editable' => true,
                    'block' => 'themeColors',
                    'order' => 400,
                    'name' => 'sw-background-color',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-price' => [
                    'name' => 'sw-color-price',
                    'label' => [
                        'en-GB' => 'Price',
                        'de-DE' => 'Preis',
                    ],
                    'type' => 'color',
                    'value' => '#2b3136',
                    'editable' => true,
                    'block' => 'eCommerce',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-buy-button' => [
                    'name' => 'sw-color-buy-button',
                    'label' => [
                        'en-GB' => 'Buy button',
                        'de-DE' => 'Kaufen-Button',
                    ],
                    'type' => 'color',
                    'value' => '#0b539b',
                    'editable' => true,
                    'block' => 'eCommerce',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-buy-button-text' => [
                    'label' => [
                        'en-GB' => 'Buy button text',
                        'de-DE' => 'Kaufen-Button Text',
                    ],
                    'type' => 'color',
                    'value' => '#fff',
                    'editable' => true,
                    'block' => 'eCommerce',
                    'order' => 300,
                    'name' => 'sw-color-buy-button-text',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-font-family-base' => [
                    'name' => 'sw-font-family-base',
                    'label' => [
                        'en-GB' => 'Fonttype text',
                        'de-DE' => 'Schriftart Text',
                    ],
                    'type' => 'fontFamily',
                    'value' => '\'Inter\', sans-serif',
                    'editable' => true,
                    'block' => 'typography',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-font-family-headline' => [
                    'name' => 'sw-font-family-headline',
                    'label' => [
                        'en-GB' => 'Fonttype headline',
                        'de-DE' => 'Schriftart Überschrift',
                    ],
                    'type' => 'fontFamily',
                    'value' => '\'Inter\', sans-serif',
                    'editable' => true,
                    'block' => 'typography',
                    'section' => null,
                    'order' => 300,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-headline-color' => [
                    'label' => [
                        'en-GB' => 'Headline colour',
                        'de-DE' => 'Überschriftfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#2b3136',
                    'editable' => true,
                    'block' => 'typography',
                    'order' => 400,
                    'name' => 'sw-headline-color',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-logo-desktop' => [
                    'label' => [
                        'en-GB' => 'Desktop',
                        'de-DE' => 'Desktop',
                    ],
                    'helpText' => [
                        'en-GB' => 'Displayed on viewport sizes above 991px and as a fallback on smaller viewports, if no other logo is set.',
                        'de-DE' => 'Wird bei Ansichten über 991px angezeigt und als Alternative bei kleineren Auflösungen, für die kein anderes Logo eingestellt ist.',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/demostore-logo.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 100,
                    'name' => 'sw-logo-desktop',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => true,
                ],
                'sw-logo-tablet' => [
                    'label' => [
                        'en-GB' => 'Tablet',
                        'de-DE' => 'Tablet',
                    ],
                    'helpText' => [
                        'en-GB' => 'Displayed between a viewport of 767px to 991px',
                        'de-DE' => 'Wird zwischen einem viewport von 767px bis 991px angezeigt',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/demostore-logo.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 200,
                    'name' => 'sw-logo-tablet',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => true,
                ],
                'sw-logo-mobile' => [
                    'label' => [
                        'en-GB' => 'Mobile',
                        'de-DE' => 'Mobil',
                    ],
                    'helpText' => [
                        'en-GB' => 'Displayed up to a viewport of 767px',
                        'de-DE' => 'Wird bis zu einem Viewport von 767px angezeigt',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/demostore-logo.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 300,
                    'name' => 'sw-logo-mobile',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => true,
                ],
                'sw-logo-share' => [
                    'label' => [
                        'en-GB' => 'App & share icon',
                        'de-DE' => 'App- & Share-Icon',
                    ],
                    'type' => 'media',
                    'value' => '',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 400,
                    'name' => 'sw-logo-share',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-logo-favicon' => [
                    'label' => [
                        'en-GB' => 'Favicon',
                        'de-DE' => 'Favicon',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/favicon.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 500,
                    'name' => 'sw-logo-favicon',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
            ],
        ];

        $config += [
            'currentFields' => [
                'sw-color-brand-primary' => [
                    'value' => '#ff00ff',
                    'isInherited' => true,
                ],
                'sw-color-brand-secondary' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-border-color' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-background-color' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-color-success' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-color-info' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-color-warning' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-color-danger' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-font-family-base' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-text-color' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-font-family-headline' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-headline-color' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-color-price' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-color-buy-button' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-color-buy-button-text' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-logo-desktop' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-logo-tablet' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-logo-mobile' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-logo-share' => [
                    'value' => null,
                    'isInherited' => true,
                ],
                'sw-logo-favicon' => [
                    'value' => null,
                    'isInherited' => true,
                ],
            ],
            'baseThemeFields' => [
                'sw-color-brand-primary' => [
                    'value' => '#ff00ff',
                    'isInherited' => false,
                ],
                'sw-color-brand-secondary' => [
                    'value' => '#3d444d',
                    'isInherited' => false,
                ],
                'sw-border-color' => [
                    'value' => '#798490',
                    'isInherited' => false,
                ],
                'sw-background-color' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-color-success' => [
                    'value' => '#3cc261',
                    'isInherited' => false,
                ],
                'sw-color-info' => [
                    'value' => '#26b6cf',
                    'isInherited' => false,
                ],
                'sw-color-warning' => [
                    'value' => '#ffbd5d',
                    'isInherited' => false,
                ],
                'sw-color-danger' => [
                    'value' => '#e52427',
                    'isInherited' => false,
                ],
                'sw-font-family-base' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-text-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-font-family-headline' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-headline-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-price' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-buy-button' => [
                    'value' => '#0b539b',
                    'isInherited' => false,
                ],
                'sw-color-buy-button-text' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-logo-desktop' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-tablet' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-mobile' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-share' => [
                    'value' => '',
                    'isInherited' => false,
                ],
                'sw-logo-favicon' => [
                    'value' => $faviconId,
                    'isInherited' => false,
                ],
            ],
        ];

        return $config;
    }

    /**
     * @return array<string, mixed>
     */
    public static function getThemeConfig(string $faviconId, string $demostoreLogoId): array
    {
        return [
            'blocks' => [
                'themeColors' => [
                    'label' => [
                        'en-GB' => 'Theme colours',
                        'de-DE' => 'Theme-Farben',
                    ],
                ],
                'typography' => [
                    'label' => [
                        'en-GB' => 'Typography',
                        'de-DE' => 'Typografie',
                    ],
                ],
                'media' => [
                    'label' => [
                        'en-GB' => 'Media',
                        'de-DE' => 'Medien',
                    ],
                ],
                'eCommerce' => [
                    'label' => [
                        'en-GB' => 'E-Commerce',
                        'de-DE' => 'E-Commerce',
                    ],
                ],
                'statusColors' => [
                    'label' => [
                        'en-GB' => 'Status messages',
                        'de-DE' => 'Status-Ausgaben',
                    ],
                ],
                'unordered' => [
                    'label' => [
                        'en-GB' => 'Misc',
                        'de-DE' => 'Sonstige',
                    ],
                ],
            ],
            'fields' => [
                'sw-color-brand-primary' => [
                    'name' => 'sw-color-brand-primary',
                    'label' => [
                        'en-GB' => 'Primary colour',
                        'de-DE' => 'Primärfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#0b539b',
                    'editable' => true,
                    'block' => 'themeColors',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-brand-secondary' => [
                    'name' => 'sw-color-brand-secondary',
                    'label' => [
                        'en-GB' => 'Secondary colour',
                        'de-DE' => 'Sekundärfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#3d444d',
                    'editable' => true,
                    'block' => 'themeColors',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-success' => [
                    'name' => 'sw-color-success',
                    'label' => [
                        'en-GB' => 'Success',
                        'de-DE' => 'Erfolg',
                    ],
                    'type' => 'color',
                    'value' => '#3cc261',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-info' => [
                    'name' => 'sw-color-info',
                    'label' => [
                        'en-GB' => 'Information',
                        'de-DE' => 'Information',
                    ],
                    'type' => 'color',
                    'value' => '#26b6cf',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-warning' => [
                    'name' => 'sw-color-warning',
                    'label' => [
                        'en-GB' => 'Notice',
                        'de-DE' => 'Hinweis',
                    ],
                    'type' => 'color',
                    'value' => '#ffbd5d',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 300,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-danger' => [
                    'name' => 'sw-color-danger',
                    'label' => [
                        'en-GB' => 'Error',
                        'de-DE' => 'Fehler',
                    ],
                    'type' => 'color',
                    'value' => '#e52427',
                    'editable' => true,
                    'block' => 'statusColors',
                    'section' => null,
                    'order' => 400,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-text-color' => [
                    'name' => 'sw-text-color',
                    'label' => [
                        'en-GB' => 'Text colour',
                        'de-DE' => 'Textfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#2b3136',
                    'editable' => true,
                    'block' => 'typography',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-border-color' => [
                    'name' => 'sw-border-color',
                    'label' => [
                        'en-GB' => 'Border',
                        'de-DE' => 'Rahmen',
                    ],
                    'type' => 'color',
                    'value' => '#798490',
                    'editable' => true,
                    'block' => 'themeColors',
                    'section' => null,
                    'order' => 300,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-background-color' => [
                    'label' => [
                        'en-GB' => 'Background',
                        'de-DE' => 'Hintergrund',
                    ],
                    'type' => 'color',
                    'value' => '#fff',
                    'editable' => true,
                    'block' => 'themeColors',
                    'order' => 400,
                    'name' => 'sw-background-color',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'helpText' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-price' => [
                    'name' => 'sw-color-price',
                    'label' => [
                        'en-GB' => 'Price',
                        'de-DE' => 'Preis',
                    ],
                    'type' => 'color',
                    'value' => '#2b3136',
                    'editable' => true,
                    'block' => 'eCommerce',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-buy-button' => [
                    'name' => 'sw-color-buy-button',
                    'label' => [
                        'en-GB' => 'Buy button',
                        'de-DE' => 'Kaufen-Button',
                    ],
                    'type' => 'color',
                    'value' => '#0b539b',
                    'editable' => true,
                    'block' => 'eCommerce',
                    'section' => null,
                    'order' => 200,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-color-buy-button-text' => [
                    'label' => [
                        'en-GB' => 'Buy button text',
                        'de-DE' => 'Kaufen-Button Text',
                    ],
                    'type' => 'color',
                    'value' => '#fff',
                    'editable' => true,
                    'block' => 'eCommerce',
                    'order' => 300,
                    'name' => 'sw-color-buy-button-text',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-font-family-base' => [
                    'name' => 'sw-font-family-base',
                    'label' => [
                        'en-GB' => 'Fonttype text',
                        'de-DE' => 'Schriftart Text',
                    ],
                    'type' => 'fontFamily',
                    'value' => '\'Inter\', sans-serif',
                    'editable' => true,
                    'block' => 'typography',
                    'section' => null,
                    'order' => 100,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-font-family-headline' => [
                    'name' => 'sw-font-family-headline',
                    'label' => [
                        'en-GB' => 'Fonttype headline',
                        'de-DE' => 'Schriftart Überschrift',
                    ],
                    'type' => 'fontFamily',
                    'value' => '\'Inter\', sans-serif',
                    'editable' => true,
                    'block' => 'typography',
                    'section' => null,
                    'order' => 300,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-headline-color' => [
                    'label' => [
                        'en-GB' => 'Headline colour',
                        'de-DE' => 'Überschriftfarbe',
                    ],
                    'type' => 'color',
                    'value' => '#2b3136',
                    'editable' => true,
                    'block' => 'typography',
                    'order' => 400,
                    'name' => 'sw-headline-color',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-logo-desktop' => [
                    'label' => [
                        'en-GB' => 'Desktop',
                        'de-DE' => 'Desktop',
                    ],
                    'helpText' => [
                        'en-GB' => 'Displayed on viewport sizes above 991px and as a fallback on smaller viewports, if no other logo is set.',
                        'de-DE' => 'Wird bei Ansichten über 991px angezeigt und als Alternative bei kleineren Auflösungen, für die kein anderes Logo eingestellt ist.',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/demostore-logo.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 100,
                    'name' => 'sw-logo-desktop',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => true,
                ],
                'sw-logo-tablet' => [
                    'label' => [
                        'en-GB' => 'Tablet',
                        'de-DE' => 'Tablet',
                    ],
                    'helpText' => [
                        'en-GB' => 'Displayed between a viewport of 767px to 991px',
                        'de-DE' => 'Wird zwischen einem viewport von 767px bis 991px angezeigt',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/demostore-logo.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 200,
                    'name' => 'sw-logo-tablet',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => true,
                ],
                'sw-logo-mobile' => [
                    'label' => [
                        'en-GB' => 'Mobile',
                        'de-DE' => 'Mobil',
                    ],
                    'helpText' => [
                        'en-GB' => 'Displayed up to a viewport of 767px',
                        'de-DE' => 'Wird bis zu einem Viewport von 767px angezeigt',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/demostore-logo.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 300,
                    'name' => 'sw-logo-mobile',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => true,
                ],
                'sw-logo-share' => [
                    'label' => [
                        'en-GB' => 'App & share icon',
                        'de-DE' => 'App- & Share-Icon',
                    ],
                    'type' => 'media',
                    'value' => '',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 400,
                    'name' => 'sw-logo-share',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
                'sw-logo-favicon' => [
                    'label' => [
                        'en-GB' => 'Favicon',
                        'de-DE' => 'Favicon',
                    ],
                    'type' => 'media',
                    'value' => 'dist/assets/logo/favicon.png',
                    'editable' => true,
                    'block' => 'media',
                    'order' => 500,
                    'name' => 'sw-logo-favicon',
                    'section' => null,
                    'sectionOrder' => null,
                    'blockOrder' => null,
                    'extensions' => [],
                    'helpText' => null,
                    'custom' => null,
                    'tab' => null,
                    'tabOrder' => null,
                    'scss' => null,
                    'fullWidth' => null,
                ],
            ],
            'currentFields' => [
                'sw-color-brand-primary' => [
                    'value' => '#0b539b',
                    'isInherited' => false,
                ],
                'sw-color-brand-secondary' => [
                    'value' => '#3d444d',
                    'isInherited' => false,
                ],
                'sw-border-color' => [
                    'value' => '#798490',
                    'isInherited' => false,
                ],
                'sw-background-color' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-color-success' => [
                    'value' => '#3cc261',
                    'isInherited' => false,
                ],
                'sw-color-info' => [
                    'value' => '#26b6cf',
                    'isInherited' => false,
                ],
                'sw-color-warning' => [
                    'value' => '#ffbd5d',
                    'isInherited' => false,
                ],
                'sw-color-danger' => [
                    'value' => '#e52427',
                    'isInherited' => false,
                ],
                'sw-font-family-base' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-text-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-font-family-headline' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-headline-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-price' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-buy-button' => [
                    'value' => '#0b539b',
                    'isInherited' => false,
                ],
                'sw-color-buy-button-text' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-logo-desktop' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-tablet' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-mobile' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-share' => [
                    'value' => '',
                    'isInherited' => false,
                ],
                'sw-logo-favicon' => [
                    'value' => $faviconId,
                    'isInherited' => false,
                ],
            ],
            'baseThemeFields' => [
                'sw-color-brand-primary' => [
                    'value' => '#0b539b',
                    'isInherited' => false,
                ],
                'sw-color-brand-secondary' => [
                    'value' => '#3d444d',
                    'isInherited' => false,
                ],
                'sw-border-color' => [
                    'value' => '#798490',
                    'isInherited' => false,
                ],
                'sw-background-color' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-color-success' => [
                    'value' => '#3cc261',
                    'isInherited' => false,
                ],
                'sw-color-info' => [
                    'value' => '#26b6cf',
                    'isInherited' => false,
                ],
                'sw-color-warning' => [
                    'value' => '#ffbd5d',
                    'isInherited' => false,
                ],
                'sw-color-danger' => [
                    'value' => '#e52427',
                    'isInherited' => false,
                ],
                'sw-font-family-base' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-text-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-font-family-headline' => [
                    'value' => '\'Inter\', sans-serif',
                    'isInherited' => false,
                ],
                'sw-headline-color' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-price' => [
                    'value' => '#2b3136',
                    'isInherited' => false,
                ],
                'sw-color-buy-button' => [
                    'value' => '#0b539b',
                    'isInherited' => false,
                ],
                'sw-color-buy-button-text' => [
                    'value' => '#fff',
                    'isInherited' => false,
                ],
                'sw-logo-desktop' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-tablet' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-mobile' => [
                    'value' => $demostoreLogoId,
                    'isInherited' => false,
                ],
                'sw-logo-share' => [
                    'value' => null,
                    'isInherited' => false,
                ],
                'sw-logo-favicon' => [
                    'value' => $faviconId,
                    'isInherited' => false,
                ],
            ],
        ];
    }
}
