/**
 * @package buyers-experience
 */
import { mount } from '@vue/test-utils_v3';

async function createWrapper() {
    return mount(await wrapTestComponent('sw-cms-section-actions', {
        sync: true,
    }), {
        props: {
            section: {},
        },
        global: {
            stubs: {
                'sw-icon': true,
            },
        },
    });
}

describe('module/sw-cms/component/sw-cms-section-actions', () => {
    beforeAll(() => {
        Shopware.State.registerModule('cmsPageState', {
            namespaced: true,
            state: {
                selectedSection: {},
            },
            actions: {
                setSection: () => {},
            },
        });
    });

    it('should be a Vue.js component', async () => {
        const wrapper = await createWrapper();

        expect(wrapper.vm).toBeTruthy();
    });

    it('should contain disabled styling', async () => {
        const wrapper = await createWrapper();
        await wrapper.setProps({
            disabled: true,
        });

        expect(wrapper.classes()).toContain('is--disabled');
    });

    it('should not contain disabled styling', async () => {
        const wrapper = await createWrapper();

        expect(wrapper.classes()).not.toContain('is--disabled');
    });
});
