<?php declare(strict_types=1);

namespace Shopware\Storefront\Page\Address\Detail;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\PageLoadedEvent;
use Symfony\Component\HttpFoundation\Request;

class AddressDetailPageLoadedEvent extends PageLoadedEvent
{
    /**
     * @var AddressDetailPage
     */
    protected $page;

    public function __construct(AddressDetailPage $page, SalesChannelContext $salesChannelContext, Request $request)
    {
        $this->page = $page;
        parent::__construct($salesChannelContext, $request);
    }

    public function getPage(): AddressDetailPage
    {
        return $this->page;
    }
}
