<?php declare(strict_types=1);

namespace Shopware\Storefront\Page\Account\RecoverPassword;

use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Page\PageLoadedEvent;
use Symfony\Component\HttpFoundation\Request;

class AccountRecoverPasswordPageLoadedEvent extends PageLoadedEvent
{
    /**
     * @var AccountRecoverPasswordPage
     */
    protected $page;

    public function __construct(AccountRecoverPasswordPage $page, SalesChannelContext $salesChannelContext, Request $request)
    {
        $this->page = $page;
        parent::__construct($salesChannelContext, $request);
    }

    public function getPage(): AccountRecoverPasswordPage
    {
        return $this->page;
    }
}
