<?php declare(strict_types=1);

namespace Shopware\Core\System\CustomEntity\Xml\Field;

use Shopware\Core\System\CustomEntity\Xml\Field\Traits\RequiredTrait;
use Shopware\Core\System\CustomEntity\Xml\Field\Traits\TranslatableTrait;

class TextField extends Field
{
    use TranslatableTrait;
    use RequiredTrait;

    protected bool $allowHtml = false;

    protected string $type = 'text';

    /**
     * @internal
     */
    public static function fromXml(\DOMElement $element): Field
    {
        return new self(self::parse($element));
    }

    public function allowHtml(): bool
    {
        return $this->allowHtml;
    }
}
