<?php declare(strict_types=1);

namespace Shopware\Core\Framework\Validation\Constraint;

use Shopware\Core\Framework\Uuid\Uuid;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints\Type;
use Symfony\Component\Validator\ConstraintValidator;
use Symfony\Component\Validator\Exception\UnexpectedTypeException;

/**
 * @package core
 */
class ArrayOfTypeValidator extends ConstraintValidator
{
    public function validate($value, Constraint $constraint): void
    {
        if (!$constraint instanceof ArrayOfType) {
            throw new UnexpectedTypeException($constraint, Uuid::class);
        }

        // custom constraints should ignore null and empty values to allow
        // other constraints (NotBlank, NotNull, etc.) take care of that
        if ($value === null) {
            return;
        }

        if (!\is_array($value)) {
            $this->context->buildViolation($constraint::INVALID_TYPE_MESSAGE)
                ->addViolation();

            return;
        }

        foreach ($value as $item) {
            $type = mb_strtolower($constraint->type);
            $type = $type === 'boolean' ? 'bool' : $constraint->type;
            $isFunction = 'is_' . $type;
            $ctypeFunction = 'ctype_' . $type;

            if (\function_exists($isFunction) && $isFunction($item)) {
                continue;
            }

            if (\function_exists($ctypeFunction) && $ctypeFunction($item)) {
                continue;
            }

            if ($item instanceof $constraint->type) {
                continue;
            }

            if (\is_array($item)) {
                $item = print_r($item, true);
            }

            $this->context->buildViolation($constraint::INVALID_MESSAGE)
                ->setCode(Type::INVALID_TYPE_ERROR)
                ->setParameter('{{ type }}', $constraint->type)
                ->setParameter('{{ value }}', (string) $item)
                ->addViolation();
        }
    }
}
