<?php declare(strict_types=1);

namespace Shopware\Core\Content\Media\TypeDetector;

use Shopware\Core\Content\Media\File\MediaFile;
use Shopware\Core\Content\Media\MediaType\AudioType;
use Shopware\Core\Content\Media\MediaType\BinaryType;
use Shopware\Core\Content\Media\MediaType\ImageType;
use Shopware\Core\Content\Media\MediaType\MediaType;
use Shopware\Core\Content\Media\MediaType\VideoType;

class DefaultTypeDetector implements TypeDetectorInterface
{
    public function detect(MediaFile $mediaFile, ?MediaType $previouslyDetectedType): ?MediaType
    {
        if ($previouslyDetectedType !== null) {
            return $previouslyDetectedType;
        }

        /** @var array<string>|false $mime */
        $mime = explode('/', $mediaFile->getMimeType());

        if ($mime === false) {
            return new BinaryType();
        }

        switch ($mime[0]) {
            case 'image':
                return new ImageType();
            case 'video':
                return new VideoType();
            case 'audio':
                return new AudioType();
            default:
                return new BinaryType();
        }
    }
}
