<?php declare(strict_types=1);

namespace Cart\LineItem\Group\RuleMatcher;

use PHPUnit\Framework\TestCase;
use Shopware\Core\Checkout\Cart\Cart;
use Shopware\Core\Checkout\Cart\LineItem\Group\AbstractProductLineItemProvider;
use Shopware\Core\Checkout\Cart\LineItem\Group\ProductLineItemProvider;
use Shopware\Core\Checkout\Cart\LineItem\LineItem;
use Shopware\Core\Checkout\Cart\LineItem\LineItemCollection;
use Shopware\Core\Checkout\Test\Cart\LineItem\Group\Helpers\Traits\LineItemTestFixtureBehaviour;
use Shopware\Core\Framework\Plugin\Exception\DecorationPatternException;
use Shopware\Core\Framework\Uuid\Uuid;

/**
 * @internal
 */
class ProductLineItemProviderTest extends TestCase
{
    use LineItemTestFixtureBehaviour;

    private AbstractProductLineItemProvider $provider;

    public function setUp(): void
    {
        $this->provider = new ProductLineItemProvider();
    }

    public function testIsMatchingReturnProductLineItem(): void
    {
        $cart = $this->getCart();

        static::assertEquals(4, $cart->getLineItems()->count());

        $lineItems = $this->provider->getProducts($cart);

        static::assertEquals(1, $lineItems->count());
        static::assertEquals(LineItem::PRODUCT_LINE_ITEM_TYPE, $lineItems->first()->getType());
    }

    public function testItThrowsDecorationPatternException(): void
    {
        static::expectException(DecorationPatternException::class);

        $this->provider->getDecorated();
    }

    private function getCart(): Cart
    {
        $items = [
            new LineItem(Uuid::randomHex(), LineItem::PRODUCT_LINE_ITEM_TYPE),
            new LineItem(Uuid::randomHex(), LineItem::PROMOTION_LINE_ITEM_TYPE),
            new LineItem(Uuid::randomHex(), LineItem::CREDIT_LINE_ITEM_TYPE),
            new LineItem(Uuid::randomHex(), LineItem::CUSTOM_LINE_ITEM_TYPE),
        ];

        $cart = new Cart('test', 'token');
        $cart->addLineItems(new LineItemCollection($items));

        return $cart;
    }
}
