<?php declare(strict_types=1);

namespace Shopware\Core\Checkout\Cart;

use Shopware\Core\Checkout\Cart\Error\ErrorCollection;
use Shopware\Core\System\SalesChannel\SalesChannelContext;

class Validator
{
    /**
     * @var CartValidatorInterface[]
     */
    private $validators;

    /**
     * @internal
     */
    public function __construct(iterable $validators)
    {
        $this->validators = $validators;
    }

    public function validate(Cart $cart, SalesChannelContext $context): array
    {
        $errors = new ErrorCollection();
        foreach ($this->validators as $validator) {
            $validator->validate($cart, $errors, $context);
        }

        return array_values($errors->getElements());
    }
}
