<?php declare(strict_types=1);

namespace Shopware\Core\Checkout\Cart\Exception;

use Shopware\Core\Framework\Feature;
use Shopware\Core\Framework\ShopwareHttpException;
use Symfony\Component\HttpFoundation\Response;

/**
 * @deprecated tag:v6.5.0 - Will be removed, use \Shopware\Core\Checkout\Cart\CartException::invalidPayload instead
 */
class InvalidPayloadException extends ShopwareHttpException
{
    public function __construct(string $id, string $lineItemId)
    {
        Feature::triggerDeprecationOrThrow(
            'v6.5.0.0',
            Feature::deprecatedMethodMessage(__CLASS__, __METHOD__, 'v6.5.0.0')
        );
        parent::__construct(
            'Unable to save payload with id `{{ id }}` on line item `{{ lineItemId }}`. Only scalar data types are allowed.',
            ['id' => $id, 'lineItemId' => $lineItemId]
        );
    }

    public function getErrorCode(): string
    {
        Feature::triggerDeprecationOrThrow(
            'v6.5.0.0',
            Feature::deprecatedMethodMessage(__CLASS__, __METHOD__, 'v6.5.0.0')
        );

        return 'CHECKOUT__CART_INVALID_LINEITEM_PAYLOAD';
    }

    public function getStatusCode(): int
    {
        Feature::triggerDeprecationOrThrow(
            'v6.5.0.0',
            Feature::deprecatedMethodMessage(__CLASS__, __METHOD__, 'v6.5.0.0')
        );

        return Response::HTTP_BAD_REQUEST;
    }
}
