import { createLocalVue, shallowMount } from '@vue/test-utils';
import 'src/app/component/media/sw-media-upload-v2';
import 'src/app/component/media/sw-media-compact-upload-v2';

describe('src/app/component/media/sw-media-compact-upload-v2', () => {
    let wrapper;

    beforeEach(async () => {
        const localVue = createLocalVue();
        localVue.directive('droppable', {});

        wrapper = shallowMount(await Shopware.Component.build('sw-media-compact-upload-v2'), {
            localVue,
            stubs: {
                'sw-context-button': true,
                'sw-context-menu-item': true,
                'sw-icon': true,
                'sw-button': true,
                'sw-media-url-form': true
            },
            provide: {
                repositoryFactory: {},
                configService: {
                    getConfig: () => Promise.resolve({ settings: { enableUrlFeature: false } }),
                },
                mediaService: {
                    addListener: () => {},
                    removeByTag: () => {},
                    removeListener: () => {},
                }
            },
            propsData: {
                uploadTag: 'my-upload'
            }
        });
    });

    it('should be a Vue.js component', async () => {
        expect(wrapper.vm).toBeTruthy();
    });

    it('should contain the default accept value', async () => {
        const fileInput = wrapper.find('.sw-media-upload-v2__file-input');

        expect(fileInput.attributes().accept).toBe('image/*');
    });

    it('should contain "application/pdf" value', async () => {
        await wrapper.setProps({
            fileAccept: 'application/pdf'
        });
        const fileInput = wrapper.find('.sw-media-upload-v2__file-input');

        expect(fileInput.attributes().accept).toBe('application/pdf');
    });

    it('should contain url upload form when input type is url-upload', async () => {
        await wrapper.setData({
            inputType: 'file-upload'
        });

        let urlForm = wrapper.find('.sw-media-upload-v2__url-form');
        let uploadBtn = wrapper.find('.sw-media-upload-v2__button.upload');

        expect(urlForm.exists()).toBeFalsy();
        expect(uploadBtn.exists()).toBeTruthy();

        await wrapper.setData({
            inputType: 'url-upload'
        });

        urlForm = wrapper.find('.sw-media-upload-v2__url-form');
        uploadBtn = wrapper.find('.sw-media-upload-v2__button.upload');

        expect(urlForm.exists()).toBeTruthy();
        expect(uploadBtn.exists()).toBeFalsy();
    });
});
