<?php

namespace ContainerCobjYYK;

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/*
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class Shopware_Core_KernelProdContainer extends Container
{
    protected $containerDir;
    protected $targetDir;
    protected $parameters = [];
    private $buildParameters;
    protected $getService;

    public function __construct(array $buildParameters = [], $containerDir = __DIR__)
    {
        $this->getService = \Closure::fromCallable([$this, 'getService']);
        $this->buildParameters = $buildParameters;
        $this->containerDir = $containerDir;
        $this->targetDir = \dirname($containerDir);
        $this->parameters = $this->getDefaultParameters();

        $this->services = $this->privates = [];
        $this->syntheticIds = [
            'kernel' => true,
        ];
        $this->methodMap = [
            '.container.private.cache_clearer' => 'get_Container_Private_CacheClearerService',
            '.container.private.filesystem' => 'get_Container_Private_FilesystemService',
            '.container.private.security.csrf.token_manager' => 'get_Container_Private_Security_Csrf_TokenManagerService',
            '.container.private.serializer' => 'get_Container_Private_SerializerService',
            '.container.private.session' => 'get_Container_Private_SessionService',
            '.container.private.twig' => 'get_Container_Private_TwigService',
            '.container.private.validator' => 'get_Container_Private_ValidatorService',
            'Doctrine\\DBAL\\Connection' => 'getConnectionService',
            'Elasticsearch\\Client' => 'getClientService',
            'Shopware\\Administration\\Controller\\AdminExtensionApiController' => 'getAdminExtensionApiControllerService',
            'Shopware\\Administration\\Controller\\AdminProductStreamController' => 'getAdminProductStreamControllerService',
            'Shopware\\Administration\\Controller\\AdminSearchController' => 'getAdminSearchControllerService',
            'Shopware\\Administration\\Controller\\AdminTagController' => 'getAdminTagControllerService',
            'Shopware\\Administration\\Controller\\AdministrationController' => 'getAdministrationControllerService',
            'Shopware\\Administration\\Controller\\DocumentServiceDeprecationController' => 'getDocumentServiceDeprecationControllerService',
            'Shopware\\Administration\\Controller\\NotificationController' => 'getNotificationControllerService',
            'Shopware\\Administration\\Controller\\UserConfigController' => 'getUserConfigControllerService',
            'Shopware\\Administration\\Notification\\NotificationDefinition' => 'getNotificationDefinitionService',
            'Shopware\\Administration\\Notification\\NotificationService' => 'getNotificationServiceService',
            'Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition' => 'getAppAdministrationSnippetDefinitionService',
            'Shopware\\Core\\Checkout\\Cart\\Calculator' => 'getCalculatorService',
            'Shopware\\Core\\Checkout\\Cart\\Facade\\CartFacadeHookFactory' => 'getCartFacadeHookFactoryService',
            'Shopware\\Core\\Checkout\\Cart\\Order\\Api\\OrderConverterController' => 'getOrderConverterControllerService',
            'Shopware\\Core\\Checkout\\Cart\\Order\\Api\\OrderRecalculationController' => 'getOrderRecalculationControllerService',
            'Shopware\\Core\\Checkout\\Cart\\PriceActionController' => 'getPriceActionControllerService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute' => 'getCartDeleteRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute' => 'getCartItemAddRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute' => 'getCartItemRemoveRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute' => 'getCartItemUpdateRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute' => 'getCartLoadRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute' => 'getCartOrderRouteService',
            'Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService' => 'getCartServiceService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition' => 'getCustomerAddressDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition' => 'getCustomerGroupRegistrationSalesChannelDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition' => 'getCustomerGroupTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition' => 'getCustomerGroupDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition' => 'getCustomerRecoveryDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition' => 'getCustomerTagDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition' => 'getCustomerWishlistProductDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition' => 'getCustomerWishlistDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\Api\\CustomerGroupRegistrationActionController' => 'getCustomerGroupRegistrationActionControllerService',
            'Shopware\\Core\\Checkout\\Customer\\CustomerDefinition' => 'getCustomerDefinitionService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountNewsletterRecipientRoute' => 'getAccountNewsletterRecipientRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AddWishlistProductRoute' => 'getAddWishlistProductRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeCustomerProfileRoute' => 'getChangeCustomerProfileRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeEmailRoute' => 'getChangeEmailRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeLanguageRoute' => 'getChangeLanguageRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangePasswordRoute' => 'getChangePasswordRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangePaymentMethodRoute' => 'getChangePaymentMethodRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerGroupRegistrationSettingsRoute' => 'getCustomerGroupRegistrationSettingsRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRecoveryIsExpiredRoute' => 'getCustomerRecoveryIsExpiredRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRoute' => 'getCustomerRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteAddressRoute' => 'getDeleteAddressRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteCustomerRoute' => 'getDeleteCustomerRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ListAddressRoute' => 'getListAddressRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoadWishlistRoute' => 'getLoadWishlistRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoginRoute' => 'getLoginRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute' => 'getLogoutRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\MergeWishlistProductRoute' => 'getMergeWishlistProductRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterConfirmRoute' => 'getRegisterConfirmRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterRoute' => 'getRegisterRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RemoveWishlistProductRoute' => 'getRemoveWishlistProductRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ResetPasswordRoute' => 'getResetPasswordRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SendPasswordRecoveryMailRoute' => 'getSendPasswordRecoveryMailRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute' => 'getSwitchDefaultAddressRouteService',
            'Shopware\\Core\\Checkout\\Customer\\SalesChannel\\UpsertAddressRoute' => 'getUpsertAddressRouteService',
            'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition' => 'getDocumentBaseConfigSalesChannelDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition' => 'getDocumentBaseConfigDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition' => 'getDocumentTypeTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition' => 'getDocumentTypeDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\Controller\\DocumentController' => 'getDocumentControllerService',
            'Shopware\\Core\\Checkout\\Document\\DocumentDefinition' => 'getDocumentDefinitionService',
            'Shopware\\Core\\Checkout\\Document\\DocumentGeneratorController' => 'getDocumentGeneratorControllerService',
            'Shopware\\Core\\Checkout\\Document\\SalesChannel\\DocumentRoute' => 'getDocumentRouteService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition' => 'getOrderAddressDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition' => 'getOrderCustomerDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition' => 'getOrderDeliveryPositionDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition' => 'getOrderDeliveryDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition' => 'getOrderLineItemDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition' => 'getOrderTagDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition' => 'getOrderTransactionCaptureRefundPositionDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition' => 'getOrderTransactionCaptureRefundDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition' => 'getOrderTransactionCaptureDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition' => 'getOrderTransactionDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\Api\\OrderActionController' => 'getOrderActionControllerService',
            'Shopware\\Core\\Checkout\\Order\\OrderDefinition' => 'getOrderDefinitionService',
            'Shopware\\Core\\Checkout\\Order\\SalesChannel\\CancelOrderRoute' => 'getCancelOrderRouteService',
            'Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute' => 'getOrderRouteService',
            'Shopware\\Core\\Checkout\\Order\\SalesChannel\\SetPaymentOrderRoute' => 'getSetPaymentOrderRouteService',
            'Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition' => 'getPaymentMethodTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentRefundProcessor' => 'getPaymentRefundProcessorService',
            'Shopware\\Core\\Checkout\\Payment\\Controller\\PaymentController' => 'getPaymentControllerService',
            'Shopware\\Core\\Checkout\\Payment\\PaymentMethodDefinition' => 'getPaymentMethodDefinitionService',
            'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\CachedPaymentMethodRoute' => 'getCachedPaymentMethodRouteService',
            'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\HandlePaymentMethodRoute' => 'getHandlePaymentMethodRouteService',
            'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition' => 'getSalesChannelPaymentMethodDefinitionService',
            'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SortedPaymentMethodRoute' => 'getSortedPaymentMethodRouteService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition' => 'getPromotionCartRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition' => 'getPromotionDiscountPriceDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition' => 'getPromotionDiscountRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition' => 'getPromotionDiscountDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition' => 'getPromotionIndividualCodeDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition' => 'getPromotionOrderRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition' => 'getPromotionPersonaCustomerDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition' => 'getPromotionPersonaRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition' => 'getPromotionSalesChannelDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition' => 'getPromotionSetGroupRuleDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition' => 'getPromotionSetGroupDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition' => 'getPromotionTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Promotion\\Api\\PromotionActionController' => 'getPromotionActionControllerService',
            'Shopware\\Core\\Checkout\\Promotion\\Api\\PromotionController' => 'getPromotionControllerService',
            'Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition' => 'getPromotionDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition' => 'getShippingMethodPriceDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition' => 'getShippingMethodTagDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition' => 'getShippingMethodTranslationDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\CachedShippingMethodRoute' => 'getCachedShippingMethodRouteService',
            'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition' => 'getSalesChannelShippingMethodDefinitionService',
            'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SortedShippingMethodRoute' => 'getSortedShippingMethodRouteService',
            'Shopware\\Core\\Checkout\\Shipping\\ShippingMethodDefinition' => 'getShippingMethodDefinitionService',
            'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition' => 'getCategoryTagDefinitionService',
            'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition' => 'getCategoryTranslationDefinitionService',
            'Shopware\\Core\\Content\\Category\\CategoryDefinition' => 'getCategoryDefinitionService',
            'Shopware\\Core\\Content\\Category\\CategoryHydrator' => 'getCategoryHydratorService',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\CachedCategoryRoute' => 'getCachedCategoryRouteService',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\CachedNavigationRoute' => 'getCachedNavigationRouteService',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\CategoryListRoute' => 'getCategoryListRouteService',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition' => 'getSalesChannelCategoryDefinitionService',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\TreeBuildingNavigationRoute' => 'getTreeBuildingNavigationRouteService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition' => 'getCmsBlockDefinitionService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition' => 'getCmsPageTranslationDefinitionService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition' => 'getCmsSectionDefinitionService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition' => 'getCmsSlotTranslationDefinitionService',
            'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition' => 'getCmsSlotDefinitionService',
            'Shopware\\Core\\Content\\Cms\\CmsPageDefinition' => 'getCmsPageDefinitionService',
            'Shopware\\Core\\Content\\Cms\\DataAbstractionLayer\\FieldSerializer\\SlotConfigFieldSerializer' => 'getSlotConfigFieldSerializerService',
            'Shopware\\Core\\Content\\Cms\\DataResolver\\CmsSlotsDataResolver' => 'getCmsSlotsDataResolverService',
            'Shopware\\Core\\Content\\Cms\\SalesChannel\\CmsRoute' => 'getCmsRouteService',
            'Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageRepository' => 'getSalesChannelCmsPageRepositoryService',
            'Shopware\\Core\\Content\\ContactForm\\SalesChannel\\ContactFormRoute' => 'getContactFormRouteService',
            'Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition' => 'getFlowSequenceDefinitionService',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\CachedFlowLoader' => 'getCachedFlowLoaderService',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor' => 'getFlowExecutorService',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowFactory' => 'getFlowFactoryService',
            'Shopware\\Core\\Content\\Flow\\FlowDefinition' => 'getFlowDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition' => 'getImportExportFileDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition' => 'getImportExportLogDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\Controller\\ImportExportActionController' => 'getImportExportActionControllerService',
            'Shopware\\Core\\Content\\ImportExport\\ImportExportFactory' => 'getImportExportFactoryService',
            'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition' => 'getImportExportProfileDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition' => 'getImportExportProfileTranslationDefinitionService',
            'Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler' => 'getImportExportHandlerService',
            'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition' => 'getLandingPageSalesChannelDefinitionService',
            'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition' => 'getLandingPageTagDefinitionService',
            'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition' => 'getLandingPageTranslationDefinitionService',
            'Shopware\\Core\\Content\\LandingPage\\LandingPageDefinition' => 'getLandingPageDefinitionService',
            'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\CachedLandingPageRoute' => 'getCachedLandingPageRouteService',
            'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition' => 'getSalesChannelLandingPageDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition' => 'getMailHeaderFooterTranslationDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition' => 'getMailHeaderFooterDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition' => 'getMailTemplateMediaDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition' => 'getMailTemplateTranslationDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition' => 'getMailTemplateTypeTranslationDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition' => 'getMailTemplateTypeDefinitionService',
            'Shopware\\Core\\Content\\MailTemplate\\Api\\MailActionController' => 'getMailActionControllerService',
            'Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition' => 'getMailTemplateDefinitionService',
            'Shopware\\Core\\Content\\Mail\\Service\\MailFactory' => 'getMailFactoryService',
            'Shopware\\Core\\Content\\Mail\\Service\\MailSender' => 'getMailSenderService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition' => 'getMediaDefaultFolderDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition' => 'getMediaFolderConfigurationMediaThumbnailSizeDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition' => 'getMediaFolderConfigurationDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition' => 'getMediaFolderDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition' => 'getMediaTagDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition' => 'getMediaThumbnailSizeDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition' => 'getMediaThumbnailDefinitionService',
            'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition' => 'getMediaTranslationDefinitionService',
            'Shopware\\Core\\Content\\Media\\Api\\MediaFolderController' => 'getMediaFolderControllerService',
            'Shopware\\Core\\Content\\Media\\Api\\MediaUploadController' => 'getMediaUploadControllerService',
            'Shopware\\Core\\Content\\Media\\File\\FileSaver' => 'getFileSaverService',
            'Shopware\\Core\\Content\\Media\\MediaDefinition' => 'getMediaDefinitionService',
            'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition' => 'getNewsletterRecipientTagDefinitionService',
            'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipient\\NewsletterRecipientDefinition' => 'getNewsletterRecipientDefinitionService',
            'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterConfirmRoute' => 'getNewsletterConfirmRouteService',
            'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterSubscribeRoute' => 'getNewsletterSubscribeRouteService',
            'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterUnsubscribeRoute' => 'getNewsletterUnsubscribeRouteService',
            'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition' => 'getSalesChannelNewsletterRecipientDefinitionService',
            'Shopware\\Core\\Content\\ProductExport\\Api\\ProductExportController' => 'getProductExportControllerService',
            'Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition' => 'getProductExportDefinitionService',
            'Shopware\\Core\\Content\\ProductExport\\ProductExportHydrator' => 'getProductExportHydratorService',
            'Shopware\\Core\\Content\\ProductExport\\SalesChannel\\ExportController' => 'getExportControllerService',
            'Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator' => 'getProductExportGeneratorService',
            'Shopware\\Core\\Content\\ProductExport\\Service\\ProductExporter' => 'getProductExporterService',
            'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition' => 'getProductStreamFilterDefinitionService',
            'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterHydrator' => 'getProductStreamFilterHydratorService',
            'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition' => 'getProductStreamTranslationDefinitionService',
            'Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition' => 'getProductStreamDefinitionService',
            'Shopware\\Core\\Content\\ProductStream\\ProductStreamHydrator' => 'getProductStreamHydratorService',
            'Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder' => 'getProductStreamBuilderService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition' => 'getProductCategoryTreeDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition' => 'getProductCategoryDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition' => 'getProductConfiguratorSettingDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingHydrator' => 'getProductConfiguratorSettingHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition' => 'getProductCrossSellingAssignedProductsDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsHydrator' => 'getProductCrossSellingAssignedProductsHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition' => 'getProductCrossSellingTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition' => 'getProductCrossSellingDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingHydrator' => 'getProductCrossSellingHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition' => 'getProductCustomFieldSetDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition' => 'getProductFeatureSetTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition' => 'getProductFeatureSetDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetHydrator' => 'getProductFeatureSetHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition' => 'getProductKeywordDictionaryDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryHydrator' => 'getProductKeywordDictionaryHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition' => 'getProductManufacturerTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition' => 'getProductManufacturerDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerHydrator' => 'getProductManufacturerHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition' => 'getProductMediaDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaHydrator' => 'getProductMediaHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition' => 'getProductOptionDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition' => 'getProductPriceDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceHydrator' => 'getProductPriceHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition' => 'getProductPropertyDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition' => 'getProductReviewDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewHydrator' => 'getProductReviewHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition' => 'getProductSearchConfigFieldDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldHydrator' => 'getProductSearchConfigFieldHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition' => 'getProductSearchConfigDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigHydrator' => 'getProductSearchConfigHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition' => 'getProductSearchKeywordDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordHydrator' => 'getProductSearchKeywordHydratorService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition' => 'getProductStreamMappingDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition' => 'getProductTagDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition' => 'getProductTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition' => 'getProductVisibilityDefinitionService',
            'Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityHydrator' => 'getProductVisibilityHydratorService',
            'Shopware\\Core\\Content\\Product\\Api\\ProductActionController' => 'getProductActionControllerService',
            'Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\CheapestPrice\\CheapestPriceAccessorBuilder' => 'getCheapestPriceAccessorBuilderService',
            'Shopware\\Core\\Content\\Product\\ProductDefinition' => 'getProductDefinitionService',
            'Shopware\\Core\\Content\\Product\\ProductHydrator' => 'getProductHydratorService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute' => 'getCachedProductCrossSellingRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\CachedProductDetailRoute' => 'getCachedProductDetailRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\FindVariant\\FindProductVariantRoute' => 'getFindProductVariantRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute' => 'getCachedProductListingRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute' => 'getResolveCriteriaProductListingRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\ProductListRoute' => 'getProductListRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute' => 'getCachedProductReviewRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewSaveRoute' => 'getProductReviewSaveRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition' => 'getSalesChannelProductDefinitionService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\CachedProductSearchRoute' => 'getCachedProductSearchRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute' => 'getResolvedCriteriaProductSearchRouteService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition' => 'getProductSortingDefinitionService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingHydrator' => 'getProductSortingHydratorService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition' => 'getProductSortingTranslationDefinitionService',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\CachedProductSuggestRoute' => 'getCachedProductSuggestRouteService',
            'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition' => 'getPropertyGroupOptionTranslationDefinitionService',
            'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition' => 'getPropertyGroupOptionDefinitionService',
            'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionHydrator' => 'getPropertyGroupOptionHydratorService',
            'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition' => 'getPropertyGroupTranslationDefinitionService',
            'Shopware\\Core\\Content\\Property\\PropertyGroupDefinition' => 'getPropertyGroupDefinitionService',
            'Shopware\\Core\\Content\\Property\\PropertyGroupHydrator' => 'getPropertyGroupHydratorService',
            'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition' => 'getRuleConditionDefinitionService',
            'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition' => 'getRuleTagDefinitionService',
            'Shopware\\Core\\Content\\Rule\\RuleDefinition' => 'getRuleDefinitionService',
            'Shopware\\Core\\Content\\Seo\\Api\\SeoActionController' => 'getSeoActionControllerService',
            'Shopware\\Core\\Content\\Seo\\CachedSeoResolver' => 'getCachedSeoResolverService',
            'Shopware\\Core\\Content\\Seo\\EmptyPathInfoResolver' => 'getEmptyPathInfoResolverService',
            'Shopware\\Core\\Content\\Seo\\Entity\\Dbal\\SeoUrlAssociationFieldResolver' => 'getSeoUrlAssociationFieldResolverService',
            'Shopware\\Core\\Content\\Seo\\Entity\\Serializer\\SeoUrlFieldSerializer' => 'getSeoUrlFieldSerializerService',
            'Shopware\\Core\\Content\\Seo\\MainCategory\\MainCategoryDefinition' => 'getMainCategoryDefinitionService',
            'Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition' => 'getSalesChannelMainCategoryDefinitionService',
            'Shopware\\Core\\Content\\Seo\\SalesChannel\\SeoUrlRoute' => 'getSeoUrlRouteService',
            'Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface' => 'getSeoUrlPlaceholderHandlerInterfaceService',
            'Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition' => 'getSeoUrlTemplateDefinitionService',
            'Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition' => 'getSalesChannelSeoUrlDefinitionService',
            'Shopware\\Core\\Content\\Seo\\SeoUrl\\SeoUrlDefinition' => 'getSeoUrlDefinitionService',
            'Shopware\\Core\\Content\\Sitemap\\SalesChannel\\CachedSitemapRoute' => 'getCachedSitemapRouteService',
            'Shopware\\Core\\Framework\\Adapter\\Asset\\AssetPackageService' => 'getAssetPackageServiceService',
            'Shopware\\Core\\Framework\\Adapter\\Cache\\CacheIdLoader' => 'getCacheIdLoaderService',
            'Shopware\\Core\\Framework\\Adapter\\Cache\\Script\\Facade\\CacheInvalidatorFacadeHookFactory' => 'getCacheInvalidatorFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\Adapter\\Twig\\AppTemplateIterator' => 'getAppTemplateIteratorService',
            'Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder' => 'getTemplateFinderService',
            'Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateIterator' => 'getTemplateIteratorService',
            'Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator' => 'getAclCriteriaValidatorService',
            'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition' => 'getAclRoleDefinitionService',
            'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition' => 'getAclUserRoleDefinitionService',
            'Shopware\\Core\\Framework\\Api\\Controller\\AccessKeyController' => 'getAccessKeyControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\AclController' => 'getAclControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\ApiController' => 'getApiControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\AuthController' => 'getAuthControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\CacheController' => 'getCacheControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\CustomSnippetFormatController' => 'getCustomSnippetFormatControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\FallbackController' => 'getFallbackControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\IndexingController' => 'getIndexingControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\InfoController' => 'getInfoControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\IntegrationController' => 'getIntegrationControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\SalesChannelProxyController' => 'getSalesChannelProxyControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\SyncController' => 'getSyncControllerService',
            'Shopware\\Core\\Framework\\Api\\Controller\\UserController' => 'getUserControllerService',
            'Shopware\\Core\\Framework\\Api\\Sync\\SyncService' => 'getSyncServiceService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition' => 'getActionButtonTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition' => 'getActionButtonDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition' => 'getAppPaymentMethodDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition' => 'getAppScriptConditionTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition' => 'getAppScriptConditionDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition' => 'getAppTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition' => 'getAppCmsBlockTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition' => 'getAppCmsBlockDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition' => 'getAppFlowActionTranslationDefinitionService',
            'Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition' => 'getAppFlowActionDefinitionService',
            'Shopware\\Core\\Framework\\App\\Api\\AppActionController' => 'getAppActionControllerService',
            'Shopware\\Core\\Framework\\App\\Api\\AppCmsController' => 'getAppCmsControllerService',
            'Shopware\\Core\\Framework\\App\\Api\\AppUrlChangeController' => 'getAppUrlChangeControllerService',
            'Shopware\\Core\\Framework\\App\\AppDefinition' => 'getAppDefinitionService',
            'Shopware\\Core\\Framework\\App\\AppLocaleProvider' => 'getAppLocaleProviderService',
            'Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\Resolver' => 'getResolverService',
            'Shopware\\Core\\Framework\\App\\FlowAction\\AppFlowActionProvider' => 'getAppFlowActionProviderService',
            'Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider' => 'getShopIdProviderService',
            'Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition' => 'getTemplateDefinitionService',
            'Shopware\\Core\\Framework\\App\\Template\\TemplateStateService' => 'getTemplateStateServiceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator' => 'getEntityCacheKeyGeneratorService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityHydrator' => 'getEntityHydratorService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\ConfigJsonFieldAccessorBuilder' => 'getConfigJsonFieldAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\CustomFieldsAccessorBuilder' => 'getCustomFieldsAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\DefaultFieldAccessorBuilder' => 'getDefaultFieldAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\JsonFieldAccessorBuilder' => 'getJsonFieldAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\PriceFieldAccessorBuilder' => 'getPriceFieldAccessorBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\ManyToManyAssociationFieldResolver' => 'getManyToManyAssociationFieldResolverService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\ManyToOneAssociationFieldResolver' => 'getManyToOneAssociationFieldResolverService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\OneToManyAssociationFieldResolver' => 'getOneToManyAssociationFieldResolverService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\TranslationFieldResolver' => 'getTranslationFieldResolverService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\JoinGroupBuilder' => 'getJoinGroupBuilderService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry' => 'getDefinitionInstanceRegistryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory' => 'getEntityLoadedEventFactoryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\ExtensionRegistry' => 'getExtensionRegistryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\RepositoryFacadeHookFactory' => 'getRepositoryFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\RepositoryWriterFacadeHookFactory' => 'getRepositoryWriterFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\SalesChannelRepositoryFacadeHookFactory' => 'getSalesChannelRepositoryFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\BlobFieldSerializer' => 'getBlobFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\BoolFieldSerializer' => 'getBoolFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CalculatedPriceFieldSerializer' => 'getCalculatedPriceFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CartPriceFieldSerializer' => 'getCartPriceFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CashRoundingConfigFieldSerializer' => 'getCashRoundingConfigFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ConfigJsonFieldSerializer' => 'getConfigJsonFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CreatedAtFieldSerializer' => 'getCreatedAtFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CreatedByFieldSerializer' => 'getCreatedByFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer' => 'getCustomFieldsSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateFieldSerializer' => 'getDateFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateTimeFieldSerializer' => 'getDateTimeFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\EmailFieldSerializer' => 'getEmailFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\FkFieldSerializer' => 'getFkFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\FloatFieldSerializer' => 'getFloatFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\IdFieldSerializer' => 'getIdFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\IntFieldSerializer' => 'getIntFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\JsonFieldSerializer' => 'getJsonFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ListFieldSerializer' => 'getListFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\LongTextFieldSerializer' => 'getLongTextFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ManyToManyAssociationFieldSerializer' => 'getManyToManyAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ManyToOneAssociationFieldSerializer' => 'getManyToOneAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\OneToManyAssociationFieldSerializer' => 'getOneToManyAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\OneToOneAssociationFieldSerializer' => 'getOneToOneAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PHPUnserializeFieldSerializer' => 'getPHPUnserializeFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PasswordFieldSerializer' => 'getPasswordFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PriceDefinitionFieldSerializer' => 'getPriceDefinitionFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PriceFieldSerializer' => 'getPriceFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ReferenceVersionFieldSerializer' => 'getReferenceVersionFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\RemoteAddressFieldSerializer' => 'getRemoteAddressFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\StateMachineStateFieldSerializer' => 'getStateMachineStateFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\StringFieldSerializer' => 'getStringFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TaxFreeConfigFieldSerializer' => 'getTaxFreeConfigFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TimeZoneFieldSerializer' => 'getTimeZoneFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TranslatedFieldSerializer' => 'getTranslatedFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TranslationsAssociationFieldSerializer' => 'getTranslationsAssociationFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\UpdatedAtFieldSerializer' => 'getUpdatedAtFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\UpdatedByFieldSerializer' => 'getUpdatedByFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VariantListingConfigFieldSerializer' => 'getVariantListingConfigFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VersionDataPayloadFieldSerializer' => 'getVersionDataPayloadFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VersionFieldSerializer' => 'getVersionFieldSerializerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry' => 'getEntityIndexerRegistryService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface' => 'getEntityReaderInterfaceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface' => 'getEntityAggregatorInterfaceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface' => 'getEntitySearcherInterfaceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager' => 'getVersionManagerService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition' => 'getVersionCommitDataDefinitionService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition' => 'getVersionCommitDefinitionService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition' => 'getVersionDefinitionService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface' => 'getEntityWriteGatewayInterfaceService',
            'Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter' => 'getEntityWriterService',
            'Shopware\\Core\\Framework\\Event\\BusinessEventRegistry' => 'getBusinessEventRegistryService',
            'Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionRule\\EventActionRuleDefinition' => 'getEventActionRuleDefinitionService',
            'Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionSalesChannel\\EventActionSalesChannelDefinition' => 'getEventActionSalesChannelDefinitionService',
            'Shopware\\Core\\Framework\\Event\\EventAction\\EventActionDefinition' => 'getEventActionDefinitionService',
            'Shopware\\Core\\Framework\\Increment\\Controller\\IncrementApiController' => 'getIncrementApiControllerService',
            'Shopware\\Core\\Framework\\Log\\LogEntryDefinition' => 'getLogEntryDefinitionService',
            'Shopware\\Core\\Framework\\MessageQueue\\Api\\ConsumeMessagesController' => 'getConsumeMessagesControllerService',
            'Shopware\\Core\\Framework\\MessageQueue\\DeadMessage\\DeadMessageDefinition' => 'getDeadMessageDefinitionService',
            'Shopware\\Core\\Framework\\MessageQueue\\MessageQueueStatsDefinition' => 'getMessageQueueStatsDefinitionService',
            'Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\Api\\ScheduledTaskController' => 'getScheduledTaskControllerService',
            'Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition' => 'getScheduledTaskDefinitionService',
            'Shopware\\Core\\Framework\\Migration\\Api\\MigrationController' => 'getMigrationControllerService',
            'Shopware\\Core\\Framework\\Migration\\IndexerQueuer' => 'getIndexerQueuerService',
            'Shopware\\Core\\Framework\\Migration\\MigrationCollectionLoader' => 'getMigrationCollectionLoaderService',
            'Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition' => 'getPluginTranslationDefinitionService',
            'Shopware\\Core\\Framework\\Plugin\\KernelPluginCollection' => 'getKernelPluginCollectionService',
            'Shopware\\Core\\Framework\\Plugin\\KernelPluginLoader\\KernelPluginLoader' => 'getKernelPluginLoaderService',
            'Shopware\\Core\\Framework\\Plugin\\PluginDefinition' => 'getPluginDefinitionService',
            'Shopware\\Core\\Framework\\Plugin\\Util\\PluginIdProvider' => 'getPluginIdProviderService',
            'Shopware\\Core\\Framework\\Routing\\CanonicalRedirectService' => 'getCanonicalRedirectServiceService',
            'Shopware\\Core\\Framework\\Routing\\RequestTransformerInterface' => 'getRequestTransformerInterfaceService',
            'Shopware\\Core\\Framework\\Rule\\Api\\RuleConfigController' => 'getRuleConfigControllerService',
            'Shopware\\Core\\Framework\\Script\\Api\\ScriptApiRoute' => 'getScriptApiRouteService',
            'Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseFactoryFacadeHookFactory' => 'getScriptResponseFactoryFacadeHookFactoryService',
            'Shopware\\Core\\Framework\\Script\\Api\\ScriptStoreApiRoute' => 'getScriptStoreApiRouteService',
            'Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor' => 'getScriptExecutorService',
            'Shopware\\Core\\Framework\\Script\\ScriptDefinition' => 'getScriptDefinitionService',
            'Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreActionsController' => 'getExtensionStoreActionsControllerService',
            'Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreDataController' => 'getExtensionStoreDataControllerService',
            'Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreLicensesController' => 'getExtensionStoreLicensesControllerService',
            'Shopware\\Core\\Framework\\Store\\Api\\FirstRunWizardController' => 'getFirstRunWizardControllerService',
            'Shopware\\Core\\Framework\\Store\\Api\\StoreController' => 'getStoreControllerService',
            'Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider' => 'getStoreRequestOptionsProviderService',
            'Shopware\\Core\\Framework\\Store\\Services\\ShopSecretInvalidMiddleware' => 'getShopSecretInvalidMiddlewareService',
            'Shopware\\Core\\Framework\\Store\\Services\\StoreSessionExpiredMiddleware' => 'getStoreSessionExpiredMiddlewareService',
            'Shopware\\Core\\Framework\\Store\\Services\\VerifyResponseSignatureMiddleware' => 'getVerifyResponseSignatureMiddlewareService',
            'Shopware\\Core\\Framework\\Update\\Api\\UpdateController' => 'getUpdateControllerService',
            'Shopware\\Core\\Framework\\Util\\HtmlSanitizer' => 'getHtmlSanitizerService',
            'Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition' => 'getWebhookEventLogDefinitionService',
            'Shopware\\Core\\Framework\\Webhook\\WebhookDefinition' => 'getWebhookDefinitionService',
            'Shopware\\Core\\Maintenance\\SalesChannel\\Service\\SalesChannelCreator' => 'getSalesChannelCreatorService',
            'Shopware\\Core\\Maintenance\\User\\Service\\UserProvisioner' => 'getUserProvisionerService',
            'Shopware\\Core\\Profiling\\Profiler' => 'getProfilerService',
            'Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition' => 'getCountryStateTranslationDefinitionService',
            'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\CountryStateDefinition' => 'getCountryStateDefinitionService',
            'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition' => 'getSalesChannelCountryStateDefinitionService',
            'Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition' => 'getCountryTranslationDefinitionService',
            'Shopware\\Core\\System\\Country\\CountryDefinition' => 'getCountryDefinitionService',
            'Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryRoute' => 'getCachedCountryRouteService',
            'Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryStateRoute' => 'getCachedCountryStateRouteService',
            'Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition' => 'getSalesChannelCountryDefinitionService',
            'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition' => 'getCurrencyCountryRoundingDefinitionService',
            'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition' => 'getCurrencyTranslationDefinitionService',
            'Shopware\\Core\\System\\Currency\\CurrencyDefinition' => 'getCurrencyDefinitionService',
            'Shopware\\Core\\System\\Currency\\CurrencyFormatter' => 'getCurrencyFormatterService',
            'Shopware\\Core\\System\\Currency\\SalesChannel\\CachedCurrencyRoute' => 'getCachedCurrencyRouteService',
            'Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition' => 'getSalesChannelCurrencyDefinitionService',
            'Shopware\\Core\\System\\CustomEntity\\Api\\CustomEntityApiController' => 'getCustomEntityApiControllerService',
            'Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition' => 'getCustomEntityDefinitionService',
            'Shopware\\Core\\System\\CustomEntity\\CustomEntityRegistrar' => 'getCustomEntityRegistrarService',
            'Shopware\\Core\\System\\CustomEntity\\Schema\\CustomEntitySchemaUpdater' => 'getCustomEntitySchemaUpdaterService',
            'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition' => 'getCustomFieldSetRelationDefinitionService',
            'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition' => 'getCustomFieldSetDefinitionService',
            'Shopware\\Core\\System\\CustomField\\Api\\CustomFieldSetActionController' => 'getCustomFieldSetActionControllerService',
            'Shopware\\Core\\System\\CustomField\\CustomFieldDefinition' => 'getCustomFieldDefinitionService',
            'Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition' => 'getDeliveryTimeTranslationDefinitionService',
            'Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition' => 'getDeliveryTimeDefinitionService',
            'Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition' => 'getIntegrationRoleDefinitionService',
            'Shopware\\Core\\System\\Integration\\IntegrationDefinition' => 'getIntegrationDefinitionService',
            'Shopware\\Core\\System\\Language\\LanguageDefinition' => 'getLanguageDefinitionService',
            'Shopware\\Core\\System\\Language\\SalesChannel\\CachedLanguageRoute' => 'getCachedLanguageRouteService',
            'Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition' => 'getSalesChannelLanguageDefinitionService',
            'Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition' => 'getLocaleTranslationDefinitionService',
            'Shopware\\Core\\System\\Locale\\LocaleDefinition' => 'getLocaleDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition' => 'getNumberRangeSalesChannelDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition' => 'getNumberRangeStateDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition' => 'getNumberRangeTranslationDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition' => 'getNumberRangeTypeTranslationDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition' => 'getNumberRangeTypeDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\Api\\NumberRangeController' => 'getNumberRangeControllerService',
            'Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition' => 'getNumberRangeDefinitionService',
            'Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface' => 'getNumberRangeValueGeneratorInterfaceService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition' => 'getSalesChannelAnalyticsDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition' => 'getSalesChannelCountryDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition' => 'getSalesChannelCurrencyDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition' => 'getSalesChannelDomainDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition' => 'getSalesChannelLanguageDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition' => 'getSalesChannelPaymentMethodDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition' => 'getSalesChannelShippingMethodDefinition2Service',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition' => 'getSalesChannelTranslationDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition' => 'getSalesChannelTypeTranslationDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition' => 'getSalesChannelTypeDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory' => 'getSalesChannelContextFactoryService',
            'Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry' => 'getSalesChannelDefinitionInstanceRegistryService',
            'Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition' => 'getSalesChannelDefinitionService',
            'Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextSwitchRoute' => 'getContextSwitchRouteService',
            'Shopware\\Core\\System\\SalesChannel\\SalesChannel\\StoreApiInfoController' => 'getStoreApiInfoControllerService',
            'Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition' => 'getSalutationTranslationDefinitionService',
            'Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute' => 'getCachedSalutationRouteService',
            'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition' => 'getSalesChannelSalutationDefinitionService',
            'Shopware\\Core\\System\\Salutation\\SalutationDefinition' => 'getSalutationDefinitionService',
            'Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition' => 'getSnippetSetDefinitionService',
            'Shopware\\Core\\System\\Snippet\\Api\\SnippetController' => 'getSnippetControllerService',
            'Shopware\\Core\\System\\Snippet\\Files\\SnippetFileCollection' => 'getSnippetFileCollectionService',
            'Shopware\\Core\\System\\Snippet\\Filter\\SnippetFilterFactory' => 'getSnippetFilterFactoryService',
            'Shopware\\Core\\System\\Snippet\\SnippetDefinition' => 'getSnippetDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition' => 'getStateMachineHistoryDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition' => 'getStateMachineStateDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition' => 'getStateMachineStateTranslationDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition' => 'getStateMachineTransitionDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\Api\\StateMachineActionController' => 'getStateMachineActionControllerService',
            'Shopware\\Core\\System\\StateMachine\\StateMachineDefinition' => 'getStateMachineDefinitionService',
            'Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition' => 'getStateMachineTranslationDefinitionService',
            'Shopware\\Core\\System\\SystemConfig\\Api\\SystemConfigController' => 'getSystemConfigControllerService',
            'Shopware\\Core\\System\\SystemConfig\\Facade\\SystemConfigFacadeHookFactory' => 'getSystemConfigFacadeHookFactoryService',
            'Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition' => 'getSystemConfigDefinitionService',
            'Shopware\\Core\\System\\SystemConfig\\SystemConfigService' => 'getSystemConfigServiceService',
            'Shopware\\Core\\System\\Tag\\Service\\FilterTagIdsService' => 'getFilterTagIdsServiceService',
            'Shopware\\Core\\System\\Tag\\TagDefinition' => 'getTagDefinitionService',
            'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition' => 'getTaxRuleTypeTranslationDefinitionService',
            'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition' => 'getTaxRuleTypeDefinitionService',
            'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition' => 'getTaxRuleDefinitionService',
            'Shopware\\Core\\System\\Tax\\TaxDefinition' => 'getTaxDefinitionService',
            'Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition' => 'getUnitTranslationDefinitionService',
            'Shopware\\Core\\System\\Unit\\UnitDefinition' => 'getUnitDefinitionService',
            'Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition' => 'getUserAccessKeyDefinitionService',
            'Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition' => 'getUserConfigDefinitionService',
            'Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition' => 'getUserRecoveryDefinitionService',
            'Shopware\\Core\\System\\User\\Api\\UserRecoveryController' => 'getUserRecoveryControllerService',
            'Shopware\\Core\\System\\User\\Api\\UserValidationController' => 'getUserValidationControllerService',
            'Shopware\\Core\\System\\User\\UserDefinition' => 'getUserDefinitionService',
            'Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper' => 'getElasticsearchHelperService',
            'Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler' => 'getCreateAliasTaskHandlerService',
            'Shopware\\Storefront\\Controller\\AccountOrderController' => 'getAccountOrderControllerService',
            'Shopware\\Storefront\\Controller\\AccountPaymentController' => 'getAccountPaymentControllerService',
            'Shopware\\Storefront\\Controller\\AccountProfileController' => 'getAccountProfileControllerService',
            'Shopware\\Storefront\\Controller\\AddressController' => 'getAddressControllerService',
            'Shopware\\Storefront\\Controller\\Api\\CaptchaController' => 'getCaptchaControllerService',
            'Shopware\\Storefront\\Controller\\AuthController' => 'getAuthController2Service',
            'Shopware\\Storefront\\Controller\\CaptchaController' => 'getCaptchaController2Service',
            'Shopware\\Storefront\\Controller\\CartLineItemController' => 'getCartLineItemControllerService',
            'Shopware\\Storefront\\Controller\\CheckoutController' => 'getCheckoutControllerService',
            'Shopware\\Storefront\\Controller\\CmsController' => 'getCmsControllerService',
            'Shopware\\Storefront\\Controller\\ContextController' => 'getContextControllerService',
            'Shopware\\Storefront\\Controller\\CookieController' => 'getCookieControllerService',
            'Shopware\\Storefront\\Controller\\CountryStateController' => 'getCountryStateControllerService',
            'Shopware\\Storefront\\Controller\\CsrfController' => 'getCsrfControllerService',
            'Shopware\\Storefront\\Controller\\DocumentController' => 'getDocumentController2Service',
            'Shopware\\Storefront\\Controller\\ErrorController' => 'getErrorControllerService',
            'Shopware\\Storefront\\Controller\\FormController' => 'getFormControllerService',
            'Shopware\\Storefront\\Controller\\LandingPageController' => 'getLandingPageControllerService',
            'Shopware\\Storefront\\Controller\\MaintenanceController' => 'getMaintenanceControllerService',
            'Shopware\\Storefront\\Controller\\NavigationController' => 'getNavigationControllerService',
            'Shopware\\Storefront\\Controller\\NewsletterController' => 'getNewsletterControllerService',
            'Shopware\\Storefront\\Controller\\ProductController' => 'getProductControllerService',
            'Shopware\\Storefront\\Controller\\RegisterController' => 'getRegisterControllerService',
            'Shopware\\Storefront\\Controller\\ScriptController' => 'getScriptControllerService',
            'Shopware\\Storefront\\Controller\\SearchController' => 'getSearchControllerService',
            'Shopware\\Storefront\\Controller\\SitemapController' => 'getSitemapControllerService',
            'Shopware\\Storefront\\Controller\\StoreApiProxyController' => 'getStoreApiProxyControllerService',
            'Shopware\\Storefront\\Controller\\VerificationHashController' => 'getVerificationHashControllerService',
            'Shopware\\Storefront\\Controller\\WellKnownController' => 'getWellKnownControllerService',
            'Shopware\\Storefront\\Controller\\WishlistController' => 'getWishlistControllerService',
            'Shopware\\Storefront\\Framework\\Cache\\CacheStore' => 'getCacheStoreService',
            'Shopware\\Storefront\\Framework\\Csrf\\CsrfPlaceholderHandler' => 'getCsrfPlaceholderHandlerService',
            'Shopware\\Storefront\\Framework\\Media\\StorefrontMediaValidatorRegistry' => 'getStorefrontMediaValidatorRegistryService',
            'Shopware\\Storefront\\Page\\Checkout\\Register\\CheckoutRegisterPageLoader' => 'getCheckoutRegisterPageLoaderService',
            'Shopware\\Storefront\\Page\\Product\\Configurator\\ProductCombinationFinder' => 'getProductCombinationFinderService',
            'Shopware\\Storefront\\Page\\Product\\Review\\ProductReviewLoader' => 'getProductReviewLoaderService',
            'Shopware\\Storefront\\Page\\Search\\SearchPageLoader' => 'getSearchPageLoaderService',
            'Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition' => 'getThemeChildDefinitionService',
            'Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition' => 'getThemeMediaDefinitionService',
            'Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition' => 'getThemeSalesChannelDefinitionService',
            'Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition' => 'getThemeTranslationDefinitionService',
            'Shopware\\Storefront\\Theme\\Controller\\ThemeController' => 'getThemeControllerService',
            'Shopware\\Storefront\\Theme\\SalesChannelThemeLoader' => 'getSalesChannelThemeLoaderService',
            'Shopware\\Storefront\\Theme\\StorefrontPluginRegistry' => 'getStorefrontPluginRegistryService',
            'Shopware\\Storefront\\Theme\\ThemeDefinition' => 'getThemeDefinitionService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController' => 'getRedirectControllerService',
            'Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController' => 'getTemplateControllerService',
            'acl_role.repository' => 'getAclRole_RepositoryService',
            'acl_user_role.repository' => 'getAclUserRole_RepositoryService',
            'administration.filesystem.private' => 'getAdministration_Filesystem_PrivateService',
            'administration.filesystem.public' => 'getAdministration_Filesystem_PublicService',
            'app.repository' => 'getApp_RepositoryService',
            'app_action_button.repository' => 'getAppActionButton_RepositoryService',
            'app_action_button_translation.repository' => 'getAppActionButtonTranslation_RepositoryService',
            'app_administration_snippet.repository' => 'getAppAdministrationSnippet_RepositoryService',
            'app_cms_block.repository' => 'getAppCmsBlock_RepositoryService',
            'app_cms_block_translation.repository' => 'getAppCmsBlockTranslation_RepositoryService',
            'app_flow_action.repository' => 'getAppFlowAction_RepositoryService',
            'app_flow_action_translation.repository' => 'getAppFlowActionTranslation_RepositoryService',
            'app_payment_method.repository' => 'getAppPaymentMethod_RepositoryService',
            'app_script_condition.repository' => 'getAppScriptCondition_RepositoryService',
            'app_script_condition_translation.repository' => 'getAppScriptConditionTranslation_RepositoryService',
            'app_template.repository' => 'getAppTemplate_RepositoryService',
            'app_translation.repository' => 'getAppTranslation_RepositoryService',
            'cache.app' => 'getCache_AppService',
            'cache.app_clearer' => 'getCache_AppClearerService',
            'cache.global_clearer' => 'getCache_GlobalClearerService',
            'cache.system' => 'getCache_SystemService',
            'cache.system_clearer' => 'getCache_SystemClearerService',
            'cache.validator_expression_language' => 'getCache_ValidatorExpressionLanguageService',
            'cache_warmer' => 'getCacheWarmerService',
            'category.repository' => 'getCategory_RepositoryService',
            'category_tag.repository' => 'getCategoryTag_RepositoryService',
            'category_translation.repository' => 'getCategoryTranslation_RepositoryService',
            'checkout.filesystem.private' => 'getCheckout_Filesystem_PrivateService',
            'checkout.filesystem.public' => 'getCheckout_Filesystem_PublicService',
            'cms_block.repository' => 'getCmsBlock_RepositoryService',
            'cms_page.repository' => 'getCmsPage_RepositoryService',
            'cms_page_translation.repository' => 'getCmsPageTranslation_RepositoryService',
            'cms_section.repository' => 'getCmsSection_RepositoryService',
            'cms_slot.repository' => 'getCmsSlot_RepositoryService',
            'cms_slot_translation.repository' => 'getCmsSlotTranslation_RepositoryService',
            'console.command_loader' => 'getConsole_CommandLoaderService',
            'container.env_var_processors_locator' => 'getContainer_EnvVarProcessorsLocatorService',
            'content.filesystem.private' => 'getContent_Filesystem_PrivateService',
            'content.filesystem.public' => 'getContent_Filesystem_PublicService',
            'country.repository' => 'getCountry_RepositoryService',
            'country_state.repository' => 'getCountryState_RepositoryService',
            'country_state_translation.repository' => 'getCountryStateTranslation_RepositoryService',
            'country_translation.repository' => 'getCountryTranslation_RepositoryService',
            'currency.repository' => 'getCurrency_RepositoryService',
            'currency_country_rounding.repository' => 'getCurrencyCountryRounding_RepositoryService',
            'currency_translation.repository' => 'getCurrencyTranslation_RepositoryService',
            'custom_entity.repository' => 'getCustomEntity_RepositoryService',
            'custom_field.repository' => 'getCustomField_RepositoryService',
            'custom_field_set.repository' => 'getCustomFieldSet_RepositoryService',
            'custom_field_set_relation.repository' => 'getCustomFieldSetRelation_RepositoryService',
            'customer.repository' => 'getCustomer_RepositoryService',
            'customer_address.repository' => 'getCustomerAddress_RepositoryService',
            'customer_group.repository' => 'getCustomerGroup_RepositoryService',
            'customer_group_registration_sales_channels.repository' => 'getCustomerGroupRegistrationSalesChannels_RepositoryService',
            'customer_group_translation.repository' => 'getCustomerGroupTranslation_RepositoryService',
            'customer_recovery.repository' => 'getCustomerRecovery_RepositoryService',
            'customer_tag.repository' => 'getCustomerTag_RepositoryService',
            'customer_wishlist.repository' => 'getCustomerWishlist_RepositoryService',
            'customer_wishlist_product.repository' => 'getCustomerWishlistProduct_RepositoryService',
            'dead_message.repository' => 'getDeadMessage_RepositoryService',
            'delivery_time.repository' => 'getDeliveryTime_RepositoryService',
            'delivery_time_translation.repository' => 'getDeliveryTimeTranslation_RepositoryService',
            'document.repository' => 'getDocument_RepositoryService',
            'document_base_config.repository' => 'getDocumentBaseConfig_RepositoryService',
            'document_base_config_sales_channel.repository' => 'getDocumentBaseConfigSalesChannel_RepositoryService',
            'document_type.repository' => 'getDocumentType_RepositoryService',
            'document_type_translation.repository' => 'getDocumentTypeTranslation_RepositoryService',
            'elasticsearch.filesystem.private' => 'getElasticsearch_Filesystem_PrivateService',
            'elasticsearch.filesystem.public' => 'getElasticsearch_Filesystem_PublicService',
            'enqueue.client.default.producer' => 'getEnqueue_Client_Default_ProducerService',
            'error_controller' => 'getErrorController2Service',
            'event_action.repository' => 'getEventAction_RepositoryService',
            'event_action_rule.repository' => 'getEventActionRule_RepositoryService',
            'event_action_sales_channel.repository' => 'getEventActionSalesChannel_RepositoryService',
            'event_dispatcher' => 'getEventDispatcherService',
            'flow.repository' => 'getFlow_RepositoryService',
            'flow_sequence.repository' => 'getFlowSequence_RepositoryService',
            'framework.filesystem.private' => 'getFramework_Filesystem_PrivateService',
            'framework.filesystem.public' => 'getFramework_Filesystem_PublicService',
            'http_kernel' => 'getHttpKernelService',
            'import_export_file.repository' => 'getImportExportFile_RepositoryService',
            'import_export_log.repository' => 'getImportExportLog_RepositoryService',
            'import_export_profile.repository' => 'getImportExportProfile_RepositoryService',
            'import_export_profile_translation.repository' => 'getImportExportProfileTranslation_RepositoryService',
            'integration.repository' => 'getIntegration_RepositoryService',
            'integration_role.repository' => 'getIntegrationRole_RepositoryService',
            'landing_page.repository' => 'getLandingPage_RepositoryService',
            'landing_page_sales_channel.repository' => 'getLandingPageSalesChannel_RepositoryService',
            'landing_page_tag.repository' => 'getLandingPageTag_RepositoryService',
            'landing_page_translation.repository' => 'getLandingPageTranslation_RepositoryService',
            'language.repository' => 'getLanguage_RepositoryService',
            'locale.repository' => 'getLocale_RepositoryService',
            'locale_translation.repository' => 'getLocaleTranslation_RepositoryService',
            'log_entry.repository' => 'getLogEntry_RepositoryService',
            'mail_header_footer.repository' => 'getMailHeaderFooter_RepositoryService',
            'mail_header_footer_translation.repository' => 'getMailHeaderFooterTranslation_RepositoryService',
            'mail_template.repository' => 'getMailTemplate_RepositoryService',
            'mail_template_media.repository' => 'getMailTemplateMedia_RepositoryService',
            'mail_template_translation.repository' => 'getMailTemplateTranslation_RepositoryService',
            'mail_template_type.repository' => 'getMailTemplateType_RepositoryService',
            'mail_template_type_translation.repository' => 'getMailTemplateTypeTranslation_RepositoryService',
            'main_category.repository' => 'getMainCategory_RepositoryService',
            'maintenance.filesystem.private' => 'getMaintenance_Filesystem_PrivateService',
            'maintenance.filesystem.public' => 'getMaintenance_Filesystem_PublicService',
            'media.repository' => 'getMedia_RepositoryService',
            'media_default_folder.repository' => 'getMediaDefaultFolder_RepositoryService',
            'media_folder.repository' => 'getMediaFolder_RepositoryService',
            'media_folder_configuration.repository' => 'getMediaFolderConfiguration_RepositoryService',
            'media_folder_configuration_media_thumbnail_size.repository' => 'getMediaFolderConfigurationMediaThumbnailSize_RepositoryService',
            'media_tag.repository' => 'getMediaTag_RepositoryService',
            'media_thumbnail.repository' => 'getMediaThumbnail_RepositoryService',
            'media_thumbnail_size.repository' => 'getMediaThumbnailSize_RepositoryService',
            'media_translation.repository' => 'getMediaTranslation_RepositoryService',
            'message_queue_stats.repository' => 'getMessageQueueStats_RepositoryService',
            'messenger.default_bus' => 'getMessenger_DefaultBusService',
            'monolog.logger.business_events' => 'getMonolog_Logger_BusinessEventsService',
            'newsletter_recipient.repository' => 'getNewsletterRecipient_RepositoryService',
            'newsletter_recipient_tag.repository' => 'getNewsletterRecipientTag_RepositoryService',
            'notification.repository' => 'getNotification_RepositoryService',
            'number_range.repository' => 'getNumberRange_RepositoryService',
            'number_range_sales_channel.repository' => 'getNumberRangeSalesChannel_RepositoryService',
            'number_range_state.repository' => 'getNumberRangeState_RepositoryService',
            'number_range_translation.repository' => 'getNumberRangeTranslation_RepositoryService',
            'number_range_type.repository' => 'getNumberRangeType_RepositoryService',
            'number_range_type_translation.repository' => 'getNumberRangeTypeTranslation_RepositoryService',
            'order.repository' => 'getOrder_RepositoryService',
            'order_address.repository' => 'getOrderAddress_RepositoryService',
            'order_customer.repository' => 'getOrderCustomer_RepositoryService',
            'order_delivery.repository' => 'getOrderDelivery_RepositoryService',
            'order_delivery_position.repository' => 'getOrderDeliveryPosition_RepositoryService',
            'order_line_item.repository' => 'getOrderLineItem_RepositoryService',
            'order_tag.repository' => 'getOrderTag_RepositoryService',
            'order_transaction.repository' => 'getOrderTransaction_RepositoryService',
            'order_transaction_capture.repository' => 'getOrderTransactionCapture_RepositoryService',
            'order_transaction_capture_refund.repository' => 'getOrderTransactionCaptureRefund_RepositoryService',
            'order_transaction_capture_refund_position.repository' => 'getOrderTransactionCaptureRefundPosition_RepositoryService',
            'payment_method.repository' => 'getPaymentMethod_RepositoryService',
            'payment_method_translation.repository' => 'getPaymentMethodTranslation_RepositoryService',
            'plugin.repository' => 'getPlugin_RepositoryService',
            'plugin_translation.repository' => 'getPluginTranslation_RepositoryService',
            'product.repository' => 'getProduct_RepositoryService',
            'product_category.repository' => 'getProductCategory_RepositoryService',
            'product_category_tree.repository' => 'getProductCategoryTree_RepositoryService',
            'product_configurator_setting.repository' => 'getProductConfiguratorSetting_RepositoryService',
            'product_cross_selling.repository' => 'getProductCrossSelling_RepositoryService',
            'product_cross_selling_assigned_products.repository' => 'getProductCrossSellingAssignedProducts_RepositoryService',
            'product_cross_selling_translation.repository' => 'getProductCrossSellingTranslation_RepositoryService',
            'product_custom_field_set.repository' => 'getProductCustomFieldSet_RepositoryService',
            'product_export.repository' => 'getProductExport_RepositoryService',
            'product_feature_set.repository' => 'getProductFeatureSet_RepositoryService',
            'product_feature_set_translation.repository' => 'getProductFeatureSetTranslation_RepositoryService',
            'product_keyword_dictionary.repository' => 'getProductKeywordDictionary_RepositoryService',
            'product_manufacturer.repository' => 'getProductManufacturer_RepositoryService',
            'product_manufacturer_translation.repository' => 'getProductManufacturerTranslation_RepositoryService',
            'product_media.repository' => 'getProductMedia_RepositoryService',
            'product_option.repository' => 'getProductOption_RepositoryService',
            'product_price.repository' => 'getProductPrice_RepositoryService',
            'product_property.repository' => 'getProductProperty_RepositoryService',
            'product_review.repository' => 'getProductReview_RepositoryService',
            'product_search_config.repository' => 'getProductSearchConfig_RepositoryService',
            'product_search_config_field.repository' => 'getProductSearchConfigField_RepositoryService',
            'product_search_keyword.repository' => 'getProductSearchKeyword_RepositoryService',
            'product_sorting.repository' => 'getProductSorting_RepositoryService',
            'product_sorting_translation.repository' => 'getProductSortingTranslation_RepositoryService',
            'product_stream.repository' => 'getProductStream_RepositoryService',
            'product_stream_filter.repository' => 'getProductStreamFilter_RepositoryService',
            'product_stream_mapping.repository' => 'getProductStreamMapping_RepositoryService',
            'product_stream_translation.repository' => 'getProductStreamTranslation_RepositoryService',
            'product_tag.repository' => 'getProductTag_RepositoryService',
            'product_translation.repository' => 'getProductTranslation_RepositoryService',
            'product_visibility.repository' => 'getProductVisibility_RepositoryService',
            'profiling.filesystem.private' => 'getProfiling_Filesystem_PrivateService',
            'profiling.filesystem.public' => 'getProfiling_Filesystem_PublicService',
            'promotion.repository' => 'getPromotion_RepositoryService',
            'promotion_cart_rule.repository' => 'getPromotionCartRule_RepositoryService',
            'promotion_discount.repository' => 'getPromotionDiscount_RepositoryService',
            'promotion_discount_prices.repository' => 'getPromotionDiscountPrices_RepositoryService',
            'promotion_discount_rule.repository' => 'getPromotionDiscountRule_RepositoryService',
            'promotion_individual_code.repository' => 'getPromotionIndividualCode_RepositoryService',
            'promotion_order_rule.repository' => 'getPromotionOrderRule_RepositoryService',
            'promotion_persona_customer.repository' => 'getPromotionPersonaCustomer_RepositoryService',
            'promotion_persona_rule.repository' => 'getPromotionPersonaRule_RepositoryService',
            'promotion_sales_channel.repository' => 'getPromotionSalesChannel_RepositoryService',
            'promotion_setgroup.repository' => 'getPromotionSetgroup_RepositoryService',
            'promotion_setgroup_rule.repository' => 'getPromotionSetgroupRule_RepositoryService',
            'promotion_translation.repository' => 'getPromotionTranslation_RepositoryService',
            'property_group.repository' => 'getPropertyGroup_RepositoryService',
            'property_group_option.repository' => 'getPropertyGroupOption_RepositoryService',
            'property_group_option_translation.repository' => 'getPropertyGroupOptionTranslation_RepositoryService',
            'property_group_translation.repository' => 'getPropertyGroupTranslation_RepositoryService',
            'request_stack' => 'getRequestStackService',
            'router' => 'getRouterService',
            'routing.loader' => 'getRouting_LoaderService',
            'rule.repository' => 'getRule_RepositoryService',
            'rule_condition.repository' => 'getRuleCondition_RepositoryService',
            'rule_tag.repository' => 'getRuleTag_RepositoryService',
            'sales_channel.category.repository' => 'getSalesChannel_Category_RepositoryService',
            'sales_channel.country.repository' => 'getSalesChannel_Country_RepositoryService',
            'sales_channel.country_state.repository' => 'getSalesChannel_CountryState_RepositoryService',
            'sales_channel.currency.repository' => 'getSalesChannel_Currency_RepositoryService',
            'sales_channel.landing_page.repository' => 'getSalesChannel_LandingPage_RepositoryService',
            'sales_channel.language.repository' => 'getSalesChannel_Language_RepositoryService',
            'sales_channel.main_category.repository' => 'getSalesChannel_MainCategory_RepositoryService',
            'sales_channel.newsletter_recipient.repository' => 'getSalesChannel_NewsletterRecipient_RepositoryService',
            'sales_channel.payment_method.repository' => 'getSalesChannel_PaymentMethod_RepositoryService',
            'sales_channel.product.repository' => 'getSalesChannel_Product_RepositoryService',
            'sales_channel.repository' => 'getSalesChannel_RepositoryService',
            'sales_channel.salutation.repository' => 'getSalesChannel_Salutation_RepositoryService',
            'sales_channel.seo_url.repository' => 'getSalesChannel_SeoUrl_RepositoryService',
            'sales_channel.shipping_method.repository' => 'getSalesChannel_ShippingMethod_RepositoryService',
            'sales_channel_analytics.repository' => 'getSalesChannelAnalytics_RepositoryService',
            'sales_channel_country.repository' => 'getSalesChannelCountry_RepositoryService',
            'sales_channel_currency.repository' => 'getSalesChannelCurrency_RepositoryService',
            'sales_channel_definition.Shopware\\Administration\\Notification\\NotificationDefinition' => 'getNotificationDefinition2Service',
            'sales_channel_definition.Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition' => 'getAppAdministrationSnippetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition' => 'getCustomerAddressDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition' => 'getCustomerGroupRegistrationSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition' => 'getCustomerGroupTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition' => 'getCustomerGroupDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition' => 'getCustomerRecoveryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition' => 'getCustomerTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition' => 'getCustomerWishlistProductDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition' => 'getCustomerWishlistDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Customer\\CustomerDefinition' => 'getCustomerDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition' => 'getDocumentBaseConfigSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition' => 'getDocumentBaseConfigDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition' => 'getDocumentTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition' => 'getDocumentTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Document\\DocumentDefinition' => 'getDocumentDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition' => 'getOrderAddressDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition' => 'getOrderCustomerDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition' => 'getOrderDeliveryPositionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition' => 'getOrderDeliveryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition' => 'getOrderLineItemDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition' => 'getOrderTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition' => 'getOrderTransactionCaptureRefundPositionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition' => 'getOrderTransactionCaptureRefundDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition' => 'getOrderTransactionCaptureDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition' => 'getOrderTransactionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Order\\OrderDefinition' => 'getOrderDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition' => 'getPaymentMethodTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition' => 'getPromotionCartRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition' => 'getPromotionDiscountPriceDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition' => 'getPromotionDiscountRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition' => 'getPromotionDiscountDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition' => 'getPromotionIndividualCodeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition' => 'getPromotionOrderRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition' => 'getPromotionPersonaCustomerDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition' => 'getPromotionPersonaRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition' => 'getPromotionSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition' => 'getPromotionSetGroupRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition' => 'getPromotionSetGroupDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition' => 'getPromotionTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition' => 'getPromotionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition' => 'getShippingMethodPriceDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition' => 'getShippingMethodTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition' => 'getShippingMethodTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition' => 'getCategoryTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition' => 'getCategoryTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition' => 'getCmsBlockDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition' => 'getCmsPageTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition' => 'getCmsSectionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition' => 'getCmsSlotTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition' => 'getCmsSlotDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Cms\\CmsPageDefinition' => 'getCmsPageDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition' => 'getFlowSequenceDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Flow\\FlowDefinition' => 'getFlowDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition' => 'getImportExportFileDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition' => 'getImportExportLogDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition' => 'getImportExportProfileDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition' => 'getImportExportProfileTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition' => 'getLandingPageSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition' => 'getLandingPageTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition' => 'getLandingPageTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition' => 'getMailHeaderFooterTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition' => 'getMailHeaderFooterDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition' => 'getMailTemplateMediaDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition' => 'getMailTemplateTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition' => 'getMailTemplateTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition' => 'getMailTemplateTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition' => 'getMailTemplateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition' => 'getMediaDefaultFolderDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition' => 'getMediaFolderConfigurationMediaThumbnailSizeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition' => 'getMediaFolderConfigurationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition' => 'getMediaFolderDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition' => 'getMediaTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition' => 'getMediaThumbnailSizeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition' => 'getMediaThumbnailDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition' => 'getMediaTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Media\\MediaDefinition' => 'getMediaDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition' => 'getNewsletterRecipientTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition' => 'getProductExportDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition' => 'getProductStreamFilterDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition' => 'getProductStreamTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition' => 'getProductStreamDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition' => 'getProductCategoryTreeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition' => 'getProductCategoryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition' => 'getProductConfiguratorSettingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition' => 'getProductCrossSellingAssignedProductsDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition' => 'getProductCrossSellingTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition' => 'getProductCrossSellingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition' => 'getProductCustomFieldSetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition' => 'getProductFeatureSetTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition' => 'getProductFeatureSetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition' => 'getProductKeywordDictionaryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition' => 'getProductManufacturerTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition' => 'getProductManufacturerDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition' => 'getProductMediaDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition' => 'getProductOptionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition' => 'getProductPriceDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition' => 'getProductPropertyDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition' => 'getProductReviewDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition' => 'getProductSearchConfigFieldDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition' => 'getProductSearchConfigDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition' => 'getProductSearchKeywordDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition' => 'getProductStreamMappingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition' => 'getProductTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition' => 'getProductTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition' => 'getProductVisibilityDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition' => 'getProductSortingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition' => 'getProductSortingTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition' => 'getPropertyGroupOptionTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition' => 'getPropertyGroupOptionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition' => 'getPropertyGroupTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Property\\PropertyGroupDefinition' => 'getPropertyGroupDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition' => 'getRuleConditionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition' => 'getRuleTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Rule\\RuleDefinition' => 'getRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition' => 'getSeoUrlTemplateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition' => 'getAclRoleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition' => 'getAclUserRoleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition' => 'getActionButtonTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition' => 'getActionButtonDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition' => 'getAppPaymentMethodDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition' => 'getAppScriptConditionTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition' => 'getAppScriptConditionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition' => 'getAppTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition' => 'getAppCmsBlockTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition' => 'getAppCmsBlockDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition' => 'getAppFlowActionTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition' => 'getAppFlowActionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\AppDefinition' => 'getAppDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition' => 'getTemplateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition' => 'getVersionCommitDataDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition' => 'getVersionCommitDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition' => 'getVersionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionRule\\EventActionRuleDefinition' => 'getEventActionRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionSalesChannel\\EventActionSalesChannelDefinition' => 'getEventActionSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Event\\EventAction\\EventActionDefinition' => 'getEventActionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Log\\LogEntryDefinition' => 'getLogEntryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\MessageQueue\\DeadMessage\\DeadMessageDefinition' => 'getDeadMessageDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\MessageQueue\\MessageQueueStatsDefinition' => 'getMessageQueueStatsDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition' => 'getScheduledTaskDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition' => 'getPluginTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Plugin\\PluginDefinition' => 'getPluginDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Script\\ScriptDefinition' => 'getScriptDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition' => 'getWebhookEventLogDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\Framework\\Webhook\\WebhookDefinition' => 'getWebhookDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition' => 'getCountryStateTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition' => 'getCountryTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition' => 'getCurrencyCountryRoundingDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition' => 'getCurrencyTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition' => 'getCustomEntityDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition' => 'getCustomFieldSetRelationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition' => 'getCustomFieldSetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\CustomField\\CustomFieldDefinition' => 'getCustomFieldDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition' => 'getDeliveryTimeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition' => 'getDeliveryTimeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition' => 'getIntegrationRoleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Integration\\IntegrationDefinition' => 'getIntegrationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition' => 'getLocaleTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Locale\\LocaleDefinition' => 'getLocaleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition' => 'getNumberRangeSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition' => 'getNumberRangeStateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition' => 'getNumberRangeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition' => 'getNumberRangeTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition' => 'getNumberRangeTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition' => 'getNumberRangeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition' => 'getSalesChannelAnalyticsDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition' => 'getSalesChannelCountryDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition' => 'getSalesChannelCurrencyDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition' => 'getSalesChannelDomainDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition' => 'getSalesChannelLanguageDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition' => 'getSalesChannelPaymentMethodDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition' => 'getSalesChannelShippingMethodDefinition3Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition' => 'getSalesChannelTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition' => 'getSalesChannelTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition' => 'getSalesChannelTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition' => 'getSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition' => 'getSalutationTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition' => 'getSnippetSetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Snippet\\SnippetDefinition' => 'getSnippetDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition' => 'getStateMachineHistoryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition' => 'getStateMachineStateDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition' => 'getStateMachineStateTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition' => 'getStateMachineTransitionDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\StateMachineDefinition' => 'getStateMachineDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition' => 'getStateMachineTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition' => 'getSystemConfigDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tag\\TagDefinition' => 'getTagDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition' => 'getTaxRuleTypeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition' => 'getTaxRuleTypeDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition' => 'getTaxRuleDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Tax\\TaxDefinition' => 'getTaxDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition' => 'getUnitTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\Unit\\UnitDefinition' => 'getUnitDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition' => 'getUserAccessKeyDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition' => 'getUserConfigDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition' => 'getUserRecoveryDefinition2Service',
            'sales_channel_definition.Shopware\\Core\\System\\User\\UserDefinition' => 'getUserDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition' => 'getThemeChildDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition' => 'getThemeMediaDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition' => 'getThemeSalesChannelDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition' => 'getThemeTranslationDefinition2Service',
            'sales_channel_definition.Shopware\\Storefront\\Theme\\ThemeDefinition' => 'getThemeDefinition2Service',
            'sales_channel_domain.repository' => 'getSalesChannelDomain_RepositoryService',
            'sales_channel_language.repository' => 'getSalesChannelLanguage_RepositoryService',
            'sales_channel_payment_method.repository' => 'getSalesChannelPaymentMethod_RepositoryService',
            'sales_channel_shipping_method.repository' => 'getSalesChannelShippingMethod_RepositoryService',
            'sales_channel_translation.repository' => 'getSalesChannelTranslation_RepositoryService',
            'sales_channel_type.repository' => 'getSalesChannelType_RepositoryService',
            'sales_channel_type_translation.repository' => 'getSalesChannelTypeTranslation_RepositoryService',
            'salutation.repository' => 'getSalutation_RepositoryService',
            'salutation_translation.repository' => 'getSalutationTranslation_RepositoryService',
            'scheduled_task.repository' => 'getScheduledTask_RepositoryService',
            'script.repository' => 'getScript_RepositoryService',
            'seo_url.repository' => 'getSeoUrl_RepositoryService',
            'seo_url_template.repository' => 'getSeoUrlTemplate_RepositoryService',
            'services_resetter' => 'getServicesResetterService',
            'shipping_method.repository' => 'getShippingMethod_RepositoryService',
            'shipping_method_price.repository' => 'getShippingMethodPrice_RepositoryService',
            'shipping_method_tag.repository' => 'getShippingMethodTag_RepositoryService',
            'shipping_method_translation.repository' => 'getShippingMethodTranslation_RepositoryService',
            'shopware.filesystem.asset' => 'getShopware_Filesystem_AssetService',
            'shopware.filesystem.private' => 'getShopware_Filesystem_PrivateService',
            'shopware.filesystem.public' => 'getShopware_Filesystem_PublicService',
            'shopware.filesystem.sitemap' => 'getShopware_Filesystem_SitemapService',
            'shopware.filesystem.temp' => 'getShopware_Filesystem_TempService',
            'shopware.filesystem.theme' => 'getShopware_Filesystem_ThemeService',
            'shopware.increment.gateway.registry' => 'getShopware_Increment_Gateway_RegistryService',
            'shopware.store_client' => 'getShopware_StoreClientService',
            'snippet.repository' => 'getSnippet_RepositoryService',
            'snippet_set.repository' => 'getSnippetSet_RepositoryService',
            'state_machine.repository' => 'getStateMachine_RepositoryService',
            'state_machine_history.repository' => 'getStateMachineHistory_RepositoryService',
            'state_machine_state.repository' => 'getStateMachineState_RepositoryService',
            'state_machine_state_translation.repository' => 'getStateMachineStateTranslation_RepositoryService',
            'state_machine_transition.repository' => 'getStateMachineTransition_RepositoryService',
            'state_machine_translation.repository' => 'getStateMachineTranslation_RepositoryService',
            'storefront.filesystem.private' => 'getStorefront_Filesystem_PrivateService',
            'storefront.filesystem.public' => 'getStorefront_Filesystem_PublicService',
            'system.filesystem.private' => 'getSystem_Filesystem_PrivateService',
            'system.filesystem.public' => 'getSystem_Filesystem_PublicService',
            'system_config.repository' => 'getSystemConfig_RepositoryService',
            'tag.repository' => 'getTag_RepositoryService',
            'tax.repository' => 'getTax_RepositoryService',
            'tax_rule.repository' => 'getTaxRule_RepositoryService',
            'tax_rule_type.repository' => 'getTaxRuleType_RepositoryService',
            'tax_rule_type_translation.repository' => 'getTaxRuleTypeTranslation_RepositoryService',
            'theme.repository' => 'getTheme_RepositoryService',
            'theme_child.repository' => 'getThemeChild_RepositoryService',
            'theme_media.repository' => 'getThemeMedia_RepositoryService',
            'theme_sales_channel.repository' => 'getThemeSalesChannel_RepositoryService',
            'theme_translation.repository' => 'getThemeTranslation_RepositoryService',
            'translator' => 'getTranslatorService',
            'unit.repository' => 'getUnit_RepositoryService',
            'unit_translation.repository' => 'getUnitTranslation_RepositoryService',
            'user.repository' => 'getUser_RepositoryService',
            'user_access_key.repository' => 'getUserAccessKey_RepositoryService',
            'user_config.repository' => 'getUserConfig_RepositoryService',
            'user_recovery.repository' => 'getUserRecovery_RepositoryService',
            'version.repository' => 'getVersion_RepositoryService',
            'version_commit.repository' => 'getVersionCommit_RepositoryService',
            'version_commit_data.repository' => 'getVersionCommitData_RepositoryService',
            'webhook.repository' => 'getWebhook_RepositoryService',
            'webhook_event_log.repository' => 'getWebhookEventLog_RepositoryService',
            'cache_clearer' => 'getCacheClearerService',
            'filesystem' => 'getFilesystemService',
            'serializer' => 'getSerializerService',
            'security.csrf.token_manager' => 'getSecurity_Csrf_TokenManagerService',
            'twig' => 'getTwigService',
            'session' => 'getSessionService',
            'validator' => 'getValidatorService',
        ];
        $this->aliases = [
            'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\PaymentMethodRoute' => 'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SortedPaymentMethodRoute',
            'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\ShippingMethodRoute' => 'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SortedShippingMethodRoute',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\CategoryRoute' => 'Shopware\\Core\\Content\\Category\\SalesChannel\\CachedCategoryRoute',
            'Shopware\\Core\\Content\\Category\\SalesChannel\\NavigationRoute' => 'Shopware\\Core\\Content\\Category\\SalesChannel\\TreeBuildingNavigationRoute',
            'Shopware\\Core\\Content\\Flow\\Dispatching\\FlowLoader' => 'Shopware\\Core\\Content\\Flow\\Dispatching\\CachedFlowLoader',
            'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\LandingPageRoute' => 'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\CachedLandingPageRoute',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\ProductCrossSellingRoute' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\ProductDetailRoute' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\CachedProductDetailRoute',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingRoute' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewRoute' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ProductSearchRoute' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute',
            'Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\ProductSuggestRoute' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\CachedProductSuggestRoute',
            'Shopware\\Core\\Content\\Seo\\SeoResolver' => 'Shopware\\Core\\Content\\Seo\\EmptyPathInfoResolver',
            'Shopware\\Core\\Content\\Sitemap\\SalesChannel\\SitemapRoute' => 'Shopware\\Core\\Content\\Sitemap\\SalesChannel\\CachedSitemapRoute',
            'Shopware\\Core\\System\\Country\\SalesChannel\\CountryRoute' => 'Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryRoute',
            'Shopware\\Core\\System\\Country\\SalesChannel\\CountryStateRoute' => 'Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryStateRoute',
            'Shopware\\Core\\System\\Currency\\SalesChannel\\CurrencyRoute' => 'Shopware\\Core\\System\\Currency\\SalesChannel\\CachedCurrencyRoute',
            'Shopware\\Core\\System\\Language\\SalesChannel\\LanguageRoute' => 'Shopware\\Core\\System\\Language\\SalesChannel\\CachedLanguageRoute',
            'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalutationRoute' => 'Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Payment\\PaymentMethodDefinition' => 'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition' => 'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition' => 'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition',
            'sales_channel_definition.Shopware\\Core\\Checkout\\Shipping\\ShippingMethodDefinition' => 'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Category\\CategoryDefinition' => 'Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition' => 'Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\LandingPageDefinition' => 'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition' => 'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipient\\NewsletterRecipientDefinition' => 'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition' => 'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\ProductDefinition' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\MainCategory\\MainCategoryDefinition' => 'Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition' => 'Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition' => 'Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition',
            'sales_channel_definition.Shopware\\Core\\Content\\Seo\\SeoUrl\\SeoUrlDefinition' => 'Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\CountryStateDefinition' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\CountryDefinition' => 'Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition' => 'Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Currency\\CurrencyDefinition' => 'Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition' => 'Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Language\\LanguageDefinition' => 'Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition' => 'Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition' => 'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition',
            'sales_channel_definition.Shopware\\Core\\System\\Salutation\\SalutationDefinition' => 'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition',
        ];

        $this->privates['service_container'] = function () {
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/lib/Doctrine/DBAL/Driver/Connection.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/dbal/lib/Doctrine/DBAL/Connection.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernelInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/KernelInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/RebootableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/TerminableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Kernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Kernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/cocur/slugify/src/SlugifyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/cocur/slugify/src/Slugify.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/ContextResolverListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/CoreSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/RouteScopeListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/RouteEventSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Snippet/SnippetService.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Snippet/Filter/SnippetFilterFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/TemplateFinderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ResetInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/TemplateFinder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/NamespaceHierarchy/NamespaceHierarchyBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/EntityTemplateLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/RequestContextResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/RouteScopeCheckTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/SalesChannelRequestContextResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/ApiRequestContextResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/RouteScopeRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Cache/CacheStateSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/messenger/Handler/MessageHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/messenger/Handler/MessageSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/MessageQueue/Handler/AbstractMessageHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/MessageQueue/ScheduledTask/ScheduledTaskHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Cache/CacheInvalidator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Cache/CacheTagCollection.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/cache/src/CacheItemPoolInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AdapterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/TagAwareAdapterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/TagAwareCacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache-contracts/CacheTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Cache/CacheDecorator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/PruneableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/ResettableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/Psr/Log/LoggerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/ContractsTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/Psr/Log/LoggerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/ProxyTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/TagAwareAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Util/HtmlSanitizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/Handler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/ResettableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Log/Monolog/ExcludeExceptionHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/RouteParamsCleanupListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Acl/AclAnnotationValidator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/EventListener/CorsListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/EventListener/ResponseHeaderListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Serializer/JsonEntityEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Converter/ApiVersionConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Converter/ConverterRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Converter/DefaultApiConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/Repositories/RepositoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/Repositories/AccessTokenRepositoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/OAuth/AccessTokenRepository.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/Repositories/RefreshTokenRepositoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/OAuth/RefreshTokenRepository.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/CryptKey.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/event/src/EmitterAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/event/src/EmitterAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/AuthorizationServer.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/Repositories/ClientRepositoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/OAuth/ClientRepository.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/Repositories/ScopeRepositoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/OAuth/ScopeRepository.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/EventListener/JsonRequestTransformerListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/EventListener/ExpectationSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/EventListener/Authentication/SalesChannelAuthenticationListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/EventListener/Authentication/ApiAuthenticationListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/ResourceServer.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/AuthorizationValidators/AuthorizationValidatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/OAuth/BearerTokenValidator.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/CryptTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/AuthorizationValidators/BearerTokenValidator.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/oauth2-server/src/Repositories/UserRepositoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/OAuth/UserRepository.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Validation/DataValidator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/psr-http-message-bridge/HttpMessageFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/psr-http-message-bridge/Factory/PsrHttpFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/RequestFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/ResponseFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/ServerRequestFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/StreamFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/UploadedFileFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/http-factory/src/UriFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/nyholm/psr7/src/Factory/Psr17Factory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/ShopId/ShopIdProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Lifecycle/Persister/ScriptPersister.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Lifecycle/ScriptFileReaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Lifecycle/ScriptFileReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/ActiveAppsLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Lifecycle/AbstractAppLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Lifecycle/AppLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomEntity/Xml/CustomEntityXmlSchemaValidator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/AppLocaleProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/AppDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/AppPaymentMethod/AppPaymentMethodDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Event/EntityLoadedEventFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Cache/EntityCacheKeyGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/EntityDefinitionQueryHelper.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/JoinGroupBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/EntityHydrator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Search/Term/TokenizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Search/Term/Tokenizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Search/Term/SearchTermInterpreter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Search/Term/EntityScoreQueryBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Read/EntityReaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/EntityReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/CriteriaQueryBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/CriteriaPartResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Write/EntityWriterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Write/EntityWriter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/EntityForeignKeyResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Write/EntityWriteResultFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Write/WriteCommandExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Write/EntityWriteGatewayInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/EntityWriteGateway.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/ExceptionHandlerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Search/Parser/SqlQueryParser.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Version/VersionDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Version/Aggregate/VersionCommit/VersionCommitDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Version/Aggregate/VersionCommitData/VersionCommitDataDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/VersionManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/DefinitionInstanceRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Event/EventAction/EventActionDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/event-dispatcher/src/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Event/BusinessEventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Filesystem/FilesystemFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/league/flysystem/src/FilesystemInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/PackageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Package.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/UrlPackage.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Asset/FallbackUrlPackage.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ThemeAssetPackage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/VersionStrategy/VersionStrategyInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Asset/FlysystemLastModifiedVersionStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/MessageQueue/ScheduledTask/ScheduledTaskDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Execution/ScriptLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Execution/ScriptExecutor.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/ScriptDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/DataCollectorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/DataCollector/DataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/DataCollector/TemplateAwareDataCollectorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/DataCollector/AbstractDataCollector.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Debugging/ScriptTraces.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Language/LanguageDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Entity/SalesChannelDefinitionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Language/SalesChannel/SalesChannelLanguageDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Language/LanguageLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Language/CachedLanguageLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Language/LanguageLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Language/SalesChannel/AbstractLanguageRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Language/SalesChannel/CachedLanguageRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Language/SalesChannel/LanguageRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SeoUrl/SeoUrlDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SeoUrl/SalesChannel/SalesChannelSeoUrlDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SeoUrlRoute/SeoUrlRouteRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SeoUrlPlaceholderHandlerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SeoUrlPlaceholderHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SalesChannel/StoreApiSeoResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Webhook/WebhookDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Flow/Dispatching/FlowDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/event-dispatcher/EventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Webhook/BusinessEventEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Increment/IncrementGatewayRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/SalesChannelDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelDomain/SalesChannelDomainDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Context/SalesChannelContextPersister.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Context/SalesChannelContextServiceInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Context/SalesChannelContextService.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Entity/SalesChannelDefinitionInstanceRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Api/StoreApiResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Api/StructEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/CountryDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/Aggregate/CountryState/CountryStateDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Currency/CurrencyDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Currency/Aggregate/CurrencyCountryRounding/CurrencyCountryRoundingDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Currency/SalesChannel/SalesChannelCurrencyDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Currency/CurrencyFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Currency/SalesChannel/AbstractCurrencyRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Currency/SalesChannel/CachedCurrencyRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Currency/SalesChannel/CurrencyRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Locale/LanguageLocaleCodeProvider.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Snippet/Aggregate/SnippetSet/SnippetSetDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Snippet/SnippetDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Tax/TaxDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/User/UserDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/StateMachine/Loader/InitialStateIdLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/SystemConfigDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Util/XmlReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/Util/ConfigReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/SystemConfigService.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/AbstractSystemConfigLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/MemoizedSystemConfigLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/CachedSystemConfigLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/SystemConfigLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/Store/MemoizedSystemConfigStore.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/ValueGenerator/NumberRangeValueGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/ValueGenerator/NumberRangeValueGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/ValueGenerator/Pattern/ValueGeneratorPatternRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/CategoryDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/SalesChannelCategoryDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/Service/NavigationLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/Service/NavigationLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/AbstractNavigationRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/CachedNavigationRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/NavigationRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/TreeBuildingNavigationRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/Service/CategoryBreadcrumbBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/MediaDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/ProductDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/SalesChannelProductDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Rule/RuleDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/CmsPageDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/DataResolver/CmsSlotsDataResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/SalesChannel/SalesChannelCmsPageLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/SalesChannel/SalesChannelCmsPageLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Flow/Dispatching/FlowFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Price/AmountCalculator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Price/CashRounding.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/CartPersisterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/AbstractCartPersister.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/CartPersister.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/CartSerializationCleaner.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/CartService.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/CartCalculator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/AbstractCartItemUpdateRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/CartItemUpdateRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/AbstractCartLoadRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/CartLoadRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/AbstractCartDeleteRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/CartDeleteRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/AbstractCartItemRemoveRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/CartItemRemoveRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/AbstractCartItemAddRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/CartItemAddRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/AbstractCartOrderRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/SalesChannel/CartOrderRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Order/OrderPersisterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Order/OrderPersister.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/PreparedPaymentService.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Tax/PercentageTaxRuleBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Tax/TaxDetector.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Tax/TaxCalculator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Processor.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Validator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Transaction/TransactionProcessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/CartRuleLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/AbstractRuleLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/CachedRuleLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/RuleLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/LineItemFactoryRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/CustomerDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Aggregate/CustomerAddress/CustomerAddressDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Aggregate/CustomerGroup/CustomerGroupDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/OrderDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderAddress/OrderAddressDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Order/OrderConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/PaymentMethodDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/SalesChannel/SalesChannelPaymentMethodDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/lcobucci/jwt/src/Configuration.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/Cart/Token/JWTConfigurationFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/lcobucci/jwt/src/Signer.php';
            include_once \dirname(__DIR__, 4).'/vendor/lcobucci/jwt/src/Signer/OpenSSL.php';
            include_once \dirname(__DIR__, 4).'/vendor/lcobucci/jwt/src/Signer/Rsa.php';
            include_once \dirname(__DIR__, 4).'/vendor/lcobucci/jwt/src/Signer/Rsa/Sha256.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/Cart/PaymentHandler/PaymentHandlerRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/container/src/ContainerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceProviderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/service-contracts/ServiceLocatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ServiceLocator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/SalesChannel/AbstractPaymentMethodRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/SalesChannel/CachedPaymentMethodRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/SalesChannel/PaymentMethodRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/SalesChannel/SortedPaymentMethodRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Shipping/ShippingMethodDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Shipping/SalesChannel/SalesChannelShippingMethodDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Shipping/SalesChannel/AbstractShippingMethodRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Shipping/SalesChannel/CachedShippingMethodRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Shipping/SalesChannel/ShippingMethodRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Shipping/SalesChannel/SortedShippingMethodRoute.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/DataAbstractionLayer/CriteriaParser.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/ElasticsearchHelper.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/ElasticsearchRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/psr/log/Psr/Log/LoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Log/LoggerFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Routing/MaintenanceModeResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ThemeConfigValueAccessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/AbstractResolvedConfigLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/CachedResolvedConfigLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ResolvedConfigLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/composer/composer/src/Composer/EventDispatcher/EventSubscriberInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/TwigDateRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Csrf/CsrfPlaceholderHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Routing/StorefrontSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/HreflangLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/HreflangLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Routing/NotFound/NotFoundSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Csrf/CsrfRouteListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/AffiliateTracking/AffiliateTrackingListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Header/HeaderPageletLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Header/HeaderPageletLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Footer/FooterPageletLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Footer/FooterPageletLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/GenericPageLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/GenericPageLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Cache/AbstractCacheTracer.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cache/CacheTracer.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Cache/CacheTracer.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cache/CacheResponseSubscriber.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Captcha/CaptchaRouteListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Routing/ResponseHeaderListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/StorefrontPluginConfiguration/AbstractStorefrontPluginConfigurationFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/StorefrontPluginConfiguration/StorefrontPluginConfigurationFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/StorefrontPluginRegistryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/StorefrontPluginRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ThemeFileImporterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ThemeFileImporter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ThemeFileResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ThemeService.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ThemeCompilerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ThemeCompiler.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/AbstractScssCompiler.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ScssPhpCompiler.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ConfigLoader/AbstractConfigLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ConfigLoader/DatabaseConfigLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/AbstractThemePathBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/MD5ThemePathBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/ThemeDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/MappingEntityDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/Aggregate/ThemeSalesChannelDefinition.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/NamespaceHierarchy/TemplateNamespaceHierarchyBuilderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/Twig/ThemeNamespaceHierarchyBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/Twig/ThemeInheritanceBuilderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/Twig/ThemeInheritanceBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/SalesChannelThemeLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/ErrorListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/RunnerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/Runner/Symfony/HttpKernelRunner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/Runner/Symfony/ResponseRunner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/RuntimeInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/GenericRuntime.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/runtime/SymfonyRuntime.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpKernel.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Controller/ControllerResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Controller/ArgumentResolver.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/RequestStack.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/UriSigner.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ConfigCacheFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/config/ResourceCheckerConfigCacheFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/AbstractAdapterTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/AbstractAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Marshaller/MarshallerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Marshaller/DefaultMarshaller.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Packages.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/PathPackage.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Context/ContextInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/Context/RequestStackContext.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/asset/VersionStrategy/EmptyVersionStrategy.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpCache/SurrogateInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpCache/AbstractSurrogate.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpCache/Esi.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/SurrogateListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/FragmentListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/TranslatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/TranslatorBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/LocaleAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/MessageFormatterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/IntlFormatterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/Formatter/MessageFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation-contracts/TranslatorTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/translation/IdentityTranslator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/monolog/monolog/src/Monolog/Logger.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Log/DebugLoggerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Logger.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Debug/FileLinkFormatter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/stopwatch/Stopwatch.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContextAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/UrlMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Generator/UrlGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RouterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Matcher/RequestMatcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/routing/RequestContext.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/RouterListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/Reader.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Compatibility/AnnotationReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/AnnotationRegistry.php';
            include_once \dirname(__DIR__, 4).'/vendor/doctrine/annotations/lib/Doctrine/Common/Annotations/PsrCachedReader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/PhpArrayAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/ClassResolverTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/CacheClassMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Loader/LoaderChain.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/Loader/AnnotationLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyTypeExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyAccessExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyListExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInitializableExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInfoCacheExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyInfoExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-info/Extractor/ReflectionExtractor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/lock/LockFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/lock/PersistingStoreInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/lock/Store/StoreFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/FilesystemCommonTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Traits/FilesystemTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/cache/Adapter/FilesystemAdapter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-access/PropertyAccessorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/property-access/PropertyAccessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/SessionStorageFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/NativeSessionStorageFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/Handler/AbstractSessionHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/Handler/StrictSessionHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionBagInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Storage/MetadataBag.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/AbstractSessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/EventListener/SessionListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ValidatorBuilder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Validation.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ConstraintValidatorFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/ContainerConstraintValidatorFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/LoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/AutoMappingTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Loader/PropertyInfoLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/mime/MimeTypeGuesserInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/mime/MimeTypesInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/mime/MimeTypes.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/ControllerListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/ParamConverterListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ParamConverter/ParamConverterManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ParamConverter/ParamConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ParamConverter/DoctrineParamConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ParamConverter/DateTimeParamConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/TemplateListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Templating/TemplateGuesser.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/HttpCacheListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/EventListener/IsGrantedListener.php';
            include_once \dirname(__DIR__, 4).'/vendor/sensio/framework-extra-bundle/src/Request/ArgumentNameConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Loader/ChainLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Loader/FilesystemLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/ExtensionInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/AbstractExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/TranslationExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityRepositoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityRepository.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/RateLimiter/RateLimiter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/RateLimiter/RateLimiterFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/rate-limiter/Storage/StorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/rate-limiter/Storage/CacheStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Entity/SalesChannelRepositoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Entity/SalesChannelRepository.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Translation/AbstractTranslator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Translation/Translator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Routing/Router.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/messenger/MessageBusInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/MessageQueue/Monitoring/MonitoringBusDecorator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/messenger/MessageBus.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Event/NestedEventDispatcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Search/EntitySearcherInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/DataAbstractionLayer/ElasticsearchEntitySearcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/EntitySearcher.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/DataAbstractionLayer/AbstractElasticsearchSearchHydrator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/DataAbstractionLayer/ElasticsearchEntitySearchHydrator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Search/EntityAggregatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/DataAbstractionLayer/ElasticsearchEntityAggregator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/EntityAggregator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/DataAbstractionLayer/AbstractElasticsearchAggregationHydrator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/DataAbstractionLayer/ElasticsearchEntityAggregatorHydrator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/DataAbstractionLayer/MediaRepositoryDecorator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/DataAbstractionLayer/PaymentMethodRepositoryDecorator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Context/AbstractSalesChannelContextFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Context/CachedSalesChannelContextFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Context/SalesChannelContextFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Context/AbstractBaseContextFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Context/CachedBaseContextFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Context/BaseContextFactory.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/SerializerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/NormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ContextAwareNormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DenormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ContextAwareDenormalizerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/EncoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/ContextAwareEncoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/DecoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/ContextAwareDecoderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Serializer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/SerializerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/CacheableSupportsMethodInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/SerializerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/UnwrappingDenormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Struct/Serializer/StructNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/NormalizerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/messenger/Transport/Serialization/Normalizer/FlattenExceptionNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ProblemNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/UidNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DateTimeNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ConstraintViolationListNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/NameConverter/NameConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/NameConverter/AdvancedNameConverterInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/NameConverter/MetadataAwareNameConverter.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/MimeMessageNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ObjectToPopulateTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/AbstractNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/AbstractObjectNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/PropertyNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/ClassDiscriminatorResolverInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Mapping/ClassDiscriminatorFromClassMetadata.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DateTimeZoneNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DateIntervalNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/FormErrorNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/BackedEnumNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DataUriNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/JsonSerializableNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DenormalizerAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/DenormalizerAwareTrait.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ArrayDenormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Normalizer/ObjectNormalizer.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Struct/Serializer/StructDecoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Serializer/JsonApiDecoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/NormalizationAwareInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/XmlEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/JsonEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/YamlEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/serializer/Encoder/CsvEncoder.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/CsrfTokenManagerInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/CsrfTokenManager.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Cache/CacheInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Cache/FilesystemCache.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/CoreExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/EscaperExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/OptimizerExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/StagingExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/ExtensionSet.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Template.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/TemplateWrapper.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Environment.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/TwigEnvironment.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/CsrfExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/AssetExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/CodeExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/RoutingExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/YamlExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/StopwatchExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/HttpKernelExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/HttpFoundationExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/UrlHelper.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Extension/SerializerExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/NodeExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/PhpSyntaxExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/FeatureFlagExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/intl-extra/IntlExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/string-extra/StringExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/InstanceOfExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Filter/CurrencyFilter.php';
            include_once \dirname(__DIR__, 4).'/vendor/cocur/slugify/src/Bridge/Twig/SlugifyExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Filter/ReplaceRecursiveFilter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/SeoUrlFunctionExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/CategoryUrlExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/Service/AbstractCategoryUrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/Service/CategoryUrlGenerator.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/MediaExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/RawUrlFunctionExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/SwSanitizeTwigFilter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/Extension/BuildBreadcrumbExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Profiling/Twig/DoctrineExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/Extension/GlobalsInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/TemplateDataExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/Extension/ConfigExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/TemplateConfigAccessor.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/IconExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/ThumbnailExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/Extension/UrlEncodingTwigFilter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/Extension/IconCacheTwigFilter.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/Extension/CsrfFunctionExtension.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/AppVariable.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/TwigAppVariable.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/RuntimeLoader/RuntimeLoaderInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/twig/twig/src/RuntimeLoader/ContainerRuntimeLoader.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bundle/DependencyInjection/Configurator/EnvironmentConfigurator.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Mapping/Factory/MetadataFactoryInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/symfony/validator/Validator/ValidatorInterface.php';
            include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Validation/HappyPathValidator.php';
            include_once __DIR__.'/proxy-classes.php';
        };
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return require $this->containerDir.\DIRECTORY_SEPARATOR.'removed-ids.php';
    }

    protected function createProxy($class, \Closure $factory)
    {
        return $factory();
    }

    /*
     * Gets the public '.container.private.cache_clearer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheClearer\ChainCacheClearer
     */
    protected function get_Container_Private_CacheClearerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheClearer/ChainCacheClearer.php';

        return $this->services['.container.private.cache_clearer'] = new \Symfony\Component\HttpKernel\CacheClearer\ChainCacheClearer(new RewindableGenerator(function () {
            yield 0 => ($this->services['cache.system_clearer'] ?? $this->getCache_SystemClearerService());
        }, 1));
    }

    /*
     * Gets the public '.container.private.filesystem' shared service.
     *
     * @return \Symfony\Component\Filesystem\Filesystem
     */
    protected function get_Container_Private_FilesystemService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/filesystem/Filesystem.php';

        return $this->services['.container.private.filesystem'] = new \Symfony\Component\Filesystem\Filesystem();
    }

    /*
     * Gets the public '.container.private.security.csrf.token_manager' shared service.
     *
     * @return \Symfony\Component\Security\Csrf\CsrfTokenManager
     */
    protected function get_Container_Private_Security_Csrf_TokenManagerService()
    {
        $a = ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()));

        return $this->services['.container.private.security.csrf.token_manager'] = new \Symfony\Component\Security\Csrf\CsrfTokenManager(new \Symfony\Component\Security\Csrf\TokenGenerator\UriSafeTokenGenerator(), new \Symfony\Component\Security\Csrf\TokenStorage\SessionTokenStorage($a), $a);
    }

    /*
     * Gets the public '.container.private.serializer' shared service.
     *
     * @return \Symfony\Component\Serializer\Serializer
     */
    protected function get_Container_Private_SerializerService()
    {
        $a = ($this->privates['property_info.reflection_extractor'] ?? ($this->privates['property_info.reflection_extractor'] = new \Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor()));

        $b = new \Symfony\Component\PropertyAccess\PropertyAccessor(3, 2, ($this->privates['cache.property_access'] ?? $this->getCache_PropertyAccessService()), $a, $a);
        $c = ($this->privates['serializer.mapping.cache_class_metadata_factory'] ?? $this->getSerializer_Mapping_CacheClassMetadataFactoryService());

        $d = new \Symfony\Component\Serializer\NameConverter\MetadataAwareNameConverter($c);
        $e = ($this->privates['property_info.cache'] ?? $this->getPropertyInfo_CacheService());
        $f = new \Symfony\Component\Serializer\Mapping\ClassDiscriminatorFromClassMetadata($c);

        return $this->services['.container.private.serializer'] = new \Symfony\Component\Serializer\Serializer([0 => new \Symfony\Component\Serializer\Normalizer\UnwrappingDenormalizer($b), 1 => new \Shopware\Core\Framework\Struct\Serializer\StructNormalizer(), 2 => new \Symfony\Component\Messenger\Transport\Serialization\Normalizer\FlattenExceptionNormalizer(), 3 => new \Symfony\Component\Serializer\Normalizer\ProblemNormalizer(false), 4 => new \Symfony\Component\Serializer\Normalizer\UidNormalizer(), 5 => new \Symfony\Component\Serializer\Normalizer\DateTimeNormalizer(), 6 => new \Symfony\Component\Serializer\Normalizer\ConstraintViolationListNormalizer([], $d), 7 => new \Symfony\Component\Serializer\Normalizer\MimeMessageNormalizer(new \Symfony\Component\Serializer\Normalizer\PropertyNormalizer($c, $d, $e, $f, NULL)), 8 => new \Symfony\Component\Serializer\Normalizer\DateTimeZoneNormalizer(), 9 => new \Symfony\Component\Serializer\Normalizer\DateIntervalNormalizer(), 10 => new \Symfony\Component\Serializer\Normalizer\FormErrorNormalizer(), 11 => new \Symfony\Component\Serializer\Normalizer\BackedEnumNormalizer(), 12 => new \Symfony\Component\Serializer\Normalizer\DataUriNormalizer(($this->privates['mime_types'] ?? $this->getMimeTypesService())), 13 => new \Symfony\Component\Serializer\Normalizer\JsonSerializableNormalizer(NULL, NULL), 14 => new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), 15 => new \Symfony\Component\Serializer\Normalizer\ObjectNormalizer($c, $d, $b, $e, $f, NULL)], [0 => new \Shopware\Core\Framework\Struct\Serializer\StructDecoder(), 1 => new \Shopware\Core\Framework\Api\Serializer\JsonApiDecoder(), 2 => new \Symfony\Component\Serializer\Encoder\XmlEncoder(), 3 => new \Symfony\Component\Serializer\Encoder\JsonEncoder(NULL, NULL), 4 => new \Symfony\Component\Serializer\Encoder\YamlEncoder(NULL, NULL), 5 => new \Symfony\Component\Serializer\Encoder\CsvEncoder()]);
    }

    /*
     * Gets the public '.container.private.session' shared service.
     *
     * @return \Symfony\Component\HttpFoundation\Session\Session
     */
    protected function get_Container_Private_SessionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/SessionInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-foundation/Session/Session.php';

        $a = ($this->privates['session.factory'] ?? $this->getSession_FactoryService());

        if (isset($this->services['.container.private.session'])) {
            return $this->services['.container.private.session'];
        }

        return $this->services['.container.private.session'] = $a->createSession();
    }

    /*
     * Gets the public '.container.private.twig' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Twig\TwigEnvironment
     */
    protected function get_Container_Private_TwigService()
    {
        $this->services['.container.private.twig'] = $instance = new \Shopware\Core\Framework\Adapter\Twig\TwigEnvironment(($this->privates['twig.loader.chain'] ?? $this->getTwig_Loader_ChainService()), ['debug' => false, 'strict_variables' => false, 'autoescape' => 'name', 'cache' => ($this->targetDir.''.'/twig'), 'charset' => 'UTF-8']);

        $a = ($this->services['router'] ?? $this->getRouterService());

        $b = new \Symfony\Bridge\Twig\Extension\RoutingExtension($a);
        $c = ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack()));
        $d = ($this->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder'] ?? $this->getTemplateFinderService());
        $e = ($this->services['Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface'] ?? $this->getSeoUrlPlaceholderHandlerInterfaceService());
        $f = new \Symfony\Bridge\Twig\AppVariable();
        $f->setEnvironment('prod');
        $f->setDebug(false);
        if ($this->has('request_stack')) {
            $f->setRequestStack($c);
        }

        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CsrfExtension());
        $instance->addExtension(($this->privates['twig.extension.trans'] ?? $this->getTwig_Extension_TransService()));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\AssetExtension(($this->privates['assets.packages'] ?? $this->getAssets_PackagesService())));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\CodeExtension(($this->privates['debug.file_link_formatter'] ?? ($this->privates['debug.file_link_formatter'] = new \Symfony\Component\HttpKernel\Debug\FileLinkFormatter(NULL))), \dirname(__DIR__, 4), 'UTF-8'));
        $instance->addExtension($b);
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\YamlExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\StopwatchExtension(($this->privates['debug.stopwatch'] ?? ($this->privates['debug.stopwatch'] = new \Symfony\Component\Stopwatch\Stopwatch(true))), false));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpKernelExtension());
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\HttpFoundationExtension(new \Symfony\Component\HttpFoundation\UrlHelper($c, $a)));
        $instance->addExtension(new \Symfony\Bridge\Twig\Extension\SerializerExtension());
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\NodeExtension($d));
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\PhpSyntaxExtension());
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\FeatureFlagExtension());
        $instance->addExtension(new \Twig\Extra\Intl\IntlExtension());
        $instance->addExtension(new \Twig\Extra\String\StringExtension());
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\InstanceOfExtension());
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Filter\CurrencyFilter(($this->services['Shopware\\Core\\System\\Currency\\CurrencyFormatter'] ?? $this->getCurrencyFormatterService())));
        $instance->addExtension(new \Cocur\Slugify\Bridge\Twig\SlugifyExtension(($this->privates['slugify'] ?? $this->getSlugifyService())));
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Filter\ReplaceRecursiveFilter());
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\SeoUrlFunctionExtension($b, $e));
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\CategoryUrlExtension($b, new \Shopware\Core\Content\Category\Service\CategoryUrlGenerator($e)));
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\MediaExtension(($this->services['media.repository'] ?? $this->getMedia_RepositoryService())));
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\RawUrlFunctionExtension($a, $c));
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter(($this->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] ?? $this->getHtmlSanitizerService())));
        $instance->addExtension(new \Shopware\Core\Framework\Adapter\Twig\Extension\BuildBreadcrumbExtension(($this->privates['Shopware\\Core\\Content\\Category\\Service\\CategoryBreadcrumbBuilder'] ?? $this->getCategoryBreadcrumbBuilderService()), ($this->services['category.repository'] ?? $this->getCategory_RepositoryService())));
        $instance->addExtension(new \Shopware\Core\Profiling\Twig\DoctrineExtension());
        $instance->addExtension(new \Shopware\Storefront\Framework\Twig\TemplateDataExtension($c, true, 'twig'));
        $instance->addExtension(new \Shopware\Storefront\Framework\Twig\Extension\ConfigExtension(new \Shopware\Storefront\Framework\Twig\TemplateConfigAccessor(($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->privates['Shopware\\Storefront\\Theme\\ThemeConfigValueAccessor'] ?? $this->getThemeConfigValueAccessorService()))));
        $instance->addExtension(new \Shopware\Storefront\Framework\Twig\IconExtension($d));
        $instance->addExtension(new \Shopware\Storefront\Framework\Twig\ThumbnailExtension($d));
        $instance->addExtension(new \Shopware\Storefront\Framework\Twig\Extension\UrlEncodingTwigFilter());
        $instance->addExtension(new \Shopware\Storefront\Framework\Twig\Extension\IconCacheTwigFilter());
        $instance->addExtension(new \Shopware\Storefront\Framework\Twig\Extension\CsrfFunctionExtension());
        $instance->addGlobal('app', new \Shopware\Storefront\Framework\Twig\TwigAppVariable($f, $this->parameters['shopware.twig.app_variable.allowed_server_params']));
        $instance->addRuntimeLoader(new \Twig\RuntimeLoader\ContainerRuntimeLoader(new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => ['privates', 'twig.runtime.security_csrf', 'getTwig_Runtime_SecurityCsrfService', false],
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => ['privates', 'twig.runtime.httpkernel', 'getTwig_Runtime_HttpkernelService', false],
            'Symfony\\Bridge\\Twig\\Extension\\SerializerRuntime' => ['privates', 'twig.runtime.serializer', 'getTwig_Runtime_SerializerService', false],
        ], [
            'Symfony\\Bridge\\Twig\\Extension\\CsrfRuntime' => '?',
            'Symfony\\Bridge\\Twig\\Extension\\HttpKernelRuntime' => '?',
            'Symfony\\Bridge\\Twig\\Extension\\SerializerRuntime' => '?',
        ])));
        (new \Symfony\Bundle\TwigBundle\DependencyInjection\Configurator\EnvironmentConfigurator('F j, Y H:i', '%d days', NULL, 0, '.', ','))->configure($instance);

        return $instance;
    }

    /*
     * Gets the public '.container.private.validator' shared service.
     *
     * @return \Shopware\Core\Framework\Validation\HappyPathValidator
     */
    protected function get_Container_Private_ValidatorService()
    {
        $a = ($this->privates['validator.builder'] ?? $this->getValidator_BuilderService());

        if (isset($this->services['.container.private.validator'])) {
            return $this->services['.container.private.validator'];
        }

        return $this->services['.container.private.validator'] = new \Shopware\Core\Framework\Validation\HappyPathValidator($a->getValidator());
    }

    /*
     * Gets the public 'Doctrine\DBAL\Connection' shared service.
     *
     * @return \Doctrine\DBAL\Connection
     */
    protected function getConnectionService()
    {
        return $this->services['Doctrine\\DBAL\\Connection'] = \Shopware\Core\Kernel::getConnection();
    }

    /*
     * Gets the public 'Elasticsearch\Client' shared service.
     *
     * @return \Elasticsearch\Client
     */
    protected function getClientService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['Elasticsearch\\Client'] = $this->createProxy('Client_dba3ed3', function () {
                return \Client_dba3ed3::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getClientService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/ClientFactory.php';

        return \Shopware\Elasticsearch\Framework\ClientFactory::createClient($this->getEnv('string:OPENSEARCH_URL'), ($this->privates['shopware.elasticsearch.logger'] ?? $this->getShopware_Elasticsearch_LoggerService()), false, $this->parameters['elasticsearch.ssl']);
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdminExtensionApiController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdminExtensionApiController
     */
    protected function getAdminExtensionApiControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Controller/AdminExtensionApiController.php';

        $this->services['Shopware\\Administration\\Controller\\AdminExtensionApiController'] = $instance = new \Shopware\Administration\Controller\AdminExtensionApiController(($this->privates['Shopware\\Core\\Framework\\App\\ActionButton\\Executor'] ?? $this->getExecutorService()), ($this->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'] ?? $this->getShopIdProviderService()), ($this->services['app.repository'] ?? $this->getApp_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\App\\Hmac\\QuerySigner'] ?? $this->getQuerySignerService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdminProductStreamController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdminProductStreamController
     */
    protected function getAdminProductStreamControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Controller/AdminProductStreamController.php';

        $this->services['Shopware\\Administration\\Controller\\AdminProductStreamController'] = $instance = new \Shopware\Administration\Controller\AdminProductStreamController(($this->services['Shopware\\Core\\Content\\Product\\ProductDefinition'] ?? $this->getProductDefinitionService()), ($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? $this->getSalesChannelContextServiceService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? $this->getRequestCriteriaBuilderService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdminSearchController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdminSearchController
     */
    protected function getAdminSearchControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Controller/AdminSearchController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Service/AdminSearcher.php';

        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService());

        $this->services['Shopware\\Administration\\Controller\\AdminSearchController'] = $instance = new \Shopware\Administration\Controller\AdminSearchController(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? $this->getRequestCriteriaBuilderService()), $a, new \Shopware\Administration\Service\AdminSearcher($a), ($this->services['.container.private.serializer'] ?? $this->get_Container_Private_SerializerService()), ($this->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] ?? $this->getAclCriteriaValidatorService()), $a, ($this->privates['Shopware\\Core\\Framework\\Api\\Serializer\\JsonEntityEncoder'] ?? $this->getJsonEntityEncoderService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdminTagController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdminTagController
     */
    protected function getAdminTagControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Controller/AdminTagController.php';

        $this->services['Shopware\\Administration\\Controller\\AdminTagController'] = $instance = new \Shopware\Administration\Controller\AdminTagController(($this->services['Shopware\\Core\\System\\Tag\\Service\\FilterTagIdsService'] ?? $this->getFilterTagIdsServiceService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\AdministrationController' shared service.
     *
     * @return \Shopware\Administration\Controller\AdministrationController
     */
    protected function getAdministrationControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Controller/AdministrationController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Snippet/SnippetFinderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Snippet/CachedSnippetFinder.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Snippet/SnippetFinder.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Framework/Routing/KnownIps/KnownIpsCollectorInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Framework/Routing/KnownIps/KnownIpsCollector.php';

        $a = ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService());

        $this->services['Shopware\\Administration\\Controller\\AdministrationController'] = $instance = new \Shopware\Administration\Controller\AdministrationController(($this->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder'] ?? $this->getTemplateFinderService()), ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\FirstRunWizardClient'] ?? $this->getFirstRunWizardClientService()), new \Shopware\Administration\Snippet\CachedSnippetFinder(new \Shopware\Administration\Snippet\SnippetFinder(($this->services['kernel'] ?? $this->get('kernel', 1)), $a), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService())), $this->parameters['kernel.supported_api_versions'], new \Shopware\Administration\Framework\Routing\KnownIps\KnownIpsCollector(), $a, ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), (\dirname(__DIR__, 4).'/vendor/shopware/core'), ($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['currency.repository'] ?? $this->getCurrency_RepositoryService()), ($this->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] ?? $this->getHtmlSanitizerService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\DocumentServiceDeprecationController' shared service.
     *
     * @return \Shopware\Administration\Controller\DocumentServiceDeprecationController
     */
    protected function getDocumentServiceDeprecationControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Controller/DocumentServiceDeprecationController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/FileGenerator/FileGeneratorInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/FileGenerator/PdfGenerator.php';

        return $this->services['Shopware\\Administration\\Controller\\DocumentServiceDeprecationController'] = new \Shopware\Administration\Controller\DocumentServiceDeprecationController(($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentService'] ?? $this->getDocumentServiceService()), ($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentGenerator\\DocumentGeneratorRegistry'] ?? $this->getDocumentGeneratorRegistryService()), ($this->privates['Shopware\\Core\\Checkout\\Document\\FileGenerator\\PdfGenerator'] ?? ($this->privates['Shopware\\Core\\Checkout\\Document\\FileGenerator\\PdfGenerator'] = new \Shopware\Core\Checkout\Document\FileGenerator\PdfGenerator())), ($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentGenerator\\InvoiceGenerator'] ?? $this->getInvoiceGeneratorService()), ($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentGenerator\\DeliveryNoteGenerator'] ?? $this->getDeliveryNoteGeneratorService()), ($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentGenerator\\StornoGenerator'] ?? $this->getStornoGeneratorService()), ($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentGenerator\\CreditNoteGenerator'] ?? $this->getCreditNoteGeneratorService()), ($this->services['Shopware\\Core\\Checkout\\Document\\DocumentGeneratorController'] ?? $this->getDocumentGeneratorControllerService()), ($this->services['Shopware\\Core\\Checkout\\Document\\Controller\\DocumentController'] ?? $this->getDocumentControllerService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\NotificationController' shared service.
     *
     * @return \Shopware\Administration\Controller\NotificationController
     */
    protected function getNotificationControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Controller/NotificationController.php';

        $this->services['Shopware\\Administration\\Controller\\NotificationController'] = $instance = new \Shopware\Administration\Controller\NotificationController(($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService()), ($this->services['Shopware\\Administration\\Notification\\NotificationService'] ?? $this->getNotificationServiceService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Controller\UserConfigController' shared service.
     *
     * @return \Shopware\Administration\Controller\UserConfigController
     */
    protected function getUserConfigControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Controller/UserConfigController.php';

        $this->services['Shopware\\Administration\\Controller\\UserConfigController'] = $instance = new \Shopware\Administration\Controller\UserConfigController(($this->services['user_config.repository'] ?? $this->getUserConfig_RepositoryService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Notification\NotificationDefinition' shared service.
     *
     * @return \Shopware\Administration\Notification\NotificationDefinition
     */
    protected function getNotificationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Notification/NotificationDefinition.php';

        $this->services['Shopware\\Administration\\Notification\\NotificationDefinition'] = $instance = new \Shopware\Administration\Notification\NotificationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Administration\Notification\NotificationService' shared service.
     *
     * @return \Shopware\Administration\Notification\NotificationService
     */
    protected function getNotificationServiceService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Notification/NotificationService.php';

        return $this->services['Shopware\\Administration\\Notification\\NotificationService'] = new \Shopware\Administration\Notification\NotificationService(($this->services['notification.repository'] ?? $this->getNotification_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Administration\Snippet\AppAdministrationSnippetDefinition' shared service.
     *
     * @return \Shopware\Administration\Snippet\AppAdministrationSnippetDefinition
     */
    protected function getAppAdministrationSnippetDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/administration/Snippet/AppAdministrationSnippetDefinition.php';

        $this->services['Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition'] = $instance = new \Shopware\Administration\Snippet\AppAdministrationSnippetDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\Calculator' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\Calculator
     */
    protected function getCalculatorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Calculator.php';

        return $this->services['Shopware\\Core\\Checkout\\Cart\\Calculator'] = new \Shopware\Core\Checkout\Cart\Calculator(($this->privates['Shopware\\Core\\Checkout\\Cart\\Price\\QuantityPriceCalculator'] ?? $this->getQuantityPriceCalculatorService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Price\\PercentagePriceCalculator'] ?? $this->getPercentagePriceCalculatorService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Price\\AbsolutePriceCalculator'] ?? $this->getAbsolutePriceCalculatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\Facade\CartFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\Facade\CartFacadeHookFactory
     */
    protected function getCartFacadeHookFactoryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Execution/Awareness/HookServiceFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Facade/CartFacadeHookFactory.php';

        return $this->services['Shopware\\Core\\Checkout\\Cart\\Facade\\CartFacadeHookFactory'] = new \Shopware\Core\Checkout\Cart\Facade\CartFacadeHookFactory(($this->privates['Shopware\\Core\\Checkout\\Cart\\Facade\\CartFacadeHelper'] ?? $this->getCartFacadeHelperService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\Order\Api\OrderConverterController' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\Order\Api\OrderConverterController
     */
    protected function getOrderConverterControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Order/Api/OrderConverterController.php';

        $this->services['Shopware\\Core\\Checkout\\Cart\\Order\\Api\\OrderConverterController'] = $instance = new \Shopware\Core\Checkout\Cart\Order\Api\OrderConverterController(($this->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? $this->getOrderConverterService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? $this->getCartPersisterService()), ($this->services['order.repository'] ?? $this->getOrder_RepositoryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\Order\Api\OrderRecalculationController' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\Order\Api\OrderRecalculationController
     */
    protected function getOrderRecalculationControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Order/Api/OrderRecalculationController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Order/RecalculationService.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Cart/PromotionItemBuilder.php';

        $this->services['Shopware\\Core\\Checkout\\Cart\\Order\\Api\\OrderRecalculationController'] = $instance = new \Shopware\Core\Checkout\Cart\Order\Api\OrderRecalculationController(new \Shopware\Core\Checkout\Cart\Order\RecalculationService(($this->services['order.repository'] ?? $this->getOrder_RepositoryService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? $this->getOrderConverterService()), ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? $this->getCartServiceService()), ($this->services['product.repository'] ?? $this->getProduct_RepositoryService()), ($this->services['order_address.repository'] ?? $this->getOrderAddress_RepositoryService()), ($this->services['customer_address.repository'] ?? $this->getCustomerAddress_RepositoryService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Processor'] ?? $this->getProcessorService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartRuleLoader'] ?? $this->getCartRuleLoaderService()), ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\PromotionItemBuilder'] ?? ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\PromotionItemBuilder'] = new \Shopware\Core\Checkout\Promotion\Cart\PromotionItemBuilder()))));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\PriceActionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\PriceActionController
     */
    protected function getPriceActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/PriceActionController.php';

        $this->services['Shopware\\Core\\Checkout\\Cart\\PriceActionController'] = $instance = new \Shopware\Core\Checkout\Cart\PriceActionController(($this->services['tax.repository'] ?? $this->getTax_RepositoryService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Price\\NetPriceCalculator'] ?? $this->getNetPriceCalculatorService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Price\\GrossPriceCalculator'] ?? $this->getGrossPriceCalculatorService()), ($this->services['currency.repository'] ?? $this->getCurrency_RepositoryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartDeleteRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartDeleteRoute
     */
    protected function getCartDeleteRouteService()
    {
        $a = ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? $this->getCartPersisterService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartDeleteRoute($a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartItemAddRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartItemAddRoute
     */
    protected function getCartItemAddRouteService()
    {
        $a = ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? $this->getCartPersisterService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'];
        }
        $c = ($this->privates['Shopware\\Core\\Checkout\\Cart\\LineItemFactoryRegistry'] ?? $this->getLineItemFactoryRegistryService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'];
        }
        $d = ($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartItemAddRoute(($this->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? $this->getCartCalculatorService()), $a, $b, $c, $d);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartItemRemoveRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartItemRemoveRoute
     */
    protected function getCartItemRemoveRouteService()
    {
        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'];
        }
        $b = ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? $this->getCartPersisterService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartItemRemoveRoute($a, ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? $this->getCartCalculatorService()), $b);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartItemUpdateRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartItemUpdateRoute
     */
    protected function getCartItemUpdateRouteService()
    {
        $a = ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? $this->getCartPersisterService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'];
        }
        $b = ($this->privates['Shopware\\Core\\Checkout\\Cart\\LineItemFactoryRegistry'] ?? $this->getLineItemFactoryRegistryService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartItemUpdateRoute($a, ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? $this->getCartCalculatorService()), $b, $c);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartLoadRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartLoadRoute
     */
    protected function getCartLoadRouteService()
    {
        $a = ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? $this->getCartPersisterService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartLoadRoute($a, $b, ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? $this->getCartCalculatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartOrderRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartOrderRoute
     */
    protected function getCartOrderRouteService()
    {
        $a = ($this->services['order.repository'] ?? $this->getOrder_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $b = ($this->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? $this->getOrderConverterService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $c = ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? $this->getCartPersisterService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $e = ($this->privates['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentHandler\\PaymentHandlerRegistry'] ?? $this->getPaymentHandlerRegistryService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }
        $f = ($this->services['app_payment_method.repository'] ?? $this->getAppPaymentMethod_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartOrderRoute(($this->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? $this->getCartCalculatorService()), $a, new \Shopware\Core\Checkout\Cart\Order\OrderPersister($a, $b), $c, $d, new \Shopware\Core\Checkout\Payment\PreparedPaymentService($e, $f, ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()), ($this->privates['Shopware\\Core\\System\\StateMachine\\Loader\\InitialStateIdLoader'] ?? $this->getInitialStateIdLoaderService())));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Cart\SalesChannel\CartService' shared service.
     *
     * @return \Shopware\Core\Checkout\Cart\SalesChannel\CartService
     */
    protected function getCartServiceService()
    {
        $a = ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartPersister'] ?? $this->getCartPersisterService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'];
        }
        $b = ($this->privates['Shopware\\Core\\Framework\\Event\\BusinessEventDispatcher'] ?? $this->getBusinessEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'];
        }
        $c = ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartCalculator'] ?? $this->getCartCalculatorService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'];
        }
        $d = ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartLoadRoute'] ?? $this->getCartLoadRouteService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'];
        }
        $e = ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartDeleteRoute'] ?? $this->getCartDeleteRouteService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'];
        }
        $f = ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemAddRoute'] ?? $this->getCartItemAddRouteService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'];
        }
        $g = ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemUpdateRoute'] ?? $this->getCartItemUpdateRouteService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'];
        }
        $h = ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartItemRemoveRoute'] ?? $this->getCartItemRemoveRouteService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'];
        }
        $i = ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'] ?? $this->getCartOrderRouteService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'])) {
            return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] = new \Shopware\Core\Checkout\Cart\SalesChannel\CartService($a, $b, $c, $d, $e, $f, $g, $h, $i);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerAddress\CustomerAddressDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerAddress\CustomerAddressDefinition
     */
    protected function getCustomerAddressDefinitionService()
    {
        $this->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerAddress\CustomerAddressDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupRegistrationSalesChannel\CustomerGroupRegistrationSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupRegistrationSalesChannel\CustomerGroupRegistrationSalesChannelDefinition
     */
    protected function getCustomerGroupRegistrationSalesChannelDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Aggregate/CustomerGroupRegistrationSalesChannel/CustomerGroupRegistrationSalesChannelDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupRegistrationSalesChannel\CustomerGroupRegistrationSalesChannelDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupTranslation\CustomerGroupTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupTranslation\CustomerGroupTranslationDefinition
     */
    protected function getCustomerGroupTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Aggregate/CustomerGroupTranslation/CustomerGroupTranslationDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroupTranslation\CustomerGroupTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerGroup\CustomerGroupDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroup\CustomerGroupDefinition
     */
    protected function getCustomerGroupDefinitionService()
    {
        $this->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerGroup\CustomerGroupDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerRecovery\CustomerRecoveryDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerRecovery\CustomerRecoveryDefinition
     */
    protected function getCustomerRecoveryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Aggregate/CustomerRecovery/CustomerRecoveryDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerRecovery\CustomerRecoveryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerTag\CustomerTagDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerTag\CustomerTagDefinition
     */
    protected function getCustomerTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Aggregate/CustomerTag/CustomerTagDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerTag\CustomerTagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlistProduct\CustomerWishlistProductDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlistProduct\CustomerWishlistProductDefinition
     */
    protected function getCustomerWishlistProductDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Aggregate/CustomerWishlistProduct/CustomerWishlistProductDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlistProduct\CustomerWishlistProductDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlist\CustomerWishlistDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlist\CustomerWishlistDefinition
     */
    protected function getCustomerWishlistDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Aggregate/CustomerWishlist/CustomerWishlistDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\Aggregate\CustomerWishlist\CustomerWishlistDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\Api\CustomerGroupRegistrationActionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\Api\CustomerGroupRegistrationActionController
     */
    protected function getCustomerGroupRegistrationActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Api/CustomerGroupRegistrationActionController.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\Api\\CustomerGroupRegistrationActionController'] = new \Shopware\Core\Checkout\Customer\Api\CustomerGroupRegistrationActionController(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['customer_group.repository'] ?? $this->getCustomerGroup_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextRestorer'] ?? $this->getSalesChannelContextRestorerService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\CustomerDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\CustomerDefinition
     */
    protected function getCustomerDefinitionService()
    {
        $this->services['Shopware\\Core\\Checkout\\Customer\\CustomerDefinition'] = $instance = new \Shopware\Core\Checkout\Customer\CustomerDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\AccountNewsletterRecipientRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\AccountNewsletterRecipientRoute
     */
    protected function getAccountNewsletterRecipientRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractAccountNewsletterRecipientRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AccountNewsletterRecipientRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountNewsletterRecipientRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\AccountNewsletterRecipientRoute(($this->services['sales_channel.newsletter_recipient.repository'] ?? $this->getSalesChannel_NewsletterRecipient_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\AddWishlistProductRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\AddWishlistProductRoute
     */
    protected function getAddWishlistProductRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractAddWishlistProductRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AddWishlistProductRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AddWishlistProductRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\AddWishlistProductRoute(($this->services['customer_wishlist.repository'] ?? $this->getCustomerWishlist_RepositoryService()), ($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ChangeCustomerProfileRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ChangeCustomerProfileRoute
     */
    protected function getChangeCustomerProfileRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractChangeCustomerProfileRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/ChangeCustomerProfileRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeCustomerProfileRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ChangeCustomerProfileRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\CustomerProfileValidationFactory'] ?? $this->getCustomerProfileValidationFactoryService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\StoreApiCustomFieldMapper'] ?? $this->getStoreApiCustomFieldMapperService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ChangeEmailRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ChangeEmailRoute
     */
    protected function getChangeEmailRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractChangeEmailRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/ChangeEmailRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeEmailRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ChangeEmailRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ChangeLanguageRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ChangeLanguageRoute
     */
    protected function getChangeLanguageRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractChangeLanguageRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/ChangeLanguageRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeLanguageRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ChangeLanguageRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ChangePasswordRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ChangePasswordRoute
     */
    protected function getChangePasswordRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractChangePasswordRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/ChangePasswordRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangePasswordRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ChangePasswordRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ChangePaymentMethodRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ChangePaymentMethodRoute
     */
    protected function getChangePaymentMethodRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractChangePaymentMethodRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/ChangePaymentMethodRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangePaymentMethodRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ChangePaymentMethodRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['payment_method.repository'] ?? $this->getPaymentMethod_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\CustomerGroupRegistrationSettingsRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\CustomerGroupRegistrationSettingsRoute
     */
    protected function getCustomerGroupRegistrationSettingsRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractCustomerGroupRegistrationSettingsRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/CustomerGroupRegistrationSettingsRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerGroupRegistrationSettingsRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\CustomerGroupRegistrationSettingsRoute(($this->services['customer_group.repository'] ?? $this->getCustomerGroup_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\CustomerRecoveryIsExpiredRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\CustomerRecoveryIsExpiredRoute
     */
    protected function getCustomerRecoveryIsExpiredRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractCustomerRecoveryIsExpiredRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/CustomerRecoveryIsExpiredRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRecoveryIsExpiredRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\CustomerRecoveryIsExpiredRoute(($this->services['customer_recovery.repository'] ?? $this->getCustomerRecovery_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\CustomerRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\CustomerRoute
     */
    protected function getCustomerRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractCustomerRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/CustomerRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\CustomerRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\DeleteAddressRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\DeleteAddressRoute
     */
    protected function getDeleteAddressRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractDeleteAddressRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/CustomerAddressValidationTrait.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/DeleteAddressRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteAddressRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\DeleteAddressRoute(($this->services['customer_address.repository'] ?? $this->getCustomerAddress_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\DeleteCustomerRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\DeleteCustomerRoute
     */
    protected function getDeleteCustomerRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractDeleteCustomerRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/DeleteCustomerRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteCustomerRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\DeleteCustomerRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ListAddressRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ListAddressRoute
     */
    protected function getListAddressRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractListAddressRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/ListAddressRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ListAddressRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ListAddressRoute(($this->services['customer_address.repository'] ?? $this->getCustomerAddress_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\LoadWishlistRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\LoadWishlistRoute
     */
    protected function getLoadWishlistRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractLoadWishlistRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/LoadWishlistRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/AbstractProductCloseoutFilterFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/ProductCloseoutFilterFactory.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoadWishlistRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\LoadWishlistRoute(($this->services['customer_wishlist.repository'] ?? $this->getCustomerWishlist_RepositoryService()), ($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] = new \Shopware\Core\Content\Product\SalesChannel\ProductCloseoutFilterFactory())));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\LoginRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\LoginRoute
     */
    protected function getLoginRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractLoginRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/LoginRoute.php';

        $a = new \Shopware\Core\Framework\RateLimiter\RateLimiter();

        $b = ($this->privates['cache.rate_limiter'] ?? $this->getCache_RateLimiterService());
        $c = ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService());
        $d = ($this->privates['lock.default.factory'] ?? $this->getLock_Default_FactoryService());

        $a->registerLimiterFactory('login', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $this->parameters['shopware.api.rate_limiter.login.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'login'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('guest_login', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $this->parameters['shopware.api.rate_limiter.login.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'guest_login'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('oauth', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $this->parameters['shopware.api.rate_limiter.login.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'oauth'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('reset_password', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $this->parameters['shopware.api.rate_limiter.reset_password.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'reset_password'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('user_recovery', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $this->parameters['shopware.api.rate_limiter.reset_password.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'user_recovery'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('contact_form', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $this->parameters['shopware.api.rate_limiter.reset_password.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'contact_form'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('notification', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $this->parameters['shopware.api.rate_limiter.login.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'notification'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('newsletter_form', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'time_backoff', 'reset' => '24 hours', 'limits' => $this->parameters['shopware.api.rate_limiter.reset_password.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'newsletter_form'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));
        $a->registerLimiterFactory('cart_add_line_item', new \Shopware\Core\Framework\RateLimiter\RateLimiterFactory(['enabled' => true, 'policy' => 'system_config', 'reset' => '1 hours', 'limits' => $this->parameters['shopware.api.rate_limiter.cart_add_line_item.limits'], 'lock_factory' => 'lock.factory', 'cache_pool' => 'cache.rate_limiter', 'id' => 'cart_add_line_item'], new \Symfony\Component\RateLimiter\Storage\CacheStorage($b), $c, $d));

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoginRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\LoginRoute(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->privates['Shopware\\Core\\Checkout\\Customer\\Password\\LegacyPasswordVerifier'] ?? $this->getLegacyPasswordVerifierService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\CartRestorer'] ?? $this->getCartRestorerService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), $a);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\LogoutRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\LogoutRoute
     */
    protected function getLogoutRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractLogoutRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/LogoutRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\LogoutRoute(($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? $this->getSalesChannelContextPersisterService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? $this->getCartServiceService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\MergeWishlistProductRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\MergeWishlistProductRoute
     */
    protected function getMergeWishlistProductRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractMergeWishlistProductRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/MergeWishlistProductRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\MergeWishlistProductRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\MergeWishlistProductRoute(($this->services['customer_wishlist.repository'] ?? $this->getCustomerWishlist_RepositoryService()), ($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\RegisterConfirmRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\RegisterConfirmRoute
     */
    protected function getRegisterConfirmRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractRegisterConfirmRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/RegisterConfirmRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterConfirmRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\RegisterConfirmRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? $this->getSalesChannelContextPersisterService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? $this->getSalesChannelContextServiceService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\RegisterRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\RegisterRoute
     */
    protected function getRegisterRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractRegisterRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/RegisterRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Validation/DataValidationFactoryInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/Validation/CustomerValidationFactory.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\RegisterRoute(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'] ?? $this->getNumberRangeValueGeneratorInterfaceService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), new \Shopware\Core\Checkout\Customer\Validation\CustomerValidationFactory(($this->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\CustomerProfileValidationFactory'] ?? $this->getCustomerProfileValidationFactoryService())), ($this->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\AddressValidationFactory'] ?? $this->getAddressValidationFactoryService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? $this->getSalesChannelContextPersisterService()), ($this->services['sales_channel.country.repository'] ?? $this->getSalesChannel_Country_RepositoryService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? $this->getSalesChannelContextServiceService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\StoreApiCustomFieldMapper'] ?? $this->getStoreApiCustomFieldMapperService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\RemoveWishlistProductRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\RemoveWishlistProductRoute
     */
    protected function getRemoveWishlistProductRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractRemoveWishlistProductRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/RemoveWishlistProductRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RemoveWishlistProductRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\RemoveWishlistProductRoute(($this->services['customer_wishlist.repository'] ?? $this->getCustomerWishlist_RepositoryService()), ($this->services['customer_wishlist_product.repository'] ?? $this->getCustomerWishlistProduct_RepositoryService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\ResetPasswordRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\ResetPasswordRoute
     */
    protected function getResetPasswordRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractResetPasswordRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/ResetPasswordRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ResetPasswordRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\ResetPasswordRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['customer_recovery.repository'] ?? $this->getCustomerRecovery_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\SendPasswordRecoveryMailRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\SendPasswordRecoveryMailRoute
     */
    protected function getSendPasswordRecoveryMailRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractSendPasswordRecoveryMailRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/SendPasswordRecoveryMailRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SendPasswordRecoveryMailRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\SendPasswordRecoveryMailRoute(($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['customer_recovery.repository'] ?? $this->getCustomerRecovery_RepositoryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\SwitchDefaultAddressRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\SwitchDefaultAddressRoute
     */
    protected function getSwitchDefaultAddressRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractSwitchDefaultAddressRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/CustomerAddressValidationTrait.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/SwitchDefaultAddressRoute.php';

        $a = ($this->services['customer_address.repository'] ?? $this->getCustomerAddress_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'];
        }
        $b = ($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SwitchDefaultAddressRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\SwitchDefaultAddressRoute($a, $b, $c);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Customer\SalesChannel\UpsertAddressRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Customer\SalesChannel\UpsertAddressRoute
     */
    protected function getUpsertAddressRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/AbstractUpsertAddressRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/CustomerAddressValidationTrait.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Customer/SalesChannel/UpsertAddressRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\UpsertAddressRoute'] = new \Shopware\Core\Checkout\Customer\SalesChannel\UpsertAddressRoute(($this->services['customer_address.repository'] ?? $this->getCustomerAddress_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\AddressValidationFactory'] ?? $this->getAddressValidationFactoryService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\StoreApiCustomFieldMapper'] ?? $this->getStoreApiCustomFieldMapperService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfigSalesChannel\DocumentBaseConfigSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfigSalesChannel\DocumentBaseConfigSalesChannelDefinition
     */
    protected function getDocumentBaseConfigSalesChannelDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/Aggregate/DocumentBaseConfigSalesChannel/DocumentBaseConfigSalesChannelDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition'] = $instance = new \Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfigSalesChannel\DocumentBaseConfigSalesChannelDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfig\DocumentBaseConfigDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfig\DocumentBaseConfigDefinition
     */
    protected function getDocumentBaseConfigDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/Aggregate/DocumentBaseConfig/DocumentBaseConfigDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition'] = $instance = new \Shopware\Core\Checkout\Document\Aggregate\DocumentBaseConfig\DocumentBaseConfigDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Aggregate\DocumentTypeTranslation\DocumentTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Aggregate\DocumentTypeTranslation\DocumentTypeTranslationDefinition
     */
    protected function getDocumentTypeTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/Aggregate/DocumentTypeTranslation/DocumentTypeTranslationDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Document\Aggregate\DocumentTypeTranslation\DocumentTypeTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Aggregate\DocumentType\DocumentTypeDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Aggregate\DocumentType\DocumentTypeDefinition
     */
    protected function getDocumentTypeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/Aggregate/DocumentType/DocumentTypeDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition'] = $instance = new \Shopware\Core\Checkout\Document\Aggregate\DocumentType\DocumentTypeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\Controller\DocumentController' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\Controller\DocumentController
     */
    protected function getDocumentControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/Controller/DocumentController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/Service/DocumentMerger.php';
        include_once \dirname(__DIR__, 4).'/vendor/tecnickcom/tcpdf/tcpdf.php';
        include_once \dirname(__DIR__, 4).'/vendor/setasign/fpdi/src/FpdiTrait.php';
        include_once \dirname(__DIR__, 4).'/vendor/setasign/fpdi/src/Tcpdf/Fpdi.php';

        $a = ($this->privates['Shopware\\Core\\Checkout\\Document\\Service\\DocumentGenerator'] ?? $this->getDocumentGeneratorService());
        $b = ($this->services['document.repository'] ?? $this->getDocument_RepositoryService());

        $this->services['Shopware\\Core\\Checkout\\Document\\Controller\\DocumentController'] = $instance = new \Shopware\Core\Checkout\Document\Controller\DocumentController(($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentService'] ?? $this->getDocumentServiceService()), $a, new \Shopware\Core\Checkout\Document\Service\DocumentMerger($b, ($this->privates['Shopware\\Core\\Content\\Media\\MediaService'] ?? $this->getMediaServiceService()), $a, new \setasign\Fpdi\Tcpdf\Fpdi()), $b);

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\DocumentDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\DocumentDefinition
     */
    protected function getDocumentDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/DocumentDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Document\\DocumentDefinition'] = $instance = new \Shopware\Core\Checkout\Document\DocumentDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\DocumentGeneratorController' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\DocumentGeneratorController
     */
    protected function getDocumentGeneratorControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/DocumentGeneratorController.php';

        $this->services['Shopware\\Core\\Checkout\\Document\\DocumentGeneratorController'] = $instance = new \Shopware\Core\Checkout\Document\DocumentGeneratorController(($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentService'] ?? $this->getDocumentServiceService()), ($this->privates['Shopware\\Core\\Checkout\\Document\\Service\\DocumentGenerator'] ?? $this->getDocumentGeneratorService()), ($this->services['.container.private.serializer'] ?? $this->get_Container_Private_SerializerService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Document\SalesChannel\DocumentRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Document\SalesChannel\DocumentRoute
     */
    protected function getDocumentRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/SalesChannel/AbstractDocumentRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Document/SalesChannel/DocumentRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Document\\SalesChannel\\DocumentRoute'] = new \Shopware\Core\Checkout\Document\SalesChannel\DocumentRoute(($this->privates['Shopware\\Core\\Checkout\\Document\\Service\\DocumentGenerator'] ?? $this->getDocumentGeneratorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderAddress\OrderAddressDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderAddress\OrderAddressDefinition
     */
    protected function getOrderAddressDefinitionService()
    {
        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderAddress\OrderAddressDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderCustomer\OrderCustomerDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderCustomer\OrderCustomerDefinition
     */
    protected function getOrderCustomerDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderCustomer/OrderCustomerDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderCustomer\OrderCustomerDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderDeliveryPosition\OrderDeliveryPositionDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderDeliveryPosition\OrderDeliveryPositionDefinition
     */
    protected function getOrderDeliveryPositionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderDeliveryPosition/OrderDeliveryPositionDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderDeliveryPosition\OrderDeliveryPositionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderDelivery\OrderDeliveryDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderDelivery\OrderDeliveryDefinition
     */
    protected function getOrderDeliveryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderDelivery/OrderDeliveryDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderDelivery\OrderDeliveryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderLineItem\OrderLineItemDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderLineItem\OrderLineItemDefinition
     */
    protected function getOrderLineItemDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderLineItem/OrderLineItemDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderLineItem\OrderLineItemDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTag\OrderTagDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTag\OrderTagDefinition
     */
    protected function getOrderTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderTag/OrderTagDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTag\OrderTagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefundPosition\OrderTransactionCaptureRefundPositionDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefundPosition\OrderTransactionCaptureRefundPositionDefinition
     */
    protected function getOrderTransactionCaptureRefundPositionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderTransactionCaptureRefundPosition/OrderTransactionCaptureRefundPositionDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefundPosition\OrderTransactionCaptureRefundPositionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefund\OrderTransactionCaptureRefundDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefund\OrderTransactionCaptureRefundDefinition
     */
    protected function getOrderTransactionCaptureRefundDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderTransactionCaptureRefund/OrderTransactionCaptureRefundDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefund\OrderTransactionCaptureRefundDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCapture\OrderTransactionCaptureDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCapture\OrderTransactionCaptureDefinition
     */
    protected function getOrderTransactionCaptureDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderTransactionCapture/OrderTransactionCaptureDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCapture\OrderTransactionCaptureDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionDefinition
     */
    protected function getOrderTransactionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderTransaction/OrderTransactionDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition'] = $instance = new \Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\Api\OrderActionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\Api\OrderActionController
     */
    protected function getOrderActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Api/OrderActionController.php';

        $this->services['Shopware\\Core\\Checkout\\Order\\Api\\OrderActionController'] = $instance = new \Shopware\Core\Checkout\Order\Api\OrderActionController(($this->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? $this->getOrderServiceService()), ($this->privates['Shopware\\Core\\Framework\\Api\\Converter\\ApiVersionConverter'] ?? $this->getApiVersionConverterService()), ($this->services['Shopware\\Core\\System\\StateMachine\\StateMachineDefinition'] ?? $this->getStateMachineDefinitionService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->services['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentRefundProcessor'] ?? $this->getPaymentRefundProcessorService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\OrderDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\OrderDefinition
     */
    protected function getOrderDefinitionService()
    {
        $this->services['Shopware\\Core\\Checkout\\Order\\OrderDefinition'] = $instance = new \Shopware\Core\Checkout\Order\OrderDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\SalesChannel\CancelOrderRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\SalesChannel\CancelOrderRoute
     */
    protected function getCancelOrderRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/SalesChannel/AbstractCancelOrderRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/SalesChannel/CancelOrderRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\CancelOrderRoute'] = new \Shopware\Core\Checkout\Order\SalesChannel\CancelOrderRoute(($this->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? $this->getOrderServiceService()), ($this->services['order.repository'] ?? $this->getOrder_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\SalesChannel\OrderRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\SalesChannel\OrderRoute
     */
    protected function getOrderRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/SalesChannel/AbstractOrderRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/SalesChannel/OrderRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute'] = new \Shopware\Core\Checkout\Order\SalesChannel\OrderRoute(($this->services['order.repository'] ?? $this->getOrder_RepositoryService()), ($this->services['promotion.repository'] ?? $this->getPromotion_RepositoryService()), ($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Order\SalesChannel\SetPaymentOrderRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Order\SalesChannel\SetPaymentOrderRoute
     */
    protected function getSetPaymentOrderRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/SalesChannel/AbstractSetPaymentOrderRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/SalesChannel/SetPaymentOrderRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\SetPaymentOrderRoute'] = new \Shopware\Core\Checkout\Order\SalesChannel\SetPaymentOrderRoute(($this->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? $this->getOrderServiceService()), ($this->services['order.repository'] ?? $this->getOrder_RepositoryService()), ($this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SortedPaymentMethodRoute'] ?? $this->getSortedPaymentMethodRouteService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? $this->getOrderConverterService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\CartRuleLoader'] ?? $this->getCartRuleLoaderService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\System\\StateMachine\\Loader\\InitialStateIdLoader'] ?? $this->getInitialStateIdLoaderService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\Aggregate\PaymentMethodTranslation\PaymentMethodTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\Aggregate\PaymentMethodTranslation\PaymentMethodTranslationDefinition
     */
    protected function getPaymentMethodTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/Aggregate/PaymentMethodTranslation/PaymentMethodTranslationDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Payment\Aggregate\PaymentMethodTranslation\PaymentMethodTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\Cart\PaymentRefundProcessor' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\Cart\PaymentRefundProcessor
     */
    protected function getPaymentRefundProcessorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/Cart/PaymentRefundProcessor.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Order/Aggregate/OrderTransactionCaptureRefund/OrderTransactionCaptureRefundStateHandler.php';

        return $this->services['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentRefundProcessor'] = new \Shopware\Core\Checkout\Payment\Cart\PaymentRefundProcessor(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), new \Shopware\Core\Checkout\Order\Aggregate\OrderTransactionCaptureRefund\OrderTransactionCaptureRefundStateHandler(($this->privates['Shopware\\Core\\System\\StateMachine\\StateMachineRegistry'] ?? $this->getStateMachineRegistryService())), ($this->privates['Shopware\\Core\\Checkout\\Payment\\Cart\\PaymentHandler\\PaymentHandlerRegistry'] ?? $this->getPaymentHandlerRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\Controller\PaymentController' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\Controller\PaymentController
     */
    protected function getPaymentControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/Controller/PaymentController.php';

        $this->services['Shopware\\Core\\Checkout\\Payment\\Controller\\PaymentController'] = $instance = new \Shopware\Core\Checkout\Payment\Controller\PaymentController(($this->privates['Shopware\\Core\\Checkout\\Payment\\PaymentService'] ?? $this->getPaymentServiceService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? $this->getOrderConverterService()), ($this->privates['Shopware\\Core\\Checkout\\Payment\\Cart\\Token\\JWTFactoryV2'] ?? $this->getJWTFactoryV2Service()), ($this->services['order.repository'] ?? $this->getOrder_RepositoryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\PaymentMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\PaymentMethodDefinition
     */
    protected function getPaymentMethodDefinitionService()
    {
        $this->services['Shopware\\Core\\Checkout\\Payment\\PaymentMethodDefinition'] = $instance = new \Shopware\Core\Checkout\Payment\PaymentMethodDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\SalesChannel\CachedPaymentMethodRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\SalesChannel\CachedPaymentMethodRoute
     */
    protected function getCachedPaymentMethodRouteService()
    {
        $a = ($this->services['sales_channel.payment_method.repository'] ?? $this->getSalesChannel_PaymentMethod_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\CachedPaymentMethodRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\CachedPaymentMethodRoute'];
        }
        $b = ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\CachedPaymentMethodRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\CachedPaymentMethodRoute'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\CachedPaymentMethodRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\CachedPaymentMethodRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\CachedPaymentMethodRoute'] = new \Shopware\Core\Checkout\Payment\SalesChannel\CachedPaymentMethodRoute(new \Shopware\Core\Checkout\Payment\SalesChannel\PaymentMethodRoute($a), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), $b, $c, []);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\SalesChannel\HandlePaymentMethodRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\SalesChannel\HandlePaymentMethodRoute
     */
    protected function getHandlePaymentMethodRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/SalesChannel/AbstractHandlePaymentMethodRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Payment/SalesChannel/HandlePaymentMethodRoute.php';

        return $this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\HandlePaymentMethodRoute'] = new \Shopware\Core\Checkout\Payment\SalesChannel\HandlePaymentMethodRoute(($this->privates['Shopware\\Core\\Checkout\\Payment\\PaymentService'] ?? $this->getPaymentServiceService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\SalesChannel\SalesChannelPaymentMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\SalesChannel\SalesChannelPaymentMethodDefinition
     */
    protected function getSalesChannelPaymentMethodDefinitionService()
    {
        $this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition'] = $instance = new \Shopware\Core\Checkout\Payment\SalesChannel\SalesChannelPaymentMethodDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Payment\SalesChannel\SortedPaymentMethodRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Payment\SalesChannel\SortedPaymentMethodRoute
     */
    protected function getSortedPaymentMethodRouteService()
    {
        $a = ($this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\CachedPaymentMethodRoute'] ?? $this->getCachedPaymentMethodRouteService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SortedPaymentMethodRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SortedPaymentMethodRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SortedPaymentMethodRoute'] = new \Shopware\Core\Checkout\Payment\SalesChannel\SortedPaymentMethodRoute($a);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionCartRule\PromotionCartRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionCartRule\PromotionCartRuleDefinition
     */
    protected function getPromotionCartRuleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionCartRule/PromotionCartRuleDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionCartRule\PromotionCartRuleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountPrice\PromotionDiscountPriceDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountPrice\PromotionDiscountPriceDefinition
     */
    protected function getPromotionDiscountPriceDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionDiscountPrice/PromotionDiscountPriceDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountPrice\PromotionDiscountPriceDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountRule\PromotionDiscountRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountRule\PromotionDiscountRuleDefinition
     */
    protected function getPromotionDiscountRuleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionDiscountRule/PromotionDiscountRuleDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscountRule\PromotionDiscountRuleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscount\PromotionDiscountDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscount\PromotionDiscountDefinition
     */
    protected function getPromotionDiscountDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionDiscount/PromotionDiscountDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionDiscount\PromotionDiscountDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionIndividualCode\PromotionIndividualCodeDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionIndividualCode\PromotionIndividualCodeDefinition
     */
    protected function getPromotionIndividualCodeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionIndividualCode/PromotionIndividualCodeDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionIndividualCode\PromotionIndividualCodeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionOrderRule\PromotionOrderRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionOrderRule\PromotionOrderRuleDefinition
     */
    protected function getPromotionOrderRuleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionOrderRule/PromotionOrderRuleDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionOrderRule\PromotionOrderRuleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaCustomer\PromotionPersonaCustomerDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaCustomer\PromotionPersonaCustomerDefinition
     */
    protected function getPromotionPersonaCustomerDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionPersonaCustomer/PromotionPersonaCustomerDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaCustomer\PromotionPersonaCustomerDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaRule\PromotionPersonaRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaRule\PromotionPersonaRuleDefinition
     */
    protected function getPromotionPersonaRuleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionPersonaRule/PromotionPersonaRuleDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionPersonaRule\PromotionPersonaRuleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionSalesChannel\PromotionSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSalesChannel\PromotionSalesChannelDefinition
     */
    protected function getPromotionSalesChannelDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionSalesChannel/PromotionSalesChannelDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSalesChannel\PromotionSalesChannelDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroupRule\PromotionSetGroupRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroupRule\PromotionSetGroupRuleDefinition
     */
    protected function getPromotionSetGroupRuleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionSetGroupRule/PromotionSetGroupRuleDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroupRule\PromotionSetGroupRuleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroup\PromotionSetGroupDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroup\PromotionSetGroupDefinition
     */
    protected function getPromotionSetGroupDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionSetGroup/PromotionSetGroupDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionSetGroup\PromotionSetGroupDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Aggregate\PromotionTranslation\PromotionTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Aggregate\PromotionTranslation\PromotionTranslationDefinition
     */
    protected function getPromotionTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Aggregate/PromotionTranslation/PromotionTranslationDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\Aggregate\PromotionTranslation\PromotionTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Api\PromotionActionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Api\PromotionActionController
     */
    protected function getPromotionActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Api/PromotionActionController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Util/PromotionCodesLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Util/PromotionCodesRemover.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Api\\PromotionActionController'] = $instance = new \Shopware\Core\Checkout\Promotion\Api\PromotionActionController(new \Shopware\Core\Checkout\Promotion\Util\PromotionCodesLoader(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService())), new \Shopware\Core\Checkout\Promotion\Util\PromotionCodesRemover(($this->services['promotion_individual_code.repository'] ?? $this->getPromotionIndividualCode_RepositoryService())), ($this->privates['Shopware\\Core\\Checkout\\Cart\\LineItem\\Group\\LineItemGroupServiceRegistry'] ?? $this->getLineItemGroupServiceRegistryService()), ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\Discount\\Filter\\FilterServiceRegistry'] ?? $this->getFilterServiceRegistryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\Api\PromotionController' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\Api\PromotionController
     */
    protected function getPromotionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Api/PromotionController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Util/PromotionCodeService.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\Api\\PromotionController'] = $instance = new \Shopware\Core\Checkout\Promotion\Api\PromotionController(new \Shopware\Core\Checkout\Promotion\Util\PromotionCodeService(($this->services['promotion.repository'] ?? $this->getPromotion_RepositoryService()), ($this->services['promotion_individual_code.repository'] ?? $this->getPromotionIndividualCode_RepositoryService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService())));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Promotion\PromotionDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Promotion\PromotionDefinition
     */
    protected function getPromotionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/PromotionDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition'] = $instance = new \Shopware\Core\Checkout\Promotion\PromotionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodPrice\ShippingMethodPriceDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodPrice\ShippingMethodPriceDefinition
     */
    protected function getShippingMethodPriceDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Shipping/Aggregate/ShippingMethodPrice/ShippingMethodPriceDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodPrice\ShippingMethodPriceDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTag\ShippingMethodTagDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTag\ShippingMethodTagDefinition
     */
    protected function getShippingMethodTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Shipping/Aggregate/ShippingMethodTag/ShippingMethodTagDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTag\ShippingMethodTagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTranslation\ShippingMethodTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTranslation\ShippingMethodTranslationDefinition
     */
    protected function getShippingMethodTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Shipping/Aggregate/ShippingMethodTranslation/ShippingMethodTranslationDefinition.php';

        $this->services['Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\Aggregate\ShippingMethodTranslation\ShippingMethodTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\SalesChannel\CachedShippingMethodRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\SalesChannel\CachedShippingMethodRoute
     */
    protected function getCachedShippingMethodRouteService()
    {
        $a = ($this->services['sales_channel.shipping_method.repository'] ?? $this->getSalesChannel_ShippingMethod_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\CachedShippingMethodRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\CachedShippingMethodRoute'];
        }
        $b = ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\CachedShippingMethodRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\CachedShippingMethodRoute'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\CachedShippingMethodRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\CachedShippingMethodRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\CachedShippingMethodRoute'] = new \Shopware\Core\Checkout\Shipping\SalesChannel\CachedShippingMethodRoute(new \Shopware\Core\Checkout\Shipping\SalesChannel\ShippingMethodRoute($a), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), $b, $c, []);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\SalesChannel\SalesChannelShippingMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\SalesChannel\SalesChannelShippingMethodDefinition
     */
    protected function getSalesChannelShippingMethodDefinitionService()
    {
        $this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\SalesChannel\SalesChannelShippingMethodDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\SalesChannel\SortedShippingMethodRoute' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\SalesChannel\SortedShippingMethodRoute
     */
    protected function getSortedShippingMethodRouteService()
    {
        $a = ($this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\CachedShippingMethodRoute'] ?? $this->getCachedShippingMethodRouteService());

        if (isset($this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SortedShippingMethodRoute'])) {
            return $this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SortedShippingMethodRoute'];
        }

        return $this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SortedShippingMethodRoute'] = new \Shopware\Core\Checkout\Shipping\SalesChannel\SortedShippingMethodRoute($a);
    }

    /*
     * Gets the public 'Shopware\Core\Checkout\Shipping\ShippingMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Checkout\Shipping\ShippingMethodDefinition
     */
    protected function getShippingMethodDefinitionService()
    {
        $this->services['Shopware\\Core\\Checkout\\Shipping\\ShippingMethodDefinition'] = $instance = new \Shopware\Core\Checkout\Shipping\ShippingMethodDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\Aggregate\CategoryTag\CategoryTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Category\Aggregate\CategoryTag\CategoryTagDefinition
     */
    protected function getCategoryTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/Aggregate/CategoryTag/CategoryTagDefinition.php';

        $this->services['Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition'] = $instance = new \Shopware\Core\Content\Category\Aggregate\CategoryTag\CategoryTagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\Aggregate\CategoryTranslation\CategoryTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Category\Aggregate\CategoryTranslation\CategoryTranslationDefinition
     */
    protected function getCategoryTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/Aggregate/CategoryTranslation/CategoryTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition'] = $instance = new \Shopware\Core\Content\Category\Aggregate\CategoryTranslation\CategoryTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\CategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Category\CategoryDefinition
     */
    protected function getCategoryDefinitionService()
    {
        $this->services['Shopware\\Core\\Content\\Category\\CategoryDefinition'] = $instance = new \Shopware\Core\Content\Category\CategoryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\CategoryHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Category\CategoryHydrator
     */
    protected function getCategoryHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/CategoryHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Category\\CategoryHydrator'] = new \Shopware\Core\Content\Category\CategoryHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\SalesChannel\CachedCategoryRoute' shared service.
     *
     * @return \Shopware\Core\Content\Category\SalesChannel\CachedCategoryRoute
     */
    protected function getCachedCategoryRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/AbstractCategoryRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/CachedCategoryRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/CategoryRoute.php';

        return $this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedCategoryRoute'] = new \Shopware\Core\Content\Category\SalesChannel\CachedCategoryRoute(new \Shopware\Core\Content\Category\SalesChannel\CategoryRoute(($this->services['sales_channel.category.repository'] ?? $this->getSalesChannel_Category_RepositoryService()), ($this->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? $this->getSalesChannelCmsPageLoaderService()), ($this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition'] ?? $this->getSalesChannelCategoryDefinitionService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), []);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\SalesChannel\CachedNavigationRoute' shared service.
     *
     * @return \Shopware\Core\Content\Category\SalesChannel\CachedNavigationRoute
     */
    protected function getCachedNavigationRouteService()
    {
        $a = ($this->services['sales_channel.category.repository'] ?? $this->getSalesChannel_Category_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedNavigationRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedNavigationRoute'];
        }
        $b = ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService());

        if (isset($this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedNavigationRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedNavigationRoute'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedNavigationRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedNavigationRoute'];
        }

        return $this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedNavigationRoute'] = new \Shopware\Core\Content\Category\SalesChannel\CachedNavigationRoute(new \Shopware\Core\Content\Category\SalesChannel\NavigationRoute(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), $a), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), $b, $c, []);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\SalesChannel\CategoryListRoute' shared service.
     *
     * @return \Shopware\Core\Content\Category\SalesChannel\CategoryListRoute
     */
    protected function getCategoryListRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/AbstractCategoryListRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Category/SalesChannel/CategoryListRoute.php';

        return $this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CategoryListRoute'] = new \Shopware\Core\Content\Category\SalesChannel\CategoryListRoute(($this->services['sales_channel.category.repository'] ?? $this->getSalesChannel_Category_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\SalesChannel\SalesChannelCategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Category\SalesChannel\SalesChannelCategoryDefinition
     */
    protected function getSalesChannelCategoryDefinitionService()
    {
        $this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition'] = $instance = new \Shopware\Core\Content\Category\SalesChannel\SalesChannelCategoryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Category\SalesChannel\TreeBuildingNavigationRoute' shared service.
     *
     * @return \Shopware\Core\Content\Category\SalesChannel\TreeBuildingNavigationRoute
     */
    protected function getTreeBuildingNavigationRouteService()
    {
        $a = ($this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedNavigationRoute'] ?? $this->getCachedNavigationRouteService());

        if (isset($this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\TreeBuildingNavigationRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\TreeBuildingNavigationRoute'];
        }

        return $this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\TreeBuildingNavigationRoute'] = new \Shopware\Core\Content\Category\SalesChannel\TreeBuildingNavigationRoute($a);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsBlock\CmsBlockDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsBlock\CmsBlockDefinition
     */
    protected function getCmsBlockDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/Aggregate/CmsBlock/CmsBlockDefinition.php';

        $this->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsBlock\CmsBlockDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsPageTranslation\CmsPageTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsPageTranslation\CmsPageTranslationDefinition
     */
    protected function getCmsPageTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/Aggregate/CmsPageTranslation/CmsPageTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsPageTranslation\CmsPageTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsSection\CmsSectionDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsSection\CmsSectionDefinition
     */
    protected function getCmsSectionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/Aggregate/CmsSection/CmsSectionDefinition.php';

        $this->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsSection\CmsSectionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsSlotTranslation\CmsSlotTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsSlotTranslation\CmsSlotTranslationDefinition
     */
    protected function getCmsSlotTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/Aggregate/CmsSlotTranslation/CmsSlotTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsSlotTranslation\CmsSlotTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\Aggregate\CmsSlot\CmsSlotDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\Aggregate\CmsSlot\CmsSlotDefinition
     */
    protected function getCmsSlotDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/Aggregate/CmsSlot/CmsSlotDefinition.php';

        $this->services['Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition'] = $instance = new \Shopware\Core\Content\Cms\Aggregate\CmsSlot\CmsSlotDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\CmsPageDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Cms\CmsPageDefinition
     */
    protected function getCmsPageDefinitionService()
    {
        $this->services['Shopware\\Core\\Content\\Cms\\CmsPageDefinition'] = $instance = new \Shopware\Core\Content\Cms\CmsPageDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\DataAbstractionLayer\FieldSerializer\SlotConfigFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Content\Cms\DataAbstractionLayer\FieldSerializer\SlotConfigFieldSerializer
     */
    protected function getSlotConfigFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/JsonFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/DataAbstractionLayer/FieldSerializer/SlotConfigFieldSerializer.php';

        return $this->services['Shopware\\Core\\Content\\Cms\\DataAbstractionLayer\\FieldSerializer\\SlotConfigFieldSerializer'] = new \Shopware\Core\Content\Cms\DataAbstractionLayer\FieldSerializer\SlotConfigFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\DataResolver\CmsSlotsDataResolver' shared service.
     *
     * @return \Shopware\Core\Content\Cms\DataResolver\CmsSlotsDataResolver
     */
    protected function getCmsSlotsDataResolverService()
    {
        $a = ($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\Cms\\DataResolver\\CmsSlotsDataResolver'])) {
            return $this->services['Shopware\\Core\\Content\\Cms\\DataResolver\\CmsSlotsDataResolver'];
        }

        return $this->services['Shopware\\Core\\Content\\Cms\\DataResolver\\CmsSlotsDataResolver'] = new \Shopware\Core\Content\Cms\DataResolver\CmsSlotsDataResolver(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Content\\Media\\Cms\\ImageCmsElementResolver'] ?? $this->getImageCmsElementResolverService());
            yield 1 => ($this->privates['Shopware\\Core\\Content\\Media\\Cms\\Type\\ImageSliderTypeDataResolver'] ?? $this->getImageSliderTypeDataResolverService());
            yield 2 => ($this->privates['Shopware\\Core\\Content\\Media\\Cms\\Type\\ImageGalleryTypeDataResolver'] ?? $this->getImageGalleryTypeDataResolverService());
            yield 3 => ($this->privates['Shopware\\Core\\Content\\Media\\Cms\\YoutubeVideoCmsElementResolver'] ?? ($this->privates['Shopware\\Core\\Content\\Media\\Cms\\YoutubeVideoCmsElementResolver'] = new \Shopware\Core\Content\Media\Cms\YoutubeVideoCmsElementResolver()));
            yield 4 => ($this->privates['Shopware\\Core\\Content\\Media\\Cms\\VimeoVideoCmsElementResolver'] ?? ($this->privates['Shopware\\Core\\Content\\Media\\Cms\\VimeoVideoCmsElementResolver'] = new \Shopware\Core\Content\Media\Cms\VimeoVideoCmsElementResolver()));
            yield 5 => ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductBoxCmsElementResolver'] ?? $this->getProductBoxCmsElementResolverService());
            yield 6 => ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductListingCmsElementResolver'] ?? $this->getProductListingCmsElementResolverService());
            yield 7 => ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductSliderCmsElementResolver'] ?? $this->getProductSliderCmsElementResolverService());
            yield 8 => ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductNameCmsElementResolver'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductNameCmsElementResolver'] = new \Shopware\Core\Content\Product\Cms\ProductNameCmsElementResolver()));
            yield 9 => ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\ManufacturerLogoCmsElementResolver'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\ManufacturerLogoCmsElementResolver'] = new \Shopware\Core\Content\Product\Cms\ManufacturerLogoCmsElementResolver()));
            yield 10 => ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\CrossSellingCmsElementResolver'] ?? $this->getCrossSellingCmsElementResolverService());
            yield 11 => ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\ProductDescriptionReviewsCmsElementResolver'] ?? $this->getProductDescriptionReviewsCmsElementResolverService());
            yield 12 => ($this->privates['Shopware\\Core\\Content\\Product\\Cms\\BuyBoxCmsElementResolver'] ?? $this->getBuyBoxCmsElementResolverService());
            yield 13 => ($this->privates['Shopware\\Core\\Content\\Cms\\DataResolver\\Element\\TextCmsElementResolver'] ?? $this->getTextCmsElementResolverService());
            yield 14 => ($this->privates['Shopware\\Core\\Content\\Cms\\DataResolver\\Element\\FormCmsElementResolver'] ?? $this->getFormCmsElementResolverService());
        }, 15), ['product' => $a], ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\SalesChannel\CmsRoute' shared service.
     *
     * @return \Shopware\Core\Content\Cms\SalesChannel\CmsRoute
     */
    protected function getCmsRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/SalesChannel/AbstractCmsRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Cms/SalesChannel/CmsRoute.php';

        return $this->services['Shopware\\Core\\Content\\Cms\\SalesChannel\\CmsRoute'] = new \Shopware\Core\Content\Cms\SalesChannel\CmsRoute(($this->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? $this->getSalesChannelCmsPageLoaderService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Cms\SalesChannel\SalesChannelCmsPageRepository' shared service.
     *
     * @return \Shopware\Core\Content\Cms\SalesChannel\SalesChannelCmsPageRepository
     *
     * @deprecated Since shopware/core 6.5.0: tag:v6.5.0 "Shopware\Core\Content\Cms\SalesChannel\SalesChannelCmsPageRepository" service alias is deprecated, it will be removed in 6.5.0.
     */
    protected function getSalesChannelCmsPageRepositoryService()
    {
        trigger_deprecation('shopware/core', '6.5.0', 'tag:v6.5.0 "Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageRepository" service alias is deprecated, it will be removed in 6.5.0.');

        return $this->services['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageRepository'] = new \Shopware\Core\Content\Cms\SalesChannel\SalesChannelCmsPageRepository(($this->services['cms_page.repository'] ?? $this->getCmsPage_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ContactForm\SalesChannel\ContactFormRoute' shared service.
     *
     * @return \Shopware\Core\Content\ContactForm\SalesChannel\ContactFormRoute
     */
    protected function getContactFormRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ContactForm/SalesChannel/AbstractContactFormRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ContactForm/SalesChannel/ContactFormRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Validation/DataValidationFactoryInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ContactForm/Validation/ContactFormValidationFactory.php';

        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());
        $b = ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService());

        return $this->services['Shopware\\Core\\Content\\ContactForm\\SalesChannel\\ContactFormRoute'] = new \Shopware\Core\Content\ContactForm\SalesChannel\ContactFormRoute(new \Shopware\Core\Content\ContactForm\Validation\ContactFormValidationFactory($a, $b), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), $a, $b, ($this->services['cms_slot.repository'] ?? $this->getCmsSlot_RepositoryService()), ($this->services['salutation.repository'] ?? $this->getSalutation_RepositoryService()), ($this->services['category.repository'] ?? $this->getCategory_RepositoryService()), ($this->services['landing_page.repository'] ?? $this->getLandingPage_RepositoryService()), ($this->services['product.repository'] ?? $this->getProduct_RepositoryService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Aggregate\FlowSequence\FlowSequenceDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Aggregate\FlowSequence\FlowSequenceDefinition
     */
    protected function getFlowSequenceDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Flow/Aggregate/FlowSequence/FlowSequenceDefinition.php';

        $this->services['Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition'] = $instance = new \Shopware\Core\Content\Flow\Aggregate\FlowSequence\FlowSequenceDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Dispatching\CachedFlowLoader' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Dispatching\CachedFlowLoader
     */
    protected function getCachedFlowLoaderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Flow/Dispatching/AbstractFlowLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Flow/Dispatching/CachedFlowLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Flow/Dispatching/FlowLoader.php';

        return $this->services['Shopware\\Core\\Content\\Flow\\Dispatching\\CachedFlowLoader'] = new \Shopware\Core\Content\Flow\Dispatching\CachedFlowLoader(new \Shopware\Core\Content\Flow\Dispatching\FlowLoader(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Dispatching\FlowExecutor' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Dispatching\FlowExecutor
     */
    protected function getFlowExecutorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Flow/Dispatching/FlowExecutor.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Flow/Rule/FlowRuleScopeBuilder.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/Delivery/DeliveryBuilder.php';

        return $this->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowExecutor'] = new \Shopware\Core\Content\Flow\Dispatching\FlowExecutor(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Framework\\App\\FlowAction\\AppFlowActionProvider'] ?? $this->getAppFlowActionProviderService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\CachedRuleLoader'] ?? $this->getCachedRuleLoaderService()), new \Shopware\Core\Content\Flow\Rule\FlowRuleScopeBuilder(($this->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? $this->getOrderConverterService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Delivery\\DeliveryBuilder'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Delivery\\DeliveryBuilder'] = new \Shopware\Core\Checkout\Cart\Delivery\DeliveryBuilder())), new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Content\\Product\\Cart\\ProductCartProcessor'] ?? $this->getProductCartProcessorService());
            yield 1 => ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\PromotionCollector'] ?? $this->getPromotionCollectorService());
            yield 2 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\CustomCartProcessor'] ?? $this->getCustomCartProcessorService());
            yield 3 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Delivery\\DeliveryProcessor'] ?? $this->getDeliveryProcessorService());
        }, 4)), new RewindableGenerator(function () {
            yield 'action.add.order.tag' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\AddOrderTagAction'] ?? $this->getAddOrderTagActionService());
            yield 'action.add.customer.tag' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\AddCustomerTagAction'] ?? $this->getAddCustomerTagActionService());
            yield 'action.remove.order.tag' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\RemoveOrderTagAction'] ?? $this->getRemoveOrderTagActionService());
            yield 'action.remove.customer.tag' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\RemoveCustomerTagAction'] ?? $this->getRemoveCustomerTagActionService());
            yield 'action.change.customer.group' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\ChangeCustomerGroupAction'] ?? $this->getChangeCustomerGroupActionService());
            yield 'action.change.customer.status' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\ChangeCustomerStatusAction'] ?? $this->getChangeCustomerStatusActionService());
            yield 'action.generate.document' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\GenerateDocumentAction'] ?? $this->getGenerateDocumentActionService());
            yield 'action.mail.send' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SendMailAction'] ?? $this->getSendMailActionService());
            yield 'action.set.order.state' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SetOrderStateAction'] ?? $this->getSetOrderStateActionService());
            yield 'action.set.customer.custom.field' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SetCustomerCustomFieldAction'] ?? $this->getSetCustomerCustomFieldActionService());
            yield 'action.set.customer.group.custom.field' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SetCustomerGroupCustomFieldAction'] ?? $this->getSetCustomerGroupCustomFieldActionService());
            yield 'action.add.customer.affiliate.and.campaign.code' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\AddCustomerAffiliateAndCampaignCodeAction'] ?? $this->getAddCustomerAffiliateAndCampaignCodeActionService());
            yield 'action.add.order.affiliate.and.campaign.code' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\AddOrderAffiliateAndCampaignCodeAction'] ?? $this->getAddOrderAffiliateAndCampaignCodeActionService());
            yield 'action.set.order.custom.field' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\SetOrderCustomFieldAction'] ?? $this->getSetOrderCustomFieldActionService());
            yield 'action.stop.flow' => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\StopFlowAction'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Action\\StopFlowAction'] = new \Shopware\Core\Content\Flow\Dispatching\Action\StopFlowAction()));
        }, 15));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\Dispatching\FlowFactory' shared service.
     *
     * @return \Shopware\Core\Content\Flow\Dispatching\FlowFactory
     */
    protected function getFlowFactoryService()
    {
        return $this->services['Shopware\\Core\\Content\\Flow\\Dispatching\\FlowFactory'] = new \Shopware\Core\Content\Flow\Dispatching\FlowFactory(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\OrderStorer'] ?? $this->getOrderStorerService());
            yield 1 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\CustomerStorer'] ?? $this->getCustomerStorerService());
            yield 2 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\MailStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\MailStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\MailStorer()));
            yield 3 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\UserStorer'] ?? $this->getUserStorerService());
            yield 4 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\CustomerGroupStorer'] ?? $this->getCustomerGroupStorerService());
            yield 5 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\CustomerRecoveryStorer'] ?? $this->getCustomerRecoveryStorerService());
            yield 6 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\OrderTransactionStorer'] ?? $this->getOrderTransactionStorerService());
            yield 7 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\NewsletterRecipientStorer'] ?? $this->getNewsletterRecipientStorerService());
            yield 8 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ContactFormDataStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ContactFormDataStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\ContactFormDataStorer()));
            yield 9 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ConfirmUrlStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ConfirmUrlStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\ConfirmUrlStorer()));
            yield 10 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ContentsStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ContentsStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\ContentsStorer()));
            yield 11 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ContextTokenStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ContextTokenStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\ContextTokenStorer()));
            yield 12 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\EmailStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\EmailStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\EmailStorer()));
            yield 13 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\MessageStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\MessageStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\MessageStorer()));
            yield 14 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\NameStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\NameStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\NameStorer()));
            yield 15 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\RecipientsStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\RecipientsStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\RecipientsStorer()));
            yield 16 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ResetUrlStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ResetUrlStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\ResetUrlStorer()));
            yield 17 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ShopNameStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\ShopNameStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\ShopNameStorer()));
            yield 18 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\SubjectStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\SubjectStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\SubjectStorer()));
            yield 19 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\TemplateDataStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\TemplateDataStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\TemplateDataStorer()));
            yield 20 => ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\UrlStorer'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Dispatching\\Storer\\UrlStorer'] = new \Shopware\Core\Content\Flow\Dispatching\Storer\UrlStorer()));
        }, 21));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Flow\FlowDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Flow\FlowDefinition
     */
    protected function getFlowDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Flow/FlowDefinition.php';

        $this->services['Shopware\\Core\\Content\\Flow\\FlowDefinition'] = $instance = new \Shopware\Core\Content\Flow\FlowDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\Aggregate\ImportExportFile\ImportExportFileDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\Aggregate\ImportExportFile\ImportExportFileDefinition
     */
    protected function getImportExportFileDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/Aggregate/ImportExportFile/ImportExportFileDefinition.php';

        $this->services['Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition'] = $instance = new \Shopware\Core\Content\ImportExport\Aggregate\ImportExportFile\ImportExportFileDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\Aggregate\ImportExportLog\ImportExportLogDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\Aggregate\ImportExportLog\ImportExportLogDefinition
     */
    protected function getImportExportLogDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/Aggregate/ImportExportLog/ImportExportLogDefinition.php';

        $this->services['Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition'] = $instance = new \Shopware\Core\Content\ImportExport\Aggregate\ImportExportLog\ImportExportLogDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\Controller\ImportExportActionController' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\Controller\ImportExportActionController
     */
    protected function getImportExportActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/Controller/ImportExportActionController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/Service/SupportedFeaturesService.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/Service/DownloadService.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/Service/AbstractMappingService.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/Service/MappingService.php';

        $a = ($this->services['import_export_profile.repository'] ?? $this->getImportExportProfile_RepositoryService());
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService());

        $this->services['Shopware\\Core\\Content\\ImportExport\\Controller\\ImportExportActionController'] = $instance = new \Shopware\Core\Content\ImportExport\Controller\ImportExportActionController(new \Shopware\Core\Content\ImportExport\Service\SupportedFeaturesService($this->parameters['import_export.supported_entities'], $this->parameters['import_export.supported_file_types']), ($this->privates['Shopware\\Core\\Content\\ImportExport\\Service\\ImportExportService'] ?? $this->getImportExportServiceService()), new \Shopware\Core\Content\ImportExport\Service\DownloadService(($this->services['shopware.filesystem.private'] ?? $this->getShopware_Filesystem_PrivateService()), ($this->services['import_export_file.repository'] ?? $this->getImportExportFile_RepositoryService())), $a, ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition'] ?? $this->getImportExportLogDefinitionService()), ($this->privates['Shopware\\Core\\Framework\\Api\\Converter\\ApiVersionConverter'] ?? $this->getApiVersionConverterService()), ($this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'] ?? $this->getImportExportFactoryService()), $b, ($this->services['messenger.default_bus'] ?? $this->getMessenger_DefaultBusService()), new \Shopware\Core\Content\ImportExport\Service\MappingService(($this->privates['Shopware\\Core\\Content\\ImportExport\\Service\\FileService'] ?? $this->getFileServiceService()), $a, $b));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\ImportExportFactory' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\ImportExportFactory
     */
    protected function getImportExportFactoryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/ImportExportFactory.php';

        $a = ($this->privates['Shopware\\Core\\Content\\ImportExport\\Service\\ImportExportService'] ?? $this->getImportExportServiceService());

        if (isset($this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'])) {
            return $this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'])) {
            return $this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'];
        }
        $c = ($this->services['import_export_log.repository'] ?? $this->getImportExportLog_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'])) {
            return $this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'];
        }
        $d = ($this->privates['Shopware\\Core\\Content\\ImportExport\\Service\\FileService'] ?? $this->getFileServiceService());

        if (isset($this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'])) {
            return $this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'];
        }

        return $this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'] = new \Shopware\Core\Content\ImportExport\ImportExportFactory($a, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['shopware.filesystem.private'] ?? $this->getShopware_Filesystem_PrivateService()), $b, $c, ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), $d, new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Content\\ImportExport\\Processing\\Reader\\CsvReaderFactory'] ?? ($this->privates['Shopware\\Core\\Content\\ImportExport\\Processing\\Reader\\CsvReaderFactory'] = new \Shopware\Core\Content\ImportExport\Processing\Reader\CsvReaderFactory()));
        }, 1), new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Content\\ImportExport\\Processing\\Writer\\CsvFileWriterFactory'] ?? $this->getCsvFileWriterFactoryService());
        }, 1), new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Content\\ImportExport\\Processing\\Pipe\\PipeFactory'] ?? $this->getPipeFactoryService());
        }, 1));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\ImportExportProfileDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\ImportExportProfileDefinition
     */
    protected function getImportExportProfileDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/ImportExportProfileDefinition.php';

        $this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition'] = $instance = new \Shopware\Core\Content\ImportExport\ImportExportProfileDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\ImportExportProfileTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\ImportExportProfileTranslationDefinition
     */
    protected function getImportExportProfileTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/ImportExportProfileTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition'] = $instance = new \Shopware\Core\Content\ImportExport\ImportExportProfileTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ImportExport\Message\ImportExportHandler' shared service.
     *
     * @return \Shopware\Core\Content\ImportExport\Message\ImportExportHandler
     */
    protected function getImportExportHandlerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ImportExport/Message/ImportExportHandler.php';

        $a = ($this->services['messenger.default_bus'] ?? $this->getMessenger_DefaultBusService());

        if (isset($this->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'])) {
            return $this->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'];
        }
        $b = ($this->services['Shopware\\Core\\Content\\ImportExport\\ImportExportFactory'] ?? $this->getImportExportFactoryService());

        if (isset($this->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'])) {
            return $this->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'];
        }

        return $this->services['Shopware\\Core\\Content\\ImportExport\\Message\\ImportExportHandler'] = new \Shopware\Core\Content\ImportExport\Message\ImportExportHandler($a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\Aggregate\LandingPageSalesChannel\LandingPageSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\Aggregate\LandingPageSalesChannel\LandingPageSalesChannelDefinition
     */
    protected function getLandingPageSalesChannelDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/LandingPage/Aggregate/LandingPageSalesChannel/LandingPageSalesChannelDefinition.php';

        $this->services['Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\Aggregate\LandingPageSalesChannel\LandingPageSalesChannelDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\Aggregate\LandingPageTag\LandingPageTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\Aggregate\LandingPageTag\LandingPageTagDefinition
     */
    protected function getLandingPageTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/LandingPage/Aggregate/LandingPageTag/LandingPageTagDefinition.php';

        $this->services['Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\Aggregate\LandingPageTag\LandingPageTagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\Aggregate\LandingPageTranslation\LandingPageTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\Aggregate\LandingPageTranslation\LandingPageTranslationDefinition
     */
    protected function getLandingPageTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/LandingPage/Aggregate/LandingPageTranslation/LandingPageTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\Aggregate\LandingPageTranslation\LandingPageTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\LandingPageDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\LandingPageDefinition
     */
    protected function getLandingPageDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/LandingPage/LandingPageDefinition.php';

        $this->services['Shopware\\Core\\Content\\LandingPage\\LandingPageDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\LandingPageDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\SalesChannel\CachedLandingPageRoute' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\SalesChannel\CachedLandingPageRoute
     */
    protected function getCachedLandingPageRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/LandingPage/SalesChannel/AbstractLandingPageRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/LandingPage/SalesChannel/CachedLandingPageRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/LandingPage/SalesChannel/LandingPageRoute.php';

        return $this->services['Shopware\\Core\\Content\\LandingPage\\SalesChannel\\CachedLandingPageRoute'] = new \Shopware\Core\Content\LandingPage\SalesChannel\CachedLandingPageRoute(new \Shopware\Core\Content\LandingPage\SalesChannel\LandingPageRoute(($this->services['sales_channel.landing_page.repository'] ?? $this->getSalesChannel_LandingPage_RepositoryService()), ($this->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? $this->getSalesChannelCmsPageLoaderService()), ($this->services['Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition'] ?? $this->getSalesChannelLandingPageDefinitionService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), []);
    }

    /*
     * Gets the public 'Shopware\Core\Content\LandingPage\SalesChannel\SalesChannelLandingPageDefinition' shared service.
     *
     * @return \Shopware\Core\Content\LandingPage\SalesChannel\SalesChannelLandingPageDefinition
     */
    protected function getSalesChannelLandingPageDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/LandingPage/LandingPageDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/LandingPage/SalesChannel/SalesChannelLandingPageDefinition.php';

        $this->services['Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition'] = $instance = new \Shopware\Core\Content\LandingPage\SalesChannel\SalesChannelLandingPageDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooterTranslation\MailHeaderFooterTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooterTranslation\MailHeaderFooterTranslationDefinition
     */
    protected function getMailHeaderFooterTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/MailTemplate/Aggregate/MailHeaderFooterTranslation/MailHeaderFooterTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooterTranslation\MailHeaderFooterTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooter\MailHeaderFooterDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooter\MailHeaderFooterDefinition
     */
    protected function getMailHeaderFooterDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/MailTemplate/Aggregate/MailHeaderFooter/MailHeaderFooterDefinition.php';

        $this->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailHeaderFooter\MailHeaderFooterDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateMedia\MailTemplateMediaDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateMedia\MailTemplateMediaDefinition
     */
    protected function getMailTemplateMediaDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/MailTemplate/Aggregate/MailTemplateMedia/MailTemplateMediaDefinition.php';

        $this->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateMedia\MailTemplateMediaDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTranslation\MailTemplateTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTranslation\MailTemplateTranslationDefinition
     */
    protected function getMailTemplateTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/MailTemplate/Aggregate/MailTemplateTranslation/MailTemplateTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTranslation\MailTemplateTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTypeTranslation\MailTemplateTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTypeTranslation\MailTemplateTypeTranslationDefinition
     */
    protected function getMailTemplateTypeTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/MailTemplate/Aggregate/MailTemplateTypeTranslation/MailTemplateTypeTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateTypeTranslation\MailTemplateTypeTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateType\MailTemplateTypeDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateType\MailTemplateTypeDefinition
     */
    protected function getMailTemplateTypeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/MailTemplate/Aggregate/MailTemplateType/MailTemplateTypeDefinition.php';

        $this->services['Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\Aggregate\MailTemplateType\MailTemplateTypeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\Api\MailActionController' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\Api\MailActionController
     */
    protected function getMailActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/MailTemplate/Api/MailActionController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/MailTemplate/Service/AttachmentLoader.php';

        $this->services['Shopware\\Core\\Content\\MailTemplate\\Api\\MailActionController'] = $instance = new \Shopware\Core\Content\MailTemplate\Api\MailActionController(($this->privates['Shopware\\Core\\Content\\Mail\\Service\\MailService'] ?? $this->getMailServiceService()), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\StringTemplateRenderer'] ?? $this->getStringTemplateRendererService()), new \Shopware\Core\Content\MailTemplate\Service\AttachmentLoader(($this->services['document.repository'] ?? $this->getDocument_RepositoryService()), ($this->privates['Shopware\\Core\\Checkout\\Document\\Service\\DocumentGenerator'] ?? $this->getDocumentGeneratorService()), ($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentService'] ?? $this->getDocumentServiceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService())));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\MailTemplate\MailTemplateDefinition' shared service.
     *
     * @return \Shopware\Core\Content\MailTemplate\MailTemplateDefinition
     */
    protected function getMailTemplateDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/MailTemplate/MailTemplateDefinition.php';

        $this->services['Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition'] = $instance = new \Shopware\Core\Content\MailTemplate\MailTemplateDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Mail\Service\MailFactory' shared service.
     *
     * @return \Shopware\Core\Content\Mail\Service\MailFactory
     */
    protected function getMailFactoryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Mail/Service/AbstractMailFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Mail/Service/MailFactory.php';

        $a = ($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService());

        if (isset($this->services['Shopware\\Core\\Content\\Mail\\Service\\MailFactory'])) {
            return $this->services['Shopware\\Core\\Content\\Mail\\Service\\MailFactory'];
        }

        return $this->services['Shopware\\Core\\Content\\Mail\\Service\\MailFactory'] = new \Shopware\Core\Content\Mail\Service\MailFactory($a, ($this->services['shopware.filesystem.public'] ?? $this->getShopware_Filesystem_PublicService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Mail\Service\MailSender' shared service.
     *
     * @return \Shopware\Core\Content\Mail\Service\MailSender
     */
    protected function getMailSenderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Mail/Service/AbstractMailSender.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Mail/Service/MailSender.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/mailer/MailerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/mailer/Mailer.php';

        $a = ($this->privates['mailer.transports'] ?? $this->getMailer_TransportsService());

        if (isset($this->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'])) {
            return $this->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'])) {
            return $this->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'];
        }
        $c = ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService());

        if (isset($this->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'])) {
            return $this->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'];
        }

        return $this->services['Shopware\\Core\\Content\\Mail\\Service\\MailSender'] = new \Shopware\Core\Content\Mail\Service\MailSender(new \Symfony\Component\Mailer\Mailer($a, NULL, $b), $c);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaDefaultFolder\MediaDefaultFolderDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaDefaultFolder\MediaDefaultFolderDefinition
     */
    protected function getMediaDefaultFolderDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Aggregate/MediaDefaultFolder/MediaDefaultFolderDefinition.php';

        $this->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaDefaultFolder\MediaDefaultFolderDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaFolderConfigurationMediaThumbnailSize\MediaFolderConfigurationMediaThumbnailSizeDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaFolderConfigurationMediaThumbnailSize\MediaFolderConfigurationMediaThumbnailSizeDefinition
     */
    protected function getMediaFolderConfigurationMediaThumbnailSizeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Aggregate/MediaFolderConfigurationMediaThumbnailSize/MediaFolderConfigurationMediaThumbnailSizeDefinition.php';

        $this->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaFolderConfigurationMediaThumbnailSize\MediaFolderConfigurationMediaThumbnailSizeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaFolderConfiguration\MediaFolderConfigurationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaFolderConfiguration\MediaFolderConfigurationDefinition
     */
    protected function getMediaFolderConfigurationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Aggregate/MediaFolderConfiguration/MediaFolderConfigurationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaFolderConfiguration\MediaFolderConfigurationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaFolder\MediaFolderDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaFolder\MediaFolderDefinition
     */
    protected function getMediaFolderDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Aggregate/MediaFolder/MediaFolderDefinition.php';

        $this->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaFolder\MediaFolderDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaTag\MediaTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaTag\MediaTagDefinition
     */
    protected function getMediaTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Aggregate/MediaTag/MediaTagDefinition.php';

        $this->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaTag\MediaTagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaThumbnailSize\MediaThumbnailSizeDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaThumbnailSize\MediaThumbnailSizeDefinition
     */
    protected function getMediaThumbnailSizeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Aggregate/MediaThumbnailSize/MediaThumbnailSizeDefinition.php';

        $this->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaThumbnailSize\MediaThumbnailSizeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaThumbnail\MediaThumbnailDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaThumbnail\MediaThumbnailDefinition
     */
    protected function getMediaThumbnailDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Aggregate/MediaThumbnail/MediaThumbnailDefinition.php';

        $this->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaThumbnail\MediaThumbnailDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Aggregate\MediaTranslation\MediaTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\Aggregate\MediaTranslation\MediaTranslationDefinition
     */
    protected function getMediaTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Aggregate/MediaTranslation/MediaTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition'] = $instance = new \Shopware\Core\Content\Media\Aggregate\MediaTranslation\MediaTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Api\MediaFolderController' shared service.
     *
     * @return \Shopware\Core\Content\Media\Api\MediaFolderController
     */
    protected function getMediaFolderControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Api/MediaFolderController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/MediaFolderService.php';

        $this->services['Shopware\\Core\\Content\\Media\\Api\\MediaFolderController'] = $instance = new \Shopware\Core\Content\Media\Api\MediaFolderController(new \Shopware\Core\Content\Media\MediaFolderService(($this->services['media.repository'] ?? $this->getMedia_RepositoryService()), ($this->services['media_folder.repository'] ?? $this->getMediaFolder_RepositoryService()), ($this->services['media_folder_configuration.repository'] ?? $this->getMediaFolderConfiguration_RepositoryService())));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\Api\MediaUploadController' shared service.
     *
     * @return \Shopware\Core\Content\Media\Api\MediaUploadController
     */
    protected function getMediaUploadControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Api/MediaUploadController.php';

        $this->services['Shopware\\Core\\Content\\Media\\Api\\MediaUploadController'] = $instance = new \Shopware\Core\Content\Media\Api\MediaUploadController(($this->privates['Shopware\\Core\\Content\\Media\\MediaService'] ?? $this->getMediaServiceService()), ($this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'] ?? $this->getFileSaverService()), ($this->privates['Shopware\\Core\\Content\\Media\\File\\FileNameProvider'] ?? $this->getFileNameProviderService()), ($this->services['Shopware\\Core\\Content\\Media\\MediaDefinition'] ?? $this->getMediaDefinitionService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\File\FileSaver' shared service.
     *
     * @return \Shopware\Core\Content\Media\File\FileSaver
     */
    protected function getFileSaverService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/File/FileSaver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Media/Metadata/MetadataLoader.php';

        $a = ($this->services['media.repository'] ?? $this->getMedia_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'])) {
            return $this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'];
        }
        $b = ($this->privates['Shopware\\Core\\Content\\Media\\Thumbnail\\ThumbnailService'] ?? $this->getThumbnailServiceService());

        if (isset($this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'])) {
            return $this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'];
        }
        $c = ($this->services['messenger.default_bus'] ?? $this->getMessenger_DefaultBusService());

        if (isset($this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'])) {
            return $this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'])) {
            return $this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'];
        }

        return $this->services['Shopware\\Core\\Content\\Media\\File\\FileSaver'] = new \Shopware\Core\Content\Media\File\FileSaver($a, ($this->services['shopware.filesystem.public'] ?? $this->getShopware_Filesystem_PublicService()), ($this->services['shopware.filesystem.private'] ?? $this->getShopware_Filesystem_PrivateService()), ($this->privates['Shopware\\Core\\Content\\Media\\Pathname\\UrlGeneratorInterface'] ?? $this->getUrlGeneratorInterfaceService()), $b, new \Shopware\Core\Content\Media\Metadata\MetadataLoader(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Content\\Media\\Metadata\\MetadataLoader\\ImageMetadataLoader'] ?? ($this->privates['Shopware\\Core\\Content\\Media\\Metadata\\MetadataLoader\\ImageMetadataLoader'] = new \Shopware\Core\Content\Media\Metadata\MetadataLoader\ImageMetadataLoader()));
        }, 1)), ($this->privates['Shopware\\Core\\Content\\Media\\TypeDetector\\TypeDetector'] ?? $this->getTypeDetectorService()), $c, $d, $this->parameters['shopware.filesystem.allowed_extensions']);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Media\MediaDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Media\MediaDefinition
     */
    protected function getMediaDefinitionService()
    {
        $this->services['Shopware\\Core\\Content\\Media\\MediaDefinition'] = $instance = new \Shopware\Core\Content\Media\MediaDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipientTag\NewsletterRecipientTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipientTag\NewsletterRecipientTagDefinition
     */
    protected function getNewsletterRecipientTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/Aggregate/NewsletterRecipientTag/NewsletterRecipientTagDefinition.php';

        $this->services['Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition'] = $instance = new \Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipientTag\NewsletterRecipientTagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipient\NewsletterRecipientDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipient\NewsletterRecipientDefinition
     */
    protected function getNewsletterRecipientDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/Aggregate/NewsletterRecipient/NewsletterRecipientDefinition.php';

        $this->services['Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipient\\NewsletterRecipientDefinition'] = $instance = new \Shopware\Core\Content\Newsletter\Aggregate\NewsletterRecipient\NewsletterRecipientDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\SalesChannel\NewsletterConfirmRoute' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterConfirmRoute
     */
    protected function getNewsletterConfirmRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/SalesChannel/AbstractNewsletterConfirmRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/SalesChannel/NewsletterConfirmRoute.php';

        return $this->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterConfirmRoute'] = new \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterConfirmRoute(($this->services['newsletter_recipient.repository'] ?? $this->getNewsletterRecipient_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\SalesChannel\NewsletterSubscribeRoute' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterSubscribeRoute
     */
    protected function getNewsletterSubscribeRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/SalesChannel/AbstractNewsletterSubscribeRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/SalesChannel/NewsletterSubscribeRoute.php';

        return $this->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterSubscribeRoute'] = new \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterSubscribeRoute(($this->services['newsletter_recipient.repository'] ?? $this->getNewsletterRecipient_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\SalesChannel\NewsletterUnsubscribeRoute' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterUnsubscribeRoute
     */
    protected function getNewsletterUnsubscribeRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/SalesChannel/AbstractNewsletterUnsubscribeRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/SalesChannel/NewsletterUnsubscribeRoute.php';

        return $this->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterUnsubscribeRoute'] = new \Shopware\Core\Content\Newsletter\SalesChannel\NewsletterUnsubscribeRoute(($this->services['newsletter_recipient.repository'] ?? $this->getNewsletterRecipient_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Newsletter\SalesChannel\SalesChannelNewsletterRecipientDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Newsletter\SalesChannel\SalesChannelNewsletterRecipientDefinition
     */
    protected function getSalesChannelNewsletterRecipientDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/Aggregate/NewsletterRecipient/NewsletterRecipientDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Newsletter/SalesChannel/SalesChannelNewsletterRecipientDefinition.php';

        $this->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition'] = $instance = new \Shopware\Core\Content\Newsletter\SalesChannel\SalesChannelNewsletterRecipientDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\Api\ProductExportController' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\Api\ProductExportController
     */
    protected function getProductExportControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/Api/ProductExportController.php';

        $this->services['Shopware\\Core\\Content\\ProductExport\\Api\\ProductExportController'] = $instance = new \Shopware\Core\Content\ProductExport\Api\ProductExportController(($this->services['sales_channel_domain.repository'] ?? $this->getSalesChannelDomain_RepositoryService()), ($this->services['sales_channel.repository'] ?? $this->getSalesChannel_RepositoryService()), ($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'] ?? $this->getProductExportGeneratorService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\ProductExportDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\ProductExportDefinition
     */
    protected function getProductExportDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/ProductExportDefinition.php';

        $this->services['Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition'] = $instance = new \Shopware\Core\Content\ProductExport\ProductExportDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\ProductExportHydrator' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\ProductExportHydrator
     */
    protected function getProductExportHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/ProductExportHydrator.php';

        return $this->services['Shopware\\Core\\Content\\ProductExport\\ProductExportHydrator'] = new \Shopware\Core\Content\ProductExport\ProductExportHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\SalesChannel\ExportController' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\SalesChannel\ExportController
     */
    protected function getExportControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/SalesChannel/ExportController.php';

        return $this->services['Shopware\\Core\\Content\\ProductExport\\SalesChannel\\ExportController'] = new \Shopware\Core\Content\ProductExport\SalesChannel\ExportController(($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExporter'] ?? $this->getProductExporterService()), ($this->privates['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportFileHandler'] ?? $this->getProductExportFileHandlerService()), ($this->services['shopware.filesystem.private'] ?? $this->getShopware_Filesystem_PrivateService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['product_export.repository'] ?? $this->getProductExport_RepositoryService()), ($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'] ?? $this->getSalesChannelContextFactoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\Service\ProductExportGenerator' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\Service\ProductExportGenerator
     */
    protected function getProductExportGeneratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/Service/ProductExportGeneratorInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/Service/ProductExportGenerator.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/Service/ProductExportValidatorInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/Service/ProductExportValidator.php';

        $a = ($this->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'] ?? $this->getProductStreamBuilderService());

        if (isset($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $b = ($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $c = ($this->privates['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportRenderer'] ?? $this->getProductExportRendererService());

        if (isset($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $e = ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? $this->getSalesChannelContextServiceService());

        if (isset($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $f = ($this->services['translator'] ?? $this->getTranslatorService());

        if (isset($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $g = ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? $this->getSalesChannelContextPersisterService());

        if (isset($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }
        $h = ($this->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\TwigVariableParser'] ?? $this->getTwigVariableParserService());

        if (isset($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'])) {
            return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'];
        }

        return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'] = new \Shopware\Core\Content\ProductExport\Service\ProductExportGenerator($a, $b, $c, $d, new \Shopware\Core\Content\ProductExport\Service\ProductExportValidator(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Content\\ProductExport\\Validator\\XmlValidator'] ?? ($this->privates['Shopware\\Core\\Content\\ProductExport\\Validator\\XmlValidator'] = new \Shopware\Core\Content\ProductExport\Validator\XmlValidator()));
        }, 1)), $e, $f, $g, ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), 100, ($this->services['Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface'] ?? $this->getSeoUrlPlaceholderHandlerInterfaceService()), $h, ($this->services['Shopware\\Core\\Content\\Product\\ProductDefinition'] ?? $this->getProductDefinitionService()), ($this->privates['Shopware\\Core\\System\\Locale\\LanguageLocaleCodeProvider'] ?? $this->getLanguageLocaleCodeProviderService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductExport\Service\ProductExporter' shared service.
     *
     * @return \Shopware\Core\Content\ProductExport\Service\ProductExporter
     */
    protected function getProductExporterService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/Service/ProductExporterInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductExport/Service/ProductExporter.php';

        return $this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExporter'] = new \Shopware\Core\Content\ProductExport\Service\ProductExporter(($this->services['product_export.repository'] ?? $this->getProductExport_RepositoryService()), ($this->services['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportGenerator'] ?? $this->getProductExportGeneratorService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Content\\ProductExport\\Service\\ProductExportFileHandler'] ?? $this->getProductExportFileHandlerService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterDefinition
     */
    protected function getProductStreamFilterDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductStream/Aggregate/ProductStreamFilter/ProductStreamFilterDefinition.php';

        $this->services['Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition'] = $instance = new \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterHydrator' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterHydrator
     */
    protected function getProductStreamFilterHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductStream/Aggregate/ProductStreamFilter/ProductStreamFilterHydrator.php';

        return $this->services['Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterHydrator'] = new \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamFilter\ProductStreamFilterHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\Aggregate\ProductStreamTranslation\ProductStreamTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamTranslation\ProductStreamTranslationDefinition
     */
    protected function getProductStreamTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductStream/Aggregate/ProductStreamTranslation/ProductStreamTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition'] = $instance = new \Shopware\Core\Content\ProductStream\Aggregate\ProductStreamTranslation\ProductStreamTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\ProductStreamDefinition' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\ProductStreamDefinition
     */
    protected function getProductStreamDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductStream/ProductStreamDefinition.php';

        $this->services['Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition'] = $instance = new \Shopware\Core\Content\ProductStream\ProductStreamDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\ProductStreamHydrator' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\ProductStreamHydrator
     */
    protected function getProductStreamHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductStream/ProductStreamHydrator.php';

        return $this->services['Shopware\\Core\\Content\\ProductStream\\ProductStreamHydrator'] = new \Shopware\Core\Content\ProductStream\ProductStreamHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\ProductStream\Service\ProductStreamBuilder' shared service.
     *
     * @return \Shopware\Core\Content\ProductStream\Service\ProductStreamBuilder
     */
    protected function getProductStreamBuilderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductStream/Service/ProductStreamBuilderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/ProductStream/Service/ProductStreamBuilder.php';

        $a = ($this->services['product_stream.repository'] ?? $this->getProductStream_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'])) {
            return $this->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'];
        }

        return $this->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'] = new \Shopware\Core\Content\ProductStream\Service\ProductStreamBuilder($a, ($this->services['Shopware\\Core\\Content\\Product\\ProductDefinition'] ?? $this->getProductDefinitionService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCategoryTree\ProductCategoryTreeDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCategoryTree\ProductCategoryTreeDefinition
     */
    protected function getProductCategoryTreeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductCategoryTree/ProductCategoryTreeDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCategoryTree\ProductCategoryTreeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCategory\ProductCategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCategory\ProductCategoryDefinition
     */
    protected function getProductCategoryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductCategory/ProductCategoryDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCategory\ProductCategoryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingDefinition
     */
    protected function getProductConfiguratorSettingDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductConfiguratorSetting/ProductConfiguratorSettingDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingHydrator
     */
    protected function getProductConfiguratorSettingHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductConfiguratorSetting/ProductConfiguratorSettingHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductConfiguratorSetting\ProductConfiguratorSettingHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsDefinition
     */
    protected function getProductCrossSellingAssignedProductsDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductCrossSellingAssignedProducts/ProductCrossSellingAssignedProductsDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsHydrator
     */
    protected function getProductCrossSellingAssignedProductsHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductCrossSellingAssignedProducts/ProductCrossSellingAssignedProductsHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingAssignedProducts\ProductCrossSellingAssignedProductsHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSellingTranslation\ProductCrossSellingTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingTranslation\ProductCrossSellingTranslationDefinition
     */
    protected function getProductCrossSellingTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductCrossSellingTranslation/ProductCrossSellingTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSellingTranslation\ProductCrossSellingTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingDefinition
     */
    protected function getProductCrossSellingDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductCrossSelling/ProductCrossSellingDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingHydrator
     */
    protected function getProductCrossSellingHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductCrossSelling/ProductCrossSellingHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductCrossSelling\ProductCrossSellingHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductCustomFieldSet\ProductCustomFieldSetDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductCustomFieldSet\ProductCustomFieldSetDefinition
     */
    protected function getProductCustomFieldSetDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductCustomFieldSet/ProductCustomFieldSetDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductCustomFieldSet\ProductCustomFieldSetDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductFeatureSetTranslation\ProductFeatureSetTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductFeatureSetTranslation\ProductFeatureSetTranslationDefinition
     */
    protected function getProductFeatureSetTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductFeatureSetTranslation/ProductFeatureSetTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductFeatureSetTranslation\ProductFeatureSetTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetDefinition
     */
    protected function getProductFeatureSetDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductFeatureSet/ProductFeatureSetDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetHydrator
     */
    protected function getProductFeatureSetHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductFeatureSet/ProductFeatureSetHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductFeatureSet\ProductFeatureSetHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryDefinition
     */
    protected function getProductKeywordDictionaryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductKeywordDictionary/ProductKeywordDictionaryDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryHydrator
     */
    protected function getProductKeywordDictionaryHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductKeywordDictionary/ProductKeywordDictionaryHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductKeywordDictionary\ProductKeywordDictionaryHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductManufacturerTranslation\ProductManufacturerTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductManufacturerTranslation\ProductManufacturerTranslationDefinition
     */
    protected function getProductManufacturerTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductManufacturerTranslation/ProductManufacturerTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductManufacturerTranslation\ProductManufacturerTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerDefinition
     */
    protected function getProductManufacturerDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductManufacturer/ProductManufacturerDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerHydrator
     */
    protected function getProductManufacturerHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductManufacturer/ProductManufacturerHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductManufacturer\ProductManufacturerHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaDefinition
     */
    protected function getProductMediaDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductMedia/ProductMediaDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaHydrator
     */
    protected function getProductMediaHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductMedia/ProductMediaHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductMedia\ProductMediaHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductOption\ProductOptionDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductOption\ProductOptionDefinition
     */
    protected function getProductOptionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductOption/ProductOptionDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductOption\ProductOptionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceDefinition
     */
    protected function getProductPriceDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductPrice/ProductPriceDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceHydrator
     */
    protected function getProductPriceHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductPrice/ProductPriceHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductPrice\ProductPriceHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductProperty\ProductPropertyDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductProperty\ProductPropertyDefinition
     */
    protected function getProductPropertyDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductProperty/ProductPropertyDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductProperty\ProductPropertyDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewDefinition
     */
    protected function getProductReviewDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductReview/ProductReviewDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewHydrator
     */
    protected function getProductReviewHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductReview/ProductReviewHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductReview\ProductReviewHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldDefinition
     */
    protected function getProductSearchConfigFieldDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductSearchConfigField/ProductSearchConfigFieldDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldHydrator
     */
    protected function getProductSearchConfigFieldHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductSearchConfigField/ProductSearchConfigFieldHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigDefinition
     */
    protected function getProductSearchConfigDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductSearchConfig/ProductSearchConfigDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigHydrator
     */
    protected function getProductSearchConfigHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductSearchConfig/ProductSearchConfigHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordDefinition
     */
    protected function getProductSearchKeywordDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductSearchKeyword/ProductSearchKeywordDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordHydrator
     */
    protected function getProductSearchKeywordHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductSearchKeyword/ProductSearchKeywordHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductSearchKeyword\ProductSearchKeywordHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductStreamMapping\ProductStreamMappingDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductStreamMapping\ProductStreamMappingDefinition
     */
    protected function getProductStreamMappingDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductStreamMapping/ProductStreamMappingDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductStreamMapping\ProductStreamMappingDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductTag\ProductTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductTag\ProductTagDefinition
     */
    protected function getProductTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductTag/ProductTagDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductTag\ProductTagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductTranslation\ProductTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductTranslation\ProductTranslationDefinition
     */
    protected function getProductTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductTranslation/ProductTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductTranslation\ProductTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityDefinition
     */
    protected function getProductVisibilityDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductVisibility/ProductVisibilityDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition'] = $instance = new \Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityHydrator
     */
    protected function getProductVisibilityHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Aggregate/ProductVisibility/ProductVisibilityHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityHydrator'] = new \Shopware\Core\Content\Product\Aggregate\ProductVisibility\ProductVisibilityHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\Api\ProductActionController' shared service.
     *
     * @return \Shopware\Core\Content\Product\Api\ProductActionController
     */
    protected function getProductActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Api/ProductActionController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Util/VariantCombinationLoader.php';

        $this->services['Shopware\\Core\\Content\\Product\\Api\\ProductActionController'] = $instance = new \Shopware\Core\Content\Product\Api\ProductActionController(new \Shopware\Core\Content\Product\Util\VariantCombinationLoader(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService())));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\DataAbstractionLayer\CheapestPrice\CheapestPriceAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Content\Product\DataAbstractionLayer\CheapestPrice\CheapestPriceAccessorBuilder
     */
    protected function getCheapestPriceAccessorBuilderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/FieldAccessorBuilderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/DataAbstractionLayer/CheapestPrice/CheapestPriceAccessorBuilder.php';

        return $this->services['Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\CheapestPrice\\CheapestPriceAccessorBuilder'] = new \Shopware\Core\Content\Product\DataAbstractionLayer\CheapestPrice\CheapestPriceAccessorBuilder(100, ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\ProductDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\ProductDefinition
     */
    protected function getProductDefinitionService()
    {
        $this->services['Shopware\\Core\\Content\\Product\\ProductDefinition'] = $instance = new \Shopware\Core\Content\Product\ProductDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\ProductHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\ProductHydrator
     */
    protected function getProductHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/ProductHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\ProductHydrator'] = new \Shopware\Core\Content\Product\ProductHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\CrossSelling\CachedProductCrossSellingRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\CrossSelling\CachedProductCrossSellingRoute
     */
    protected function getCachedProductCrossSellingRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/CrossSelling/AbstractProductCrossSellingRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/CrossSelling/CachedProductCrossSellingRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/CrossSelling/ProductCrossSellingRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/AbstractProductCloseoutFilterFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/ProductCloseoutFilterFactory.php';

        $a = ($this->services['product_cross_selling.repository'] ?? $this->getProductCrossSelling_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'];
        }
        $c = ($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'];
        }
        $d = ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'];
        }
        $e = ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingLoader'] ?? $this->getProductListingLoaderService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'];
        }
        $f = ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'];
        }

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'] = new \Shopware\Core\Content\Product\SalesChannel\CrossSelling\CachedProductCrossSellingRoute(new \Shopware\Core\Content\Product\SalesChannel\CrossSelling\ProductCrossSellingRoute($a, $b, ($this->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'] ?? $this->getProductStreamBuilderService()), $c, $d, $e, ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] = new \Shopware\Core\Content\Product\SalesChannel\ProductCloseoutFilterFactory()))), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), $f, $b, []);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Detail\CachedProductDetailRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Detail\CachedProductDetailRoute
     */
    protected function getCachedProductDetailRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Detail/AbstractProductDetailRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Detail/CachedProductDetailRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Detail/ProductDetailRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/AbstractProductCloseoutFilterFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/ProductCloseoutFilterFactory.php';

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\CachedProductDetailRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Detail\CachedProductDetailRoute(new \Shopware\Core\Content\Product\SalesChannel\Detail\ProductDetailRoute(($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->privates['Shopware\\Storefront\\Page\\Product\\Configurator\\ProductPageConfiguratorLoader'] ?? $this->getProductPageConfiguratorLoaderService()), ($this->privates['Shopware\\Core\\Content\\Category\\Service\\CategoryBreadcrumbBuilder'] ?? $this->getCategoryBreadcrumbBuilderService()), ($this->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? $this->getSalesChannelCmsPageLoaderService()), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition'] ?? $this->getSalesChannelProductDefinitionService()), ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] = new \Shopware\Core\Content\Product\SalesChannel\ProductCloseoutFilterFactory()))), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), []);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\FindVariant\FindProductVariantRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\FindVariant\FindProductVariantRoute
     */
    protected function getFindProductVariantRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/FindVariant/AbstractFindProductVariantRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/FindVariant/FindProductVariantRoute.php';

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\FindVariant\\FindProductVariantRoute'] = new \Shopware\Core\Content\Product\SalesChannel\FindVariant\FindProductVariantRoute(($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Listing\CachedProductListingRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Listing\CachedProductListingRoute
     */
    protected function getCachedProductListingRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Listing/AbstractProductListingRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Listing/CachedProductListingRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Listing/ProductListingRoute.php';

        $a = ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingLoader'] ?? $this->getProductListingLoaderService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'];
        }
        $c = ($this->services['category.repository'] ?? $this->getCategory_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'];
        }
        $d = ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'];
        }

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Listing\CachedProductListingRoute(new \Shopware\Core\Content\Product\SalesChannel\Listing\ProductListingRoute($a, $b, $c, ($this->services['Shopware\\Core\\Content\\ProductStream\\Service\\ProductStreamBuilder'] ?? $this->getProductStreamBuilderService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), $d, $b, []);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Listing\ResolveCriteriaProductListingRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Listing\ResolveCriteriaProductListingRoute
     */
    protected function getResolveCriteriaProductListingRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Listing/AbstractProductListingRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Listing/ResolveCriteriaProductListingRoute.php';

        $a = ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\CachedProductListingRoute'] ?? $this->getCachedProductListingRouteService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute'];
        }

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Listing\ResolveCriteriaProductListingRoute($a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\ProductListRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\ProductListRoute
     */
    protected function getProductListRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/AbstractProductListRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/ProductListRoute.php';

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductListRoute'] = new \Shopware\Core\Content\Product\SalesChannel\ProductListRoute(($this->services['sales_channel.product.repository'] ?? $this->getSalesChannel_Product_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Review\CachedProductReviewRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Review\CachedProductReviewRoute
     */
    protected function getCachedProductReviewRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Review/AbstractProductReviewRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Review/CachedProductReviewRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Review/ProductReviewRoute.php';

        $a = ($this->services['product_review.repository'] ?? $this->getProductReview_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute'];
        }
        $b = ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute'])) {
            return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute'];
        }

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Review\CachedProductReviewRoute(new \Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewRoute($a), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), $b, $c, []);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewSaveRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewSaveRoute
     */
    protected function getProductReviewSaveRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Review/AbstractProductReviewSaveRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Review/ProductReviewSaveRoute.php';

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewSaveRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Review\ProductReviewSaveRoute(($this->services['product_review.repository'] ?? $this->getProductReview_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\SalesChannelProductDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\SalesChannelProductDefinition
     */
    protected function getSalesChannelProductDefinitionService()
    {
        $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition'] = $instance = new \Shopware\Core\Content\Product\SalesChannel\SalesChannelProductDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Search\CachedProductSearchRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Search\CachedProductSearchRoute
     */
    protected function getCachedProductSearchRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Search/AbstractProductSearchRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Search/CachedProductSearchRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Search/ProductSearchRoute.php';

        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\CachedProductSearchRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Search\CachedProductSearchRoute(new \Shopware\Core\Content\Product\SalesChannel\Search\ProductSearchRoute(($this->privates['Shopware\\Elasticsearch\\Product\\ProductSearchBuilder'] ?? $this->getProductSearchBuilderService()), $a, ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingLoader'] ?? $this->getProductListingLoaderService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), $a, []);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Search\ResolvedCriteriaProductSearchRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Search\ResolvedCriteriaProductSearchRoute
     */
    protected function getResolvedCriteriaProductSearchRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Search/AbstractProductSearchRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Search/ResolvedCriteriaProductSearchRoute.php';

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Search\ResolvedCriteriaProductSearchRoute(($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\CachedProductSearchRoute'] ?? $this->getCachedProductSearchRouteService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? $this->getRequestCriteriaBuilderService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingDefinition
     */
    protected function getProductSortingDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Sorting/ProductSortingDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition'] = $instance = new \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingHydrator
     */
    protected function getProductSortingHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Sorting/ProductSortingHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingHydrator'] = new \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingTranslationDefinition
     */
    protected function getProductSortingTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Sorting/ProductSortingTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition'] = $instance = new \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Product\SalesChannel\Suggest\CachedProductSuggestRoute' shared service.
     *
     * @return \Shopware\Core\Content\Product\SalesChannel\Suggest\CachedProductSuggestRoute
     */
    protected function getCachedProductSuggestRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Suggest/AbstractProductSuggestRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Suggest/CachedProductSuggestRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/Suggest/ProductSuggestRoute.php';

        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        return $this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\CachedProductSuggestRoute'] = new \Shopware\Core\Content\Product\SalesChannel\Suggest\CachedProductSuggestRoute(new \Shopware\Core\Content\Product\SalesChannel\Suggest\ProductSuggestRoute(($this->privates['Shopware\\Elasticsearch\\Product\\ProductSearchBuilder'] ?? $this->getProductSearchBuilderService()), $a, ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ProductListingLoader'] ?? $this->getProductListingLoaderService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), $a, []);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\Aggregate\PropertyGroupOptionTranslation\PropertyGroupOptionTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Property\Aggregate\PropertyGroupOptionTranslation\PropertyGroupOptionTranslationDefinition
     */
    protected function getPropertyGroupOptionTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Property/Aggregate/PropertyGroupOptionTranslation/PropertyGroupOptionTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition'] = $instance = new \Shopware\Core\Content\Property\Aggregate\PropertyGroupOptionTranslation\PropertyGroupOptionTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionDefinition
     */
    protected function getPropertyGroupOptionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Property/Aggregate/PropertyGroupOption/PropertyGroupOptionDefinition.php';

        $this->services['Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition'] = $instance = new \Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionHydrator
     */
    protected function getPropertyGroupOptionHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Property/Aggregate/PropertyGroupOption/PropertyGroupOptionHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionHydrator'] = new \Shopware\Core\Content\Property\Aggregate\PropertyGroupOption\PropertyGroupOptionHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\Aggregate\PropertyGroupTranslation\PropertyGroupTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Property\Aggregate\PropertyGroupTranslation\PropertyGroupTranslationDefinition
     */
    protected function getPropertyGroupTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Property/Aggregate/PropertyGroupTranslation/PropertyGroupTranslationDefinition.php';

        $this->services['Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition'] = $instance = new \Shopware\Core\Content\Property\Aggregate\PropertyGroupTranslation\PropertyGroupTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\PropertyGroupDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Property\PropertyGroupDefinition
     */
    protected function getPropertyGroupDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Property/PropertyGroupDefinition.php';

        $this->services['Shopware\\Core\\Content\\Property\\PropertyGroupDefinition'] = $instance = new \Shopware\Core\Content\Property\PropertyGroupDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Property\PropertyGroupHydrator' shared service.
     *
     * @return \Shopware\Core\Content\Property\PropertyGroupHydrator
     */
    protected function getPropertyGroupHydratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Property/PropertyGroupHydrator.php';

        return $this->services['Shopware\\Core\\Content\\Property\\PropertyGroupHydrator'] = new \Shopware\Core\Content\Property\PropertyGroupHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Content\Rule\Aggregate\RuleCondition\RuleConditionDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Rule\Aggregate\RuleCondition\RuleConditionDefinition
     */
    protected function getRuleConditionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Rule/Aggregate/RuleCondition/RuleConditionDefinition.php';

        $this->services['Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition'] = $instance = new \Shopware\Core\Content\Rule\Aggregate\RuleCondition\RuleConditionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Rule\Aggregate\RuleTag\RuleTagDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Rule\Aggregate\RuleTag\RuleTagDefinition
     */
    protected function getRuleTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Rule/Aggregate/RuleTag/RuleTagDefinition.php';

        $this->services['Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition'] = $instance = new \Shopware\Core\Content\Rule\Aggregate\RuleTag\RuleTagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Rule\RuleDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Rule\RuleDefinition
     */
    protected function getRuleDefinitionService()
    {
        $this->services['Shopware\\Core\\Content\\Rule\\RuleDefinition'] = $instance = new \Shopware\Core\Content\Rule\RuleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\Api\SeoActionController' shared service.
     *
     * @return \Shopware\Core\Content\Seo\Api\SeoActionController
     */
    protected function getSeoActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/Api/SeoActionController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/Validation/SeoUrlDataValidationFactoryInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/Validation/SeoUrlValidationFactory.php';

        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService());

        $this->services['Shopware\\Core\\Content\\Seo\\Api\\SeoActionController'] = $instance = new \Shopware\Core\Content\Seo\Api\SeoActionController(($this->privates['Shopware\\Core\\Content\\Seo\\SeoUrlGenerator'] ?? $this->getSeoUrlGeneratorService()), ($this->privates['Shopware\\Core\\Content\\Seo\\SeoUrlPersister'] ?? $this->getSeoUrlPersisterService()), $a, ($this->privates['Shopware\\Core\\Content\\Seo\\SeoUrlRoute\\SeoUrlRouteRegistry'] ?? $this->getSeoUrlRouteRegistryService()), new \Shopware\Core\Content\Seo\Validation\SeoUrlValidationFactory(), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->services['sales_channel.repository'] ?? $this->getSalesChannel_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? $this->getRequestCriteriaBuilderService()), $a);

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\CachedSeoResolver' shared service.
     *
     * @return \Shopware\Core\Content\Seo\CachedSeoResolver
     */
    protected function getCachedSeoResolverService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/AbstractSeoResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/CachedSeoResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SeoResolver.php';

        return $this->services['Shopware\\Core\\Content\\Seo\\CachedSeoResolver'] = new \Shopware\Core\Content\Seo\CachedSeoResolver(new \Shopware\Core\Content\Seo\SeoResolver(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\EmptyPathInfoResolver' shared service.
     *
     * @return \Shopware\Core\Content\Seo\EmptyPathInfoResolver
     */
    protected function getEmptyPathInfoResolverService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/AbstractSeoResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/EmptyPathInfoResolver.php';

        return $this->services['Shopware\\Core\\Content\\Seo\\EmptyPathInfoResolver'] = new \Shopware\Core\Content\Seo\EmptyPathInfoResolver(($this->services['Shopware\\Core\\Content\\Seo\\CachedSeoResolver'] ?? $this->getCachedSeoResolverService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\Entity\Dbal\SeoUrlAssociationFieldResolver' shared service.
     *
     * @return \Shopware\Core\Content\Seo\Entity\Dbal\SeoUrlAssociationFieldResolver
     */
    protected function getSeoUrlAssociationFieldResolverService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/AbstractFieldResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/Entity/Dbal/SeoUrlAssociationFieldResolver.php';

        return $this->services['Shopware\\Core\\Content\\Seo\\Entity\\Dbal\\SeoUrlAssociationFieldResolver'] = new \Shopware\Core\Content\Seo\Entity\Dbal\SeoUrlAssociationFieldResolver(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper())));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\Entity\Serializer\SeoUrlFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Content\Seo\Entity\Serializer\SeoUrlFieldSerializer
     */
    protected function getSeoUrlFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/OneToManyAssociationFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/Entity/Serializer/SeoUrlFieldSerializer.php';

        return $this->services['Shopware\\Core\\Content\\Seo\\Entity\\Serializer\\SeoUrlFieldSerializer'] = new \Shopware\Core\Content\Seo\Entity\Serializer\SeoUrlFieldSerializer(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? $this->getWriteCommandExtractorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\MainCategory\MainCategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\MainCategory\MainCategoryDefinition
     */
    protected function getMainCategoryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/MainCategory/MainCategoryDefinition.php';

        $this->services['Shopware\\Core\\Content\\Seo\\MainCategory\\MainCategoryDefinition'] = $instance = new \Shopware\Core\Content\Seo\MainCategory\MainCategoryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\MainCategory\SalesChannel\SalesChannelMainCategoryDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\MainCategory\SalesChannel\SalesChannelMainCategoryDefinition
     */
    protected function getSalesChannelMainCategoryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/MainCategory/MainCategoryDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/MainCategory/SalesChannel/SalesChannelMainCategoryDefinition.php';

        $this->services['Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition'] = $instance = new \Shopware\Core\Content\Seo\MainCategory\SalesChannel\SalesChannelMainCategoryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SalesChannel\SeoUrlRoute' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SalesChannel\SeoUrlRoute
     */
    protected function getSeoUrlRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SalesChannel/AbstractSeoUrlRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SalesChannel/SeoUrlRoute.php';

        return $this->services['Shopware\\Core\\Content\\Seo\\SalesChannel\\SeoUrlRoute'] = new \Shopware\Core\Content\Seo\SalesChannel\SeoUrlRoute(($this->services['sales_channel.seo_url.repository'] ?? $this->getSalesChannel_SeoUrl_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SeoUrlPlaceholderHandlerInterface' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SeoUrlPlaceholderHandler
     */
    protected function getSeoUrlPlaceholderHandlerInterfaceService()
    {
        return $this->services['Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface'] = new \Shopware\Core\Content\Seo\SeoUrlPlaceholderHandler(($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['router.default'] ?? $this->getRouter_DefaultService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SeoUrlTemplate\SeoUrlTemplateDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SeoUrlTemplate\SeoUrlTemplateDefinition
     */
    protected function getSeoUrlTemplateDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Seo/SeoUrlTemplate/SeoUrlTemplateDefinition.php';

        $this->services['Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition'] = $instance = new \Shopware\Core\Content\Seo\SeoUrlTemplate\SeoUrlTemplateDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SeoUrl\SalesChannel\SalesChannelSeoUrlDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SeoUrl\SalesChannel\SalesChannelSeoUrlDefinition
     */
    protected function getSalesChannelSeoUrlDefinitionService()
    {
        $this->services['Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition'] = $instance = new \Shopware\Core\Content\Seo\SeoUrl\SalesChannel\SalesChannelSeoUrlDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Seo\SeoUrl\SeoUrlDefinition' shared service.
     *
     * @return \Shopware\Core\Content\Seo\SeoUrl\SeoUrlDefinition
     */
    protected function getSeoUrlDefinitionService()
    {
        $this->services['Shopware\\Core\\Content\\Seo\\SeoUrl\\SeoUrlDefinition'] = $instance = new \Shopware\Core\Content\Seo\SeoUrl\SeoUrlDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Content\Sitemap\SalesChannel\CachedSitemapRoute' shared service.
     *
     * @return \Shopware\Core\Content\Sitemap\SalesChannel\CachedSitemapRoute
     */
    protected function getCachedSitemapRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Sitemap/SalesChannel/AbstractSitemapRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Sitemap/SalesChannel/CachedSitemapRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Sitemap/SalesChannel/SitemapRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Sitemap/Service/SitemapListerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Sitemap/Service/SitemapLister.php';

        $a = ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService());

        return $this->services['Shopware\\Core\\Content\\Sitemap\\SalesChannel\\CachedSitemapRoute'] = new \Shopware\Core\Content\Sitemap\SalesChannel\CachedSitemapRoute(new \Shopware\Core\Content\Sitemap\SalesChannel\SitemapRoute(new \Shopware\Core\Content\Sitemap\Service\SitemapLister(($this->services['shopware.filesystem.sitemap'] ?? $this->getShopware_Filesystem_SitemapService()), ($this->privates['shopware.asset.sitemap'] ?? $this->getShopware_Asset_SitemapService())), $a, ($this->privates['Shopware\\Core\\Content\\Sitemap\\Service\\SitemapExporter'] ?? $this->getSitemapExporterService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), [], $a);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Asset\AssetPackageService' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Asset\AssetPackageService
     */
    protected function getAssetPackageServiceService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Asset/AssetPackageService.php';

        return $this->services['Shopware\\Core\\Framework\\Adapter\\Asset\\AssetPackageService'] = new \Shopware\Core\Framework\Adapter\Asset\AssetPackageService(($this->privates['assets.packages'] ?? $this->getAssets_PackagesService()), new \Shopware\Core\Framework\Adapter\Asset\FallbackUrlPackage([0 => ''], ($this->privates['assets.empty_version_strategy'] ?? ($this->privates['assets.empty_version_strategy'] = new \Symfony\Component\Asset\VersionStrategy\EmptyVersionStrategy()))), ($this->privates['shopware.asset.asset.version_strategy'] ?? $this->getShopware_Asset_Asset_VersionStrategyService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Cache\CacheIdLoader' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Cache\CacheIdLoader
     */
    protected function getCacheIdLoaderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Cache/CacheIdLoader.php';

        return $this->services['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheIdLoader'] = new \Shopware\Core\Framework\Adapter\Cache\CacheIdLoader(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->privates['cache.messenger.restart_workers_signal'] ?? $this->getCache_Messenger_RestartWorkersSignalService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Cache\Script\Facade\CacheInvalidatorFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Cache\Script\Facade\CacheInvalidatorFacadeHookFactory
     */
    protected function getCacheInvalidatorFacadeHookFactoryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Execution/Awareness/HookServiceFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Cache/Script/Facade/CacheInvalidatorFacadeHookFactory.php';

        return $this->services['Shopware\\Core\\Framework\\Adapter\\Cache\\Script\\Facade\\CacheInvalidatorFacadeHookFactory'] = new \Shopware\Core\Framework\Adapter\Cache\Script\Facade\CacheInvalidatorFacadeHookFactory(($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheInvalidator'] ?? $this->getCacheInvalidatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Twig\AppTemplateIterator' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Twig\AppTemplateIterator
     */
    protected function getAppTemplateIteratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/AppTemplateIterator.php';

        return $this->services['Shopware\\Core\\Framework\\Adapter\\Twig\\AppTemplateIterator'] = new \Shopware\Core\Framework\Adapter\Twig\AppTemplateIterator(($this->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateIterator'] ?? $this->getTemplateIteratorService()), ($this->services['app_template.repository'] ?? $this->getAppTemplate_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Twig\TemplateFinder' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Twig\TemplateFinder
     */
    protected function getTemplateFinderService()
    {
        $a = ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService());

        if (isset($this->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder'])) {
            return $this->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder'];
        }

        return $this->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateFinder'] = new \Shopware\Core\Framework\Adapter\Twig\TemplateFinder($a, ($this->privates['twig.loader.chain'] ?? $this->getTwig_Loader_ChainService()), $this->targetDir.'', new \Shopware\Core\Framework\Adapter\Twig\NamespaceHierarchy\NamespaceHierarchyBuilder(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\NamespaceHierarchy\\BundleHierarchyBuilder'] ?? $this->getBundleHierarchyBuilderService());
            yield 1 => ($this->privates['Shopware\\Storefront\\Theme\\Twig\\ThemeNamespaceHierarchyBuilder'] ?? $this->getThemeNamespaceHierarchyBuilderService());
        }, 2)));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Adapter\Twig\TemplateIterator' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Twig\TemplateIterator
     */
    protected function getTemplateIteratorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Twig/TemplateIterator.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/twig-bundle/TemplateIterator.php';

        return $this->services['Shopware\\Core\\Framework\\Adapter\\Twig\\TemplateIterator'] = new \Shopware\Core\Framework\Adapter\Twig\TemplateIterator(new \Symfony\Bundle\TwigBundle\TemplateIterator(($this->services['kernel'] ?? $this->get('kernel', 1)), [(\dirname(__DIR__, 4).'/vendor/symfony/twig-bridge/Resources/views/Email') => 'email'], (\dirname(__DIR__, 4).'/templates')), $this->parameters['kernel.bundles']);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Acl\AclCriteriaValidator' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Acl\AclCriteriaValidator
     */
    protected function getAclCriteriaValidatorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Acl/AclCriteriaValidator.php';

        return $this->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] = new \Shopware\Core\Framework\Api\Acl\AclCriteriaValidator(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Acl\Role\AclRoleDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Acl\Role\AclRoleDefinition
     */
    protected function getAclRoleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Acl/Role/AclRoleDefinition.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition'] = $instance = new \Shopware\Core\Framework\Api\Acl\Role\AclRoleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Acl\Role\AclUserRoleDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Acl\Role\AclUserRoleDefinition
     */
    protected function getAclUserRoleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Acl/Role/AclUserRoleDefinition.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition'] = $instance = new \Shopware\Core\Framework\Api\Acl\Role\AclUserRoleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\AccessKeyController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\AccessKeyController
     */
    protected function getAccessKeyControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/AccessKeyController.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\AccessKeyController'] = $instance = new \Shopware\Core\Framework\Api\Controller\AccessKeyController();

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\AclController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\AclController
     */
    protected function getAclControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/AclController.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\AclController'] = $instance = new \Shopware\Core\Framework\Api\Controller\AclController(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['router'] ?? $this->getRouterService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\ApiController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\ApiController
     */
    protected function getApiControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/ApiController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Search/RequestCriteriaBuilder.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Search/Parser/AggregationParser.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityProtection/EntityProtectionValidator.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\ApiController'] = $instance = new \Shopware\Core\Framework\Api\Controller\ApiController(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['.container.private.serializer'] ?? $this->get_Container_Private_SerializerService()), new \Shopware\Core\Framework\DataAbstractionLayer\Search\RequestCriteriaBuilder(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Parser\\AggregationParser'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Parser\\AggregationParser'] = new \Shopware\Core\Framework\DataAbstractionLayer\Search\Parser\AggregationParser())), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\ApiCriteriaValidator'] ?? $this->getApiCriteriaValidatorService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\CriteriaArrayConverter'] ?? $this->getCriteriaArrayConverterService())), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\CompositeEntitySearcher'] ?? $this->getCompositeEntitySearcherService()), ($this->privates['Shopware\\Core\\Framework\\Api\\Converter\\ApiVersionConverter'] ?? $this->getApiVersionConverterService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\EntityProtection\\EntityProtectionValidator'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\EntityProtection\\EntityProtectionValidator'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityProtection\EntityProtectionValidator())), ($this->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] ?? $this->getAclCriteriaValidatorService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\AuthController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\AuthController
     */
    protected function getAuthControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/AuthController.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\AuthController'] = $instance = new \Shopware\Core\Framework\Api\Controller\AuthController(($this->privates['shopware.api.authorization_server'] ?? $this->getShopware_Api_AuthorizationServerService()), ($this->privates['Symfony\\Bridge\\PsrHttpMessage\\Factory\\PsrHttpFactory'] ?? $this->getPsrHttpFactoryService()), ($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\CacheController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\CacheController
     */
    protected function getCacheControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/CacheController.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\CacheController'] = $instance = new \Shopware\Core\Framework\Api\Controller\CacheController(($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheClearer'] ?? $this->getCacheClearer2Service()), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheWarmer\\CacheWarmer'] ?? $this->getCacheWarmer2Service()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'] ?? $this->getEntityIndexerRegistryService()));

        $instance->setContainer((new \Symfony\Component\DependencyInjection\Argument\ServiceLocator($this->getService, [
            'http_kernel' => ['services', 'http_kernel', 'getHttpKernelService', false],
            'message_bus' => ['services', 'messenger.default_bus', 'getMessenger_DefaultBusService', false],
            'messenger.default_bus' => ['services', 'messenger.default_bus', 'getMessenger_DefaultBusService', false],
            'parameter_bag' => ['privates', 'parameter_bag', 'getParameterBagService', false],
            'request_stack' => ['services', 'request_stack', 'getRequestStackService', false],
            'router' => ['services', 'router', 'getRouterService', false],
            'security.csrf.token_manager' => ['services', '.container.private.security.csrf.token_manager', 'get_Container_Private_Security_Csrf_TokenManagerService', false],
            'serializer' => ['services', '.container.private.serializer', 'get_Container_Private_SerializerService', false],
            'session' => ['privates', '.session.deprecated', 'get_Session_DeprecatedService', false],
            'twig' => ['services', '.container.private.twig', 'get_Container_Private_TwigService', false],
        ], [
            'http_kernel' => '?',
            'message_bus' => '?',
            'messenger.default_bus' => '?',
            'parameter_bag' => '?',
            'request_stack' => '?',
            'router' => '?',
            'security.csrf.token_manager' => '?',
            'serializer' => '?',
            'session' => '.session.deprecated',
            'twig' => '?',
        ]))->withContext('Shopware\\Core\\Framework\\Api\\Controller\\CacheController', $this));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\CustomSnippetFormatController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\CustomSnippetFormatController
     */
    protected function getCustomSnippetFormatControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/CustomSnippetFormatController.php';

        return $this->services['Shopware\\Core\\Framework\\Api\\Controller\\CustomSnippetFormatController'] = new \Shopware\Core\Framework\Api\Controller\CustomSnippetFormatController(($this->services['Shopware\\Core\\Framework\\Plugin\\KernelPluginCollection'] ?? $this->getKernelPluginCollectionService()), ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\FallbackController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\FallbackController
     */
    protected function getFallbackControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/FallbackController.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\FallbackController'] = $instance = new \Shopware\Core\Framework\Api\Controller\FallbackController();

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\IndexingController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\IndexingController
     */
    protected function getIndexingControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/IndexingController.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\IndexingController'] = $instance = new \Shopware\Core\Framework\Api\Controller\IndexingController(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'] ?? $this->getEntityIndexerRegistryService()), ($this->services['messenger.default_bus'] ?? $this->getMessenger_DefaultBusService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\InfoController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\InfoController
     */
    protected function getInfoControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/InfoController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Maintenance/System/Service/AppUrlVerifier.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\InfoController'] = $instance = new \Shopware\Core\Framework\Api\Controller\InfoController(($this->privates['Shopware\\Core\\Framework\\Api\\ApiDefinition\\DefinitionService'] ?? $this->getDefinitionServiceService()), ($this->privates['parameter_bag'] ?? ($this->privates['parameter_bag'] = new \Symfony\Component\DependencyInjection\ParameterBag\ContainerBag($this))), ($this->services['kernel'] ?? $this->get('kernel', 1)), ($this->privates['assets.packages'] ?? $this->getAssets_PackagesService()), ($this->privates['Shopware\\Core\\Framework\\Event\\BusinessEventCollector'] ?? $this->getBusinessEventCollectorService()), ($this->services['shopware.increment.gateway.registry'] ?? $this->getShopware_Increment_Gateway_RegistryService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), new \Shopware\Core\Maintenance\System\Service\AppUrlVerifier(new \GuzzleHttp\Client(), ($this->services['app.repository'] ?? $this->getApp_RepositoryService()), 'prod', $this->getEnv('bool:APP_URL_CHECK_DISABLED')), ($this->privates['Shopware\\Core\\Content\\Flow\\Api\\FlowActionCollector'] ?? $this->getFlowActionCollectorService()), true, $this->parameters['shopware.security.csp_templates']);

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\IntegrationController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\IntegrationController
     */
    protected function getIntegrationControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/IntegrationController.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\IntegrationController'] = $instance = new \Shopware\Core\Framework\Api\Controller\IntegrationController(($this->services['integration.repository'] ?? $this->getIntegration_RepositoryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\SalesChannelProxyController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\SalesChannelProxyController
     */
    protected function getSalesChannelProxyControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/SalesChannelProxyController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Cart/ApiOrderCartService.php';

        $a = ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? $this->getSalesChannelContextPersisterService());
        $b = ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? $this->getCartServiceService());

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\SalesChannelProxyController'] = $instance = new \Shopware\Core\Framework\Api\Controller\SalesChannelProxyController(($this->services['kernel'] ?? $this->get('kernel', 1)), ($this->services['sales_channel.repository'] ?? $this->getSalesChannel_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), $a, ($this->privates['Shopware\\Core\\Framework\\Routing\\SalesChannelRequestContextResolver'] ?? $this->getSalesChannelRequestContextResolverService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? $this->getSalesChannelContextServiceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), new \Shopware\Core\Checkout\Cart\ApiOrderCartService($b, $a), ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartOrderRoute'] ?? $this->getCartOrderRouteService()), $b, ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\SyncController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\SyncController
     */
    protected function getSyncControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/SyncController.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\SyncController'] = $instance = new \Shopware\Core\Framework\Api\Controller\SyncController(($this->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'] ?? $this->getSyncServiceService()), ($this->services['.container.private.serializer'] ?? $this->get_Container_Private_SerializerService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Controller\UserController' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Controller\UserController
     */
    protected function getUserControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/UserController.php';

        $this->services['Shopware\\Core\\Framework\\Api\\Controller\\UserController'] = $instance = new \Shopware\Core\Framework\Api\Controller\UserController(($this->services['user.repository'] ?? $this->getUser_RepositoryService()), ($this->services['acl_user_role.repository'] ?? $this->getAclUserRole_RepositoryService()), ($this->services['acl_role.repository'] ?? $this->getAclRole_RepositoryService()), ($this->services['user_access_key.repository'] ?? $this->getUserAccessKey_RepositoryService()), ($this->services['Shopware\\Core\\System\\User\\UserDefinition'] ?? $this->getUserDefinitionService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Api\Sync\SyncService' shared service.
     *
     * @return \Shopware\Core\Framework\Api\Sync\SyncService
     */
    protected function getSyncServiceService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Sync/SyncServiceInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Sync/SyncService.php';

        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'] ?? $this->getEntityWriterService());

        if (isset($this->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'])) {
            return $this->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'])) {
            return $this->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'];
        }

        return $this->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'] = new \Shopware\Core\Framework\Api\Sync\SyncService(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->privates['Shopware\\Core\\Framework\\Api\\Converter\\ApiVersionConverter'] ?? $this->getApiVersionConverterService()), $a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\ActionButtonTranslation\ActionButtonTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\ActionButtonTranslation\ActionButtonTranslationDefinition
     */
    protected function getActionButtonTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/ActionButtonTranslation/ActionButtonTranslationDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\ActionButtonTranslation\ActionButtonTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\ActionButton\ActionButtonDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\ActionButton\ActionButtonDefinition
     */
    protected function getActionButtonDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/ActionButton/ActionButtonDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\ActionButton\ActionButtonDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\AppPaymentMethod\AppPaymentMethodDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\AppPaymentMethod\AppPaymentMethodDefinition
     */
    protected function getAppPaymentMethodDefinitionService()
    {
        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\AppPaymentMethod\AppPaymentMethodDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\AppScriptConditionTranslation\AppScriptConditionTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\AppScriptConditionTranslation\AppScriptConditionTranslationDefinition
     */
    protected function getAppScriptConditionTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/AppScriptConditionTranslation/AppScriptConditionTranslationDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\AppScriptConditionTranslation\AppScriptConditionTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\AppScriptCondition\AppScriptConditionDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\AppScriptCondition\AppScriptConditionDefinition
     */
    protected function getAppScriptConditionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/AppScriptCondition/AppScriptConditionDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\AppScriptCondition\AppScriptConditionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\AppTranslation\AppTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\AppTranslation\AppTranslationDefinition
     */
    protected function getAppTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/AppTranslation/AppTranslationDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\AppTranslation\AppTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\CmsBlockTranslation\AppCmsBlockTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\CmsBlockTranslation\AppCmsBlockTranslationDefinition
     */
    protected function getAppCmsBlockTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/CmsBlockTranslation/AppCmsBlockTranslationDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\CmsBlockTranslation\AppCmsBlockTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\CmsBlock\AppCmsBlockDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\CmsBlock\AppCmsBlockDefinition
     */
    protected function getAppCmsBlockDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/CmsBlock/AppCmsBlockDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\CmsBlock\AppCmsBlockDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\FlowActionTranslation\AppFlowActionTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\FlowActionTranslation\AppFlowActionTranslationDefinition
     */
    protected function getAppFlowActionTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/FlowActionTranslation/AppFlowActionTranslationDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\FlowActionTranslation\AppFlowActionTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Aggregate\FlowAction\AppFlowActionDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Aggregate\FlowAction\AppFlowActionDefinition
     */
    protected function getAppFlowActionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Aggregate/FlowAction/AppFlowActionDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition'] = $instance = new \Shopware\Core\Framework\App\Aggregate\FlowAction\AppFlowActionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Api\AppActionController' shared service.
     *
     * @return \Shopware\Core\Framework\App\Api\AppActionController
     */
    protected function getAppActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Api/AppActionController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/ActionButton/ActionButtonLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/ActionButton/AppActionLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Manifest/ModuleLoader.php';

        $a = ($this->services['app_action_button.repository'] ?? $this->getAppActionButton_RepositoryService());
        $b = ($this->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'] ?? $this->getShopIdProviderService());

        $this->services['Shopware\\Core\\Framework\\App\\Api\\AppActionController'] = $instance = new \Shopware\Core\Framework\App\Api\AppActionController(new \Shopware\Core\Framework\App\ActionButton\ActionButtonLoader($a), new \Shopware\Core\Framework\App\ActionButton\AppActionLoader($this->getEnv('APP_URL'), $a, $b), ($this->privates['Shopware\\Core\\Framework\\App\\ActionButton\\Executor'] ?? $this->getExecutorService()), new \Shopware\Core\Framework\App\Manifest\ModuleLoader(($this->services['app.repository'] ?? $this->getApp_RepositoryService()), $b, ($this->privates['Shopware\\Core\\Framework\\App\\Hmac\\QuerySigner'] ?? $this->getQuerySignerService())));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Api\AppCmsController' shared service.
     *
     * @return \Shopware\Core\Framework\App\Api\AppCmsController
     */
    protected function getAppCmsControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Api/AppCmsController.php';

        $this->services['Shopware\\Core\\Framework\\App\\Api\\AppCmsController'] = $instance = new \Shopware\Core\Framework\App\Api\AppCmsController(($this->services['app_cms_block.repository'] ?? $this->getAppCmsBlock_RepositoryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Api\AppUrlChangeController' shared service.
     *
     * @return \Shopware\Core\Framework\App\Api\AppUrlChangeController
     */
    protected function getAppUrlChangeControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Api/AppUrlChangeController.php';

        $this->services['Shopware\\Core\\Framework\\App\\Api\\AppUrlChangeController'] = $instance = new \Shopware\Core\Framework\App\Api\AppUrlChangeController(($this->services['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\Resolver'] ?? $this->getResolverService()), ($this->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'] ?? $this->getShopIdProviderService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\AppDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\AppDefinition
     */
    protected function getAppDefinitionService()
    {
        $this->services['Shopware\\Core\\Framework\\App\\AppDefinition'] = $instance = new \Shopware\Core\Framework\App\AppDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\AppLocaleProvider' shared service.
     *
     * @return \Shopware\Core\Framework\App\AppLocaleProvider
     */
    protected function getAppLocaleProviderService()
    {
        $a = ($this->services['user.repository'] ?? $this->getUser_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Framework\\App\\AppLocaleProvider'])) {
            return $this->services['Shopware\\Core\\Framework\\App\\AppLocaleProvider'];
        }

        return $this->services['Shopware\\Core\\Framework\\App\\AppLocaleProvider'] = new \Shopware\Core\Framework\App\AppLocaleProvider($a, ($this->privates['Shopware\\Core\\System\\Locale\\LanguageLocaleCodeProvider'] ?? $this->getLanguageLocaleCodeProviderService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\AppUrlChangeResolver\Resolver' shared service.
     *
     * @return \Shopware\Core\Framework\App\AppUrlChangeResolver\Resolver
     */
    protected function getResolverService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/AppUrlChangeResolver/Resolver.php';

        return $this->services['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\Resolver'] = new \Shopware\Core\Framework\App\AppUrlChangeResolver\Resolver(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\MoveShopPermanentlyStrategy'] ?? $this->getMoveShopPermanentlyStrategyService());
            yield 1 => ($this->privates['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\ReinstallAppsStrategy'] ?? $this->getReinstallAppsStrategyService());
            yield 2 => ($this->privates['Shopware\\Core\\Framework\\App\\AppUrlChangeResolver\\UninstallAppsStrategy'] ?? $this->getUninstallAppsStrategyService());
        }, 3));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\FlowAction\AppFlowActionProvider' shared service.
     *
     * @return \Shopware\Core\Framework\App\FlowAction\AppFlowActionProvider
     */
    protected function getAppFlowActionProviderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/FlowAction/AppFlowActionProvider.php';

        return $this->services['Shopware\\Core\\Framework\\App\\FlowAction\\AppFlowActionProvider'] = new \Shopware\Core\Framework\App\FlowAction\AppFlowActionProvider(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->privates['Shopware\\Core\\Framework\\Webhook\\BusinessEventEncoder'] ?? $this->getBusinessEventEncoderService()), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Twig\\StringTemplateRenderer'] ?? $this->getStringTemplateRendererService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\ShopId\ShopIdProvider' shared service.
     *
     * @return \Shopware\Core\Framework\App\ShopId\ShopIdProvider
     */
    protected function getShopIdProviderService()
    {
        $a = ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService());

        if (isset($this->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'])) {
            return $this->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'];
        }
        $b = ($this->services['app.repository'] ?? $this->getApp_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'])) {
            return $this->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'];
        }

        return $this->services['Shopware\\Core\\Framework\\App\\ShopId\\ShopIdProvider'] = new \Shopware\Core\Framework\App\ShopId\ShopIdProvider($a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Template\TemplateDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\App\Template\TemplateDefinition
     */
    protected function getTemplateDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Template/TemplateDefinition.php';

        $this->services['Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition'] = $instance = new \Shopware\Core\Framework\App\Template\TemplateDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\App\Template\TemplateStateService' shared service.
     *
     * @return \Shopware\Core\Framework\App\Template\TemplateStateService
     */
    protected function getTemplateStateServiceService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/App/Template/TemplateStateService.php';

        $a = ($this->services['app_template.repository'] ?? $this->getAppTemplate_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Framework\\App\\Template\\TemplateStateService'])) {
            return $this->services['Shopware\\Core\\Framework\\App\\Template\\TemplateStateService'];
        }

        return $this->services['Shopware\\Core\\Framework\\App\\Template\\TemplateStateService'] = new \Shopware\Core\Framework\App\Template\TemplateStateService($a);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator
     */
    protected function getEntityCacheKeyGeneratorService()
    {
        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityHydrator' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityHydrator
     */
    protected function getEntityHydratorService()
    {
        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityHydrator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityHydrator($this);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\ConfigJsonFieldAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\ConfigJsonFieldAccessorBuilder
     */
    protected function getConfigJsonFieldAccessorBuilderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/FieldAccessorBuilderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/JsonFieldAccessorBuilder.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/ConfigJsonFieldAccessorBuilder.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\ConfigJsonFieldAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\ConfigJsonFieldAccessorBuilder(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\CustomFieldsAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\CustomFieldsAccessorBuilder
     */
    protected function getCustomFieldsAccessorBuilderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/FieldAccessorBuilderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/JsonFieldAccessorBuilder.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/CustomFieldsAccessorBuilder.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\CustomFieldsAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\CustomFieldsAccessorBuilder(($this->privates['Shopware\\Core\\System\\CustomField\\CustomFieldService'] ?? $this->getCustomFieldServiceService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\DefaultFieldAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\DefaultFieldAccessorBuilder
     */
    protected function getDefaultFieldAccessorBuilderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/FieldAccessorBuilderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/DefaultFieldAccessorBuilder.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\DefaultFieldAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\DefaultFieldAccessorBuilder();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\JsonFieldAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\JsonFieldAccessorBuilder
     */
    protected function getJsonFieldAccessorBuilderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/FieldAccessorBuilderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/JsonFieldAccessorBuilder.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\JsonFieldAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\JsonFieldAccessorBuilder(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\PriceFieldAccessorBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\PriceFieldAccessorBuilder
     */
    protected function getPriceFieldAccessorBuilderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/FieldAccessorBuilderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldAccessorBuilder/PriceFieldAccessorBuilder.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldAccessorBuilder\\PriceFieldAccessorBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldAccessorBuilder\PriceFieldAccessorBuilder(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToManyAssociationFieldResolver' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToManyAssociationFieldResolver
     */
    protected function getManyToManyAssociationFieldResolverService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/AbstractFieldResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/ManyToManyAssociationFieldResolver.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\ManyToManyAssociationFieldResolver'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToManyAssociationFieldResolver();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToOneAssociationFieldResolver' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToOneAssociationFieldResolver
     */
    protected function getManyToOneAssociationFieldResolverService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/AbstractFieldResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/ManyToOneAssociationFieldResolver.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\ManyToOneAssociationFieldResolver'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\ManyToOneAssociationFieldResolver(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper())));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\OneToManyAssociationFieldResolver' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\OneToManyAssociationFieldResolver
     */
    protected function getOneToManyAssociationFieldResolverService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/AbstractFieldResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/OneToManyAssociationFieldResolver.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\OneToManyAssociationFieldResolver'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\OneToManyAssociationFieldResolver();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\TranslationFieldResolver' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\TranslationFieldResolver
     */
    protected function getTranslationFieldResolverService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/AbstractFieldResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Dbal/FieldResolver/TranslationFieldResolver.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\FieldResolver\\TranslationFieldResolver'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\FieldResolver\TranslationFieldResolver();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Dbal\JoinGroupBuilder' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\JoinGroupBuilder
     */
    protected function getJoinGroupBuilderService()
    {
        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\JoinGroupBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\JoinGroupBuilder();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\DefinitionInstanceRegistry' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\DefinitionInstanceRegistry
     */
    protected function getDefinitionInstanceRegistryService()
    {
        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] = new \Shopware\Core\Framework\DataAbstractionLayer\DefinitionInstanceRegistry($this, ['log_entry' => 'Shopware\\Core\\Framework\\Log\\LogEntryDefinition', 'acl_role' => 'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition', 'acl_user_role' => 'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition', 'app' => 'Shopware\\Core\\Framework\\App\\AppDefinition', 'app_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition', 'app_action_button' => 'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition', 'app_action_button_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition', 'app_template' => 'Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition', 'app_payment_method' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition', 'app_script_condition' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition', 'app_script_condition_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition', 'app_cms_block' => 'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition', 'app_cms_block_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition', 'app_flow_action' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition', 'app_flow_action_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition', 'custom_field' => 'Shopware\\Core\\System\\CustomField\\CustomFieldDefinition', 'custom_field_set' => 'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition', 'custom_field_set_relation' => 'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition', 'version' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition', 'version_commit' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition', 'version_commit_data' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition', 'event_action' => 'Shopware\\Core\\Framework\\Event\\EventAction\\EventActionDefinition', 'event_action_rule' => 'Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionRule\\EventActionRuleDefinition', 'event_action_sales_channel' => 'Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionSalesChannel\\EventActionSalesChannelDefinition', 'dead_message' => 'Shopware\\Core\\Framework\\MessageQueue\\DeadMessage\\DeadMessageDefinition', 'message_queue_stats' => 'Shopware\\Core\\Framework\\MessageQueue\\MessageQueueStatsDefinition', 'plugin' => 'Shopware\\Core\\Framework\\Plugin\\PluginDefinition', 'plugin_translation' => 'Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition', 'scheduled_task' => 'Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition', 'script' => 'Shopware\\Core\\Framework\\Script\\ScriptDefinition', 'language' => 'Shopware\\Core\\System\\Language\\LanguageDefinition', 'seo_url' => 'Shopware\\Core\\Content\\Seo\\SeoUrl\\SeoUrlDefinition', 'seo_url_template' => 'Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition', 'main_category' => 'Shopware\\Core\\Content\\Seo\\MainCategory\\MainCategoryDefinition', 'webhook' => 'Shopware\\Core\\Framework\\Webhook\\WebhookDefinition', 'webhook_event_log' => 'Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition', 'sales_channel' => 'Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition', 'sales_channel_translation' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition', 'sales_channel_country' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition', 'sales_channel_currency' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition', 'sales_channel_domain' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition', 'sales_channel_language' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition', 'sales_channel_payment_method' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition', 'sales_channel_shipping_method' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition', 'sales_channel_type' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition', 'sales_channel_type_translation' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition', 'sales_channel_analytics' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition', 'country' => 'Shopware\\Core\\System\\Country\\CountryDefinition', 'country_state' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\CountryStateDefinition', 'country_state_translation' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition', 'country_translation' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition', 'currency' => 'Shopware\\Core\\System\\Currency\\CurrencyDefinition', 'currency_country_rounding' => 'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition', 'currency_translation' => 'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition', 'custom_entity' => 'Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition', 'locale' => 'Shopware\\Core\\System\\Locale\\LocaleDefinition', 'locale_translation' => 'Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition', 'snippet_set' => 'Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition', 'snippet' => 'Shopware\\Core\\System\\Snippet\\SnippetDefinition', 'salutation' => 'Shopware\\Core\\System\\Salutation\\SalutationDefinition', 'salutation_translation' => 'Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition', 'tax' => 'Shopware\\Core\\System\\Tax\\TaxDefinition', 'tax_rule' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition', 'tax_rule_type' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition', 'tax_rule_type_translation' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition', 'unit' => 'Shopware\\Core\\System\\Unit\\UnitDefinition', 'unit_translation' => 'Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition', 'user' => 'Shopware\\Core\\System\\User\\UserDefinition', 'user_config' => 'Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition', 'user_access_key' => 'Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition', 'user_recovery' => 'Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition', 'integration' => 'Shopware\\Core\\System\\Integration\\IntegrationDefinition', 'integration_role' => 'Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition', 'state_machine' => 'Shopware\\Core\\System\\StateMachine\\StateMachineDefinition', 'state_machine_translation' => 'Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition', 'state_machine_state' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition', 'state_machine_state_translation' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition', 'state_machine_transition' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition', 'state_machine_history' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition', 'system_config' => 'Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition', 'number_range' => 'Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition', 'number_range_sales_channel' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition', 'number_range_state' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition', 'number_range_type' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition', 'number_range_type_translation' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition', 'number_range_translation' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition', 'tag' => 'Shopware\\Core\\System\\Tag\\TagDefinition', 'category' => 'Shopware\\Core\\Content\\Category\\CategoryDefinition', 'category_translation' => 'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition', 'category_tag' => 'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition', 'media' => 'Shopware\\Core\\Content\\Media\\MediaDefinition', 'media_default_folder' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition', 'media_thumbnail' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition', 'media_translation' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition', 'media_folder' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition', 'media_thumbnail_size' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition', 'media_folder_configuration' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition', 'media_folder_configuration_media_thumbnail_size' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition', 'media_tag' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition', 'product' => 'Shopware\\Core\\Content\\Product\\ProductDefinition', 'product_stream_mapping' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition', 'product_category' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition', 'product_custom_field_set' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition', 'product_tag' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition', 'product_configurator_setting' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition', 'product_price' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition', 'product_property' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition', 'product_search_keyword' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition', 'product_keyword_dictionary' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition', 'product_review' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition', 'product_manufacturer' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition', 'product_manufacturer_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition', 'product_media' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition', 'product_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition', 'product_option' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition', 'product_category_tree' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition', 'product_cross_selling' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition', 'product_cross_selling_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition', 'product_cross_selling_assigned_products' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition', 'product_feature_set' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition', 'product_feature_set_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition', 'product_sorting' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition', 'product_sorting_translation' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition', 'product_search_config' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition', 'product_search_config_field' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition', 'product_visibility' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition', 'delivery_time' => 'Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition', 'newsletter_recipient' => 'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipient\\NewsletterRecipientDefinition', 'newsletter_recipient_tag' => 'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition', 'rule' => 'Shopware\\Core\\Content\\Rule\\RuleDefinition', 'rule_condition' => 'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition', 'rule_tag' => 'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition', 'product_stream' => 'Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition', 'product_stream_translation' => 'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition', 'product_stream_filter' => 'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition', 'product_export' => 'Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition', 'property_group' => 'Shopware\\Core\\Content\\Property\\PropertyGroupDefinition', 'property_group_option' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition', 'property_group_option_translation' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition', 'property_group_translation' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition', 'cms_page' => 'Shopware\\Core\\Content\\Cms\\CmsPageDefinition', 'cms_page_translation' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition', 'cms_section' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition', 'cms_block' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition', 'cms_slot' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition', 'cms_slot_translation' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition', 'mail_template' => 'Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition', 'mail_template_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition', 'mail_template_type' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition', 'mail_template_type_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition', 'mail_template_media' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition', 'mail_header_footer' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition', 'mail_header_footer_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition', 'delivery_time_translation' => 'Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition', 'import_export_profile' => 'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition', 'import_export_log' => 'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition', 'import_export_file' => 'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition', 'import_export_profile_translation' => 'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition', 'landing_page' => 'Shopware\\Core\\Content\\LandingPage\\LandingPageDefinition', 'landing_page_translation' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition', 'landing_page_tag' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition', 'landing_page_sales_channel' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition', 'flow' => 'Shopware\\Core\\Content\\Flow\\FlowDefinition', 'flow_sequence' => 'Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition', 'customer' => 'Shopware\\Core\\Checkout\\Customer\\CustomerDefinition', 'customer_group_translation' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition', 'customer_address' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition', 'customer_recovery' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition', 'customer_group' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition', 'customer_group_registration_sales_channels' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition', 'customer_tag' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition', 'customer_wishlist' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition', 'customer_wishlist_product' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition', 'document' => 'Shopware\\Core\\Checkout\\Document\\DocumentDefinition', 'document_type' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition', 'document_type_translation' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition', 'document_base_config' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition', 'document_base_config_sales_channel' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition', 'order' => 'Shopware\\Core\\Checkout\\Order\\OrderDefinition', 'order_address' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition', 'order_customer' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition', 'order_delivery' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition', 'order_delivery_position' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition', 'order_line_item' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition', 'order_tag' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition', 'order_transaction' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition', 'order_transaction_capture' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition', 'order_transaction_capture_refund' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition', 'order_transaction_capture_refund_position' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition', 'payment_method' => 'Shopware\\Core\\Checkout\\Payment\\PaymentMethodDefinition', 'payment_method_translation' => 'Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition', 'promotion' => 'Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition', 'promotion_sales_channel' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition', 'promotion_individual_code' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition', 'promotion_discount' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition', 'promotion_discount_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition', 'promotion_setgroup' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition', 'promotion_setgroup_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition', 'promotion_order_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition', 'promotion_persona_customer' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition', 'promotion_persona_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition', 'promotion_cart_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition', 'promotion_translation' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition', 'promotion_discount_prices' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition', 'shipping_method' => 'Shopware\\Core\\Checkout\\Shipping\\ShippingMethodDefinition', 'shipping_method_tag' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition', 'shipping_method_price' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition', 'shipping_method_translation' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition', 'app_administration_snippet' => 'Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition', 'notification' => 'Shopware\\Administration\\Notification\\NotificationDefinition', 'theme' => 'Shopware\\Storefront\\Theme\\ThemeDefinition', 'theme_translation' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition', 'theme_sales_channel' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition', 'theme_media' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition', 'theme_child' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition'], ['log_entry' => 'log_entry.repository', 'acl_role' => 'acl_role.repository', 'acl_user_role' => 'acl_user_role.repository', 'app' => 'app.repository', 'app_translation' => 'app_translation.repository', 'app_action_button' => 'app_action_button.repository', 'app_action_button_translation' => 'app_action_button_translation.repository', 'app_template' => 'app_template.repository', 'app_payment_method' => 'app_payment_method.repository', 'app_script_condition' => 'app_script_condition.repository', 'app_script_condition_translation' => 'app_script_condition_translation.repository', 'app_cms_block' => 'app_cms_block.repository', 'app_cms_block_translation' => 'app_cms_block_translation.repository', 'app_flow_action' => 'app_flow_action.repository', 'app_flow_action_translation' => 'app_flow_action_translation.repository', 'custom_field' => 'custom_field.repository', 'custom_field_set' => 'custom_field_set.repository', 'custom_field_set_relation' => 'custom_field_set_relation.repository', 'version' => 'version.repository', 'version_commit' => 'version_commit.repository', 'version_commit_data' => 'version_commit_data.repository', 'event_action' => 'event_action.repository', 'event_action_rule' => 'event_action_rule.repository', 'event_action_sales_channel' => 'event_action_sales_channel.repository', 'dead_message' => 'dead_message.repository', 'message_queue_stats' => 'message_queue_stats.repository', 'plugin' => 'plugin.repository', 'plugin_translation' => 'plugin_translation.repository', 'scheduled_task' => 'scheduled_task.repository', 'script' => 'script.repository', 'language' => 'language.repository', 'seo_url' => 'seo_url.repository', 'seo_url_template' => 'seo_url_template.repository', 'main_category' => 'main_category.repository', 'webhook' => 'webhook.repository', 'webhook_event_log' => 'webhook_event_log.repository', 'sales_channel' => 'sales_channel.repository', 'sales_channel_translation' => 'sales_channel_translation.repository', 'sales_channel_country' => 'sales_channel_country.repository', 'sales_channel_currency' => 'sales_channel_currency.repository', 'sales_channel_domain' => 'sales_channel_domain.repository', 'sales_channel_language' => 'sales_channel_language.repository', 'sales_channel_payment_method' => 'sales_channel_payment_method.repository', 'sales_channel_shipping_method' => 'sales_channel_shipping_method.repository', 'sales_channel_type' => 'sales_channel_type.repository', 'sales_channel_type_translation' => 'sales_channel_type_translation.repository', 'sales_channel_analytics' => 'sales_channel_analytics.repository', 'country' => 'country.repository', 'country_state' => 'country_state.repository', 'country_state_translation' => 'country_state_translation.repository', 'country_translation' => 'country_translation.repository', 'currency' => 'currency.repository', 'currency_country_rounding' => 'currency_country_rounding.repository', 'currency_translation' => 'currency_translation.repository', 'custom_entity' => 'custom_entity.repository', 'locale' => 'locale.repository', 'locale_translation' => 'locale_translation.repository', 'snippet_set' => 'snippet_set.repository', 'snippet' => 'snippet.repository', 'salutation' => 'salutation.repository', 'salutation_translation' => 'salutation_translation.repository', 'tax' => 'tax.repository', 'tax_rule' => 'tax_rule.repository', 'tax_rule_type' => 'tax_rule_type.repository', 'tax_rule_type_translation' => 'tax_rule_type_translation.repository', 'unit' => 'unit.repository', 'unit_translation' => 'unit_translation.repository', 'user' => 'user.repository', 'user_config' => 'user_config.repository', 'user_access_key' => 'user_access_key.repository', 'user_recovery' => 'user_recovery.repository', 'integration' => 'integration.repository', 'integration_role' => 'integration_role.repository', 'state_machine' => 'state_machine.repository', 'state_machine_translation' => 'state_machine_translation.repository', 'state_machine_state' => 'state_machine_state.repository', 'state_machine_state_translation' => 'state_machine_state_translation.repository', 'state_machine_transition' => 'state_machine_transition.repository', 'state_machine_history' => 'state_machine_history.repository', 'system_config' => 'system_config.repository', 'number_range' => 'number_range.repository', 'number_range_sales_channel' => 'number_range_sales_channel.repository', 'number_range_state' => 'number_range_state.repository', 'number_range_type' => 'number_range_type.repository', 'number_range_type_translation' => 'number_range_type_translation.repository', 'number_range_translation' => 'number_range_translation.repository', 'tag' => 'tag.repository', 'category' => 'category.repository', 'category_translation' => 'category_translation.repository', 'category_tag' => 'category_tag.repository', 'media' => 'media.repository', 'media_default_folder' => 'media_default_folder.repository', 'media_thumbnail' => 'media_thumbnail.repository', 'media_translation' => 'media_translation.repository', 'media_folder' => 'media_folder.repository', 'media_thumbnail_size' => 'media_thumbnail_size.repository', 'media_folder_configuration' => 'media_folder_configuration.repository', 'media_folder_configuration_media_thumbnail_size' => 'media_folder_configuration_media_thumbnail_size.repository', 'media_tag' => 'media_tag.repository', 'product' => 'product.repository', 'product_stream_mapping' => 'product_stream_mapping.repository', 'product_category' => 'product_category.repository', 'product_custom_field_set' => 'product_custom_field_set.repository', 'product_tag' => 'product_tag.repository', 'product_configurator_setting' => 'product_configurator_setting.repository', 'product_price' => 'product_price.repository', 'product_property' => 'product_property.repository', 'product_search_keyword' => 'product_search_keyword.repository', 'product_keyword_dictionary' => 'product_keyword_dictionary.repository', 'product_review' => 'product_review.repository', 'product_manufacturer' => 'product_manufacturer.repository', 'product_manufacturer_translation' => 'product_manufacturer_translation.repository', 'product_media' => 'product_media.repository', 'product_translation' => 'product_translation.repository', 'product_option' => 'product_option.repository', 'product_category_tree' => 'product_category_tree.repository', 'product_cross_selling' => 'product_cross_selling.repository', 'product_cross_selling_translation' => 'product_cross_selling_translation.repository', 'product_cross_selling_assigned_products' => 'product_cross_selling_assigned_products.repository', 'product_feature_set' => 'product_feature_set.repository', 'product_feature_set_translation' => 'product_feature_set_translation.repository', 'product_sorting' => 'product_sorting.repository', 'product_sorting_translation' => 'product_sorting_translation.repository', 'product_search_config' => 'product_search_config.repository', 'product_search_config_field' => 'product_search_config_field.repository', 'product_visibility' => 'product_visibility.repository', 'delivery_time' => 'delivery_time.repository', 'newsletter_recipient' => 'newsletter_recipient.repository', 'newsletter_recipient_tag' => 'newsletter_recipient_tag.repository', 'rule' => 'rule.repository', 'rule_condition' => 'rule_condition.repository', 'rule_tag' => 'rule_tag.repository', 'product_stream' => 'product_stream.repository', 'product_stream_translation' => 'product_stream_translation.repository', 'product_stream_filter' => 'product_stream_filter.repository', 'product_export' => 'product_export.repository', 'property_group' => 'property_group.repository', 'property_group_option' => 'property_group_option.repository', 'property_group_option_translation' => 'property_group_option_translation.repository', 'property_group_translation' => 'property_group_translation.repository', 'cms_page' => 'cms_page.repository', 'cms_page_translation' => 'cms_page_translation.repository', 'cms_section' => 'cms_section.repository', 'cms_block' => 'cms_block.repository', 'cms_slot' => 'cms_slot.repository', 'cms_slot_translation' => 'cms_slot_translation.repository', 'mail_template' => 'mail_template.repository', 'mail_template_translation' => 'mail_template_translation.repository', 'mail_template_type' => 'mail_template_type.repository', 'mail_template_type_translation' => 'mail_template_type_translation.repository', 'mail_template_media' => 'mail_template_media.repository', 'mail_header_footer' => 'mail_header_footer.repository', 'mail_header_footer_translation' => 'mail_header_footer_translation.repository', 'delivery_time_translation' => 'delivery_time_translation.repository', 'import_export_profile' => 'import_export_profile.repository', 'import_export_log' => 'import_export_log.repository', 'import_export_file' => 'import_export_file.repository', 'import_export_profile_translation' => 'import_export_profile_translation.repository', 'landing_page' => 'landing_page.repository', 'landing_page_translation' => 'landing_page_translation.repository', 'landing_page_tag' => 'landing_page_tag.repository', 'landing_page_sales_channel' => 'landing_page_sales_channel.repository', 'flow' => 'flow.repository', 'flow_sequence' => 'flow_sequence.repository', 'customer' => 'customer.repository', 'customer_group_translation' => 'customer_group_translation.repository', 'customer_address' => 'customer_address.repository', 'customer_recovery' => 'customer_recovery.repository', 'customer_group' => 'customer_group.repository', 'customer_group_registration_sales_channels' => 'customer_group_registration_sales_channels.repository', 'customer_tag' => 'customer_tag.repository', 'customer_wishlist' => 'customer_wishlist.repository', 'customer_wishlist_product' => 'customer_wishlist_product.repository', 'document' => 'document.repository', 'document_type' => 'document_type.repository', 'document_type_translation' => 'document_type_translation.repository', 'document_base_config' => 'document_base_config.repository', 'document_base_config_sales_channel' => 'document_base_config_sales_channel.repository', 'order' => 'order.repository', 'order_address' => 'order_address.repository', 'order_customer' => 'order_customer.repository', 'order_delivery' => 'order_delivery.repository', 'order_delivery_position' => 'order_delivery_position.repository', 'order_line_item' => 'order_line_item.repository', 'order_tag' => 'order_tag.repository', 'order_transaction' => 'order_transaction.repository', 'order_transaction_capture' => 'order_transaction_capture.repository', 'order_transaction_capture_refund' => 'order_transaction_capture_refund.repository', 'order_transaction_capture_refund_position' => 'order_transaction_capture_refund_position.repository', 'payment_method' => 'payment_method.repository', 'payment_method_translation' => 'payment_method_translation.repository', 'promotion' => 'promotion.repository', 'promotion_sales_channel' => 'promotion_sales_channel.repository', 'promotion_individual_code' => 'promotion_individual_code.repository', 'promotion_discount' => 'promotion_discount.repository', 'promotion_discount_rule' => 'promotion_discount_rule.repository', 'promotion_setgroup' => 'promotion_setgroup.repository', 'promotion_setgroup_rule' => 'promotion_setgroup_rule.repository', 'promotion_order_rule' => 'promotion_order_rule.repository', 'promotion_persona_customer' => 'promotion_persona_customer.repository', 'promotion_persona_rule' => 'promotion_persona_rule.repository', 'promotion_cart_rule' => 'promotion_cart_rule.repository', 'promotion_translation' => 'promotion_translation.repository', 'promotion_discount_prices' => 'promotion_discount_prices.repository', 'shipping_method' => 'shipping_method.repository', 'shipping_method_tag' => 'shipping_method_tag.repository', 'shipping_method_price' => 'shipping_method_price.repository', 'shipping_method_translation' => 'shipping_method_translation.repository', 'app_administration_snippet' => 'app_administration_snippet.repository', 'notification' => 'notification.repository', 'theme' => 'theme.repository', 'theme_translation' => 'theme_translation.repository', 'theme_sales_channel' => 'theme_sales_channel.repository', 'theme_media' => 'theme_media.repository', 'theme_child' => 'theme_child.repository']);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Event\EntityLoadedEventFactory' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Event\EntityLoadedEventFactory
     */
    protected function getEntityLoadedEventFactoryService()
    {
        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] = new \Shopware\Core\Framework\DataAbstractionLayer\Event\EntityLoadedEventFactory(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\ExtensionRegistry' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\ExtensionRegistry
     */
    protected function getExtensionRegistryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/ExtensionRegistry.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\ExtensionRegistry'] = new \Shopware\Core\Framework\DataAbstractionLayer\ExtensionRegistry(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Administration\\Notification\\Extension\\IntegrationExtension'] ?? ($this->privates['Shopware\\Administration\\Notification\\Extension\\IntegrationExtension'] = new \Shopware\Administration\Notification\Extension\IntegrationExtension()));
            yield 1 => ($this->privates['Shopware\\Administration\\Notification\\Extension\\UserExtension'] ?? ($this->privates['Shopware\\Administration\\Notification\\Extension\\UserExtension'] = new \Shopware\Administration\Notification\Extension\UserExtension()));
            yield 2 => ($this->privates['Shopware\\Storefront\\Theme\\Extension\\SalesChannelExtension'] ?? ($this->privates['Shopware\\Storefront\\Theme\\Extension\\SalesChannelExtension'] = new \Shopware\Storefront\Theme\Extension\SalesChannelExtension()));
            yield 3 => ($this->privates['Shopware\\Storefront\\Theme\\Extension\\LanguageExtension'] ?? ($this->privates['Shopware\\Storefront\\Theme\\Extension\\LanguageExtension'] = new \Shopware\Storefront\Theme\Extension\LanguageExtension()));
            yield 4 => ($this->privates['Shopware\\Storefront\\Theme\\Extension\\MediaExtension'] ?? ($this->privates['Shopware\\Storefront\\Theme\\Extension\\MediaExtension'] = new \Shopware\Storefront\Theme\Extension\MediaExtension()));
        }, 5));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryFacadeHookFactory
     */
    protected function getRepositoryFacadeHookFactoryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Execution/Awareness/HookServiceFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Facade/RepositoryFacadeHookFactory.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\RepositoryFacadeHookFactory'] = new \Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryFacadeHookFactory(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\AppContextCreator'] ?? $this->getAppContextCreatorService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? $this->getRequestCriteriaBuilderService()), ($this->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] ?? $this->getAclCriteriaValidatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryWriterFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryWriterFacadeHookFactory
     */
    protected function getRepositoryWriterFacadeHookFactoryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Execution/Awareness/HookServiceFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Facade/RepositoryWriterFacadeHookFactory.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\RepositoryWriterFacadeHookFactory'] = new \Shopware\Core\Framework\DataAbstractionLayer\Facade\RepositoryWriterFacadeHookFactory(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\AppContextCreator'] ?? $this->getAppContextCreatorService()), ($this->services['Shopware\\Core\\Framework\\Api\\Sync\\SyncService'] ?? $this->getSyncServiceService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Facade\SalesChannelRepositoryFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Facade\SalesChannelRepositoryFacadeHookFactory
     */
    protected function getSalesChannelRepositoryFacadeHookFactoryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Execution/Awareness/HookServiceFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Facade/SalesChannelRepositoryFacadeHookFactory.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Facade\\SalesChannelRepositoryFacadeHookFactory'] = new \Shopware\Core\Framework\DataAbstractionLayer\Facade\SalesChannelRepositoryFacadeHookFactory(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? $this->getRequestCriteriaBuilderService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BlobFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BlobFieldSerializer
     */
    protected function getBlobFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/BlobFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\BlobFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BlobFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BoolFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BoolFieldSerializer
     */
    protected function getBoolFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/BoolFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\BoolFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\BoolFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CalculatedPriceFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CalculatedPriceFieldSerializer
     */
    protected function getCalculatedPriceFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/JsonFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/CalculatedPriceFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CalculatedPriceFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CalculatedPriceFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CartPriceFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CartPriceFieldSerializer
     */
    protected function getCartPriceFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/JsonFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/CartPriceFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CartPriceFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CartPriceFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CashRoundingConfigFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CashRoundingConfigFieldSerializer
     */
    protected function getCashRoundingConfigFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/JsonFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/CashRoundingConfigFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CashRoundingConfigFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CashRoundingConfigFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ConfigJsonFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ConfigJsonFieldSerializer
     */
    protected function getConfigJsonFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/JsonFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/ConfigJsonFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ConfigJsonFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ConfigJsonFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedAtFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedAtFieldSerializer
     */
    protected function getCreatedAtFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/DateTimeFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/CreatedAtFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CreatedAtFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedAtFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedByFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedByFieldSerializer
     */
    protected function getCreatedByFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FkFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/CreatedByFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CreatedByFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CreatedByFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CustomFieldsSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CustomFieldsSerializer
     */
    protected function getCustomFieldsSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/JsonFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/CustomFieldsSerializer.php';

        $a = ($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer'];
        }
        $b = ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? $this->getWriteCommandExtractorService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer'];
        }

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\CustomFieldsSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\CustomFieldsSerializer(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), $a, ($this->privates['Shopware\\Core\\System\\CustomField\\CustomFieldService'] ?? $this->getCustomFieldServiceService()), $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateFieldSerializer
     */
    protected function getDateFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/DateFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateTimeFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateTimeFieldSerializer
     */
    protected function getDateTimeFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/DateTimeFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\DateTimeFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\DateTimeFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\EmailFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\EmailFieldSerializer
     */
    protected function getEmailFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/EmailFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\EmailFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\EmailFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FkFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FkFieldSerializer
     */
    protected function getFkFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FkFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\FkFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FkFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FloatFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FloatFieldSerializer
     */
    protected function getFloatFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FloatFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\FloatFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\FloatFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IdFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IdFieldSerializer
     */
    protected function getIdFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/IdFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\IdFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IdFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IntFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IntFieldSerializer
     */
    protected function getIntFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/IntFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\IntFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\IntFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\JsonFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\JsonFieldSerializer
     */
    protected function getJsonFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/JsonFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\JsonFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\JsonFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ListFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ListFieldSerializer
     */
    protected function getListFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/ListFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ListFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ListFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\LongTextFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\LongTextFieldSerializer
     */
    protected function getLongTextFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/LongTextFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\LongTextFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\LongTextFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] ?? $this->getHtmlSanitizerService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToManyAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToManyAssociationFieldSerializer
     */
    protected function getManyToManyAssociationFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/ManyToManyAssociationFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ManyToManyAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToManyAssociationFieldSerializer(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? $this->getWriteCommandExtractorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToOneAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToOneAssociationFieldSerializer
     */
    protected function getManyToOneAssociationFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/ManyToOneAssociationFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ManyToOneAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ManyToOneAssociationFieldSerializer(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? $this->getWriteCommandExtractorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToManyAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToManyAssociationFieldSerializer
     */
    protected function getOneToManyAssociationFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/OneToManyAssociationFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\OneToManyAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToManyAssociationFieldSerializer(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? $this->getWriteCommandExtractorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] ?? $this->getEntityWriteGatewayInterfaceService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToOneAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToOneAssociationFieldSerializer
     */
    protected function getOneToOneAssociationFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/OneToOneAssociationFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\OneToOneAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\OneToOneAssociationFieldSerializer(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? $this->getWriteCommandExtractorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PHPUnserializeFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PHPUnserializeFieldSerializer
     */
    protected function getPHPUnserializeFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/PHPUnserializeFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PHPUnserializeFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PHPUnserializeFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PasswordFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PasswordFieldSerializer
     */
    protected function getPasswordFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/PasswordFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PasswordFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PasswordFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceDefinitionFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceDefinitionFieldSerializer
     */
    protected function getPriceDefinitionFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/JsonFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/PriceDefinitionFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PriceDefinitionFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceDefinitionFieldSerializer(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->privates['Shopware\\Core\\Framework\\Rule\\Collector\\RuleConditionRegistry'] ?? $this->getRuleConditionRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceFieldSerializer
     */
    protected function getPriceFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/PriceFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\PriceFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\PriceFieldSerializer(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ReferenceVersionFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ReferenceVersionFieldSerializer
     */
    protected function getReferenceVersionFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/ReferenceVersionFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\ReferenceVersionFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\ReferenceVersionFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\RemoteAddressFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\RemoteAddressFieldSerializer
     */
    protected function getRemoteAddressFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/RemoteAddressFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\RemoteAddressFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\RemoteAddressFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StateMachineStateFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StateMachineStateFieldSerializer
     */
    protected function getStateMachineStateFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FkFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/StateMachineStateFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\StateMachineStateFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StateMachineStateFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StringFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StringFieldSerializer
     */
    protected function getStringFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/StringFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\StringFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\StringFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] ?? $this->getHtmlSanitizerService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TaxFreeConfigFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TaxFreeConfigFieldSerializer
     */
    protected function getTaxFreeConfigFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/JsonFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/TaxFreeConfigFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TaxFreeConfigFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TaxFreeConfigFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TimeZoneFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TimeZoneFieldSerializer
     */
    protected function getTimeZoneFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/TimeZoneFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TimeZoneFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TimeZoneFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslatedFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslatedFieldSerializer
     */
    protected function getTranslatedFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/TranslatedFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TranslatedFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslatedFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslationsAssociationFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslationsAssociationFieldSerializer
     */
    protected function getTranslationsAssociationFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/TranslationsAssociationFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\TranslationsAssociationFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\TranslationsAssociationFieldSerializer(($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? $this->getWriteCommandExtractorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] ?? $this->getEntityWriteGatewayInterfaceService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedAtFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedAtFieldSerializer
     */
    protected function getUpdatedAtFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/DateTimeFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/UpdatedAtFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\UpdatedAtFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedAtFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedByFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedByFieldSerializer
     */
    protected function getUpdatedByFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FkFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/UpdatedByFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\UpdatedByFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\UpdatedByFieldSerializer(($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VariantListingConfigFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VariantListingConfigFieldSerializer
     */
    protected function getVariantListingConfigFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/AbstractFieldSerializer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/VariantListingConfigFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VariantListingConfigFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VariantListingConfigFieldSerializer(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['.container.private.validator'] ?? $this->get_Container_Private_ValidatorService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionDataPayloadFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionDataPayloadFieldSerializer
     */
    protected function getVersionDataPayloadFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/VersionDataPayloadFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VersionDataPayloadFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionDataPayloadFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionFieldSerializer' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionFieldSerializer
     */
    protected function getVersionFieldSerializerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/FieldSerializerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/FieldSerializer/VersionFieldSerializer.php';

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\FieldSerializer\\VersionFieldSerializer'] = new \Shopware\Core\Framework\DataAbstractionLayer\FieldSerializer\VersionFieldSerializer();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Indexing\EntityIndexerRegistry' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Indexing\EntityIndexerRegistry
     */
    protected function getEntityIndexerRegistryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/Indexing/EntityIndexerRegistry.php';

        $a = ($this->services['messenger.default_bus'] ?? $this->getMessenger_DefaultBusService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'];
        }

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Indexing\\EntityIndexerRegistry'] = new \Shopware\Core\Framework\DataAbstractionLayer\Indexing\EntityIndexerRegistry(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Content\\LandingPage\\DataAbstractionLayer\\LandingPageIndexer'] ?? $this->getLandingPageIndexerService());
            yield 1 => ($this->privates['Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\ProductIndexer'] ?? $this->getProductIndexerService());
            yield 2 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\DataAbstractionLayer\\CustomerIndexer'] ?? $this->getCustomerIndexerService());
            yield 3 => ($this->privates['Shopware\\Core\\System\\SalesChannel\\DataAbstractionLayer\\SalesChannelIndexer'] ?? $this->getSalesChannelIndexerService());
            yield 4 => ($this->privates['Shopware\\Core\\Content\\Category\\DataAbstractionLayer\\CategoryIndexer'] ?? $this->getCategoryIndexerService());
            yield 5 => ($this->privates['Shopware\\Core\\Content\\Media\\DataAbstractionLayer\\MediaIndexer'] ?? $this->getMediaIndexerService());
            yield 6 => ($this->privates['Shopware\\Core\\Content\\Media\\DataAbstractionLayer\\MediaFolderConfigurationIndexer'] ?? $this->getMediaFolderConfigurationIndexerService());
            yield 7 => ($this->privates['Shopware\\Core\\Content\\Media\\DataAbstractionLayer\\MediaFolderIndexer'] ?? $this->getMediaFolderIndexerService());
            yield 8 => ($this->privates['Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\ProductStreamUpdater'] ?? $this->getProductStreamUpdaterService());
            yield 9 => ($this->privates['Shopware\\Core\\Content\\Newsletter\\DataAbstractionLayer\\NewsletterRecipientIndexer'] ?? $this->getNewsletterRecipientIndexerService());
            yield 10 => ($this->privates['Shopware\\Core\\Content\\Rule\\DataAbstractionLayer\\RuleIndexer'] ?? $this->getRuleIndexerService());
            yield 11 => ($this->privates['Shopware\\Core\\Content\\ProductStream\\DataAbstractionLayer\\ProductStreamIndexer'] ?? $this->getProductStreamIndexerService());
            yield 12 => ($this->privates['Shopware\\Core\\Content\\Flow\\Indexing\\FlowIndexer'] ?? $this->getFlowIndexerService());
            yield 13 => ($this->privates['Shopware\\Core\\Checkout\\Payment\\DataAbstractionLayer\\PaymentMethodIndexer'] ?? $this->getPaymentMethodIndexerService());
            yield 14 => ($this->privates['Shopware\\Core\\Checkout\\Promotion\\DataAbstractionLayer\\PromotionIndexer'] ?? $this->getPromotionIndexerService());
            yield 15 => ($this->privates['Shopware\\Storefront\\Theme\\DataAbstractionLayer\\ThemeIndexer'] ?? $this->getThemeIndexerService());
        }, 16), $a, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Read\EntityReaderInterface' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityReader
     */
    protected function getEntityReaderInterfaceService()
    {
        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityReader(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityHydrator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityHydrator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityHydrator($this))), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper())), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Parser\\SqlQueryParser'] ?? $this->getSqlQueryParserService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\CriteriaQueryBuilder'] ?? $this->getCriteriaQueryBuilderService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Search\EntityAggregatorInterface' shared service.
     *
     * @return \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntityAggregator
     */
    protected function getEntityAggregatorInterfaceService()
    {
        $a = ($this->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'] ?? $this->getElasticsearchHelperService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService());

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] = new \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntityAggregator($a, ($this->services['Elasticsearch\\Client'] ?? $this->getClientService()), new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityAggregator(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper())), $c, ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\CriteriaQueryBuilder'] ?? $this->getCriteriaQueryBuilderService()), $this->getEnv('bool:SHOPWARE_DBAL_TIMEZONE_SUPPORT_ENABLED'), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Term\\SearchTermInterpreter'] ?? $this->getSearchTermInterpreterService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Term\\EntityScoreQueryBuilder'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\Term\\EntityScoreQueryBuilder'] = new \Shopware\Core\Framework\DataAbstractionLayer\Search\Term\EntityScoreQueryBuilder()))), new \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntityAggregatorHydrator($c), $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Search\EntitySearcherInterface' shared service.
     *
     * @return \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntitySearcher
     */
    protected function getEntitySearcherInterfaceService()
    {
        $a = ($this->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'] ?? $this->getElasticsearchHelperService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'];
        }

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] = new \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntitySearcher(($this->services['Elasticsearch\\Client'] ?? $this->getClientService()), new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntitySearcher(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper())), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\CriteriaQueryBuilder'] ?? $this->getCriteriaQueryBuilderService())), $a, ($this->privates['Shopware\\Elasticsearch\\Framework\\DataAbstractionLayer\\CriteriaParser'] ?? $this->getCriteriaParserService()), new \Shopware\Elasticsearch\Framework\DataAbstractionLayer\ElasticsearchEntitySearchHydrator(), $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\VersionManager' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\VersionManager
     */
    protected function getVersionManagerService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'] ?? $this->getEntityWriterService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] ?? $this->getEntityWriteGatewayInterfaceService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'];
        }

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] = new \Shopware\Core\Framework\DataAbstractionLayer\VersionManager($a, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $b, $c, $d, ($this->services['.container.private.serializer'] ?? $this->get_Container_Private_SerializerService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition'] ?? $this->getVersionCommitDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition'] ?? $this->getVersionCommitDataDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition'] ?? $this->getVersionDefinitionService()), ($this->privates['lock.default.factory'] ?? $this->getLock_Default_FactoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommitData\VersionCommitDataDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommitData\VersionCommitDataDefinition
     */
    protected function getVersionCommitDataDefinitionService()
    {
        $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition'] = $instance = new \Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommitData\VersionCommitDataDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommit\VersionCommitDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommit\VersionCommitDefinition
     */
    protected function getVersionCommitDefinitionService()
    {
        $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition'] = $instance = new \Shopware\Core\Framework\DataAbstractionLayer\Version\Aggregate\VersionCommit\VersionCommitDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Version\VersionDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Version\VersionDefinition
     */
    protected function getVersionDefinitionService()
    {
        $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition'] = $instance = new \Shopware\Core\Framework\DataAbstractionLayer\Version\VersionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriteGatewayInterface' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityWriteGateway
     */
    protected function getEntityWriteGatewayInterfaceService()
    {
        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'];
        }

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityWriteGateway(125, ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), $a, new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\ExceptionHandlerRegistry(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\System\\Language\\LanguageExceptionHandler'] ?? ($this->privates['Shopware\\Core\\System\\Language\\LanguageExceptionHandler'] = new \Shopware\Core\System\Language\LanguageExceptionHandler()));
            yield 1 => ($this->privates['Shopware\\Core\\System\\SalesChannel\\SalesChannelExceptionHandler'] ?? ($this->privates['Shopware\\Core\\System\\SalesChannel\\SalesChannelExceptionHandler'] = new \Shopware\Core\System\SalesChannel\SalesChannelExceptionHandler()));
            yield 2 => ($this->privates['Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\ProductExceptionHandler'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\DataAbstractionLayer\\ProductExceptionHandler'] = new \Shopware\Core\Content\Product\DataAbstractionLayer\ProductExceptionHandler()));
            yield 3 => ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingExceptionHandler'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingExceptionHandler'] = new \Shopware\Core\Content\Product\SalesChannel\Sorting\ProductSortingExceptionHandler()));
            yield 4 => ($this->privates['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldExceptionHandler'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldExceptionHandler'] = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfigField\ProductSearchConfigFieldExceptionHandler()));
            yield 5 => ($this->privates['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigExceptionHandler'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigExceptionHandler'] = new \Shopware\Core\Content\Product\Aggregate\ProductSearchConfig\ProductSearchConfigExceptionHandler()));
            yield 6 => ($this->privates['Shopware\\Core\\Content\\Newsletter\\NewsletterExceptionHandler'] ?? ($this->privates['Shopware\\Core\\Content\\Newsletter\\NewsletterExceptionHandler'] = new \Shopware\Core\Content\Newsletter\NewsletterExceptionHandler()));
            yield 7 => ($this->privates['Shopware\\Core\\Content\\ProductExport\\DataAbstractionLayer\\ProductExportExceptionHandler'] ?? ($this->privates['Shopware\\Core\\Content\\ProductExport\\DataAbstractionLayer\\ProductExportExceptionHandler'] = new \Shopware\Core\Content\ProductExport\DataAbstractionLayer\ProductExportExceptionHandler()));
            yield 8 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\DataAbstractionLayer\\CustomerWishlistProductExceptionHandler'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\DataAbstractionLayer\\CustomerWishlistProductExceptionHandler'] = new \Shopware\Core\Checkout\Customer\DataAbstractionLayer\CustomerWishlistProductExceptionHandler()));
            yield 9 => ($this->privates['Shopware\\Core\\Checkout\\Order\\OrderExceptionHandler'] ?? ($this->privates['Shopware\\Core\\Checkout\\Order\\OrderExceptionHandler'] = new \Shopware\Core\Checkout\Order\OrderExceptionHandler()));
        }, 10)), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriter' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriter
     */
    protected function getEntityWriterService()
    {
        $a = ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\WriteCommandExtractor'] ?? $this->getWriteCommandExtractorService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriteGatewayInterface'] ?? $this->getEntityWriteGatewayInterfaceService());

        if (isset($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'])) {
            return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'];
        }
        $c = ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService());
        $d = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService());

        return $this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Write\\EntityWriter'] = new \Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriter($a, new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityForeignKeyResolver($c, ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\EntityDefinitionQueryHelper'] = new \Shopware\Core\Framework\DataAbstractionLayer\Dbal\EntityDefinitionQueryHelper()))), $b, ($this->privates['Shopware\\Core\\System\\Language\\CachedLanguageLoader'] ?? $this->getCachedLanguageLoaderService()), $d, new \Shopware\Core\Framework\DataAbstractionLayer\Write\EntityWriteResultFactory($d, $c));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Event\BusinessEventRegistry' shared service.
     *
     * @return \Shopware\Core\Framework\Event\BusinessEventRegistry
     */
    protected function getBusinessEventRegistryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Event/BusinessEventRegistry.php';

        $this->services['Shopware\\Core\\Framework\\Event\\BusinessEventRegistry'] = $instance = new \Shopware\Core\Framework\Event\BusinessEventRegistry();

        $instance->addClasses([0 => 'Shopware\\Core\\Framework\\Event\\BusinessEvent', 1 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerBeforeLoginEvent', 2 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerLoginEvent', 3 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerLogoutEvent', 4 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerDeletedEvent', 5 => 'Shopware\\Core\\System\\User\\Recovery\\UserRecoveryRequestEvent', 6 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerChangedPaymentMethodEvent', 7 => 'Shopware\\Core\\Checkout\\Cart\\Event\\CheckoutOrderPlacedEvent', 8 => 'Shopware\\Core\\Checkout\\Order\\Event\\OrderPaymentMethodChangedEvent', 9 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerAccountRecoverRequestEvent', 10 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerDoubleOptInRegistrationEvent', 11 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerGroupRegistrationAccepted', 12 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerGroupRegistrationDeclined', 13 => 'Shopware\\Core\\Checkout\\Customer\\Event\\CustomerRegisterEvent', 14 => 'Shopware\\Core\\Checkout\\Customer\\Event\\DoubleOptInGuestOrderEvent', 15 => 'Shopware\\Core\\Checkout\\Customer\\Event\\GuestCustomerRegisterEvent', 16 => 'Shopware\\Core\\Content\\ContactForm\\Event\\ContactFormEvent', 17 => 'Shopware\\Core\\Content\\MailTemplate\\Service\\Event\\MailBeforeSentEvent', 18 => 'Shopware\\Core\\Content\\MailTemplate\\Service\\Event\\MailBeforeValidateEvent', 19 => 'Shopware\\Core\\Content\\MailTemplate\\Service\\Event\\MailSentEvent', 20 => 'Shopware\\Core\\Content\\Newsletter\\Event\\NewsletterConfirmEvent', 21 => 'Shopware\\Core\\Content\\Newsletter\\Event\\NewsletterRegisterEvent', 22 => 'Shopware\\Core\\Content\\Newsletter\\Event\\NewsletterUnsubscribeEvent', 23 => 'Shopware\\Core\\Content\\Newsletter\\Event\\NewsletterUpdateEvent', 24 => 'Shopware\\Core\\Content\\ProductExport\\Event\\ProductExportLoggingEvent']);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Event\EventAction\Aggregate\EventActionRule\EventActionRuleDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Event\EventAction\Aggregate\EventActionRule\EventActionRuleDefinition
     */
    protected function getEventActionRuleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Event/EventAction/Aggregate/EventActionRule/EventActionRuleDefinition.php';

        $this->services['Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionRule\\EventActionRuleDefinition'] = $instance = new \Shopware\Core\Framework\Event\EventAction\Aggregate\EventActionRule\EventActionRuleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Event\EventAction\Aggregate\EventActionSalesChannel\EventActionSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Event\EventAction\Aggregate\EventActionSalesChannel\EventActionSalesChannelDefinition
     */
    protected function getEventActionSalesChannelDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Event/EventAction/Aggregate/EventActionSalesChannel/EventActionSalesChannelDefinition.php';

        $this->services['Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionSalesChannel\\EventActionSalesChannelDefinition'] = $instance = new \Shopware\Core\Framework\Event\EventAction\Aggregate\EventActionSalesChannel\EventActionSalesChannelDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Event\EventAction\EventActionDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Event\EventAction\EventActionDefinition
     */
    protected function getEventActionDefinitionService()
    {
        $this->services['Shopware\\Core\\Framework\\Event\\EventAction\\EventActionDefinition'] = $instance = new \Shopware\Core\Framework\Event\EventAction\EventActionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Increment\Controller\IncrementApiController' shared service.
     *
     * @return \Shopware\Core\Framework\Increment\Controller\IncrementApiController
     */
    protected function getIncrementApiControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Increment/Controller/IncrementApiController.php';

        return $this->services['Shopware\\Core\\Framework\\Increment\\Controller\\IncrementApiController'] = new \Shopware\Core\Framework\Increment\Controller\IncrementApiController(($this->services['shopware.increment.gateway.registry'] ?? $this->getShopware_Increment_Gateway_RegistryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Log\LogEntryDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Log\LogEntryDefinition
     */
    protected function getLogEntryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Log/LogEntryDefinition.php';

        $this->services['Shopware\\Core\\Framework\\Log\\LogEntryDefinition'] = $instance = new \Shopware\Core\Framework\Log\LogEntryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\MessageQueue\Api\ConsumeMessagesController' shared service.
     *
     * @return \Shopware\Core\Framework\MessageQueue\Api\ConsumeMessagesController
     */
    protected function getConsumeMessagesControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/MessageQueue/Api/ConsumeMessagesController.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/messenger/EventListener/StopWorkerOnSigtermSignalListener.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/messenger/EventListener/DispatchPcntlSignalListener.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/MessageQueue/Subscriber/EarlyReturnMessagesListener.php';

        $this->services['Shopware\\Core\\Framework\\MessageQueue\\Api\\ConsumeMessagesController'] = $instance = new \Shopware\Core\Framework\MessageQueue\Api\ConsumeMessagesController(($this->privates['messenger.receiver_locator'] ?? $this->getMessenger_ReceiverLocatorService()), ($this->services['messenger.default_bus'] ?? $this->getMessenger_DefaultBusService()), 20, ($this->privates['messenger.listener.stop_worker_on_restart_signal_listener'] ?? $this->getMessenger_Listener_StopWorkerOnRestartSignalListenerService()), new \Symfony\Component\Messenger\EventListener\StopWorkerOnSigtermSignalListener(($this->privates['monolog.logger.messenger'] ?? $this->getMonolog_Logger_MessengerService())), new \Symfony\Component\Messenger\EventListener\DispatchPcntlSignalListener(), new \Shopware\Core\Framework\MessageQueue\Subscriber\EarlyReturnMessagesListener(), 'default', '128M');

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\MessageQueue\DeadMessage\DeadMessageDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\MessageQueue\DeadMessage\DeadMessageDefinition
     */
    protected function getDeadMessageDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/MessageQueue/DeadMessage/DeadMessageDefinition.php';

        $this->services['Shopware\\Core\\Framework\\MessageQueue\\DeadMessage\\DeadMessageDefinition'] = $instance = new \Shopware\Core\Framework\MessageQueue\DeadMessage\DeadMessageDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\MessageQueue\MessageQueueStatsDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\MessageQueue\MessageQueueStatsDefinition
     */
    protected function getMessageQueueStatsDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/MessageQueue/MessageQueueStatsDefinition.php';

        $this->services['Shopware\\Core\\Framework\\MessageQueue\\MessageQueueStatsDefinition'] = $instance = new \Shopware\Core\Framework\MessageQueue\MessageQueueStatsDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\MessageQueue\ScheduledTask\Api\ScheduledTaskController' shared service.
     *
     * @return \Shopware\Core\Framework\MessageQueue\ScheduledTask\Api\ScheduledTaskController
     */
    protected function getScheduledTaskControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/MessageQueue/ScheduledTask/Api/ScheduledTaskController.php';

        $this->services['Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\Api\\ScheduledTaskController'] = $instance = new \Shopware\Core\Framework\MessageQueue\ScheduledTask\Api\ScheduledTaskController(($this->privates['Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\Scheduler\\TaskScheduler'] ?? $this->getTaskSchedulerService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\MessageQueue\ScheduledTask\ScheduledTaskDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\MessageQueue\ScheduledTask\ScheduledTaskDefinition
     */
    protected function getScheduledTaskDefinitionService()
    {
        $this->services['Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition'] = $instance = new \Shopware\Core\Framework\MessageQueue\ScheduledTask\ScheduledTaskDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Migration\Api\MigrationController' shared service.
     *
     * @return \Shopware\Core\Framework\Migration\Api\MigrationController
     */
    protected function getMigrationControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Migration/Api/MigrationController.php';

        $this->services['Shopware\\Core\\Framework\\Migration\\Api\\MigrationController'] = $instance = new \Shopware\Core\Framework\Migration\Api\MigrationController(($this->services['Shopware\\Core\\Framework\\Migration\\MigrationCollectionLoader'] ?? $this->getMigrationCollectionLoaderService()), '6.4.18.0');

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Migration\IndexerQueuer' shared service.
     *
     * @return \Shopware\Core\Framework\Migration\IndexerQueuer
     */
    protected function getIndexerQueuerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Migration/IndexerQueuer.php';

        return $this->services['Shopware\\Core\\Framework\\Migration\\IndexerQueuer'] = new \Shopware\Core\Framework\Migration\IndexerQueuer(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Migration\MigrationCollectionLoader' shared service.
     *
     * @return \Shopware\Core\Framework\Migration\MigrationCollectionLoader
     */
    protected function getMigrationCollectionLoaderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Migration/MigrationCollectionLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Migration/MigrationRuntime.php';

        $a = ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService());
        $b = ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService());

        return $this->services['Shopware\\Core\\Framework\\Migration\\MigrationCollectionLoader'] = new \Shopware\Core\Framework\Migration\MigrationCollectionLoader($a, new \Shopware\Core\Framework\Migration\MigrationRuntime($a, $b), new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core'] ?? ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core'] = new \Shopware\Core\Framework\Migration\MigrationSource('core')));
            yield 1 => ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core.V6_3'] ?? $this->getMigrationSource_Core_V63Service());
            yield 2 => ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core.V6_4'] ?? $this->getMigrationSource_Core_V64Service());
            yield 3 => ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.core.V6_5'] ?? $this->getMigrationSource_Core_V65Service());
            yield 4 => ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.null'] ?? ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource.null'] = new \Shopware\Core\Framework\Migration\MigrationSource('null', [])));
            yield 5 => ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Framework'] ?? ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Framework'] = new \Shopware\Core\Framework\Migration\MigrationSource('Framework', [(\dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Migration') => 'Shopware\\Core\\Framework\\Migration'])));
            yield 6 => ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Administration'] ?? ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Administration'] = new \Shopware\Core\Framework\Migration\MigrationSource('Administration', [(\dirname(__DIR__, 4).'/vendor/shopware/administration/Migration') => 'Shopware\\Administration\\Migration'])));
            yield 7 => ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Storefront'] ?? ($this->privates['Shopware\\Core\\Framework\\Migration\\MigrationSource_Storefront'] = new \Shopware\Core\Framework\Migration\MigrationSource('Storefront', [(\dirname(__DIR__, 4).'/vendor/shopware/storefront/Migration') => 'Shopware\\Storefront\\Migration'])));
        }, 8), $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\Aggregate\PluginTranslation\PluginTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\Aggregate\PluginTranslation\PluginTranslationDefinition
     */
    protected function getPluginTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Plugin/Aggregate/PluginTranslation/PluginTranslationDefinition.php';

        $this->services['Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition'] = $instance = new \Shopware\Core\Framework\Plugin\Aggregate\PluginTranslation\PluginTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\KernelPluginCollection' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\KernelPluginCollection
     */
    protected function getKernelPluginCollectionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Plugin/KernelPluginCollection.php';

        return $this->services['Shopware\\Core\\Framework\\Plugin\\KernelPluginCollection'] = ($this->services['Shopware\\Core\\Framework\\Plugin\\KernelPluginLoader\\KernelPluginLoader'] ?? $this->getKernelPluginLoaderService())->getPluginInstances();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\KernelPluginLoader\KernelPluginLoader' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\KernelPluginLoader\KernelPluginLoader
     */
    protected function getKernelPluginLoaderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ContainerAwareInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Bundle/BundleInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/dependency-injection/ContainerAwareTrait.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/Bundle/Bundle.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Plugin/KernelPluginLoader/KernelPluginLoader.php';

        return $this->services['Shopware\\Core\\Framework\\Plugin\\KernelPluginLoader\\KernelPluginLoader'] = ($this->services['kernel'] ?? $this->get('kernel', 1))->getPluginLoader();
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\PluginDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\PluginDefinition
     */
    protected function getPluginDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Plugin/PluginDefinition.php';

        $this->services['Shopware\\Core\\Framework\\Plugin\\PluginDefinition'] = $instance = new \Shopware\Core\Framework\Plugin\PluginDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Plugin\Util\PluginIdProvider' shared service.
     *
     * @return \Shopware\Core\Framework\Plugin\Util\PluginIdProvider
     */
    protected function getPluginIdProviderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Plugin/Util/PluginIdProvider.php';

        return $this->services['Shopware\\Core\\Framework\\Plugin\\Util\\PluginIdProvider'] = new \Shopware\Core\Framework\Plugin\Util\PluginIdProvider(($this->services['plugin.repository'] ?? $this->getPlugin_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Routing\CanonicalRedirectService' shared service.
     *
     * @return \Shopware\Core\Framework\Routing\CanonicalRedirectService
     */
    protected function getCanonicalRedirectServiceService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/CanonicalRedirectService.php';

        return $this->services['Shopware\\Core\\Framework\\Routing\\CanonicalRedirectService'] = new \Shopware\Core\Framework\Routing\CanonicalRedirectService(($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Routing\RequestTransformerInterface' shared autowired service.
     *
     * @return \Shopware\Storefront\Framework\Routing\RequestTransformer
     */
    protected function getRequestTransformerInterfaceService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/RequestTransformerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Routing/RequestTransformer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Routing/RequestTransformer.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Routing/AbstractDomainLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Routing/CachedDomainLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Routing/DomainLoader.php';

        return $this->services['Shopware\\Core\\Framework\\Routing\\RequestTransformerInterface'] = new \Shopware\Storefront\Framework\Routing\RequestTransformer(new \Shopware\Core\Framework\Routing\RequestTransformer(), ($this->services['Shopware\\Core\\Content\\Seo\\EmptyPathInfoResolver'] ?? $this->getEmptyPathInfoResolverService()), $this->getParameter('shopware.routing.registered_api_prefixes'), new \Shopware\Storefront\Framework\Routing\CachedDomainLoader(new \Shopware\Storefront\Framework\Routing\DomainLoader(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService())));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Rule\Api\RuleConfigController' shared service.
     *
     * @return \Shopware\Core\Framework\Rule\Api\RuleConfigController
     */
    protected function getRuleConfigControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Rule/Api/RuleConfigController.php';

        $this->services['Shopware\\Core\\Framework\\Rule\\Api\\RuleConfigController'] = $instance = new \Shopware\Core\Framework\Rule\Api\RuleConfigController(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\AndRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\AndRule'] = new \Shopware\Core\Framework\Rule\Container\AndRule()));
            yield 1 => ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\NotRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\NotRule'] = new \Shopware\Core\Framework\Rule\Container\NotRule()));
            yield 2 => ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\OrRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\OrRule'] = new \Shopware\Core\Framework\Rule\Container\OrRule()));
            yield 3 => ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\XorRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\XorRule'] = new \Shopware\Core\Framework\Rule\Container\XorRule()));
            yield 4 => ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\MatchAllLineItemsRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\Container\\MatchAllLineItemsRule'] = new \Shopware\Core\Framework\Rule\Container\MatchAllLineItemsRule()));
            yield 5 => ($this->privates['Shopware\\Core\\Framework\\Rule\\ScriptRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\ScriptRule'] = new \Shopware\Core\Framework\Rule\ScriptRule()));
            yield 6 => ($this->privates['Shopware\\Core\\Framework\\Rule\\DateRangeRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\DateRangeRule'] = new \Shopware\Core\Framework\Rule\DateRangeRule()));
            yield 7 => ($this->privates['Shopware\\Core\\Framework\\Rule\\SimpleRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\SimpleRule'] = new \Shopware\Core\Framework\Rule\SimpleRule()));
            yield 8 => ($this->privates['Shopware\\Core\\Framework\\Rule\\SalesChannelRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\SalesChannelRule'] = new \Shopware\Core\Framework\Rule\SalesChannelRule()));
            yield 9 => ($this->privates['Shopware\\Core\\Framework\\Rule\\TimeRangeRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\TimeRangeRule'] = new \Shopware\Core\Framework\Rule\TimeRangeRule()));
            yield 10 => ($this->privates['Shopware\\Core\\Framework\\Rule\\WeekdayRule'] ?? ($this->privates['Shopware\\Core\\Framework\\Rule\\WeekdayRule'] = new \Shopware\Core\Framework\Rule\WeekdayRule()));
            yield 11 => ($this->privates['Shopware\\Core\\System\\Language\\Rule\\LanguageRule'] ?? ($this->privates['Shopware\\Core\\System\\Language\\Rule\\LanguageRule'] = new \Shopware\Core\System\Language\Rule\LanguageRule()));
            yield 12 => ($this->privates['Shopware\\Core\\System\\Currency\\Rule\\CurrencyRule'] ?? ($this->privates['Shopware\\Core\\System\\Currency\\Rule\\CurrencyRule'] = new \Shopware\Core\System\Currency\Rule\CurrencyRule()));
            yield 13 => ($this->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderTagRule'] ?? ($this->privates['Shopware\\Core\\Content\\Flow\\Rule\\OrderTagRule'] = new \Shopware\Core\Content\Flow\Rule\OrderTagRule()));
            yield 14 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartAmountRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartAmountRule'] = new \Shopware\Core\Checkout\Cart\Rule\CartAmountRule()));
            yield 15 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartPositionPriceRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartPositionPriceRule'] = new \Shopware\Core\Checkout\Cart\Rule\CartPositionPriceRule()));
            yield 16 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\GoodsCountRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\GoodsCountRule'] = new \Shopware\Core\Checkout\Cart\Rule\GoodsCountRule()));
            yield 17 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\GoodsPriceRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\GoodsPriceRule'] = new \Shopware\Core\Checkout\Cart\Rule\GoodsPriceRule()));
            yield 18 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemOfTypeRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemOfTypeRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemOfTypeRule()));
            yield 19 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemRule()));
            yield 20 => ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionLineItemRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionLineItemRule'] = new \Shopware\Core\Checkout\Promotion\Rule\PromotionLineItemRule()));
            yield 21 => ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionCodeOfTypeRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionCodeOfTypeRule'] = new \Shopware\Core\Checkout\Promotion\Rule\PromotionCodeOfTypeRule()));
            yield 22 => ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionValueRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionValueRule'] = new \Shopware\Core\Checkout\Promotion\Rule\PromotionValueRule()));
            yield 23 => ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionsInCartCountRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Rule\\PromotionsInCartCountRule'] = new \Shopware\Core\Checkout\Promotion\Rule\PromotionsInCartCountRule()));
            yield 24 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemsInCartRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemsInCartRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemsInCartRule()));
            yield 25 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemTotalPriceRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemTotalPriceRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemTotalPriceRule()));
            yield 26 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemUnitPriceRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemUnitPriceRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemUnitPriceRule()));
            yield 27 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemWithQuantityRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemWithQuantityRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemWithQuantityRule()));
            yield 28 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemWrapperRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemWrapperRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemWrapperRule()));
            yield 29 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartWeightRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartWeightRule'] = new \Shopware\Core\Checkout\Cart\Rule\CartWeightRule()));
            yield 30 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartVolumeRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartVolumeRule'] = new \Shopware\Core\Checkout\Cart\Rule\CartVolumeRule()));
            yield 31 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartHasDeliveryFreeItemRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartHasDeliveryFreeItemRule'] = new \Shopware\Core\Checkout\Cart\Rule\CartHasDeliveryFreeItemRule()));
            yield 32 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingCountryRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingCountryRule'] = new \Shopware\Core\Checkout\Customer\Rule\BillingCountryRule()));
            yield 33 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingStreetRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingStreetRule'] = new \Shopware\Core\Checkout\Customer\Rule\BillingStreetRule()));
            yield 34 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingZipCodeRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingZipCodeRule'] = new \Shopware\Core\Checkout\Customer\Rule\BillingZipCodeRule()));
            yield 35 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerGroupRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerGroupRule'] = new \Shopware\Core\Checkout\Customer\Rule\CustomerGroupRule()));
            yield 36 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerTagRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerTagRule'] = new \Shopware\Core\Checkout\Customer\Rule\CustomerTagRule()));
            yield 37 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerNumberRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerNumberRule'] = new \Shopware\Core\Checkout\Customer\Rule\CustomerNumberRule()));
            yield 38 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DifferentAddressesRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DifferentAddressesRule'] = new \Shopware\Core\Checkout\Customer\Rule\DifferentAddressesRule()));
            yield 39 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\EmailRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\EmailRule'] = new \Shopware\Core\Checkout\Customer\Rule\EmailRule()));
            yield 40 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsNewCustomerRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsNewCustomerRule'] = new \Shopware\Core\Checkout\Customer\Rule\IsNewCustomerRule()));
            yield 41 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsActiveRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsActiveRule'] = new \Shopware\Core\Checkout\Customer\Rule\IsActiveRule()));
            yield 42 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\LastNameRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\LastNameRule'] = new \Shopware\Core\Checkout\Customer\Rule\LastNameRule()));
            yield 43 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsCompanyRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsCompanyRule'] = new \Shopware\Core\Checkout\Customer\Rule\IsCompanyRule()));
            yield 44 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartTaxDisplayRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\CartTaxDisplayRule'] = new \Shopware\Core\Checkout\Cart\Rule\CartTaxDisplayRule()));
            yield 45 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsGuestCustomerRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsGuestCustomerRule'] = new \Shopware\Core\Checkout\Customer\Rule\IsGuestCustomerRule()));
            yield 46 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsNewsletterRecipientRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\IsNewsletterRecipientRule'] = new \Shopware\Core\Checkout\Customer\Rule\IsNewsletterRecipientRule()));
            yield 47 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingCountryRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingCountryRule'] = new \Shopware\Core\Checkout\Customer\Rule\ShippingCountryRule()));
            yield 48 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingStreetRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingStreetRule'] = new \Shopware\Core\Checkout\Customer\Rule\ShippingStreetRule()));
            yield 49 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingCityRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingCityRule'] = new \Shopware\Core\Checkout\Customer\Rule\BillingCityRule()));
            yield 50 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingCityRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingCityRule'] = new \Shopware\Core\Checkout\Customer\Rule\ShippingCityRule()));
            yield 51 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingStateRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\BillingStateRule'] = new \Shopware\Core\Checkout\Customer\Rule\BillingStateRule()));
            yield 52 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingStateRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingStateRule'] = new \Shopware\Core\Checkout\Customer\Rule\ShippingStateRule()));
            yield 53 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingZipCodeRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\ShippingZipCodeRule'] = new \Shopware\Core\Checkout\Customer\Rule\ShippingZipCodeRule()));
            yield 54 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerLoggedInRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerLoggedInRule'] = new \Shopware\Core\Checkout\Customer\Rule\CustomerLoggedInRule()));
            yield 55 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemsInCartCountRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemsInCartCountRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemsInCartCountRule()));
            yield 56 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\OrderCountRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\OrderCountRule'] = new \Shopware\Core\Checkout\Customer\Rule\OrderCountRule()));
            yield 57 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DaysSinceLastOrderRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DaysSinceLastOrderRule'] = new \Shopware\Core\Checkout\Customer\Rule\DaysSinceLastOrderRule()));
            yield 58 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemTagRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemTagRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemTagRule()));
            yield 59 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\AlwaysValidRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\AlwaysValidRule'] = new \Shopware\Core\Checkout\Cart\Rule\AlwaysValidRule()));
            yield 60 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPropertyRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPropertyRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemPropertyRule()));
            yield 61 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemIsNewRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemIsNewRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemIsNewRule()));
            yield 62 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemOfManufacturerRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemOfManufacturerRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemOfManufacturerRule()));
            yield 63 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPurchasePriceRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPurchasePriceRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemPurchasePriceRule()));
            yield 64 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemCreationDateRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemCreationDateRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemCreationDateRule()));
            yield 65 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemReleaseDateRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemReleaseDateRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemReleaseDateRule()));
            yield 66 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemClearanceSaleRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemClearanceSaleRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemClearanceSaleRule()));
            yield 67 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPromotedRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemPromotedRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemPromotedRule()));
            yield 68 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemInCategoryRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemInCategoryRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemInCategoryRule()));
            yield 69 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemInProductStreamRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemInProductStreamRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemInProductStreamRule()));
            yield 70 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemTaxationRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemTaxationRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemTaxationRule()));
            yield 71 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionWidthRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionWidthRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionWidthRule()));
            yield 72 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionHeightRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionHeightRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionHeightRule()));
            yield 73 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionLengthRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionLengthRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionLengthRule()));
            yield 74 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionWeightRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionWeightRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionWeightRule()));
            yield 75 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionVolumeRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemDimensionVolumeRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemDimensionVolumeRule()));
            yield 76 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemListPriceRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemListPriceRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemListPriceRule()));
            yield 77 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemListPriceRatioRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemListPriceRatioRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemListPriceRatioRule()));
            yield 78 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemCustomFieldRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemCustomFieldRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemCustomFieldRule()));
            yield 79 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemStockRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemStockRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemStockRule()));
            yield 80 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemActualStockRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemActualStockRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemActualStockRule()));
            yield 81 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\PaymentMethodRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\PaymentMethodRule'] = new \Shopware\Core\Checkout\Cart\Rule\PaymentMethodRule()));
            yield 82 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\ShippingMethodRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\ShippingMethodRule'] = new \Shopware\Core\Checkout\Cart\Rule\ShippingMethodRule()));
            yield 83 => ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemGoodsTotalRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Rule\\LineItemGoodsTotalRule'] = new \Shopware\Core\Checkout\Cart\Rule\LineItemGoodsTotalRule()));
            yield 84 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\OrderTotalAmountRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\OrderTotalAmountRule'] = new \Shopware\Core\Checkout\Customer\Rule\OrderTotalAmountRule()));
            yield 85 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerCustomFieldRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerCustomFieldRule'] = new \Shopware\Core\Checkout\Customer\Rule\CustomerCustomFieldRule()));
            yield 86 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerBirthdayRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerBirthdayRule'] = new \Shopware\Core\Checkout\Customer\Rule\CustomerBirthdayRule()));
            yield 87 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerAgeRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CustomerAgeRule'] = new \Shopware\Core\Checkout\Customer\Rule\CustomerAgeRule()));
            yield 88 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DaysSinceLastLoginRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\DaysSinceLastLoginRule'] = new \Shopware\Core\Checkout\Customer\Rule\DaysSinceLastLoginRule()));
            yield 89 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\AffiliateCodeRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\AffiliateCodeRule'] = new \Shopware\Core\Checkout\Customer\Rule\AffiliateCodeRule()));
            yield 90 => ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CampaignCodeRule'] ?? ($this->privates['Shopware\\Core\\Checkout\\Customer\\Rule\\CampaignCodeRule'] = new \Shopware\Core\Checkout\Customer\Rule\CampaignCodeRule()));
        }, 91));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\Api\ScriptApiRoute' shared service.
     *
     * @return \Shopware\Core\Framework\Script\Api\ScriptApiRoute
     */
    protected function getScriptApiRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Api/ScriptApiRoute.php';

        return $this->services['Shopware\\Core\\Framework\\Script\\Api\\ScriptApiRoute'] = new \Shopware\Core\Framework\Script\Api\ScriptApiRoute(($this->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'] ?? $this->getScriptExecutorService()), ($this->privates['Shopware\\Core\\Framework\\Script\\Execution\\ScriptLoader'] ?? $this->getScriptLoaderService()), ($this->privates['Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseEncoder'] ?? $this->getScriptResponseEncoderService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\Api\ScriptResponseFactoryFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\Framework\Script\Api\ScriptResponseFactoryFacadeHookFactory
     */
    protected function getScriptResponseFactoryFacadeHookFactoryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Execution/Awareness/HookServiceFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Api/ScriptResponseFactoryFacadeHookFactory.php';

        return $this->services['Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseFactoryFacadeHookFactory'] = new \Shopware\Core\Framework\Script\Api\ScriptResponseFactoryFacadeHookFactory(($this->services['router'] ?? $this->getRouterService()), ($this->services['Shopware\\Storefront\\Controller\\ScriptController'] ?? $this->getScriptControllerService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\Api\ScriptStoreApiRoute' shared service.
     *
     * @return \Shopware\Core\Framework\Script\Api\ScriptStoreApiRoute
     */
    protected function getScriptStoreApiRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Api/ScriptStoreApiRoute.php';

        return $this->services['Shopware\\Core\\Framework\\Script\\Api\\ScriptStoreApiRoute'] = new \Shopware\Core\Framework\Script\Api\ScriptStoreApiRoute(($this->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'] ?? $this->getScriptExecutorService()), ($this->privates['Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseEncoder'] ?? $this->getScriptResponseEncoderService()), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\Execution\ScriptExecutor' shared service.
     *
     * @return \Shopware\Core\Framework\Script\Execution\ScriptExecutor
     */
    protected function getScriptExecutorService()
    {
        $a = ($this->privates['Shopware\\Core\\Framework\\Script\\Execution\\ScriptLoader'] ?? $this->getScriptLoaderService());

        if (isset($this->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'])) {
            return $this->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'];
        }
        $b = ($this->privates['twig.extension.trans'] ?? $this->getTwig_Extension_TransService());

        if (isset($this->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'])) {
            return $this->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'];
        }

        return $this->services['Shopware\\Core\\Framework\\Script\\Execution\\ScriptExecutor'] = new \Shopware\Core\Framework\Script\Execution\ScriptExecutor($a, ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()), ($this->privates['Shopware\\Core\\Framework\\Script\\Debugging\\ScriptTraces'] ?? ($this->privates['Shopware\\Core\\Framework\\Script\\Debugging\\ScriptTraces'] = new \Shopware\Core\Framework\Script\Debugging\ScriptTraces())), $this, $b);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Script\ScriptDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Script\ScriptDefinition
     */
    protected function getScriptDefinitionService()
    {
        $this->services['Shopware\\Core\\Framework\\Script\\ScriptDefinition'] = $instance = new \Shopware\Core\Framework\Script\ScriptDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\ExtensionStoreActionsController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\ExtensionStoreActionsController
     */
    protected function getExtensionStoreActionsControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Api/ExtensionStoreActionsController.php';

        $this->services['Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreActionsController'] = $instance = new \Shopware\Core\Framework\Store\Api\ExtensionStoreActionsController(($this->privates['Shopware\\Core\\Framework\\Store\\Services\\ExtensionLifecycleService'] ?? $this->getExtensionLifecycleServiceService()), ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\ExtensionDownloader'] ?? $this->getExtensionDownloaderService()), ($this->privates['Shopware\\Core\\Framework\\Plugin\\PluginService'] ?? $this->getPluginServiceService()), ($this->privates['Shopware\\Core\\Framework\\Plugin\\PluginManagementService'] ?? $this->getPluginManagementServiceService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\ExtensionStoreDataController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\ExtensionStoreDataController
     */
    protected function getExtensionStoreDataControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Api/ExtensionStoreDataController.php';

        $this->services['Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreDataController'] = $instance = new \Shopware\Core\Framework\Store\Api\ExtensionStoreDataController(($this->privates['Shopware\\Core\\Framework\\Store\\Services\\AbstractExtensionDataProvider'] ?? $this->getAbstractExtensionDataProviderService()), ($this->services['user.repository'] ?? $this->getUser_RepositoryService()), ($this->services['language.repository'] ?? $this->getLanguage_RepositoryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\ExtensionStoreLicensesController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\ExtensionStoreLicensesController
     */
    protected function getExtensionStoreLicensesControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Api/ExtensionStoreLicensesController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/AbstractExtensionStoreLicensesService.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/ExtensionStoreLicensesService.php';

        $this->services['Shopware\\Core\\Framework\\Store\\Api\\ExtensionStoreLicensesController'] = $instance = new \Shopware\Core\Framework\Store\Api\ExtensionStoreLicensesController(new \Shopware\Core\Framework\Store\Services\ExtensionStoreLicensesService(($this->privates['Shopware\\Core\\Framework\\Store\\Services\\StoreClient'] ?? $this->getStoreClientService())));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\FirstRunWizardController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\FirstRunWizardController
     */
    protected function getFirstRunWizardControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Api/FirstRunWizardController.php';

        $this->services['Shopware\\Core\\Framework\\Store\\Api\\FirstRunWizardController'] = $instance = new \Shopware\Core\Framework\Store\Api\FirstRunWizardController(($this->privates['Shopware\\Core\\Framework\\Store\\Services\\FirstRunWizardClient'] ?? $this->getFirstRunWizardClientService()), ($this->services['plugin.repository'] ?? $this->getPlugin_RepositoryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Api\StoreController' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Api\StoreController
     */
    protected function getStoreControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Api/StoreController.php';

        $this->services['Shopware\\Core\\Framework\\Store\\Api\\StoreController'] = $instance = new \Shopware\Core\Framework\Store\Api\StoreController(($this->privates['Shopware\\Core\\Framework\\Store\\Services\\StoreClient'] ?? $this->getStoreClientService()), ($this->services['plugin.repository'] ?? $this->getPlugin_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\Plugin\\PluginManagementService'] ?? $this->getPluginManagementServiceService()), ($this->services['user.repository'] ?? $this->getUser_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\AbstractExtensionDataProvider'] ?? $this->getAbstractExtensionDataProviderService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Authentication\StoreRequestOptionsProvider' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Authentication\StoreRequestOptionsProvider
     */
    protected function getStoreRequestOptionsProviderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Authentication/AbstractStoreRequestOptionsProvider.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Authentication/StoreRequestOptionsProvider.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/InstanceService.php';

        $a = ($this->services['user.repository'] ?? $this->getUser_RepositoryService());

        if (isset($this->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'])) {
            return $this->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'];
        }
        $b = ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService());

        if (isset($this->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'])) {
            return $this->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'];
        }

        return $this->services['Shopware\\Core\\Framework\\Store\\Authentication\\StoreRequestOptionsProvider'] = new \Shopware\Core\Framework\Store\Authentication\StoreRequestOptionsProvider($a, $b, ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\InstanceService'] ?? ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\InstanceService'] = new \Shopware\Core\Framework\Store\Services\InstanceService('6.4.18.0', $this->getEnv('INSTANCE_ID')))), ($this->privates['Shopware\\Core\\Framework\\Store\\Authentication\\LocaleProvider'] ?? $this->getLocaleProviderService()));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Services\ShopSecretInvalidMiddleware' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Services\ShopSecretInvalidMiddleware
     */
    protected function getShopSecretInvalidMiddlewareService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/MiddlewareInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/ShopSecretInvalidMiddleware.php';

        $a = ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService());

        if (isset($this->services['Shopware\\Core\\Framework\\Store\\Services\\ShopSecretInvalidMiddleware'])) {
            return $this->services['Shopware\\Core\\Framework\\Store\\Services\\ShopSecretInvalidMiddleware'];
        }

        return $this->services['Shopware\\Core\\Framework\\Store\\Services\\ShopSecretInvalidMiddleware'] = new \Shopware\Core\Framework\Store\Services\ShopSecretInvalidMiddleware(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), $a);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Services\StoreSessionExpiredMiddleware' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Services\StoreSessionExpiredMiddleware
     */
    protected function getStoreSessionExpiredMiddlewareService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/MiddlewareInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/StoreSessionExpiredMiddleware.php';

        return $this->services['Shopware\\Core\\Framework\\Store\\Services\\StoreSessionExpiredMiddleware'] = new \Shopware\Core\Framework\Store\Services\StoreSessionExpiredMiddleware(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Store\Services\VerifyResponseSignatureMiddleware' shared service.
     *
     * @return \Shopware\Core\Framework\Store\Services\VerifyResponseSignatureMiddleware
     */
    protected function getVerifyResponseSignatureMiddlewareService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/MiddlewareInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/VerifyResponseSignatureMiddleware.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/OpenSSLVerifier.php';

        return $this->services['Shopware\\Core\\Framework\\Store\\Services\\VerifyResponseSignatureMiddleware'] = new \Shopware\Core\Framework\Store\Services\VerifyResponseSignatureMiddleware(($this->privates['Shopware\\Core\\Framework\\Store\\Services\\OpenSSLVerifier'] ?? ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\OpenSSLVerifier'] = new \Shopware\Core\Framework\Store\Services\OpenSSLVerifier([0 => (\dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/public.key')]))));
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Update\Api\UpdateController' shared service.
     *
     * @return \Shopware\Core\Framework\Update\Api\UpdateController
     */
    protected function getUpdateControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Update/Api/UpdateController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Update/Services/ApiClient.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Update/Services/UpdateApiHttpClientFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Update/Services/RequirementsValidator.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Update/Services/PluginCompatibility.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/Services/OpenSSLVerifier.php';

        $a = ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService());

        $this->services['Shopware\\Core\\Framework\\Update\\Api\\UpdateController'] = $instance = new \Shopware\Core\Framework\Update\Api\UpdateController(\dirname(__DIR__, 4), new \Shopware\Core\Framework\Update\Services\ApiClient('6.4.18.0', $a, ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\OpenSSLVerifier'] ?? ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\OpenSSLVerifier'] = new \Shopware\Core\Framework\Store\Services\OpenSSLVerifier([0 => (\dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Store/public.key')]))), (new \Shopware\Core\Framework\Update\Services\UpdateApiHttpClientFactory($a))->__invoke(), true), new \Shopware\Core\Framework\Update\Services\RequirementsValidator(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\Framework\\Update\\Checkers\\PhpVersionCheck'] ?? ($this->privates['Shopware\\Core\\Framework\\Update\\Checkers\\PhpVersionCheck'] = new \Shopware\Core\Framework\Update\Checkers\PhpVersionCheck()));
            yield 1 => ($this->privates['Shopware\\Core\\Framework\\Update\\Checkers\\LicenseCheck'] ?? $this->getLicenseCheckService());
            yield 2 => ($this->privates['Shopware\\Core\\Framework\\Update\\Checkers\\WriteableCheck'] ?? $this->getWriteableCheckService());
            yield 3 => ($this->privates['Shopware\\Core\\Framework\\Update\\Checkers\\MysqlVersionCheck'] ?? $this->getMysqlVersionCheckService());
        }, 4)), new \Shopware\Core\Framework\Update\Services\PluginCompatibility(($this->privates['Shopware\\Core\\Framework\\Store\\Services\\StoreClient'] ?? $this->getStoreClientService()), ($this->services['plugin.repository'] ?? $this->getPlugin_RepositoryService()), ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\AbstractExtensionDataProvider'] ?? $this->getAbstractExtensionDataProviderService())), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), $a, ($this->privates['Shopware\\Core\\Framework\\Store\\Services\\ExtensionLifecycleService'] ?? $this->getExtensionLifecycleServiceService()), ($this->services['user.repository'] ?? $this->getUser_RepositoryService()), '6.4.18.0', $this->getEnv('bool:SHOPWARE_UPDATE_TEST'));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Util\HtmlSanitizer' shared service.
     *
     * @return \Shopware\Core\Framework\Util\HtmlSanitizer
     */
    protected function getHtmlSanitizerService()
    {
        return $this->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] = new \Shopware\Core\Framework\Util\HtmlSanitizer($this->targetDir.'', true, $this->parameters['shopware.html_sanitizer.sets'], $this->parameters['shopware.html_sanitizer.fields']);
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Webhook\EventLog\WebhookEventLogDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Webhook\EventLog\WebhookEventLogDefinition
     */
    protected function getWebhookEventLogDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Webhook/EventLog/WebhookEventLogDefinition.php';

        $this->services['Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition'] = $instance = new \Shopware\Core\Framework\Webhook\EventLog\WebhookEventLogDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Framework\Webhook\WebhookDefinition' shared service.
     *
     * @return \Shopware\Core\Framework\Webhook\WebhookDefinition
     */
    protected function getWebhookDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Webhook/WebhookDefinition.php';

        $this->services['Shopware\\Core\\Framework\\Webhook\\WebhookDefinition'] = $instance = new \Shopware\Core\Framework\Webhook\WebhookDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\Maintenance\SalesChannel\Service\SalesChannelCreator' shared autowired service.
     *
     * @return \Shopware\Core\Maintenance\SalesChannel\Service\SalesChannelCreator
     */
    protected function getSalesChannelCreatorService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Maintenance/SalesChannel/Service/SalesChannelCreator.php';

        return $this->services['Shopware\\Core\\Maintenance\\SalesChannel\\Service\\SalesChannelCreator'] = new \Shopware\Core\Maintenance\SalesChannel\Service\SalesChannelCreator(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['sales_channel.repository'] ?? $this->getSalesChannel_RepositoryService()), ($this->services['payment_method.repository'] ?? $this->getPaymentMethod_RepositoryService()), ($this->services['shipping_method.repository'] ?? $this->getShippingMethod_RepositoryService()), ($this->services['country.repository'] ?? $this->getCountry_RepositoryService()), ($this->services['category.repository'] ?? $this->getCategory_RepositoryService()));
    }

    /*
     * Gets the public 'Shopware\Core\Maintenance\User\Service\UserProvisioner' shared autowired service.
     *
     * @return \Shopware\Core\Maintenance\User\Service\UserProvisioner
     */
    protected function getUserProvisionerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Maintenance/User/Service/UserProvisioner.php';

        return $this->services['Shopware\\Core\\Maintenance\\User\\Service\\UserProvisioner'] = new \Shopware\Core\Maintenance\User\Service\UserProvisioner(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\Profiling\Profiler' shared service.
     *
     * @return \Shopware\Core\Profiling\Profiler
     */
    protected function getProfilerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Profiling/Profiler.php';

        return $this->services['Shopware\\Core\\Profiling\\Profiler'] = new \Shopware\Core\Profiling\Profiler(new RewindableGenerator(function () {
            yield 'Symfony' => ($this->privates['Shopware\\Core\\Profiling\\Integration\\Stopwatch'] ?? $this->getStopwatchService());
            yield 'Tideways' => ($this->privates['Shopware\\Core\\Profiling\\Integration\\Tideways'] ?? ($this->privates['Shopware\\Core\\Profiling\\Integration\\Tideways'] = new \Shopware\Core\Profiling\Integration\Tideways()));
            yield 'Datadog' => ($this->privates['Shopware\\Core\\Profiling\\Integration\\Datadog'] ?? ($this->privates['Shopware\\Core\\Profiling\\Integration\\Datadog'] = new \Shopware\Core\Profiling\Integration\Datadog()));
        }, 3), []);
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\Aggregate\CountryStateTranslation\CountryStateTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\Aggregate\CountryStateTranslation\CountryStateTranslationDefinition
     */
    protected function getCountryStateTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/Aggregate/CountryStateTranslation/CountryStateTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition'] = $instance = new \Shopware\Core\System\Country\Aggregate\CountryStateTranslation\CountryStateTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\Aggregate\CountryState\CountryStateDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\Aggregate\CountryState\CountryStateDefinition
     */
    protected function getCountryStateDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\CountryStateDefinition'] = $instance = new \Shopware\Core\System\Country\Aggregate\CountryState\CountryStateDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\Aggregate\CountryState\SalesChannel\SalesChannelCountryStateDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\Aggregate\CountryState\SalesChannel\SalesChannelCountryStateDefinition
     */
    protected function getSalesChannelCountryStateDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/Aggregate/CountryState/SalesChannel/SalesChannelCountryStateDefinition.php';

        $this->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition'] = $instance = new \Shopware\Core\System\Country\Aggregate\CountryState\SalesChannel\SalesChannelCountryStateDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\Aggregate\CountryTranslation\CountryTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\Aggregate\CountryTranslation\CountryTranslationDefinition
     */
    protected function getCountryTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/Aggregate/CountryTranslation/CountryTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition'] = $instance = new \Shopware\Core\System\Country\Aggregate\CountryTranslation\CountryTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\CountryDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\CountryDefinition
     */
    protected function getCountryDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Country\\CountryDefinition'] = $instance = new \Shopware\Core\System\Country\CountryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\SalesChannel\CachedCountryRoute' shared service.
     *
     * @return \Shopware\Core\System\Country\SalesChannel\CachedCountryRoute
     */
    protected function getCachedCountryRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/SalesChannel/AbstractCountryRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/SalesChannel/CachedCountryRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/SalesChannel/CountryRoute.php';

        return $this->services['Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryRoute'] = new \Shopware\Core\System\Country\SalesChannel\CachedCountryRoute(new \Shopware\Core\System\Country\SalesChannel\CountryRoute(($this->services['sales_channel.country.repository'] ?? $this->getSalesChannel_Country_RepositoryService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), []);
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\SalesChannel\CachedCountryStateRoute' shared service.
     *
     * @return \Shopware\Core\System\Country\SalesChannel\CachedCountryStateRoute
     */
    protected function getCachedCountryStateRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/SalesChannel/AbstractCountryStateRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/SalesChannel/CachedCountryStateRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/SalesChannel/CountryStateRoute.php';

        return $this->services['Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryStateRoute'] = new \Shopware\Core\System\Country\SalesChannel\CachedCountryStateRoute(new \Shopware\Core\System\Country\SalesChannel\CountryStateRoute(($this->services['country_state.repository'] ?? $this->getCountryState_RepositoryService())), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), []);
    }

    /*
     * Gets the public 'Shopware\Core\System\Country\SalesChannel\SalesChannelCountryDefinition' shared service.
     *
     * @return \Shopware\Core\System\Country\SalesChannel\SalesChannelCountryDefinition
     */
    protected function getSalesChannelCountryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Country/SalesChannel/SalesChannelCountryDefinition.php';

        $this->services['Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition'] = $instance = new \Shopware\Core\System\Country\SalesChannel\SalesChannelCountryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\Aggregate\CurrencyCountryRounding\CurrencyCountryRoundingDefinition' shared service.
     *
     * @return \Shopware\Core\System\Currency\Aggregate\CurrencyCountryRounding\CurrencyCountryRoundingDefinition
     */
    protected function getCurrencyCountryRoundingDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition'] = $instance = new \Shopware\Core\System\Currency\Aggregate\CurrencyCountryRounding\CurrencyCountryRoundingDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\Aggregate\CurrencyTranslation\CurrencyTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Currency\Aggregate\CurrencyTranslation\CurrencyTranslationDefinition
     */
    protected function getCurrencyTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Currency/Aggregate/CurrencyTranslation/CurrencyTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition'] = $instance = new \Shopware\Core\System\Currency\Aggregate\CurrencyTranslation\CurrencyTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\CurrencyDefinition' shared service.
     *
     * @return \Shopware\Core\System\Currency\CurrencyDefinition
     */
    protected function getCurrencyDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Currency\\CurrencyDefinition'] = $instance = new \Shopware\Core\System\Currency\CurrencyDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\CurrencyFormatter' shared service.
     *
     * @return \Shopware\Core\System\Currency\CurrencyFormatter
     */
    protected function getCurrencyFormatterService()
    {
        return $this->services['Shopware\\Core\\System\\Currency\\CurrencyFormatter'] = new \Shopware\Core\System\Currency\CurrencyFormatter(($this->privates['Shopware\\Core\\System\\Locale\\LanguageLocaleCodeProvider'] ?? $this->getLanguageLocaleCodeProviderService()));
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\SalesChannel\CachedCurrencyRoute' shared service.
     *
     * @return \Shopware\Core\System\Currency\SalesChannel\CachedCurrencyRoute
     */
    protected function getCachedCurrencyRouteService()
    {
        $a = ($this->services['sales_channel.currency.repository'] ?? $this->getSalesChannel_Currency_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\Currency\\SalesChannel\\CachedCurrencyRoute'])) {
            return $this->services['Shopware\\Core\\System\\Currency\\SalesChannel\\CachedCurrencyRoute'];
        }
        $b = ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService());

        if (isset($this->services['Shopware\\Core\\System\\Currency\\SalesChannel\\CachedCurrencyRoute'])) {
            return $this->services['Shopware\\Core\\System\\Currency\\SalesChannel\\CachedCurrencyRoute'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\System\\Currency\\SalesChannel\\CachedCurrencyRoute'])) {
            return $this->services['Shopware\\Core\\System\\Currency\\SalesChannel\\CachedCurrencyRoute'];
        }

        return $this->services['Shopware\\Core\\System\\Currency\\SalesChannel\\CachedCurrencyRoute'] = new \Shopware\Core\System\Currency\SalesChannel\CachedCurrencyRoute(new \Shopware\Core\System\Currency\SalesChannel\CurrencyRoute($a), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), $b, $c, []);
    }

    /*
     * Gets the public 'Shopware\Core\System\Currency\SalesChannel\SalesChannelCurrencyDefinition' shared service.
     *
     * @return \Shopware\Core\System\Currency\SalesChannel\SalesChannelCurrencyDefinition
     */
    protected function getSalesChannelCurrencyDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition'] = $instance = new \Shopware\Core\System\Currency\SalesChannel\SalesChannelCurrencyDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomEntity\Api\CustomEntityApiController' shared service.
     *
     * @return \Shopware\Core\System\CustomEntity\Api\CustomEntityApiController
     */
    protected function getCustomEntityApiControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Api/Controller/ApiController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomEntity/Api/CustomEntityApiController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityProtection/EntityProtectionValidator.php';

        $this->services['Shopware\\Core\\System\\CustomEntity\\Api\\CustomEntityApiController'] = $instance = new \Shopware\Core\System\CustomEntity\Api\CustomEntityApiController(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()), ($this->services['.container.private.serializer'] ?? $this->get_Container_Private_SerializerService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? $this->getRequestCriteriaBuilderService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\CompositeEntitySearcher'] ?? $this->getCompositeEntitySearcherService()), ($this->privates['Shopware\\Core\\Framework\\Api\\Converter\\ApiVersionConverter'] ?? $this->getApiVersionConverterService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\EntityProtection\\EntityProtectionValidator'] ?? ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\EntityProtection\\EntityProtectionValidator'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityProtection\EntityProtectionValidator())), ($this->services['Shopware\\Core\\Framework\\Api\\Acl\\AclCriteriaValidator'] ?? $this->getAclCriteriaValidatorService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomEntity\CustomEntityDefinition' shared service.
     *
     * @return \Shopware\Core\System\CustomEntity\CustomEntityDefinition
     */
    protected function getCustomEntityDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomEntity/CustomEntityDefinition.php';

        $this->services['Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition'] = $instance = new \Shopware\Core\System\CustomEntity\CustomEntityDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomEntity\CustomEntityRegistrar' shared service.
     *
     * @return \Shopware\Core\System\CustomEntity\CustomEntityRegistrar
     */
    protected function getCustomEntityRegistrarService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomEntity/CustomEntityRegistrar.php';

        return $this->services['Shopware\\Core\\System\\CustomEntity\\CustomEntityRegistrar'] = new \Shopware\Core\System\CustomEntity\CustomEntityRegistrar($this);
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomEntity\Schema\CustomEntitySchemaUpdater' shared service.
     *
     * @return \Shopware\Core\System\CustomEntity\Schema\CustomEntitySchemaUpdater
     */
    protected function getCustomEntitySchemaUpdaterService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomEntity/Schema/CustomEntitySchemaUpdater.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomEntity/Schema/SchemaUpdater.php';

        return $this->services['Shopware\\Core\\System\\CustomEntity\\Schema\\CustomEntitySchemaUpdater'] = new \Shopware\Core\System\CustomEntity\Schema\CustomEntitySchemaUpdater(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->privates['lock.default.factory'] ?? $this->getLock_Default_FactoryService()), new \Shopware\Core\System\CustomEntity\Schema\SchemaUpdater());
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomField\Aggregate\CustomFieldSetRelation\CustomFieldSetRelationDefinition' shared service.
     *
     * @return \Shopware\Core\System\CustomField\Aggregate\CustomFieldSetRelation\CustomFieldSetRelationDefinition
     */
    protected function getCustomFieldSetRelationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomField/Aggregate/CustomFieldSetRelation/CustomFieldSetRelationDefinition.php';

        $this->services['Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition'] = $instance = new \Shopware\Core\System\CustomField\Aggregate\CustomFieldSetRelation\CustomFieldSetRelationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomField\Aggregate\CustomFieldSet\CustomFieldSetDefinition' shared service.
     *
     * @return \Shopware\Core\System\CustomField\Aggregate\CustomFieldSet\CustomFieldSetDefinition
     */
    protected function getCustomFieldSetDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomField/Aggregate/CustomFieldSet/CustomFieldSetDefinition.php';

        $this->services['Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition'] = $instance = new \Shopware\Core\System\CustomField\Aggregate\CustomFieldSet\CustomFieldSetDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomField\Api\CustomFieldSetActionController' shared service.
     *
     * @return \Shopware\Core\System\CustomField\Api\CustomFieldSetActionController
     */
    protected function getCustomFieldSetActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomField/Api/CustomFieldSetActionController.php';

        $this->services['Shopware\\Core\\System\\CustomField\\Api\\CustomFieldSetActionController'] = $instance = new \Shopware\Core\System\CustomField\Api\CustomFieldSetActionController(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\CustomField\CustomFieldDefinition' shared service.
     *
     * @return \Shopware\Core\System\CustomField\CustomFieldDefinition
     */
    protected function getCustomFieldDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/CustomField/CustomFieldDefinition.php';

        $this->services['Shopware\\Core\\System\\CustomField\\CustomFieldDefinition'] = $instance = new \Shopware\Core\System\CustomField\CustomFieldDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\DeliveryTime\Aggregate\DeliveryTimeTranslation\DeliveryTimeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\DeliveryTime\Aggregate\DeliveryTimeTranslation\DeliveryTimeTranslationDefinition
     */
    protected function getDeliveryTimeTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/DeliveryTime/Aggregate/DeliveryTimeTranslation/DeliveryTimeTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition'] = $instance = new \Shopware\Core\System\DeliveryTime\Aggregate\DeliveryTimeTranslation\DeliveryTimeTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\DeliveryTime\DeliveryTimeDefinition' shared service.
     *
     * @return \Shopware\Core\System\DeliveryTime\DeliveryTimeDefinition
     */
    protected function getDeliveryTimeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/DeliveryTime/DeliveryTimeDefinition.php';

        $this->services['Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition'] = $instance = new \Shopware\Core\System\DeliveryTime\DeliveryTimeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Integration\Aggregate\IntegrationRole\IntegrationRoleDefinition' shared service.
     *
     * @return \Shopware\Core\System\Integration\Aggregate\IntegrationRole\IntegrationRoleDefinition
     */
    protected function getIntegrationRoleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Integration/Aggregate/IntegrationRole/IntegrationRoleDefinition.php';

        $this->services['Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition'] = $instance = new \Shopware\Core\System\Integration\Aggregate\IntegrationRole\IntegrationRoleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Integration\IntegrationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Integration\IntegrationDefinition
     */
    protected function getIntegrationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Integration/IntegrationDefinition.php';

        $this->services['Shopware\\Core\\System\\Integration\\IntegrationDefinition'] = $instance = new \Shopware\Core\System\Integration\IntegrationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Language\LanguageDefinition' shared service.
     *
     * @return \Shopware\Core\System\Language\LanguageDefinition
     */
    protected function getLanguageDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Language\\LanguageDefinition'] = $instance = new \Shopware\Core\System\Language\LanguageDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Language\SalesChannel\CachedLanguageRoute' shared service.
     *
     * @return \Shopware\Core\System\Language\SalesChannel\CachedLanguageRoute
     */
    protected function getCachedLanguageRouteService()
    {
        $a = ($this->services['sales_channel.language.repository'] ?? $this->getSalesChannel_Language_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\Language\\SalesChannel\\CachedLanguageRoute'])) {
            return $this->services['Shopware\\Core\\System\\Language\\SalesChannel\\CachedLanguageRoute'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\System\\Language\\SalesChannel\\CachedLanguageRoute'])) {
            return $this->services['Shopware\\Core\\System\\Language\\SalesChannel\\CachedLanguageRoute'];
        }

        return $this->services['Shopware\\Core\\System\\Language\\SalesChannel\\CachedLanguageRoute'] = new \Shopware\Core\System\Language\SalesChannel\CachedLanguageRoute(new \Shopware\Core\System\Language\SalesChannel\LanguageRoute($a), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), $b, []);
    }

    /*
     * Gets the public 'Shopware\Core\System\Language\SalesChannel\SalesChannelLanguageDefinition' shared service.
     *
     * @return \Shopware\Core\System\Language\SalesChannel\SalesChannelLanguageDefinition
     */
    protected function getSalesChannelLanguageDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition'] = $instance = new \Shopware\Core\System\Language\SalesChannel\SalesChannelLanguageDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Locale\Aggregate\LocaleTranslation\LocaleTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Locale\Aggregate\LocaleTranslation\LocaleTranslationDefinition
     */
    protected function getLocaleTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Locale/Aggregate/LocaleTranslation/LocaleTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition'] = $instance = new \Shopware\Core\System\Locale\Aggregate\LocaleTranslation\LocaleTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Locale\LocaleDefinition' shared service.
     *
     * @return \Shopware\Core\System\Locale\LocaleDefinition
     */
    protected function getLocaleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Locale/LocaleDefinition.php';

        $this->services['Shopware\\Core\\System\\Locale\\LocaleDefinition'] = $instance = new \Shopware\Core\System\Locale\LocaleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeSalesChannel\NumberRangeSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeSalesChannel\NumberRangeSalesChannelDefinition
     */
    protected function getNumberRangeSalesChannelDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/Aggregate/NumberRangeSalesChannel/NumberRangeSalesChannelDefinition.php';

        $this->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeSalesChannel\NumberRangeSalesChannelDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeState\NumberRangeStateDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeState\NumberRangeStateDefinition
     */
    protected function getNumberRangeStateDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/Aggregate/NumberRangeState/NumberRangeStateDefinition.php';

        $this->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeState\NumberRangeStateDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeTranslation\NumberRangeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeTranslation\NumberRangeTranslationDefinition
     */
    protected function getNumberRangeTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/Aggregate/NumberRangeTranslation/NumberRangeTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeTranslation\NumberRangeTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeTypeTranslation\NumberRangeTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeTypeTranslation\NumberRangeTypeTranslationDefinition
     */
    protected function getNumberRangeTypeTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/Aggregate/NumberRangeTypeTranslation/NumberRangeTypeTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeTypeTranslation\NumberRangeTypeTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Aggregate\NumberRangeType\NumberRangeTypeDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Aggregate\NumberRangeType\NumberRangeTypeDefinition
     */
    protected function getNumberRangeTypeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/Aggregate/NumberRangeType/NumberRangeTypeDefinition.php';

        $this->services['Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition'] = $instance = new \Shopware\Core\System\NumberRange\Aggregate\NumberRangeType\NumberRangeTypeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\Api\NumberRangeController' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\Api\NumberRangeController
     */
    protected function getNumberRangeControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/Api/NumberRangeController.php';

        $this->services['Shopware\\Core\\System\\NumberRange\\Api\\NumberRangeController'] = $instance = new \Shopware\Core\System\NumberRange\Api\NumberRangeController(($this->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'] ?? $this->getNumberRangeValueGeneratorInterfaceService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\NumberRangeDefinition' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\NumberRangeDefinition
     */
    protected function getNumberRangeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/NumberRange/NumberRangeDefinition.php';

        $this->services['Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition'] = $instance = new \Shopware\Core\System\NumberRange\NumberRangeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\NumberRange\ValueGenerator\NumberRangeValueGeneratorInterface' shared service.
     *
     * @return \Shopware\Core\System\NumberRange\ValueGenerator\NumberRangeValueGenerator
     */
    protected function getNumberRangeValueGeneratorInterfaceService()
    {
        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'])) {
            return $this->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'];
        }

        return $this->services['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\NumberRangeValueGeneratorInterface'] = new \Shopware\Core\System\NumberRange\ValueGenerator\NumberRangeValueGenerator(new \Shopware\Core\System\NumberRange\ValueGenerator\Pattern\ValueGeneratorPatternRegistry(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\Pattern\\ValueGeneratorPatternIncrement'] ?? $this->getValueGeneratorPatternIncrementService());
            yield 1 => ($this->privates['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\Pattern\\ValueGeneratorPatternDate'] ?? ($this->privates['Shopware\\Core\\System\\NumberRange\\ValueGenerator\\Pattern\\ValueGeneratorPatternDate'] = new \Shopware\Core\System\NumberRange\ValueGenerator\Pattern\ValueGeneratorPatternDate()));
        }, 2)), $a, ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelAnalytics\SalesChannelAnalyticsDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelAnalytics\SalesChannelAnalyticsDefinition
     */
    protected function getSalesChannelAnalyticsDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelAnalytics/SalesChannelAnalyticsDefinition.php';

        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelAnalytics\SalesChannelAnalyticsDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCountry\SalesChannelCountryDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCountry\SalesChannelCountryDefinition
     */
    protected function getSalesChannelCountryDefinition2Service()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelCountry/SalesChannelCountryDefinition.php';

        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCountry\SalesChannelCountryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCurrency\SalesChannelCurrencyDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCurrency\SalesChannelCurrencyDefinition
     */
    protected function getSalesChannelCurrencyDefinition2Service()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelCurrency/SalesChannelCurrencyDefinition.php';

        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelCurrency\SalesChannelCurrencyDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelDomain\SalesChannelDomainDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelDomain\SalesChannelDomainDefinition
     */
    protected function getSalesChannelDomainDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelDomain\SalesChannelDomainDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelLanguage\SalesChannelLanguageDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelLanguage\SalesChannelLanguageDefinition
     */
    protected function getSalesChannelLanguageDefinition2Service()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelLanguage/SalesChannelLanguageDefinition.php';

        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelLanguage\SalesChannelLanguageDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelPaymentMethod\SalesChannelPaymentMethodDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelPaymentMethod\SalesChannelPaymentMethodDefinition
     */
    protected function getSalesChannelPaymentMethodDefinition2Service()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelPaymentMethod/SalesChannelPaymentMethodDefinition.php';

        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelPaymentMethod\SalesChannelPaymentMethodDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelShippingMethod\SalesChannelShippingMethodDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelShippingMethod\SalesChannelShippingMethodDefinition
     */
    protected function getSalesChannelShippingMethodDefinition2Service()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelShippingMethod/SalesChannelShippingMethodDefinition.php';

        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelShippingMethod\SalesChannelShippingMethodDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTranslation\SalesChannelTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTranslation\SalesChannelTranslationDefinition
     */
    protected function getSalesChannelTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelTranslation/SalesChannelTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTranslation\SalesChannelTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTypeTranslation\SalesChannelTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTypeTranslation\SalesChannelTypeTranslationDefinition
     */
    protected function getSalesChannelTypeTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelTypeTranslation/SalesChannelTypeTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelTypeTranslation\SalesChannelTypeTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Aggregate\SalesChannelType\SalesChannelTypeDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelType\SalesChannelTypeDefinition
     */
    protected function getSalesChannelTypeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/Aggregate/SalesChannelType/SalesChannelTypeDefinition.php';

        $this->services['Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\Aggregate\SalesChannelType\SalesChannelTypeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Context\SalesChannelContextFactory' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Context\CachedSalesChannelContextFactory
     */
    protected function getSalesChannelContextFactoryService()
    {
        $a = ($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $b = ($this->services['customer_group.repository'] ?? $this->getCustomerGroup_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $c = ($this->services['customer_address.repository'] ?? $this->getCustomerAddress_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $d = ($this->services['payment_method.repository'] ?? $this->getPaymentMethod_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $e = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $f = ($this->services['currency_country_rounding.repository'] ?? $this->getCurrencyCountryRounding_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $g = ($this->services['sales_channel.repository'] ?? $this->getSalesChannel_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $h = ($this->services['currency.repository'] ?? $this->getCurrency_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $i = ($this->services['country.repository'] ?? $this->getCountry_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $j = ($this->services['tax.repository'] ?? $this->getTax_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $k = ($this->services['shipping_method.repository'] ?? $this->getShippingMethod_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $l = ($this->services['country_state.repository'] ?? $this->getCountryState_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $m = ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService());

        if (isset($this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'])) {
            return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'];
        }
        $n = ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService());

        return $this->services['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextFactory'] = new \Shopware\Core\System\SalesChannel\Context\CachedSalesChannelContextFactory(new \Shopware\Core\System\SalesChannel\Context\SalesChannelContextFactory($a, $b, $c, $d, ($this->privates['Shopware\\Core\\Checkout\\Cart\\Tax\\TaxDetector'] ?? ($this->privates['Shopware\\Core\\Checkout\\Cart\\Tax\\TaxDetector'] = new \Shopware\Core\Checkout\Cart\Tax\TaxDetector())), new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\EntireCountryRuleTypeFilter'] ?? ($this->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\EntireCountryRuleTypeFilter'] = new \Shopware\Core\System\Tax\TaxRuleType\EntireCountryRuleTypeFilter()));
            yield 1 => ($this->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\IndividualStatesRuleTypeFilter'] ?? ($this->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\IndividualStatesRuleTypeFilter'] = new \Shopware\Core\System\Tax\TaxRuleType\IndividualStatesRuleTypeFilter()));
            yield 2 => ($this->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\ZipCodeRangeRuleTypeFilter'] ?? ($this->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\ZipCodeRangeRuleTypeFilter'] = new \Shopware\Core\System\Tax\TaxRuleType\ZipCodeRangeRuleTypeFilter()));
            yield 3 => ($this->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\ZipCodeRuleTypeFilter'] ?? ($this->privates['Shopware\\Core\\System\\Tax\\TaxRuleType\\ZipCodeRuleTypeFilter'] = new \Shopware\Core\System\Tax\TaxRuleType\ZipCodeRuleTypeFilter()));
        }, 4), $e, $f, new \Shopware\Core\System\SalesChannel\Context\CachedBaseContextFactory(new \Shopware\Core\System\SalesChannel\Context\BaseContextFactory($g, $h, $b, $i, $j, $d, $k, ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), $l, $f), $n, $m)), $n, $m);
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\Entity\SalesChannelDefinitionInstanceRegistry' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\Entity\SalesChannelDefinitionInstanceRegistry
     */
    protected function getSalesChannelDefinitionInstanceRegistryService()
    {
        return $this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] = new \Shopware\Core\System\SalesChannel\Entity\SalesChannelDefinitionInstanceRegistry('sales_channel_definition.', $this, ['log_entry' => 'Shopware\\Core\\Framework\\Log\\LogEntryDefinition', 'acl_role' => 'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition', 'acl_user_role' => 'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition', 'user_role_acl' => 'Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition', 'app' => 'Shopware\\Core\\Framework\\App\\AppDefinition', 'app_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition', 'app_action_button' => 'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition', 'app_action_button_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition', 'app_template' => 'Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition', 'app_payment_method' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition', 'app_script_condition' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition', 'app_script_condition_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition', 'app_cms_block' => 'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition', 'app_cms_block_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition', 'app_flow_action' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition', 'app_flow_action_translation' => 'Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition', 'custom_field' => 'Shopware\\Core\\System\\CustomField\\CustomFieldDefinition', 'custom_field_set' => 'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSet\\CustomFieldSetDefinition', 'custom_field_set_relation' => 'Shopware\\Core\\System\\CustomField\\Aggregate\\CustomFieldSetRelation\\CustomFieldSetRelationDefinition', 'version' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\VersionDefinition', 'version_commit' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommit\\VersionCommitDefinition', 'version_commit_data' => 'Shopware\\Core\\Framework\\DataAbstractionLayer\\Version\\Aggregate\\VersionCommitData\\VersionCommitDataDefinition', 'event_action' => 'Shopware\\Core\\Framework\\Event\\EventAction\\EventActionDefinition', 'event_action_rule' => 'Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionRule\\EventActionRuleDefinition', 'event_action_sales_channel' => 'Shopware\\Core\\Framework\\Event\\EventAction\\Aggregate\\EventActionSalesChannel\\EventActionSalesChannelDefinition', 'dead_message' => 'Shopware\\Core\\Framework\\MessageQueue\\DeadMessage\\DeadMessageDefinition', 'message_queue_stats' => 'Shopware\\Core\\Framework\\MessageQueue\\MessageQueueStatsDefinition', 'plugin' => 'Shopware\\Core\\Framework\\Plugin\\PluginDefinition', 'plugin_translation' => 'Shopware\\Core\\Framework\\Plugin\\Aggregate\\PluginTranslation\\PluginTranslationDefinition', 'scheduled_task' => 'Shopware\\Core\\Framework\\MessageQueue\\ScheduledTask\\ScheduledTaskDefinition', 'script' => 'Shopware\\Core\\Framework\\Script\\ScriptDefinition', 'language' => 'Shopware\\Core\\System\\Language\\SalesChannel\\SalesChannelLanguageDefinition', 'seo_url' => 'Shopware\\Core\\Content\\Seo\\SeoUrl\\SalesChannel\\SalesChannelSeoUrlDefinition', 'seo_url_template' => 'Shopware\\Core\\Content\\Seo\\SeoUrlTemplate\\SeoUrlTemplateDefinition', 'main_category' => 'Shopware\\Core\\Content\\Seo\\MainCategory\\SalesChannel\\SalesChannelMainCategoryDefinition', 'webhook' => 'Shopware\\Core\\Framework\\Webhook\\WebhookDefinition', 'webhook_event_log' => 'Shopware\\Core\\Framework\\Webhook\\EventLog\\WebhookEventLogDefinition', 'sales_channel' => 'Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition', 'sales_channel_translation' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTranslation\\SalesChannelTranslationDefinition', 'sales_channel_country' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCountry\\SalesChannelCountryDefinition', 'sales_channel_currency' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelCurrency\\SalesChannelCurrencyDefinition', 'sales_channel_domain' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelDomain\\SalesChannelDomainDefinition', 'sales_channel_language' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelLanguage\\SalesChannelLanguageDefinition', 'sales_channel_payment_method' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelPaymentMethod\\SalesChannelPaymentMethodDefinition', 'sales_channel_shipping_method' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelShippingMethod\\SalesChannelShippingMethodDefinition', 'sales_channel_type' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelType\\SalesChannelTypeDefinition', 'sales_channel_type_translation' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelTypeTranslation\\SalesChannelTypeTranslationDefinition', 'sales_channel_analytics' => 'Shopware\\Core\\System\\SalesChannel\\Aggregate\\SalesChannelAnalytics\\SalesChannelAnalyticsDefinition', 'country' => 'Shopware\\Core\\System\\Country\\SalesChannel\\SalesChannelCountryDefinition', 'country_state' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryState\\SalesChannel\\SalesChannelCountryStateDefinition', 'country_state_translation' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryStateTranslation\\CountryStateTranslationDefinition', 'country_translation' => 'Shopware\\Core\\System\\Country\\Aggregate\\CountryTranslation\\CountryTranslationDefinition', 'currency' => 'Shopware\\Core\\System\\Currency\\SalesChannel\\SalesChannelCurrencyDefinition', 'currency_country_rounding' => 'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyCountryRounding\\CurrencyCountryRoundingDefinition', 'currency_translation' => 'Shopware\\Core\\System\\Currency\\Aggregate\\CurrencyTranslation\\CurrencyTranslationDefinition', 'custom_entity' => 'Shopware\\Core\\System\\CustomEntity\\CustomEntityDefinition', 'locale' => 'Shopware\\Core\\System\\Locale\\LocaleDefinition', 'locale_translation' => 'Shopware\\Core\\System\\Locale\\Aggregate\\LocaleTranslation\\LocaleTranslationDefinition', 'snippet_set' => 'Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition', 'snippet' => 'Shopware\\Core\\System\\Snippet\\SnippetDefinition', 'salutation' => 'Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition', 'salutation_translation' => 'Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition', 'tax' => 'Shopware\\Core\\System\\Tax\\TaxDefinition', 'tax_rule' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition', 'tax_rule_type' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition', 'tax_rule_type_translation' => 'Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition', 'unit' => 'Shopware\\Core\\System\\Unit\\UnitDefinition', 'unit_translation' => 'Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition', 'user' => 'Shopware\\Core\\System\\User\\UserDefinition', 'user_config' => 'Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition', 'user_access_key' => 'Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition', 'user_recovery' => 'Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition', 'integration' => 'Shopware\\Core\\System\\Integration\\IntegrationDefinition', 'integration_role' => 'Shopware\\Core\\System\\Integration\\Aggregate\\IntegrationRole\\IntegrationRoleDefinition', 'state_machine' => 'Shopware\\Core\\System\\StateMachine\\StateMachineDefinition', 'state_machine_translation' => 'Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition', 'state_machine_state' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition', 'state_machine_state_translation' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition', 'state_machine_transition' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition', 'state_machine_history' => 'Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition', 'system_config' => 'Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition', 'number_range' => 'Shopware\\Core\\System\\NumberRange\\NumberRangeDefinition', 'number_range_sales_channel' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeSalesChannel\\NumberRangeSalesChannelDefinition', 'number_range_state' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeState\\NumberRangeStateDefinition', 'number_range_type' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeType\\NumberRangeTypeDefinition', 'number_range_type_translation' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTypeTranslation\\NumberRangeTypeTranslationDefinition', 'number_range_translation' => 'Shopware\\Core\\System\\NumberRange\\Aggregate\\NumberRangeTranslation\\NumberRangeTranslationDefinition', 'tag' => 'Shopware\\Core\\System\\Tag\\TagDefinition', 'category' => 'Shopware\\Core\\Content\\Category\\SalesChannel\\SalesChannelCategoryDefinition', 'category_translation' => 'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTranslation\\CategoryTranslationDefinition', 'category_tag' => 'Shopware\\Core\\Content\\Category\\Aggregate\\CategoryTag\\CategoryTagDefinition', 'media' => 'Shopware\\Core\\Content\\Media\\MediaDefinition', 'media_default_folder' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaDefaultFolder\\MediaDefaultFolderDefinition', 'media_thumbnail' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnail\\MediaThumbnailDefinition', 'media_translation' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTranslation\\MediaTranslationDefinition', 'media_folder' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolder\\MediaFolderDefinition', 'media_thumbnail_size' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaThumbnailSize\\MediaThumbnailSizeDefinition', 'media_folder_configuration' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfiguration\\MediaFolderConfigurationDefinition', 'media_folder_configuration_media_thumbnail_size' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaFolderConfigurationMediaThumbnailSize\\MediaFolderConfigurationMediaThumbnailSizeDefinition', 'media_tag' => 'Shopware\\Core\\Content\\Media\\Aggregate\\MediaTag\\MediaTagDefinition', 'product' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\SalesChannelProductDefinition', 'product_stream_mapping' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductStreamMapping\\ProductStreamMappingDefinition', 'product_category' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategory\\ProductCategoryDefinition', 'product_custom_field_set' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCustomFieldSet\\ProductCustomFieldSetDefinition', 'product_tag' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTag\\ProductTagDefinition', 'product_configurator_setting' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductConfiguratorSetting\\ProductConfiguratorSettingDefinition', 'product_price' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductPrice\\ProductPriceDefinition', 'product_property' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductProperty\\ProductPropertyDefinition', 'product_search_keyword' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchKeyword\\ProductSearchKeywordDefinition', 'product_keyword_dictionary' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductKeywordDictionary\\ProductKeywordDictionaryDefinition', 'product_review' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductReview\\ProductReviewDefinition', 'product_manufacturer' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturer\\ProductManufacturerDefinition', 'product_manufacturer_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductManufacturerTranslation\\ProductManufacturerTranslationDefinition', 'product_media' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductMedia\\ProductMediaDefinition', 'product_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductTranslation\\ProductTranslationDefinition', 'product_option' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductOption\\ProductOptionDefinition', 'product_category_tree' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCategoryTree\\ProductCategoryTreeDefinition', 'product_cross_selling' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSelling\\ProductCrossSellingDefinition', 'product_cross_selling_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingTranslation\\ProductCrossSellingTranslationDefinition', 'product_cross_selling_assigned_products' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductCrossSellingAssignedProducts\\ProductCrossSellingAssignedProductsDefinition', 'product_feature_set' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSet\\ProductFeatureSetDefinition', 'product_feature_set_translation' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductFeatureSetTranslation\\ProductFeatureSetTranslationDefinition', 'product_sorting' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingDefinition', 'product_sorting_translation' => 'Shopware\\Core\\Content\\Product\\SalesChannel\\Sorting\\ProductSortingTranslationDefinition', 'product_search_config' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfig\\ProductSearchConfigDefinition', 'product_search_config_field' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductSearchConfigField\\ProductSearchConfigFieldDefinition', 'product_visibility' => 'Shopware\\Core\\Content\\Product\\Aggregate\\ProductVisibility\\ProductVisibilityDefinition', 'delivery_time' => 'Shopware\\Core\\System\\DeliveryTime\\DeliveryTimeDefinition', 'newsletter_recipient' => 'Shopware\\Core\\Content\\Newsletter\\SalesChannel\\SalesChannelNewsletterRecipientDefinition', 'newsletter_recipient_tag' => 'Shopware\\Core\\Content\\Newsletter\\Aggregate\\NewsletterRecipientTag\\NewsletterRecipientTagDefinition', 'rule' => 'Shopware\\Core\\Content\\Rule\\RuleDefinition', 'rule_condition' => 'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleCondition\\RuleConditionDefinition', 'rule_tag' => 'Shopware\\Core\\Content\\Rule\\Aggregate\\RuleTag\\RuleTagDefinition', 'product_stream' => 'Shopware\\Core\\Content\\ProductStream\\ProductStreamDefinition', 'product_stream_translation' => 'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamTranslation\\ProductStreamTranslationDefinition', 'product_stream_filter' => 'Shopware\\Core\\Content\\ProductStream\\Aggregate\\ProductStreamFilter\\ProductStreamFilterDefinition', 'product_export' => 'Shopware\\Core\\Content\\ProductExport\\ProductExportDefinition', 'property_group' => 'Shopware\\Core\\Content\\Property\\PropertyGroupDefinition', 'property_group_option' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOption\\PropertyGroupOptionDefinition', 'property_group_option_translation' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupOptionTranslation\\PropertyGroupOptionTranslationDefinition', 'property_group_translation' => 'Shopware\\Core\\Content\\Property\\Aggregate\\PropertyGroupTranslation\\PropertyGroupTranslationDefinition', 'cms_page' => 'Shopware\\Core\\Content\\Cms\\CmsPageDefinition', 'cms_page_translation' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsPageTranslation\\CmsPageTranslationDefinition', 'cms_section' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSection\\CmsSectionDefinition', 'cms_block' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsBlock\\CmsBlockDefinition', 'cms_slot' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlot\\CmsSlotDefinition', 'cms_slot_translation' => 'Shopware\\Core\\Content\\Cms\\Aggregate\\CmsSlotTranslation\\CmsSlotTranslationDefinition', 'mail_template' => 'Shopware\\Core\\Content\\MailTemplate\\MailTemplateDefinition', 'mail_template_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTranslation\\MailTemplateTranslationDefinition', 'mail_template_type' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateType\\MailTemplateTypeDefinition', 'mail_template_type_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateTypeTranslation\\MailTemplateTypeTranslationDefinition', 'mail_template_media' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailTemplateMedia\\MailTemplateMediaDefinition', 'mail_header_footer' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooter\\MailHeaderFooterDefinition', 'mail_header_footer_translation' => 'Shopware\\Core\\Content\\MailTemplate\\Aggregate\\MailHeaderFooterTranslation\\MailHeaderFooterTranslationDefinition', 'delivery_time_translation' => 'Shopware\\Core\\System\\DeliveryTime\\Aggregate\\DeliveryTimeTranslation\\DeliveryTimeTranslationDefinition', 'import_export_profile' => 'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileDefinition', 'import_export_log' => 'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportLog\\ImportExportLogDefinition', 'import_export_file' => 'Shopware\\Core\\Content\\ImportExport\\Aggregate\\ImportExportFile\\ImportExportFileDefinition', 'import_export_profile_translation' => 'Shopware\\Core\\Content\\ImportExport\\ImportExportProfileTranslationDefinition', 'landing_page' => 'Shopware\\Core\\Content\\LandingPage\\SalesChannel\\SalesChannelLandingPageDefinition', 'landing_page_translation' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTranslation\\LandingPageTranslationDefinition', 'landing_page_tag' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageTag\\LandingPageTagDefinition', 'landing_page_sales_channel' => 'Shopware\\Core\\Content\\LandingPage\\Aggregate\\LandingPageSalesChannel\\LandingPageSalesChannelDefinition', 'flow' => 'Shopware\\Core\\Content\\Flow\\FlowDefinition', 'flow_sequence' => 'Shopware\\Core\\Content\\Flow\\Aggregate\\FlowSequence\\FlowSequenceDefinition', 'customer' => 'Shopware\\Core\\Checkout\\Customer\\CustomerDefinition', 'customer_group_translation' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupTranslation\\CustomerGroupTranslationDefinition', 'customer_address' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerAddress\\CustomerAddressDefinition', 'customer_recovery' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerRecovery\\CustomerRecoveryDefinition', 'customer_group' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroup\\CustomerGroupDefinition', 'customer_group_registration_sales_channels' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerGroupRegistrationSalesChannel\\CustomerGroupRegistrationSalesChannelDefinition', 'customer_tag' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerTag\\CustomerTagDefinition', 'customer_wishlist' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlist\\CustomerWishlistDefinition', 'customer_wishlist_product' => 'Shopware\\Core\\Checkout\\Customer\\Aggregate\\CustomerWishlistProduct\\CustomerWishlistProductDefinition', 'document' => 'Shopware\\Core\\Checkout\\Document\\DocumentDefinition', 'document_type' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentType\\DocumentTypeDefinition', 'document_type_translation' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentTypeTranslation\\DocumentTypeTranslationDefinition', 'document_base_config' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfig\\DocumentBaseConfigDefinition', 'document_base_config_sales_channel' => 'Shopware\\Core\\Checkout\\Document\\Aggregate\\DocumentBaseConfigSalesChannel\\DocumentBaseConfigSalesChannelDefinition', 'order' => 'Shopware\\Core\\Checkout\\Order\\OrderDefinition', 'order_address' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderAddress\\OrderAddressDefinition', 'order_customer' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderCustomer\\OrderCustomerDefinition', 'order_delivery' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDelivery\\OrderDeliveryDefinition', 'order_delivery_position' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderDeliveryPosition\\OrderDeliveryPositionDefinition', 'order_line_item' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderLineItem\\OrderLineItemDefinition', 'order_tag' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTag\\OrderTagDefinition', 'order_transaction' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransaction\\OrderTransactionDefinition', 'order_transaction_capture' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCapture\\OrderTransactionCaptureDefinition', 'order_transaction_capture_refund' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefund\\OrderTransactionCaptureRefundDefinition', 'order_transaction_capture_refund_position' => 'Shopware\\Core\\Checkout\\Order\\Aggregate\\OrderTransactionCaptureRefundPosition\\OrderTransactionCaptureRefundPositionDefinition', 'payment_method' => 'Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SalesChannelPaymentMethodDefinition', 'payment_method_translation' => 'Shopware\\Core\\Checkout\\Payment\\Aggregate\\PaymentMethodTranslation\\PaymentMethodTranslationDefinition', 'promotion' => 'Shopware\\Core\\Checkout\\Promotion\\PromotionDefinition', 'promotion_sales_channel' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSalesChannel\\PromotionSalesChannelDefinition', 'promotion_individual_code' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionIndividualCode\\PromotionIndividualCodeDefinition', 'promotion_discount' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscount\\PromotionDiscountDefinition', 'promotion_discount_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountRule\\PromotionDiscountRuleDefinition', 'promotion_setgroup' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroup\\PromotionSetGroupDefinition', 'promotion_setgroup_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionSetGroupRule\\PromotionSetGroupRuleDefinition', 'promotion_order_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionOrderRule\\PromotionOrderRuleDefinition', 'promotion_persona_customer' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaCustomer\\PromotionPersonaCustomerDefinition', 'promotion_persona_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionPersonaRule\\PromotionPersonaRuleDefinition', 'promotion_cart_rule' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionCartRule\\PromotionCartRuleDefinition', 'promotion_translation' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionTranslation\\PromotionTranslationDefinition', 'promotion_discount_prices' => 'Shopware\\Core\\Checkout\\Promotion\\Aggregate\\PromotionDiscountPrice\\PromotionDiscountPriceDefinition', 'shipping_method' => 'Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SalesChannelShippingMethodDefinition', 'shipping_method_tag' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTag\\ShippingMethodTagDefinition', 'shipping_method_price' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodPrice\\ShippingMethodPriceDefinition', 'shipping_method_translation' => 'Shopware\\Core\\Checkout\\Shipping\\Aggregate\\ShippingMethodTranslation\\ShippingMethodTranslationDefinition', 'app_administration_snippet' => 'Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition', 'notification' => 'Shopware\\Administration\\Notification\\NotificationDefinition', 'theme' => 'Shopware\\Storefront\\Theme\\ThemeDefinition', 'theme_translation' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition', 'theme_sales_channel' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition', 'theme_media' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition', 'theme_child' => 'Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition'], ['language' => 'sales_channel.language.repository', 'seo_url' => 'sales_channel.seo_url.repository', 'main_category' => 'sales_channel.main_category.repository', 'country' => 'sales_channel.country.repository', 'country_state' => 'sales_channel.country_state.repository', 'currency' => 'sales_channel.currency.repository', 'salutation' => 'sales_channel.salutation.repository', 'category' => 'sales_channel.category.repository', 'product' => 'sales_channel.product.repository', 'newsletter_recipient' => 'sales_channel.newsletter_recipient.repository', 'landing_page' => 'sales_channel.landing_page.repository', 'payment_method' => 'sales_channel.payment_method.repository', 'shipping_method' => 'sales_channel.shipping_method.repository']);
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\SalesChannelDefinition' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\SalesChannelDefinition
     */
    protected function getSalesChannelDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\SalesChannel\\SalesChannelDefinition'] = $instance = new \Shopware\Core\System\SalesChannel\SalesChannelDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\SalesChannel\ContextSwitchRoute' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\SalesChannel\ContextSwitchRoute
     */
    protected function getContextSwitchRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/SalesChannel/AbstractContextSwitchRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/SalesChannel/ContextSwitchRoute.php';

        return $this->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextSwitchRoute'] = new \Shopware\Core\System\SalesChannel\SalesChannel\ContextSwitchRoute(($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextPersister'] ?? $this->getSalesChannelContextPersisterService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the public 'Shopware\Core\System\SalesChannel\SalesChannel\StoreApiInfoController' shared service.
     *
     * @return \Shopware\Core\System\SalesChannel\SalesChannel\StoreApiInfoController
     */
    protected function getStoreApiInfoControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SalesChannel/SalesChannel/StoreApiInfoController.php';

        return $this->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\StoreApiInfoController'] = new \Shopware\Core\System\SalesChannel\SalesChannel\StoreApiInfoController(($this->privates['Shopware\\Core\\Framework\\Api\\ApiDefinition\\DefinitionService'] ?? $this->getDefinitionServiceService()), ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()), $this->parameters['shopware.security.csp_templates']);
    }

    /*
     * Gets the public 'Shopware\Core\System\Salutation\Aggregate\SalutationTranslation\SalutationTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Salutation\Aggregate\SalutationTranslation\SalutationTranslationDefinition
     */
    protected function getSalutationTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Salutation/Aggregate/SalutationTranslation/SalutationTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\Salutation\\Aggregate\\SalutationTranslation\\SalutationTranslationDefinition'] = $instance = new \Shopware\Core\System\Salutation\Aggregate\SalutationTranslation\SalutationTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Salutation\SalesChannel\CachedSalutationRoute' shared service.
     *
     * @return \Shopware\Core\System\Salutation\SalesChannel\CachedSalutationRoute
     */
    protected function getCachedSalutationRouteService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Salutation/SalesChannel/AbstractSalutationRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Salutation/SalesChannel/CachedSalutationRoute.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Salutation/SalesChannel/SalutationRoute.php';

        $a = ($this->services['sales_channel.salutation.repository'] ?? $this->getSalesChannel_Salutation_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'])) {
            return $this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'];
        }
        $b = ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService());

        if (isset($this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'])) {
            return $this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'])) {
            return $this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'];
        }

        return $this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'] = new \Shopware\Core\System\Salutation\SalesChannel\CachedSalutationRoute(new \Shopware\Core\System\Salutation\SalesChannel\SalutationRoute($a), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] ?? ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Cache\\EntityCacheKeyGenerator'] = new \Shopware\Core\Framework\DataAbstractionLayer\Cache\EntityCacheKeyGenerator())), $b, $c, []);
    }

    /*
     * Gets the public 'Shopware\Core\System\Salutation\SalesChannel\SalesChannelSalutationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Salutation\SalesChannel\SalesChannelSalutationDefinition
     */
    protected function getSalesChannelSalutationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Salutation/SalutationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Salutation/SalesChannel/SalesChannelSalutationDefinition.php';

        $this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\SalesChannelSalutationDefinition'] = $instance = new \Shopware\Core\System\Salutation\SalesChannel\SalesChannelSalutationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\System\\SalesChannel\\Entity\\SalesChannelDefinitionInstanceRegistry'] ?? $this->getSalesChannelDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Salutation\SalutationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Salutation\SalutationDefinition
     */
    protected function getSalutationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Salutation/SalutationDefinition.php';

        $this->services['Shopware\\Core\\System\\Salutation\\SalutationDefinition'] = $instance = new \Shopware\Core\System\Salutation\SalutationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\Aggregate\SnippetSet\SnippetSetDefinition' shared service.
     *
     * @return \Shopware\Core\System\Snippet\Aggregate\SnippetSet\SnippetSetDefinition
     */
    protected function getSnippetSetDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Snippet\\Aggregate\\SnippetSet\\SnippetSetDefinition'] = $instance = new \Shopware\Core\System\Snippet\Aggregate\SnippetSet\SnippetSetDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\Api\SnippetController' shared service.
     *
     * @return \Shopware\Core\System\Snippet\Api\SnippetController
     */
    protected function getSnippetControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Snippet/Api/SnippetController.php';

        $this->services['Shopware\\Core\\System\\Snippet\\Api\\SnippetController'] = $instance = new \Shopware\Core\System\Snippet\Api\SnippetController(($this->privates['Shopware\\Core\\System\\Snippet\\SnippetService'] ?? $this->getSnippetServiceService()), ($this->services['Shopware\\Core\\System\\Snippet\\Files\\SnippetFileCollection'] ?? $this->getSnippetFileCollectionService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\Files\SnippetFileCollection' shared service.
     *
     * @return \Shopware\Core\System\Snippet\Files\SnippetFileCollection
     */
    protected function getSnippetFileCollectionService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['Shopware\\Core\\System\\Snippet\\Files\\SnippetFileCollection'] = $this->createProxy('SnippetFileCollection_08f09cc', function () {
                return \SnippetFileCollection_08f09cc::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getSnippetFileCollectionService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Snippet/Files/SnippetFileCollectionFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Snippet/Files/SnippetFileLoaderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Snippet/Files/SnippetFileLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Snippet/Files/AppSnippetFileLoader.php';

        return (new \Shopware\Core\System\Snippet\Files\SnippetFileCollectionFactory(new \Shopware\Core\System\Snippet\Files\SnippetFileLoader(($this->services['kernel'] ?? $this->get('kernel', 1)), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), new \Shopware\Core\System\Snippet\Files\AppSnippetFileLoader(\dirname(__DIR__, 4)), ($this->privates['Shopware\\Core\\Framework\\App\\ActiveAppsLoader'] ?? $this->getActiveAppsLoaderService()))))->createSnippetFileCollection();
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\Filter\SnippetFilterFactory' shared service.
     *
     * @return \Shopware\Core\System\Snippet\Filter\SnippetFilterFactory
     */
    protected function getSnippetFilterFactoryService()
    {
        return $this->services['Shopware\\Core\\System\\Snippet\\Filter\\SnippetFilterFactory'] = new \Shopware\Core\System\Snippet\Filter\SnippetFilterFactory(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\AuthorFilter'] ?? ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\AuthorFilter'] = new \Shopware\Core\System\Snippet\Filter\AuthorFilter()));
            yield 1 => ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\AddedFilter'] ?? ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\AddedFilter'] = new \Shopware\Core\System\Snippet\Filter\AddedFilter()));
            yield 2 => ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\EditedFilter'] ?? ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\EditedFilter'] = new \Shopware\Core\System\Snippet\Filter\EditedFilter()));
            yield 3 => ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\EmptySnippetFilter'] ?? ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\EmptySnippetFilter'] = new \Shopware\Core\System\Snippet\Filter\EmptySnippetFilter()));
            yield 4 => ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\NamespaceFilter'] ?? ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\NamespaceFilter'] = new \Shopware\Core\System\Snippet\Filter\NamespaceFilter()));
            yield 5 => ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\TermFilter'] ?? ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\TermFilter'] = new \Shopware\Core\System\Snippet\Filter\TermFilter()));
            yield 6 => ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\TranslationKeyFilter'] ?? ($this->privates['Shopware\\Core\\System\\Snippet\\Filter\\TranslationKeyFilter'] = new \Shopware\Core\System\Snippet\Filter\TranslationKeyFilter()));
        }, 7));
    }

    /*
     * Gets the public 'Shopware\Core\System\Snippet\SnippetDefinition' shared service.
     *
     * @return \Shopware\Core\System\Snippet\SnippetDefinition
     */
    protected function getSnippetDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Snippet\\SnippetDefinition'] = $instance = new \Shopware\Core\System\Snippet\SnippetDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Aggregation\StateMachineHistory\StateMachineHistoryDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Aggregation\StateMachineHistory\StateMachineHistoryDefinition
     */
    protected function getStateMachineHistoryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/StateMachine/Aggregation/StateMachineHistory/StateMachineHistoryDefinition.php';

        $this->services['Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineHistory\\StateMachineHistoryDefinition'] = $instance = new \Shopware\Core\System\StateMachine\Aggregation\StateMachineHistory\StateMachineHistoryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateDefinition
     */
    protected function getStateMachineStateDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/StateMachine/Aggregation/StateMachineState/StateMachineStateDefinition.php';

        $this->services['Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateDefinition'] = $instance = new \Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateTranslationDefinition
     */
    protected function getStateMachineStateTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/StateMachine/Aggregation/StateMachineState/StateMachineStateTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineState\\StateMachineStateTranslationDefinition'] = $instance = new \Shopware\Core\System\StateMachine\Aggregation\StateMachineState\StateMachineStateTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Aggregation\StateMachineTransition\StateMachineTransitionDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Aggregation\StateMachineTransition\StateMachineTransitionDefinition
     */
    protected function getStateMachineTransitionDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/StateMachine/Aggregation/StateMachineTransition/StateMachineTransitionDefinition.php';

        $this->services['Shopware\\Core\\System\\StateMachine\\Aggregation\\StateMachineTransition\\StateMachineTransitionDefinition'] = $instance = new \Shopware\Core\System\StateMachine\Aggregation\StateMachineTransition\StateMachineTransitionDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\Api\StateMachineActionController' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\Api\StateMachineActionController
     */
    protected function getStateMachineActionControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/StateMachine/Api/StateMachineActionController.php';

        $this->services['Shopware\\Core\\System\\StateMachine\\Api\\StateMachineActionController'] = $instance = new \Shopware\Core\System\StateMachine\Api\StateMachineActionController(($this->privates['Shopware\\Core\\System\\StateMachine\\StateMachineRegistry'] ?? $this->getStateMachineRegistryService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\StateMachineDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\StateMachineDefinition
     */
    protected function getStateMachineDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/StateMachine/StateMachineDefinition.php';

        $this->services['Shopware\\Core\\System\\StateMachine\\StateMachineDefinition'] = $instance = new \Shopware\Core\System\StateMachine\StateMachineDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\StateMachine\StateMachineTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\StateMachine\StateMachineTranslationDefinition
     */
    protected function getStateMachineTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/StateMachine/StateMachineTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\StateMachine\\StateMachineTranslationDefinition'] = $instance = new \Shopware\Core\System\StateMachine\StateMachineTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SystemConfig\Api\SystemConfigController' shared service.
     *
     * @return \Shopware\Core\System\SystemConfig\Api\SystemConfigController
     */
    protected function getSystemConfigControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/Api/SystemConfigController.php';

        $this->services['Shopware\\Core\\System\\SystemConfig\\Api\\SystemConfigController'] = $instance = new \Shopware\Core\System\SystemConfig\Api\SystemConfigController(($this->privates['Shopware\\Core\\System\\SystemConfig\\Service\\ConfigurationService'] ?? $this->getConfigurationServiceService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SystemConfig\Facade\SystemConfigFacadeHookFactory' shared service.
     *
     * @return \Shopware\Core\System\SystemConfig\Facade\SystemConfigFacadeHookFactory
     */
    protected function getSystemConfigFacadeHookFactoryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Script/Execution/Awareness/HookServiceFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/SystemConfig/Facade/SystemConfigFacadeHookFactory.php';

        return $this->services['Shopware\\Core\\System\\SystemConfig\\Facade\\SystemConfigFacadeHookFactory'] = new \Shopware\Core\System\SystemConfig\Facade\SystemConfigFacadeHookFactory(($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Core\System\SystemConfig\SystemConfigDefinition' shared service.
     *
     * @return \Shopware\Core\System\SystemConfig\SystemConfigDefinition
     */
    protected function getSystemConfigDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigDefinition'] = $instance = new \Shopware\Core\System\SystemConfig\SystemConfigDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\SystemConfig\SystemConfigService' shared service.
     *
     * @return \Shopware\Core\System\SystemConfig\SystemConfigService
     */
    protected function getSystemConfigServiceService()
    {
        $a = ($this->services['system_config.repository'] ?? $this->getSystemConfig_RepositoryService());

        if (isset($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'])) {
            return $this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'];
        }
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'])) {
            return $this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'];
        }
        $c = ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService());

        return $this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] = new \Shopware\Core\System\SystemConfig\SystemConfigService($c, $a, ($this->privates['Shopware\\Core\\System\\SystemConfig\\Util\\ConfigReader'] ?? ($this->privates['Shopware\\Core\\System\\SystemConfig\\Util\\ConfigReader'] = new \Shopware\Core\System\SystemConfig\Util\ConfigReader())), new \Shopware\Core\System\SystemConfig\MemoizedSystemConfigLoader(new \Shopware\Core\System\SystemConfig\CachedSystemConfigLoader(new \Shopware\Core\System\SystemConfig\SystemConfigLoader($c, ($this->services['kernel'] ?? $this->get('kernel', 1))), ($this->privates['Shopware\\Core\\Framework\\Adapter\\Cache\\CacheDecorator'] ?? $this->getCacheDecoratorService())), ($this->privates['Shopware\\Core\\System\\SystemConfig\\Store\\MemoizedSystemConfigStore'] ?? ($this->privates['Shopware\\Core\\System\\SystemConfig\\Store\\MemoizedSystemConfigStore'] = new \Shopware\Core\System\SystemConfig\Store\MemoizedSystemConfigStore()))), $b);
    }

    /*
     * Gets the public 'Shopware\Core\System\Tag\Service\FilterTagIdsService' shared service.
     *
     * @return \Shopware\Core\System\Tag\Service\FilterTagIdsService
     */
    protected function getFilterTagIdsServiceService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Tag/Service/FilterTagIdsService.php';

        return $this->services['Shopware\\Core\\System\\Tag\\Service\\FilterTagIdsService'] = new \Shopware\Core\System\Tag\Service\FilterTagIdsService(($this->services['Shopware\\Core\\System\\Tag\\TagDefinition'] ?? $this->getTagDefinitionService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Dbal\\CriteriaQueryBuilder'] ?? $this->getCriteriaQueryBuilderService()));
    }

    /*
     * Gets the public 'Shopware\Core\System\Tag\TagDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tag\TagDefinition
     */
    protected function getTagDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Tag/TagDefinition.php';

        $this->services['Shopware\\Core\\System\\Tag\\TagDefinition'] = $instance = new \Shopware\Core\System\Tag\TagDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Tax\Aggregate\TaxRuleTypeTranslation\TaxRuleTypeTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tax\Aggregate\TaxRuleTypeTranslation\TaxRuleTypeTranslationDefinition
     */
    protected function getTaxRuleTypeTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Tax/Aggregate/TaxRuleTypeTranslation/TaxRuleTypeTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleTypeTranslation\\TaxRuleTypeTranslationDefinition'] = $instance = new \Shopware\Core\System\Tax\Aggregate\TaxRuleTypeTranslation\TaxRuleTypeTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Tax\Aggregate\TaxRuleType\TaxRuleTypeDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tax\Aggregate\TaxRuleType\TaxRuleTypeDefinition
     */
    protected function getTaxRuleTypeDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Tax/Aggregate/TaxRuleType/TaxRuleTypeDefinition.php';

        $this->services['Shopware\\Core\\System\\Tax\\Aggregate\\TaxRuleType\\TaxRuleTypeDefinition'] = $instance = new \Shopware\Core\System\Tax\Aggregate\TaxRuleType\TaxRuleTypeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Tax\Aggregate\TaxRule\TaxRuleDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tax\Aggregate\TaxRule\TaxRuleDefinition
     */
    protected function getTaxRuleDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Tax/Aggregate/TaxRule/TaxRuleDefinition.php';

        $this->services['Shopware\\Core\\System\\Tax\\Aggregate\\TaxRule\\TaxRuleDefinition'] = $instance = new \Shopware\Core\System\Tax\Aggregate\TaxRule\TaxRuleDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Tax\TaxDefinition' shared service.
     *
     * @return \Shopware\Core\System\Tax\TaxDefinition
     */
    protected function getTaxDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\Tax\\TaxDefinition'] = $instance = new \Shopware\Core\System\Tax\TaxDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Unit\Aggregate\UnitTranslation\UnitTranslationDefinition' shared service.
     *
     * @return \Shopware\Core\System\Unit\Aggregate\UnitTranslation\UnitTranslationDefinition
     */
    protected function getUnitTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Unit/Aggregate/UnitTranslation/UnitTranslationDefinition.php';

        $this->services['Shopware\\Core\\System\\Unit\\Aggregate\\UnitTranslation\\UnitTranslationDefinition'] = $instance = new \Shopware\Core\System\Unit\Aggregate\UnitTranslation\UnitTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\Unit\UnitDefinition' shared service.
     *
     * @return \Shopware\Core\System\Unit\UnitDefinition
     */
    protected function getUnitDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/Unit/UnitDefinition.php';

        $this->services['Shopware\\Core\\System\\Unit\\UnitDefinition'] = $instance = new \Shopware\Core\System\Unit\UnitDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Aggregate\UserAccessKey\UserAccessKeyDefinition' shared service.
     *
     * @return \Shopware\Core\System\User\Aggregate\UserAccessKey\UserAccessKeyDefinition
     */
    protected function getUserAccessKeyDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/User/Aggregate/UserAccessKey/UserAccessKeyDefinition.php';

        $this->services['Shopware\\Core\\System\\User\\Aggregate\\UserAccessKey\\UserAccessKeyDefinition'] = $instance = new \Shopware\Core\System\User\Aggregate\UserAccessKey\UserAccessKeyDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Aggregate\UserConfig\UserConfigDefinition' shared service.
     *
     * @return \Shopware\Core\System\User\Aggregate\UserConfig\UserConfigDefinition
     */
    protected function getUserConfigDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/User/Aggregate/UserConfig/UserConfigDefinition.php';

        $this->services['Shopware\\Core\\System\\User\\Aggregate\\UserConfig\\UserConfigDefinition'] = $instance = new \Shopware\Core\System\User\Aggregate\UserConfig\UserConfigDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Aggregate\UserRecovery\UserRecoveryDefinition' shared service.
     *
     * @return \Shopware\Core\System\User\Aggregate\UserRecovery\UserRecoveryDefinition
     */
    protected function getUserRecoveryDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/User/Aggregate/UserRecovery/UserRecoveryDefinition.php';

        $this->services['Shopware\\Core\\System\\User\\Aggregate\\UserRecovery\\UserRecoveryDefinition'] = $instance = new \Shopware\Core\System\User\Aggregate\UserRecovery\UserRecoveryDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Api\UserRecoveryController' shared service.
     *
     * @return \Shopware\Core\System\User\Api\UserRecoveryController
     */
    protected function getUserRecoveryControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/User/Api/UserRecoveryController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/User/Recovery/UserRecoveryService.php';

        $this->services['Shopware\\Core\\System\\User\\Api\\UserRecoveryController'] = $instance = new \Shopware\Core\System\User\Api\UserRecoveryController(new \Shopware\Core\System\User\Recovery\UserRecoveryService(($this->services['user_recovery.repository'] ?? $this->getUserRecovery_RepositoryService()), ($this->services['user.repository'] ?? $this->getUser_RepositoryService()), ($this->services['router'] ?? $this->getRouterService()), ($this->privates['Shopware\\Core\\Framework\\Event\\BusinessEventDispatcher'] ?? $this->getBusinessEventDispatcherService()), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? $this->getSalesChannelContextServiceService())), ($this->privates['shopware.rate_limiter'] ?? $this->getShopware_RateLimiterService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\Api\UserValidationController' shared service.
     *
     * @return \Shopware\Core\System\User\Api\UserValidationController
     */
    protected function getUserValidationControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/User/Api/UserValidationController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/System/User/Service/UserValidationService.php';

        $this->services['Shopware\\Core\\System\\User\\Api\\UserValidationController'] = $instance = new \Shopware\Core\System\User\Api\UserValidationController(new \Shopware\Core\System\User\Service\UserValidationService(($this->services['user.repository'] ?? $this->getUser_RepositoryService())));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Core\System\User\UserDefinition' shared service.
     *
     * @return \Shopware\Core\System\User\UserDefinition
     */
    protected function getUserDefinitionService()
    {
        $this->services['Shopware\\Core\\System\\User\\UserDefinition'] = $instance = new \Shopware\Core\System\User\UserDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Elasticsearch\Framework\ElasticsearchHelper' shared service.
     *
     * @return \Shopware\Elasticsearch\Framework\ElasticsearchHelper
     */
    protected function getElasticsearchHelperService()
    {
        $a = ($this->privates['Shopware\\Elasticsearch\\Framework\\ElasticsearchRegistry'] ?? $this->getElasticsearchRegistryService());

        if (isset($this->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'])) {
            return $this->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'];
        }

        return $this->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'] = new \Shopware\Elasticsearch\Framework\ElasticsearchHelper('prod', $this->getEnv('bool:SHOPWARE_ES_ENABLED'), $this->getEnv('bool:SHOPWARE_ES_INDEXING_ENABLED'), $this->getEnv('string:SHOPWARE_ES_INDEX_PREFIX'), $this->getEnv('string:SHOPWARE_ES_THROW_EXCEPTION'), ($this->services['Elasticsearch\\Client'] ?? $this->getClientService()), $a, ($this->privates['Shopware\\Elasticsearch\\Framework\\DataAbstractionLayer\\CriteriaParser'] ?? $this->getCriteriaParserService()), ($this->privates['shopware.elasticsearch.logger'] ?? $this->getShopware_Elasticsearch_LoggerService()));
    }

    /*
     * Gets the public 'Shopware\Elasticsearch\Framework\Indexing\CreateAliasTaskHandler' shared service.
     *
     * @return \Shopware\Elasticsearch\Framework\Indexing\CreateAliasTaskHandler
     */
    protected function getCreateAliasTaskHandlerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/elasticsearch/Framework/Indexing/CreateAliasTaskHandler.php';

        $a = ($this->services['scheduled_task.repository'] ?? $this->getScheduledTask_RepositoryService());

        if (isset($this->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'])) {
            return $this->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'];
        }
        $b = ($this->services['Shopware\\Elasticsearch\\Framework\\ElasticsearchHelper'] ?? $this->getElasticsearchHelperService());

        if (isset($this->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'])) {
            return $this->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'];
        }
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'])) {
            return $this->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'];
        }

        return $this->services['Shopware\\Elasticsearch\\Framework\\Indexing\\CreateAliasTaskHandler'] = new \Shopware\Elasticsearch\Framework\Indexing\CreateAliasTaskHandler($a, ($this->services['Elasticsearch\\Client'] ?? $this->getClientService()), ($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()), $b, $this->parameters['elasticsearch.index.config'], $c);
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AccountOrderController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AccountOrderController
     */
    protected function getAccountOrderControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/AccountOrderController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/Order/AccountOrderPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/Order/AccountEditOrderPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/Order/AccountOrderDetailPageLoader.php';

        $a = ($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService());
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());
        $c = ($this->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute'] ?? $this->getOrderRouteService());
        $d = ($this->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? $this->getOrderServiceService());

        $this->services['Shopware\\Storefront\\Controller\\AccountOrderController'] = $instance = new \Shopware\Storefront\Controller\AccountOrderController(new \Shopware\Storefront\Page\Account\Order\AccountOrderPageLoader($a, $b, $c, ($this->privates['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountService'] ?? $this->getAccountServiceService())), new \Shopware\Storefront\Page\Account\Order\AccountEditOrderPageLoader($a, $b, $c, ($this->privates['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\RequestCriteriaBuilder'] ?? $this->getRequestCriteriaBuilderService()), ($this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SortedPaymentMethodRoute'] ?? $this->getSortedPaymentMethodRouteService()), ($this->privates['Shopware\\Core\\Checkout\\Cart\\Order\\OrderConverter'] ?? $this->getOrderConverterService()), $d), ($this->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextSwitchRoute'] ?? $this->getContextSwitchRouteService()), ($this->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\CancelOrderRoute'] ?? $this->getCancelOrderRouteService()), ($this->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\SetPaymentOrderRoute'] ?? $this->getSetPaymentOrderRouteService()), ($this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\HandlePaymentMethodRoute'] ?? $this->getHandlePaymentMethodRouteService()), $b, new \Shopware\Storefront\Page\Account\Order\AccountOrderDetailPageLoader($a, $b, $c), $c, ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? $this->getSalesChannelContextServiceService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), $d);

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AccountPaymentController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AccountPaymentController
     */
    protected function getAccountPaymentControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/AccountPaymentController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/PaymentMethod/AccountPaymentMethodPageLoader.php';

        $this->services['Shopware\\Storefront\\Controller\\AccountPaymentController'] = $instance = new \Shopware\Storefront\Controller\AccountPaymentController(new \Shopware\Storefront\Page\Account\PaymentMethod\AccountPaymentMethodPageLoader(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService())), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangePaymentMethodRoute'] ?? $this->getChangePaymentMethodRouteService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AccountProfileController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AccountProfileController
     */
    protected function getAccountProfileControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/AccountProfileController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/Overview/AccountOverviewPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/Profile/AccountProfilePageLoader.php';

        $a = ($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService());
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        $this->services['Shopware\\Storefront\\Controller\\AccountProfileController'] = $instance = new \Shopware\Storefront\Controller\AccountProfileController(new \Shopware\Storefront\Page\Account\Overview\AccountOverviewPageLoader($a, $b, ($this->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute'] ?? $this->getOrderRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRoute'] ?? $this->getCustomerRouteService()), ($this->privates['Shopware\\Storefront\\Pagelet\\Newsletter\\Account\\NewsletterAccountPageletLoader'] ?? $this->getNewsletterAccountPageletLoaderService())), new \Shopware\Storefront\Page\Account\Profile\AccountProfilePageLoader($a, $b, ($this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'] ?? $this->getCachedSalutationRouteService())), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeCustomerProfileRoute'] ?? $this->getChangeCustomerProfileRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangePasswordRoute'] ?? $this->getChangePasswordRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeEmailRoute'] ?? $this->getChangeEmailRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteCustomerRoute'] ?? $this->getDeleteCustomerRouteService()), ($this->privates['monolog.logger'] ?? $this->getMonolog_LoggerService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AddressController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AddressController
     */
    protected function getAddressControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/AddressController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Address/Listing/AddressListingPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Address/Detail/AddressDetailPageLoader.php';

        $a = ($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService());
        $b = ($this->services['Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryRoute'] ?? $this->getCachedCountryRouteService());
        $c = ($this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'] ?? $this->getCachedSalutationRouteService());
        $d = ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ListAddressRoute'] ?? $this->getListAddressRouteService());
        $e = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        $this->services['Shopware\\Storefront\\Controller\\AddressController'] = $instance = new \Shopware\Storefront\Controller\AddressController(new \Shopware\Storefront\Page\Address\Listing\AddressListingPageLoader($a, $b, $c, $d, $e, ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? $this->getCartServiceService())), new \Shopware\Storefront\Page\Address\Detail\AddressDetailPageLoader($a, $b, $c, $e, $d), ($this->privates['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AccountService'] ?? $this->getAccountServiceService()), $d, ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\UpsertAddressRoute'] ?? $this->getUpsertAddressRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\DeleteAddressRoute'] ?? $this->getDeleteAddressRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeCustomerProfileRoute'] ?? $this->getChangeCustomerProfileRouteService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\Api\CaptchaController' shared service.
     *
     * @return \Shopware\Storefront\Controller\Api\CaptchaController
     */
    protected function getCaptchaControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/Api/CaptchaController.php';

        $this->services['Shopware\\Storefront\\Controller\\Api\\CaptchaController'] = $instance = new \Shopware\Storefront\Controller\Api\CaptchaController(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Storefront\\Framework\\Captcha\\HoneypotCaptcha'] ?? $this->getHoneypotCaptchaService());
            yield 1 => ($this->privates['Shopware\\Storefront\\Framework\\Captcha\\BasicCaptcha'] ?? $this->getBasicCaptchaService());
            yield 2 => ($this->privates['Shopware\\Storefront\\Framework\\Captcha\\GoogleReCaptchaV2'] ?? $this->getGoogleReCaptchaV2Service());
            yield 3 => ($this->privates['Shopware\\Storefront\\Framework\\Captcha\\GoogleReCaptchaV3'] ?? $this->getGoogleReCaptchaV3Service());
        }, 4));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\AuthController' shared service.
     *
     * @return \Shopware\Storefront\Controller\AuthController
     */
    protected function getAuthController2Service()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/AuthController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/RecoverPassword/AccountRecoverPasswordPageLoader.php';

        $this->services['Shopware\\Storefront\\Controller\\AuthController'] = $instance = new \Shopware\Storefront\Controller\AuthController(($this->privates['Shopware\\Storefront\\Page\\Account\\Login\\AccountLoginPageLoader'] ?? $this->getAccountLoginPageLoaderService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\SendPasswordRecoveryMailRoute'] ?? $this->getSendPasswordRecoveryMailRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ResetPasswordRoute'] ?? $this->getResetPasswordRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoginRoute'] ?? $this->getLoginRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute'] ?? $this->getLogoutRouteService()), ($this->privates['Shopware\\Storefront\\Checkout\\Cart\\SalesChannel\\StorefrontCartFacade'] ?? $this->getStorefrontCartFacadeService()), new \Shopware\Storefront\Page\Account\RecoverPassword\AccountRecoverPasswordPageLoader(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerRecoveryIsExpiredRoute'] ?? $this->getCustomerRecoveryIsExpiredRouteService())), ($this->privates['Shopware\\Core\\System\\SalesChannel\\Context\\SalesChannelContextService'] ?? $this->getSalesChannelContextServiceService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CaptchaController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CaptchaController
     */
    protected function getCaptchaController2Service()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/CaptchaController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Captcha/AbstractBasicCaptchaPageletLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Captcha/BasicCaptchaPageletLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Captcha/BasicCaptcha/AbstractBasicCaptchaGenerator.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Captcha/BasicCaptcha/BasicCaptchaGenerator.php';

        $this->services['Shopware\\Storefront\\Controller\\CaptchaController'] = $instance = new \Shopware\Storefront\Controller\CaptchaController(new \Shopware\Storefront\Pagelet\Captcha\BasicCaptchaPageletLoader(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), new \Shopware\Storefront\Framework\Captcha\BasicCaptcha\BasicCaptchaGenerator(), ($this->privates['Shopware\\Core\\Content\\Category\\Service\\NavigationLoader'] ?? $this->getNavigationLoaderService())), ($this->privates['Shopware\\Storefront\\Framework\\Captcha\\BasicCaptcha'] ?? $this->getBasicCaptchaService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CartLineItemController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CartLineItemController
     */
    protected function getCartLineItemControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/CartLineItemController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/Cart/ProductLineItemFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Checkout/Promotion/Cart/PromotionItemBuilder.php';

        $this->services['Shopware\\Storefront\\Controller\\CartLineItemController'] = $instance = new \Shopware\Storefront\Controller\CartLineItemController(($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? $this->getCartServiceService()), ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\PromotionItemBuilder'] ?? ($this->privates['Shopware\\Core\\Checkout\\Promotion\\Cart\\PromotionItemBuilder'] = new \Shopware\Core\Checkout\Promotion\Cart\PromotionItemBuilder())), new \Shopware\Core\Content\Product\Cart\ProductLineItemFactory(), ($this->services['Shopware\\Core\\Framework\\Util\\HtmlSanitizer'] ?? $this->getHtmlSanitizerService()), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductListRoute'] ?? $this->getProductListRouteService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CheckoutController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CheckoutController
     */
    protected function getCheckoutControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/CheckoutController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Checkout/Cart/CheckoutCartPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Checkout/Confirm/CheckoutConfirmPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Checkout/Finish/CheckoutFinishPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Checkout/Offcanvas/OffcanvasCartPageLoader.php';

        $a = ($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService());
        $b = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());
        $c = ($this->privates['Shopware\\Storefront\\Checkout\\Cart\\SalesChannel\\StorefrontCartFacade'] ?? $this->getStorefrontCartFacadeService());
        $d = ($this->services['Shopware\\Core\\Checkout\\Payment\\SalesChannel\\SortedPaymentMethodRoute'] ?? $this->getSortedPaymentMethodRouteService());
        $e = ($this->services['Shopware\\Core\\Checkout\\Shipping\\SalesChannel\\SortedShippingMethodRoute'] ?? $this->getSortedShippingMethodRouteService());

        $this->services['Shopware\\Storefront\\Controller\\CheckoutController'] = $instance = new \Shopware\Storefront\Controller\CheckoutController(($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? $this->getCartServiceService()), new \Shopware\Storefront\Page\Checkout\Cart\CheckoutCartPageLoader($a, $b, $c, $d, $e, ($this->services['Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryRoute'] ?? $this->getCachedCountryRouteService())), new \Shopware\Storefront\Page\Checkout\Confirm\CheckoutConfirmPageLoader($b, $c, $e, $d, $a, ($this->privates['Shopware\\Core\\Checkout\\Customer\\Validation\\AddressValidationFactory'] ?? $this->getAddressValidationFactoryService()), ($this->privates['Shopware\\Core\\Framework\\Validation\\DataValidator'] ?? $this->getDataValidatorService())), new \Shopware\Storefront\Page\Checkout\Finish\CheckoutFinishPageLoader($b, $a, ($this->services['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderRoute'] ?? $this->getOrderRouteService())), ($this->privates['Shopware\\Core\\Checkout\\Order\\SalesChannel\\OrderService'] ?? $this->getOrderServiceService()), ($this->privates['Shopware\\Core\\Checkout\\Payment\\PaymentService'] ?? $this->getPaymentServiceService()), new \Shopware\Storefront\Page\Checkout\Offcanvas\OffcanvasCartPageLoader($b, $c, $a, $e), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LogoutRoute'] ?? $this->getLogoutRouteService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CmsController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CmsController
     */
    protected function getCmsControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/CmsController.php';

        $this->services['Shopware\\Storefront\\Controller\\CmsController'] = $instance = new \Shopware\Storefront\Controller\CmsController(($this->services['Shopware\\Core\\Content\\Cms\\SalesChannel\\CmsRoute'] ?? $this->getCmsRouteService()), ($this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedCategoryRoute'] ?? $this->getCachedCategoryRouteService()), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Listing\\ResolveCriteriaProductListingRoute'] ?? $this->getResolveCriteriaProductListingRouteService()), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\CachedProductDetailRoute'] ?? $this->getCachedProductDetailRouteService()), ($this->services['Shopware\\Storefront\\Page\\Product\\Review\\ProductReviewLoader'] ?? $this->getProductReviewLoaderService()), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\FindVariant\\FindProductVariantRoute'] ?? $this->getFindProductVariantRouteService()), ($this->services['Shopware\\Storefront\\Page\\Product\\Configurator\\ProductCombinationFinder'] ?? $this->getProductCombinationFinderService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\ContextController' shared service.
     *
     * @return \Shopware\Storefront\Controller\ContextController
     */
    protected function getContextControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/ContextController.php';

        $this->services['Shopware\\Storefront\\Controller\\ContextController'] = $instance = new \Shopware\Storefront\Controller\ContextController(($this->services['Shopware\\Core\\System\\SalesChannel\\SalesChannel\\ContextSwitchRoute'] ?? $this->getContextSwitchRouteService()), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['router.default'] ?? $this->getRouter_DefaultService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ChangeLanguageRoute'] ?? $this->getChangeLanguageRouteService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CookieController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CookieController
     */
    protected function getCookieControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/CookieController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cookie/CookieProviderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cookie/AppCookieProvider.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cookie/CookieProvider.php';

        $this->services['Shopware\\Storefront\\Controller\\CookieController'] = $instance = new \Shopware\Storefront\Controller\CookieController(new \Shopware\Storefront\Framework\Cookie\AppCookieProvider(new \Shopware\Storefront\Framework\Cookie\CookieProvider(), ($this->services['app.repository'] ?? $this->getApp_RepositoryService())), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CountryStateController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CountryStateController
     */
    protected function getCountryStateControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/CountryStateController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Country/CountryStateDataPageletLoader.php';

        $this->services['Shopware\\Storefront\\Controller\\CountryStateController'] = $instance = new \Shopware\Storefront\Controller\CountryStateController(new \Shopware\Storefront\Pagelet\Country\CountryStateDataPageletLoader(($this->services['Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryStateRoute'] ?? $this->getCachedCountryStateRouteService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService())), ($this->services['Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryRoute'] ?? $this->getCachedCountryRouteService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\CsrfController' shared service.
     *
     * @return \Shopware\Storefront\Controller\CsrfController
     */
    protected function getCsrfControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/CsrfController.php';

        $this->services['Shopware\\Storefront\\Controller\\CsrfController'] = $instance = new \Shopware\Storefront\Controller\CsrfController(($this->services['.container.private.security.csrf.token_manager'] ?? $this->get_Container_Private_Security_Csrf_TokenManagerService()), true, 'twig');

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\DocumentController' shared service.
     *
     * @return \Shopware\Storefront\Controller\DocumentController
     */
    protected function getDocumentController2Service()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/DocumentController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/Document/DocumentPageLoader.php';

        $this->services['Shopware\\Storefront\\Controller\\DocumentController'] = $instance = new \Shopware\Storefront\Controller\DocumentController(new \Shopware\Storefront\Page\Account\Document\DocumentPageLoader(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->privates['Shopware\\Core\\Checkout\\Document\\DocumentService'] ?? $this->getDocumentServiceService()), ($this->services['document.repository'] ?? $this->getDocument_RepositoryService())), ($this->services['Shopware\\Core\\Checkout\\Document\\SalesChannel\\DocumentRoute'] ?? $this->getDocumentRouteService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\ErrorController' shared service.
     *
     * @return \Shopware\Storefront\Controller\ErrorController
     */
    protected function getErrorControllerService($lazyLoad = true)
    {
        if ($lazyLoad) {
            return $this->services['Shopware\\Storefront\\Controller\\ErrorController'] = $this->createProxy('ErrorController_b437ad9', function () {
                return \ErrorController_b437ad9::staticProxyConstructor(function (&$wrappedInstance, \ProxyManager\Proxy\LazyLoadingInterface $proxy) {
                    $wrappedInstance = $this->getErrorControllerService(false);

                    $proxy->setProxyInitializer(null);

                    return true;
                });
            });
        }

        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Twig/ErrorTemplateResolver.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Navigation/Error/ErrorPageLoaderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Navigation/Error/ErrorPageLoader.php';

        $a = ($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService());

        $instance = new \Shopware\Storefront\Controller\ErrorController(new \Shopware\Storefront\Framework\Twig\ErrorTemplateResolver($a), ($this->privates['Shopware\\Storefront\\Pagelet\\Header\\HeaderPageletLoader'] ?? $this->getHeaderPageletLoaderService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), new \Shopware\Storefront\Page\Navigation\Error\ErrorPageLoader(($this->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? $this->getSalesChannelCmsPageLoaderService()), ($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService())), ($this->privates['Shopware\\Storefront\\Pagelet\\Footer\\FooterPageletLoader'] ?? $this->getFooterPageletLoaderService()));

        $instance->setContainer($this);
        $instance->setTwig($a);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\FormController' shared service.
     *
     * @return \Shopware\Storefront\Controller\FormController
     */
    protected function getFormControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/FormController.php';

        $this->services['Shopware\\Storefront\\Controller\\FormController'] = $instance = new \Shopware\Storefront\Controller\FormController(($this->services['Shopware\\Core\\Content\\ContactForm\\SalesChannel\\ContactFormRoute'] ?? $this->getContactFormRouteService()), ($this->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterSubscribeRoute'] ?? $this->getNewsletterSubscribeRouteService()), ($this->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterUnsubscribeRoute'] ?? $this->getNewsletterUnsubscribeRouteService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\LandingPageController' shared service.
     *
     * @return \Shopware\Storefront\Controller\LandingPageController
     */
    protected function getLandingPageControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/LandingPageController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/LandingPage/LandingPageLoader.php';

        $this->services['Shopware\\Storefront\\Controller\\LandingPageController'] = $instance = new \Shopware\Storefront\Controller\LandingPageController(new \Shopware\Storefront\Page\LandingPage\LandingPageLoader(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->services['Shopware\\Core\\Content\\LandingPage\\SalesChannel\\CachedLandingPageRoute'] ?? $this->getCachedLandingPageRouteService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService())));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\MaintenanceController' shared service.
     *
     * @return \Shopware\Storefront\Controller\MaintenanceController
     */
    protected function getMaintenanceControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/MaintenanceController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Maintenance/MaintenancePageLoader.php';

        $this->services['Shopware\\Storefront\\Controller\\MaintenanceController'] = $instance = new \Shopware\Storefront\Controller\MaintenanceController(($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), new \Shopware\Storefront\Page\Maintenance\MaintenancePageLoader(($this->privates['Shopware\\Core\\Content\\Cms\\SalesChannel\\SalesChannelCmsPageLoader'] ?? $this->getSalesChannelCmsPageLoaderService()), ($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService())), ($this->privates['Shopware\\Storefront\\Framework\\Routing\\MaintenanceModeResolver'] ?? $this->getMaintenanceModeResolverService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\NavigationController' shared service.
     *
     * @return \Shopware\Storefront\Controller\NavigationController
     */
    protected function getNavigationControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/NavigationController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Navigation/NavigationPageLoaderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Navigation/NavigationPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Menu/Offcanvas/MenuOffcanvasPageletLoaderInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Menu/Offcanvas/MenuOffcanvasPageletLoader.php';

        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        $this->services['Shopware\\Storefront\\Controller\\NavigationController'] = $instance = new \Shopware\Storefront\Controller\NavigationController(new \Shopware\Storefront\Page\Navigation\NavigationPageLoader(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), $a, ($this->services['Shopware\\Core\\Content\\Category\\SalesChannel\\CachedCategoryRoute'] ?? $this->getCachedCategoryRouteService()), ($this->services['Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface'] ?? $this->getSeoUrlPlaceholderHandlerInterfaceService())), new \Shopware\Storefront\Pagelet\Menu\Offcanvas\MenuOffcanvasPageletLoader($a, ($this->privates['Shopware\\Core\\Content\\Category\\Service\\NavigationLoader'] ?? $this->getNavigationLoaderService())));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\NewsletterController' shared service.
     *
     * @return \Shopware\Storefront\Controller\NewsletterController
     */
    protected function getNewsletterControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/NewsletterController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Newsletter/Subscribe/NewsletterSubscribePageLoader.php';

        $this->services['Shopware\\Storefront\\Controller\\NewsletterController'] = $instance = new \Shopware\Storefront\Controller\NewsletterController(new \Shopware\Storefront\Page\Newsletter\Subscribe\NewsletterSubscribePageLoader(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService())), ($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), ($this->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterSubscribeRoute'] ?? $this->getNewsletterSubscribeRouteService()), ($this->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterConfirmRoute'] ?? $this->getNewsletterConfirmRouteService()), ($this->services['Shopware\\Core\\Content\\Newsletter\\SalesChannel\\NewsletterUnsubscribeRoute'] ?? $this->getNewsletterUnsubscribeRouteService()), ($this->privates['Shopware\\Storefront\\Pagelet\\Newsletter\\Account\\NewsletterAccountPageletLoader'] ?? $this->getNewsletterAccountPageletLoaderService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\ProductController' shared service.
     *
     * @return \Shopware\Storefront\Controller\ProductController
     */
    protected function getProductControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/ProductController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Product/ProductPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Product/QuickView/MinimalQuickViewPageLoader.php';

        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());
        $b = ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Detail\\CachedProductDetailRoute'] ?? $this->getCachedProductDetailRouteService());
        $c = ($this->services['Shopware\\Storefront\\Page\\Product\\Review\\ProductReviewLoader'] ?? $this->getProductReviewLoaderService());

        $this->services['Shopware\\Storefront\\Controller\\ProductController'] = $instance = new \Shopware\Storefront\Controller\ProductController(new \Shopware\Storefront\Page\Product\ProductPageLoader(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), $a, $b, $c, ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\CrossSelling\\CachedProductCrossSellingRoute'] ?? $this->getCachedProductCrossSellingRouteService())), ($this->services['Shopware\\Storefront\\Page\\Product\\Configurator\\ProductCombinationFinder'] ?? $this->getProductCombinationFinderService()), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\FindVariant\\FindProductVariantRoute'] ?? $this->getFindProductVariantRouteService()), new \Shopware\Storefront\Page\Product\QuickView\MinimalQuickViewPageLoader($a, $b), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\ProductReviewSaveRoute'] ?? $this->getProductReviewSaveRouteService()), ($this->services['Shopware\\Core\\Content\\Seo\\SeoUrlPlaceholderHandlerInterface'] ?? $this->getSeoUrlPlaceholderHandlerInterfaceService()), $c, ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\RegisterController' shared service.
     *
     * @return \Shopware\Storefront\Controller\RegisterController
     */
    protected function getRegisterControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/RegisterController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/CustomerGroupRegistration/AbstractCustomerGroupRegistrationPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Account/CustomerGroupRegistration/CustomerGroupRegistrationPageLoader.php';

        $a = ($this->privates['Shopware\\Storefront\\Page\\Account\\Login\\AccountLoginPageLoader'] ?? $this->getAccountLoginPageLoaderService());

        $this->services['Shopware\\Storefront\\Controller\\RegisterController'] = $instance = new \Shopware\Storefront\Controller\RegisterController($a, ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterRoute'] ?? $this->getRegisterRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RegisterConfirmRoute'] ?? $this->getRegisterConfirmRouteService()), ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? $this->getCartServiceService()), ($this->services['Shopware\\Storefront\\Page\\Checkout\\Register\\CheckoutRegisterPageLoader'] ?? $this->getCheckoutRegisterPageLoaderService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), ($this->services['customer.repository'] ?? $this->getCustomer_RepositoryService()), new \Shopware\Storefront\Page\Account\CustomerGroupRegistration\CustomerGroupRegistrationPageLoader($a, ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\CustomerGroupRegistrationSettingsRoute'] ?? $this->getCustomerGroupRegistrationSettingsRouteService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService())), ($this->services['sales_channel_domain.repository'] ?? $this->getSalesChannelDomain_RepositoryService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\ScriptController' shared service.
     *
     * @return \Shopware\Storefront\Controller\ScriptController
     */
    protected function getScriptControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/ScriptController.php';

        $this->services['Shopware\\Storefront\\Controller\\ScriptController'] = $instance = new \Shopware\Storefront\Controller\ScriptController(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->privates['Shopware\\Core\\Framework\\Script\\Api\\ScriptResponseEncoder'] ?? $this->getScriptResponseEncoderService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\SearchController' shared service.
     *
     * @return \Shopware\Storefront\Controller\SearchController
     */
    protected function getSearchControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/SearchController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Suggest/SuggestPageLoader.php';

        $this->services['Shopware\\Storefront\\Controller\\SearchController'] = $instance = new \Shopware\Storefront\Controller\SearchController(($this->services['Shopware\\Storefront\\Page\\Search\\SearchPageLoader'] ?? $this->getSearchPageLoaderService()), new \Shopware\Storefront\Page\Suggest\SuggestPageLoader(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Suggest\\CachedProductSuggestRoute'] ?? $this->getCachedProductSuggestRouteService()), ($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService())), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute'] ?? $this->getResolvedCriteriaProductSearchRouteService()));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\SitemapController' shared service.
     *
     * @return \Shopware\Storefront\Controller\SitemapController
     */
    protected function getSitemapControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/SitemapController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Sitemap/SitemapPageLoader.php';

        $this->services['Shopware\\Storefront\\Controller\\SitemapController'] = $instance = new \Shopware\Storefront\Controller\SitemapController(new \Shopware\Storefront\Page\Sitemap\SitemapPageLoader(($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Content\\Sitemap\\SalesChannel\\CachedSitemapRoute'] ?? $this->getCachedSitemapRouteService())));

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\StoreApiProxyController' shared service.
     *
     * @return \Shopware\Storefront\Controller\StoreApiProxyController
     */
    protected function getStoreApiProxyControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/StoreApiProxyController.php';

        return $this->services['Shopware\\Storefront\\Controller\\StoreApiProxyController'] = new \Shopware\Storefront\Controller\StoreApiProxyController(($this->services['kernel'] ?? $this->get('kernel', 1)), ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())));
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\VerificationHashController' shared service.
     *
     * @return \Shopware\Storefront\Controller\VerificationHashController
     */
    protected function getVerificationHashControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/VerificationHashController.php';

        $this->services['Shopware\\Storefront\\Controller\\VerificationHashController'] = $instance = new \Shopware\Storefront\Controller\VerificationHashController(($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\WellKnownController' shared service.
     *
     * @return \Shopware\Storefront\Controller\WellKnownController
     */
    protected function getWellKnownControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/WellKnownController.php';

        $this->services['Shopware\\Storefront\\Controller\\WellKnownController'] = $instance = new \Shopware\Storefront\Controller\WellKnownController();

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Controller\WishlistController' shared service.
     *
     * @return \Shopware\Storefront\Controller\WishlistController
     */
    protected function getWishlistControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Controller/WishlistController.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Wishlist/WishlistPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Wishlist/GuestWishlistPageLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Pagelet/Wishlist/GuestWishlistPageletLoader.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/AbstractProductCloseoutFilterFactory.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Content/Product/SalesChannel/ProductCloseoutFilterFactory.php';

        $a = ($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService());
        $b = ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\LoadWishlistRoute'] ?? $this->getLoadWishlistRouteService());
        $c = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        $this->services['Shopware\\Storefront\\Controller\\WishlistController'] = $instance = new \Shopware\Storefront\Controller\WishlistController(new \Shopware\Storefront\Page\Wishlist\WishlistPageLoader($a, $b, $c), $b, ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\AddWishlistProductRoute'] ?? $this->getAddWishlistProductRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\RemoveWishlistProductRoute'] ?? $this->getRemoveWishlistProductRouteService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\MergeWishlistProductRoute'] ?? $this->getMergeWishlistProductRouteService()), new \Shopware\Storefront\Page\Wishlist\GuestWishlistPageLoader($a, $c), new \Shopware\Storefront\Pagelet\Wishlist\GuestWishlistPageletLoader(($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductListRoute'] ?? $this->getProductListRouteService()), ($this->services['Shopware\\Core\\System\\SystemConfig\\SystemConfigService'] ?? $this->getSystemConfigServiceService()), $c, ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] ?? ($this->privates['Shopware\\Core\\Content\\Product\\SalesChannel\\ProductCloseoutFilterFactory'] = new \Shopware\Core\Content\Product\SalesChannel\ProductCloseoutFilterFactory()))), $c);

        $instance->setContainer($this);
        $instance->setTwig(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Framework\Cache\CacheStore' shared autowired service.
     *
     * @return \Shopware\Storefront\Framework\Cache\CacheStore
     */
    protected function getCacheStoreService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/HttpCache/StoreInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cache/CacheStore.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cache/CacheStateValidatorInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cache/CacheStateValidator.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cache/AbstractHttpCacheKeyGenerator.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Cache/HttpCacheKeyGenerator.php';

        $a = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        return $this->services['Shopware\\Storefront\\Framework\\Cache\\CacheStore'] = new \Shopware\Storefront\Framework\Cache\CacheStore(($this->privates['cache.http'] ?? $this->getCache_HttpService()), new \Shopware\Storefront\Framework\Cache\CacheStateValidator($this->parameters['shopware.cache.invalidation.http_cache']), $a, ($this->privates['Shopware\\Storefront\\Framework\\Cache\\CacheTracer'] ?? $this->getCacheTracerService()), new \Shopware\Storefront\Framework\Cache\HttpCacheKeyGenerator('246eff99a7cf73041589a6ecc9e3ab3c', $a, $this->parameters['storefront.http_cache.ignored_url_parameters']), ($this->privates['Shopware\\Storefront\\Framework\\Routing\\MaintenanceModeResolver'] ?? $this->getMaintenanceModeResolverService()), $this->parameters['session.storage.options']);
    }

    /*
     * Gets the public 'Shopware\Storefront\Framework\Csrf\CsrfPlaceholderHandler' shared autowired service.
     *
     * @return \Shopware\Storefront\Framework\Csrf\CsrfPlaceholderHandler
     */
    protected function getCsrfPlaceholderHandlerService()
    {
        return $this->services['Shopware\\Storefront\\Framework\\Csrf\\CsrfPlaceholderHandler'] = new \Shopware\Storefront\Framework\Csrf\CsrfPlaceholderHandler(($this->services['.container.private.security.csrf.token_manager'] ?? $this->get_Container_Private_Security_Csrf_TokenManagerService()), true, 'twig', ($this->services['request_stack'] ?? ($this->services['request_stack'] = new \Symfony\Component\HttpFoundation\RequestStack())), ($this->privates['session.storage.factory.native'] ?? $this->getSession_Storage_Factory_NativeService()));
    }

    /*
     * Gets the public 'Shopware\Storefront\Framework\Media\StorefrontMediaValidatorRegistry' shared autowired service.
     *
     * @return \Shopware\Storefront\Framework\Media\StorefrontMediaValidatorRegistry
     */
    protected function getStorefrontMediaValidatorRegistryService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Framework/Media/StorefrontMediaValidatorRegistry.php';

        return $this->services['Shopware\\Storefront\\Framework\\Media\\StorefrontMediaValidatorRegistry'] = new \Shopware\Storefront\Framework\Media\StorefrontMediaValidatorRegistry(new RewindableGenerator(function () {
            yield 0 => ($this->privates['Shopware\\Storefront\\Framework\\Media\\Validator\\StorefrontMediaImageValidator'] ?? ($this->privates['Shopware\\Storefront\\Framework\\Media\\Validator\\StorefrontMediaImageValidator'] = new \Shopware\Storefront\Framework\Media\Validator\StorefrontMediaImageValidator()));
            yield 1 => ($this->privates['Shopware\\Storefront\\Framework\\Media\\Validator\\StorefrontMediaDocumentValidator'] ?? ($this->privates['Shopware\\Storefront\\Framework\\Media\\Validator\\StorefrontMediaDocumentValidator'] = new \Shopware\Storefront\Framework\Media\Validator\StorefrontMediaDocumentValidator()));
        }, 2));
    }

    /*
     * Gets the public 'Shopware\Storefront\Page\Checkout\Register\CheckoutRegisterPageLoader' shared autowired service.
     *
     * @return \Shopware\Storefront\Page\Checkout\Register\CheckoutRegisterPageLoader
     */
    protected function getCheckoutRegisterPageLoaderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Checkout/Register/CheckoutRegisterPageLoader.php';

        return $this->services['Shopware\\Storefront\\Page\\Checkout\\Register\\CheckoutRegisterPageLoader'] = new \Shopware\Storefront\Page\Checkout\Register\CheckoutRegisterPageLoader(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->services['Shopware\\Core\\Checkout\\Customer\\SalesChannel\\ListAddressRoute'] ?? $this->getListAddressRouteService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Checkout\\Cart\\SalesChannel\\CartService'] ?? $this->getCartServiceService()), ($this->services['Shopware\\Core\\System\\Salutation\\SalesChannel\\CachedSalutationRoute'] ?? $this->getCachedSalutationRouteService()), ($this->services['Shopware\\Core\\System\\Country\\SalesChannel\\CachedCountryRoute'] ?? $this->getCachedCountryRouteService()));
    }

    /*
     * Gets the public 'Shopware\Storefront\Page\Product\Configurator\ProductCombinationFinder' shared autowired service.
     *
     * @return \Shopware\Storefront\Page\Product\Configurator\ProductCombinationFinder
     */
    protected function getProductCombinationFinderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Product/Configurator/ProductCombinationFinder.php';

        return $this->services['Shopware\\Storefront\\Page\\Product\\Configurator\\ProductCombinationFinder'] = new \Shopware\Storefront\Page\Product\Configurator\ProductCombinationFinder(($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\FindVariant\\FindProductVariantRoute'] ?? $this->getFindProductVariantRouteService()));
    }

    /*
     * Gets the public 'Shopware\Storefront\Page\Product\Review\ProductReviewLoader' shared service.
     *
     * @return \Shopware\Storefront\Page\Product\Review\ProductReviewLoader
     */
    protected function getProductReviewLoaderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Product/Review/ProductReviewLoader.php';

        return $this->services['Shopware\\Storefront\\Page\\Product\\Review\\ProductReviewLoader'] = new \Shopware\Storefront\Page\Product\Review\ProductReviewLoader(($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Review\\CachedProductReviewRoute'] ?? $this->getCachedProductReviewRouteService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the public 'Shopware\Storefront\Page\Search\SearchPageLoader' shared autowired service.
     *
     * @return \Shopware\Storefront\Page\Search\SearchPageLoader
     */
    protected function getSearchPageLoaderService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Page/Search/SearchPageLoader.php';

        return $this->services['Shopware\\Storefront\\Page\\Search\\SearchPageLoader'] = new \Shopware\Storefront\Page\Search\SearchPageLoader(($this->privates['Shopware\\Storefront\\Page\\GenericPageLoader'] ?? $this->getGenericPageLoaderService()), ($this->services['Shopware\\Core\\Content\\Product\\SalesChannel\\Search\\ResolvedCriteriaProductSearchRoute'] ?? $this->getResolvedCriteriaProductSearchRouteService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()));
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Aggregate\ThemeChildDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\Aggregate\ThemeChildDefinition
     */
    protected function getThemeChildDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/Aggregate/ThemeChildDefinition.php';

        $this->services['Shopware\\Storefront\\Theme\\Aggregate\\ThemeChildDefinition'] = $instance = new \Shopware\Storefront\Theme\Aggregate\ThemeChildDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Aggregate\ThemeMediaDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\Aggregate\ThemeMediaDefinition
     */
    protected function getThemeMediaDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/Aggregate/ThemeMediaDefinition.php';

        $this->services['Shopware\\Storefront\\Theme\\Aggregate\\ThemeMediaDefinition'] = $instance = new \Shopware\Storefront\Theme\Aggregate\ThemeMediaDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Aggregate\ThemeSalesChannelDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\Aggregate\ThemeSalesChannelDefinition
     */
    protected function getThemeSalesChannelDefinitionService()
    {
        $this->services['Shopware\\Storefront\\Theme\\Aggregate\\ThemeSalesChannelDefinition'] = $instance = new \Shopware\Storefront\Theme\Aggregate\ThemeSalesChannelDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Aggregate\ThemeTranslationDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\Aggregate\ThemeTranslationDefinition
     */
    protected function getThemeTranslationDefinitionService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/DataAbstractionLayer/EntityTranslationDefinition.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/Aggregate/ThemeTranslationDefinition.php';

        $this->services['Shopware\\Storefront\\Theme\\Aggregate\\ThemeTranslationDefinition'] = $instance = new \Shopware\Storefront\Theme\Aggregate\ThemeTranslationDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\Controller\ThemeController' shared service.
     *
     * @return \Shopware\Storefront\Theme\Controller\ThemeController
     */
    protected function getThemeControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/storefront/Theme/Controller/ThemeController.php';

        $this->services['Shopware\\Storefront\\Theme\\Controller\\ThemeController'] = $instance = new \Shopware\Storefront\Theme\Controller\ThemeController(($this->privates['Shopware\\Storefront\\Theme\\ThemeService'] ?? $this->getThemeServiceService()));

        $instance->setContainer($this);

        return $instance;
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\SalesChannelThemeLoader' shared service.
     *
     * @return \Shopware\Storefront\Theme\SalesChannelThemeLoader
     */
    protected function getSalesChannelThemeLoaderService()
    {
        return $this->services['Shopware\\Storefront\\Theme\\SalesChannelThemeLoader'] = new \Shopware\Storefront\Theme\SalesChannelThemeLoader(($this->services['Doctrine\\DBAL\\Connection'] ?? $this->getConnectionService()));
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\StorefrontPluginRegistry' shared service.
     *
     * @return \Shopware\Storefront\Theme\StorefrontPluginRegistry
     */
    protected function getStorefrontPluginRegistryService()
    {
        return $this->services['Shopware\\Storefront\\Theme\\StorefrontPluginRegistry'] = new \Shopware\Storefront\Theme\StorefrontPluginRegistry(($this->services['kernel'] ?? $this->get('kernel', 1)), ($this->privates['Shopware\\Storefront\\Theme\\StorefrontPluginConfiguration\\StorefrontPluginConfigurationFactory'] ?? ($this->privates['Shopware\\Storefront\\Theme\\StorefrontPluginConfiguration\\StorefrontPluginConfigurationFactory'] = new \Shopware\Storefront\Theme\StorefrontPluginConfiguration\StorefrontPluginConfigurationFactory(\dirname(__DIR__, 4)))), ($this->privates['Shopware\\Core\\Framework\\App\\ActiveAppsLoader'] ?? $this->getActiveAppsLoaderService()));
    }

    /*
     * Gets the public 'Shopware\Storefront\Theme\ThemeDefinition' shared service.
     *
     * @return \Shopware\Storefront\Theme\ThemeDefinition
     */
    protected function getThemeDefinitionService()
    {
        $this->services['Shopware\\Storefront\\Theme\\ThemeDefinition'] = $instance = new \Shopware\Storefront\Theme\ThemeDefinition();

        $instance->compile(($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\DefinitionInstanceRegistry'] ?? $this->getDefinitionInstanceRegistryService()));

        return $instance;
    }

    /*
     * Gets the public 'Symfony\Bundle\FrameworkBundle\Controller\RedirectController' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Controller\RedirectController
     */
    protected function getRedirectControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Controller/RedirectController.php';

        $a = ($this->privates['router.request_context'] ?? $this->getRouter_RequestContextService());

        return $this->services['Symfony\\Bundle\\FrameworkBundle\\Controller\\RedirectController'] = new \Symfony\Bundle\FrameworkBundle\Controller\RedirectController(($this->services['router'] ?? $this->getRouterService()), $a->getHttpPort(), $a->getHttpsPort());
    }

    /*
     * Gets the public 'Symfony\Bundle\FrameworkBundle\Controller\TemplateController' shared service.
     *
     * @return \Symfony\Bundle\FrameworkBundle\Controller\TemplateController
     */
    protected function getTemplateControllerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/framework-bundle/Controller/TemplateController.php';

        return $this->services['Symfony\\Bundle\\FrameworkBundle\\Controller\\TemplateController'] = new \Symfony\Bundle\FrameworkBundle\Controller\TemplateController(($this->services['.container.private.twig'] ?? $this->get_Container_Private_TwigService()));
    }

    /*
     * Gets the public 'acl_role.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAclRole_RepositoryService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService());

        if (isset($this->services['acl_role.repository'])) {
            return $this->services['acl_role.repository'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['acl_role.repository'])) {
            return $this->services['acl_role.repository'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService());

        if (isset($this->services['acl_role.repository'])) {
            return $this->services['acl_role.repository'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['acl_role.repository'])) {
            return $this->services['acl_role.repository'];
        }

        return $this->services['acl_role.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclRoleDefinition'] ?? $this->getAclRoleDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $a, $b, $c, $d, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'acl_user_role.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAclUserRole_RepositoryService()
    {
        return $this->services['acl_user_role.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\Api\\Acl\\Role\\AclUserRoleDefinition'] ?? $this->getAclUserRoleDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'administration.filesystem.private' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected function getAdministration_Filesystem_PrivateService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Filesystem/AbstractFilesystem.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Filesystem/PrefixFilesystem.php';

        return $this->services['administration.filesystem.private'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($this->services['shopware.filesystem.private'] ?? $this->getShopware_Filesystem_PrivateService()), 'plugins/administration');
    }

    /*
     * Gets the public 'administration.filesystem.public' shared service.
     *
     * @return \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem
     */
    protected function getAdministration_Filesystem_PublicService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Filesystem/AbstractFilesystem.php';
        include_once \dirname(__DIR__, 4).'/vendor/shopware/core/Framework/Adapter/Filesystem/PrefixFilesystem.php';

        return $this->services['administration.filesystem.public'] = new \Shopware\Core\Framework\Adapter\Filesystem\PrefixFilesystem(($this->services['shopware.filesystem.public'] ?? $this->getShopware_Filesystem_PublicService()), 'plugins/administration');
    }

    /*
     * Gets the public 'app.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getApp_RepositoryService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService());

        if (isset($this->services['app.repository'])) {
            return $this->services['app.repository'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['app.repository'])) {
            return $this->services['app.repository'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService());

        if (isset($this->services['app.repository'])) {
            return $this->services['app.repository'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['app.repository'])) {
            return $this->services['app.repository'];
        }

        return $this->services['app.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\AppDefinition'] ?? $this->getAppDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $a, $b, $c, $d, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_action_button.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppActionButton_RepositoryService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService());

        if (isset($this->services['app_action_button.repository'])) {
            return $this->services['app_action_button.repository'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['app_action_button.repository'])) {
            return $this->services['app_action_button.repository'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService());

        if (isset($this->services['app_action_button.repository'])) {
            return $this->services['app_action_button.repository'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['app_action_button.repository'])) {
            return $this->services['app_action_button.repository'];
        }

        return $this->services['app_action_button.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\ActionButton\\ActionButtonDefinition'] ?? $this->getActionButtonDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $a, $b, $c, $d, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_action_button_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppActionButtonTranslation_RepositoryService()
    {
        return $this->services['app_action_button_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\ActionButtonTranslation\\ActionButtonTranslationDefinition'] ?? $this->getActionButtonTranslationDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_administration_snippet.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppAdministrationSnippet_RepositoryService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService());

        if (isset($this->services['app_administration_snippet.repository'])) {
            return $this->services['app_administration_snippet.repository'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['app_administration_snippet.repository'])) {
            return $this->services['app_administration_snippet.repository'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService());

        if (isset($this->services['app_administration_snippet.repository'])) {
            return $this->services['app_administration_snippet.repository'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['app_administration_snippet.repository'])) {
            return $this->services['app_administration_snippet.repository'];
        }

        return $this->services['app_administration_snippet.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Administration\\Snippet\\AppAdministrationSnippetDefinition'] ?? $this->getAppAdministrationSnippetDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $a, $b, $c, $d, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_cms_block.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppCmsBlock_RepositoryService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService());

        if (isset($this->services['app_cms_block.repository'])) {
            return $this->services['app_cms_block.repository'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['app_cms_block.repository'])) {
            return $this->services['app_cms_block.repository'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService());

        if (isset($this->services['app_cms_block.repository'])) {
            return $this->services['app_cms_block.repository'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['app_cms_block.repository'])) {
            return $this->services['app_cms_block.repository'];
        }

        return $this->services['app_cms_block.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlock\\AppCmsBlockDefinition'] ?? $this->getAppCmsBlockDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $a, $b, $c, $d, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_cms_block_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppCmsBlockTranslation_RepositoryService()
    {
        return $this->services['app_cms_block_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\CmsBlockTranslation\\AppCmsBlockTranslationDefinition'] ?? $this->getAppCmsBlockTranslationDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_flow_action.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppFlowAction_RepositoryService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService());

        if (isset($this->services['app_flow_action.repository'])) {
            return $this->services['app_flow_action.repository'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['app_flow_action.repository'])) {
            return $this->services['app_flow_action.repository'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService());

        if (isset($this->services['app_flow_action.repository'])) {
            return $this->services['app_flow_action.repository'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['app_flow_action.repository'])) {
            return $this->services['app_flow_action.repository'];
        }

        return $this->services['app_flow_action.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowAction\\AppFlowActionDefinition'] ?? $this->getAppFlowActionDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $a, $b, $c, $d, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_flow_action_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppFlowActionTranslation_RepositoryService()
    {
        return $this->services['app_flow_action_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\FlowActionTranslation\\AppFlowActionTranslationDefinition'] ?? $this->getAppFlowActionTranslationDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_payment_method.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppPaymentMethod_RepositoryService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService());

        if (isset($this->services['app_payment_method.repository'])) {
            return $this->services['app_payment_method.repository'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['app_payment_method.repository'])) {
            return $this->services['app_payment_method.repository'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService());

        if (isset($this->services['app_payment_method.repository'])) {
            return $this->services['app_payment_method.repository'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['app_payment_method.repository'])) {
            return $this->services['app_payment_method.repository'];
        }

        return $this->services['app_payment_method.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppPaymentMethod\\AppPaymentMethodDefinition'] ?? $this->getAppPaymentMethodDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $a, $b, $c, $d, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_script_condition.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppScriptCondition_RepositoryService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService());

        if (isset($this->services['app_script_condition.repository'])) {
            return $this->services['app_script_condition.repository'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['app_script_condition.repository'])) {
            return $this->services['app_script_condition.repository'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService());

        if (isset($this->services['app_script_condition.repository'])) {
            return $this->services['app_script_condition.repository'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['app_script_condition.repository'])) {
            return $this->services['app_script_condition.repository'];
        }

        return $this->services['app_script_condition.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptCondition\\AppScriptConditionDefinition'] ?? $this->getAppScriptConditionDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $a, $b, $c, $d, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_script_condition_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppScriptConditionTranslation_RepositoryService()
    {
        return $this->services['app_script_condition_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppScriptConditionTranslation\\AppScriptConditionTranslationDefinition'] ?? $this->getAppScriptConditionTranslationDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_template.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppTemplate_RepositoryService()
    {
        $a = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService());

        if (isset($this->services['app_template.repository'])) {
            return $this->services['app_template.repository'];
        }
        $b = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService());

        if (isset($this->services['app_template.repository'])) {
            return $this->services['app_template.repository'];
        }
        $c = ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService());

        if (isset($this->services['app_template.repository'])) {
            return $this->services['app_template.repository'];
        }
        $d = ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService());

        if (isset($this->services['app_template.repository'])) {
            return $this->services['app_template.repository'];
        }

        return $this->services['app_template.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Template\\TemplateDefinition'] ?? $this->getTemplateDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), $a, $b, $c, $d, ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'app_translation.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected function getAppTranslation_RepositoryService()
    {
        return $this->services['app_translation.repository'] = new \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository(($this->services['Shopware\\Core\\Framework\\App\\Aggregate\\AppTranslation\\AppTranslationDefinition'] ?? $this->getAppTranslationDefinitionService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Read\\EntityReaderInterface'] ?? $this->getEntityReaderInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\VersionManager'] ?? $this->getVersionManagerService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntitySearcherInterface'] ?? $this->getEntitySearcherInterfaceService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Search\\EntityAggregatorInterface'] ?? $this->getEntityAggregatorInterfaceService()), ($this->services['event_dispatcher'] ?? $this->getEventDispatcherService()), ($this->services['Shopware\\Core\\Framework\\DataAbstractionLayer\\Event\\EntityLoadedEventFactory'] ?? $this->getEntityLoadedEventFactoryService()));
    }

    /*
     * Gets the public 'cache.app' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\FilesystemAdapter
     */
    protected function getCache_AppService()
    {
        $this->services['cache.app'] = $instance = new \Symfony\Component\Cache\Adapter\FilesystemAdapter('Up4koPfX6f', 0, ($this->targetDir.''.'/pools/app'), ($this->privates['cache.default_marshaller'] ?? ($this->privates['cache.default_marshaller'] = new \Symfony\Component\Cache\Marshaller\DefaultMarshaller(NULL, false))));

        $instance->setLogger(($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService()));

        return $instance;
    }

    /*
     * Gets the public 'cache.app_clearer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer
     */
    protected function getCache_AppClearerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php';

        return $this->services['cache.app_clearer'] = new \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer(['cache.app' => ($this->services['cache.app'] ?? $this->getCache_AppService()), 'cache.messenger.restart_workers_signal' => ($this->privates['cache.messenger.restart_workers_signal'] ?? $this->getCache_Messenger_RestartWorkersSignalService()), 'cache.rate_limiter' => ($this->privates['cache.rate_limiter'] ?? $this->getCache_RateLimiterService()), 'cache.object' => ($this->privates['.cache.object.inner'] ?? $this->get_Cache_Object_InnerService()), 'cache.http' => ($this->privates['.cache.http.inner'] ?? $this->get_Cache_Http_InnerService()), 'cache.tags' => ($this->privates['cache.tags'] ?? $this->getCache_TagsService())]);
    }

    /*
     * Gets the public 'cache.global_clearer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer
     */
    protected function getCache_GlobalClearerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php';

        return $this->services['cache.global_clearer'] = new \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer(['cache.app' => ($this->services['cache.app'] ?? $this->getCache_AppService()), 'cache.system' => ($this->services['cache.system'] ?? $this->getCache_SystemService()), 'cache.validator' => ($this->privates['cache.validator'] ?? $this->getCache_ValidatorService()), 'cache.serializer' => ($this->privates['cache.serializer'] ?? $this->getCache_SerializerService()), 'cache.annotations' => ($this->privates['cache.annotations'] ?? $this->getCache_AnnotationsService()), 'cache.property_info' => ($this->privates['cache.property_info'] ?? $this->getCache_PropertyInfoService()), 'cache.messenger.restart_workers_signal' => ($this->privates['cache.messenger.restart_workers_signal'] ?? $this->getCache_Messenger_RestartWorkersSignalService()), 'cache.rate_limiter' => ($this->privates['cache.rate_limiter'] ?? $this->getCache_RateLimiterService()), 'cache.object' => ($this->privates['.cache.object.inner'] ?? $this->get_Cache_Object_InnerService()), 'cache.http' => ($this->privates['.cache.http.inner'] ?? $this->get_Cache_Http_InnerService()), 'cache.tags' => ($this->privates['cache.tags'] ?? $this->getCache_TagsService()), 'cache.property_access' => ($this->privates['cache.property_access'] ?? $this->getCache_PropertyAccessService()), 'cache.validator_expression_language' => ($this->services['cache.validator_expression_language'] ?? $this->getCache_ValidatorExpressionLanguageService())]);
    }

    /*
     * Gets the public 'cache.system' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected function getCache_SystemService()
    {
        return $this->services['cache.system'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('3cvuuC0DfN', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService()));
    }

    /*
     * Gets the public 'cache.system_clearer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer
     */
    protected function getCache_SystemClearerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php';

        return $this->services['cache.system_clearer'] = new \Symfony\Component\HttpKernel\CacheClearer\Psr6CacheClearer(['cache.system' => ($this->services['cache.system'] ?? $this->getCache_SystemService()), 'cache.validator' => ($this->privates['cache.validator'] ?? $this->getCache_ValidatorService()), 'cache.serializer' => ($this->privates['cache.serializer'] ?? $this->getCache_SerializerService()), 'cache.annotations' => ($this->privates['cache.annotations'] ?? $this->getCache_AnnotationsService()), 'cache.property_info' => ($this->privates['cache.property_info'] ?? $this->getCache_PropertyInfoService()), 'cache.property_access' => ($this->privates['cache.property_access'] ?? $this->getCache_PropertyAccessService()), 'cache.validator_expression_language' => ($this->services['cache.validator_expression_language'] ?? $this->getCache_ValidatorExpressionLanguageService())]);
    }

    /*
     * Gets the public 'cache.validator_expression_language' shared service.
     *
     * @return \Symfony\Component\Cache\Adapter\AdapterInterface
     */
    protected function getCache_ValidatorExpressionLanguageService()
    {
        return $this->services['cache.validator_expression_language'] = \Symfony\Component\Cache\Adapter\AbstractAdapter::createSystemCache('Fo6EFbVbAa', 0, $this->getParameter('container.build_id'), ($this->targetDir.''.'/pools/system'), ($this->privates['monolog.logger.cache'] ?? $this->getMonolog_Logger_CacheService()));
    }

    /*
     * Gets the public 'cache_warmer' shared service.
     *
     * @return \Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerAggregate
     */
    protected function getCacheWarmerService()
    {
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheWarmer/CacheWarmerInterface.php';
        include_once \dirname(__DIR__, 4).'/vendor/symfony/http-kernel/CacheWarmer/CacheWarmerAggregate.php';

        return $this->services['cache_warmer'] = new \Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerAggregate(new RewindableGenerator(function () {
            yield 0 => ($this->privates['config_builder.warmer'] ?? $this->getConfigBuilder_WarmerService());
            yield 1 => ($this->privates['translation.warmer'] ?? $this->getTranslation_WarmerService());
            yield 2 => ($this->privates['router.cache_warmer'] ?? $this->getRouter_CacheWarmerService());
            yield 3 => ($this->privates['annotations.cache_warmer'] ?? $this->getAnnotations_CacheWarmerService());
            yield 4 => ($this->privates['serializer.mapping.cache_warmer'] ?? $this->getSerializer_Mapping_CacheWarmerService());
            yield 5 => ($this->privates['validator.mapping.cache_warmer'] ?? $this->getValidator_Mapping_CacheWarmerService());
        }, 6), false, ($this->targetDir.''.'/Shopware_Core_KernelProdContainerDeprecations.log'));
    }

    /*
     * Gets the public 'category.repository' shared service.
     *
     * @return \Shopware\Core\Framework\DataAbstractionLayer\EntityRepository
     */
    protected fun